/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_ext_meter_fi message types

fi_tclMessageBase* midw_ext_meterfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_meterfi_tclToken::EN_MSG_SETHMIDISTANCEUNITMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMIDISTANCEUNITMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMIFUELCONSUMPTIONUNITMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMIFUELCONSUMPTIONUNITMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMITEMPERATUREUNITMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMITEMPERATUREUNITMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMIPRESSUREUNITMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETHMIPRESSUREUNITMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETREQUESTEDLANGUAGERESULTMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETREQUESTEDLANGUAGERESULTMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_GETMETERLANGUAGEMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_GETMETERLANGUAGEMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGESETTINGSREQUESTFROMLCNMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGESETTINGSREQUESTFROMLCNMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETLANGUAGESETTINGSFROMLCNMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETLANGUAGESETTINGSFROMLCNMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGEAVAILABILITYMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGEAVAILABILITYMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETMETERLANGUAGEMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETMETERLANGUAGEMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_GETAVAILABLESOURCELISTMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_GETAVAILABLESOURCELISTMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSOURCEINFOMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSOURCEINFOMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOWARNINGMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioWarningMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOWARNINGMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioWarningMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSPECIALMODEMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSPECIALMODEMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOENTERTAINMUTEMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOENTERTAINMUTEMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOEXTERNALMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioExternalMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOEXTERNALMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetAudioExternalMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVINAVSTATUSMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVINAVSTATUSMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIPOSITIONINFORMATIONMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIPOSITIONINFORMATIONMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDISTANCETODESTINATIONMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDISTANCETODESTINATIONMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVICURRENTSTREETMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVICURRENTSTREETMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVITURNTOSTREETMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVITURNTOSTREETMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTTURNTOSTREETMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTTURNTOSTREETMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIBARGRAPHINFOMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIBARGRAPHINFOMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERSYMBOLMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERSYMBOLMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIROUNDABOUTEXITNUMBERMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIROUNDABOUTEXITNUMBERMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDEFORMEDIMAGEMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDEFORMEDIMAGEMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERVIEWMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERVIEWMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVILANERECOMMENDATIONLISTMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVILANERECOMMENDATIONLISTMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVISPEEDLIMITMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVISPEEDLIMITMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTMANEUVERDETAILSMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTMANEUVERDETAILSMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIARRIVALINFORMATIONLISTMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIARRIVALINFORMATIONLISTMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPCARSORPOSITIONMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPCARSORPOSITIONMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSXMTABWEATHERMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSXMTABWEATHERMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONSTATUSINFOMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONSTATUSINFOMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDATAMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDATAMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDISTANCEDATAMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDISTANCEDATAMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGCALLINFOMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGCALLINFOMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGSMSINFOMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGSMSINFOMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETVOICERECOGNITIONSTATUSMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETVOICERECOGNITIONSTATUSMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETPOWERONKEEPMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETPOWERONKEEPMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_SETTIMEINFOMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetTimeInfoMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_SETTIMEINFOMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetTimeInfoMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
         return OSAL_NEW midw_ext_meterfi_tclMsgResetHistoryMethodStart;

      case midw_ext_meterfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
         return OSAL_NEW midw_ext_meterfi_tclMsgResetHistoryMethodResult;

      case midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgConnectionUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgConnectionRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgConnectionGet;

      case midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgConnectionStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgConfigurationUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgConfigurationRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgConfigurationGet;

      case midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgConfigurationStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgHardwareVersionUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgHardwareVersionRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgHardwareVersionGet;

      case midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgHardwareVersionStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSoftwareVersionUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgSoftwareVersionGet;

      case midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgSoftwareVersionStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgDataTransmissionUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgDataTransmissionRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgDataTransmissionGet;

      case midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgDataTransmissionStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgCurrentMeterSettingsGet;

      case midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailablePressureUnitsGet;

      case midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPressureUnitGet;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPressureUnitStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODEUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODERELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODEGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgSupportedLangSyncModeGet;

      case midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODESTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGEUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedLanguageUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGERELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGEGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedLanguageGet;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGESTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedLanguageStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgLanguageSettingsStatusGet;

      case midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet;

      case midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPEUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviSwipeUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPERELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPESET:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviSwipeSet;

      case midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPESTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgSetNaviSwipeStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_KEYEVENTUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgKeyEventUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_KEYEVENTRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgKeyEventRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_KEYEVENTSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgKeyEventStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPHONECALLMENUACTIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPHONECALLMENUACTIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPHONECALLMENUACTIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDSMSMENUACTIONUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDSMSMENUACTIONRELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDSMSMENUACTIONSTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus;

      case midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATEUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgVehiclePowerStateUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATERELUPREG:
         return OSAL_NEW midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg;

      case midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATEGET:
         return OSAL_NEW midw_ext_meterfi_tclMsgVehiclePowerStateGet;

      case midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATESTATUS:
         return OSAL_NEW midw_ext_meterfi_tclMsgVehiclePowerStateStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_meterfifi messages

// common functions

tU16 midw_ext_meterfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_METERFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_meterfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_meterfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_meterfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_meterfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_meterfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_meterfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8DistanceUnit = coRef.e8DistanceUnit;
}
midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::operator=(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8DistanceUnit = coRef.e8DistanceUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart()
:e8DistanceUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMIDISTANCEUNITMETHODSTART;
}


midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::~midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DistanceUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DistanceUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart::operator==(const midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DistanceUnit == roRef.e8DistanceUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult::midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMIDISTANCEUNITMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult::~midw_ext_meterfi_tclMsgSetHMIDistanceUnitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8FuelConsumptionUnit = coRef.e8FuelConsumptionUnit;
}
midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::operator=(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8FuelConsumptionUnit = coRef.e8FuelConsumptionUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart()
:e8FuelConsumptionUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMIFUELCONSUMPTIONUNITMETHODSTART;
}


midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::~midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FuelConsumptionUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FuelConsumptionUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart::operator==(const midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FuelConsumptionUnit == roRef.e8FuelConsumptionUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult::midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMIFUELCONSUMPTIONUNITMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult::~midw_ext_meterfi_tclMsgSetHMIFuelConsumptionUnitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8TemperatureUnit = coRef.e8TemperatureUnit;
}
midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::operator=(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8TemperatureUnit = coRef.e8TemperatureUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart()
:e8TemperatureUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMITEMPERATUREUNITMETHODSTART;
}


midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::~midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TemperatureUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TemperatureUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart::operator==(const midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TemperatureUnit == roRef.e8TemperatureUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult::midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMITEMPERATUREUNITMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult::~midw_ext_meterfi_tclMsgSetHMITemperatureUnitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8PressureUnit = coRef.e8PressureUnit;
}
midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::operator=(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PressureUnit = coRef.e8PressureUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart()
:e8PressureUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMIPRESSUREUNITMETHODSTART;
}


midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::~midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PressureUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PressureUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart::operator==(const midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PressureUnit == roRef.e8PressureUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult::midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETHMIPRESSUREUNITMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult::~midw_ext_meterfi_tclMsgSetHMIPressureUnitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Resultoneway = coRef.e8Resultoneway;
   e8Resulttwoway = coRef.e8Resulttwoway;
}
midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::operator=(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Resultoneway = coRef.e8Resultoneway;
   e8Resulttwoway = coRef.e8Resulttwoway;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart()
:e8Resultoneway()
,e8Resulttwoway()
 {}

tS32 midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETREQUESTEDLANGUAGERESULTMETHODSTART;
}


midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::~midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Resultoneway);
   (tVoid) (oIn >> e8Resulttwoway);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Resultoneway);
   (tVoid) (oOut << e8Resulttwoway);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart::operator==(const midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Resultoneway == roRef.e8Resultoneway);
   bResult = bResult && (e8Resulttwoway == roRef.e8Resulttwoway);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult::midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETREQUESTEDLANGUAGERESULTMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult::~midw_ext_meterfi_tclMsgSetRequestedLanguageResultMethodResult()
{}

//=============================================================================

midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart::midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart()
 {}

tS32 midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETMETERLANGUAGEMETHODSTART;
}


midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart::~midw_ext_meterfi_tclMsgGetMeterLanguageMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::operator=(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult()
:e8Language()
 {}

tS32 midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETMETERLANGUAGEMETHODRESULT;
}


midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::~midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult()
{}

tU32 midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult::operator==(const midw_ext_meterfi_tclMsgGetMeterLanguageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart::midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart()
 {}

tS32 midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGESETTINGSREQUESTFROMLCNMETHODSTART;
}


midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart::~midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8DefaultLanguage = coRef.e8DefaultLanguage;
   e8CurrentLanguage = coRef.e8CurrentLanguage;
   e8LanguageAvailable_Byte_1 = coRef.e8LanguageAvailable_Byte_1;
   e8LanguageAvailable_Byte_2 = coRef.e8LanguageAvailable_Byte_2;
   e8LanguageAvailable_Byte_3 = coRef.e8LanguageAvailable_Byte_3;
}
midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::operator=(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DefaultLanguage = coRef.e8DefaultLanguage;
   e8CurrentLanguage = coRef.e8CurrentLanguage;
   e8LanguageAvailable_Byte_1 = coRef.e8LanguageAvailable_Byte_1;
   e8LanguageAvailable_Byte_2 = coRef.e8LanguageAvailable_Byte_2;
   e8LanguageAvailable_Byte_3 = coRef.e8LanguageAvailable_Byte_3;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult()
:e8DefaultLanguage()
,e8CurrentLanguage()
,e8LanguageAvailable_Byte_1(0)
,e8LanguageAvailable_Byte_2(0)
,e8LanguageAvailable_Byte_3(0)
 {}

tS32 midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGESETTINGSREQUESTFROMLCNMETHODRESULT;
}


midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::~midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult()
{}

tU32 midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DefaultLanguage);
   (tVoid) (oIn >> e8CurrentLanguage);
   (tVoid) (oIn >> e8LanguageAvailable_Byte_1);
   (tVoid) (oIn >> e8LanguageAvailable_Byte_2);
   (tVoid) (oIn >> e8LanguageAvailable_Byte_3);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DefaultLanguage);
   (tVoid) (oOut << e8CurrentLanguage);
   (tVoid) (oOut << e8LanguageAvailable_Byte_1);
   (tVoid) (oOut << e8LanguageAvailable_Byte_2);
   (tVoid) (oOut << e8LanguageAvailable_Byte_3);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult::operator==(const midw_ext_meterfi_tclMsgGetLanguageSettingsRequestfromLCNMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DefaultLanguage == roRef.e8DefaultLanguage);
   bResult = bResult && (e8CurrentLanguage == roRef.e8CurrentLanguage);
   bResult = bResult && (e8LanguageAvailable_Byte_1 == roRef.e8LanguageAvailable_Byte_1);
   bResult = bResult && (e8LanguageAvailable_Byte_2 == roRef.e8LanguageAvailable_Byte_2);
   bResult = bResult && (e8LanguageAvailable_Byte_3 == roRef.e8LanguageAvailable_Byte_3);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::operator=(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart()
:e8Language()
 {}

tS32 midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETLANGUAGESETTINGSFROMLCNMETHODSTART;
}


midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::~midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart::operator==(const midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult::midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETLANGUAGESETTINGSFROMLCNMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult::~midw_ext_meterfi_tclMsgSetLanguageSettingsfromLCNMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::operator=(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart()
:e8Language()
 {}

tS32 midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGEAVAILABILITYMETHODSTART;
}


midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::~midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart::operator==(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8LanguageStatus = coRef.e8LanguageStatus;
}
midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::operator=(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8LanguageStatus = coRef.e8LanguageStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult()
:e8LanguageStatus()
 {}

tS32 midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETLANGUAGEAVAILABILITYMETHODRESULT;
}


midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::~midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult()
{}

tU32 midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LanguageStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LanguageStatus);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult::operator==(const midw_ext_meterfi_tclMsgGetLanguageAvailabilityMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LanguageStatus == roRef.e8LanguageStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::operator=(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart()
:e8Language()
 {}

tS32 midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETMETERLANGUAGEMETHODSTART;
}


midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::~midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart::operator==(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8LanguageStatus = coRef.e8LanguageStatus;
}
midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::operator=(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8LanguageStatus = coRef.e8LanguageStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult()
:e8LanguageStatus()
 {}

tS32 midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETMETERLANGUAGEMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::~midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult()
{}

tU32 midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LanguageStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LanguageStatus);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult::operator==(const midw_ext_meterfi_tclMsgSetMeterLanguageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LanguageStatus == roRef.e8LanguageStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   u32SourceListLowByte = coRef.u32SourceListLowByte;
   u32SourceListHighByte = coRef.u32SourceListHighByte;
   u32SourceListGen2Byte = coRef.u32SourceListGen2Byte;
}
midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::operator=(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32SourceListLowByte = coRef.u32SourceListLowByte;
   u32SourceListHighByte = coRef.u32SourceListHighByte;
   u32SourceListGen2Byte = coRef.u32SourceListGen2Byte;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart()
:u32SourceListLowByte(0)
,u32SourceListHighByte(0)
,u32SourceListGen2Byte(0)
 {}

tS32 midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETAVAILABLESOURCELISTMETHODSTART;
}


midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::~midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32SourceListLowByte);
   (tVoid) (oIn >> u32SourceListHighByte);
   (tVoid) (oIn >> u32SourceListGen2Byte);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32SourceListLowByte);
   (tVoid) (oOut << u32SourceListHighByte);
   (tVoid) (oOut << u32SourceListGen2Byte);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart::operator==(const midw_ext_meterfi_tclMsgGetAvailableSourceListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32SourceListLowByte == roRef.u32SourceListLowByte);
   bResult = bResult && (u32SourceListHighByte == roRef.u32SourceListHighByte);
   bResult = bResult && (u32SourceListGen2Byte == roRef.u32SourceListGen2Byte);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult::midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_GETAVAILABLESOURCELISTMETHODRESULT;
}


midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult::~midw_ext_meterfi_tclMsgGetAvailableSourceListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bCausedByUser = coRef.bCausedByUser;
   SourceInfo = coRef.SourceInfo;
}
midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::operator=(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bCausedByUser = coRef.bCausedByUser;
   SourceInfo = coRef.SourceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::vDestroy()
{
   SourceInfo.vDestroy(); 
}

midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart()
:bCausedByUser(0)
,SourceInfo()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSOURCEINFOMETHODSTART;
}


midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::~midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+SourceInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bCausedByUser);
   (tVoid) (oIn >> SourceInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bCausedByUser);
   (tVoid) (oOut << SourceInfo);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart::operator==(const midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bCausedByUser == roRef.bCausedByUser);
   bResult = bResult && (SourceInfo == roRef.SourceInfo);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult::midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSOURCEINFOMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult::~midw_ext_meterfi_tclMsgSetAudioSourceInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::midw_ext_meterfi_tclMsgSetAudioWarningMethodStart(const midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bCausedByUser = coRef.bCausedByUser;
   e8WarningSource = coRef.e8WarningSource;
   e8WarningState = coRef.e8WarningState;
   strWarningText = coRef.strWarningText;
}
midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::operator=(const midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bCausedByUser = coRef.bCausedByUser;
   e8WarningSource = coRef.e8WarningSource;
   e8WarningState = coRef.e8WarningState;
   strWarningText = coRef.strWarningText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::vDestroy()
{
   strWarningText.vDestroy();
}

midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::midw_ext_meterfi_tclMsgSetAudioWarningMethodStart()
:bCausedByUser(0)
,e8WarningSource()
,e8WarningState()
,strWarningText()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOWARNINGMETHODSTART;
}


midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::~midw_ext_meterfi_tclMsgSetAudioWarningMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+strWarningText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bCausedByUser);
   (tVoid) (oIn >> e8WarningSource);
   (tVoid) (oIn >> e8WarningState);
   (tVoid) (oIn >> strWarningText);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bCausedByUser);
   (tVoid) (oOut << e8WarningSource);
   (tVoid) (oOut << e8WarningState);
   (tVoid) (oOut << strWarningText);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetAudioWarningMethodStart::operator==(const midw_ext_meterfi_tclMsgSetAudioWarningMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bCausedByUser == roRef.bCausedByUser);
   bResult = bResult && (e8WarningSource == roRef.e8WarningSource);
   bResult = bResult && (e8WarningState == roRef.e8WarningState);
   bResult = bResult && (strWarningText == roRef.strWarningText);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetAudioWarningMethodResult::midw_ext_meterfi_tclMsgSetAudioWarningMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioWarningMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOWARNINGMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetAudioWarningMethodResult::~midw_ext_meterfi_tclMsgSetAudioWarningMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8SpecialMode = coRef.e8SpecialMode;
   bSpecialModeInterrupt = coRef.bSpecialModeInterrupt;
}
midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::operator=(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SpecialMode = coRef.e8SpecialMode;
   bSpecialModeInterrupt = coRef.bSpecialModeInterrupt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart()
:e8SpecialMode()
,bSpecialModeInterrupt(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSPECIALMODEMETHODSTART;
}


midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::~midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SpecialMode);
   (tVoid) (oIn >> bSpecialModeInterrupt);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SpecialMode);
   (tVoid) (oOut << bSpecialModeInterrupt);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart::operator==(const midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SpecialMode == roRef.e8SpecialMode);
   bResult = bResult && (bSpecialModeInterrupt == roRef.bSpecialModeInterrupt);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult::midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOSPECIALMODEMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult::~midw_ext_meterfi_tclMsgSetAudioSpecialModeMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bMute = coRef.bMute;
}
midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::operator=(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bMute = coRef.bMute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart()
:bMute(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOENTERTAINMUTEMETHODSTART;
}


midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::~midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMute);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMute);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart::operator==(const midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMute == roRef.bMute);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult::midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOENTERTAINMUTEMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult::~midw_ext_meterfi_tclMsgSetAudioEntertainMuteMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::midw_ext_meterfi_tclMsgSetAudioExternalMethodStart(const midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bExternalAudio = coRef.bExternalAudio;
}
midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::operator=(const midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bExternalAudio = coRef.bExternalAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::midw_ext_meterfi_tclMsgSetAudioExternalMethodStart()
:bExternalAudio(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOEXTERNALMETHODSTART;
}


midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::~midw_ext_meterfi_tclMsgSetAudioExternalMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bExternalAudio);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bExternalAudio);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetAudioExternalMethodStart::operator==(const midw_ext_meterfi_tclMsgSetAudioExternalMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bExternalAudio == roRef.bExternalAudio);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetAudioExternalMethodResult::midw_ext_meterfi_tclMsgSetAudioExternalMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetAudioExternalMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETAUDIOEXTERNALMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetAudioExternalMethodResult::~midw_ext_meterfi_tclMsgSetAudioExternalMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8NavStatus = coRef.e8NavStatus;
}
midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8NavStatus = coRef.e8NavStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart()
:e8NavStatus()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVINAVSTATUSMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::~midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8NavStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8NavStatus);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviNavStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8NavStatus == roRef.e8NavStatus);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult::midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVINAVSTATUSMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult::~midw_ext_meterfi_tclMsgSetNaviNavStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   strPositionInformationCountryCode = coRef.strPositionInformationCountryCode;
   e8PositionInformationRoadClass = coRef.e8PositionInformationRoadClass;
   f32PositionInformationVehicleSpeed = coRef.f32PositionInformationVehicleSpeed;
   f32PositionInformationVehicleHeading = coRef.f32PositionInformationVehicleHeading;
}
midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strPositionInformationCountryCode = coRef.strPositionInformationCountryCode;
   e8PositionInformationRoadClass = coRef.e8PositionInformationRoadClass;
   f32PositionInformationVehicleSpeed = coRef.f32PositionInformationVehicleSpeed;
   f32PositionInformationVehicleHeading = coRef.f32PositionInformationVehicleHeading;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::vDestroy()
{
   strPositionInformationCountryCode.vDestroy();
}

midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart()
:strPositionInformationCountryCode()
,e8PositionInformationRoadClass()
,f32PositionInformationVehicleSpeed(0)
,f32PositionInformationVehicleHeading(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIPOSITIONINFORMATIONMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::~midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+strPositionInformationCountryCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strPositionInformationCountryCode);
   (tVoid) (oIn >> e8PositionInformationRoadClass);
   (tVoid) (oIn >> f32PositionInformationVehicleSpeed);
   (tVoid) (oIn >> f32PositionInformationVehicleHeading);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strPositionInformationCountryCode);
   (tVoid) (oOut << e8PositionInformationRoadClass);
   (tVoid) (oOut << f32PositionInformationVehicleSpeed);
   (tVoid) (oOut << f32PositionInformationVehicleHeading);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strPositionInformationCountryCode == roRef.strPositionInformationCountryCode);
   bResult = bResult && (e8PositionInformationRoadClass == roRef.e8PositionInformationRoadClass);
   bResult = bResult && (f32PositionInformationVehicleSpeed == roRef.f32PositionInformationVehicleSpeed);
   bResult = bResult && (f32PositionInformationVehicleHeading == roRef.f32PositionInformationVehicleHeading);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult::midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIPOSITIONINFORMATIONMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult::~midw_ext_meterfi_tclMsgSetNaviPositionInformationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   u32DistanceToDestinationDistanceToDestination = coRef.u32DistanceToDestinationDistanceToDestination;
   e8DistanceToDestinationUnit = coRef.e8DistanceToDestinationUnit;
}
midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32DistanceToDestinationDistanceToDestination = coRef.u32DistanceToDestinationDistanceToDestination;
   e8DistanceToDestinationUnit = coRef.e8DistanceToDestinationUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart()
:u32DistanceToDestinationDistanceToDestination(0)
,e8DistanceToDestinationUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDISTANCETODESTINATIONMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::~midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DistanceToDestinationDistanceToDestination);
   (tVoid) (oIn >> e8DistanceToDestinationUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DistanceToDestinationDistanceToDestination);
   (tVoid) (oOut << e8DistanceToDestinationUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DistanceToDestinationDistanceToDestination == roRef.u32DistanceToDestinationDistanceToDestination);
   bResult = bResult && (e8DistanceToDestinationUnit == roRef.e8DistanceToDestinationUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult::midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDISTANCETODESTINATIONMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult::~midw_ext_meterfi_tclMsgSetNaviDistanceToDestinationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   strCurrentStreet = coRef.strCurrentStreet;
}
midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strCurrentStreet = coRef.strCurrentStreet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::vDestroy()
{
   strCurrentStreet.vDestroy();
}

midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart()
:strCurrentStreet()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVICURRENTSTREETMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::~midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strCurrentStreet.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strCurrentStreet);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strCurrentStreet);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strCurrentStreet == roRef.strCurrentStreet);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult::midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVICURRENTSTREETMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult::~midw_ext_meterfi_tclMsgSetNaviCurrentStreetMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   strTurntoStreet = coRef.strTurntoStreet;
}
midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strTurntoStreet = coRef.strTurntoStreet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::vDestroy()
{
   strTurntoStreet.vDestroy();
}

midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart()
:strTurntoStreet()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVITURNTOSTREETMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::~midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strTurntoStreet.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strTurntoStreet);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strTurntoStreet);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strTurntoStreet == roRef.strTurntoStreet);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult::midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVITURNTOSTREETMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult::~midw_ext_meterfi_tclMsgSetNaviTurntoStreetMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   strNextTurntoStreet = coRef.strNextTurntoStreet;
}
midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strNextTurntoStreet = coRef.strNextTurntoStreet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::vDestroy()
{
   strNextTurntoStreet.vDestroy();
}

midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart()
:strNextTurntoStreet()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTTURNTOSTREETMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::~midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strNextTurntoStreet.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strNextTurntoStreet);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strNextTurntoStreet);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strNextTurntoStreet == roRef.strNextTurntoStreet);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult::midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTTURNTOSTREETMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult::~midw_ext_meterfi_tclMsgSetNaviNextTurntoStreetMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bBarGraphInfoValid = coRef.bBarGraphInfoValid;
   u16BarGraphInfoValue = coRef.u16BarGraphInfoValue;
   u16BarGraphInfoScale = coRef.u16BarGraphInfoScale;
   e8BarGraphInfoUnit = coRef.e8BarGraphInfoUnit;
}
midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bBarGraphInfoValid = coRef.bBarGraphInfoValid;
   u16BarGraphInfoValue = coRef.u16BarGraphInfoValue;
   u16BarGraphInfoScale = coRef.u16BarGraphInfoScale;
   e8BarGraphInfoUnit = coRef.e8BarGraphInfoUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart()
:bBarGraphInfoValid(0)
,u16BarGraphInfoValue(0)
,u16BarGraphInfoScale(0)
,e8BarGraphInfoUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIBARGRAPHINFOMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::~midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBarGraphInfoValid);
   (tVoid) (oIn >> u16BarGraphInfoValue);
   (tVoid) (oIn >> u16BarGraphInfoScale);
   (tVoid) (oIn >> e8BarGraphInfoUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBarGraphInfoValid);
   (tVoid) (oOut << u16BarGraphInfoValue);
   (tVoid) (oOut << u16BarGraphInfoScale);
   (tVoid) (oOut << e8BarGraphInfoUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBarGraphInfoValid == roRef.bBarGraphInfoValid);
   bResult = bResult && (u16BarGraphInfoValue == roRef.u16BarGraphInfoValue);
   bResult = bResult && (u16BarGraphInfoScale == roRef.u16BarGraphInfoScale);
   bResult = bResult && (e8BarGraphInfoUnit == roRef.e8BarGraphInfoUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult::midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIBARGRAPHINFOMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult::~midw_ext_meterfi_tclMsgSetNaviBarGraphInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8ManeuverSymbol = coRef.e8ManeuverSymbol;
}
midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ManeuverSymbol = coRef.e8ManeuverSymbol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart()
:e8ManeuverSymbol()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERSYMBOLMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::~midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ManeuverSymbol);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ManeuverSymbol);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ManeuverSymbol == roRef.e8ManeuverSymbol);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult::midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERSYMBOLMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult::~midw_ext_meterfi_tclMsgSetNaviManeuverSymbolMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   u16RoundaboutExitNumber = coRef.u16RoundaboutExitNumber;
}
midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16RoundaboutExitNumber = coRef.u16RoundaboutExitNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart()
:u16RoundaboutExitNumber(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIROUNDABOUTEXITNUMBERMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::~midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RoundaboutExitNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RoundaboutExitNumber);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16RoundaboutExitNumber == roRef.u16RoundaboutExitNumber);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult::midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIROUNDABOUTEXITNUMBERMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult::~midw_ext_meterfi_tclMsgSetNaviRoundaboutExitNumberMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bDeformedImageValid = coRef.bDeformedImageValid;
   e8DeformedImageDeformedImageRoad = coRef.e8DeformedImageDeformedImageRoad;
   e8DeformedImageDeformedImageArrow = coRef.e8DeformedImageDeformedImageArrow;
}
midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bDeformedImageValid = coRef.bDeformedImageValid;
   e8DeformedImageDeformedImageRoad = coRef.e8DeformedImageDeformedImageRoad;
   e8DeformedImageDeformedImageArrow = coRef.e8DeformedImageDeformedImageArrow;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart()
:bDeformedImageValid(0)
,e8DeformedImageDeformedImageRoad()
,e8DeformedImageDeformedImageArrow()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDEFORMEDIMAGEMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::~midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDeformedImageValid);
   (tVoid) (oIn >> e8DeformedImageDeformedImageRoad);
   (tVoid) (oIn >> e8DeformedImageDeformedImageArrow);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDeformedImageValid);
   (tVoid) (oOut << e8DeformedImageDeformedImageRoad);
   (tVoid) (oOut << e8DeformedImageDeformedImageArrow);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDeformedImageValid == roRef.bDeformedImageValid);
   bResult = bResult && (e8DeformedImageDeformedImageRoad == roRef.e8DeformedImageDeformedImageRoad);
   bResult = bResult && (e8DeformedImageDeformedImageArrow == roRef.e8DeformedImageDeformedImageArrow);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult::midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIDEFORMEDIMAGEMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult::~midw_ext_meterfi_tclMsgSetNaviDeformedImageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8ManeuverViewManeuverView = coRef.e8ManeuverViewManeuverView;
   bManeuverViewDeformedImageValid = coRef.bManeuverViewDeformedImageValid;
   e8ManeuverViewDeformedImageDeformedImageRoad = coRef.e8ManeuverViewDeformedImageDeformedImageRoad;
   e8ManeuverViewDeformedImageDeformedImageArrow = coRef.e8ManeuverViewDeformedImageDeformedImageArrow;
   u32ManeuverViewIntersectionMapId = coRef.u32ManeuverViewIntersectionMapId;
}
midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ManeuverViewManeuverView = coRef.e8ManeuverViewManeuverView;
   bManeuverViewDeformedImageValid = coRef.bManeuverViewDeformedImageValid;
   e8ManeuverViewDeformedImageDeformedImageRoad = coRef.e8ManeuverViewDeformedImageDeformedImageRoad;
   e8ManeuverViewDeformedImageDeformedImageArrow = coRef.e8ManeuverViewDeformedImageDeformedImageArrow;
   u32ManeuverViewIntersectionMapId = coRef.u32ManeuverViewIntersectionMapId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart()
:e8ManeuverViewManeuverView()
,bManeuverViewDeformedImageValid(0)
,e8ManeuverViewDeformedImageDeformedImageRoad()
,e8ManeuverViewDeformedImageDeformedImageArrow()
,u32ManeuverViewIntersectionMapId(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERVIEWMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::~midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ManeuverViewManeuverView);
   (tVoid) (oIn >> bManeuverViewDeformedImageValid);
   (tVoid) (oIn >> e8ManeuverViewDeformedImageDeformedImageRoad);
   (tVoid) (oIn >> e8ManeuverViewDeformedImageDeformedImageArrow);
   (tVoid) (oIn >> u32ManeuverViewIntersectionMapId);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ManeuverViewManeuverView);
   (tVoid) (oOut << bManeuverViewDeformedImageValid);
   (tVoid) (oOut << e8ManeuverViewDeformedImageDeformedImageRoad);
   (tVoid) (oOut << e8ManeuverViewDeformedImageDeformedImageArrow);
   (tVoid) (oOut << u32ManeuverViewIntersectionMapId);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ManeuverViewManeuverView == roRef.e8ManeuverViewManeuverView);
   bResult = bResult && (bManeuverViewDeformedImageValid == roRef.bManeuverViewDeformedImageValid);
   bResult = bResult && (e8ManeuverViewDeformedImageDeformedImageRoad == roRef.e8ManeuverViewDeformedImageDeformedImageRoad);
   bResult = bResult && (e8ManeuverViewDeformedImageDeformedImageArrow == roRef.e8ManeuverViewDeformedImageDeformedImageArrow);
   bResult = bResult && (u32ManeuverViewIntersectionMapId == roRef.u32ManeuverViewIntersectionMapId);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult::midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIMANEUVERVIEWMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult::~midw_ext_meterfi_tclMsgSetNaviManeuverViewMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   tLaneRecommendationList = coRef.tLaneRecommendationList;
}
midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tLaneRecommendationList = coRef.tLaneRecommendationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tLaneRecommendationList.size(); ++u32Idx)
         tLaneRecommendationList[u32Idx].vDestroy();
   tLaneRecommendationList.clear();
   }
}

midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart()

 {}

tS32 midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVILANERECOMMENDATIONLISTMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::~midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tLaneRecommendationList.size()*9);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tLaneRecommendationList.size(); ++u32Idx)
      {
         tLaneRecommendationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tLaneRecommendationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tLaneRecommendationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tLaneRecommendationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tLaneRecommendationList.size(); ++u32Idx)
         (tVoid) (oOut << tLaneRecommendationList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tLaneRecommendationList.size() == roRef.tLaneRecommendationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tLaneRecommendationList.size()); ++u32Idx)
            bResult = bResult && (tLaneRecommendationList[u32Idx] == roRef.tLaneRecommendationList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult::midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVILANERECOMMENDATIONLISTMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult::~midw_ext_meterfi_tclMsgSetNaviLaneRecommendationListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bSpeedLimitPresent = coRef.bSpeedLimitPresent;
   strSpeedLimitCountryCode = coRef.strSpeedLimitCountryCode;
   u16SpeedLimitValue = coRef.u16SpeedLimitValue;
   e8SpeedLimitSpeedUnit = coRef.e8SpeedLimitSpeedUnit;
}
midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bSpeedLimitPresent = coRef.bSpeedLimitPresent;
   strSpeedLimitCountryCode = coRef.strSpeedLimitCountryCode;
   u16SpeedLimitValue = coRef.u16SpeedLimitValue;
   e8SpeedLimitSpeedUnit = coRef.e8SpeedLimitSpeedUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::vDestroy()
{
   strSpeedLimitCountryCode.vDestroy();
}

midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart()
:bSpeedLimitPresent(0)
,strSpeedLimitCountryCode()
,u16SpeedLimitValue(0)
,e8SpeedLimitSpeedUnit()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVISPEEDLIMITMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::~midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strSpeedLimitCountryCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSpeedLimitPresent);
   (tVoid) (oIn >> strSpeedLimitCountryCode);
   (tVoid) (oIn >> u16SpeedLimitValue);
   (tVoid) (oIn >> e8SpeedLimitSpeedUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSpeedLimitPresent);
   (tVoid) (oOut << strSpeedLimitCountryCode);
   (tVoid) (oOut << u16SpeedLimitValue);
   (tVoid) (oOut << e8SpeedLimitSpeedUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSpeedLimitPresent == roRef.bSpeedLimitPresent);
   bResult = bResult && (strSpeedLimitCountryCode == roRef.strSpeedLimitCountryCode);
   bResult = bResult && (u16SpeedLimitValue == roRef.u16SpeedLimitValue);
   bResult = bResult && (e8SpeedLimitSpeedUnit == roRef.e8SpeedLimitSpeedUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult::midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVISPEEDLIMITMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult::~midw_ext_meterfi_tclMsgSetNaviSpeedLimitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   strNextManeuverDetailsDistanceToManeuver = coRef.strNextManeuverDetailsDistanceToManeuver;
   e8NextManeuverDetailsDistanceToManeuverUnit = coRef.e8NextManeuverDetailsDistanceToManeuverUnit;
   e8NextManeuverDetailsRecommendationType = coRef.e8NextManeuverDetailsRecommendationType;
   bNextManeuverDetailsIsNewManeuver = coRef.bNextManeuverDetailsIsNewManeuver;
   bNextManeuverDetailsIsReRouted = coRef.bNextManeuverDetailsIsReRouted;
}
midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strNextManeuverDetailsDistanceToManeuver = coRef.strNextManeuverDetailsDistanceToManeuver;
   e8NextManeuverDetailsDistanceToManeuverUnit = coRef.e8NextManeuverDetailsDistanceToManeuverUnit;
   e8NextManeuverDetailsRecommendationType = coRef.e8NextManeuverDetailsRecommendationType;
   bNextManeuverDetailsIsNewManeuver = coRef.bNextManeuverDetailsIsNewManeuver;
   bNextManeuverDetailsIsReRouted = coRef.bNextManeuverDetailsIsReRouted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::vDestroy()
{
   strNextManeuverDetailsDistanceToManeuver.vDestroy();
}

midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart()
:strNextManeuverDetailsDistanceToManeuver()
,e8NextManeuverDetailsDistanceToManeuverUnit()
,e8NextManeuverDetailsRecommendationType()
,bNextManeuverDetailsIsNewManeuver(0)
,bNextManeuverDetailsIsReRouted(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTMANEUVERDETAILSMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::~midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strNextManeuverDetailsDistanceToManeuver.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strNextManeuverDetailsDistanceToManeuver);
   (tVoid) (oIn >> e8NextManeuverDetailsDistanceToManeuverUnit);
   (tVoid) (oIn >> e8NextManeuverDetailsRecommendationType);
   (tVoid) (oIn >> bNextManeuverDetailsIsNewManeuver);
   (tVoid) (oIn >> bNextManeuverDetailsIsReRouted);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strNextManeuverDetailsDistanceToManeuver);
   (tVoid) (oOut << e8NextManeuverDetailsDistanceToManeuverUnit);
   (tVoid) (oOut << e8NextManeuverDetailsRecommendationType);
   (tVoid) (oOut << bNextManeuverDetailsIsNewManeuver);
   (tVoid) (oOut << bNextManeuverDetailsIsReRouted);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strNextManeuverDetailsDistanceToManeuver == roRef.strNextManeuverDetailsDistanceToManeuver);
   bResult = bResult && (e8NextManeuverDetailsDistanceToManeuverUnit == roRef.e8NextManeuverDetailsDistanceToManeuverUnit);
   bResult = bResult && (e8NextManeuverDetailsRecommendationType == roRef.e8NextManeuverDetailsRecommendationType);
   bResult = bResult && (bNextManeuverDetailsIsNewManeuver == roRef.bNextManeuverDetailsIsNewManeuver);
   bResult = bResult && (bNextManeuverDetailsIsReRouted == roRef.bNextManeuverDetailsIsReRouted);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult::midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVINEXTMANEUVERDETAILSMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult::~midw_ext_meterfi_tclMsgSetNaviNextManeuverDetailsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   tArrivalInformation = coRef.tArrivalInformation;
}
midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tArrivalInformation = coRef.tArrivalInformation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tArrivalInformation.size(); ++u32Idx)
         tArrivalInformation[u32Idx].vDestroy();
   tArrivalInformation.clear();
   }
}

midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart()

 {}

tS32 midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIARRIVALINFORMATIONLISTMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::~midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tArrivalInformation.size(); ++u32ListIdx)
      u32DynamicSize += tArrivalInformation[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tArrivalInformation.size(); ++u32Idx)
      {
         tArrivalInformation[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tArrivalInformation.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tArrivalInformation[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tArrivalInformation.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tArrivalInformation.size(); ++u32Idx)
         (tVoid) (oOut << tArrivalInformation[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tArrivalInformation.size() == roRef.tArrivalInformation.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tArrivalInformation.size()); ++u32Idx)
            bResult = bResult && (tArrivalInformation[u32Idx] == roRef.tArrivalInformation[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult::midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIARRIVALINFORMATIONLISTMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult::~midw_ext_meterfi_tclMsgSetNaviArrivalInformationListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   tIntersectionMapRoadLineRoadList = coRef.tIntersectionMapRoadLineRoadList;
   tIntersectionMapRoadLineRouteList = coRef.tIntersectionMapRoadLineRouteList;
   tIntersectionMapNoEntryIconsList = coRef.tIntersectionMapNoEntryIconsList;
   u8IntersectionMapIntersectionNumber = coRef.u8IntersectionMapIntersectionNumber;
}
midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tIntersectionMapRoadLineRoadList = coRef.tIntersectionMapRoadLineRoadList;
   tIntersectionMapRoadLineRouteList = coRef.tIntersectionMapRoadLineRouteList;
   tIntersectionMapNoEntryIconsList = coRef.tIntersectionMapNoEntryIconsList;
   u8IntersectionMapIntersectionNumber = coRef.u8IntersectionMapIntersectionNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapRoadLineRoadList.size(); ++u32Idx)
         tIntersectionMapRoadLineRoadList[u32Idx].vDestroy();
   tIntersectionMapRoadLineRoadList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapRoadLineRouteList.size(); ++u32Idx)
         tIntersectionMapRoadLineRouteList[u32Idx].vDestroy();
   tIntersectionMapRoadLineRouteList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapNoEntryIconsList.size(); ++u32Idx)
         tIntersectionMapNoEntryIconsList[u32Idx].vDestroy();
   tIntersectionMapNoEntryIconsList.clear();
   }
}

midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart()



:u8IntersectionMapIntersectionNumber(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::~midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tIntersectionMapRoadLineRoadList.size(); ++u32ListIdx)
      u32DynamicSize += tIntersectionMapRoadLineRoadList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < tIntersectionMapRoadLineRouteList.size(); ++u32ListIdx)
      u32DynamicSize += tIntersectionMapRoadLineRouteList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13+ static_cast<tU32>(tIntersectionMapNoEntryIconsList.size()*8);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tIntersectionMapRoadLineRoadList.size(); ++u32Idx)
      {
         tIntersectionMapRoadLineRoadList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tIntersectionMapRoadLineRoadList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tIntersectionMapRoadLineRoadList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tIntersectionMapRoadLineRouteList.size(); ++u32Idx)
      {
         tIntersectionMapRoadLineRouteList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tIntersectionMapRoadLineRouteList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tIntersectionMapRoadLineRouteList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tIntersectionMapNoEntryIconsList.size(); ++u32Idx)
      {
         tIntersectionMapNoEntryIconsList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tIntersectionMapNoEntryIconsList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tIntersectionMapNoEntryIconsList[u32Idx]);
      }
   }
   (tVoid) (oIn >> u8IntersectionMapIntersectionNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tIntersectionMapRoadLineRoadList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapRoadLineRoadList.size(); ++u32Idx)
         (tVoid) (oOut << tIntersectionMapRoadLineRoadList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tIntersectionMapRoadLineRouteList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapRoadLineRouteList.size(); ++u32Idx)
         (tVoid) (oOut << tIntersectionMapRoadLineRouteList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tIntersectionMapNoEntryIconsList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tIntersectionMapNoEntryIconsList.size(); ++u32Idx)
         (tVoid) (oOut << tIntersectionMapNoEntryIconsList[u32Idx]);
   }
   (tVoid) (oOut << u8IntersectionMapIntersectionNumber);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tIntersectionMapRoadLineRoadList.size() == roRef.tIntersectionMapRoadLineRoadList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tIntersectionMapRoadLineRoadList.size()); ++u32Idx)
            bResult = bResult && (tIntersectionMapRoadLineRoadList[u32Idx] == roRef.tIntersectionMapRoadLineRoadList[u32Idx]);
      }
      bResult = bResult && (tIntersectionMapRoadLineRouteList.size() == roRef.tIntersectionMapRoadLineRouteList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tIntersectionMapRoadLineRouteList.size()); ++u32Idx)
            bResult = bResult && (tIntersectionMapRoadLineRouteList[u32Idx] == roRef.tIntersectionMapRoadLineRouteList[u32Idx]);
      }
      bResult = bResult && (tIntersectionMapNoEntryIconsList.size() == roRef.tIntersectionMapNoEntryIconsList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tIntersectionMapNoEntryIconsList.size()); ++u32Idx)
            bResult = bResult && (tIntersectionMapNoEntryIconsList[u32Idx] == roRef.tIntersectionMapNoEntryIconsList[u32Idx]);
      }
   bResult = bResult && (u8IntersectionMapIntersectionNumber == roRef.u8IntersectionMapIntersectionNumber);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult::midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult::~midw_ext_meterfi_tclMsgSetNaviIntersectionMapMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   u32IntersectionMapCarsorPositionIntersectionMapId = coRef.u32IntersectionMapCarsorPositionIntersectionMapId;
   e8IntersectionMapCarsorPositionIntersectionMapCarsorState = coRef.e8IntersectionMapCarsorPositionIntersectionMapCarsorState;
   tIntersectionMapCarsorPositionScreenCoordinate = coRef.tIntersectionMapCarsorPositionScreenCoordinate;
   s32IntersectionMapCarsorPositionCarsorAngle = coRef.s32IntersectionMapCarsorPositionCarsorAngle;
}
midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::operator=(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32IntersectionMapCarsorPositionIntersectionMapId = coRef.u32IntersectionMapCarsorPositionIntersectionMapId;
   e8IntersectionMapCarsorPositionIntersectionMapCarsorState = coRef.e8IntersectionMapCarsorPositionIntersectionMapCarsorState;
   tIntersectionMapCarsorPositionScreenCoordinate = coRef.tIntersectionMapCarsorPositionScreenCoordinate;
   s32IntersectionMapCarsorPositionCarsorAngle = coRef.s32IntersectionMapCarsorPositionCarsorAngle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart()
:u32IntersectionMapCarsorPositionIntersectionMapId(0)
,e8IntersectionMapCarsorPositionIntersectionMapCarsorState()
,tIntersectionMapCarsorPositionScreenCoordinate()
,s32IntersectionMapCarsorPositionCarsorAngle(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPCARSORPOSITIONMETHODSTART;
}


midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::~midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32IntersectionMapCarsorPositionIntersectionMapId);
   (tVoid) (oIn >> e8IntersectionMapCarsorPositionIntersectionMapCarsorState);
   (tVoid) (oIn >> tIntersectionMapCarsorPositionScreenCoordinate);
   (tVoid) (oIn >> s32IntersectionMapCarsorPositionCarsorAngle);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32IntersectionMapCarsorPositionIntersectionMapId);
   (tVoid) (oOut << e8IntersectionMapCarsorPositionIntersectionMapCarsorState);
   (tVoid) (oOut << tIntersectionMapCarsorPositionScreenCoordinate);
   (tVoid) (oOut << s32IntersectionMapCarsorPositionCarsorAngle);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart::operator==(const midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32IntersectionMapCarsorPositionIntersectionMapId == roRef.u32IntersectionMapCarsorPositionIntersectionMapId);
   bResult = bResult && (e8IntersectionMapCarsorPositionIntersectionMapCarsorState == roRef.e8IntersectionMapCarsorPositionIntersectionMapCarsorState);
   bResult = bResult && (tIntersectionMapCarsorPositionScreenCoordinate == roRef.tIntersectionMapCarsorPositionScreenCoordinate);
   bResult = bResult && (s32IntersectionMapCarsorPositionCarsorAngle == roRef.s32IntersectionMapCarsorPositionCarsorAngle);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult::midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVIINTERSECTIONMAPCARSORPOSITIONMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult::~midw_ext_meterfi_tclMsgSetNaviIntersectionMapCarsorPositionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   u8SxmTabWeatherInfoEventCodeCurrentWeather = coRef.u8SxmTabWeatherInfoEventCodeCurrentWeather;
   u8SxmTabWeatherInfoEventCodeDestinationWeather = coRef.u8SxmTabWeatherInfoEventCodeDestinationWeather;
}
midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::operator=(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SxmTabWeatherInfoEventCodeCurrentWeather = coRef.u8SxmTabWeatherInfoEventCodeCurrentWeather;
   u8SxmTabWeatherInfoEventCodeDestinationWeather = coRef.u8SxmTabWeatherInfoEventCodeDestinationWeather;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart()
:u8SxmTabWeatherInfoEventCodeCurrentWeather(0)
,u8SxmTabWeatherInfoEventCodeDestinationWeather(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSXMTABWEATHERMETHODSTART;
}


midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::~midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SxmTabWeatherInfoEventCodeCurrentWeather);
   (tVoid) (oIn >> u8SxmTabWeatherInfoEventCodeDestinationWeather);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SxmTabWeatherInfoEventCodeCurrentWeather);
   (tVoid) (oOut << u8SxmTabWeatherInfoEventCodeDestinationWeather);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart::operator==(const midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SxmTabWeatherInfoEventCodeCurrentWeather == roRef.u8SxmTabWeatherInfoEventCodeCurrentWeather);
   bResult = bResult && (u8SxmTabWeatherInfoEventCodeDestinationWeather == roRef.u8SxmTabWeatherInfoEventCodeDestinationWeather);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult::midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSXMTABWEATHERMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult::~midw_ext_meterfi_tclMsgSetSxmTabWeatherMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8SpiNavgationStatus = coRef.e8SpiNavgationStatus;
}
midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::operator=(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SpiNavgationStatus = coRef.e8SpiNavgationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart()
:e8SpiNavgationStatus()
 {}

tS32 midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONSTATUSINFOMETHODSTART;
}


midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::~midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SpiNavgationStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SpiNavgationStatus);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart::operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SpiNavgationStatus == roRef.e8SpiNavgationStatus);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult::midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONSTATUSINFOMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult::~midw_ext_meterfi_tclMsgSetSpiNavigationStatusInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   strSpiNavigationRoadName = coRef.strSpiNavigationRoadName;
   e8SpiNavigationTurnSide = coRef.e8SpiNavigationTurnSide;
   e8SpiNavigationNextTurnEvent = coRef.e8SpiNavigationNextTurnEvent;
   strSpiNavigationImage = coRef.strSpiNavigationImage;
   s32SpiNavigationTurnAngle = coRef.s32SpiNavigationTurnAngle;
   s32SpiNavigationTurnNumber = coRef.s32SpiNavigationTurnNumber;
}
midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::operator=(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strSpiNavigationRoadName = coRef.strSpiNavigationRoadName;
   e8SpiNavigationTurnSide = coRef.e8SpiNavigationTurnSide;
   e8SpiNavigationNextTurnEvent = coRef.e8SpiNavigationNextTurnEvent;
   strSpiNavigationImage = coRef.strSpiNavigationImage;
   s32SpiNavigationTurnAngle = coRef.s32SpiNavigationTurnAngle;
   s32SpiNavigationTurnNumber = coRef.s32SpiNavigationTurnNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::vDestroy()
{
   strSpiNavigationRoadName.vDestroy();
   strSpiNavigationImage.vDestroy();
}

midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart()
:strSpiNavigationRoadName()
,e8SpiNavigationTurnSide()
,e8SpiNavigationNextTurnEvent()
,strSpiNavigationImage()
,s32SpiNavigationTurnAngle(0)
,s32SpiNavigationTurnNumber(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDATAMETHODSTART;
}


midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+strSpiNavigationRoadName.u32GetSize(u16MajorVersion)+strSpiNavigationImage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strSpiNavigationRoadName);
   (tVoid) (oIn >> e8SpiNavigationTurnSide);
   (tVoid) (oIn >> e8SpiNavigationNextTurnEvent);
   (tVoid) (oIn >> strSpiNavigationImage);
   (tVoid) (oIn >> s32SpiNavigationTurnAngle);
   (tVoid) (oIn >> s32SpiNavigationTurnNumber);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strSpiNavigationRoadName);
   (tVoid) (oOut << e8SpiNavigationTurnSide);
   (tVoid) (oOut << e8SpiNavigationNextTurnEvent);
   (tVoid) (oOut << strSpiNavigationImage);
   (tVoid) (oOut << s32SpiNavigationTurnAngle);
   (tVoid) (oOut << s32SpiNavigationTurnNumber);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart::operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strSpiNavigationRoadName == roRef.strSpiNavigationRoadName);
   bResult = bResult && (e8SpiNavigationTurnSide == roRef.e8SpiNavigationTurnSide);
   bResult = bResult && (e8SpiNavigationNextTurnEvent == roRef.e8SpiNavigationNextTurnEvent);
   bResult = bResult && (strSpiNavigationImage == roRef.strSpiNavigationImage);
   bResult = bResult && (s32SpiNavigationTurnAngle == roRef.s32SpiNavigationTurnAngle);
   bResult = bResult && (s32SpiNavigationTurnNumber == roRef.s32SpiNavigationTurnNumber);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult::midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDATAMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult::~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   s32SpiNavigationDistanceInMeters = coRef.s32SpiNavigationDistanceInMeters;
   s32SpiNavigationTimeInSeconds = coRef.s32SpiNavigationTimeInSeconds;
}
midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::operator=(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32SpiNavigationDistanceInMeters = coRef.s32SpiNavigationDistanceInMeters;
   s32SpiNavigationTimeInSeconds = coRef.s32SpiNavigationTimeInSeconds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart()
:s32SpiNavigationDistanceInMeters(0)
,s32SpiNavigationTimeInSeconds(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDISTANCEDATAMETHODSTART;
}


midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32SpiNavigationDistanceInMeters);
   (tVoid) (oIn >> s32SpiNavigationTimeInSeconds);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32SpiNavigationDistanceInMeters);
   (tVoid) (oOut << s32SpiNavigationTimeInSeconds);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart::operator==(const midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32SpiNavigationDistanceInMeters == roRef.s32SpiNavigationDistanceInMeters);
   bResult = bResult && (s32SpiNavigationTimeInSeconds == roRef.s32SpiNavigationTimeInSeconds);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult::midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETSPINAVIGATIONNEXTTURNDISTANCEDATAMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult::~midw_ext_meterfi_tclMsgSetSpiNavigationNextTurnDistanceDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8CallState = coRef.e8CallState;
   strCallerInfo = coRef.strCallerInfo;
   bSwitch_1 = coRef.bSwitch_1;
   bSwitch_2 = coRef.bSwitch_2;
   IsMuteOn = coRef.IsMuteOn;
}
midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::operator=(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8CallState = coRef.e8CallState;
   strCallerInfo = coRef.strCallerInfo;
   bSwitch_1 = coRef.bSwitch_1;
   bSwitch_2 = coRef.bSwitch_2;
   IsMuteOn = coRef.IsMuteOn;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::vDestroy()
{
   strCallerInfo.vDestroy();
}

midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart()
:e8CallState()
,strCallerInfo()
,bSwitch_1(0)
,bSwitch_2(0)
,IsMuteOn(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGCALLINFOMETHODSTART;
}


midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::~midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strCallerInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CallState);
   (tVoid) (oIn >> strCallerInfo);
   (tVoid) (oIn >> bSwitch_1);
   (tVoid) (oIn >> bSwitch_2);
   (tVoid) (oIn >> IsMuteOn);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CallState);
   (tVoid) (oOut << strCallerInfo);
   (tVoid) (oOut << bSwitch_1);
   (tVoid) (oOut << bSwitch_2);
   (tVoid) (oOut << IsMuteOn);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart::operator==(const midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CallState == roRef.e8CallState);
   bResult = bResult && (strCallerInfo == roRef.strCallerInfo);
   bResult = bResult && (bSwitch_1 == roRef.bSwitch_1);
   bResult = bResult && (bSwitch_2 == roRef.bSwitch_2);
   bResult = bResult && (IsMuteOn == roRef.IsMuteOn);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult::midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGCALLINFOMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult::~midw_ext_meterfi_tclMsgSetPhoneIncomingCallInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8SMSState = coRef.e8SMSState;
   e8SMSPopupType = coRef.e8SMSPopupType;
   u8MsgNumber = coRef.u8MsgNumber;
   strSenderInfo = coRef.strSenderInfo;
}
midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::operator=(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SMSState = coRef.e8SMSState;
   e8SMSPopupType = coRef.e8SMSPopupType;
   u8MsgNumber = coRef.u8MsgNumber;
   strSenderInfo = coRef.strSenderInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::vDestroy()
{
   strSenderInfo.vDestroy();
}

midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart()
:e8SMSState()
,e8SMSPopupType()
,u8MsgNumber(0)
,strSenderInfo()
 {}

tS32 midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGSMSINFOMETHODSTART;
}


midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::~midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+strSenderInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SMSState);
   (tVoid) (oIn >> e8SMSPopupType);
   (tVoid) (oIn >> u8MsgNumber);
   (tVoid) (oIn >> strSenderInfo);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SMSState);
   (tVoid) (oOut << e8SMSPopupType);
   (tVoid) (oOut << u8MsgNumber);
   (tVoid) (oOut << strSenderInfo);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart::operator==(const midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SMSState == roRef.e8SMSState);
   bResult = bResult && (e8SMSPopupType == roRef.e8SMSPopupType);
   bResult = bResult && (u8MsgNumber == roRef.u8MsgNumber);
   bResult = bResult && (strSenderInfo == roRef.strSenderInfo);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult::midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETPHONEINCOMINGSMSINFOMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult::~midw_ext_meterfi_tclMsgSetPhoneIncomingSMSInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8VRState = coRef.e8VRState;
   u8NumberOfDigits = coRef.u8NumberOfDigits;
   e8VRDigitType = coRef.e8VRDigitType;
}
midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::operator=(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VRState = coRef.e8VRState;
   u8NumberOfDigits = coRef.u8NumberOfDigits;
   e8VRDigitType = coRef.e8VRDigitType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart()
:e8VRState()
,u8NumberOfDigits(0)
,e8VRDigitType()
 {}

tS32 midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETVOICERECOGNITIONSTATUSMETHODSTART;
}


midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::~midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VRState);
   (tVoid) (oIn >> u8NumberOfDigits);
   (tVoid) (oIn >> e8VRDigitType);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VRState);
   (tVoid) (oOut << u8NumberOfDigits);
   (tVoid) (oOut << e8VRDigitType);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart::operator==(const midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VRState == roRef.e8VRState);
   bResult = bResult && (u8NumberOfDigits == roRef.u8NumberOfDigits);
   bResult = bResult && (e8VRDigitType == roRef.e8VRDigitType);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult::midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETVOICERECOGNITIONSTATUSMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult::~midw_ext_meterfi_tclMsgSetVoiceRecognitionStatusMethodResult()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart::midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart()
 {}

tS32 midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETPOWERONKEEPMETHODSTART;
}


midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart::~midw_ext_meterfi_tclMsgSetPowerOnKeepMethodStart()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult::midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETPOWERONKEEPMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult::~midw_ext_meterfi_tclMsgSetPowerOnKeepMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::midw_ext_meterfi_tclMsgSetTimeInfoMethodStart(const midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8TimeInfoType = coRef.e8TimeInfoType;
   u8TensHour = coRef.u8TensHour;
   u8OnesHour = coRef.u8OnesHour;
   u8TensMinute = coRef.u8TensMinute;
   u8OnesMinute = coRef.u8OnesMinute;
}
midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::operator=(const midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8TimeInfoType = coRef.e8TimeInfoType;
   u8TensHour = coRef.u8TensHour;
   u8OnesHour = coRef.u8OnesHour;
   u8TensMinute = coRef.u8TensMinute;
   u8OnesMinute = coRef.u8OnesMinute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::midw_ext_meterfi_tclMsgSetTimeInfoMethodStart()
:e8TimeInfoType()
,u8TensHour(0)
,u8OnesHour(0)
,u8TensMinute(0)
,u8OnesMinute(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETTIMEINFOMETHODSTART;
}


midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::~midw_ext_meterfi_tclMsgSetTimeInfoMethodStart()
{}

tU32 midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TimeInfoType);
   (tVoid) (oIn >> u8TensHour);
   (tVoid) (oIn >> u8OnesHour);
   (tVoid) (oIn >> u8TensMinute);
   (tVoid) (oIn >> u8OnesMinute);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TimeInfoType);
   (tVoid) (oOut << u8TensHour);
   (tVoid) (oOut << u8OnesHour);
   (tVoid) (oOut << u8TensMinute);
   (tVoid) (oOut << u8OnesMinute);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetTimeInfoMethodStart::operator==(const midw_ext_meterfi_tclMsgSetTimeInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TimeInfoType == roRef.e8TimeInfoType);
   bResult = bResult && (u8TensHour == roRef.u8TensHour);
   bResult = bResult && (u8OnesHour == roRef.u8OnesHour);
   bResult = bResult && (u8TensMinute == roRef.u8TensMinute);
   bResult = bResult && (u8OnesMinute == roRef.u8OnesMinute);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetTimeInfoMethodResult::midw_ext_meterfi_tclMsgSetTimeInfoMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgSetTimeInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETTIMEINFOMETHODRESULT;
}


midw_ext_meterfi_tclMsgSetTimeInfoMethodResult::~midw_ext_meterfi_tclMsgSetTimeInfoMethodResult()
{}

//=============================================================================

midw_ext_meterfi_tclMsgResetHistoryMethodStart::midw_ext_meterfi_tclMsgResetHistoryMethodStart()
 {}

tS32 midw_ext_meterfi_tclMsgResetHistoryMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART;
}


midw_ext_meterfi_tclMsgResetHistoryMethodStart::~midw_ext_meterfi_tclMsgResetHistoryMethodStart()
{}

//=============================================================================

midw_ext_meterfi_tclMsgResetHistoryMethodResult::midw_ext_meterfi_tclMsgResetHistoryMethodResult()
 {}

tS32 midw_ext_meterfi_tclMsgResetHistoryMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT;
}


midw_ext_meterfi_tclMsgResetHistoryMethodResult::~midw_ext_meterfi_tclMsgResetHistoryMethodResult()
{}

//=============================================================================

midw_ext_meterfi_tclMsgConnectionUpReg::midw_ext_meterfi_tclMsgConnectionUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgConnectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONUPREG;
}


midw_ext_meterfi_tclMsgConnectionUpReg::~midw_ext_meterfi_tclMsgConnectionUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgConnectionRelUpReg::midw_ext_meterfi_tclMsgConnectionRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONRELUPREG;
}


midw_ext_meterfi_tclMsgConnectionRelUpReg::~midw_ext_meterfi_tclMsgConnectionRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgConnectionGet::midw_ext_meterfi_tclMsgConnectionGet()
 {}

tS32 midw_ext_meterfi_tclMsgConnectionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONGET;
}


midw_ext_meterfi_tclMsgConnectionGet::~midw_ext_meterfi_tclMsgConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgConnectionStatus::midw_ext_meterfi_tclMsgConnectionStatus(const midw_ext_meterfi_tclMsgConnectionStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   arConnectionStatusList = coRef.arConnectionStatusList;
}
midw_ext_meterfi_tclMsgConnectionStatus& midw_ext_meterfi_tclMsgConnectionStatus::operator=(const midw_ext_meterfi_tclMsgConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   arConnectionStatusList = coRef.arConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgConnectionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
         arConnectionStatusList[u32Idx].vDestroy();
   arConnectionStatusList.clear();
   }
}

midw_ext_meterfi_tclMsgConnectionStatus::midw_ext_meterfi_tclMsgConnectionStatus()

 {}

tS32 midw_ext_meterfi_tclMsgConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONNECTIONSTATUS;
}


midw_ext_meterfi_tclMsgConnectionStatus::~midw_ext_meterfi_tclMsgConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arConnectionStatusList.size()*4);
}

fi_tclInContext& midw_ext_meterfi_tclMsgConnectionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
      {
         arConnectionStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arConnectionStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arConnectionStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arConnectionStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
         (tVoid) (oOut << arConnectionStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgConnectionStatus::operator==(const midw_ext_meterfi_tclMsgConnectionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arConnectionStatusList.size() == roRef.arConnectionStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arConnectionStatusList.size()); ++u32Idx)
            bResult = bResult && (arConnectionStatusList[u32Idx] == roRef.arConnectionStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgConfigurationUpReg::midw_ext_meterfi_tclMsgConfigurationUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgConfigurationUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONUPREG;
}


midw_ext_meterfi_tclMsgConfigurationUpReg::~midw_ext_meterfi_tclMsgConfigurationUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgConfigurationRelUpReg::midw_ext_meterfi_tclMsgConfigurationRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgConfigurationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONRELUPREG;
}


midw_ext_meterfi_tclMsgConfigurationRelUpReg::~midw_ext_meterfi_tclMsgConfigurationRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgConfigurationGet::midw_ext_meterfi_tclMsgConfigurationGet()
 {}

tS32 midw_ext_meterfi_tclMsgConfigurationGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONGET;
}


midw_ext_meterfi_tclMsgConfigurationGet::~midw_ext_meterfi_tclMsgConfigurationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgConfigurationStatus::midw_ext_meterfi_tclMsgConfigurationStatus(const midw_ext_meterfi_tclMsgConfigurationStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   arConfigurationList = coRef.arConfigurationList;
}
midw_ext_meterfi_tclMsgConfigurationStatus& midw_ext_meterfi_tclMsgConfigurationStatus::operator=(const midw_ext_meterfi_tclMsgConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   arConfigurationList = coRef.arConfigurationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgConfigurationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arConfigurationList.size(); ++u32Idx)
         arConfigurationList[u32Idx].vDestroy();
   arConfigurationList.clear();
   }
}

midw_ext_meterfi_tclMsgConfigurationStatus::midw_ext_meterfi_tclMsgConfigurationStatus()

 {}

tS32 midw_ext_meterfi_tclMsgConfigurationStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CONFIGURATIONSTATUS;
}


midw_ext_meterfi_tclMsgConfigurationStatus::~midw_ext_meterfi_tclMsgConfigurationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arConfigurationList.size()*6);
}

fi_tclInContext& midw_ext_meterfi_tclMsgConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arConfigurationList.size(); ++u32Idx)
      {
         arConfigurationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arConfigurationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arConfigurationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arConfigurationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arConfigurationList.size(); ++u32Idx)
         (tVoid) (oOut << arConfigurationList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgConfigurationStatus::operator==(const midw_ext_meterfi_tclMsgConfigurationStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arConfigurationList.size() == roRef.arConfigurationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arConfigurationList.size()); ++u32Idx)
            bResult = bResult && (arConfigurationList[u32Idx] == roRef.arConfigurationList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgHardwareVersionUpReg::midw_ext_meterfi_tclMsgHardwareVersionUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgHardwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG;
}


midw_ext_meterfi_tclMsgHardwareVersionUpReg::~midw_ext_meterfi_tclMsgHardwareVersionUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgHardwareVersionRelUpReg::midw_ext_meterfi_tclMsgHardwareVersionRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgHardwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG;
}


midw_ext_meterfi_tclMsgHardwareVersionRelUpReg::~midw_ext_meterfi_tclMsgHardwareVersionRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgHardwareVersionGet::midw_ext_meterfi_tclMsgHardwareVersionGet()
 {}

tS32 midw_ext_meterfi_tclMsgHardwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONGET;
}


midw_ext_meterfi_tclMsgHardwareVersionGet::~midw_ext_meterfi_tclMsgHardwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgHardwareVersionStatus::midw_ext_meterfi_tclMsgHardwareVersionStatus(const midw_ext_meterfi_tclMsgHardwareVersionStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   arHardwareVersionList = coRef.arHardwareVersionList;
}
midw_ext_meterfi_tclMsgHardwareVersionStatus& midw_ext_meterfi_tclMsgHardwareVersionStatus::operator=(const midw_ext_meterfi_tclMsgHardwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   arHardwareVersionList = coRef.arHardwareVersionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgHardwareVersionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
         arHardwareVersionList[u32Idx].vDestroy();
   arHardwareVersionList.clear();
   }
}

midw_ext_meterfi_tclMsgHardwareVersionStatus::midw_ext_meterfi_tclMsgHardwareVersionStatus()

 {}

tS32 midw_ext_meterfi_tclMsgHardwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS;
}


midw_ext_meterfi_tclMsgHardwareVersionStatus::~midw_ext_meterfi_tclMsgHardwareVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgHardwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arHardwareVersionList.size()*4);
}

fi_tclInContext& midw_ext_meterfi_tclMsgHardwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
      {
         arHardwareVersionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arHardwareVersionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arHardwareVersionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgHardwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arHardwareVersionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
         (tVoid) (oOut << arHardwareVersionList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgHardwareVersionStatus::operator==(const midw_ext_meterfi_tclMsgHardwareVersionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arHardwareVersionList.size() == roRef.arHardwareVersionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arHardwareVersionList.size()); ++u32Idx)
            bResult = bResult && (arHardwareVersionList[u32Idx] == roRef.arHardwareVersionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSoftwareVersionUpReg::midw_ext_meterfi_tclMsgSoftwareVersionUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSoftwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG;
}


midw_ext_meterfi_tclMsgSoftwareVersionUpReg::~midw_ext_meterfi_tclMsgSoftwareVersionUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg::midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG;
}


midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg::~midw_ext_meterfi_tclMsgSoftwareVersionRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSoftwareVersionGet::midw_ext_meterfi_tclMsgSoftwareVersionGet()
 {}

tS32 midw_ext_meterfi_tclMsgSoftwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONGET;
}


midw_ext_meterfi_tclMsgSoftwareVersionGet::~midw_ext_meterfi_tclMsgSoftwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSoftwareVersionStatus::midw_ext_meterfi_tclMsgSoftwareVersionStatus(const midw_ext_meterfi_tclMsgSoftwareVersionStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   arSoftwareVersionList = coRef.arSoftwareVersionList;
}
midw_ext_meterfi_tclMsgSoftwareVersionStatus& midw_ext_meterfi_tclMsgSoftwareVersionStatus::operator=(const midw_ext_meterfi_tclMsgSoftwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   arSoftwareVersionList = coRef.arSoftwareVersionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgSoftwareVersionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
         arSoftwareVersionList[u32Idx].vDestroy();
   arSoftwareVersionList.clear();
   }
}

midw_ext_meterfi_tclMsgSoftwareVersionStatus::midw_ext_meterfi_tclMsgSoftwareVersionStatus()

 {}

tS32 midw_ext_meterfi_tclMsgSoftwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS;
}


midw_ext_meterfi_tclMsgSoftwareVersionStatus::~midw_ext_meterfi_tclMsgSoftwareVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgSoftwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arSoftwareVersionList.size()*4);
}

fi_tclInContext& midw_ext_meterfi_tclMsgSoftwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
      {
         arSoftwareVersionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arSoftwareVersionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arSoftwareVersionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSoftwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arSoftwareVersionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
         (tVoid) (oOut << arSoftwareVersionList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSoftwareVersionStatus::operator==(const midw_ext_meterfi_tclMsgSoftwareVersionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arSoftwareVersionList.size() == roRef.arSoftwareVersionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arSoftwareVersionList.size()); ++u32Idx)
            bResult = bResult && (arSoftwareVersionList[u32Idx] == roRef.arSoftwareVersionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgDataTransmissionUpReg::midw_ext_meterfi_tclMsgDataTransmissionUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgDataTransmissionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONUPREG;
}


midw_ext_meterfi_tclMsgDataTransmissionUpReg::~midw_ext_meterfi_tclMsgDataTransmissionUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgDataTransmissionRelUpReg::midw_ext_meterfi_tclMsgDataTransmissionRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgDataTransmissionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONRELUPREG;
}


midw_ext_meterfi_tclMsgDataTransmissionRelUpReg::~midw_ext_meterfi_tclMsgDataTransmissionRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgDataTransmissionGet::midw_ext_meterfi_tclMsgDataTransmissionGet()
 {}

tS32 midw_ext_meterfi_tclMsgDataTransmissionGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONGET;
}


midw_ext_meterfi_tclMsgDataTransmissionGet::~midw_ext_meterfi_tclMsgDataTransmissionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgDataTransmissionStatus::midw_ext_meterfi_tclMsgDataTransmissionStatus(const midw_ext_meterfi_tclMsgDataTransmissionStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   arDataTransmissionStatusList = coRef.arDataTransmissionStatusList;
}
midw_ext_meterfi_tclMsgDataTransmissionStatus& midw_ext_meterfi_tclMsgDataTransmissionStatus::operator=(const midw_ext_meterfi_tclMsgDataTransmissionStatus& coRef)
{
   if (this == &coRef) return *this;
   arDataTransmissionStatusList = coRef.arDataTransmissionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_meterfi_tclMsgDataTransmissionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arDataTransmissionStatusList.size(); ++u32Idx)
         arDataTransmissionStatusList[u32Idx].vDestroy();
   arDataTransmissionStatusList.clear();
   }
}

midw_ext_meterfi_tclMsgDataTransmissionStatus::midw_ext_meterfi_tclMsgDataTransmissionStatus()

 {}

tS32 midw_ext_meterfi_tclMsgDataTransmissionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_DATATRANSMISSIONSTATUS;
}


midw_ext_meterfi_tclMsgDataTransmissionStatus::~midw_ext_meterfi_tclMsgDataTransmissionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_meterfi_tclMsgDataTransmissionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arDataTransmissionStatusList.size()*2);
}

fi_tclInContext& midw_ext_meterfi_tclMsgDataTransmissionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arDataTransmissionStatusList.size(); ++u32Idx)
      {
         arDataTransmissionStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arDataTransmissionStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arDataTransmissionStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgDataTransmissionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arDataTransmissionStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arDataTransmissionStatusList.size(); ++u32Idx)
         (tVoid) (oOut << arDataTransmissionStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_meterfi_tclMsgDataTransmissionStatus::operator==(const midw_ext_meterfi_tclMsgDataTransmissionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arDataTransmissionStatusList.size() == roRef.arDataTransmissionStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arDataTransmissionStatusList.size()); ++u32Idx)
            bResult = bResult && (arDataTransmissionStatusList[u32Idx] == roRef.arDataTransmissionStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg::midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSUPREG;
}


midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg::~midw_ext_meterfi_tclMsgCurrentMeterSettingsUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg::midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSRELUPREG;
}


midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg::~midw_ext_meterfi_tclMsgCurrentMeterSettingsRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgCurrentMeterSettingsGet::midw_ext_meterfi_tclMsgCurrentMeterSettingsGet()
 {}

tS32 midw_ext_meterfi_tclMsgCurrentMeterSettingsGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSGET;
}


midw_ext_meterfi_tclMsgCurrentMeterSettingsGet::~midw_ext_meterfi_tclMsgCurrentMeterSettingsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus(const midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
   e8FuelConsumptionUnit = coRef.e8FuelConsumptionUnit;
   e8TemperatureUnit = coRef.e8TemperatureUnit;
   e8PressureUnit = coRef.e8PressureUnit;
}
midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::operator=(const midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   e8FuelConsumptionUnit = coRef.e8FuelConsumptionUnit;
   e8TemperatureUnit = coRef.e8TemperatureUnit;
   e8PressureUnit = coRef.e8PressureUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus()
:e8Language()
,e8FuelConsumptionUnit()
,e8TemperatureUnit()
,e8PressureUnit()
 {}

tS32 midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_CURRENTMETERSETTINGSSTATUS;
}


midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::~midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus()
{}

tU32 midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   (tVoid) (oIn >> e8FuelConsumptionUnit);
   (tVoid) (oIn >> e8TemperatureUnit);
   (tVoid) (oIn >> e8PressureUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   (tVoid) (oOut << e8FuelConsumptionUnit);
   (tVoid) (oOut << e8TemperatureUnit);
   (tVoid) (oOut << e8PressureUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus::operator==(const midw_ext_meterfi_tclMsgCurrentMeterSettingsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   bResult = bResult && (e8FuelConsumptionUnit == roRef.e8FuelConsumptionUnit);
   bResult = bResult && (e8TemperatureUnit == roRef.e8TemperatureUnit);
   bResult = bResult && (e8PressureUnit == roRef.e8PressureUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg::midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSUPREG;
}


midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg::~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg::midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSRELUPREG;
}


midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg::~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet::midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet()
 {}

tS32 midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSGET;
}


midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet::~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   b_km_per_l = coRef.b_km_per_l;
   b_l_per_100km = coRef.b_l_per_100km;
   b_US_MPG = coRef.b_US_MPG;
   b_UK_MPG = coRef.b_UK_MPG;
}
midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::operator=(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& coRef)
{
   if (this == &coRef) return *this;
   b_km_per_l = coRef.b_km_per_l;
   b_l_per_100km = coRef.b_l_per_100km;
   b_US_MPG = coRef.b_US_MPG;
   b_UK_MPG = coRef.b_UK_MPG;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus()
:b_km_per_l(0)
,b_l_per_100km(0)
,b_US_MPG(0)
,b_UK_MPG(0)
 {}

tS32 midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEFUELCONSUMPTIONUNITSSTATUS;
}


midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::~midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus()
{}

tU32 midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b_km_per_l);
   (tVoid) (oIn >> b_l_per_100km);
   (tVoid) (oIn >> b_US_MPG);
   (tVoid) (oIn >> b_UK_MPG);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b_km_per_l);
   (tVoid) (oOut << b_l_per_100km);
   (tVoid) (oOut << b_US_MPG);
   (tVoid) (oOut << b_UK_MPG);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus::operator==(const midw_ext_meterfi_tclMsgAvailableFuelConsumptionUnitsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b_km_per_l == roRef.b_km_per_l);
   bResult = bResult && (b_l_per_100km == roRef.b_l_per_100km);
   bResult = bResult && (b_US_MPG == roRef.b_US_MPG);
   bResult = bResult && (b_UK_MPG == roRef.b_UK_MPG);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg::midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSUPREG;
}


midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg::~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg::midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSRELUPREG;
}


midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg::~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet::midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet()
 {}

tS32 midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSGET;
}


midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet::~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   b_deg_C = coRef.b_deg_C;
   b_deg_F = coRef.b_deg_F;
}
midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::operator=(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& coRef)
{
   if (this == &coRef) return *this;
   b_deg_C = coRef.b_deg_C;
   b_deg_F = coRef.b_deg_F;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus()
:b_deg_C(0)
,b_deg_F(0)
 {}

tS32 midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLETEMPERATUREUNITSSTATUS;
}


midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::~midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus()
{}

tU32 midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b_deg_C);
   (tVoid) (oIn >> b_deg_F);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b_deg_C);
   (tVoid) (oOut << b_deg_F);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus::operator==(const midw_ext_meterfi_tclMsgAvailableTemperatureUnitsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b_deg_C == roRef.b_deg_C);
   bResult = bResult && (b_deg_F == roRef.b_deg_F);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg::midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSUPREG;
}


midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg::~midw_ext_meterfi_tclMsgAvailablePressureUnitsUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg::midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSRELUPREG;
}


midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg::~midw_ext_meterfi_tclMsgAvailablePressureUnitsRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgAvailablePressureUnitsGet::midw_ext_meterfi_tclMsgAvailablePressureUnitsGet()
 {}

tS32 midw_ext_meterfi_tclMsgAvailablePressureUnitsGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSGET;
}


midw_ext_meterfi_tclMsgAvailablePressureUnitsGet::~midw_ext_meterfi_tclMsgAvailablePressureUnitsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus(const midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   b_kPa = coRef.b_kPa;
   b_PSI = coRef.b_PSI;
   b_bar = coRef.b_bar;
   b_kgf_cm2 = coRef.b_kgf_cm2;
}
midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::operator=(const midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& coRef)
{
   if (this == &coRef) return *this;
   b_kPa = coRef.b_kPa;
   b_PSI = coRef.b_PSI;
   b_bar = coRef.b_bar;
   b_kgf_cm2 = coRef.b_kgf_cm2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus()
:b_kPa(0)
,b_PSI(0)
,b_bar(0)
,b_kgf_cm2(0)
 {}

tS32 midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_AVAILABLEPRESSUREUNITSSTATUS;
}


midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::~midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus()
{}

tU32 midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b_kPa);
   (tVoid) (oIn >> b_PSI);
   (tVoid) (oIn >> b_bar);
   (tVoid) (oIn >> b_kgf_cm2);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b_kPa);
   (tVoid) (oOut << b_PSI);
   (tVoid) (oOut << b_bar);
   (tVoid) (oOut << b_kgf_cm2);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus::operator==(const midw_ext_meterfi_tclMsgAvailablePressureUnitsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b_kPa == roRef.b_kPa);
   bResult = bResult && (b_PSI == roRef.b_PSI);
   bResult = bResult && (b_bar == roRef.b_bar);
   bResult = bResult && (b_kgf_cm2 == roRef.b_kgf_cm2);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg::midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITUPREG;
}


midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg::~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg::midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITRELUPREG;
}


midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg::~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet::midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITGET;
}


midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet::~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8FuelConsumptionUnit = coRef.e8FuelConsumptionUnit;
}
midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::operator=(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& coRef)
{
   if (this == &coRef) return *this;
   e8FuelConsumptionUnit = coRef.e8FuelConsumptionUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus()
:e8FuelConsumptionUnit()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDFUELCONSUMPTIONUNITSTATUS;
}


midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::~midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus()
{}

tU32 midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FuelConsumptionUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FuelConsumptionUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus::operator==(const midw_ext_meterfi_tclMsgRequestedFuelConsumptionUnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FuelConsumptionUnit == roRef.e8FuelConsumptionUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg::midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITUPREG;
}


midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg::~midw_ext_meterfi_tclMsgRequestedTemperatureUnitUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg::midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITRELUPREG;
}


midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg::~midw_ext_meterfi_tclMsgRequestedTemperatureUnitRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet::midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITGET;
}


midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet::~midw_ext_meterfi_tclMsgRequestedTemperatureUnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8TemperatureUnit = coRef.e8TemperatureUnit;
}
midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::operator=(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& coRef)
{
   if (this == &coRef) return *this;
   e8TemperatureUnit = coRef.e8TemperatureUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus()
:e8TemperatureUnit()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDTEMPERATUREUNITSTATUS;
}


midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::~midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus()
{}

tU32 midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TemperatureUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TemperatureUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus::operator==(const midw_ext_meterfi_tclMsgRequestedTemperatureUnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TemperatureUnit == roRef.e8TemperatureUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg::midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITUPREG;
}


midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg::~midw_ext_meterfi_tclMsgRequestedPressureUnitUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg::midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITRELUPREG;
}


midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg::~midw_ext_meterfi_tclMsgRequestedPressureUnitRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedPressureUnitGet::midw_ext_meterfi_tclMsgRequestedPressureUnitGet()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPressureUnitGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITGET;
}


midw_ext_meterfi_tclMsgRequestedPressureUnitGet::~midw_ext_meterfi_tclMsgRequestedPressureUnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::midw_ext_meterfi_tclMsgRequestedPressureUnitStatus(const midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8PressureUnit = coRef.e8PressureUnit;
}
midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::operator=(const midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PressureUnit = coRef.e8PressureUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::midw_ext_meterfi_tclMsgRequestedPressureUnitStatus()
:e8PressureUnit()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPRESSUREUNITSTATUS;
}


midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::~midw_ext_meterfi_tclMsgRequestedPressureUnitStatus()
{}

tU32 midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PressureUnit);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PressureUnit);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgRequestedPressureUnitStatus::operator==(const midw_ext_meterfi_tclMsgRequestedPressureUnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PressureUnit == roRef.e8PressureUnit);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg::midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODEUPREG;
}


midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg::~midw_ext_meterfi_tclMsgSupportedLangSyncModeUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg::midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODERELUPREG;
}


midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg::~midw_ext_meterfi_tclMsgSupportedLangSyncModeRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSupportedLangSyncModeGet::midw_ext_meterfi_tclMsgSupportedLangSyncModeGet()
 {}

tS32 midw_ext_meterfi_tclMsgSupportedLangSyncModeGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODEGET;
}


midw_ext_meterfi_tclMsgSupportedLangSyncModeGet::~midw_ext_meterfi_tclMsgSupportedLangSyncModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus(const midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8LangSyncMode = coRef.e8LangSyncMode;
}
midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::operator=(const midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8LangSyncMode = coRef.e8LangSyncMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus()
:e8LangSyncMode()
 {}

tS32 midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SUPPORTEDLANGSYNCMODESTATUS;
}


midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::~midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus()
{}

tU32 midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LangSyncMode);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LangSyncMode);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus::operator==(const midw_ext_meterfi_tclMsgSupportedLangSyncModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LangSyncMode == roRef.e8LangSyncMode);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedLanguageUpReg::midw_ext_meterfi_tclMsgRequestedLanguageUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedLanguageUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGEUPREG;
}


midw_ext_meterfi_tclMsgRequestedLanguageUpReg::~midw_ext_meterfi_tclMsgRequestedLanguageUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg::midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGERELUPREG;
}


midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg::~midw_ext_meterfi_tclMsgRequestedLanguageRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedLanguageGet::midw_ext_meterfi_tclMsgRequestedLanguageGet()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedLanguageGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGEGET;
}


midw_ext_meterfi_tclMsgRequestedLanguageGet::~midw_ext_meterfi_tclMsgRequestedLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgRequestedLanguageStatus::midw_ext_meterfi_tclMsgRequestedLanguageStatus(const midw_ext_meterfi_tclMsgRequestedLanguageStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
   e8MeterLanguageAction = coRef.e8MeterLanguageAction;
}
midw_ext_meterfi_tclMsgRequestedLanguageStatus& midw_ext_meterfi_tclMsgRequestedLanguageStatus::operator=(const midw_ext_meterfi_tclMsgRequestedLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   e8MeterLanguageAction = coRef.e8MeterLanguageAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgRequestedLanguageStatus::midw_ext_meterfi_tclMsgRequestedLanguageStatus()
:e8Language()
,e8MeterLanguageAction()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedLanguageStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDLANGUAGESTATUS;
}


midw_ext_meterfi_tclMsgRequestedLanguageStatus::~midw_ext_meterfi_tclMsgRequestedLanguageStatus()
{}

tU32 midw_ext_meterfi_tclMsgRequestedLanguageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgRequestedLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   (tVoid) (oIn >> e8MeterLanguageAction);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgRequestedLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   (tVoid) (oOut << e8MeterLanguageAction);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgRequestedLanguageStatus::operator==(const midw_ext_meterfi_tclMsgRequestedLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   bResult = bResult && (e8MeterLanguageAction == roRef.e8MeterLanguageAction);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg::midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSUPREG;
}


midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg::~midw_ext_meterfi_tclMsgLanguageSettingsStatusUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg::midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSRELUPREG;
}


midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg::~midw_ext_meterfi_tclMsgLanguageSettingsStatusRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgLanguageSettingsStatusGet::midw_ext_meterfi_tclMsgLanguageSettingsStatusGet()
 {}

tS32 midw_ext_meterfi_tclMsgLanguageSettingsStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSGET;
}


midw_ext_meterfi_tclMsgLanguageSettingsStatusGet::~midw_ext_meterfi_tclMsgLanguageSettingsStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus(const midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8DefaultLanguage = coRef.e8DefaultLanguage;
   e8CurrentLanguage = coRef.e8CurrentLanguage;
   e8LanguageAvailable_Byte_1 = coRef.e8LanguageAvailable_Byte_1;
   e8LanguageAvailable_Byte_2 = coRef.e8LanguageAvailable_Byte_2;
   e8LanguageAvailable_Byte_3 = coRef.e8LanguageAvailable_Byte_3;
}
midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::operator=(const midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8InvalidParameter = coRef.e8InvalidParameter;
   e8DefaultLanguage = coRef.e8DefaultLanguage;
   e8CurrentLanguage = coRef.e8CurrentLanguage;
   e8LanguageAvailable_Byte_1 = coRef.e8LanguageAvailable_Byte_1;
   e8LanguageAvailable_Byte_2 = coRef.e8LanguageAvailable_Byte_2;
   e8LanguageAvailable_Byte_3 = coRef.e8LanguageAvailable_Byte_3;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus()
:e8InvalidParameter()
,e8DefaultLanguage()
,e8CurrentLanguage()
,e8LanguageAvailable_Byte_1(0)
,e8LanguageAvailable_Byte_2(0)
,e8LanguageAvailable_Byte_3(0)
 {}

tS32 midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_LANGUAGESETTINGSSTATUSSTATUS;
}


midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::~midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus()
{}

tU32 midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8InvalidParameter);
   (tVoid) (oIn >> e8DefaultLanguage);
   (tVoid) (oIn >> e8CurrentLanguage);
   (tVoid) (oIn >> e8LanguageAvailable_Byte_1);
   (tVoid) (oIn >> e8LanguageAvailable_Byte_2);
   (tVoid) (oIn >> e8LanguageAvailable_Byte_3);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8InvalidParameter);
   (tVoid) (oOut << e8DefaultLanguage);
   (tVoid) (oOut << e8CurrentLanguage);
   (tVoid) (oOut << e8LanguageAvailable_Byte_1);
   (tVoid) (oOut << e8LanguageAvailable_Byte_2);
   (tVoid) (oOut << e8LanguageAvailable_Byte_3);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus::operator==(const midw_ext_meterfi_tclMsgLanguageSettingsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8InvalidParameter == roRef.e8InvalidParameter);
   bResult = bResult && (e8DefaultLanguage == roRef.e8DefaultLanguage);
   bResult = bResult && (e8CurrentLanguage == roRef.e8CurrentLanguage);
   bResult = bResult && (e8LanguageAvailable_Byte_1 == roRef.e8LanguageAvailable_Byte_1);
   bResult = bResult && (e8LanguageAvailable_Byte_2 == roRef.e8LanguageAvailable_Byte_2);
   bResult = bResult && (e8LanguageAvailable_Byte_3 == roRef.e8LanguageAvailable_Byte_3);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg::midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERUPREG;
}


midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg::~midw_ext_meterfi_tclMsgSelectedSourceOnMeterUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg::midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERRELUPREG;
}


midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg::~midw_ext_meterfi_tclMsgSelectedSourceOnMeterRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet::midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet()
 {}

tS32 midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERGET;
}


midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet::~midw_ext_meterfi_tclMsgSelectedSourceOnMeterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8SelectedSource = coRef.e8SelectedSource;
}
midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::operator=(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SelectedSource = coRef.e8SelectedSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus()
:e8SelectedSource(0)
 {}

tS32 midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SELECTEDSOURCEONMETERSTATUS;
}


midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::~midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus()
{}

tU32 midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectedSource);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectedSource);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus::operator==(const midw_ext_meterfi_tclMsgSelectedSourceOnMeterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectedSource == roRef.e8SelectedSource);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviSwipeUpReg::midw_ext_meterfi_tclMsgSetNaviSwipeUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviSwipeUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPEUPREG;
}


midw_ext_meterfi_tclMsgSetNaviSwipeUpReg::~midw_ext_meterfi_tclMsgSetNaviSwipeUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg::midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPERELUPREG;
}


midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg::~midw_ext_meterfi_tclMsgSetNaviSwipeRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgSetNaviSwipeSet::midw_ext_meterfi_tclMsgSetNaviSwipeSet()
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviSwipeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPESET;
}


midw_ext_meterfi_tclMsgSetNaviSwipeSet::~midw_ext_meterfi_tclMsgSetNaviSwipeSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgSetNaviSwipeStatus::midw_ext_meterfi_tclMsgSetNaviSwipeStatus(const midw_ext_meterfi_tclMsgSetNaviSwipeStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bSwipeBeep = coRef.bSwipeBeep;
}
midw_ext_meterfi_tclMsgSetNaviSwipeStatus& midw_ext_meterfi_tclMsgSetNaviSwipeStatus::operator=(const midw_ext_meterfi_tclMsgSetNaviSwipeStatus& coRef)
{
   if (this == &coRef) return *this;
   bSwipeBeep = coRef.bSwipeBeep;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgSetNaviSwipeStatus::midw_ext_meterfi_tclMsgSetNaviSwipeStatus()
:bSwipeBeep(0)
 {}

tS32 midw_ext_meterfi_tclMsgSetNaviSwipeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_SETNAVISWIPESTATUS;
}


midw_ext_meterfi_tclMsgSetNaviSwipeStatus::~midw_ext_meterfi_tclMsgSetNaviSwipeStatus()
{}

tU32 midw_ext_meterfi_tclMsgSetNaviSwipeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgSetNaviSwipeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSwipeBeep);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgSetNaviSwipeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSwipeBeep);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgSetNaviSwipeStatus::operator==(const midw_ext_meterfi_tclMsgSetNaviSwipeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSwipeBeep == roRef.bSwipeBeep);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgKeyEventUpReg::midw_ext_meterfi_tclMsgKeyEventUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgKeyEventUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_KEYEVENTUPREG;
}


midw_ext_meterfi_tclMsgKeyEventUpReg::~midw_ext_meterfi_tclMsgKeyEventUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgKeyEventRelUpReg::midw_ext_meterfi_tclMsgKeyEventRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgKeyEventRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_KEYEVENTRELUPREG;
}


midw_ext_meterfi_tclMsgKeyEventRelUpReg::~midw_ext_meterfi_tclMsgKeyEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgKeyEventStatus::midw_ext_meterfi_tclMsgKeyEventStatus(const midw_ext_meterfi_tclMsgKeyEventStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   bKeyPressed = coRef.bKeyPressed;
   e8KeyCode = coRef.e8KeyCode;
}
midw_ext_meterfi_tclMsgKeyEventStatus& midw_ext_meterfi_tclMsgKeyEventStatus::operator=(const midw_ext_meterfi_tclMsgKeyEventStatus& coRef)
{
   if (this == &coRef) return *this;
   bKeyPressed = coRef.bKeyPressed;
   e8KeyCode = coRef.e8KeyCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgKeyEventStatus::midw_ext_meterfi_tclMsgKeyEventStatus()
:bKeyPressed(0)
,e8KeyCode()
 {}

tS32 midw_ext_meterfi_tclMsgKeyEventStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_KEYEVENTSTATUS;
}


midw_ext_meterfi_tclMsgKeyEventStatus::~midw_ext_meterfi_tclMsgKeyEventStatus()
{}

tU32 midw_ext_meterfi_tclMsgKeyEventStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_meterfi_tclMsgKeyEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bKeyPressed);
   (tVoid) (oIn >> e8KeyCode);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgKeyEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bKeyPressed);
   (tVoid) (oOut << e8KeyCode);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgKeyEventStatus::operator==(const midw_ext_meterfi_tclMsgKeyEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bKeyPressed == roRef.bKeyPressed);
   bResult = bResult && (e8KeyCode == roRef.e8KeyCode);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg::midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPHONECALLMENUACTIONUPREG;
}


midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg::~midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg::midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPHONECALLMENUACTIONRELUPREG;
}


midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg::~midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8CallMenuSelection = coRef.e8CallMenuSelection;
}
midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::operator=(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CallMenuSelection = coRef.e8CallMenuSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus()
:e8CallMenuSelection()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDPHONECALLMENUACTIONSTATUS;
}


midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::~midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus()
{}

tU32 midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CallMenuSelection);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CallMenuSelection);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus::operator==(const midw_ext_meterfi_tclMsgRequestedPhoneCallMenuActionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CallMenuSelection == roRef.e8CallMenuSelection);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg::midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDSMSMENUACTIONUPREG;
}


midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg::~midw_ext_meterfi_tclMsgRequestedSMSMenuActionUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg::midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDSMSMENUACTIONRELUPREG;
}


midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg::~midw_ext_meterfi_tclMsgRequestedSMSMenuActionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8SelectedSMSMenu = coRef.e8SelectedSMSMenu;
}
midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::operator=(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SelectedSMSMenu = coRef.e8SelectedSMSMenu;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus()
:e8SelectedSMSMenu()
 {}

tS32 midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_REQUESTEDSMSMENUACTIONSTATUS;
}


midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::~midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus()
{}

tU32 midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SelectedSMSMenu);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SelectedSMSMenu);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus::operator==(const midw_ext_meterfi_tclMsgRequestedSMSMenuActionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SelectedSMSMenu == roRef.e8SelectedSMSMenu);
   return bResult;
}

//=============================================================================

midw_ext_meterfi_tclMsgVehiclePowerStateUpReg::midw_ext_meterfi_tclMsgVehiclePowerStateUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgVehiclePowerStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATEUPREG;
}


midw_ext_meterfi_tclMsgVehiclePowerStateUpReg::~midw_ext_meterfi_tclMsgVehiclePowerStateUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg::midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg()
 {}

tS32 midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATERELUPREG;
}


midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg::~midw_ext_meterfi_tclMsgVehiclePowerStateRelUpReg()
{}

//=============================================================================

midw_ext_meterfi_tclMsgVehiclePowerStateGet::midw_ext_meterfi_tclMsgVehiclePowerStateGet()
 {}

tS32 midw_ext_meterfi_tclMsgVehiclePowerStateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATEGET;
}


midw_ext_meterfi_tclMsgVehiclePowerStateGet::~midw_ext_meterfi_tclMsgVehiclePowerStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_meterfi_tclMsgVehiclePowerStateStatus::midw_ext_meterfi_tclMsgVehiclePowerStateStatus(const midw_ext_meterfi_tclMsgVehiclePowerStateStatus& coRef)
   : midw_ext_meterfi_tclMsgBaseMessage(coRef)
{
   e8PowerState = coRef.e8PowerState;
}
midw_ext_meterfi_tclMsgVehiclePowerStateStatus& midw_ext_meterfi_tclMsgVehiclePowerStateStatus::operator=(const midw_ext_meterfi_tclMsgVehiclePowerStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PowerState = coRef.e8PowerState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_meterfi_tclMsgVehiclePowerStateStatus::midw_ext_meterfi_tclMsgVehiclePowerStateStatus()
:e8PowerState()
 {}

tS32 midw_ext_meterfi_tclMsgVehiclePowerStateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_meterfi_tclToken::EN_MSG_VEHICLEPOWERSTATESTATUS;
}


midw_ext_meterfi_tclMsgVehiclePowerStateStatus::~midw_ext_meterfi_tclMsgVehiclePowerStateStatus()
{}

tU32 midw_ext_meterfi_tclMsgVehiclePowerStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_meterfi_tclMsgVehiclePowerStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PowerState);
   return oIn;
}

fi_tclOutContext& midw_ext_meterfi_tclMsgVehiclePowerStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PowerState);
   return oOut;
}

tBool midw_ext_meterfi_tclMsgVehiclePowerStateStatus::operator==(const midw_ext_meterfi_tclMsgVehiclePowerStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PowerState == roRef.e8PowerState);
   return bResult;
}

