/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_EXT_DABTUNERFITYPES_HEADER
#define MIDW_EXT_DABTUNERFITYPES_HEADER


class midw_ext_dabtunerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_EXT_DABTUNER_FI message types

fi_tclMessageBase* midw_ext_dabtunerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ext_dabtunerfi_tclMsgBaseMessage : public midw_ext_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ext_dabtunerfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool StartScan;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_START_SCANMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_LearnParam LearnParam;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_LEARNMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   std::vector<midw_ext_fi_tcl_DAB_TIIListElement, std::allocator<midw_ext_fi_tcl_DAB_TIIListElement> > TIIList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_TIILISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_EnsSelectMode SelectMode;
   tU32 u32Value;
   tBool bNegative;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ENS_SELECTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_ChnSelectMode SelectMode;
   tU32 u32Value;
   tU16 u16Scids;
   tBool bNegative;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SRV_SELECTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_CompSelectMode SelectMode;
   tU32 u32Value;
   tBool bNegative;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_COMP_SELECTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_SourceState e8SourceState;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   midw_ext_fi_tcl_e8_DAB_SourceState e8SourceState;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   tS8 s8FieldStrength;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_FIELDSTRENGTHMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b32_DAB_SetupMask b32SetupMask;
   midw_ext_fi_tcl_b32_DAB_SetupFlags b32SetupFlags;
   tBool bUseConcealmentLevel;
   tU8 u8ConcealmentLevel;
   tBool bUseServiceLinkingMode;
   midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode;
   tBool bUseEnsInsertThreshold;
   tU8 u8EnsInsertThreshold;
   tBool bUseEnsDeleteThreshold;
   tU8 u8EnsDeleteThreshold;
   tBool bBgLearnUpdateTime;
   tU8 u8BgLearnUpdateTime;
   tBool bDABScanThreshold;
   tU8 u8DABScanThreshold;
   tBool bSwitchMeasurementMode;
   midw_ext_fi_tcl_b8_DAB_LinkingSetupMask b8LinkingSetupMask;
   tU8 u8DABFMLinkingThreshold;
   tU8 u8DABFMLinkingBackThreshold;
   tU8 u8DABFMLinkingBackValidationTime;
   tU8 u8DABFMLinkBackDelay;
   tBool bIsTestmode;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SETUPMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_AnnoConfig AnnoConfig;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSelect;
   tU16 u16AnnoNumber;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_BankList e8BankId;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_BANKMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8PresetElemId;
   tU32 u32PSID;
   tU8 u8Scids;
   tU32 u32EnsFrequency;
   tBool bDelete;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_DeleteAction e8Action;
   tU8 u8DelPresetElemId;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ActPresetElemID;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_PresetListElement, std::allocator<midw_ext_fi_tcl_DAB_PresetListElement> > PresetList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8FirstElementID;
   tU8 u8NumberOfElements;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   tU8 u8FirstElementID;
   tU8 u8NumberOfElements;
   std::vector<midw_ext_fi_tcl_DAB_PresetListElement, std::allocator<midw_ext_fi_tcl_DAB_PresetListElement> > PresetList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool StartAutostore;
   midw_ext_fi_tcl_e8_DAB_AST_Type AST_Type;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   tU8 u8NumberOfStationsFound;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_ListOperation enOperation;
   tU16 u16FirstElemId;
   tU16 u16NumElem;
   midw_ext_fi_tcl_e8_DAB_EnsembleListSortingType enSortingType;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   std::vector<midw_ext_fi_tcl_DAB_EnsembleInfo, std::allocator<midw_ext_fi_tcl_DAB_EnsembleInfo> > EnsembleList;
   tBool bOpen;
   tU16 u16TotalNumberOfElements;
   tU16 u16SentNumberOfElements;
   tU16 u16InitialActivatedElementId;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_ENS_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_ListOperation enOperation;
   midw_ext_fi_tcl_e8_DAB_ServiceListType enServiceListType;
   tU32 u32PTYFilter;
   tU16 u16FirstElemId;
   tU16 u16NumElem;
   midw_ext_fi_tcl_e8_DAB_ServiceListSortingType enSortingType;
   tU16 u16EnsembleIndex;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   midw_ext_fi_tcl_e8_DAB_ServiceListType enServiceListType;
   std::vector<midw_ext_fi_tcl_DAB_ChnListElement, std::allocator<midw_ext_fi_tcl_DAB_ChnListElement> > ChannelList;
   tBool bOpen;
   tU16 u16TotalNumberOfElements;
   tU16 u16SentNumberOfElements;
   tU16 u16InitialActivatedElementId;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_SRV_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_ListOperation enOperation;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_COMP_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   tBool bEPGAvailability;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_VALIDATE_EPG_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TestOperation enOperation;
   tU32 u32Value1;
   tU32 u32Value2;
   tU32 u32Value3;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TEST_OPERATIONMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSet;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DEFAULT_SETTINGSMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32EnsembleId;
   std::vector<midw_ext_fi_tcl_DAB_RdbId, std::allocator<midw_ext_fi_tcl_DAB_RdbId> > RdbIDList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_TMCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumberOfElements;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   std::vector<midw_ext_fi_tcl_DAB_TpegUriChannel, std::allocator<midw_ext_fi_tcl_DAB_TpegUriChannel> > TpegUriChannelList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TPEG_URI_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bActive;
   midw_ext_fi_tcl_DAB_TpegUriChannel sTpegUriChn;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TPEG_CHNMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_RdbId, std::allocator<midw_ext_fi_tcl_DAB_RdbId> > RdbIDList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_RdbId, std::allocator<midw_ext_fi_tcl_DAB_RdbId> > RdbIDList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_RDBID_WISH_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bActive;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_TESTMODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ExpApiId;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ExpApiId;
   midw_ext_fi_tclString sLabel;
   midw_ext_fi_tclString sValue;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_EXP_API_INFOMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Adr3DbQuery;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Adr3DbQuery;
   midw_ext_fi_tclString sDbQuery;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DB_QUERYMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TuneCmd enTuneCmd;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_ENSEMBLEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TuneCmd enTuneCmd;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SEEK_SERVICEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_TuneCmd enTuneCmd;
   tU32 u32Frequency;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TARGET_SEEKMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Source e8DabSource;
   midw_ext_fi_tcl_e8_DAB_MuteStatus e8MuteStatus;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_LogoElement, std::allocator<midw_ext_fi_tcl_DAB_LogoElement> > LogoList;
   std::vector<midw_ext_fi_tcl_DAB_ContentID, std::allocator<midw_ext_fi_tcl_DAB_ContentID> > ContentIDList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DATASERVICES_DATAMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_ADRMsg DSMMsg;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_DSM_MSGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b8_DAB_MTC_SetMode b8Mode;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tclString FrequencyLabel;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_TUNE_FREQUENCY_LABELMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_UserProfileAction Action;
   tU8 UserID;
   tU8 DestinationUserID;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_UserProfileAction Action;
   tU8 ActiveUserID;
   midw_ext_fi_tcl_e8_DAB_Response e8MethodResult;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_TunerStatus TunerStatus;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TUNER_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bIsDABAvailable;
   midw_ext_fi_tcl_e8_DAB_SourceState e8SourceState;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_AVAILABILITYStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_ADRMsg TunerStatus;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ADR_MSGStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS64 LocalOffset;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LOCAL_OFFSETStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_AnnoStatus AnnoStatus;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_ChannelInfo ChannelInfo;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bOpen;
   tU16 u16NumberOfComponents;
   tU16 u16ActivatedElementId;
   std::vector<midw_ext_fi_tcl_DAB_ChnListElement, std::allocator<midw_ext_fi_tcl_DAB_ChnListElement> > ComponentList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_COMP_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8FirstElementID;
   tU8 u8NumberOfElements;
   std::vector<midw_ext_fi_tcl_DAB_PresetListElement, std::allocator<midw_ext_fi_tcl_DAB_PresetListElement> > PresetList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b32_DAB_SetupFlags b32SetupFlags;
   midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode;
   tU8 u8ConcealmentLevel;
   tU8 u8DABFMLinkingThreshold;
   tU8 u8DABFMLinkBackDelay;
   tU8 u8DABFMLinkingBackThreshold;
   tU8 u8DABFMLinkingBackValidationTime;
   tU8 u8EnsInsertThreshold;
   tU8 u8EnsDeleteThreshold;
   tU8 u8BgLearnUpdateTime;
   tU8 u8DABScanThreshold;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SETUP_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_ServiceFollowingTuner e8ServiceFollowingTuner;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_DAB_MuteStatus e8MuteStatus;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRequestMute;
   tU8 u8Attenuation;
   tBool bMute_Interrupt;
   tBool bTa;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8LearnPercentage;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LEARNUPDATE_PROGRESSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bActive;
   tBool bUpdateRunning;
   tU16 u16ActivatedElementId;
   std::vector<midw_ext_fi_tcl_DAB_ListElementAvailInfo, std::allocator<midw_ext_fi_tcl_DAB_ListElementAvailInfo> > ChangedSrvAvailList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRV_LIST_UPDATEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_TestModeData TestModeData;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TESTMODE_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_EnsembleInfo EnsembleInfo;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_ServiceInfo ServiceInfo;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_SERVICE_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_ComponentInfo ComponentInfo;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_ACTIVE_COMPONENT_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_BG_TestModeData BG_TestModeData;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_BG_TESTMODE_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_DAB_TMC_TPEG_TestModeData TestModeData;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_TPEG_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_TmcInfo, std::allocator<midw_ext_fi_tcl_DAB_TmcInfo> > TmcData;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_EnsembleTmcInfo, std::allocator<midw_ext_fi_tcl_DAB_EnsembleTmcInfo> > EnsembleTmcInfoList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TMC_AVAIL_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_TpegInfo, std::allocator<midw_ext_fi_tcl_DAB_TpegInfo> > TpegData;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_TpegUriChannel, std::allocator<midw_ext_fi_tcl_DAB_TpegUriChannel> > TpegUriChannelList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_TPEG_URI_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_b8_DAB_MTC_SetMode Mode;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_MTC_Tuner_Status State;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_TUNER_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_ext_fi_tcl_e8_StationType StationType;
   tU32 StationFrequency;
   tU32 StationId;
   tU32 EnsID;
   midw_ext_fi_tcl_e8_TPState TPState;
   midw_ext_fi_tclString StationNameFM;
   midw_ext_fi_tclString StationNameDAB;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bListUpdate;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_SRVLIST_NOTIFICATIONStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet();

   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet();

   inline tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus : public midw_ext_dabtunerfi_tclMsgBaseMessage
{
public:

   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& operator=(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& coRef);
   midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_ext_fi_tcl_DAB_ChnListElement, std::allocator<midw_ext_fi_tcl_DAB_ChnListElement> > AvailSrvList;
   virtual ~midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ext_dabtunerfi_tclMsgFID_DAB_G_LIST_UPDATEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
