/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_CLOCKFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_CLOCKFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_CLOCKFI_SERVICEINFO
#include "midw_ext_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_ext_clock_fi message types

fi_tclMessageBase* midw_ext_clockfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART:
         return OSAL_NEW midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart;

      case midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT:
         return OSAL_NEW midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult;

      case midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART:
         return OSAL_NEW midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart;

      case midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT:
         return OSAL_NEW midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult;

      case midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART:
         return OSAL_NEW midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart;

      case midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT:
         return OSAL_NEW midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult;

      case midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART:
         return OSAL_NEW midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart;

      case midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT:
         return OSAL_NEW midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeZoneGet;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESET:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeZoneSet;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeZoneUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONERELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeZoneRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeZoneStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgDaylightSavingTimeGet;

      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET:
         return OSAL_NEW midw_ext_clockfi_tclMsgDaylightSavingTimeSet;

      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgDaylightSavingTimeStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_AutoSyncGet;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSET:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_AutoSyncSet;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_AutoSyncStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgSyncModeGet;

      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESET:
         return OSAL_NEW midw_ext_clockfi_tclMsgSyncModeSet;

      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgSyncModeUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODERELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgSyncModeRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgSyncModeStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_WeekEpochGet;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_WeekEpochSet;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgGPS_WeekEpochStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeOffsetGet;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeOffsetStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeOffsetSet;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeDateUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeDateGet;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeDateStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESET:
         return OSAL_NEW midw_ext_clockfi_tclMsgLocalTimeDateSet;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeFormatUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeFormatRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeFormatGet;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeFormatStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSET:
         return OSAL_NEW midw_ext_clockfi_tclMsgTimeFormatSet;

      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgDateFormatUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgDateFormatRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgDateFormatGet;

      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgDateFormatStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSET:
         return OSAL_NEW midw_ext_clockfi_tclMsgDateFormatSet;

      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgClockSourceStatusUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgClockSourceStatusGet;

      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgClockSourceStatusStatus;

      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgFormatSourceStatusUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG:
         return OSAL_NEW midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg;

      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET:
         return OSAL_NEW midw_ext_clockfi_tclMsgFormatSourceStatusGet;

      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS:
         return OSAL_NEW midw_ext_clockfi_tclMsgFormatSourceStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ext_clockfifi messages

// common functions

tU16 midw_ext_clockfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_EXT_CLOCKFI_C_U16_SERVICE_ID;
}

tU16 midw_ext_clockfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ext_clockfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ext_clockfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ext_clockfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ext_clockfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ext_clockfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart::midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart()
 {}

tS32 midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART;
}


midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart::~midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   aszDescriptions = coRef.aszDescriptions;
   u16Indexes = coRef.u16Indexes;
}
midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::operator=(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   aszDescriptions = coRef.aszDescriptions;
   u16Indexes = coRef.u16Indexes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aszDescriptions.size(); ++u32Idx)
         aszDescriptions[u32Idx].vDestroy();
   aszDescriptions.clear();
   }
   {
   u16Indexes.clear();
   }
}

midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult()


 {}

tS32 midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT;
}


midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::~midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aszDescriptions.size(); ++u32ListIdx)
      u32DynamicSize += aszDescriptions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+ static_cast<tU32>(u16Indexes.size()*2);
}

fi_tclInContext& midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aszDescriptions.size(); ++u32Idx)
      {
         aszDescriptions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      aszDescriptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> aszDescriptions[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u16Indexes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u16Indexes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)aszDescriptions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < aszDescriptions.size(); ++u32Idx)
         (tVoid) (oOut << aszDescriptions[u32Idx]);
   }
   (tVoid) (oOut << (tU32)u16Indexes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u16Indexes.size(); ++u32Idx)
         (tVoid) (oOut << u16Indexes[u32Idx]);
   }
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult::operator==(const midw_ext_clockfi_tclMsgGetAvailableTimeZonesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (aszDescriptions.size() == roRef.aszDescriptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aszDescriptions.size()); ++u32Idx)
            bResult = bResult && (aszDescriptions[u32Idx] == roRef.aszDescriptions[u32Idx]);
      }
      bResult = bResult && (u16Indexes.size() == roRef.u16Indexes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u16Indexes.size()); ++u32Idx)
            bResult = bResult && (u16Indexes[u32Idx] == roRef.u16Indexes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   u32TimeDateValue = coRef.u32TimeDateValue;
   u8SourceDomain = coRef.u8SourceDomain;
   u8TargetDomain = coRef.u8TargetDomain;
}
midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::operator=(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32TimeDateValue = coRef.u32TimeDateValue;
   u8SourceDomain = coRef.u8SourceDomain;
   u8TargetDomain = coRef.u8TargetDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart()
:u32TimeDateValue(0)
,u8SourceDomain(1)
,u8TargetDomain(1)
 {}

tS32 midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART;
}


midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::~midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart()
{}

tU32 midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32TimeDateValue);
   (tVoid) (oIn >> u8SourceDomain);
   (tVoid) (oIn >> u8TargetDomain);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32TimeDateValue);
   (tVoid) (oOut << u8SourceDomain);
   (tVoid) (oOut << u8TargetDomain);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart::operator==(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32TimeDateValue == roRef.u32TimeDateValue);
   bResult = bResult && (u8SourceDomain == roRef.u8SourceDomain);
   bResult = bResult && (u8TargetDomain == roRef.u8TargetDomain);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
}
midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::operator=(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
 {}

tS32 midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT;
}


midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::~midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult()
{}

tU32 midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult::operator==(const midw_ext_clockfi_tclMsgGetTimeDateFromValueMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
}
midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::operator=(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart()
:s16Year(0)
,u8Month(0)
 {}

tS32 midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART;
}


midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::~midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart()
{}

tU32 midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart::operator==(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   u8NumberOfDays = coRef.u8NumberOfDays;
}
midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::operator=(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8NumberOfDays = coRef.u8NumberOfDays;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult()
:u8NumberOfDays(0)
 {}

tS32 midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT;
}


midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::~midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult()
{}

tU32 midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumberOfDays);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumberOfDays);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult::operator==(const midw_ext_clockfi_tclMsgGetDaysPerMonthMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumberOfDays == roRef.u8NumberOfDays);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::operator=(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart()
:DefSetStateGroup()
,DefSetStateMode()
 {}

tS32 midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART;
}


midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::~midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart()
{}

tU32 midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart::operator==(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   Status = coRef.Status;
}
midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::operator=(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult()
:DefSetStateGroup()
,DefSetStateMode()
,Status(0)
 {}

tS32 midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT;
}


midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::~midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult()
{}

tU32 midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult::operator==(const midw_ext_clockfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgTimeZoneGet::midw_ext_clockfi_tclMsgTimeZoneGet()
 {}

tS32 midw_ext_clockfi_tclMsgTimeZoneGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEGET;
}


midw_ext_clockfi_tclMsgTimeZoneGet::~midw_ext_clockfi_tclMsgTimeZoneGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgTimeZoneSet::midw_ext_clockfi_tclMsgTimeZoneSet(const midw_ext_clockfi_tclMsgTimeZoneSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   u16Index = coRef.u16Index;
}
midw_ext_clockfi_tclMsgTimeZoneSet& midw_ext_clockfi_tclMsgTimeZoneSet::operator=(const midw_ext_clockfi_tclMsgTimeZoneSet& coRef)
{
   if (this == &coRef) return *this;
   u16Index = coRef.u16Index;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgTimeZoneSet::midw_ext_clockfi_tclMsgTimeZoneSet()
:u16Index(0)
 {}

tS32 midw_ext_clockfi_tclMsgTimeZoneSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESET;
}


midw_ext_clockfi_tclMsgTimeZoneSet::~midw_ext_clockfi_tclMsgTimeZoneSet()
{}

tU32 midw_ext_clockfi_tclMsgTimeZoneSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_clockfi_tclMsgTimeZoneSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Index);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgTimeZoneSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Index);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgTimeZoneSet::operator==(const midw_ext_clockfi_tclMsgTimeZoneSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Index == roRef.u16Index);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgTimeZoneUpReg::midw_ext_clockfi_tclMsgTimeZoneUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgTimeZoneUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEUPREG;
}


midw_ext_clockfi_tclMsgTimeZoneUpReg::~midw_ext_clockfi_tclMsgTimeZoneUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgTimeZoneRelUpReg::midw_ext_clockfi_tclMsgTimeZoneRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgTimeZoneRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEZONERELUPREG;
}


midw_ext_clockfi_tclMsgTimeZoneRelUpReg::~midw_ext_clockfi_tclMsgTimeZoneRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgTimeZoneStatus::midw_ext_clockfi_tclMsgTimeZoneStatus(const midw_ext_clockfi_tclMsgTimeZoneStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   u16Index = coRef.u16Index;
   szDescription = coRef.szDescription;
}
midw_ext_clockfi_tclMsgTimeZoneStatus& midw_ext_clockfi_tclMsgTimeZoneStatus::operator=(const midw_ext_clockfi_tclMsgTimeZoneStatus& coRef)
{
   if (this == &coRef) return *this;
   u16Index = coRef.u16Index;
   szDescription = coRef.szDescription;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ext_clockfi_tclMsgTimeZoneStatus::vDestroy()
{
   szDescription.vDestroy();
}

midw_ext_clockfi_tclMsgTimeZoneStatus::midw_ext_clockfi_tclMsgTimeZoneStatus()
:u16Index(0)
,szDescription()
 {}

tS32 midw_ext_clockfi_tclMsgTimeZoneStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESTATUS;
}


midw_ext_clockfi_tclMsgTimeZoneStatus::~midw_ext_clockfi_tclMsgTimeZoneStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ext_clockfi_tclMsgTimeZoneStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ext_clockfi_tclMsgTimeZoneStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Index);
   (tVoid) (oIn >> szDescription);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgTimeZoneStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Index);
   (tVoid) (oOut << szDescription);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgTimeZoneStatus::operator==(const midw_ext_clockfi_tclMsgTimeZoneStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Index == roRef.u16Index);
   bResult = bResult && (szDescription == roRef.szDescription);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgDaylightSavingTimeGet::midw_ext_clockfi_tclMsgDaylightSavingTimeGet()
 {}

tS32 midw_ext_clockfi_tclMsgDaylightSavingTimeGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET;
}


midw_ext_clockfi_tclMsgDaylightSavingTimeGet::~midw_ext_clockfi_tclMsgDaylightSavingTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgDaylightSavingTimeSet::midw_ext_clockfi_tclMsgDaylightSavingTimeSet(const midw_ext_clockfi_tclMsgDaylightSavingTimeSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enDST_Setting = coRef.enDST_Setting;
}
midw_ext_clockfi_tclMsgDaylightSavingTimeSet& midw_ext_clockfi_tclMsgDaylightSavingTimeSet::operator=(const midw_ext_clockfi_tclMsgDaylightSavingTimeSet& coRef)
{
   if (this == &coRef) return *this;
   enDST_Setting = coRef.enDST_Setting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgDaylightSavingTimeSet::midw_ext_clockfi_tclMsgDaylightSavingTimeSet()
:enDST_Setting()
 {}

tS32 midw_ext_clockfi_tclMsgDaylightSavingTimeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET;
}


midw_ext_clockfi_tclMsgDaylightSavingTimeSet::~midw_ext_clockfi_tclMsgDaylightSavingTimeSet()
{}

tU32 midw_ext_clockfi_tclMsgDaylightSavingTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgDaylightSavingTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDST_Setting);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgDaylightSavingTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDST_Setting);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgDaylightSavingTimeSet::operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDST_Setting == roRef.enDST_Setting);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg::midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG;
}


midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg::~midw_ext_clockfi_tclMsgDaylightSavingTimeUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg::midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG;
}


midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg::~midw_ext_clockfi_tclMsgDaylightSavingTimeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::midw_ext_clockfi_tclMsgDaylightSavingTimeStatus(const midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   bDST_Status = coRef.bDST_Status;
   bDST_AutoAdjust = coRef.bDST_AutoAdjust;
   enDST_Status = coRef.enDST_Status;
}
midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::operator=(const midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   bDST_Status = coRef.bDST_Status;
   bDST_AutoAdjust = coRef.bDST_AutoAdjust;
   enDST_Status = coRef.enDST_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::midw_ext_clockfi_tclMsgDaylightSavingTimeStatus()
:bDST_Status(0)
,bDST_AutoAdjust(0)
,enDST_Status()
 {}

tS32 midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS;
}


midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::~midw_ext_clockfi_tclMsgDaylightSavingTimeStatus()
{}

tU32 midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDST_Status);
   (tVoid) (oIn >> bDST_AutoAdjust);
   (tVoid) (oIn >> enDST_Status);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDST_Status);
   (tVoid) (oOut << bDST_AutoAdjust);
   (tVoid) (oOut << enDST_Status);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgDaylightSavingTimeStatus::operator==(const midw_ext_clockfi_tclMsgDaylightSavingTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDST_Status == roRef.bDST_Status);
   bResult = bResult && (bDST_AutoAdjust == roRef.bDST_AutoAdjust);
   bResult = bResult && (enDST_Status == roRef.enDST_Status);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgGPS_AutoSyncGet::midw_ext_clockfi_tclMsgGPS_AutoSyncGet()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_AutoSyncGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCGET;
}


midw_ext_clockfi_tclMsgGPS_AutoSyncGet::~midw_ext_clockfi_tclMsgGPS_AutoSyncGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGPS_AutoSyncSet::midw_ext_clockfi_tclMsgGPS_AutoSyncSet(const midw_ext_clockfi_tclMsgGPS_AutoSyncSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
}
midw_ext_clockfi_tclMsgGPS_AutoSyncSet& midw_ext_clockfi_tclMsgGPS_AutoSyncSet::operator=(const midw_ext_clockfi_tclMsgGPS_AutoSyncSet& coRef)
{
   if (this == &coRef) return *this;
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGPS_AutoSyncSet::midw_ext_clockfi_tclMsgGPS_AutoSyncSet()
:bEnabled(0)
,bPositionBased(0)
 {}

tS32 midw_ext_clockfi_tclMsgGPS_AutoSyncSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSET;
}


midw_ext_clockfi_tclMsgGPS_AutoSyncSet::~midw_ext_clockfi_tclMsgGPS_AutoSyncSet()
{}

tU32 midw_ext_clockfi_tclMsgGPS_AutoSyncSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGPS_AutoSyncSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnabled);
   (tVoid) (oIn >> bPositionBased);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGPS_AutoSyncSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnabled);
   (tVoid) (oOut << bPositionBased);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGPS_AutoSyncSet::operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnabled == roRef.bEnabled);
   bResult = bResult && (bPositionBased == roRef.bPositionBased);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg::midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG;
}


midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg::~midw_ext_clockfi_tclMsgGPS_AutoSyncUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg::midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG;
}


midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg::~midw_ext_clockfi_tclMsgGPS_AutoSyncRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::midw_ext_clockfi_tclMsgGPS_AutoSyncStatus(const midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
}
midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::operator=(const midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& coRef)
{
   if (this == &coRef) return *this;
   bEnabled = coRef.bEnabled;
   bPositionBased = coRef.bPositionBased;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::midw_ext_clockfi_tclMsgGPS_AutoSyncStatus()
:bEnabled(0)
,bPositionBased(0)
 {}

tS32 midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS;
}


midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::~midw_ext_clockfi_tclMsgGPS_AutoSyncStatus()
{}

tU32 midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnabled);
   (tVoid) (oIn >> bPositionBased);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnabled);
   (tVoid) (oOut << bPositionBased);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGPS_AutoSyncStatus::operator==(const midw_ext_clockfi_tclMsgGPS_AutoSyncStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnabled == roRef.bEnabled);
   bResult = bResult && (bPositionBased == roRef.bPositionBased);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgSyncModeGet::midw_ext_clockfi_tclMsgSyncModeGet()
 {}

tS32 midw_ext_clockfi_tclMsgSyncModeGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEGET;
}


midw_ext_clockfi_tclMsgSyncModeGet::~midw_ext_clockfi_tclMsgSyncModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgSyncModeSet::midw_ext_clockfi_tclMsgSyncModeSet(const midw_ext_clockfi_tclMsgSyncModeSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enMode = coRef.enMode;
}
midw_ext_clockfi_tclMsgSyncModeSet& midw_ext_clockfi_tclMsgSyncModeSet::operator=(const midw_ext_clockfi_tclMsgSyncModeSet& coRef)
{
   if (this == &coRef) return *this;
   enMode = coRef.enMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgSyncModeSet::midw_ext_clockfi_tclMsgSyncModeSet()
:enMode()
 {}

tS32 midw_ext_clockfi_tclMsgSyncModeSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESET;
}


midw_ext_clockfi_tclMsgSyncModeSet::~midw_ext_clockfi_tclMsgSyncModeSet()
{}

tU32 midw_ext_clockfi_tclMsgSyncModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgSyncModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enMode);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgSyncModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enMode);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgSyncModeSet::operator==(const midw_ext_clockfi_tclMsgSyncModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enMode == roRef.enMode);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgSyncModeUpReg::midw_ext_clockfi_tclMsgSyncModeUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgSyncModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEUPREG;
}


midw_ext_clockfi_tclMsgSyncModeUpReg::~midw_ext_clockfi_tclMsgSyncModeUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgSyncModeRelUpReg::midw_ext_clockfi_tclMsgSyncModeRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgSyncModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_SYNCMODERELUPREG;
}


midw_ext_clockfi_tclMsgSyncModeRelUpReg::~midw_ext_clockfi_tclMsgSyncModeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgSyncModeStatus::midw_ext_clockfi_tclMsgSyncModeStatus(const midw_ext_clockfi_tclMsgSyncModeStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enMode = coRef.enMode;
}
midw_ext_clockfi_tclMsgSyncModeStatus& midw_ext_clockfi_tclMsgSyncModeStatus::operator=(const midw_ext_clockfi_tclMsgSyncModeStatus& coRef)
{
   if (this == &coRef) return *this;
   enMode = coRef.enMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgSyncModeStatus::midw_ext_clockfi_tclMsgSyncModeStatus()
:enMode()
 {}

tS32 midw_ext_clockfi_tclMsgSyncModeStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESTATUS;
}


midw_ext_clockfi_tclMsgSyncModeStatus::~midw_ext_clockfi_tclMsgSyncModeStatus()
{}

tU32 midw_ext_clockfi_tclMsgSyncModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgSyncModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enMode);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgSyncModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enMode);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgSyncModeStatus::operator==(const midw_ext_clockfi_tclMsgSyncModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enMode == roRef.enMode);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgGPS_WeekEpochGet::midw_ext_clockfi_tclMsgGPS_WeekEpochGet()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_WeekEpochGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET;
}


midw_ext_clockfi_tclMsgGPS_WeekEpochGet::~midw_ext_clockfi_tclMsgGPS_WeekEpochGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGPS_WeekEpochSet::midw_ext_clockfi_tclMsgGPS_WeekEpochSet(const midw_ext_clockfi_tclMsgGPS_WeekEpochSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   GPSepoch = coRef.GPSepoch;
}
midw_ext_clockfi_tclMsgGPS_WeekEpochSet& midw_ext_clockfi_tclMsgGPS_WeekEpochSet::operator=(const midw_ext_clockfi_tclMsgGPS_WeekEpochSet& coRef)
{
   if (this == &coRef) return *this;
   GPSepoch = coRef.GPSepoch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGPS_WeekEpochSet::midw_ext_clockfi_tclMsgGPS_WeekEpochSet()
:GPSepoch()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_WeekEpochSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET;
}


midw_ext_clockfi_tclMsgGPS_WeekEpochSet::~midw_ext_clockfi_tclMsgGPS_WeekEpochSet()
{}

tU32 midw_ext_clockfi_tclMsgGPS_WeekEpochSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGPS_WeekEpochSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GPSepoch);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGPS_WeekEpochSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GPSepoch);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGPS_WeekEpochSet::operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GPSepoch == roRef.GPSepoch);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg::midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG;
}


midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg::~midw_ext_clockfi_tclMsgGPS_WeekEpochUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg::midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG;
}


midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg::~midw_ext_clockfi_tclMsgGPS_WeekEpochRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::midw_ext_clockfi_tclMsgGPS_WeekEpochStatus(const midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   GPSepoch = coRef.GPSepoch;
}
midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::operator=(const midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& coRef)
{
   if (this == &coRef) return *this;
   GPSepoch = coRef.GPSepoch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::midw_ext_clockfi_tclMsgGPS_WeekEpochStatus()
:GPSepoch()
 {}

tS32 midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS;
}


midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::~midw_ext_clockfi_tclMsgGPS_WeekEpochStatus()
{}

tU32 midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GPSepoch);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GPSepoch);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgGPS_WeekEpochStatus::operator==(const midw_ext_clockfi_tclMsgGPS_WeekEpochStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GPSepoch == roRef.GPSepoch);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg::midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG;
}


midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg::~midw_ext_clockfi_tclMsgLocalTimeOffsetUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg::midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG;
}


midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg::~midw_ext_clockfi_tclMsgLocalTimeOffsetRelUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgLocalTimeOffsetGet::midw_ext_clockfi_tclMsgLocalTimeOffsetGet()
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeOffsetGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET;
}


midw_ext_clockfi_tclMsgLocalTimeOffsetGet::~midw_ext_clockfi_tclMsgLocalTimeOffsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::midw_ext_clockfi_tclMsgLocalTimeOffsetStatus(const midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   s64Offset_ScalarValue = coRef.s64Offset_ScalarValue;
   bIsOffsetPostive = coRef.bIsOffsetPostive;
   s16Offset_Year = coRef.s16Offset_Year;
   u8Offset_Month = coRef.u8Offset_Month;
   u8Offset_Day = coRef.u8Offset_Day;
   u8Offset_Hour = coRef.u8Offset_Hour;
   u8Offset_Minute = coRef.u8Offset_Minute;
   u8Offset_Second = coRef.u8Offset_Second;
   u32UTCTimeDate_ScalarValue = coRef.u32UTCTimeDate_ScalarValue;
   s16UTCTimeDate_Year = coRef.s16UTCTimeDate_Year;
   u8UTCTimeDate_Month = coRef.u8UTCTimeDate_Month;
   u8UTCTimeDate_Day = coRef.u8UTCTimeDate_Day;
   u8UTCTimeDate_Hour = coRef.u8UTCTimeDate_Hour;
   u8UTCTimeDate_Minute = coRef.u8UTCTimeDate_Minute;
   u8UTCTimeDate_Second = coRef.u8UTCTimeDate_Second;
   u8UTCTimeDate_Weekday = coRef.u8UTCTimeDate_Weekday;
   enGpsRtcTimeState = coRef.enGpsRtcTimeState;
}
midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::operator=(const midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& coRef)
{
   if (this == &coRef) return *this;
   s64Offset_ScalarValue = coRef.s64Offset_ScalarValue;
   bIsOffsetPostive = coRef.bIsOffsetPostive;
   s16Offset_Year = coRef.s16Offset_Year;
   u8Offset_Month = coRef.u8Offset_Month;
   u8Offset_Day = coRef.u8Offset_Day;
   u8Offset_Hour = coRef.u8Offset_Hour;
   u8Offset_Minute = coRef.u8Offset_Minute;
   u8Offset_Second = coRef.u8Offset_Second;
   u32UTCTimeDate_ScalarValue = coRef.u32UTCTimeDate_ScalarValue;
   s16UTCTimeDate_Year = coRef.s16UTCTimeDate_Year;
   u8UTCTimeDate_Month = coRef.u8UTCTimeDate_Month;
   u8UTCTimeDate_Day = coRef.u8UTCTimeDate_Day;
   u8UTCTimeDate_Hour = coRef.u8UTCTimeDate_Hour;
   u8UTCTimeDate_Minute = coRef.u8UTCTimeDate_Minute;
   u8UTCTimeDate_Second = coRef.u8UTCTimeDate_Second;
   u8UTCTimeDate_Weekday = coRef.u8UTCTimeDate_Weekday;
   enGpsRtcTimeState = coRef.enGpsRtcTimeState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::midw_ext_clockfi_tclMsgLocalTimeOffsetStatus()
:s64Offset_ScalarValue(0)
,bIsOffsetPostive(0)
,s16Offset_Year(0)
,u8Offset_Month(0)
,u8Offset_Day(0)
,u8Offset_Hour(0)
,u8Offset_Minute(0)
,u8Offset_Second(0)
,u32UTCTimeDate_ScalarValue(0)
,s16UTCTimeDate_Year(0)
,u8UTCTimeDate_Month(0)
,u8UTCTimeDate_Day(0)
,u8UTCTimeDate_Hour(0)
,u8UTCTimeDate_Minute(0)
,u8UTCTimeDate_Second(0)
,u8UTCTimeDate_Weekday(0)
,enGpsRtcTimeState()
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS;
}


midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::~midw_ext_clockfi_tclMsgLocalTimeOffsetStatus()
{}

tU32 midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29;
}

fi_tclInContext& midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s64Offset_ScalarValue);
   (tVoid) (oIn >> bIsOffsetPostive);
   (tVoid) (oIn >> s16Offset_Year);
   (tVoid) (oIn >> u8Offset_Month);
   (tVoid) (oIn >> u8Offset_Day);
   (tVoid) (oIn >> u8Offset_Hour);
   (tVoid) (oIn >> u8Offset_Minute);
   (tVoid) (oIn >> u8Offset_Second);
   (tVoid) (oIn >> u32UTCTimeDate_ScalarValue);
   (tVoid) (oIn >> s16UTCTimeDate_Year);
   (tVoid) (oIn >> u8UTCTimeDate_Month);
   (tVoid) (oIn >> u8UTCTimeDate_Day);
   (tVoid) (oIn >> u8UTCTimeDate_Hour);
   (tVoid) (oIn >> u8UTCTimeDate_Minute);
   (tVoid) (oIn >> u8UTCTimeDate_Second);
   (tVoid) (oIn >> u8UTCTimeDate_Weekday);
   (tVoid) (oIn >> enGpsRtcTimeState);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s64Offset_ScalarValue);
   (tVoid) (oOut << bIsOffsetPostive);
   (tVoid) (oOut << s16Offset_Year);
   (tVoid) (oOut << u8Offset_Month);
   (tVoid) (oOut << u8Offset_Day);
   (tVoid) (oOut << u8Offset_Hour);
   (tVoid) (oOut << u8Offset_Minute);
   (tVoid) (oOut << u8Offset_Second);
   (tVoid) (oOut << u32UTCTimeDate_ScalarValue);
   (tVoid) (oOut << s16UTCTimeDate_Year);
   (tVoid) (oOut << u8UTCTimeDate_Month);
   (tVoid) (oOut << u8UTCTimeDate_Day);
   (tVoid) (oOut << u8UTCTimeDate_Hour);
   (tVoid) (oOut << u8UTCTimeDate_Minute);
   (tVoid) (oOut << u8UTCTimeDate_Second);
   (tVoid) (oOut << u8UTCTimeDate_Weekday);
   (tVoid) (oOut << enGpsRtcTimeState);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgLocalTimeOffsetStatus::operator==(const midw_ext_clockfi_tclMsgLocalTimeOffsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s64Offset_ScalarValue == roRef.s64Offset_ScalarValue);
   bResult = bResult && (bIsOffsetPostive == roRef.bIsOffsetPostive);
   bResult = bResult && (s16Offset_Year == roRef.s16Offset_Year);
   bResult = bResult && (u8Offset_Month == roRef.u8Offset_Month);
   bResult = bResult && (u8Offset_Day == roRef.u8Offset_Day);
   bResult = bResult && (u8Offset_Hour == roRef.u8Offset_Hour);
   bResult = bResult && (u8Offset_Minute == roRef.u8Offset_Minute);
   bResult = bResult && (u8Offset_Second == roRef.u8Offset_Second);
   bResult = bResult && (u32UTCTimeDate_ScalarValue == roRef.u32UTCTimeDate_ScalarValue);
   bResult = bResult && (s16UTCTimeDate_Year == roRef.s16UTCTimeDate_Year);
   bResult = bResult && (u8UTCTimeDate_Month == roRef.u8UTCTimeDate_Month);
   bResult = bResult && (u8UTCTimeDate_Day == roRef.u8UTCTimeDate_Day);
   bResult = bResult && (u8UTCTimeDate_Hour == roRef.u8UTCTimeDate_Hour);
   bResult = bResult && (u8UTCTimeDate_Minute == roRef.u8UTCTimeDate_Minute);
   bResult = bResult && (u8UTCTimeDate_Second == roRef.u8UTCTimeDate_Second);
   bResult = bResult && (u8UTCTimeDate_Weekday == roRef.u8UTCTimeDate_Weekday);
   bResult = bResult && (enGpsRtcTimeState == roRef.enGpsRtcTimeState);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgLocalTimeOffsetSet::midw_ext_clockfi_tclMsgLocalTimeOffsetSet()
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeOffsetSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET;
}


midw_ext_clockfi_tclMsgLocalTimeOffsetSet::~midw_ext_clockfi_tclMsgLocalTimeOffsetSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgLocalTimeDateUpReg::midw_ext_clockfi_tclMsgLocalTimeDateUpReg(const midw_ext_clockfi_tclMsgLocalTimeDateUpReg& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   u8UpdatePeriod = coRef.u8UpdatePeriod;
}
midw_ext_clockfi_tclMsgLocalTimeDateUpReg& midw_ext_clockfi_tclMsgLocalTimeDateUpReg::operator=(const midw_ext_clockfi_tclMsgLocalTimeDateUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8UpdatePeriod = coRef.u8UpdatePeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgLocalTimeDateUpReg::midw_ext_clockfi_tclMsgLocalTimeDateUpReg()
:u8UpdatePeriod(0)
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeDateUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG;
}


midw_ext_clockfi_tclMsgLocalTimeDateUpReg::~midw_ext_clockfi_tclMsgLocalTimeDateUpReg()
{}

tU32 midw_ext_clockfi_tclMsgLocalTimeDateUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgLocalTimeDateUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8UpdatePeriod);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgLocalTimeDateUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8UpdatePeriod);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgLocalTimeDateUpReg::operator==(const midw_ext_clockfi_tclMsgLocalTimeDateUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8UpdatePeriod == roRef.u8UpdatePeriod);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg(const midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   u8UpdatePeriod = coRef.u8UpdatePeriod;
}
midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::operator=(const midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   u8UpdatePeriod = coRef.u8UpdatePeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg()
:u8UpdatePeriod(0)
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG;
}


midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::~midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg()
{}

tU32 midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8UpdatePeriod);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8UpdatePeriod);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg::operator==(const midw_ext_clockfi_tclMsgLocalTimeDateRelUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8UpdatePeriod == roRef.u8UpdatePeriod);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgLocalTimeDateGet::midw_ext_clockfi_tclMsgLocalTimeDateGet()
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeDateGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEGET;
}


midw_ext_clockfi_tclMsgLocalTimeDateGet::~midw_ext_clockfi_tclMsgLocalTimeDateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgLocalTimeDateStatus::midw_ext_clockfi_tclMsgLocalTimeDateStatus(const midw_ext_clockfi_tclMsgLocalTimeDateStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8TimeDateStatus = coRef.u8TimeDateStatus;
   u32TimeDateValue = coRef.u32TimeDateValue;
}
midw_ext_clockfi_tclMsgLocalTimeDateStatus& midw_ext_clockfi_tclMsgLocalTimeDateStatus::operator=(const midw_ext_clockfi_tclMsgLocalTimeDateStatus& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8TimeDateStatus = coRef.u8TimeDateStatus;
   u32TimeDateValue = coRef.u32TimeDateValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgLocalTimeDateStatus::midw_ext_clockfi_tclMsgLocalTimeDateStatus()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,u8TimeDateStatus(0)
,u32TimeDateValue(0)
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeDateStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS;
}


midw_ext_clockfi_tclMsgLocalTimeDateStatus::~midw_ext_clockfi_tclMsgLocalTimeDateStatus()
{}

tU32 midw_ext_clockfi_tclMsgLocalTimeDateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& midw_ext_clockfi_tclMsgLocalTimeDateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> u8TimeDateStatus);
   (tVoid) (oIn >> u32TimeDateValue);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgLocalTimeDateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << u8TimeDateStatus);
   (tVoid) (oOut << u32TimeDateValue);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgLocalTimeDateStatus::operator==(const midw_ext_clockfi_tclMsgLocalTimeDateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (u8TimeDateStatus == roRef.u8TimeDateStatus);
   bResult = bResult && (u32TimeDateValue == roRef.u32TimeDateValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgLocalTimeDateSet::midw_ext_clockfi_tclMsgLocalTimeDateSet(const midw_ext_clockfi_tclMsgLocalTimeDateSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8ChangeMask = coRef.u8ChangeMask;
}
midw_ext_clockfi_tclMsgLocalTimeDateSet& midw_ext_clockfi_tclMsgLocalTimeDateSet::operator=(const midw_ext_clockfi_tclMsgLocalTimeDateSet& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hours = coRef.u8Hours;
   u8Minutes = coRef.u8Minutes;
   u8Seconds = coRef.u8Seconds;
   u8Weekday = coRef.u8Weekday;
   u8ChangeMask = coRef.u8ChangeMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgLocalTimeDateSet::midw_ext_clockfi_tclMsgLocalTimeDateSet()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hours(0)
,u8Minutes(0)
,u8Seconds(0)
,u8Weekday(0)
,u8ChangeMask(0)
 {}

tS32 midw_ext_clockfi_tclMsgLocalTimeDateSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESET;
}


midw_ext_clockfi_tclMsgLocalTimeDateSet::~midw_ext_clockfi_tclMsgLocalTimeDateSet()
{}

tU32 midw_ext_clockfi_tclMsgLocalTimeDateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& midw_ext_clockfi_tclMsgLocalTimeDateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hours);
   (tVoid) (oIn >> u8Minutes);
   (tVoid) (oIn >> u8Seconds);
   (tVoid) (oIn >> u8Weekday);
   (tVoid) (oIn >> u8ChangeMask);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgLocalTimeDateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hours);
   (tVoid) (oOut << u8Minutes);
   (tVoid) (oOut << u8Seconds);
   (tVoid) (oOut << u8Weekday);
   (tVoid) (oOut << u8ChangeMask);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgLocalTimeDateSet::operator==(const midw_ext_clockfi_tclMsgLocalTimeDateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hours == roRef.u8Hours);
   bResult = bResult && (u8Minutes == roRef.u8Minutes);
   bResult = bResult && (u8Seconds == roRef.u8Seconds);
   bResult = bResult && (u8Weekday == roRef.u8Weekday);
   bResult = bResult && (u8ChangeMask == roRef.u8ChangeMask);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgTimeFormatUpReg::midw_ext_clockfi_tclMsgTimeFormatUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgTimeFormatUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATUPREG;
}


midw_ext_clockfi_tclMsgTimeFormatUpReg::~midw_ext_clockfi_tclMsgTimeFormatUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgTimeFormatRelUpReg::midw_ext_clockfi_tclMsgTimeFormatRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgTimeFormatRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATRELUPREG;
}


midw_ext_clockfi_tclMsgTimeFormatRelUpReg::~midw_ext_clockfi_tclMsgTimeFormatRelUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgTimeFormatGet::midw_ext_clockfi_tclMsgTimeFormatGet()
 {}

tS32 midw_ext_clockfi_tclMsgTimeFormatGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATGET;
}


midw_ext_clockfi_tclMsgTimeFormatGet::~midw_ext_clockfi_tclMsgTimeFormatGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgTimeFormatStatus::midw_ext_clockfi_tclMsgTimeFormatStatus(const midw_ext_clockfi_tclMsgTimeFormatStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enTimeFormat = coRef.enTimeFormat;
}
midw_ext_clockfi_tclMsgTimeFormatStatus& midw_ext_clockfi_tclMsgTimeFormatStatus::operator=(const midw_ext_clockfi_tclMsgTimeFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   enTimeFormat = coRef.enTimeFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgTimeFormatStatus::midw_ext_clockfi_tclMsgTimeFormatStatus()
:enTimeFormat()
 {}

tS32 midw_ext_clockfi_tclMsgTimeFormatStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSTATUS;
}


midw_ext_clockfi_tclMsgTimeFormatStatus::~midw_ext_clockfi_tclMsgTimeFormatStatus()
{}

tU32 midw_ext_clockfi_tclMsgTimeFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgTimeFormatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTimeFormat);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgTimeFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTimeFormat);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgTimeFormatStatus::operator==(const midw_ext_clockfi_tclMsgTimeFormatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTimeFormat == roRef.enTimeFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgTimeFormatSet::midw_ext_clockfi_tclMsgTimeFormatSet(const midw_ext_clockfi_tclMsgTimeFormatSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enTimeFormat = coRef.enTimeFormat;
}
midw_ext_clockfi_tclMsgTimeFormatSet& midw_ext_clockfi_tclMsgTimeFormatSet::operator=(const midw_ext_clockfi_tclMsgTimeFormatSet& coRef)
{
   if (this == &coRef) return *this;
   enTimeFormat = coRef.enTimeFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgTimeFormatSet::midw_ext_clockfi_tclMsgTimeFormatSet()
:enTimeFormat()
 {}

tS32 midw_ext_clockfi_tclMsgTimeFormatSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSET;
}


midw_ext_clockfi_tclMsgTimeFormatSet::~midw_ext_clockfi_tclMsgTimeFormatSet()
{}

tU32 midw_ext_clockfi_tclMsgTimeFormatSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgTimeFormatSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enTimeFormat);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgTimeFormatSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enTimeFormat);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgTimeFormatSet::operator==(const midw_ext_clockfi_tclMsgTimeFormatSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enTimeFormat == roRef.enTimeFormat);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgDateFormatUpReg::midw_ext_clockfi_tclMsgDateFormatUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgDateFormatUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATUPREG;
}


midw_ext_clockfi_tclMsgDateFormatUpReg::~midw_ext_clockfi_tclMsgDateFormatUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgDateFormatRelUpReg::midw_ext_clockfi_tclMsgDateFormatRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgDateFormatRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATRELUPREG;
}


midw_ext_clockfi_tclMsgDateFormatRelUpReg::~midw_ext_clockfi_tclMsgDateFormatRelUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgDateFormatGet::midw_ext_clockfi_tclMsgDateFormatGet()
 {}

tS32 midw_ext_clockfi_tclMsgDateFormatGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATGET;
}


midw_ext_clockfi_tclMsgDateFormatGet::~midw_ext_clockfi_tclMsgDateFormatGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgDateFormatStatus::midw_ext_clockfi_tclMsgDateFormatStatus(const midw_ext_clockfi_tclMsgDateFormatStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enDateFormat = coRef.enDateFormat;
}
midw_ext_clockfi_tclMsgDateFormatStatus& midw_ext_clockfi_tclMsgDateFormatStatus::operator=(const midw_ext_clockfi_tclMsgDateFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   enDateFormat = coRef.enDateFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgDateFormatStatus::midw_ext_clockfi_tclMsgDateFormatStatus()
:enDateFormat()
 {}

tS32 midw_ext_clockfi_tclMsgDateFormatStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSTATUS;
}


midw_ext_clockfi_tclMsgDateFormatStatus::~midw_ext_clockfi_tclMsgDateFormatStatus()
{}

tU32 midw_ext_clockfi_tclMsgDateFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgDateFormatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDateFormat);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgDateFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDateFormat);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgDateFormatStatus::operator==(const midw_ext_clockfi_tclMsgDateFormatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDateFormat == roRef.enDateFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgDateFormatSet::midw_ext_clockfi_tclMsgDateFormatSet(const midw_ext_clockfi_tclMsgDateFormatSet& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enDateFormat = coRef.enDateFormat;
}
midw_ext_clockfi_tclMsgDateFormatSet& midw_ext_clockfi_tclMsgDateFormatSet::operator=(const midw_ext_clockfi_tclMsgDateFormatSet& coRef)
{
   if (this == &coRef) return *this;
   enDateFormat = coRef.enDateFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgDateFormatSet::midw_ext_clockfi_tclMsgDateFormatSet()
:enDateFormat()
 {}

tS32 midw_ext_clockfi_tclMsgDateFormatSet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSET;
}


midw_ext_clockfi_tclMsgDateFormatSet::~midw_ext_clockfi_tclMsgDateFormatSet()
{}

tU32 midw_ext_clockfi_tclMsgDateFormatSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgDateFormatSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enDateFormat);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgDateFormatSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enDateFormat);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgDateFormatSet::operator==(const midw_ext_clockfi_tclMsgDateFormatSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enDateFormat == roRef.enDateFormat);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgClockSourceStatusUpReg::midw_ext_clockfi_tclMsgClockSourceStatusUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgClockSourceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG;
}


midw_ext_clockfi_tclMsgClockSourceStatusUpReg::~midw_ext_clockfi_tclMsgClockSourceStatusUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg::midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG;
}


midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg::~midw_ext_clockfi_tclMsgClockSourceStatusRelUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgClockSourceStatusGet::midw_ext_clockfi_tclMsgClockSourceStatusGet()
 {}

tS32 midw_ext_clockfi_tclMsgClockSourceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET;
}


midw_ext_clockfi_tclMsgClockSourceStatusGet::~midw_ext_clockfi_tclMsgClockSourceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgClockSourceStatusStatus::midw_ext_clockfi_tclMsgClockSourceStatusStatus(const midw_ext_clockfi_tclMsgClockSourceStatusStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enSourcesValid = coRef.enSourcesValid;
}
midw_ext_clockfi_tclMsgClockSourceStatusStatus& midw_ext_clockfi_tclMsgClockSourceStatusStatus::operator=(const midw_ext_clockfi_tclMsgClockSourceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   enSourcesValid = coRef.enSourcesValid;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgClockSourceStatusStatus::midw_ext_clockfi_tclMsgClockSourceStatusStatus()
:enSourcesValid()
 {}

tS32 midw_ext_clockfi_tclMsgClockSourceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS;
}


midw_ext_clockfi_tclMsgClockSourceStatusStatus::~midw_ext_clockfi_tclMsgClockSourceStatusStatus()
{}

tU32 midw_ext_clockfi_tclMsgClockSourceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgClockSourceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enSourcesValid);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgClockSourceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enSourcesValid);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgClockSourceStatusStatus::operator==(const midw_ext_clockfi_tclMsgClockSourceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enSourcesValid == roRef.enSourcesValid);
   return bResult;
}

//=============================================================================

midw_ext_clockfi_tclMsgFormatSourceStatusUpReg::midw_ext_clockfi_tclMsgFormatSourceStatusUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgFormatSourceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG;
}


midw_ext_clockfi_tclMsgFormatSourceStatusUpReg::~midw_ext_clockfi_tclMsgFormatSourceStatusUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg::midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg()
 {}

tS32 midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG;
}


midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg::~midw_ext_clockfi_tclMsgFormatSourceStatusRelUpReg()
{}

//=============================================================================

midw_ext_clockfi_tclMsgFormatSourceStatusGet::midw_ext_clockfi_tclMsgFormatSourceStatusGet()
 {}

tS32 midw_ext_clockfi_tclMsgFormatSourceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET;
}


midw_ext_clockfi_tclMsgFormatSourceStatusGet::~midw_ext_clockfi_tclMsgFormatSourceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ext_clockfi_tclMsgFormatSourceStatusStatus::midw_ext_clockfi_tclMsgFormatSourceStatusStatus(const midw_ext_clockfi_tclMsgFormatSourceStatusStatus& coRef)
   : midw_ext_clockfi_tclMsgBaseMessage(coRef)
{
   enFormatSourceStatus = coRef.enFormatSourceStatus;
}
midw_ext_clockfi_tclMsgFormatSourceStatusStatus& midw_ext_clockfi_tclMsgFormatSourceStatusStatus::operator=(const midw_ext_clockfi_tclMsgFormatSourceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   enFormatSourceStatus = coRef.enFormatSourceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ext_clockfi_tclMsgFormatSourceStatusStatus::midw_ext_clockfi_tclMsgFormatSourceStatusStatus()
:enFormatSourceStatus()
 {}

tS32 midw_ext_clockfi_tclMsgFormatSourceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS;
}


midw_ext_clockfi_tclMsgFormatSourceStatusStatus::~midw_ext_clockfi_tclMsgFormatSourceStatusStatus()
{}

tU32 midw_ext_clockfi_tclMsgFormatSourceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ext_clockfi_tclMsgFormatSourceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enFormatSourceStatus);
   return oIn;
}

fi_tclOutContext& midw_ext_clockfi_tclMsgFormatSourceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enFormatSourceStatus);
   return oOut;
}

tBool midw_ext_clockfi_tclMsgFormatSourceStatusStatus::operator==(const midw_ext_clockfi_tclMsgFormatSourceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enFormatSourceStatus == roRef.enFormatSourceStatus);
   return bResult;
}

