#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_CLOCKFI_STDVISITORS
#include "midw_ext_fi_gen_if.h"

tBool midw_ext_clockfi_tclDescription::bInitMessage(midw_ext_clockfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case midw_ext_clockfi_tclToken::EN_LAST_TOKEN:
   case midw_ext_clockfi_tclToken::EN_LIST:
   case midw_ext_clockfi_tclToken::EN_END_OF_STRUCT:
   case midw_ext_clockfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U16,midw_ext_clockfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_LIST,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U16INDEXES)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_STRING,midw_ext_clockfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_LIST,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ASZDESCRIPTIONS)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8TARGETDOMAIN)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8SOURCEDOMAIN)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U32,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U32TIMEDATEVALUE)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8NUMBEROFDAYS)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_E8_DEFSETMODE,midw_ext_clockfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_E8_DEFSETGROUPS,midw_ext_clockfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_E8_DEFSETMODE,midw_ext_clockfi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_E8_DEFSETGROUPS,midw_ext_clockfi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U16INDEX)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_STRING,midw_ext_clockfi_tclSemanticDomain::EN_MSG_SZDESCRIPTION)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U16INDEX)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_DST_SETTING,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENDST_SETTING)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_DST_SETTING,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENDST_STATUS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BDST_AUTOADJUST)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BDST_STATUS)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BPOSITIONBASED)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BENABLED)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BPOSITIONBASED)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BENABLED)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_SYNCMODE,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENMODE)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_SYNCMODE,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENMODE)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_GPS_EPOCH,midw_ext_clockfi_tclSemanticDomain::EN_MSG_GPSEPOCH)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_GPS_EPOCH,midw_ext_clockfi_tclSemanticDomain::EN_MSG_GPSEPOCH)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_GPSRTCTIMESTATE,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENGPSRTCTIMESTATE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_SECOND)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_MINUTE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_HOUR)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_DAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UTCTIMEDATE_MONTH)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S16UTCTIMEDATE_YEAR)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U32,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U32UTCTIMEDATE_SCALARVALUE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8OFFSET_SECOND)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8OFFSET_MINUTE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8OFFSET_HOUR)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8OFFSET_DAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8OFFSET_MONTH)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S16OFFSET_YEAR)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_BOOL,midw_ext_clockfi_tclSemanticDomain::EN_MSG_BISOFFSETPOSTIVE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S64,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S64OFFSET_SCALARVALUE)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UPDATEPERIOD)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8UPDATEPERIOD)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U32,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U32TIMEDATEVALUE)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8TIMEDATESTATUS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8CHANGEMASK)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8WEEKDAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8SECONDS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MINUTES)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8HOURS)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8DAY)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_MSG_U8MONTH)) && bResult;
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_S16,midw_ext_clockfi_tclSemanticDomain::EN_MSG_S16YEAR)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_TIMEFORMAT,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENTIMEFORMAT)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_TIMEFORMAT,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENTIMEFORMAT)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_DATEFORMAT,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENDATEFORMAT)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSET:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_DATEFORMAT,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENDATEFORMAT)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_CLOCKSOURCESTATUS,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENSOURCESVALID)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_CLK_TEN_FORMATSOURCESTATUS,midw_ext_clockfi_tclSemanticDomain::EN_MSG_ENFORMATSOURCESTATUS)) && bResult;
   } break;
   case midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART:
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEGET:
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONERELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET:
   case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCGET:
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEGET:
   case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODERELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET:
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET:
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET:
   case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEGET:
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATGET:
   case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATGET:
   case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET:
   case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG:
   case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET:
   case midw_ext_clockfi_tclToken::EN_BINCONTAINER:
   case midw_ext_clockfi_tclToken::EN_E8_DEFSETMODE:
   case midw_ext_clockfi_tclToken::EN_E8_DEFSETGROUPS:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_DST_SETTING:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_GPS_EPOCH:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_GPSRTCTIMESTATE:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_FORMATSOURCESTATUS:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_CLOCKSOURCESTATUS:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_TIMEFORMAT:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_DATEFORMAT:
   case midw_ext_clockfi_tclToken::EN_CLK_TEN_SYNCMODE:
   case midw_ext_clockfi_tclToken::EN_U8:   
   case midw_ext_clockfi_tclToken::EN_S8:   
   case midw_ext_clockfi_tclToken::EN_U16:   
   case midw_ext_clockfi_tclToken::EN_S16:   
   case midw_ext_clockfi_tclToken::EN_U24:   
   case midw_ext_clockfi_tclToken::EN_S24:   
   case midw_ext_clockfi_tclToken::EN_U32:   
   case midw_ext_clockfi_tclToken::EN_S32:   
   case midw_ext_clockfi_tclToken::EN_U64:   
   case midw_ext_clockfi_tclToken::EN_S64:   
   case midw_ext_clockfi_tclToken::EN_F32:   
   case midw_ext_clockfi_tclToken::EN_F64:   
   case midw_ext_clockfi_tclToken::EN_BOOL:   
   case midw_ext_clockfi_tclToken::EN_STRING:   
   case midw_ext_clockfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(enMsgToken,midw_ext_clockfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool midw_ext_clockfi_tclDescription::bDoIt(midw_ext_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool midw_ext_clockfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      midw_ext_clockfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      midw_ext_clockfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      midw_ext_clockfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == midw_ext_clockfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(midw_ext_clockfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case midw_ext_clockfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == midw_ext_clockfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_LIST: 
      {
         midw_ext_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_clockfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            midw_ext_clockfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case midw_ext_clockfi_tclToken::EN_U8: 
      {
         midw_ext_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case midw_ext_clockfi_tclToken::EN_U16: 
      {
         midw_ext_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_U24: 
      {
         midw_ext_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_U32: 
      {
         midw_ext_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_U64: 
      {
         midw_ext_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_S8: 
      {
         midw_ext_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_S16: 
      {
         midw_ext_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_S24: 
      {
         midw_ext_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_S32: 
      {
         midw_ext_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_S64: 
      {
         midw_ext_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_F32: 
      {
         midw_ext_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_F64: 
      {
         midw_ext_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_BOOL: 
      {
         midw_ext_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_STRING: 
      {
         midw_ext_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         midw_ext_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODSTART:
      case midw_ext_clockfi_tclToken::EN_MSG_GETAVAILABLETIMEZONESMETHODRESULT:
      case midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODSTART:
      case midw_ext_clockfi_tclToken::EN_MSG_GETTIMEDATEFROMVALUEMETHODRESULT:
      case midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODSTART:
      case midw_ext_clockfi_tclToken::EN_MSG_GETDAYSPERMONTHMETHODRESULT:
      case midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODSTART:
      case midw_ext_clockfi_tclToken::EN_MSG_FID_S_DIAG_CONFIGURATIONMETHODRESULT:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEGET:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESET:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONEUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONERELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEZONESTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEGET:
      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESET:
      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMEUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMERELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_DAYLIGHTSAVINGTIMESTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCGET:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSET:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_AUTOSYNCSTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEGET:
      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESET:
      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODEUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODERELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_SYNCMODESTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHGET:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSET:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_GPS_WEEKEPOCHSTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETGET:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEOFFSETSET:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATERELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATEGET:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_LOCALTIMEDATESET:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATGET:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_TIMEFORMATSET:
      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATGET:
      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_DATEFORMATSET:
      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSGET:
      case midw_ext_clockfi_tclToken::EN_MSG_CLOCKSOURCESTATUSSTATUS:
      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSRELUPREG:
      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSGET:
      case midw_ext_clockfi_tclToken::EN_MSG_FORMATSOURCESTATUSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case midw_ext_clockfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_END_OF_STRUCT,midw_ext_clockfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_U8,midw_ext_clockfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(midw_ext_clockfi_tclKnot(midw_ext_clockfi_tclToken::EN_LIST,midw_ext_clockfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         midw_ext_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case midw_ext_clockfi_tclToken::EN_E8_DEFSETMODE:
      {
         midw_ext_fi_tcl_e8_DefSetMode o_e8_DefSetMode;
         if (!bDoIt(o_e8_DefSetMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_E8_DEFSETGROUPS:
      {
         midw_ext_fi_tcl_e8_DefSetGroups o_e8_DefSetGroups;
         if (!bDoIt(o_e8_DefSetGroups))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_DST_SETTING:
      {
         midw_ext_fi_tclDCLK_TEN_DST_Setting oDCLK_TEN_DST_Setting;
         if (!bDoIt(oDCLK_TEN_DST_Setting))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_GPS_EPOCH:
      {
         midw_ext_fi_tclDCLK_TEN_GPS_EPOCH oDCLK_TEN_GPS_EPOCH;
         if (!bDoIt(oDCLK_TEN_GPS_EPOCH))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_GPSRTCTIMESTATE:
      {
         midw_ext_fi_tclDCLK_TEN_GPSRTCTIMESTATE oDCLK_TEN_GPSRTCTIMESTATE;
         if (!bDoIt(oDCLK_TEN_GPSRTCTIMESTATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_FORMATSOURCESTATUS:
      {
         midw_ext_fi_tclDCLK_TEN_FormatSourceStatus oDCLK_TEN_FormatSourceStatus;
         if (!bDoIt(oDCLK_TEN_FormatSourceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_CLOCKSOURCESTATUS:
      {
         midw_ext_fi_tclDCLK_TEN_ClockSourceStatus oDCLK_TEN_ClockSourceStatus;
         if (!bDoIt(oDCLK_TEN_ClockSourceStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_TIMEFORMAT:
      {
         midw_ext_fi_tclDCLK_TEN_TimeFormat oDCLK_TEN_TimeFormat;
         if (!bDoIt(oDCLK_TEN_TimeFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_DATEFORMAT:
      {
         midw_ext_fi_tclDCLK_TEN_DateFormat oDCLK_TEN_DateFormat;
         if (!bDoIt(oDCLK_TEN_DateFormat))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_CLK_TEN_SYNCMODE:
      {
         midw_ext_fi_tclDCLK_TEN_SyncMode oDCLK_TEN_SyncMode;
         if (!bDoIt(oDCLK_TEN_SyncMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case midw_ext_clockfi_tclToken::EN_UNKNOWN:
      case midw_ext_clockfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

