#ifndef METERSRV_MAINFILANGUAGE_HEADER
#define METERSRV_MAINFILANGUAGE_HEADER

class metersrv_mainfi_tclInContext;
class metersrv_mainfi_tclOutContext;
class metersrv_mainfi_tclVisitorBase;

class MY_DECL metersrv_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  metersrv_mainfi_tclDescription(fi_tclInContext* poIn, metersrv_mainfi_tclVisitorBase* poVisit);
  metersrv_mainfi_tclDescription(fi_tclOutContext* poOut, metersrv_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(metersrv_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(metersrv_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ metersrv_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  metersrv_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<metersrv_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<metersrv_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline metersrv_mainfi_tclDescription::metersrv_mainfi_tclDescription(fi_tclInContext* poIn, metersrv_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline metersrv_mainfi_tclDescription::metersrv_mainfi_tclDescription(fi_tclOutContext* poOut, metersrv_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

