#ifndef MASCF_FIVISITOR_HEADER
#define MASCF_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class mascf_fi_tclOutput {
public:
   mascf_fi_tclOutput();
   virtual ~mascf_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class mascf_fi_tclFileOutput : public mascf_fi_tclOutput 
{
public:
   mascf_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   mascf_fi_tclFileOutput(); //lint !e1704
   mascf_fi_tclFileOutput& operator=(const mascf_fi_tclFileOutput& coRef);
   mascf_fi_tclFileOutput(const mascf_fi_tclFileOutput& coRef); //lint !e1704
};

class mascf_fi_tclMemOutput : public mascf_fi_tclOutput
{
public:
   mascf_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~mascf_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   mascf_fi_tclMemOutput(); //lint !e1704
   mascf_fi_tclMemOutput(const mascf_fi_tclMemOutput& coRef); //lint !e1704
   mascf_fi_tclMemOutput& operator=(const mascf_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL mascf_fi_tclVisitorBase {
public:

   // --Konstruktor
   mascf_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~mascf_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(mascf_fi_tclU8& oU8);
   virtual tVoid vVisitS8(mascf_fi_tclS8& oS8);
   virtual tVoid vVisitU16(mascf_fi_tclU16& oU16);
   virtual tVoid vVisitS16(mascf_fi_tclS16& oS16);
   virtual tVoid vVisitU24(mascf_fi_tclU24& oU24);
   virtual tVoid vVisitS24(mascf_fi_tclS24& oS24);
   virtual tVoid vVisitU32(mascf_fi_tclU32& oU32);
   virtual tVoid vVisitS32(mascf_fi_tclS32& oS32);
   virtual tVoid vVisitU64(mascf_fi_tclU64& oU64);
   virtual tVoid vVisitS64(mascf_fi_tclS64& oS64);
   virtual tVoid vVisitF32(mascf_fi_tclF32& oF32);
   virtual tVoid vVisitF64(mascf_fi_tclF64& oF64);
   virtual tVoid vVisitBool(mascf_fi_tclBool& oBool);
   virtual tVoid vVisitString(mascf_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(mascf_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(mascf_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(mascf_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(mascf_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(mascf_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(mascf_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(mascf_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(mascf_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(mascf_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(mascf_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(mascf_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(mascf_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(mascf_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(mascf_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(mascf_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(mascf_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(mascf_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(mascf_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(mascf_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(mascf_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(mascf_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(mascf_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(mascf_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(mascf_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(mascf_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(mascf_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(mascf_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(mascf_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(mascf_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(mascf_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(mascf_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(mascf_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(mascf_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(mascf_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(mascf_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(mascf_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(mascf_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(mascf_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(mascf_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(mascf_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(mascf_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(mascf_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(mascf_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(mascf_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(mascf_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(mascf_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(mascf_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(mascf_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e16_Aud_TroubleCode(mascf_fi_tcl_e16_Aud_TroubleCode& oe16_Aud_TroubleCode);

   virtual tVoid vVisit_e8_Aud_MonitoringMode(mascf_fi_tcl_e8_Aud_MonitoringMode& oe8_Aud_MonitoringMode);

   virtual tVoid vVisit_e8_Aud_SupervisionControl(mascf_fi_tcl_e8_Aud_SupervisionControl& oe8_Aud_SupervisionControl);

   virtual tVoid vVisit_e8_Aud_ErrorStatus(mascf_fi_tcl_e8_Aud_ErrorStatus& oe8_Aud_ErrorStatus);

   virtual tVoid vVisit_e8_Aud_RoutineStatus(mascf_fi_tcl_e8_Aud_RoutineStatus& oe8_Aud_RoutineStatus);

   virtual tVoid vVisit_e8_Aud_WriteTestErrorStatus(mascf_fi_tcl_e8_Aud_WriteTestErrorStatus& oe8_Aud_WriteTestErrorStatus);

   virtual tVoid vVisit_e8_Aud_SpeakerType(mascf_fi_tcl_e8_Aud_SpeakerType& oe8_Aud_SpeakerType);

   virtual tVoid vVisit_e8_Aud_TestToneControl(mascf_fi_tcl_e8_Aud_TestToneControl& oe8_Aud_TestToneControl);

   virtual tVoid vVisit_e8_Aud_FreqTestTone(mascf_fi_tcl_e8_Aud_FreqTestTone& oe8_Aud_FreqTestTone);

   virtual tVoid vVisit_Aud_TestRoutineParameter(mascf_fi_tcl_Aud_TestRoutineParameter& oAud_TestRoutineParameter);

   virtual tVoid vVisit_Aud_TestRoutineParameterList(mascf_fi_tcl_Aud_TestRoutineParameterList& oAud_TestRoutineParameterList);

   virtual tVoid vVisit_Aud_TestTroubleCodeStatus(mascf_fi_tcl_Aud_TestTroubleCodeStatus& oAud_TestTroubleCodeStatus);

   virtual tVoid vVisit_Aud_TestTroubleCodeStatusList(mascf_fi_tcl_Aud_TestTroubleCodeStatusList& oAud_TestTroubleCodeStatusList);

   virtual tVoid vVisit_e8_MicrophoneNumber(mascf_fi_tcl_e8_MicrophoneNumber& oe8_MicrophoneNumber);

   virtual tVoid vVisit_e8_MicrophoneConnectionStatus(mascf_fi_tcl_e8_MicrophoneConnectionStatus& oe8_MicrophoneConnectionStatus);

   virtual tVoid vVisit_e8_MicrophoneDetection(mascf_fi_tcl_e8_MicrophoneDetection& oe8_MicrophoneDetection);

   virtual tVoid vVisit_MicrophoneConnectionStatus(mascf_fi_tcl_MicrophoneConnectionStatus& oMicrophoneConnectionStatus);

   virtual tVoid vVisit_MicrophoneConnectionStatusList(mascf_fi_tcl_MicrophoneConnectionStatusList& oMicrophoneConnectionStatusList);

   virtual tVoid vVisit_e8_ResourceNo(mascf_fi_tcl_e8_ResourceNo& oe8_ResourceNo);

   virtual tVoid vVisit_e8_AudioServiceStatus(mascf_fi_tcl_e8_AudioServiceStatus& oe8_AudioServiceStatus);

   virtual tVoid vVisit_e8_GalaLevel(mascf_fi_tcl_e8_GalaLevel& oe8_GalaLevel);

   virtual tVoid vVisit_e8_AudioChannel(mascf_fi_tcl_e8_AudioChannel& oe8_AudioChannel);

   virtual tVoid vVisit_e8_AudioVolumeType(mascf_fi_tcl_e8_AudioVolumeType& oe8_AudioVolumeType);

   virtual tVoid vVisit_e8_AudioSoundType(mascf_fi_tcl_e8_AudioSoundType& oe8_AudioSoundType);

   virtual tVoid vVisit_e8_AudioBeepType(mascf_fi_tcl_e8_AudioBeepType& oe8_AudioBeepType);

   virtual tVoid vVisit_e8_AudioBeepStatus(mascf_fi_tcl_e8_AudioBeepStatus& oe8_AudioBeepStatus);

   virtual tVoid vVisit_e8_VolumeMode(mascf_fi_tcl_e8_VolumeMode& oe8_VolumeMode);

   virtual tVoid vVisit_e8_SourceNo(mascf_fi_tcl_e8_SourceNo& oe8_SourceNo);

   virtual tVoid vVisit_e8_RouteNo(mascf_fi_tcl_e8_RouteNo& oe8_RouteNo);

   virtual tVoid vVisit_e8_Sound(mascf_fi_tcl_e8_Sound& oe8_Sound);

   virtual tVoid vVisit_e8_MemStatus(mascf_fi_tcl_e8_MemStatus& oe8_MemStatus);

   virtual tVoid vVisit_e8_FaderStatus(mascf_fi_tcl_e8_FaderStatus& oe8_FaderStatus);

   virtual tVoid vVisit_e8_DynCompression(mascf_fi_tcl_e8_DynCompression& oe8_DynCompression);

   virtual tVoid vVisit_e8_Optimization(mascf_fi_tcl_e8_Optimization& oe8_Optimization);

   virtual tVoid vVisit_e8_EquPresets(mascf_fi_tcl_e8_EquPresets& oe8_EquPresets);

   virtual tVoid vVisit_e8_DiagAudMode(mascf_fi_tcl_e8_DiagAudMode& oe8_DiagAudMode);

   virtual tVoid vVisit_e8_GenericDiagAudMode(mascf_fi_tcl_e8_GenericDiagAudMode& oe8_GenericDiagAudMode);

   virtual tVoid vVisit_e8_AuxInLevel(mascf_fi_tcl_e8_AuxInLevel& oe8_AuxInLevel);

   virtual tVoid vVisit_e8_BeepLevel(mascf_fi_tcl_e8_BeepLevel& oe8_BeepLevel);

   virtual tVoid vVisit_e8_Rear_Mute(mascf_fi_tcl_e8_Rear_Mute& oe8_Rear_Mute);

   virtual tVoid vVisit_e8_Geometry_Mode(mascf_fi_tcl_e8_Geometry_Mode& oe8_Geometry_Mode);

   virtual tVoid vVisit_e8_PDCAttenuation(mascf_fi_tcl_e8_PDCAttenuation& oe8_PDCAttenuation);

   virtual tVoid vVisit_e8_VolumeType(mascf_fi_tcl_e8_VolumeType& oe8_VolumeType);

   virtual tVoid vVisit_Volume(mascf_fi_tcl_Volume& oVolume);

   virtual tVoid vVisit_b8_ChannelSelect(mascf_fi_tcl_b8_ChannelSelect& ob8_ChannelSelect);

   virtual tVoid vVisit_e8_Aud_Beep_Vol_Type(mascf_fi_tcl_e8_Aud_Beep_Vol_Type& oe8_Aud_Beep_Vol_Type);

   virtual tVoid vVisit_BeepConfig(mascf_fi_tcl_BeepConfig& oBeepConfig);

   virtual tVoid vVisit_e8_AudioDevice_Availability(mascf_fi_tcl_e8_AudioDevice_Availability& oe8_AudioDevice_Availability);

   virtual tVoid vVisit_e8_State(mascf_fi_tcl_e8_State& oe8_State);

   virtual tVoid vVisit_e8_Aud_VolumeType(mascf_fi_tcl_e8_Aud_VolumeType& oe8_Aud_VolumeType);

   virtual tVoid vVisit_Aud_VolumeStatus(mascf_fi_tcl_Aud_VolumeStatus& oAud_VolumeStatus);

   virtual tVoid vVisit_Aud_VolumeStatusList(mascf_fi_tcl_Aud_VolumeStatusList& oAud_VolumeStatusList);

   virtual tVoid vVisit_e8_BTAudioInLevel(mascf_fi_tcl_e8_BTAudioInLevel& oe8_BTAudioInLevel);

   virtual tVoid vVisit_e8_Aud_EDType(mascf_fi_tcl_e8_Aud_EDType& oe8_Aud_EDType);

   virtual tVoid vVisit_Aud_EDStatus(mascf_fi_tcl_Aud_EDStatus& oAud_EDStatus);

   virtual tVoid vVisit_Aud_EDStatusList(mascf_fi_tcl_Aud_EDStatusList& oAud_EDStatusList);

   virtual tVoid vVisit_e8_SurroundSetting(mascf_fi_tcl_e8_SurroundSetting& oe8_SurroundSetting);

   virtual tVoid vVisit_e8_AmpTemperatureLevel(mascf_fi_tcl_e8_AmpTemperatureLevel& oe8_AmpTemperatureLevel);

   virtual tVoid vVisit_e8_DiagMode(mascf_fi_tcl_e8_DiagMode& oe8_DiagMode);

   virtual tVoid vVisit_e8_DiagState(mascf_fi_tcl_e8_DiagState& oe8_DiagState);

   virtual tVoid vVisit_e8_Aud_DataId(mascf_fi_tcl_e8_Aud_DataId& oe8_Aud_DataId);

   virtual tVoid vVisit_b32_MeasurementResult(mascf_fi_tcl_b32_MeasurementResult& ob32_MeasurementResult);

   virtual tVoid vVisit_Aud_MeasurementResultItem(mascf_fi_tcl_Aud_MeasurementResultItem& oAud_MeasurementResultItem);

   virtual tVoid vVisit_e8_VolumeLock(mascf_fi_tcl_e8_VolumeLock& oe8_VolumeLock);

   virtual tVoid vVisit_e8_Requester(mascf_fi_tcl_e8_Requester& oe8_Requester);

   virtual tVoid vVisit_e8_RoomEffect(mascf_fi_tcl_e8_RoomEffect& oe8_RoomEffect);

   virtual tVoid vVisit_e8_AudDiagDefSetPhase(mascf_fi_tcl_e8_AudDiagDefSetPhase& oe8_AudDiagDefSetPhase);

   virtual tVoid vVisit_e8_AudioMode(mascf_fi_tcl_e8_AudioMode& oe8_AudioMode);

   virtual tVoid vVisit_e8_ADAS_UPA_SoundType(mascf_fi_tcl_e8_ADAS_UPA_SoundType& oe8_ADAS_UPA_SoundType);

   virtual tVoid vVisit_e8_ADAS_ParkAssist_Volume(mascf_fi_tcl_e8_ADAS_ParkAssist_Volume& oe8_ADAS_ParkAssist_Volume);

   virtual tVoid vVisit_e8_ADAS_LDW_UserVolume(mascf_fi_tcl_e8_ADAS_LDW_UserVolume& oe8_ADAS_LDW_UserVolume);

   virtual tVoid vVisit_e8_ADAS_Setting_Sound(mascf_fi_tcl_e8_ADAS_Setting_Sound& oe8_ADAS_Setting_Sound);

   virtual tVoid vVisit_e8_OnGoingAction(mascf_fi_tcl_e8_OnGoingAction& oe8_OnGoingAction);

   virtual tVoid vVisit_e8_BOSE_UnitType(mascf_fi_tcl_e8_BOSE_UnitType& oe8_BOSE_UnitType);

   virtual tVoid vVisit_BOSE_UnitConnectionStatus(mascf_fi_tcl_BOSE_UnitConnectionStatus& oBOSE_UnitConnectionStatus);

   virtual tVoid vVisit_e8_MicConnection(mascf_fi_tcl_e8_MicConnection& oe8_MicConnection);

   virtual tVoid vVisit_e8_MicResult(mascf_fi_tcl_e8_MicResult& oe8_MicResult);

   virtual tVoid vVisit_MicrophoneStatus(mascf_fi_tcl_MicrophoneStatus& oMicrophoneStatus);

   virtual tVoid vVisit_MicrophoneResult(mascf_fi_tcl_MicrophoneResult& oMicrophoneResult);

   virtual tVoid vVisit_e8_AudioPilotIntensity(mascf_fi_tcl_e8_AudioPilotIntensity& oe8_AudioPilotIntensity);

   virtual tVoid vVisit_e8_AudSource(mascf_fi_tcl_e8_AudSource& oe8_AudSource);

   virtual tVoid vVisit_e8_SrcActivity(mascf_fi_tcl_e8_SrcActivity& oe8_SrcActivity);

   virtual tVoid vVisit_e8_SrcAvailabilityReason(mascf_fi_tcl_e8_SrcAvailabilityReason& oe8_SrcAvailabilityReason);

   virtual tVoid vVisit_e8_SrcAvailability(mascf_fi_tcl_e8_SrcAvailability& oe8_SrcAvailability);

   virtual tVoid vVisit_SourceAvailablityItem(mascf_fi_tcl_SourceAvailablityItem& oSourceAvailablityItem);

   virtual tVoid vVisit_e8MuteAction(mascf_fi_tcl_e8MuteAction& oe8MuteAction);

   virtual tVoid vVisit_RequestAudioRouteItem(mascf_fi_tcl_RequestAudioRouteItem& oRequestAudioRouteItem);

   virtual tVoid vVisit_e8_AudioProperty(mascf_fi_tcl_e8_AudioProperty& oe8_AudioProperty);

   virtual tVoid vVisit_b32MuteReason(mascf_fi_tcl_b32MuteReason& ob32MuteReason);

   virtual tVoid vVisit_e8_MuteState(mascf_fi_tcl_e8_MuteState& oe8_MuteState);

   virtual tVoid vVisit_MuteRequestItem(mascf_fi_tcl_MuteRequestItem& oMuteRequestItem);

   virtual tVoid vVisit_e8_MuteRequester(mascf_fi_tcl_e8_MuteRequester& oe8_MuteRequester);

   virtual tVoid vVisit_e8MuteSpeed(mascf_fi_tcl_e8MuteSpeed& oe8MuteSpeed);

   virtual tVoid vVisit_SetAudioPropertyItem(mascf_fi_tcl_SetAudioPropertyItem& oSetAudioPropertyItem);

   virtual tVoid vVisit_SourceRouteActivity(mascf_fi_tcl_SourceRouteActivity& oSourceRouteActivity);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
