/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MASCF_ALLFITYPES_HEADER
#define MASCF_ALLFITYPES_HEADER

#include <vector>

class mascf_fi_tclVisitorBase;

const tU16 MASCF_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 MASCF_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 MASCF_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class mascf_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  mascf_fi_tclTypeBase() {}
  virtual ~mascf_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& /*oVisitor*/) {}
};

class mascf_fi_tclVisitableTypeBase :public mascf_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& /*oVisitor*/) {}
};

class mascf_fi_tclU8 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_U8;}
};

class mascf_fi_tclS8 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_S8;}
};

class mascf_fi_tclU16 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_U16;}
};

class mascf_fi_tclS16 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_S16;}
};

class mascf_fi_tclU24 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_U24;}
};

class mascf_fi_tclS24 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_S24;}
};

class mascf_fi_tclU32 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_U32;}
};

class mascf_fi_tclS32 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_S32;}
};

class mascf_fi_tclU64 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_U64;}
};

class mascf_fi_tclS64 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_S64;}
};

class mascf_fi_tclF32 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_F32;}
};

class mascf_fi_tclF64 : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_F64;}
};

class mascf_fi_tclBool : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const mascf_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_BOOL;}
};

class mascf_fi_tclString : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tclString(const mascf_fi_tclString& coRef);
   mascf_fi_tclString& operator=(const mascf_fi_tclString& coRef);
   virtual ~mascf_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const mascf_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   mascf_fi_tclString& operator=(tCString coszString); // ADDED
   mascf_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const mascf_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class mascf_fi_tclList : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const mascf_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_LIST;}
};

class mascf_fi_tclMultiLanguageString : public mascf_fi_tclVisitableTypeBase
{
public:
   mascf_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tclMultiLanguageString(const mascf_fi_tclMultiLanguageString& coRef);
   mascf_fi_tclMultiLanguageString& operator=(const mascf_fi_tclMultiLanguageString& coRef);
   virtual ~mascf_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const mascf_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(mascf_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   mascf_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   mascf_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return mascf_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const mascf_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class mascf_fi_tcl_BinContainer;
class mascf_fi_tcl_Reserved;
class mascf_fi_tcl_u8_Percent;
class mascf_fi_tcl_s16_PerThousand;
class mascf_fi_tcl_u16_IndexInReferenceList;
class mascf_fi_tcl_u16_ErrorCode;
class mascf_fi_tcl_u16_RPM;
class mascf_fi_tcl_s32_Kilogram;
class mascf_fi_tcl_s32_Pound;
class mascf_fi_tcl_s16_Meter;
class mascf_fi_tcl_s32_Meter;
class mascf_fi_tcl_s32_Yards;
class mascf_fi_tcl_s32_Foot;
class mascf_fi_tcl_s32_Centimeter;
class mascf_fi_tcl_s32_Inch;
class mascf_fi_tcl_s32_Millimeter;
class mascf_fi_tcl_s32_Microliter;
class mascf_fi_tcl_s32_Second;
class mascf_fi_tcl_u16_MilliSecond;
class mascf_fi_tcl_s32_MilliSecond;
class mascf_fi_tcl_POSIXTime;
class mascf_fi_tcl_e8_DST_State;
class mascf_fi_tcl_TimeZoneElement;
class mascf_fi_tcl_s16_KmPerHour;
class mascf_fi_tcl_s16_MilesPerHour;
class mascf_fi_tcl_s16_Knot;
class mascf_fi_tcl_s16_CentimeterSecond;
class mascf_fi_tcl_s16_Kelvin;
class mascf_fi_tcl_s16_Fahrenheit;
class mascf_fi_tcl_s32_Pascal;
class mascf_fi_tcl_s32_Watt;
class mascf_fi_tcl_FIVersion;
class mascf_fi_tcl_s32_Longitude;
class mascf_fi_tcl_s32_Latitude;
class mascf_fi_tcl_PositionWGS84;
class mascf_fi_tcl_RectangleWGS84;
class mascf_fi_tcl_e16_ISOCountryCode;
class mascf_fi_tcl_e16_ISOLanguageCode;
class mascf_fi_tcl_LanguageID;
class mascf_fi_tcl_u8_DirectionAbsolute;
class mascf_fi_tcl_u8_DirectionRelative;
class mascf_fi_tcl_s16_CentiDegree;
class mascf_fi_tcl_s16_Degree;
class mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class mascf_fi_tcl_s16_DirectionRelative_CentiDegree;
class mascf_fi_tcl_e8_FuelType;
class mascf_fi_tcl_DistTimeFuel;
class mascf_fi_tcl_e16_Aud_TroubleCode;
class mascf_fi_tcl_e8_Aud_MonitoringMode;
class mascf_fi_tcl_e8_Aud_SupervisionControl;
class mascf_fi_tcl_e8_Aud_ErrorStatus;
class mascf_fi_tcl_e8_Aud_RoutineStatus;
class mascf_fi_tcl_e8_Aud_WriteTestErrorStatus;
class mascf_fi_tcl_e8_Aud_SpeakerType;
class mascf_fi_tcl_e8_Aud_TestToneControl;
class mascf_fi_tcl_e8_Aud_FreqTestTone;
class mascf_fi_tcl_Aud_TestRoutineParameter;
class mascf_fi_tcl_Aud_TestRoutineParameterList;
class mascf_fi_tcl_Aud_TestTroubleCodeStatus;
class mascf_fi_tcl_Aud_TestTroubleCodeStatusList;
class mascf_fi_tcl_e8_MicrophoneNumber;
class mascf_fi_tcl_e8_MicrophoneConnectionStatus;
class mascf_fi_tcl_e8_MicrophoneDetection;
class mascf_fi_tcl_MicrophoneConnectionStatus;
class mascf_fi_tcl_MicrophoneConnectionStatusList;
class mascf_fi_tcl_e8_ResourceNo;
class mascf_fi_tcl_e8_AudioServiceStatus;
class mascf_fi_tcl_e8_GalaLevel;
class mascf_fi_tcl_e8_AudioChannel;
class mascf_fi_tcl_e8_AudioVolumeType;
class mascf_fi_tcl_e8_AudioSoundType;
class mascf_fi_tcl_e8_AudioBeepType;
class mascf_fi_tcl_e8_AudioBeepStatus;
class mascf_fi_tcl_e8_VolumeMode;
class mascf_fi_tcl_e8_SourceNo;
class mascf_fi_tcl_e8_RouteNo;
class mascf_fi_tcl_e8_Sound;
class mascf_fi_tcl_e8_MemStatus;
class mascf_fi_tcl_e8_FaderStatus;
class mascf_fi_tcl_e8_DynCompression;
class mascf_fi_tcl_e8_Optimization;
class mascf_fi_tcl_e8_EquPresets;
class mascf_fi_tcl_e8_DiagAudMode;
class mascf_fi_tcl_e8_GenericDiagAudMode;
class mascf_fi_tcl_e8_AuxInLevel;
class mascf_fi_tcl_e8_BeepLevel;
class mascf_fi_tcl_e8_Rear_Mute;
class mascf_fi_tcl_e8_Geometry_Mode;
class mascf_fi_tcl_e8_PDCAttenuation;
class mascf_fi_tcl_e8_VolumeType;
class mascf_fi_tcl_Volume;
class mascf_fi_tcl_b8_ChannelSelect;
class mascf_fi_tcl_e8_Aud_Beep_Vol_Type;
class mascf_fi_tcl_BeepConfig;
class mascf_fi_tcl_e8_AudioDevice_Availability;
class mascf_fi_tcl_e8_State;
class mascf_fi_tcl_e8_Aud_VolumeType;
class mascf_fi_tcl_Aud_VolumeStatus;
class mascf_fi_tcl_Aud_VolumeStatusList;
class mascf_fi_tcl_e8_BTAudioInLevel;
class mascf_fi_tcl_e8_Aud_EDType;
class mascf_fi_tcl_Aud_EDStatus;
class mascf_fi_tcl_Aud_EDStatusList;
class mascf_fi_tcl_e8_SurroundSetting;
class mascf_fi_tcl_e8_AmpTemperatureLevel;
class mascf_fi_tcl_e8_DiagMode;
class mascf_fi_tcl_e8_DiagState;
class mascf_fi_tcl_e8_Aud_DataId;
class mascf_fi_tcl_b32_MeasurementResult;
class mascf_fi_tcl_Aud_MeasurementResultItem;
class mascf_fi_tcl_e8_VolumeLock;
class mascf_fi_tcl_e8_Requester;
class mascf_fi_tcl_e8_RoomEffect;
class mascf_fi_tcl_e8_AudDiagDefSetPhase;
class mascf_fi_tcl_e8_AudioMode;
class mascf_fi_tcl_e8_ADAS_UPA_SoundType;
class mascf_fi_tcl_e8_ADAS_ParkAssist_Volume;
class mascf_fi_tcl_e8_ADAS_LDW_UserVolume;
class mascf_fi_tcl_e8_ADAS_Setting_Sound;
class mascf_fi_tcl_e8_OnGoingAction;
class mascf_fi_tcl_e8_BOSE_UnitType;
class mascf_fi_tcl_BOSE_UnitConnectionStatus;
class mascf_fi_tcl_e8_MicConnection;
class mascf_fi_tcl_e8_MicResult;
class mascf_fi_tcl_MicrophoneStatus;
class mascf_fi_tcl_MicrophoneResult;
class mascf_fi_tcl_e8_AudioPilotIntensity;
class mascf_fi_tcl_e8_AudSource;
class mascf_fi_tcl_e8_SrcActivity;
class mascf_fi_tcl_e8_SrcAvailabilityReason;
class mascf_fi_tcl_e8_SrcAvailability;
class mascf_fi_tcl_SourceAvailablityItem;
class mascf_fi_tcl_e8MuteAction;
class mascf_fi_tcl_RequestAudioRouteItem;
class mascf_fi_tcl_e8_AudioProperty;
class mascf_fi_tcl_b32MuteReason;
class mascf_fi_tcl_e8_MuteState;
class mascf_fi_tcl_MuteRequestItem;
class mascf_fi_tcl_e8_MuteRequester;
class mascf_fi_tcl_e8MuteSpeed;
class mascf_fi_tcl_SetAudioPropertyItem;
class mascf_fi_tcl_SourceRouteActivity;
class mascf_fi_tcl_BinContainer : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_BinContainer& operator=(const mascf_fi_tcl_BinContainer& coRef);
   mascf_fi_tcl_BinContainer(const mascf_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~mascf_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Reserved : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Reserved();

   virtual ~mascf_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u8_Percent : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~mascf_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_PerThousand : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u16_IndexInReferenceList : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~mascf_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u16_ErrorCode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~mascf_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u16_RPM : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~mascf_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Kilogram : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Pound : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_Meter : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Meter : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Yards : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Foot : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Centimeter : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Inch : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Millimeter : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Microliter : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Second : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u16_MilliSecond : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~mascf_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_MilliSecond : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_POSIXTime : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_POSIXTime& operator=(const mascf_fi_tcl_POSIXTime& coRef);
   mascf_fi_tcl_POSIXTime(const mascf_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~mascf_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_DST_State : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_DST_State(mascf_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_TimeZoneElement : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_TimeZoneElement& operator=(const mascf_fi_tcl_TimeZoneElement& coRef);
   mascf_fi_tcl_TimeZoneElement(const mascf_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tclMultiLanguageString Abbreviation_StandardTime;
   mascf_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   mascf_fi_tcl_s32_Second TimeZoneDifference;
   mascf_fi_tcl_e8_DST_State DST_State;
   mascf_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~mascf_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_KmPerHour : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_MilesPerHour : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_Knot : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_CentimeterSecond : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_Kelvin : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_Fahrenheit : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Pascal : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Watt : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_FIVersion : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_FIVersion& operator=(const mascf_fi_tcl_FIVersion& coRef);
   mascf_fi_tcl_FIVersion(const mascf_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~mascf_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Longitude : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s32_Latitude : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~mascf_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_PositionWGS84 : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_PositionWGS84& operator=(const mascf_fi_tcl_PositionWGS84& coRef);
   mascf_fi_tcl_PositionWGS84(const mascf_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_s32_Longitude Longitude;
   mascf_fi_tcl_s32_Latitude Latitude;
   virtual ~mascf_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_RectangleWGS84 : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_RectangleWGS84& operator=(const mascf_fi_tcl_RectangleWGS84& coRef);
   mascf_fi_tcl_RectangleWGS84(const mascf_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_s32_Longitude LongitudeMin;
   mascf_fi_tcl_s32_Latitude LatitudeMin;
   mascf_fi_tcl_s32_Longitude LongitudeMax;
   mascf_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~mascf_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e16_ISOCountryCode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   mascf_fi_tcl_e16_ISOCountryCode(mascf_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e16_ISOLanguageCode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   mascf_fi_tcl_e16_ISOLanguageCode(mascf_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_LanguageID : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_LanguageID& operator=(const mascf_fi_tcl_LanguageID& coRef);
   mascf_fi_tcl_LanguageID(const mascf_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   mascf_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~mascf_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u8_DirectionAbsolute : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~mascf_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u8_DirectionRelative : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~mascf_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_CentiDegree : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_Degree : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_s16_DirectionRelative_CentiDegree : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~mascf_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_FuelType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_FuelType(mascf_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_DistTimeFuel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_DistTimeFuel& operator=(const mascf_fi_tcl_DistTimeFuel& coRef);
   mascf_fi_tcl_DistTimeFuel(const mascf_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_s32_Meter Distance;
   mascf_fi_tcl_s32_Second Time;
   mascf_fi_tcl_s32_Microliter Fuel;
   virtual ~mascf_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e16_Aud_TroubleCode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e16_Aud_TroubleCode();
   enum tenType {
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED = 1025UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_SHORT_VSS = 1026UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_SHORT_GND = 1027UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_SHORT_WIRE = 1028UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_INTERRUPTED = 1029UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_SHORT_VSS = 1030UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_SHORT_GND = 1031UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RF_CIRCUIT_SHORT_WIRE = 1032UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_INTERRUPTED = 1033UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_SHORT_VSS = 1034UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_SHORT_GND = 1035UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_LR_CIRCUIT_SHORT_WIRE = 1036UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_INTERRUPTED = 1037UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_SHORT_VSS = 1038UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_SHORT_GND = 1039UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_RR_CIRCUIT_SHORT_WIRE = 1040UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPK_ALL_CIRCUIT_FAULT = 1041UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LF_CIRCUIT_INTERRUPTED = 1042UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RF_CIRCUIT_INTERRUPTED = 1043UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LR_CIRCUIT_INTERRUPTED = 1044UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RR_CIRCUIT_INTERRUPTED = 1045UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_ALL_CIRCUIT_FAULT = 1046UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_INTERRUPTED = 1047UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_SHORT_VSS = 1048UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_SHORT_GND = 1049UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_SHORT_WIRE = 1050UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_INTERRUPTED = 1051UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_SHORT_VSS = 1052UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_SHORT_GND = 1053UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_SHORT_WIRE = 1054UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_INTERRUPTED = 1055UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_SHORT_VSS = 1056UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_SHORT_GND = 1057UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_SHORT_WIRE = 1058UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_INTERRUPTED = 1059UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_SHORT_VSS = 1060UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_SHORT_GND = 1061UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_SHORT_WIRE = 1062UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_ALL_CIRCUIT_FAULT = 1063UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_LF_CIRCUIT_NOT_CODED = 1064UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_RF_CIRCUIT_NOT_CODED = 1065UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_LR_CIRCUIT_NOT_CODED = 1066UL,
      FI_EN_VDL_ITC_FC_AUDIO_SPEAKER_RR_CIRCUIT_NOT_CODED = 1067UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LF_CIRCUIT_NOT_CODED = 1068UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RF_CIRCUIT_NOT_CODED = 1069UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_LR_CIRCUIT_NOT_CODED = 1070UL,
      FI_EN_VDL_ITC_FC_AUDIO_TWT_RR_CIRCUIT_NOT_CODED = 1071UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LF_CIRCUIT_NOT_CODED = 1072UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RF_CIRCUIT_NOT_CODED = 1073UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_LR_CIRCUIT_NOT_CODED = 1074UL,
      FI_EN_VDL_ITC_FC_AUDIO_LINEOUT_RR_CIRCUIT_NOT_CODED = 1075UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_L_CIRCUIT_INTERRUPTED = 1076UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_R_CIRCUIT_INTERRUPTED = 1077UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_L_CIRCUIT_NOT_CODED = 1078UL,
      FI_EN_VDL_ITC_FC_AUDIO_AUX_IN_R_CIRCUIT_NOT_CODED = 1079UL
   };
   tenType enType;

   mascf_fi_tcl_e16_Aud_TroubleCode(mascf_fi_tcl_e16_Aud_TroubleCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e16_Aud_TroubleCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e16_Aud_TroubleCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_MonitoringMode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_MonitoringMode();
   enum tenType {
      FI_EN_FC_AUDIO_MONITORING_OFF = 0UL,
      FI_EN_FC_AUDIO_MONITORING_CONTINUOUS = 1UL,
      FI_EN_FC_AUDIO_MONITORING_SINGLE = 2UL,
      FI_EN_FC_AUDIO_MONITORING_DEFAULTMODE = 3UL,
      FI_EN_FC_AUDIO_MONITORING_PREVIOUSMODE = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_MonitoringMode(mascf_fi_tcl_e8_Aud_MonitoringMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_MonitoringMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_MonitoringMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_SupervisionControl : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_SupervisionControl();
   enum tenType {
      FI_EN_FC_AUDIO_SUPERVISION_DEFAULT = 0UL,
      FI_EN_FC_AUDIO_SUPERVISION_OFF = 1UL,
      FI_EN_FC_AUDIO_SUPERVISION_ON = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_SupervisionControl(mascf_fi_tcl_e8_Aud_SupervisionControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_SupervisionControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_SupervisionControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_ErrorStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_ErrorStatus();
   enum tenType {
      FI_EN_FC_AUDIO_TEST_PASSED = 0UL,
      FI_EN_FC_AUDIO_TEST_FAILED = 1UL,
      FI_EN_FC_AUDIO_TEST_NEVER_RAN = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_ErrorStatus(mascf_fi_tcl_e8_Aud_ErrorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_ErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_ErrorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_RoutineStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_RoutineStatus();
   enum tenType {
      FI_EN_FC_AUDIO_ROUTINE_NOT_RUNNING = 0UL,
      FI_EN_FC_AUDIO_ROUTINE_RUNNING = 1UL,
      FI_EN_FC_AUDIO_ROUTINE_FINISHED = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_RoutineStatus(mascf_fi_tcl_e8_Aud_RoutineStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_RoutineStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_RoutineStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_WriteTestErrorStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_WriteTestErrorStatus();
   enum tenType {
      FI_EN_FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG = 0UL,
      FI_EN_FC_AUDIO_NO_ACTION_LOG = 1UL,
      FI_EN_FC_AUDIO_WRITE_DIALOG_REQ_FAILED = 2UL,
      FI_EN_FC_AUDIO_WRITE_DIALOG_REQ_PASSED = 3UL,
      FI_EN_FC_AUDIO_WRITE_DIALOG_NOT_REQ = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_WriteTestErrorStatus(mascf_fi_tcl_e8_Aud_WriteTestErrorStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_WriteTestErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_WriteTestErrorStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_SpeakerType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_SpeakerType();
   enum tenType {
      FI_EN_FC_AUDIO_SPEAKER_UNDEF = 255UL,
      FI_EN_FC_AUDIO_SPEAKER_LF = 0UL,
      FI_EN_FC_AUDIO_SPEAKER_LR = 1UL,
      FI_EN_FC_AUDIO_SPEAKER_RF = 2UL,
      FI_EN_FC_AUDIO_SPEAKER_RR = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_SpeakerType(mascf_fi_tcl_e8_Aud_SpeakerType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_SpeakerType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_SpeakerType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_TestToneControl : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_TestToneControl();
   enum tenType {
      FI_EN_FC_AUDIO_TEST_TONE_UNDEF = 255UL,
      FI_EN_FC_AUDIO_TEST_TONE_ON = 0UL,
      FI_EN_FC_AUDIO_TEST_TONE_OFF = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_TestToneControl(mascf_fi_tcl_e8_Aud_TestToneControl::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_TestToneControl();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_TestToneControl& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_FreqTestTone : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_FreqTestTone();
   enum tenType {
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_DEFAULT = 0UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_1 = 1UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_2 = 2UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_3 = 3UL,
      FI_EN_FC_AUDIO_FREQ_TEST_TONE_PRESET_4 = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_FreqTestTone(mascf_fi_tcl_e8_Aud_FreqTestTone::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_FreqTestTone();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_FreqTestTone& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_TestRoutineParameter : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_TestRoutineParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_TestRoutineParameter& operator=(const mascf_fi_tcl_Aud_TestRoutineParameter& coRef);
   mascf_fi_tcl_Aud_TestRoutineParameter(const mascf_fi_tcl_Aud_TestRoutineParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e16_Aud_TroubleCode TroubleCode;
   tBool WriteToRM;
   mascf_fi_tcl_e8_Aud_MonitoringMode MonitoringMode;
   mascf_fi_tcl_e8_Aud_SupervisionControl SupervisionControl;
   virtual ~mascf_fi_tcl_Aud_TestRoutineParameter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_TestRoutineParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_TestRoutineParameterList : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_TestRoutineParameterList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_TestRoutineParameterList& operator=(const mascf_fi_tcl_Aud_TestRoutineParameterList& coRef);
   mascf_fi_tcl_Aud_TestRoutineParameterList(const mascf_fi_tcl_Aud_TestRoutineParameterList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_Aud_TestRoutineParameter, std::allocator<mascf_fi_tcl_Aud_TestRoutineParameter> > TestRoutineParameterList;
   virtual ~mascf_fi_tcl_Aud_TestRoutineParameterList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_TestRoutineParameterList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_TestTroubleCodeStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_TestTroubleCodeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_TestTroubleCodeStatus& operator=(const mascf_fi_tcl_Aud_TestTroubleCodeStatus& coRef);
   mascf_fi_tcl_Aud_TestTroubleCodeStatus(const mascf_fi_tcl_Aud_TestTroubleCodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e16_Aud_TroubleCode TroubleCode;
   mascf_fi_tcl_e8_Aud_ErrorStatus ErrorStatus;
   mascf_fi_tcl_e8_Aud_RoutineStatus RoutineStatus;
   mascf_fi_tcl_e8_Aud_WriteTestErrorStatus DiagnosisLogWrite;
   virtual ~mascf_fi_tcl_Aud_TestTroubleCodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_TestTroubleCodeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_TestTroubleCodeStatusList : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_TestTroubleCodeStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_TestTroubleCodeStatusList& operator=(const mascf_fi_tcl_Aud_TestTroubleCodeStatusList& coRef);
   mascf_fi_tcl_Aud_TestTroubleCodeStatusList(const mascf_fi_tcl_Aud_TestTroubleCodeStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_Aud_TestTroubleCodeStatus, std::allocator<mascf_fi_tcl_Aud_TestTroubleCodeStatus> > TroubleCodeStatusList;
   virtual ~mascf_fi_tcl_Aud_TestTroubleCodeStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_TestTroubleCodeStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MicrophoneNumber : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MicrophoneNumber();
   enum tenType {
      FI_EN_MIC_1 = 1UL,
      FI_EN_MIC_2 = 2UL,
      FI_EN_MIC_NUMBER_UNDEFINED = 255UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MicrophoneNumber(mascf_fi_tcl_e8_MicrophoneNumber::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MicrophoneNumber();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MicrophoneNumber& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MicrophoneConnectionStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MicrophoneConnectionStatus();
   enum tenType {
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OPEN = 0UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_SHORT = 1UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OK = 2UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_SHORT_TO_BATTERY = 3UL,
      FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_UNDEFINED = 255UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MicrophoneConnectionStatus(mascf_fi_tcl_e8_MicrophoneConnectionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MicrophoneConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MicrophoneConnectionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MicrophoneDetection : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MicrophoneDetection();
   enum tenType {
      FI_EN_MIC_DET_ABSENT = 0UL,
      FI_EN_MIC_DET_PRESENT = 1UL,
      FI_EN_MIC_DET_UNKNOWN = 255UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MicrophoneDetection(mascf_fi_tcl_e8_MicrophoneDetection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MicrophoneDetection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MicrophoneDetection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_MicrophoneConnectionStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_MicrophoneConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_MicrophoneConnectionStatus& operator=(const mascf_fi_tcl_MicrophoneConnectionStatus& coRef);
   mascf_fi_tcl_MicrophoneConnectionStatus(const mascf_fi_tcl_MicrophoneConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MicrophoneNumber e8MicrophoneNumber;
   tU16 u16MicrophoneCurrent;
   mascf_fi_tcl_e8_MicrophoneConnectionStatus e8MicrophoneConnectionStatus;
   mascf_fi_tcl_e8_MicrophoneDetection e8MicrophoneDetection;
   virtual ~mascf_fi_tcl_MicrophoneConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_MicrophoneConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_MicrophoneConnectionStatusList : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_MicrophoneConnectionStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_MicrophoneConnectionStatusList& operator=(const mascf_fi_tcl_MicrophoneConnectionStatusList& coRef);
   mascf_fi_tcl_MicrophoneConnectionStatusList(const mascf_fi_tcl_MicrophoneConnectionStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_MicrophoneConnectionStatus, std::allocator<mascf_fi_tcl_MicrophoneConnectionStatus> > MicrophoneConnectionStatusList;
   virtual ~mascf_fi_tcl_MicrophoneConnectionStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_MicrophoneConnectionStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_ResourceNo : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_ResourceNo();
   enum tenType {
      FI_EN_AUDIO_RESOURCE_NOT_DEF = 0UL,
      FI_EN_AUDIO_RESOURCE_LS = 1UL,
      FI_EN_AUDIO_RESOURCE_HP = 2UL,
      FI_EN_AUDIO_RESOURCE_DRIVER = 17UL
   };
   tenType enType;

   mascf_fi_tcl_e8_ResourceNo(mascf_fi_tcl_e8_ResourceNo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_ResourceNo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_ResourceNo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioServiceStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioServiceStatus();
   enum tenType {
      FI_EN_REJECTED = 0UL,
      FI_EN_RECEIVED = 1UL,
      FI_EN_PREVIOUS_REQUEST_PENDING = 2UL,
      FI_EN_PROCESSED = 3UL,
      FI_EN_ABORT = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioServiceStatus(mascf_fi_tcl_e8_AudioServiceStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioServiceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_GalaLevel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_GalaLevel();
   enum tenType {
      FI_EN_AUDIO_GALA_NOT_DEF = 255UL,
      FI_EN_AUDIO_GALA_OFF = 0UL,
      FI_EN_AUDIO_GALA_LEVEL_1 = 1UL,
      FI_EN_AUDIO_GALA_LEVEL_2 = 2UL,
      FI_EN_AUDIO_GALA_LEVEL_3 = 3UL,
      FI_EN_AUDIO_GALA_LEVEL_4 = 4UL,
      FI_EN_AUDIO_GALA_LEVEL_5 = 5UL,
      FI_EN_AUDIO_GALA_LEVEL_6 = 6UL,
      FI_EN_AUDIO_GALA_LEVEL_7 = 7UL
   };
   tenType enType;

   mascf_fi_tcl_e8_GalaLevel(mascf_fi_tcl_e8_GalaLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_GalaLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_GalaLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioChannel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioChannel();
   enum tenType {
      FI_EN_AUDIO_CHANNEL_NOT_DEF = 255UL,
      FI_EN_AUDIO_CHANNEL_EXC = 1UL,
      FI_EN_AUDIO_CHANNEL_MIX = 2UL,
      FI_EN_AUDIO_CHANNEL_MIX2 = 3UL,
      FI_EN_AUDIO_CHANNEL_MIX3 = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioChannel(mascf_fi_tcl_e8_AudioChannel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioChannel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioChannel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioVolumeType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioVolumeType();
   enum tenType {
      FI_EN_AUDIO_VAL_TYPE_NOT_DEF = 255UL,
      FI_EN_AUDIO_VAL_TYPE_ABS = 1UL,
      FI_EN_AUDIO_VAL_TYPE_INC = 2UL,
      FI_EN_AUDIO_VAL_TYPE_DEC = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioVolumeType(mascf_fi_tcl_e8_AudioVolumeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioVolumeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioVolumeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioSoundType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioSoundType();
   enum tenType {
      FI_EN_AUDIO_SND_TYPE_NOT_DEF = 255UL,
      FI_EN_AUDIO_SND_TYPE_ABS = 1UL,
      FI_EN_AUDIO_SND_TYPE_INC = 2UL,
      FI_EN_AUDIO_SND_TYPE_DEC = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioSoundType(mascf_fi_tcl_e8_AudioSoundType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioSoundType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioSoundType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioBeepType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioBeepType();
   enum tenType {
      FI_EN_AUDIO_BEEP_WARN_NOT_DEF = 255UL,
      FI_EN_AUDIO_BEEP_ERROR = 1UL,
      FI_EN_AUDIO_BEEP_ROGER = 2UL,
      FI_EN_AUDIO_BEEP_WARN = 3UL,
      FI_EN_AUDIO_BEEP_CLICK = 4UL,
      FI_EN_AUDIO_BEEP_POI = 5UL,
      FI_EN_AUDIO_BEEP_SDS_END = 6UL,
      FI_EN_AUDIO_BEEP_SMS_INCOMING = 7UL,
      FI_EN_AUDIO_BEEP_SMS_SEND = 8UL,
      FI_EN_AUDIO_BEEP_URGENT = 9UL,
      FI_EN_AUDIO_BEEP_SPEED_WARN = 10UL,
      FI_EN_AUDIO_BEEP_CURVE_WARN = 11UL,
      FI_EN_AUDIO_BEEP_AVM_OPERATION = 12UL,
      FI_EN_AUDIO_BEEP_AVM_ERROR = 13UL,
      FI_EN_AUDIO_BEEP_SPEED_HINT = 14UL,
      FI_EN_AUDIO_BEEP_CURVE_HINT = 15UL,
      FI_EN_AUDIO_BEEP_IPA_NOSOUND = 16UL,
      FI_EN_AUDIO_BEEP_IPA_3 = 17UL,
      FI_EN_AUDIO_BEEP_IPA_7 = 18UL,
      FI_EN_AUDIO_BEEP_IPA_8 = 19UL,
      FI_EN_AUDIO_BEEP_IPA_9 = 20UL,
      FI_EN_AUDIO_BEEP_IPA_10 = 21UL,
      FI_EN_AUDIO_BEEP_IPA_11 = 22UL,
      FI_EN_AUDIO_BEEP_IPA_STOP_SOUND = 23UL,
      FI_EN_AUDIO_BEEP_SDS_START = 24UL,
      FI_EN_AUDIO_BEEP_IPA_4 = 25UL,
      FI_EN_AUDIO_BEEP_IPA_5 = 26UL,
      FI_EN_AUDIO_BEEP_IPA_6 = 27UL,
      FI_EN_AUDIO_BEEP_GST_01 = 65UL,
      FI_EN_AUDIO_BEEP_GST_02 = 66UL,
      FI_EN_AUDIO_BEEP_GST_03 = 67UL,
      FI_EN_AUDIO_BEEP_GST_04 = 68UL,
      FI_EN_AUDIO_BEEP_GST_05 = 69UL,
      FI_EN_AUDIO_BEEP_GST_06 = 70UL,
      FI_EN_AUDIO_BEEP_GST_07 = 71UL,
      FI_EN_AUDIO_BEEP_GST_08 = 72UL,
      FI_EN_AUDIO_BEEP_GST_09 = 73UL,
      FI_EN_AUDIO_BEEP_GST_10 = 74UL,
      FI_EN_AUDIO_BEEP_GST_11 = 75UL,
      FI_EN_AUDIO_BEEP_GST_12 = 76UL,
      FI_EN_AUDIO_BEEP_GST_13 = 77UL,
      FI_EN_AUDIO_BEEP_GST_14 = 78UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioBeepType(mascf_fi_tcl_e8_AudioBeepType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioBeepType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioBeepType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioBeepStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioBeepStatus();
   enum tenType {
      FI_EN_AUDIO_BEEP_STATUS_NOT_DEF = 255UL,
      FI_EN_AUDIO_BEEP_STATUS_ON = 1UL,
      FI_EN_AUDIO_BEEP_STATUS_OFF = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioBeepStatus(mascf_fi_tcl_e8_AudioBeepStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioBeepStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioBeepStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_VolumeMode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_VolumeMode();
   enum tenType {
      FI_EN_AUDIO_VOLMODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_VOLMODE_NORMAL = 0UL,
      FI_EN_AUDIO_VOLMODE_SETUP_ONVOL = 1UL,
      FI_EN_AUDIO_VOLMODE_SETUP_TEL = 2UL,
      FI_EN_AUDIO_VOLMODE_SETUP_TIM = 3UL,
      FI_EN_AUDIO_VOLMODE_SETUP_TA = 4UL,
      FI_EN_AUDIO_VOLMODE_SETUP_BEEPVOL = 5UL,
      FI_EN_AUDIO_VOLMODE_SETUP_DIAGVOL = 6UL,
      FI_EN_AUDIO_VOLMODE_NAV_ANNOUCEMENT = 7UL,
      FI_EN_AUDIO_VOLMODE_SETUP_NAV_VOL = 8UL,
      FI_EN_AUDIO_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL = 9UL,
      FI_EN_AUDIO_VOLMODE_SETUP_PDC_ATTENUATION_VOL = 10UL,
      FI_EN_AUDIO_VOLMODE_SETUP_SDS = 11UL
   };
   tenType enType;

   mascf_fi_tcl_e8_VolumeMode(mascf_fi_tcl_e8_VolumeMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_VolumeMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_VolumeMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_SourceNo : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_SourceNo();
   enum tenType {
      FI_EN_AUDIO_SRC_NOT_DEF = 255UL,
      FI_EN_AUDIO_SRC_NO = 0UL,
      FI_EN_AUDIO_SRC_FM = 1UL,
      FI_EN_AUDIO_SRC_AM = 2UL,
      FI_EN_AUDIO_SRC_CD = 3UL,
      FI_EN_AUDIO_SRC_CDC = 4UL,
      FI_EN_AUDIO_SRC_CC = 5UL,
      FI_EN_AUDIO_SRC_AUX = 6UL,
      FI_EN_AUDIO_SRC_TEL = 7UL,
      FI_EN_AUDIO_SRC_MD = 8UL,
      FI_EN_AUDIO_SRC_MP3 = 9UL,
      FI_EN_AUDIO_SRC_TA = 10UL,
      FI_EN_AUDIO_SRC_TV = 11UL,
      FI_EN_AUDIO_SRC_TIM = 12UL,
      FI_EN_AUDIO_SRC_NAVI = 13UL,
      FI_EN_AUDIO_SRC_NO1 = 14UL,
      FI_EN_AUDIO_SRC_FM2 = 15UL,
      FI_EN_AUDIO_SRC_AM2 = 16UL,
      FI_EN_AUDIO_SRC_TA2 = 17UL,
      FI_EN_AUDIO_SRC_DAB = 18UL,
      FI_EN_AUDIO_SRC_DAB_TA = 19UL,
      FI_EN_AUDIO_SRC_CDC2 = 20UL,
      FI_EN_AUDIO_SRC_GSM = 21UL,
      FI_EN_AUDIO_SRC_VRU = 22UL,
      FI_EN_AUDIO_SRC_MICROPHONE = 23UL,
      FI_EN_AUDIO_SRC_AUX2 = 24UL,
      FI_EN_AUDIO_SRC_VR2 = 25UL,
      FI_EN_AUDIO_SRC_AUX_FAKRA = 26UL,
      FI_EN_AUDIO_SRC_XMTUN = 27UL,
      FI_EN_AUDIO_SRC_IPOD = 28UL,
      FI_EN_AUDIO_SRC_DOV = 29UL,
      FI_EN_AUDIO_SRC_DOV_TEST = 30UL,
      FI_EN_AUDIO_SRC_DAB_SRV_FOLLOW = 31UL,
      FI_EN_AUDIO_SRC_PANDORA = 32UL,
      FI_EN_AUDIO_SRC_SMS = 33UL,
      FI_EN_AUDIO_SRC_AUX3 = 34UL
   };
   tenType enType;

   mascf_fi_tcl_e8_SourceNo(mascf_fi_tcl_e8_SourceNo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_SourceNo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_SourceNo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_RouteNo : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_RouteNo();
   enum tenType {
      FI_EN_NOSOURCE = 0UL,
      FI_EN_AUDIO_SNK_NOT_DEF = 255UL,
      FI_EN_TUN1 = 1UL,
      FI_EN_TUN2 = 2UL,
      FI_EN_DAB = 3UL,
      FI_EN_MEDIA = 4UL,
      FI_EN_CDA = 5UL,
      FI_EN_AUX = 6UL,
      FI_EN_PHONE1 = 7UL,
      FI_EN_PHONE2 = 8UL,
      FI_EN_ATP_MEMO = 9UL,
      FI_EN_XM = 10UL,
      FI_EN_NAVI = 11UL,
      FI_EN_AUX2 = 12UL,
      FI_EN_BTAUDIO = 13UL,
      FI_EN_PHONE3 = 14UL,
      FI_EN_PHONE4 = 15UL,
      FI_EN_CUE1 = 17UL,
      FI_EN_CUE2 = 20UL,
      FI_EN_IPA1 = 21UL,
      FI_EN_CUE3 = 22UL,
      FI_EN_CUE4 = 23UL,
      FI_EN_SOUNDGENERATOR1 = 32UL,
      FI_EN_SOUNDGENERATOR2 = 33UL,
      FI_EN_SOUNDSAMPLEPLAYER = 34UL,
      FI_EN_TV = 64UL,
      FI_EN_DVD = 65UL,
      FI_EN_EXT_MEDIA1 = 66UL,
      FI_EN_MIC1 = 80UL,
      FI_EN_MIC2 = 81UL,
      FI_EN_AUX3 = 83UL
   };
   tenType enType;

   mascf_fi_tcl_e8_RouteNo(mascf_fi_tcl_e8_RouteNo::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_RouteNo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_RouteNo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Sound : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Sound();
   enum tenType {
      FI_EN_AUDIO_SOUND_NOT_DEF = 255UL,
      FI_EN_AUDIO_SOUND_VOLUME = 0UL,
      FI_EN_AUDIO_SOUND_BASS = 1UL,
      FI_EN_AUDIO_SOUND_TREBLE = 2UL,
      FI_EN_AUDIO_SOUND_BALANCE = 3UL,
      FI_EN_AUDIO_SOUND_FADER = 4UL,
      FI_EN_AUDIO_SOUND_LOUDNESS = 5UL,
      FI_EN_AUDIO_SOUND_SUBW = 6UL,
      FI_EN_AUDIO_SOUND_MID = 7UL,
      FI_EN_AUDIO_SOUND_HPAS = 8UL,
      FI_EN_AUDIO_SOUND_GALA = 9UL,
      FI_EN_AUDIO_SOUND_AUDPILOT = 10UL,
      FI_EN_AUDIO_SOUND_VOLOFFSET = 11UL,
      FI_EN_AUDIO_SOUND_DYNCOMP = 12UL,
      FI_EN_AUDIO_SOUND_OPTIMIZATION = 13UL,
      FI_EN_AUDIO_SOUND_PDC_ATTENUATION_LEVEL = 14UL,
      FI_EN_AUDIO_SOUND_EQ_PRESET = 15UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Sound(mascf_fi_tcl_e8_Sound::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Sound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Sound& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MemStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MemStatus();
   enum tenType {
      FI_EN_AUDIO_MEMSTATUS_NOT_DEF = 255UL,
      FI_EN_AUDIO_MEMSTATUS_SUCCESS = 0UL,
      FI_EN_AUDIO_MEMSTATUS_FAIL = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MemStatus(mascf_fi_tcl_e8_MemStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MemStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MemStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_FaderStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_FaderStatus();
   enum tenType {
      FI_EN_AUDIO_FADERSTATUS_NOT_DEF = 255UL,
      FI_EN_AUDIO_FADERSTATUS_INACTIVE = 0UL,
      FI_EN_AUDIO_FADERSTATUS_ACTIVE = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_FaderStatus(mascf_fi_tcl_e8_FaderStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_FaderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_FaderStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_DynCompression : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_DynCompression();
   enum tenType {
      FI_EN_AUDIO_DYN_COMPRESSION_NOT_DEF = 255UL,
      FI_EN_AUDIO_DYN_COMPRESSION_OFF = 0UL,
      FI_EN_AUDIO_DYN_COMPRESSION_ON = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_DynCompression(mascf_fi_tcl_e8_DynCompression::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_DynCompression();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_DynCompression& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Optimization : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Optimization();
   enum tenType {
      FI_EN_AUDIO_OPTIMIZATION_NOT_DEF = 255UL,
      FI_EN_AUDIO_OPTIMIZATION_OFF = 0UL,
      FI_EN_AUDIO_OPTIMIZATION_LEFT = 1UL,
      FI_EN_AUDIO_OPTIMIZATION_RIGHT = 2UL,
      FI_EN_AUDIO_OPTIMIZATION_ALL = 3UL,
      FI_EN_AUDIO_OPTIMIZATION_DRIVER = 4UL,
      FI_EN_AUDIO_OPTIMIZATION_FRONT_PASSENGER = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Optimization(mascf_fi_tcl_e8_Optimization::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Optimization();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Optimization& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_EquPresets : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_EquPresets();
   enum tenType {
      FI_EN_AUDIO_EQU_PRESET_NOT_DEF = 255UL,
      FI_EN_AUDIO_EQU_PRESET_0 = 0UL,
      FI_EN_AUDIO_EQU_PRESET_1 = 1UL,
      FI_EN_AUDIO_EQU_PRESET_2 = 2UL,
      FI_EN_AUDIO_EQU_PRESET_3 = 3UL,
      FI_EN_AUDIO_EQU_PRESET_4 = 4UL,
      FI_EN_AUDIO_EQU_PRESET_5 = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_EquPresets(mascf_fi_tcl_e8_EquPresets::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_EquPresets();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_EquPresets& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_DiagAudMode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_DiagAudMode();
   enum tenType {
      FI_EN_AUDIO_DIAG_AUD_MODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_OFF = 0UL,
      FI_EN_AUDIO_DIAG_AUD_MODE_LINEAR_ON = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_DiagAudMode(mascf_fi_tcl_e8_DiagAudMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_DiagAudMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_DiagAudMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_GenericDiagAudMode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_GenericDiagAudMode();
   enum tenType {
      FI_EN_NOT_DEFINED = 255UL,
      FI_EN_NORMAL_MODE = 0UL,
      FI_EN_FEATURE_OFF = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_GenericDiagAudMode(mascf_fi_tcl_e8_GenericDiagAudMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_GenericDiagAudMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_GenericDiagAudMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AuxInLevel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AuxInLevel();
   enum tenType {
      FI_EN_AUDIO_AUX_IN_LEVEL_NOT_DEF = 255UL,
      FI_EN_AUDIO_AUX_IN_LEVEL_1 = 1UL,
      FI_EN_AUDIO_AUX_IN_LEVEL_2 = 2UL,
      FI_EN_AUDIO_AUX_IN_LEVEL_3 = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AuxInLevel(mascf_fi_tcl_e8_AuxInLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AuxInLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AuxInLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_BeepLevel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_BeepLevel();
   enum tenType {
      FI_EN_AUDIO_BEEP_LEVEL_NOT_DEF = 255UL,
      FI_EN_AUDIO_BEEP_LEVEL_1 = 1UL,
      FI_EN_AUDIO_BEEP_LEVEL_2 = 2UL,
      FI_EN_AUDIO_BEEP_LEVEL_3 = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_BeepLevel(mascf_fi_tcl_e8_BeepLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_BeepLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_BeepLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Rear_Mute : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Rear_Mute();
   enum tenType {
      FI_EN_AUDIO_REAR_MUTE_NOT_DEF = 255UL,
      FI_EN_REAR_MUTE_OFF = 0UL,
      FI_EN_REAR_MUTE_ON = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Rear_Mute(mascf_fi_tcl_e8_Rear_Mute::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Rear_Mute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Rear_Mute& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Geometry_Mode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Geometry_Mode();
   enum tenType {
      FI_EN_AUDIO_GEOMETRY_MODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_GEOMETRY_MODE_MANUAL = 0UL,
      FI_EN_AUDIO_GEOMETRY_MODE_CHILD_SLEEP = 1UL,
      FI_EN_AUDIO_GEOMETRY_MODE_ALL_CAR = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Geometry_Mode(mascf_fi_tcl_e8_Geometry_Mode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Geometry_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Geometry_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_PDCAttenuation : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_PDCAttenuation();
   enum tenType {
      FI_EN_AUDIO_PDC_COMMAND_NOT_DEF = 255UL,
      FI_EN_AUDIO_PDC_COMMAND_START = 1UL,
      FI_EN_AUDIO_PDC_COMMAND_STOP = 2UL,
      FI_EN_AUDIO_PDC_COMMAND_BREAK = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_PDCAttenuation(mascf_fi_tcl_e8_PDCAttenuation::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_PDCAttenuation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_PDCAttenuation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_VolumeType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_VolumeType();
   enum tenType {
      FI_EN_INCREMENT = 1UL,
      FI_EN_DB_LEVEL = 2UL,
      FI_EN_DBV_LEVEL = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_VolumeType(mascf_fi_tcl_e8_VolumeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_VolumeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_VolumeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Volume : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Volume();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Volume& operator=(const mascf_fi_tcl_Volume& coRef);
   mascf_fi_tcl_Volume(const mascf_fi_tcl_Volume& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_VolumeType e8VolType;
   tS16 s16Volume;
   virtual ~mascf_fi_tcl_Volume();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Volume& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_b8_ChannelSelect : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_b8_ChannelSelect();

   enum {
      FI_C_U8_BIT_CHANNEL_LF = 0x1UL,
      FI_C_U8_BIT_CHANNEL_RF = 0x2UL,
      FI_C_U8_BIT_CHANNEL_LR = 0x4UL,
      FI_C_U8_BIT_CHANNEL_RR = 0x8UL,
      FI_C_U8_BIT_CHANNEL_CENT = 0x10UL,
      FI_C_U8_BIT_CHANNEL_SUB = 0x20UL
   };
   tBool bCHANNEL_LF() const {return (u8Value & FI_C_U8_BIT_CHANNEL_LF) != 0; }
   tVoid vSetCHANNEL_LF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_LF):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_LF)); }
   tBool bCHANNEL_RF() const {return (u8Value & FI_C_U8_BIT_CHANNEL_RF) != 0; }
   tVoid vSetCHANNEL_RF(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_RF):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_RF)); }
   tBool bCHANNEL_LR() const {return (u8Value & FI_C_U8_BIT_CHANNEL_LR) != 0; }
   tVoid vSetCHANNEL_LR(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_LR):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_LR)); }
   tBool bCHANNEL_RR() const {return (u8Value & FI_C_U8_BIT_CHANNEL_RR) != 0; }
   tVoid vSetCHANNEL_RR(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_RR):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_RR)); }
   tBool bCHANNEL_CENT() const {return (u8Value & FI_C_U8_BIT_CHANNEL_CENT) != 0; }
   tVoid vSetCHANNEL_CENT(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_CENT):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_CENT)); }
   tBool bCHANNEL_SUB() const {return (u8Value & FI_C_U8_BIT_CHANNEL_SUB) != 0; }
   tVoid vSetCHANNEL_SUB(tBool bSetBit) { u8Value = (tU8)((bSetBit)?(u8Value | FI_C_U8_BIT_CHANNEL_SUB):(u8Value & ~(tU8)FI_C_U8_BIT_CHANNEL_SUB)); }
   struct rBitValues {
      tBool CHANNEL_LF:1;
      tBool CHANNEL_RF:1;
      tBool CHANNEL_LR:1;
      tBool CHANNEL_RR:1;
      tBool CHANNEL_CENT:1;
      tBool CHANNEL_SUB:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~mascf_fi_tcl_b8_ChannelSelect();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_b8_ChannelSelect& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_Beep_Vol_Type : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_Beep_Vol_Type();
   enum tenType {
      FI_EN_FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT = 0UL,
      FI_EN_FC_AUDIO_BEEP_VOL_TYPE_USER_SPECIFIC = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_Beep_Vol_Type(mascf_fi_tcl_e8_Aud_Beep_Vol_Type::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_Beep_Vol_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_Beep_Vol_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_BeepConfig : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_BeepConfig();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_BeepConfig& operator=(const mascf_fi_tcl_BeepConfig& coRef);
   mascf_fi_tcl_BeepConfig(const mascf_fi_tcl_BeepConfig& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Aud_Beep_Vol_Type e8VolType;
   tS16 s16VoldB;
   virtual ~mascf_fi_tcl_BeepConfig();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_BeepConfig& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioDevice_Availability : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioDevice_Availability();
   enum tenType {
      FI_EN_AUDIODEVICE_NOTAVAILABLE = 0UL,
      FI_EN_AUDIODEVICE_AVAILABLE = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioDevice_Availability(mascf_fi_tcl_e8_AudioDevice_Availability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioDevice_Availability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioDevice_Availability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_State : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_State();
   enum tenType {
      FI_EN_CUESTATE_NOT_DEF = 255UL,
      FI_EN_CUESTATE_START = 1UL,
      FI_EN_CUESTATE_STOP = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_State(mascf_fi_tcl_e8_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_VolumeType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_VolumeType();
   enum tenType {
      FI_EN_VOLUME_NOT_DEF = 255UL,
      FI_EN_VOLUME_ONVOL = 0UL,
      FI_EN_VOLUME_ENTERTAINMENT = 1UL,
      FI_EN_VOLUME_PHONE = 2UL,
      FI_EN_VOLUME_PHONE1 = 3UL,
      FI_EN_VOLUME_PHONE2 = 4UL,
      FI_EN_VOLUME_PHONE3 = 5UL,
      FI_EN_VOLUME_PHONE4 = 6UL,
      FI_EN_VOLUME_PHONE5 = 7UL,
      FI_EN_VOLUME_RINGTONE = 8UL,
      FI_EN_VOLUME_NAVIGATION = 9UL,
      FI_EN_VOLUME_SDS = 10UL,
      FI_EN_VOLUME_TASETUP = 11UL,
      FI_EN_VOLUME_VDA_PHONE = 12UL,
      FI_EN_VOLUME_BT_PHONE = 13UL,
      FI_EN_VOLUME_BEEP = 14UL,
      FI_EN_VOLUME_SPI_INFO = 15UL,
      FI_EN_VOLUME_PHONE6 = 16UL,
      FI_EN_VOLUME_PHONE7 = 17UL,
      FI_EN_VOLUME_PHONE8 = 18UL,
      FI_EN_VOLUME_PHONE9 = 19UL,
      FI_EN_VOLUME_PHONE10 = 20UL,
      FI_EN_VOLUME_CARPLAY_PHONE = 21UL,
      FI_EN_VOLUME_TCU_ECALL = 22UL,
      FI_EN_VOLUME_TCU_SERVICECALL = 23UL,
      FI_EN_VOLUME_TCU_TTS = 24UL,
      FI_EN_VOLUME_SPI_ALERT = 25UL,
      FI_EN_VOLUME_ONVOL_SPI_INFO = 26UL,
      FI_EN_VOLUME_AUX3 = 27UL,
      FI_EN_VOLUME_PHONE_WAIT = 28UL,
      FI_EN_VOLUME_PARK_ASSIST = 29UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_VolumeType(mascf_fi_tcl_e8_Aud_VolumeType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_VolumeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_VolumeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_VolumeStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_VolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_VolumeStatus& operator=(const mascf_fi_tcl_Aud_VolumeStatus& coRef);
   mascf_fi_tcl_Aud_VolumeStatus(const mascf_fi_tcl_Aud_VolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Aud_VolumeType AudVolumeType;
   tU8 Volume;
   virtual ~mascf_fi_tcl_Aud_VolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_VolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_VolumeStatusList : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_VolumeStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_VolumeStatusList& operator=(const mascf_fi_tcl_Aud_VolumeStatusList& coRef);
   mascf_fi_tcl_Aud_VolumeStatusList(const mascf_fi_tcl_Aud_VolumeStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_Aud_VolumeStatus, std::allocator<mascf_fi_tcl_Aud_VolumeStatus> > VolumeStatusList;
   virtual ~mascf_fi_tcl_Aud_VolumeStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_VolumeStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_BTAudioInLevel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_BTAudioInLevel();
   enum tenType {
      FI_EN_AUDIO_BT_IN_LEVEL_1 = 0UL,
      FI_EN_AUDIO_BT_IN_LEVEL_2 = 1UL,
      FI_EN_AUDIO_BT_IN_LEVEL_3 = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_BTAudioInLevel(mascf_fi_tcl_e8_BTAudioInLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_BTAudioInLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_BTAudioInLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_EDType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_EDType();
   enum tenType {
      FI_EN_ED_NOT_DEF = 255UL,
      FI_EN_ED_GALA_GAIN = 0UL,
      FI_EN_ED_INPUTGAINOFFSET_TUNER_FM = 1UL,
      FI_EN_ED_INPUTGAINOFFSET_TUNER_AM = 2UL,
      FI_EN_ED_INPUTGAINOFFSET_TUNER_DAB = 3UL,
      FI_EN_ED_INPUTGAINOFFSET_TA_TUNER_FM = 4UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_MFP = 5UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_CDA = 6UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_AUXADAPTER = 7UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_BTDEVICE = 8UL,
      FI_EN_ED_INPUTGAINOFFSET_MEDIA_AUXIN = 9UL,
      FI_EN_ED_INPUTGAINOFFSET_PHONE_VOICE = 10UL,
      FI_EN_ED_INPUTGAINOFFSET_PHONE_RINGER_OB = 11UL,
      FI_EN_ED_INPUTGAINOFFSET_HFP = 12UL,
      FI_EN_ED_INPUTGAINOFFSET_TONE_BEEP = 13UL,
      FI_EN_ED_INPUTGAINOFFSET_TONE_TOUCHSCREEN = 14UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_EDType(mascf_fi_tcl_e8_Aud_EDType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_EDType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_EDType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_EDStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_EDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_EDStatus& operator=(const mascf_fi_tcl_Aud_EDStatus& coRef);
   mascf_fi_tcl_Aud_EDStatus(const mascf_fi_tcl_Aud_EDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Aud_EDType AudEDType;
   tS32 EDValue;
   virtual ~mascf_fi_tcl_Aud_EDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_EDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_EDStatusList : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_EDStatusList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_EDStatusList& operator=(const mascf_fi_tcl_Aud_EDStatusList& coRef);
   mascf_fi_tcl_Aud_EDStatusList(const mascf_fi_tcl_Aud_EDStatusList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<mascf_fi_tcl_Aud_EDStatus, std::allocator<mascf_fi_tcl_Aud_EDStatus> > EDStatusList;
   virtual ~mascf_fi_tcl_Aud_EDStatusList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_EDStatusList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_SurroundSetting : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_SurroundSetting();
   enum tenType {
      FI_EN_AUDIO_SURROUND_NOT_DEF = 255UL,
      FI_EN_AUDIO_SURROUND_OFF = 0UL,
      FI_EN_AUDIO_SURROUND_DOLBY_PROLOGIC = 1UL,
      FI_EN_AUDIO_SURROUND_AC3 = 2UL,
      FI_EN_AUDIO_SURROUND_DTS = 3UL,
      FI_EN_AUDIO_SURROUND_MAX = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_SurroundSetting(mascf_fi_tcl_e8_SurroundSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_SurroundSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_SurroundSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AmpTemperatureLevel : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AmpTemperatureLevel();
   enum tenType {
      FI_EN_THERMAL_WARNING_UNKNOWN = 255UL,
      FI_EN_THERMAL_WARNING_STEP_0 = 0UL,
      FI_EN_THERMAL_WARNING_STEP_1 = 1UL,
      FI_EN_THERMAL_WARNING_STEP_2 = 2UL,
      FI_EN_THERMAL_WARNING_STEP_3 = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AmpTemperatureLevel(mascf_fi_tcl_e8_AmpTemperatureLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AmpTemperatureLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AmpTemperatureLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_DiagMode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_DiagMode();
   enum tenType {
      FI_EN_OFF = 1UL,
      FI_EN_UNQUALIFIED = 2UL,
      FI_EN_QUALIFIED = 3UL,
      FI_EN_CONTINOUS = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_DiagMode(mascf_fi_tcl_e8_DiagMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_DiagMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_DiagMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_DiagState : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_DiagState();
   enum tenType {
      FI_EN_OFF = 1UL,
      FI_EN_DC_STARTED = 2UL,
      FI_EN_AC_STARTED = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_DiagState(mascf_fi_tcl_e8_DiagState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_DiagState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_DiagState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Aud_DataId : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Aud_DataId();
   enum tenType {
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF = 1UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RF = 2UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LR = 3UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_RR = 4UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_CE = 5UL,
      FI_EN_DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_SUB = 6UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_LF = 7UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_RF = 8UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_LR = 9UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_RR = 10UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_CE = 11UL,
      FI_EN_DATAID_AUDIO_LINEOUTS_RESULT_CHANNEL_SUB = 12UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Aud_DataId(mascf_fi_tcl_e8_Aud_DataId::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Aud_DataId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Aud_DataId& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_b32_MeasurementResult : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_b32_MeasurementResult();

   enum {
      FI_C_U32_BIT_SHORT_TO_GROUND_OK = 0x1UL,
      FI_C_U32_BIT_SHORT_TO_GROUND_ERROR = 0x2UL,
      FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED = 0x4UL,
      FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK = 0x8UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_OK = 0x10UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR = 0x20UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED = 0x40UL,
      FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK = 0x80UL,
      FI_C_U32_BIT_SHORTED_LOAD_OK = 0x100UL,
      FI_C_U32_BIT_SHORTED_LOAD_ERROR = 0x200UL,
      FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED = 0x400UL,
      FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK = 0x800UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK = 0x1000UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR = 0x2000UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED = 0x4000UL,
      FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK = 0x8000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK = 0x10000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR = 0x20000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED = 0x40000UL,
      FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK = 0x80000UL,
      FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED = 0x4000000UL,
      FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED = 0x8000000UL,
      FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED = 0x10000000UL,
      FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED = 0x20000000UL,
      FI_C_U32_BIT_WOOFER_AVAILABILITY = 0x40000000UL,
      FI_C_U32_BIT_TWEETER_AVAILABILITY = 0x80000000UL
   };
   tBool bSHORT_TO_GROUND_OK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_OK) != 0; }
   tVoid vSetSHORT_TO_GROUND_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_OK)); }
   tBool bSHORT_TO_GROUND_ERROR() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_ERROR) != 0; }
   tVoid vSetSHORT_TO_GROUND_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_ERROR)); }
   tBool bSHORT_TO_GROUND_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED) != 0; }
   tVoid vSetSHORT_TO_GROUND_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_NOT_TESTED)); }
   tBool bSHORT_TO_GROUND_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK) != 0; }
   tVoid vSetSHORT_TO_GROUND_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_GROUND_CONDITION_NOK)); }
   tBool bSHORT_TO_BATTERY_OK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_OK) != 0; }
   tVoid vSetSHORT_TO_BATTERY_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_OK)); }
   tBool bSHORT_TO_BATTERY_ERROR() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR) != 0; }
   tVoid vSetSHORT_TO_BATTERY_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_ERROR)); }
   tBool bSHORT_TO_BATTERY_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED) != 0; }
   tVoid vSetSHORT_TO_BATTERY_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_NOT_TESTED)); }
   tBool bSHORT_TO_BATTERY_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK) != 0; }
   tVoid vSetSHORT_TO_BATTERY_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORT_TO_BATTERY_CONDITION_NOK)); }
   tBool bSHORTED_LOAD_OK() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_OK) != 0; }
   tVoid vSetSHORTED_LOAD_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_OK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_OK)); }
   tBool bSHORTED_LOAD_ERROR() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_ERROR) != 0; }
   tVoid vSetSHORTED_LOAD_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_ERROR)); }
   tBool bSHORTED_LOAD_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED) != 0; }
   tVoid vSetSHORTED_LOAD_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_NOT_TESTED)); }
   tBool bSHORTED_LOAD_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK) != 0; }
   tVoid vSetSHORTED_LOAD_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_SHORTED_LOAD_CONDITION_NOK)); }
   tBool bWOOFER_OPEN_LOAD_OK() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_OK)); }
   tBool bWOOFER_OPEN_LOAD_ERROR() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_ERROR)); }
   tBool bWOOFER_OPEN_LOAD_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_NOT_TESTED)); }
   tBool bWOOFER_OPEN_LOAD_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK) != 0; }
   tVoid vSetWOOFER_OPEN_LOAD_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_OPEN_LOAD_CONDITION_NOK)); }
   tBool bTWEETER_OPEN_LOAD_OK() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_OK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_OK)); }
   tBool bTWEETER_OPEN_LOAD_ERROR() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_ERROR(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_ERROR)); }
   tBool bTWEETER_OPEN_LOAD_NOT_TESTED() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_NOT_TESTED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_NOT_TESTED)); }
   tBool bTWEETER_OPEN_LOAD_CONDITION_NOK() const {return (u32Value & FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK) != 0; }
   tVoid vSetTWEETER_OPEN_LOAD_CONDITION_NOK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_OPEN_LOAD_CONDITION_NOK)); }
   tBool bDC_DIAGMODE_UNQUALIFIED() const {return (u32Value & FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED) != 0; }
   tVoid vSetDC_DIAGMODE_UNQUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_DC_DIAGMODE_UNQUALIFIED)); }
   tBool bDC_DIAGMODE_QUALIFIED() const {return (u32Value & FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED) != 0; }
   tVoid vSetDC_DIAGMODE_QUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_DC_DIAGMODE_QUALIFIED)); }
   tBool bAC_DIAGMODE_UNQUALIFIED() const {return (u32Value & FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED) != 0; }
   tVoid vSetAC_DIAGMODE_UNQUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_AC_DIAGMODE_UNQUALIFIED)); }
   tBool bAC_DIAGMODE_QUALIFIED() const {return (u32Value & FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED) != 0; }
   tVoid vSetAC_DIAGMODE_QUALIFIED(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED):(u32Value & ~(tU32)FI_C_U32_BIT_AC_DIAGMODE_QUALIFIED)); }
   tBool bWOOFER_AVAILABILITY() const {return (u32Value & FI_C_U32_BIT_WOOFER_AVAILABILITY) != 0; }
   tVoid vSetWOOFER_AVAILABILITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_WOOFER_AVAILABILITY):(u32Value & ~(tU32)FI_C_U32_BIT_WOOFER_AVAILABILITY)); }
   tBool bTWEETER_AVAILABILITY() const {return (u32Value & FI_C_U32_BIT_TWEETER_AVAILABILITY) != 0; }
   tVoid vSetTWEETER_AVAILABILITY(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_TWEETER_AVAILABILITY):(u32Value & ~(tU32)FI_C_U32_BIT_TWEETER_AVAILABILITY)); }
   struct rBitValues {
      tBool SHORT_TO_GROUND_OK:1;
      tBool SHORT_TO_GROUND_ERROR:1;
      tBool SHORT_TO_GROUND_NOT_TESTED:1;
      tBool SHORT_TO_GROUND_CONDITION_NOK:1;
      tBool SHORT_TO_BATTERY_OK:1;
      tBool SHORT_TO_BATTERY_ERROR:1;
      tBool SHORT_TO_BATTERY_NOT_TESTED:1;
      tBool SHORT_TO_BATTERY_CONDITION_NOK:1;
      tBool SHORTED_LOAD_OK:1;
      tBool SHORTED_LOAD_ERROR:1;
      tBool SHORTED_LOAD_NOT_TESTED:1;
      tBool SHORTED_LOAD_CONDITION_NOK:1;
      tBool WOOFER_OPEN_LOAD_OK:1;
      tBool WOOFER_OPEN_LOAD_ERROR:1;
      tBool WOOFER_OPEN_LOAD_NOT_TESTED:1;
      tBool WOOFER_OPEN_LOAD_CONDITION_NOK:1;
      tBool TWEETER_OPEN_LOAD_OK:1;
      tBool TWEETER_OPEN_LOAD_ERROR:1;
      tBool TWEETER_OPEN_LOAD_NOT_TESTED:1;
      tBool TWEETER_OPEN_LOAD_CONDITION_NOK:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool DC_DIAGMODE_UNQUALIFIED:1;
      tBool DC_DIAGMODE_QUALIFIED:1;
      tBool AC_DIAGMODE_UNQUALIFIED:1;
      tBool AC_DIAGMODE_QUALIFIED:1;
      tBool WOOFER_AVAILABILITY:1;
      tBool TWEETER_AVAILABILITY:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~mascf_fi_tcl_b32_MeasurementResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_b32_MeasurementResult& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_Aud_MeasurementResultItem : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_Aud_MeasurementResultItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_Aud_MeasurementResultItem& operator=(const mascf_fi_tcl_Aud_MeasurementResultItem& coRef);
   mascf_fi_tcl_Aud_MeasurementResultItem(const mascf_fi_tcl_Aud_MeasurementResultItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_Aud_DataId u8DataId;
   mascf_fi_tcl_b32_MeasurementResult b32Result;
   virtual ~mascf_fi_tcl_Aud_MeasurementResultItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_Aud_MeasurementResultItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_VolumeLock : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_VolumeLock();
   enum tenType {
      FI_EN_AUDIO_VOLUME_LOCK_NOT_DEF = 255UL,
      FI_EN_AUDIO_VOLUME_LOCK_OFF = 0UL,
      FI_EN_AUDIO_VOLUME_LOCK_TOTAL = 1UL,
      FI_EN_AUDIO_VOLUME_LOCK_INCREASING = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_VolumeLock(mascf_fi_tcl_e8_VolumeLock::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_VolumeLock();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_VolumeLock& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_Requester : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_Requester();
   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HMI = 1UL,
      FI_EN_AUDIOROUTINGMANAGER = 2UL,
      FI_EN_TEMPERATUREHANDLER = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_Requester(mascf_fi_tcl_e8_Requester::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_Requester();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_Requester& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_RoomEffect : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_RoomEffect();
   enum tenType {
      FI_EN_AUDIO_ROOM_EFFECT_NOT_DEF = 255UL,
      FI_EN_AUDIO_ROOM_EFFECT_0 = 0UL,
      FI_EN_AUDIO_ROOM_EFFECT_1 = 1UL,
      FI_EN_AUDIO_ROOM_EFFECT_2 = 2UL,
      FI_EN_AUDIO_ROOM_EFFECT_3 = 3UL,
      FI_EN_AUDIO_ROOM_EFFECT_4 = 4UL
   };
   tenType enType;

   mascf_fi_tcl_e8_RoomEffect(mascf_fi_tcl_e8_RoomEffect::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_RoomEffect();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_RoomEffect& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudDiagDefSetPhase : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudDiagDefSetPhase();
   enum tenType {
      FI_EN_AUDIO_DIAGDEFSET_NOT_DEF = 255UL,
      FI_EN_AUDIO_DIAGDEFSET_PREPARE = 1UL,
      FI_EN_AUDIO_DIAGDEFSET_SET = 2UL,
      FI_EN_AUDIO_DIAGDEFSET_FINISH = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudDiagDefSetPhase(mascf_fi_tcl_e8_AudDiagDefSetPhase::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudDiagDefSetPhase();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudDiagDefSetPhase& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioMode : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioMode();
   enum tenType {
      FI_EN_AUDIO_MODE_NOT_DEF = 255UL,
      FI_EN_AUDIO_MODE_BYPASS = 1UL,
      FI_EN_AUDIO_MODE_CLASSIC = 2UL,
      FI_EN_AUDIO_MODE_AUDITORIUM = 3UL,
      FI_EN_AUDIO_MODE_PREMIUM_1 = 4UL,
      FI_EN_AUDIO_MODE_PREMIUM_2 = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioMode(mascf_fi_tcl_e8_AudioMode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_ADAS_UPA_SoundType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_ADAS_UPA_SoundType();
   enum tenType {
      FI_EN_ADAS_UPA_SOUND_UNDEF = 255UL,
      FI_EN_ADAS_UPA_SOUND_BIP = 1UL,
      FI_EN_ADAS_UPA_SOUND_CORDE = 2UL,
      FI_EN_ADAS_UPA_SOUND_SONAR = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_ADAS_UPA_SoundType(mascf_fi_tcl_e8_ADAS_UPA_SoundType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_ADAS_UPA_SoundType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_ADAS_UPA_SoundType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_ADAS_ParkAssist_Volume : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_ADAS_ParkAssist_Volume();
   enum tenType {
      FI_EN_ADAS_PA_VOL_NO_SOUND = 0UL,
      FI_EN_ADAS_PA_VOL_LEVEL_1 = 1UL,
      FI_EN_ADAS_PA_VOL_LEVEL_2 = 2UL,
      FI_EN_ADAS_PA_VOL_LEVEL_3 = 3UL,
      FI_EN_ADAS_PA_VOL_LEVEL_4 = 4UL,
      FI_EN_ADAS_PA_VOL_LEVEL_5 = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_ADAS_ParkAssist_Volume(mascf_fi_tcl_e8_ADAS_ParkAssist_Volume::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_ADAS_ParkAssist_Volume();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_ADAS_ParkAssist_Volume& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_ADAS_LDW_UserVolume : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_ADAS_LDW_UserVolume();
   enum tenType {
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID = 0UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_1 = 1UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_2 = 2UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_3 = 3UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_4 = 4UL,
      FI_EN_ADAS_LDW_USR_VOL_LEVEL_5 = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_ADAS_LDW_UserVolume(mascf_fi_tcl_e8_ADAS_LDW_UserVolume::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_ADAS_LDW_UserVolume();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_ADAS_LDW_UserVolume& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_ADAS_Setting_Sound : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_ADAS_Setting_Sound();
   enum tenType {
      FI_EN_ADAS_SETTING_SOUND_NONE = 0UL,
      FI_EN_ADAS_SETTING_SOUND_LDW = 1UL,
      FI_EN_ADAS_SETTING_SOUND_UPA = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_ADAS_Setting_Sound(mascf_fi_tcl_e8_ADAS_Setting_Sound::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_ADAS_Setting_Sound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_ADAS_Setting_Sound& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_OnGoingAction : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_OnGoingAction();
   enum tenType {
      FI_EN_UNDEF = 0UL,
      FI_EN_ALLOCATE = 1UL,
      FI_EN_DEALLOCATE = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_OnGoingAction(mascf_fi_tcl_e8_OnGoingAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_OnGoingAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_OnGoingAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_BOSE_UnitType : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_BOSE_UnitType();
   enum tenType {
      FI_EN_AUDIOAMPLIFIER = 0UL,
      FI_EN_MASTERAMPLIFIER = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_BOSE_UnitType(mascf_fi_tcl_e8_BOSE_UnitType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_BOSE_UnitType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_BOSE_UnitType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_BOSE_UnitConnectionStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_BOSE_UnitConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_BOSE_UnitConnectionStatus& operator=(const mascf_fi_tcl_BOSE_UnitConnectionStatus& coRef);
   mascf_fi_tcl_BOSE_UnitConnectionStatus(const mascf_fi_tcl_BOSE_UnitConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_BOSE_UnitType e8UnitType;
   tBool bConnected;
   tU8 u8AbsenceState;
   tU8 u8MuteState;
   virtual ~mascf_fi_tcl_BOSE_UnitConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_BOSE_UnitConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MicConnection : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MicConnection();
   enum tenType {
      FI_EN_UNAVAILABLE = 0UL,
      FI_EN_AVAILABLE = 1UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MicConnection(mascf_fi_tcl_e8_MicConnection::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MicConnection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MicConnection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MicResult : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MicResult();
   enum tenType {
      FI_EN_NORMAL = 0UL,
      FI_EN_OPEN = 1UL,
      FI_EN_SHORT = 2UL,
      FI_EN_SHORTBATTERY = 3UL,
      FI_EN_SHORTGROUND = 4UL,
      FI_EN_AMPOVERTEMP = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MicResult(mascf_fi_tcl_e8_MicResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MicResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MicResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_MicrophoneStatus : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_MicrophoneStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_MicrophoneStatus& operator=(const mascf_fi_tcl_MicrophoneStatus& coRef);
   mascf_fi_tcl_MicrophoneStatus(const mascf_fi_tcl_MicrophoneStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_MicConnection MicConnection;
   mascf_fi_tcl_e8_MicResult MicResult;
   virtual ~mascf_fi_tcl_MicrophoneStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_MicrophoneStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_MicrophoneResult : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_MicrophoneResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_MicrophoneResult& operator=(const mascf_fi_tcl_MicrophoneResult& coRef);
   mascf_fi_tcl_MicrophoneResult(const mascf_fi_tcl_MicrophoneResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_MicrophoneStatus Mic1Result;
   mascf_fi_tcl_MicrophoneStatus Mic2Result;
   mascf_fi_tcl_MicrophoneStatus Mic3Result;
   mascf_fi_tcl_MicrophoneStatus Mic4Result;
   virtual ~mascf_fi_tcl_MicrophoneResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_MicrophoneResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioPilotIntensity : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioPilotIntensity();
   enum tenType {
      FI_EN_UNDEF = 255UL,
      FI_EN_LOW = 1UL,
      FI_EN_MEDIUM = 2UL,
      FI_EN_HIGH = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioPilotIntensity(mascf_fi_tcl_e8_AudioPilotIntensity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioPilotIntensity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioPilotIntensity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudSource : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudSource();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_FM_TA = 2UL,
      FI_EN_AM = 3UL,
      FI_EN_DAB = 4UL,
      FI_EN_DAB_TA = 5UL,
      FI_EN_XMTUN = 6UL,
      FI_EN_CPRA = 7UL,
      FI_EN_CDDA = 8UL,
      FI_EN_AUX = 9UL,
      FI_EN_SPI_BT_AUDIO = 10UL,
      FI_EN_SPI_USB = 11UL,
      FI_EN_SPI_VR_USB = 12UL,
      FI_EN_SPI_VR_BT_AUDIO = 13UL,
      FI_EN_SPI_TTS = 14UL,
      FI_EN_BT_AUDIO = 15UL,
      FI_EN_PHONE = 16UL,
      FI_EN_AUX2 = 17UL,
      FI_EN_VRU = 18UL,
      FI_EN_SMS = 19UL,
      FI_EN_NAVI = 20UL,
      FI_EN_CUE = 21UL,
      FI_EN_MIC = 22UL,
      FI_EN_PHONE2 = 23UL,
      FI_EN_CPRA2 = 24UL,
      FI_EN_IAPPS = 25UL,
      FI_EN_SPI_MAIN = 26UL,
      FI_EN_SPI_PHONE = 27UL,
      FI_EN_SPI_VR = 28UL,
      FI_EN_SPI_MIX = 29UL,
      FI_EN_PHONE_ANALOG_EXT = 30UL,
      FI_EN_PHONE_ECALL = 31UL,
      FI_EN_PHONE_OUTBAND_RING = 32UL,
      FI_EN_PHONE_VR = 33UL,
      FI_EN_SPI_ALERT = 34UL,
      FI_EN_DRM = 35UL,
      FI_EN_PHONE_WAIT = 36UL,
      FI_EN_TCU_ECALL = 37UL,
      FI_EN_TCU_SERVICECALL = 38UL,
      FI_EN_TCU_TTS = 39UL,
      FI_EN_SPI_TRANSIENT = 40UL,
      FI_EN_WEB_ENT = 41UL,
      FI_EN_WEB_INFO_USR = 42UL,
      FI_EN_SXM_TTS = 43UL,
      FI_EN_SPI_ML_INFO = 44UL,
      FI_EN_SPI_VR_STEREO = 45UL,
      FI_EN_BLU_RAY = 46UL,
      FI_EN_EXTERNAL_CD = 47UL,
      FI_EN_AUX3 = 48UL,
      FI_EN_SXM_NEWS = 49UL,
      FI_EN_IPA_TTS = 50UL,
      FI_EN_DTV = 51UL,
      FI_EN_MIC2 = 52UL,
      FI_EN_AM_TI = 53UL,
      FI_EN_WEB_INFO_SYSTEM = 54UL,
      FI_EN_WEB_MIX = 55UL,
      FI_EN_WEB_TTS = 56UL,
      FI_EN_AUX2_DIAG = 57UL,
      FI_EN_VPA_MAIN = 58UL,
      FI_EN_VPA_SDS = 59UL,
      FI_EN_VPA_TTS = 60UL,
      FI_EN_RSE_IN = 61UL,
      FI_EN_NAVI_BY_SDS = 62UL,
      FI_EN_USB_VIDEO = 63UL,
      FI_EN_AUTO_DRIVE = 64UL,
      FI_EN_DRVASS_VIDEO = 65UL,
      FI_EN_EXT_MEDIA1 = 66UL,
      FI_EN_SPARE_CD = 67UL,
      FI_EN_ECO_TTS = 68UL,
      FI_EN_EXT_NAVI = 69UL,
      FI_EN_WX = 70UL,
      FI_EN_WEB_SDS = 71UL,
      FI_EN_SRC_MAX = 72UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudSource(mascf_fi_tcl_e8_AudSource::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudSource();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudSource& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_SrcActivity : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_SrcActivity();
   enum tenType {
      FI_EN_PAUSE = 2UL,
      FI_EN_ON = 1UL,
      FI_EN_OFF = 0UL
   };
   tenType enType;

   mascf_fi_tcl_e8_SrcActivity(mascf_fi_tcl_e8_SrcActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_SrcActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_SrcActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_SrcAvailabilityReason : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_SrcAvailabilityReason();
   enum tenType {
      FI_EN_NEWMEDIA = 0UL,
      FI_EN_SAMEMEDIA = 1UL,
      FI_EN_NOMEDIA = 2UL,
      FI_EN_TEMPERATURE = 3UL,
      FI_EN_VOLTAGE = 4UL,
      FI_EN_ERROR = 5UL,
      FI_EN_NO_CONTENT = 6UL,
      FI_EN_OVERCURRENT = 7UL,
      FI_EN_INTERNALDISCONNECT = 8UL
   };
   tenType enType;

   mascf_fi_tcl_e8_SrcAvailabilityReason(mascf_fi_tcl_e8_SrcAvailabilityReason::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_SrcAvailabilityReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_SrcAvailabilityReason& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_SrcAvailability : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_SrcAvailability();
   enum tenType {
      FI_EN_NOT_AVAILABLE = 0UL,
      FI_EN_PLAYABLE_UNKNOWN = 1UL,
      FI_EN_PLAYABLE = 2UL,
      FI_EN_NOT_PLAYABLE = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_SrcAvailability(mascf_fi_tcl_e8_SrcAvailability::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_SrcAvailability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_SrcAvailability& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_SourceAvailablityItem : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_SourceAvailablityItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_SourceAvailablityItem& operator=(const mascf_fi_tcl_SourceAvailablityItem& coRef);
   mascf_fi_tcl_SourceAvailablityItem(const mascf_fi_tcl_SourceAvailablityItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   mascf_fi_tcl_e8_SrcAvailabilityReason e8Reason;
   mascf_fi_tcl_e8_SrcAvailability e8Availability;
   virtual ~mascf_fi_tcl_SourceAvailablityItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_SourceAvailablityItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8MuteAction : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8MuteAction();
   enum tenType {
      FI_EN_MUTE = 1UL,
      FI_EN_DEMUTE = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8MuteAction(mascf_fi_tcl_e8MuteAction::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8MuteAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8MuteAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_RequestAudioRouteItem : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_RequestAudioRouteItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_RequestAudioRouteItem& operator=(const mascf_fi_tcl_RequestAudioRouteItem& coRef);
   mascf_fi_tcl_RequestAudioRouteItem(const mascf_fi_tcl_RequestAudioRouteItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   tU8 u8Reason;
   mascf_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~mascf_fi_tcl_RequestAudioRouteItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_RequestAudioRouteItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_AudioProperty : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_AudioProperty();
   enum tenType {
      FI_EN_AUDIO_PROP_VOLUME_LOCK = 1UL,
      FI_EN_AUDIO_PROP_INPUT_GAIN = 2UL,
      FI_EN_AUDIO_PROP_IPOD_DUCKING = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_AudioProperty(mascf_fi_tcl_e8_AudioProperty::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_AudioProperty();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_AudioProperty& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_b32MuteReason : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_b32MuteReason();

   enum {
      FI_C_U32_BIT_MUTE_REAS_USER_ACTION = 0x1UL,
      FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK = 0x2UL,
      FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL = 0x4UL,
      FI_C_U32_BIT_MUTE_REAS_DIAG = 0x8UL,
      FI_C_U32_BIT_MUTE_REAS_OTHER = 0x10UL
   };
   tBool bMUTE_REAS_USER_ACTION() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_USER_ACTION) != 0; }
   tVoid vSetMUTE_REAS_USER_ACTION(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_USER_ACTION):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_USER_ACTION)); }
   tBool bMUTE_REAS_START_OF_TRACK() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK) != 0; }
   tVoid vSetMUTE_REAS_START_OF_TRACK(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK)); }
   tBool bMUTE_REAS_SOURCE_SEL() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL) != 0; }
   tVoid vSetMUTE_REAS_SOURCE_SEL(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL)); }
   tBool bMUTE_REAS_DIAG() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_DIAG) != 0; }
   tVoid vSetMUTE_REAS_DIAG(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_DIAG):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_DIAG)); }
   tBool bMUTE_REAS_OTHER() const {return (u32Value & FI_C_U32_BIT_MUTE_REAS_OTHER) != 0; }
   tVoid vSetMUTE_REAS_OTHER(tBool bSetBit) { u32Value = (tU32)((bSetBit)?(u32Value | FI_C_U32_BIT_MUTE_REAS_OTHER):(u32Value & ~(tU32)FI_C_U32_BIT_MUTE_REAS_OTHER)); }
   struct rBitValues {
      tBool MUTE_REAS_USER_ACTION:1;
      tBool MUTE_REAS_START_OF_TRACK:1;
      tBool MUTE_REAS_SOURCE_SEL:1;
      tBool MUTE_REAS_DIAG:1;
      tBool MUTE_REAS_OTHER:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
      tBool dummy16:1;
      tBool dummy17:1;
      tBool dummy18:1;
      tBool dummy19:1;
      tBool dummy20:1;
      tBool dummy21:1;
      tBool dummy22:1;
      tBool dummy23:1;
      tBool dummy24:1;
      tBool dummy25:1;
      tBool dummy26:1;
      tBool dummy27:1;
      tBool dummy28:1;
      tBool dummy29:1;
      tBool dummy30:1;
      tBool dummy31:1;
   };
   union {
      tU32 u32Value;
      rBitValues bits;
   };
   virtual ~mascf_fi_tcl_b32MuteReason();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_b32MuteReason& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MuteState : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MuteState();
   enum tenType {
      FI_EN_MUTE = 1UL,
      FI_EN_DEMUTE = 2UL,
      FI_EN_DEMUTERUNNING = 3UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MuteState(mascf_fi_tcl_e8_MuteState::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MuteState();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MuteState& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_MuteRequestItem : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_MuteRequestItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_MuteRequestItem& operator=(const mascf_fi_tcl_MuteRequestItem& coRef);
   mascf_fi_tcl_MuteRequestItem(const mascf_fi_tcl_MuteRequestItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource u8Source;
   mascf_fi_tcl_e8MuteAction u8Action;
   mascf_fi_tcl_b32MuteReason u32Reason;
   virtual ~mascf_fi_tcl_MuteRequestItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_MuteRequestItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8_MuteRequester : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8_MuteRequester();
   enum tenType {
      FI_EN_AUDIOROUTINGMANAGER = 1UL,
      FI_EN_GENIVIAUDIOMANAGER = 2UL
   };
   tenType enType;

   mascf_fi_tcl_e8_MuteRequester(mascf_fi_tcl_e8_MuteRequester::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8_MuteRequester();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8_MuteRequester& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_e8MuteSpeed : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_e8MuteSpeed();
   enum tenType {
      FI_EN_VERY_FAST = 1UL,
      FI_EN_FAST = 2UL,
      FI_EN_SLOW = 3UL,
      FI_EN_MID = 4UL,
      FI_EN_VERY_SLOW = 5UL
   };
   tenType enType;

   mascf_fi_tcl_e8MuteSpeed(mascf_fi_tcl_e8MuteSpeed::tenType newValue)
      :enType(newValue)
   {}

   virtual ~mascf_fi_tcl_e8MuteSpeed();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const mascf_fi_tcl_e8MuteSpeed& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_SetAudioPropertyItem : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_SetAudioPropertyItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_SetAudioPropertyItem& operator=(const mascf_fi_tcl_SetAudioPropertyItem& coRef);
   mascf_fi_tcl_SetAudioPropertyItem(const mascf_fi_tcl_SetAudioPropertyItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource u8Source;
   tU16 u16SubSource;
   mascf_fi_tcl_e8_AudioProperty u8Property;
   tS32 s32PropValue;
   virtual ~mascf_fi_tcl_SetAudioPropertyItem();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_SetAudioPropertyItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

class mascf_fi_tcl_SourceRouteActivity : public mascf_fi_tclVisitableTypeBase
{
public:

   mascf_fi_tcl_SourceRouteActivity();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mascf_fi_tcl_SourceRouteActivity& operator=(const mascf_fi_tcl_SourceRouteActivity& coRef);
   mascf_fi_tcl_SourceRouteActivity(const mascf_fi_tcl_SourceRouteActivity& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mascf_fi_tcl_e8_AudSource Source;
   tU16 SubSource;
   mascf_fi_tcl_e8_AudSource PossibleNextSource;
   mascf_fi_tcl_e8_ResourceNo Resource;
   mascf_fi_tcl_e8_SrcActivity Activity;
   virtual ~mascf_fi_tcl_SourceRouteActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mascf_fi_tcl_SourceRouteActivity& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(mascf_fi_tclVisitorBase& rfoVisitor);
};

#endif
