/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MASCF_FI_S_IMPORT_INTERFACE_MASCF_MAINFI_TYPES
#define MASCF_FI_S_IMPORT_INTERFACE_MASCF_MAINFI_FUNCTIONIDS
#define MASCF_FI_S_IMPORT_INTERFACE_MASCF_MAINFI_SERVICEINFO
#include "mascf_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for mascf_main_fi message types

fi_tclMessageBase* mascf_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case mascf_mainfi_tclToken::EN_MSG_VOLUMEMODEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeModeMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEMODEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeModeMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_BEEPMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgBeepMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_BEEPMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgBeepMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_BEEPFILEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgBeepFileMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_BEEPFILEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgBeepFileMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_MUTEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgMuteMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_MUTEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgMuteMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgSet_Mute_RampMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgSet_Mute_RampMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOSOURCEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgAudioSourceMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOSOURCEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgAudioSourceMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOTESTTONEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgAudioTestToneMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOTESTTONEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgAudioTestToneMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_CUESTATEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgCueStateMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_CUESTATEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgCueStateMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_PERFORMONVOLUMELIMITMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_SYSTEMMUTEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgSystemMuteMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_SYSTEMMUTEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgSystemMuteMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_SettingSoundMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_SettingSoundMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgEntertainmentMuteMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgEntertainmentMuteMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODSTART:
         return OSAL_NEW mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart;

      case mascf_mainfi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODRESULT:
         return OSAL_NEW mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeModeStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeModeStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeModeStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeModeStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMEGET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeGet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMESET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeSet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeStatus;

      case mascf_mainfi_tclToken::EN_MSG_BEEPSTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBeepStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BEEPSTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBeepStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BEEPSTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgBeepStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_GALAUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgGalaUpReg;

      case mascf_mainfi_tclToken::EN_MSG_GALARELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgGalaRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_GALAGET:
         return OSAL_NEW mascf_mainfi_tclMsgGalaGet;

      case mascf_mainfi_tclToken::EN_MSG_GALASET:
         return OSAL_NEW mascf_mainfi_tclMsgGalaSet;

      case mascf_mainfi_tclToken::EN_MSG_GALASTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgGalaStatus;

      case mascf_mainfi_tclToken::EN_MSG_BALANCEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBalanceUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BALANCERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBalanceRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BALANCEGET:
         return OSAL_NEW mascf_mainfi_tclMsgBalanceGet;

      case mascf_mainfi_tclToken::EN_MSG_BALANCESET:
         return OSAL_NEW mascf_mainfi_tclMsgBalanceSet;

      case mascf_mainfi_tclToken::EN_MSG_BALANCESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgBalanceStatus;

      case mascf_mainfi_tclToken::EN_MSG_LOUDNESSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgLoudnessUpReg;

      case mascf_mainfi_tclToken::EN_MSG_LOUDNESSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgLoudnessRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_LOUDNESSGET:
         return OSAL_NEW mascf_mainfi_tclMsgLoudnessGet;

      case mascf_mainfi_tclToken::EN_MSG_LOUDNESSSET:
         return OSAL_NEW mascf_mainfi_tclMsgLoudnessSet;

      case mascf_mainfi_tclToken::EN_MSG_LOUDNESSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgLoudnessStatus;

      case mascf_mainfi_tclToken::EN_MSG_BASSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBassUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BASSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBassRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BASSGET:
         return OSAL_NEW mascf_mainfi_tclMsgBassGet;

      case mascf_mainfi_tclToken::EN_MSG_BASSSET:
         return OSAL_NEW mascf_mainfi_tclMsgBassSet;

      case mascf_mainfi_tclToken::EN_MSG_BASSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgBassStatus;

      case mascf_mainfi_tclToken::EN_MSG_TREBLEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgTrebleUpReg;

      case mascf_mainfi_tclToken::EN_MSG_TREBLERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgTrebleRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_TREBLEGET:
         return OSAL_NEW mascf_mainfi_tclMsgTrebleGet;

      case mascf_mainfi_tclToken::EN_MSG_TREBLESET:
         return OSAL_NEW mascf_mainfi_tclMsgTrebleSet;

      case mascf_mainfi_tclToken::EN_MSG_TREBLESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgTrebleStatus;

      case mascf_mainfi_tclToken::EN_MSG_FADERUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgFaderUpReg;

      case mascf_mainfi_tclToken::EN_MSG_FADERRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgFaderRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_FADERGET:
         return OSAL_NEW mascf_mainfi_tclMsgFaderGet;

      case mascf_mainfi_tclToken::EN_MSG_FADERSET:
         return OSAL_NEW mascf_mainfi_tclMsgFaderSet;

      case mascf_mainfi_tclToken::EN_MSG_FADERSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgFaderStatus;

      case mascf_mainfi_tclToken::EN_MSG_MIDRANGEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMidRangeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MIDRANGERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMidRangeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MIDRANGEGET:
         return OSAL_NEW mascf_mainfi_tclMsgMidRangeGet;

      case mascf_mainfi_tclToken::EN_MSG_MIDRANGESET:
         return OSAL_NEW mascf_mainfi_tclMsgMidRangeSet;

      case mascf_mainfi_tclToken::EN_MSG_MIDRANGESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgMidRangeStatus;

      case mascf_mainfi_tclToken::EN_MSG_MEMSOUNDUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMemSoundUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MEMSOUNDRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMemSoundRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MEMSOUNDSET:
         return OSAL_NEW mascf_mainfi_tclMsgMemSoundSet;

      case mascf_mainfi_tclToken::EN_MSG_MEMSOUNDSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgMemSoundStatus;

      case mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgFaderActivationStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgFaderActivationStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgFaderActivationStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgFaderActivationStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDynamicCompressionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDynamicCompressionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgDynamicCompressionGet;

      case mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSET:
         return OSAL_NEW mascf_mainfi_tclMsgDynamicCompressionSet;

      case mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgDynamicCompressionStatus;

      case mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgOptimizationUpReg;

      case mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgOptimizationRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgOptimizationGet;

      case mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONSET:
         return OSAL_NEW mascf_mainfi_tclMsgOptimizationSet;

      case mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgOptimizationStatus;

      case mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgEqualiserPresetUpReg;

      case mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgEqualiserPresetRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETGET:
         return OSAL_NEW mascf_mainfi_tclMsgEqualiserPresetGet;

      case mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETSET:
         return OSAL_NEW mascf_mainfi_tclMsgEqualiserPresetSet;

      case mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgEqualiserPresetStatus;

      case mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDiagAudModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDiagAudModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgDiagAudModeGet;

      case mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgDiagAudModeSet;

      case mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgDiagAudModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUXINLEVELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAuxInLevelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUXINLEVELRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAuxInLevelRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUXINLEVELGET:
         return OSAL_NEW mascf_mainfi_tclMsgAuxInLevelGet;

      case mascf_mainfi_tclToken::EN_MSG_AUXINLEVELSET:
         return OSAL_NEW mascf_mainfi_tclMsgAuxInLevelSet;

      case mascf_mainfi_tclToken::EN_MSG_AUXINLEVELSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAuxInLevelStatus;

      case mascf_mainfi_tclToken::EN_MSG_BEEPLEVELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBeepLevelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BEEPLEVELRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBeepLevelRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BEEPLEVELGET:
         return OSAL_NEW mascf_mainfi_tclMsgBeepLevelGet;

      case mascf_mainfi_tclToken::EN_MSG_BEEPLEVELSET:
         return OSAL_NEW mascf_mainfi_tclMsgBeepLevelSet;

      case mascf_mainfi_tclToken::EN_MSG_BEEPLEVELSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgBeepLevelStatus;

      case mascf_mainfi_tclToken::EN_MSG_REAR_MUTEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRear_MuteUpReg;

      case mascf_mainfi_tclToken::EN_MSG_REAR_MUTERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRear_MuteRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_REAR_MUTEGET:
         return OSAL_NEW mascf_mainfi_tclMsgRear_MuteGet;

      case mascf_mainfi_tclToken::EN_MSG_REAR_MUTESET:
         return OSAL_NEW mascf_mainfi_tclMsgRear_MuteSet;

      case mascf_mainfi_tclToken::EN_MSG_REAR_MUTESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRear_MuteStatus;

      case mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgGeometry_ModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgGeometry_ModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgGeometry_ModeGet;

      case mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODESET:
         return OSAL_NEW mascf_mainfi_tclMsgGeometry_ModeSet;

      case mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgGeometry_ModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgLSValueStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgLSValueStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgLSValueStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgLSValueStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationLevelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELGET:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationLevelGet;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELSET:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationLevelSet;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationLevelStatus;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationUpReg;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationGet;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONSET:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationSet;

      case mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgPDCAttenuationStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioDeviceStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioDeviceStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAudioDeviceStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempReductionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempReductionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempReductionGet;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONSET:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempReductionSet;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempReductionStatus;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempAmplifierStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgOverTempAmplifierStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgReadMeasurementResultUpReg;

      case mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgReadMeasurementResultRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTGET:
         return OSAL_NEW mascf_mainfi_tclMsgReadMeasurementResultGet;

      case mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgReadMeasurementResultStatus;

      case mascf_mainfi_tclToken::EN_MSG_CENTERUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgCenterUpReg;

      case mascf_mainfi_tclToken::EN_MSG_CENTERRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgCenterRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_CENTERGET:
         return OSAL_NEW mascf_mainfi_tclMsgCenterGet;

      case mascf_mainfi_tclToken::EN_MSG_CENTERSET:
         return OSAL_NEW mascf_mainfi_tclMsgCenterSet;

      case mascf_mainfi_tclToken::EN_MSG_CENTERSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgCenterStatus;

      case mascf_mainfi_tclToken::EN_MSG_SUBWOOFERUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSubWooferUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SUBWOOFERRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSubWooferRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SUBWOOFERGET:
         return OSAL_NEW mascf_mainfi_tclMsgSubWooferGet;

      case mascf_mainfi_tclToken::EN_MSG_SUBWOOFERSET:
         return OSAL_NEW mascf_mainfi_tclMsgSubWooferSet;

      case mascf_mainfi_tclToken::EN_MSG_SUBWOOFERSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgSubWooferStatus;

      case mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg;

      case mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEGET:
         return OSAL_NEW mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet;

      case mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus;

      case mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgGeneralSpeakerTestUpReg;

      case mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTGET:
         return OSAL_NEW mascf_mainfi_tclMsgGeneralSpeakerTestGet;

      case mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTSET:
         return OSAL_NEW mascf_mainfi_tclMsgGeneralSpeakerTestSet;

      case mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgGeneralSpeakerTestStatus;

      case mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCSWVersionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCSWVersionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgANCSWVersionGet;

      case mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgANCSWVersionStatus;

      case mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgASCSWVersionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgASCSWVersionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgASCSWVersionGet;

      case mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgASCSWVersionStatus;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSettingUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSettingRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGGET:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSettingGet;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGSET:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSettingSet;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSettingStatus;

      case mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpSoftwareVersionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgAmpSoftwareVersionGet;

      case mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAmpSoftwareVersionStatus;

      case mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpParameterVersionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpParameterVersionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgAmpParameterVersionGet;

      case mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAmpParameterVersionStatus;

      case mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpHardwareVersionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgAmpHardwareVersionGet;

      case mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAmpHardwareVersionStatus;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundVolUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundVolRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLGET:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundVolGet;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLSET:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundVolSet;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundVolStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotModeGet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotModeSet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundModeGet;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundModeSet;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDownMixModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDownMixModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDownMixModeGet;

      case mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDownMixModeSet;

      case mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAmpDownMixModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDriverSoundModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDriverSoundModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgDriverSoundModeGet;

      case mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgDriverSoundModeSet;

      case mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgDriverSoundModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRearSoundModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRearSoundModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgRearSoundModeGet;

      case mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgRearSoundModeSet;

      case mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRearSoundModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioOFFMuteStateUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATESET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioOFFMuteStateSet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAudioOFFMuteStateStatus;

      case mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgMicrophoneConnectionStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_CONNECTIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgConnectionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_CONNECTIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgConnectionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_CONNECTIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgConnectionGet;

      case mascf_mainfi_tclToken::EN_MSG_CONNECTIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgConnectionStatus;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELISTUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeListUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELISTRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeListRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELISTGET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeListGet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELISTSET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeListSet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELISTSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeListStatus;

      case mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBTAudioInLevelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgBTAudioInLevelRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELGET:
         return OSAL_NEW mascf_mainfi_tclMsgBTAudioInLevelGet;

      case mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELSET:
         return OSAL_NEW mascf_mainfi_tclMsgBTAudioInLevelSet;

      case mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgBTAudioInLevelStatus;

      case mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATAUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgEngineeringDataUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATARELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgEngineeringDataRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATAGET:
         return OSAL_NEW mascf_mainfi_tclMsgEngineeringDataGet;

      case mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATASET:
         return OSAL_NEW mascf_mainfi_tclMsgEngineeringDataSet;

      case mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATASTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgEngineeringDataStatus;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundSettingUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundSettingRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGGET:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundSettingGet;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGSET:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundSettingSet;

      case mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgSurroundSettingStatus;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeLockUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeLockRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKGET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeLockGet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKSET:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeLockSet;

      case mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgVolumeLockStatus;

      case mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpAvailFunctionUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgAmpAvailFunctionGet;

      case mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAmpAvailFunctionStatus;

      case mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSetAudioPropertyUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSetAudioPropertyRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYGET:
         return OSAL_NEW mascf_mainfi_tclMsgSetAudioPropertyGet;

      case mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYSET:
         return OSAL_NEW mascf_mainfi_tclMsgSetAudioPropertySet;

      case mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgSetAudioPropertyStatus;

      case mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgEntOnVolumeSetupUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPSET:
         return OSAL_NEW mascf_mainfi_tclMsgEntOnVolumeSetupSet;

      case mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgEntOnVolumeSetupStatus;

      case mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRoomEffectUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRoomEffectRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTGET:
         return OSAL_NEW mascf_mainfi_tclMsgRoomEffectGet;

      case mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTSET:
         return OSAL_NEW mascf_mainfi_tclMsgRoomEffectSet;

      case mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRoomEffectStatus;

      case mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgFMEnhancerModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgFMEnhancerModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgFMEnhancerModeGet;

      case mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgFMEnhancerModeSet;

      case mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgFMEnhancerModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDiagDefSetPhaseUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASEGET:
         return OSAL_NEW mascf_mainfi_tclMsgDiagDefSetPhaseGet;

      case mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgDiagDefSetPhaseStatus;

      case mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgESESoundTypeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgESESoundTypeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPEGET:
         return OSAL_NEW mascf_mainfi_tclMsgESESoundTypeGet;

      case mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPESET:
         return OSAL_NEW mascf_mainfi_tclMsgESESoundTypeSet;

      case mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgESESoundTypeStatus;

      case mascf_mainfi_tclToken::EN_MSG_ESEVOLUMEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgESEVolumeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ESEVOLUMERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgESEVolumeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ESEVOLUMEGET:
         return OSAL_NEW mascf_mainfi_tclMsgESEVolumeGet;

      case mascf_mainfi_tclToken::EN_MSG_ESEVOLUMESET:
         return OSAL_NEW mascf_mainfi_tclMsgESEVolumeSet;

      case mascf_mainfi_tclToken::EN_MSG_ESEVOLUMESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgESEVolumeStatus;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundOnOffUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundOnOffRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFGET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundOnOffGet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFSET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundOnOffSet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundOnOffStatus;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundSoundTypeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPEGET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundSoundTypeGet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPESET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundSoundTypeSet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundSoundTypeStatus;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundVolumeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundVolumeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMEGET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundVolumeGet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMESET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundVolumeSet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundVolumeStatus;

      case mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgESEDriveModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgESEDriveModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgESEDriveModeGet;

      case mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODESET:
         return OSAL_NEW mascf_mainfi_tclMsgESEDriveModeSet;

      case mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgESEDriveModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOMODEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioModeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOMODERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioModeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOMODEGET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioModeGet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOMODESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAudioModeStatus;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEGET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPASoundTypeGet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPASoundTypeSet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPASoundTypeStatus;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEGET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPAMuteUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTEGET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPAMuteGet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTESET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPAMuteSet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_UPAMuteStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAutomaticGainControlUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAutomaticGainControlRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLGET:
         return OSAL_NEW mascf_mainfi_tclMsgAutomaticGainControlGet;

      case mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSET:
         return OSAL_NEW mascf_mainfi_tclMsgAutomaticGainControlSet;

      case mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAutomaticGainControlStatus;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEGET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESET:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet;

      case mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundActivationUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundActivationRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONGET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundActivationGet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONSET:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundActivationSet;

      case mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgRSoundActivationStatus;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCActiveTestUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCActiveTestRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTGET:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCActiveTestGet;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTSET:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCActiveTestSet;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCActiveTestStatus;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSGET:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSET:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet;

      case mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus;

      case mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgUserProfileChangeUpReg;

      case mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgUserProfileChangeRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGEGET:
         return OSAL_NEW mascf_mainfi_tclMsgUserProfileChangeGet;

      case mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGESET:
         return OSAL_NEW mascf_mainfi_tclMsgUserProfileChangeSet;

      case mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgUserProfileChangeStatus;

      case mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSRSoundNotificationStateUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATERELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEGET:
         return OSAL_NEW mascf_mainfi_tclMsgSRSoundNotificationStateGet;

      case mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESET:
         return OSAL_NEW mascf_mainfi_tclMsgSRSoundNotificationStateSet;

      case mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgSRSoundNotificationStateStatus;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotIntensityUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYGET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotIntensityGet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSET:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotIntensitySet;

      case mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgAudioPilotIntensityStatus;

      case mascf_mainfi_tclToken::EN_MSG_MAINAUDIOATTENUATIONUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMainAudioAttenuationUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MAINAUDIOATTENUATIONRELUPREG:
         return OSAL_NEW mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg;

      case mascf_mainfi_tclToken::EN_MSG_MAINAUDIOATTENUATIONSTATUS:
         return OSAL_NEW mascf_mainfi_tclMsgMainAudioAttenuationStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all mascf_mainfifi messages

// common functions

tU16 mascf_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MASCF_MAINFI_C_U16_SERVICE_ID;
}

tU16 mascf_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 mascf_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& mascf_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& mascf_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 mascf_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& mascf_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& mascf_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeModeMethodStart::mascf_mainfi_tclMsgVolumeModeMethodStart(const mascf_mainfi_tclMsgVolumeModeMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgVolumeModeMethodStart& mascf_mainfi_tclMsgVolumeModeMethodStart::operator=(const mascf_mainfi_tclMsgVolumeModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeModeMethodStart::mascf_mainfi_tclMsgVolumeModeMethodStart()
:VolumeMode()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgVolumeModeMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEMODEMETHODSTART;
}


mascf_mainfi_tclMsgVolumeModeMethodStart::~mascf_mainfi_tclMsgVolumeModeMethodStart()
{}

tU32 mascf_mainfi_tclMsgVolumeModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeMode);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeMode);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeModeMethodStart::operator==(const mascf_mainfi_tclMsgVolumeModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeMode == roRef.VolumeMode);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeModeMethodResult::mascf_mainfi_tclMsgVolumeModeMethodResult(const mascf_mainfi_tclMsgVolumeModeMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mascf_mainfi_tclMsgVolumeModeMethodResult& mascf_mainfi_tclMsgVolumeModeMethodResult::operator=(const mascf_mainfi_tclMsgVolumeModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeModeMethodResult::mascf_mainfi_tclMsgVolumeModeMethodResult()
:ServiceStatus()
 {}

tS32 mascf_mainfi_tclMsgVolumeModeMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEMODEMETHODRESULT;
}


mascf_mainfi_tclMsgVolumeModeMethodResult::~mascf_mainfi_tclMsgVolumeModeMethodResult()
{}

tU32 mascf_mainfi_tclMsgVolumeModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeModeMethodResult::operator==(const mascf_mainfi_tclMsgVolumeModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepMethodStart::mascf_mainfi_tclMsgBeepMethodStart(const mascf_mainfi_tclMsgBeepMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   BeepType = coRef.BeepType;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgBeepMethodStart& mascf_mainfi_tclMsgBeepMethodStart::operator=(const mascf_mainfi_tclMsgBeepMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BeepType = coRef.BeepType;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBeepMethodStart::mascf_mainfi_tclMsgBeepMethodStart()
:BeepType()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgBeepMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPMETHODSTART;
}


mascf_mainfi_tclMsgBeepMethodStart::~mascf_mainfi_tclMsgBeepMethodStart()
{}

tU32 mascf_mainfi_tclMsgBeepMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgBeepMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepType);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepType);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepMethodStart::operator==(const mascf_mainfi_tclMsgBeepMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepType == roRef.BeepType);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepMethodResult::mascf_mainfi_tclMsgBeepMethodResult(const mascf_mainfi_tclMsgBeepMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mascf_mainfi_tclMsgBeepMethodResult& mascf_mainfi_tclMsgBeepMethodResult::operator=(const mascf_mainfi_tclMsgBeepMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBeepMethodResult::mascf_mainfi_tclMsgBeepMethodResult()
:ServiceStatus()
 {}

tS32 mascf_mainfi_tclMsgBeepMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPMETHODRESULT;
}


mascf_mainfi_tclMsgBeepMethodResult::~mascf_mainfi_tclMsgBeepMethodResult()
{}

tU32 mascf_mainfi_tclMsgBeepMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgBeepMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepMethodResult::operator==(const mascf_mainfi_tclMsgBeepMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepFileMethodStart::mascf_mainfi_tclMsgBeepFileMethodStart(const mascf_mainfi_tclMsgBeepFileMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   sFilePath = coRef.sFilePath;
   oConfig = coRef.oConfig;
}
mascf_mainfi_tclMsgBeepFileMethodStart& mascf_mainfi_tclMsgBeepFileMethodStart::operator=(const mascf_mainfi_tclMsgBeepFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sFilePath = coRef.sFilePath;
   oConfig = coRef.oConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgBeepFileMethodStart::vDestroy()
{
   sFilePath.vDestroy();
   oConfig.vDestroy(); 
}

mascf_mainfi_tclMsgBeepFileMethodStart::mascf_mainfi_tclMsgBeepFileMethodStart()
:sFilePath()
,oConfig()
 {}

tS32 mascf_mainfi_tclMsgBeepFileMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPFILEMETHODSTART;
}


mascf_mainfi_tclMsgBeepFileMethodStart::~mascf_mainfi_tclMsgBeepFileMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgBeepFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+sFilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgBeepFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilePath);
   (tVoid) (oIn >> oConfig);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilePath);
   (tVoid) (oOut << oConfig);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepFileMethodStart::operator==(const mascf_mainfi_tclMsgBeepFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilePath == roRef.sFilePath);
   bResult = bResult && (oConfig == roRef.oConfig);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepFileMethodResult::mascf_mainfi_tclMsgBeepFileMethodResult(const mascf_mainfi_tclMsgBeepFileMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
   u32Token = coRef.u32Token;
}
mascf_mainfi_tclMsgBeepFileMethodResult& mascf_mainfi_tclMsgBeepFileMethodResult::operator=(const mascf_mainfi_tclMsgBeepFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   u32Token = coRef.u32Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBeepFileMethodResult::mascf_mainfi_tclMsgBeepFileMethodResult()
:ServiceStatus()
,u32Token(0)
 {}

tS32 mascf_mainfi_tclMsgBeepFileMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPFILEMETHODRESULT;
}


mascf_mainfi_tclMsgBeepFileMethodResult::~mascf_mainfi_tclMsgBeepFileMethodResult()
{}

tU32 mascf_mainfi_tclMsgBeepFileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_mainfi_tclMsgBeepFileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   (tVoid) (oIn >> u32Token);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   (tVoid) (oOut << u32Token);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepFileMethodResult::operator==(const mascf_mainfi_tclMsgBeepFileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   bResult = bResult && (u32Token == roRef.u32Token);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMuteMethodStart::mascf_mainfi_tclMsgMuteMethodStart(const mascf_mainfi_tclMsgMuteMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgMuteMethodStart& mascf_mainfi_tclMsgMuteMethodStart::operator=(const mascf_mainfi_tclMsgMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMuteMethodStart::mascf_mainfi_tclMsgMuteMethodStart()
:Requester()
,Resource()
,State()
,Reason()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgMuteMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MUTEMETHODSTART;
}


mascf_mainfi_tclMsgMuteMethodStart::~mascf_mainfi_tclMsgMuteMethodStart()
{}

tU32 mascf_mainfi_tclMsgMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mascf_mainfi_tclMsgMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Reason);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Reason);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgMuteMethodStart::operator==(const mascf_mainfi_tclMsgMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Reason == roRef.Reason);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMuteMethodResult::mascf_mainfi_tclMsgMuteMethodResult(const mascf_mainfi_tclMsgMuteMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgMuteMethodResult& mascf_mainfi_tclMsgMuteMethodResult::operator=(const mascf_mainfi_tclMsgMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMuteMethodResult::mascf_mainfi_tclMsgMuteMethodResult()
:Requester()
,Resource()
,State()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgMuteMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MUTEMETHODRESULT;
}


mascf_mainfi_tclMsgMuteMethodResult::~mascf_mainfi_tclMsgMuteMethodResult()
{}

tU32 mascf_mainfi_tclMsgMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_mainfi_tclMsgMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgMuteMethodResult::operator==(const mascf_mainfi_tclMsgMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSet_Mute_RampMethodStart::mascf_mainfi_tclMsgSet_Mute_RampMethodStart(const mascf_mainfi_tclMsgSet_Mute_RampMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgSet_Mute_RampMethodStart& mascf_mainfi_tclMsgSet_Mute_RampMethodStart::operator=(const mascf_mainfi_tclMsgSet_Mute_RampMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSet_Mute_RampMethodStart::mascf_mainfi_tclMsgSet_Mute_RampMethodStart()
:Resource()
,State()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgSet_Mute_RampMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODSTART;
}


mascf_mainfi_tclMsgSet_Mute_RampMethodStart::~mascf_mainfi_tclMsgSet_Mute_RampMethodStart()
{}

tU32 mascf_mainfi_tclMsgSet_Mute_RampMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgSet_Mute_RampMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSet_Mute_RampMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgSet_Mute_RampMethodStart::operator==(const mascf_mainfi_tclMsgSet_Mute_RampMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSet_Mute_RampMethodResult::mascf_mainfi_tclMsgSet_Mute_RampMethodResult(const mascf_mainfi_tclMsgSet_Mute_RampMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mascf_mainfi_tclMsgSet_Mute_RampMethodResult& mascf_mainfi_tclMsgSet_Mute_RampMethodResult::operator=(const mascf_mainfi_tclMsgSet_Mute_RampMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSet_Mute_RampMethodResult::mascf_mainfi_tclMsgSet_Mute_RampMethodResult()
:ServiceStatus()
 {}

tS32 mascf_mainfi_tclMsgSet_Mute_RampMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODRESULT;
}


mascf_mainfi_tclMsgSet_Mute_RampMethodResult::~mascf_mainfi_tclMsgSet_Mute_RampMethodResult()
{}

tU32 mascf_mainfi_tclMsgSet_Mute_RampMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSet_Mute_RampMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSet_Mute_RampMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgSet_Mute_RampMethodResult::operator==(const mascf_mainfi_tclMsgSet_Mute_RampMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioSourceMethodStart::mascf_mainfi_tclMsgAudioSourceMethodStart(const mascf_mainfi_tclMsgAudioSourceMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   Source = coRef.Source;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgAudioSourceMethodStart& mascf_mainfi_tclMsgAudioSourceMethodStart::operator=(const mascf_mainfi_tclMsgAudioSourceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   Source = coRef.Source;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioSourceMethodStart::mascf_mainfi_tclMsgAudioSourceMethodStart()
:Resource()
,Source()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgAudioSourceMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOSOURCEMETHODSTART;
}


mascf_mainfi_tclMsgAudioSourceMethodStart::~mascf_mainfi_tclMsgAudioSourceMethodStart()
{}

tU32 mascf_mainfi_tclMsgAudioSourceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioSourceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioSourceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioSourceMethodStart::operator==(const mascf_mainfi_tclMsgAudioSourceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioSourceMethodResult::mascf_mainfi_tclMsgAudioSourceMethodResult(const mascf_mainfi_tclMsgAudioSourceMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mascf_mainfi_tclMsgAudioSourceMethodResult& mascf_mainfi_tclMsgAudioSourceMethodResult::operator=(const mascf_mainfi_tclMsgAudioSourceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioSourceMethodResult::mascf_mainfi_tclMsgAudioSourceMethodResult()
:ServiceStatus()
 {}

tS32 mascf_mainfi_tclMsgAudioSourceMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOSOURCEMETHODRESULT;
}


mascf_mainfi_tclMsgAudioSourceMethodResult::~mascf_mainfi_tclMsgAudioSourceMethodResult()
{}

tU32 mascf_mainfi_tclMsgAudioSourceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioSourceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioSourceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioSourceMethodResult::operator==(const mascf_mainfi_tclMsgAudioSourceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Source = coRef.Source;
   AudProcAdev = coRef.AudProcAdev;
   MsgHandle = coRef.MsgHandle;
   Action = coRef.Action;
}
mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::operator=(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Source = coRef.Source;
   AudProcAdev = coRef.AudProcAdev;
   MsgHandle = coRef.MsgHandle;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::vDestroy()
{
   AudProcAdev.vDestroy();
}

mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart()
:Resource()
,Channel()
,Source()
,AudProcAdev()
,MsgHandle(0)
,Action()
 {}

tS32 mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODSTART;
}


mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::~mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+AudProcAdev.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> AudProcAdev);
   (tVoid) (oIn >> MsgHandle);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << AudProcAdev);
   (tVoid) (oOut << MsgHandle);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart::operator==(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (AudProcAdev == roRef.AudProcAdev);
   bResult = bResult && (MsgHandle == roRef.MsgHandle);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
   MsgHandle = coRef.MsgHandle;
}
mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::operator=(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   MsgHandle = coRef.MsgHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult()
:ServiceStatus()
,MsgHandle(0)
 {}

tS32 mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODRESULT;
}


mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::~mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult()
{}

tU32 mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   (tVoid) (oIn >> MsgHandle);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   (tVoid) (oOut << MsgHandle);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult::operator==(const mascf_mainfi_tclMsgAmpDeviceAudioRouteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   bResult = bResult && (MsgHandle == roRef.MsgHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioTestToneMethodStart::mascf_mainfi_tclMsgAudioTestToneMethodStart(const mascf_mainfi_tclMsgAudioTestToneMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ChannelSelect = coRef.ChannelSelect;
   Frequency = coRef.Frequency;
   Volume = coRef.Volume;
}
mascf_mainfi_tclMsgAudioTestToneMethodStart& mascf_mainfi_tclMsgAudioTestToneMethodStart::operator=(const mascf_mainfi_tclMsgAudioTestToneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ChannelSelect = coRef.ChannelSelect;
   Frequency = coRef.Frequency;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioTestToneMethodStart::mascf_mainfi_tclMsgAudioTestToneMethodStart()
:ChannelSelect()
,Frequency(0)
,Volume()
 {}

tS32 mascf_mainfi_tclMsgAudioTestToneMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOTESTTONEMETHODSTART;
}


mascf_mainfi_tclMsgAudioTestToneMethodStart::~mascf_mainfi_tclMsgAudioTestToneMethodStart()
{}

tU32 mascf_mainfi_tclMsgAudioTestToneMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioTestToneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelSelect);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioTestToneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelSelect);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioTestToneMethodStart::operator==(const mascf_mainfi_tclMsgAudioTestToneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelSelect == roRef.ChannelSelect);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioTestToneMethodResult::mascf_mainfi_tclMsgAudioTestToneMethodResult(const mascf_mainfi_tclMsgAudioTestToneMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ChannelSelect = coRef.ChannelSelect;
   Status = coRef.Status;
}
mascf_mainfi_tclMsgAudioTestToneMethodResult& mascf_mainfi_tclMsgAudioTestToneMethodResult::operator=(const mascf_mainfi_tclMsgAudioTestToneMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelSelect = coRef.ChannelSelect;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioTestToneMethodResult::mascf_mainfi_tclMsgAudioTestToneMethodResult()
:ChannelSelect()
,Status()
 {}

tS32 mascf_mainfi_tclMsgAudioTestToneMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOTESTTONEMETHODRESULT;
}


mascf_mainfi_tclMsgAudioTestToneMethodResult::~mascf_mainfi_tclMsgAudioTestToneMethodResult()
{}

tU32 mascf_mainfi_tclMsgAudioTestToneMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioTestToneMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelSelect);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioTestToneMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelSelect);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioTestToneMethodResult::operator==(const mascf_mainfi_tclMsgAudioTestToneMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelSelect == roRef.ChannelSelect);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgCueStateMethodStart::mascf_mainfi_tclMsgCueStateMethodStart(const mascf_mainfi_tclMsgCueStateMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   Source = coRef.Source;
}
mascf_mainfi_tclMsgCueStateMethodStart& mascf_mainfi_tclMsgCueStateMethodStart::operator=(const mascf_mainfi_tclMsgCueStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgCueStateMethodStart::mascf_mainfi_tclMsgCueStateMethodStart()
:State()
,Source()
 {}

tS32 mascf_mainfi_tclMsgCueStateMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CUESTATEMETHODSTART;
}


mascf_mainfi_tclMsgCueStateMethodStart::~mascf_mainfi_tclMsgCueStateMethodStart()
{}

tU32 mascf_mainfi_tclMsgCueStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgCueStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgCueStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool mascf_mainfi_tclMsgCueStateMethodStart::operator==(const mascf_mainfi_tclMsgCueStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgCueStateMethodResult::mascf_mainfi_tclMsgCueStateMethodResult(const mascf_mainfi_tclMsgCueStateMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mascf_mainfi_tclMsgCueStateMethodResult& mascf_mainfi_tclMsgCueStateMethodResult::operator=(const mascf_mainfi_tclMsgCueStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgCueStateMethodResult::mascf_mainfi_tclMsgCueStateMethodResult()
:ServiceStatus()
 {}

tS32 mascf_mainfi_tclMsgCueStateMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CUESTATEMETHODRESULT;
}


mascf_mainfi_tclMsgCueStateMethodResult::~mascf_mainfi_tclMsgCueStateMethodResult()
{}

tU32 mascf_mainfi_tclMsgCueStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgCueStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgCueStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgCueStateMethodResult::operator==(const mascf_mainfi_tclMsgCueStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart::mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart()
 {}

tS32 mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PERFORMONVOLUMELIMITMETHODSTART;
}


mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart::~mascf_mainfi_tclMsgPerformOnVolumeLimitMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DC_Mode = coRef.DC_Mode;
   AC_Mode = coRef.AC_Mode;
}
mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::operator=(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DC_Mode = coRef.DC_Mode;
   AC_Mode = coRef.AC_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart()
:DC_Mode()
,AC_Mode()
 {}

tS32 mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODSTART;
}


mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::~mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart()
{}

tU32 mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DC_Mode);
   (tVoid) (oIn >> AC_Mode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DC_Mode);
   (tVoid) (oOut << AC_Mode);
   return oOut;
}

tBool mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart::operator==(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DC_Mode == roRef.DC_Mode);
   bResult = bResult && (AC_Mode == roRef.AC_Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::operator=(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult()
:Status()
 {}

tS32 mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODRESULT;
}


mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::~mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult()
{}

tU32 mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult::operator==(const mascf_mainfi_tclMsgSpeakerDiagnosisStartMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSystemMuteMethodStart::mascf_mainfi_tclMsgSystemMuteMethodStart(const mascf_mainfi_tclMsgSystemMuteMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
}
mascf_mainfi_tclMsgSystemMuteMethodStart& mascf_mainfi_tclMsgSystemMuteMethodStart::operator=(const mascf_mainfi_tclMsgSystemMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSystemMuteMethodStart::mascf_mainfi_tclMsgSystemMuteMethodStart()
:Requester()
,Resource()
,State()
,Reason()
 {}

tS32 mascf_mainfi_tclMsgSystemMuteMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SYSTEMMUTEMETHODSTART;
}


mascf_mainfi_tclMsgSystemMuteMethodStart::~mascf_mainfi_tclMsgSystemMuteMethodStart()
{}

tU32 mascf_mainfi_tclMsgSystemMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& mascf_mainfi_tclMsgSystemMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Reason);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSystemMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Reason);
   return oOut;
}

tBool mascf_mainfi_tclMsgSystemMuteMethodStart::operator==(const mascf_mainfi_tclMsgSystemMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Reason == roRef.Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSystemMuteMethodResult::mascf_mainfi_tclMsgSystemMuteMethodResult(const mascf_mainfi_tclMsgSystemMuteMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
}
mascf_mainfi_tclMsgSystemMuteMethodResult& mascf_mainfi_tclMsgSystemMuteMethodResult::operator=(const mascf_mainfi_tclMsgSystemMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSystemMuteMethodResult::mascf_mainfi_tclMsgSystemMuteMethodResult()
:Requester()
,Resource()
,State()
 {}

tS32 mascf_mainfi_tclMsgSystemMuteMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SYSTEMMUTEMETHODRESULT;
}


mascf_mainfi_tclMsgSystemMuteMethodResult::~mascf_mainfi_tclMsgSystemMuteMethodResult()
{}

tU32 mascf_mainfi_tclMsgSystemMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgSystemMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSystemMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   return oOut;
}

tBool mascf_mainfi_tclMsgSystemMuteMethodResult::operator==(const mascf_mainfi_tclMsgSystemMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::mascf_mainfi_tclMsgADAS_SettingSoundMethodStart(const mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SettingSound = coRef.SettingSound;
}
mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::operator=(const mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SettingSound = coRef.SettingSound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::mascf_mainfi_tclMsgADAS_SettingSoundMethodStart()
:SettingSound()
 {}

tS32 mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODSTART;
}


mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::~mascf_mainfi_tclMsgADAS_SettingSoundMethodStart()
{}

tU32 mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SettingSound);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SettingSound);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_SettingSoundMethodStart::operator==(const mascf_mainfi_tclMsgADAS_SettingSoundMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SettingSound == roRef.SettingSound);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::mascf_mainfi_tclMsgADAS_SettingSoundMethodResult(const mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::operator=(const mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::mascf_mainfi_tclMsgADAS_SettingSoundMethodResult()
:ServiceStatus()
 {}

tS32 mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODRESULT;
}


mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::~mascf_mainfi_tclMsgADAS_SettingSoundMethodResult()
{}

tU32 mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_SettingSoundMethodResult::operator==(const mascf_mainfi_tclMsgADAS_SettingSoundMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEntertainmentMuteMethodStart::mascf_mainfi_tclMsgEntertainmentMuteMethodStart(const mascf_mainfi_tclMsgEntertainmentMuteMethodStart& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
}
mascf_mainfi_tclMsgEntertainmentMuteMethodStart& mascf_mainfi_tclMsgEntertainmentMuteMethodStart::operator=(const mascf_mainfi_tclMsgEntertainmentMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgEntertainmentMuteMethodStart::mascf_mainfi_tclMsgEntertainmentMuteMethodStart()
:Requester()
,Resource()
,State()
,Reason()
 {}

tS32 mascf_mainfi_tclMsgEntertainmentMuteMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODSTART;
}


mascf_mainfi_tclMsgEntertainmentMuteMethodStart::~mascf_mainfi_tclMsgEntertainmentMuteMethodStart()
{}

tU32 mascf_mainfi_tclMsgEntertainmentMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& mascf_mainfi_tclMsgEntertainmentMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Reason);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEntertainmentMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Reason);
   return oOut;
}

tBool mascf_mainfi_tclMsgEntertainmentMuteMethodStart::operator==(const mascf_mainfi_tclMsgEntertainmentMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Reason == roRef.Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEntertainmentMuteMethodResult::mascf_mainfi_tclMsgEntertainmentMuteMethodResult(const mascf_mainfi_tclMsgEntertainmentMuteMethodResult& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
}
mascf_mainfi_tclMsgEntertainmentMuteMethodResult& mascf_mainfi_tclMsgEntertainmentMuteMethodResult::operator=(const mascf_mainfi_tclMsgEntertainmentMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgEntertainmentMuteMethodResult::mascf_mainfi_tclMsgEntertainmentMuteMethodResult()
:Requester()
,Resource()
,State()
 {}

tS32 mascf_mainfi_tclMsgEntertainmentMuteMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODRESULT;
}


mascf_mainfi_tclMsgEntertainmentMuteMethodResult::~mascf_mainfi_tclMsgEntertainmentMuteMethodResult()
{}

tU32 mascf_mainfi_tclMsgEntertainmentMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgEntertainmentMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEntertainmentMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   return oOut;
}

tBool mascf_mainfi_tclMsgEntertainmentMuteMethodResult::operator==(const mascf_mainfi_tclMsgEntertainmentMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart::mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart()
 {}

tS32 mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODSTART;
}


mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart::~mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodStart()
{}

//=============================================================================

mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult::mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult()
 {}

tS32 mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODRESULT;
}


mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult::~mascf_mainfi_tclMsgMCANBoseAmp_VersionInfoMethodResult()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeModeStatusUpReg::mascf_mainfi_tclMsgVolumeModeStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeModeStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSUPREG;
}


mascf_mainfi_tclMsgVolumeModeStatusUpReg::~mascf_mainfi_tclMsgVolumeModeStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeModeStatusRelUpReg::mascf_mainfi_tclMsgVolumeModeStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeModeStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSRELUPREG;
}


mascf_mainfi_tclMsgVolumeModeStatusRelUpReg::~mascf_mainfi_tclMsgVolumeModeStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeModeStatusGet::mascf_mainfi_tclMsgVolumeModeStatusGet()
 {}

tS32 mascf_mainfi_tclMsgVolumeModeStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSGET;
}


mascf_mainfi_tclMsgVolumeModeStatusGet::~mascf_mainfi_tclMsgVolumeModeStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeModeStatusStatus::mascf_mainfi_tclMsgVolumeModeStatusStatus(const mascf_mainfi_tclMsgVolumeModeStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgVolumeModeStatusStatus& mascf_mainfi_tclMsgVolumeModeStatusStatus::operator=(const mascf_mainfi_tclMsgVolumeModeStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeModeStatusStatus::mascf_mainfi_tclMsgVolumeModeStatusStatus()
:VolumeMode()
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgVolumeModeStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEMODESTATUSSTATUS;
}


mascf_mainfi_tclMsgVolumeModeStatusStatus::~mascf_mainfi_tclMsgVolumeModeStatusStatus()
{}

tU32 mascf_mainfi_tclMsgVolumeModeStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeModeStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeMode);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeModeStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeMode);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeModeStatusStatus::operator==(const mascf_mainfi_tclMsgVolumeModeStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeMode == roRef.VolumeMode);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgVolumeUpReg::mascf_mainfi_tclMsgVolumeUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEUPREG;
}


mascf_mainfi_tclMsgVolumeUpReg::~mascf_mainfi_tclMsgVolumeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeRelUpReg::mascf_mainfi_tclMsgVolumeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMERELUPREG;
}


mascf_mainfi_tclMsgVolumeRelUpReg::~mascf_mainfi_tclMsgVolumeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeGet::mascf_mainfi_tclMsgVolumeGet()
 {}

tS32 mascf_mainfi_tclMsgVolumeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMEGET;
}


mascf_mainfi_tclMsgVolumeGet::~mascf_mainfi_tclMsgVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeSet::mascf_mainfi_tclMsgVolumeSet(const mascf_mainfi_tclMsgVolumeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeType = coRef.VolumeType;
   Resource = coRef.Resource;
   Volume = coRef.Volume;
}
mascf_mainfi_tclMsgVolumeSet& mascf_mainfi_tclMsgVolumeSet::operator=(const mascf_mainfi_tclMsgVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeType = coRef.VolumeType;
   Resource = coRef.Resource;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeSet::mascf_mainfi_tclMsgVolumeSet()
:VolumeType()
,Resource()
,Volume(0)
 {}

tS32 mascf_mainfi_tclMsgVolumeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMESET;
}


mascf_mainfi_tclMsgVolumeSet::~mascf_mainfi_tclMsgVolumeSet()
{}

tU32 mascf_mainfi_tclMsgVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeSet::operator==(const mascf_mainfi_tclMsgVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeType == roRef.VolumeType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeStatus::mascf_mainfi_tclMsgVolumeStatus(const mascf_mainfi_tclMsgVolumeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Volume = coRef.Volume;
   Source = coRef.Source;
}
mascf_mainfi_tclMsgVolumeStatus& mascf_mainfi_tclMsgVolumeStatus::operator=(const mascf_mainfi_tclMsgVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Volume = coRef.Volume;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeStatus::mascf_mainfi_tclMsgVolumeStatus()
:VolumeMode()
,Resource()
,Channel()
,Volume(0)
,Source()
 {}

tS32 mascf_mainfi_tclMsgVolumeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMESTATUS;
}


mascf_mainfi_tclMsgVolumeStatus::~mascf_mainfi_tclMsgVolumeStatus()
{}

tU32 mascf_mainfi_tclMsgVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeMode);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   (tVoid) (oIn >> Volume);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeMode);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   (tVoid) (oOut << Volume);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeStatus::operator==(const mascf_mainfi_tclMsgVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeMode == roRef.VolumeMode);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   bResult = bResult && (Volume == roRef.Volume);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgBeepStatusUpReg::mascf_mainfi_tclMsgBeepStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgBeepStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPSTATUSUPREG;
}


mascf_mainfi_tclMsgBeepStatusUpReg::~mascf_mainfi_tclMsgBeepStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBeepStatusRelUpReg::mascf_mainfi_tclMsgBeepStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBeepStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPSTATUSRELUPREG;
}


mascf_mainfi_tclMsgBeepStatusRelUpReg::~mascf_mainfi_tclMsgBeepStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepStatusStatus::mascf_mainfi_tclMsgBeepStatusStatus(const mascf_mainfi_tclMsgBeepStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   BeepStatus = coRef.BeepStatus;
   u32Token = coRef.u32Token;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgBeepStatusStatus& mascf_mainfi_tclMsgBeepStatusStatus::operator=(const mascf_mainfi_tclMsgBeepStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   BeepStatus = coRef.BeepStatus;
   u32Token = coRef.u32Token;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBeepStatusStatus::mascf_mainfi_tclMsgBeepStatusStatus()
:BeepStatus()
,u32Token(0)
,Resource()
 {}

tS32 mascf_mainfi_tclMsgBeepStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPSTATUSSTATUS;
}


mascf_mainfi_tclMsgBeepStatusStatus::~mascf_mainfi_tclMsgBeepStatusStatus()
{}

tU32 mascf_mainfi_tclMsgBeepStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_mainfi_tclMsgBeepStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepStatus);
   (tVoid) (oIn >> u32Token);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepStatus);
   (tVoid) (oOut << u32Token);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepStatusStatus::operator==(const mascf_mainfi_tclMsgBeepStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepStatus == roRef.BeepStatus);
   bResult = bResult && (u32Token == roRef.u32Token);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgGalaUpReg::mascf_mainfi_tclMsgGalaUpReg()
 {}

tS32 mascf_mainfi_tclMsgGalaUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GALAUPREG;
}


mascf_mainfi_tclMsgGalaUpReg::~mascf_mainfi_tclMsgGalaUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgGalaRelUpReg::mascf_mainfi_tclMsgGalaRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgGalaRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GALARELUPREG;
}


mascf_mainfi_tclMsgGalaRelUpReg::~mascf_mainfi_tclMsgGalaRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgGalaGet::mascf_mainfi_tclMsgGalaGet()
 {}

tS32 mascf_mainfi_tclMsgGalaGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GALAGET;
}


mascf_mainfi_tclMsgGalaGet::~mascf_mainfi_tclMsgGalaGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgGalaSet::mascf_mainfi_tclMsgGalaSet(const mascf_mainfi_tclMsgGalaSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgGalaSet& mascf_mainfi_tclMsgGalaSet::operator=(const mascf_mainfi_tclMsgGalaSet& coRef)
{
   if (this == &coRef) return *this;
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgGalaSet::mascf_mainfi_tclMsgGalaSet()
:GalaLevel()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgGalaSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GALASET;
}


mascf_mainfi_tclMsgGalaSet::~mascf_mainfi_tclMsgGalaSet()
{}

tU32 mascf_mainfi_tclMsgGalaSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgGalaSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GalaLevel);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgGalaSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GalaLevel);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgGalaSet::operator==(const mascf_mainfi_tclMsgGalaSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GalaLevel == roRef.GalaLevel);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgGalaStatus::mascf_mainfi_tclMsgGalaStatus(const mascf_mainfi_tclMsgGalaStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgGalaStatus& mascf_mainfi_tclMsgGalaStatus::operator=(const mascf_mainfi_tclMsgGalaStatus& coRef)
{
   if (this == &coRef) return *this;
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgGalaStatus::mascf_mainfi_tclMsgGalaStatus()
:GalaLevel()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgGalaStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GALASTATUS;
}


mascf_mainfi_tclMsgGalaStatus::~mascf_mainfi_tclMsgGalaStatus()
{}

tU32 mascf_mainfi_tclMsgGalaStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgGalaStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GalaLevel);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgGalaStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GalaLevel);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgGalaStatus::operator==(const mascf_mainfi_tclMsgGalaStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GalaLevel == roRef.GalaLevel);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgBalanceUpReg::mascf_mainfi_tclMsgBalanceUpReg()
 {}

tS32 mascf_mainfi_tclMsgBalanceUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BALANCEUPREG;
}


mascf_mainfi_tclMsgBalanceUpReg::~mascf_mainfi_tclMsgBalanceUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBalanceRelUpReg::mascf_mainfi_tclMsgBalanceRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBalanceRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BALANCERELUPREG;
}


mascf_mainfi_tclMsgBalanceRelUpReg::~mascf_mainfi_tclMsgBalanceRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBalanceGet::mascf_mainfi_tclMsgBalanceGet()
 {}

tS32 mascf_mainfi_tclMsgBalanceGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BALANCEGET;
}


mascf_mainfi_tclMsgBalanceGet::~mascf_mainfi_tclMsgBalanceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBalanceSet::mascf_mainfi_tclMsgBalanceSet(const mascf_mainfi_tclMsgBalanceSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Balance = coRef.Balance;
}
mascf_mainfi_tclMsgBalanceSet& mascf_mainfi_tclMsgBalanceSet::operator=(const mascf_mainfi_tclMsgBalanceSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Balance = coRef.Balance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBalanceSet::mascf_mainfi_tclMsgBalanceSet()
:SoundType()
,Resource()
,Balance(0)
 {}

tS32 mascf_mainfi_tclMsgBalanceSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BALANCESET;
}


mascf_mainfi_tclMsgBalanceSet::~mascf_mainfi_tclMsgBalanceSet()
{}

tU32 mascf_mainfi_tclMsgBalanceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgBalanceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Balance);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBalanceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Balance);
   return oOut;
}

tBool mascf_mainfi_tclMsgBalanceSet::operator==(const mascf_mainfi_tclMsgBalanceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Balance == roRef.Balance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBalanceStatus::mascf_mainfi_tclMsgBalanceStatus(const mascf_mainfi_tclMsgBalanceStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Balance = coRef.Balance;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgBalanceStatus& mascf_mainfi_tclMsgBalanceStatus::operator=(const mascf_mainfi_tclMsgBalanceStatus& coRef)
{
   if (this == &coRef) return *this;
   Balance = coRef.Balance;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBalanceStatus::mascf_mainfi_tclMsgBalanceStatus()
:Balance(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgBalanceStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BALANCESTATUS;
}


mascf_mainfi_tclMsgBalanceStatus::~mascf_mainfi_tclMsgBalanceStatus()
{}

tU32 mascf_mainfi_tclMsgBalanceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgBalanceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Balance);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBalanceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Balance);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgBalanceStatus::operator==(const mascf_mainfi_tclMsgBalanceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Balance == roRef.Balance);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgLoudnessUpReg::mascf_mainfi_tclMsgLoudnessUpReg()
 {}

tS32 mascf_mainfi_tclMsgLoudnessUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LOUDNESSUPREG;
}


mascf_mainfi_tclMsgLoudnessUpReg::~mascf_mainfi_tclMsgLoudnessUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgLoudnessRelUpReg::mascf_mainfi_tclMsgLoudnessRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgLoudnessRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LOUDNESSRELUPREG;
}


mascf_mainfi_tclMsgLoudnessRelUpReg::~mascf_mainfi_tclMsgLoudnessRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgLoudnessGet::mascf_mainfi_tclMsgLoudnessGet()
 {}

tS32 mascf_mainfi_tclMsgLoudnessGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LOUDNESSGET;
}


mascf_mainfi_tclMsgLoudnessGet::~mascf_mainfi_tclMsgLoudnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgLoudnessSet::mascf_mainfi_tclMsgLoudnessSet(const mascf_mainfi_tclMsgLoudnessSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Loudness = coRef.Loudness;
}
mascf_mainfi_tclMsgLoudnessSet& mascf_mainfi_tclMsgLoudnessSet::operator=(const mascf_mainfi_tclMsgLoudnessSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Loudness = coRef.Loudness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgLoudnessSet::mascf_mainfi_tclMsgLoudnessSet()
:SoundType()
,Resource()
,Loudness(0)
 {}

tS32 mascf_mainfi_tclMsgLoudnessSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LOUDNESSSET;
}


mascf_mainfi_tclMsgLoudnessSet::~mascf_mainfi_tclMsgLoudnessSet()
{}

tU32 mascf_mainfi_tclMsgLoudnessSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgLoudnessSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Loudness);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgLoudnessSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Loudness);
   return oOut;
}

tBool mascf_mainfi_tclMsgLoudnessSet::operator==(const mascf_mainfi_tclMsgLoudnessSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Loudness == roRef.Loudness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgLoudnessStatus::mascf_mainfi_tclMsgLoudnessStatus(const mascf_mainfi_tclMsgLoudnessStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Loudness = coRef.Loudness;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgLoudnessStatus& mascf_mainfi_tclMsgLoudnessStatus::operator=(const mascf_mainfi_tclMsgLoudnessStatus& coRef)
{
   if (this == &coRef) return *this;
   Loudness = coRef.Loudness;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgLoudnessStatus::mascf_mainfi_tclMsgLoudnessStatus()
:Loudness(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgLoudnessStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LOUDNESSSTATUS;
}


mascf_mainfi_tclMsgLoudnessStatus::~mascf_mainfi_tclMsgLoudnessStatus()
{}

tU32 mascf_mainfi_tclMsgLoudnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgLoudnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Loudness);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgLoudnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Loudness);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgLoudnessStatus::operator==(const mascf_mainfi_tclMsgLoudnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Loudness == roRef.Loudness);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgBassUpReg::mascf_mainfi_tclMsgBassUpReg()
 {}

tS32 mascf_mainfi_tclMsgBassUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BASSUPREG;
}


mascf_mainfi_tclMsgBassUpReg::~mascf_mainfi_tclMsgBassUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBassRelUpReg::mascf_mainfi_tclMsgBassRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBassRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BASSRELUPREG;
}


mascf_mainfi_tclMsgBassRelUpReg::~mascf_mainfi_tclMsgBassRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBassGet::mascf_mainfi_tclMsgBassGet()
 {}

tS32 mascf_mainfi_tclMsgBassGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BASSGET;
}


mascf_mainfi_tclMsgBassGet::~mascf_mainfi_tclMsgBassGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBassSet::mascf_mainfi_tclMsgBassSet(const mascf_mainfi_tclMsgBassSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Bass = coRef.Bass;
}
mascf_mainfi_tclMsgBassSet& mascf_mainfi_tclMsgBassSet::operator=(const mascf_mainfi_tclMsgBassSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Bass = coRef.Bass;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBassSet::mascf_mainfi_tclMsgBassSet()
:SoundType()
,Resource()
,Bass(0)
 {}

tS32 mascf_mainfi_tclMsgBassSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BASSSET;
}


mascf_mainfi_tclMsgBassSet::~mascf_mainfi_tclMsgBassSet()
{}

tU32 mascf_mainfi_tclMsgBassSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgBassSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Bass);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBassSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Bass);
   return oOut;
}

tBool mascf_mainfi_tclMsgBassSet::operator==(const mascf_mainfi_tclMsgBassSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Bass == roRef.Bass);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBassStatus::mascf_mainfi_tclMsgBassStatus(const mascf_mainfi_tclMsgBassStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Bass = coRef.Bass;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgBassStatus& mascf_mainfi_tclMsgBassStatus::operator=(const mascf_mainfi_tclMsgBassStatus& coRef)
{
   if (this == &coRef) return *this;
   Bass = coRef.Bass;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBassStatus::mascf_mainfi_tclMsgBassStatus()
:Bass(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgBassStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BASSSTATUS;
}


mascf_mainfi_tclMsgBassStatus::~mascf_mainfi_tclMsgBassStatus()
{}

tU32 mascf_mainfi_tclMsgBassStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgBassStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Bass);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBassStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Bass);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgBassStatus::operator==(const mascf_mainfi_tclMsgBassStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Bass == roRef.Bass);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgTrebleUpReg::mascf_mainfi_tclMsgTrebleUpReg()
 {}

tS32 mascf_mainfi_tclMsgTrebleUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_TREBLEUPREG;
}


mascf_mainfi_tclMsgTrebleUpReg::~mascf_mainfi_tclMsgTrebleUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgTrebleRelUpReg::mascf_mainfi_tclMsgTrebleRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgTrebleRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_TREBLERELUPREG;
}


mascf_mainfi_tclMsgTrebleRelUpReg::~mascf_mainfi_tclMsgTrebleRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgTrebleGet::mascf_mainfi_tclMsgTrebleGet()
 {}

tS32 mascf_mainfi_tclMsgTrebleGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_TREBLEGET;
}


mascf_mainfi_tclMsgTrebleGet::~mascf_mainfi_tclMsgTrebleGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgTrebleSet::mascf_mainfi_tclMsgTrebleSet(const mascf_mainfi_tclMsgTrebleSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Treble = coRef.Treble;
}
mascf_mainfi_tclMsgTrebleSet& mascf_mainfi_tclMsgTrebleSet::operator=(const mascf_mainfi_tclMsgTrebleSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Treble = coRef.Treble;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgTrebleSet::mascf_mainfi_tclMsgTrebleSet()
:SoundType()
,Resource()
,Treble(0)
 {}

tS32 mascf_mainfi_tclMsgTrebleSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_TREBLESET;
}


mascf_mainfi_tclMsgTrebleSet::~mascf_mainfi_tclMsgTrebleSet()
{}

tU32 mascf_mainfi_tclMsgTrebleSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgTrebleSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Treble);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgTrebleSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Treble);
   return oOut;
}

tBool mascf_mainfi_tclMsgTrebleSet::operator==(const mascf_mainfi_tclMsgTrebleSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Treble == roRef.Treble);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgTrebleStatus::mascf_mainfi_tclMsgTrebleStatus(const mascf_mainfi_tclMsgTrebleStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Treble = coRef.Treble;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgTrebleStatus& mascf_mainfi_tclMsgTrebleStatus::operator=(const mascf_mainfi_tclMsgTrebleStatus& coRef)
{
   if (this == &coRef) return *this;
   Treble = coRef.Treble;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgTrebleStatus::mascf_mainfi_tclMsgTrebleStatus()
:Treble(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgTrebleStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_TREBLESTATUS;
}


mascf_mainfi_tclMsgTrebleStatus::~mascf_mainfi_tclMsgTrebleStatus()
{}

tU32 mascf_mainfi_tclMsgTrebleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgTrebleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Treble);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgTrebleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Treble);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgTrebleStatus::operator==(const mascf_mainfi_tclMsgTrebleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Treble == roRef.Treble);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgFaderUpReg::mascf_mainfi_tclMsgFaderUpReg()
 {}

tS32 mascf_mainfi_tclMsgFaderUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERUPREG;
}


mascf_mainfi_tclMsgFaderUpReg::~mascf_mainfi_tclMsgFaderUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgFaderRelUpReg::mascf_mainfi_tclMsgFaderRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgFaderRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERRELUPREG;
}


mascf_mainfi_tclMsgFaderRelUpReg::~mascf_mainfi_tclMsgFaderRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgFaderGet::mascf_mainfi_tclMsgFaderGet()
 {}

tS32 mascf_mainfi_tclMsgFaderGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERGET;
}


mascf_mainfi_tclMsgFaderGet::~mascf_mainfi_tclMsgFaderGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgFaderSet::mascf_mainfi_tclMsgFaderSet(const mascf_mainfi_tclMsgFaderSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Fader = coRef.Fader;
}
mascf_mainfi_tclMsgFaderSet& mascf_mainfi_tclMsgFaderSet::operator=(const mascf_mainfi_tclMsgFaderSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Fader = coRef.Fader;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgFaderSet::mascf_mainfi_tclMsgFaderSet()
:SoundType()
,Resource()
,Fader(0)
 {}

tS32 mascf_mainfi_tclMsgFaderSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERSET;
}


mascf_mainfi_tclMsgFaderSet::~mascf_mainfi_tclMsgFaderSet()
{}

tU32 mascf_mainfi_tclMsgFaderSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgFaderSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Fader);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgFaderSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Fader);
   return oOut;
}

tBool mascf_mainfi_tclMsgFaderSet::operator==(const mascf_mainfi_tclMsgFaderSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Fader == roRef.Fader);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgFaderStatus::mascf_mainfi_tclMsgFaderStatus(const mascf_mainfi_tclMsgFaderStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Fader = coRef.Fader;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgFaderStatus& mascf_mainfi_tclMsgFaderStatus::operator=(const mascf_mainfi_tclMsgFaderStatus& coRef)
{
   if (this == &coRef) return *this;
   Fader = coRef.Fader;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgFaderStatus::mascf_mainfi_tclMsgFaderStatus()
:Fader(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgFaderStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERSTATUS;
}


mascf_mainfi_tclMsgFaderStatus::~mascf_mainfi_tclMsgFaderStatus()
{}

tU32 mascf_mainfi_tclMsgFaderStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgFaderStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Fader);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgFaderStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Fader);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgFaderStatus::operator==(const mascf_mainfi_tclMsgFaderStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Fader == roRef.Fader);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgMidRangeUpReg::mascf_mainfi_tclMsgMidRangeUpReg()
 {}

tS32 mascf_mainfi_tclMsgMidRangeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MIDRANGEUPREG;
}


mascf_mainfi_tclMsgMidRangeUpReg::~mascf_mainfi_tclMsgMidRangeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgMidRangeRelUpReg::mascf_mainfi_tclMsgMidRangeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgMidRangeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MIDRANGERELUPREG;
}


mascf_mainfi_tclMsgMidRangeRelUpReg::~mascf_mainfi_tclMsgMidRangeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgMidRangeGet::mascf_mainfi_tclMsgMidRangeGet()
 {}

tS32 mascf_mainfi_tclMsgMidRangeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MIDRANGEGET;
}


mascf_mainfi_tclMsgMidRangeGet::~mascf_mainfi_tclMsgMidRangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMidRangeSet::mascf_mainfi_tclMsgMidRangeSet(const mascf_mainfi_tclMsgMidRangeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   MidRange = coRef.MidRange;
}
mascf_mainfi_tclMsgMidRangeSet& mascf_mainfi_tclMsgMidRangeSet::operator=(const mascf_mainfi_tclMsgMidRangeSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   MidRange = coRef.MidRange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMidRangeSet::mascf_mainfi_tclMsgMidRangeSet()
:SoundType()
,Resource()
,MidRange(0)
 {}

tS32 mascf_mainfi_tclMsgMidRangeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MIDRANGESET;
}


mascf_mainfi_tclMsgMidRangeSet::~mascf_mainfi_tclMsgMidRangeSet()
{}

tU32 mascf_mainfi_tclMsgMidRangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgMidRangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> MidRange);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMidRangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << MidRange);
   return oOut;
}

tBool mascf_mainfi_tclMsgMidRangeSet::operator==(const mascf_mainfi_tclMsgMidRangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (MidRange == roRef.MidRange);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMidRangeStatus::mascf_mainfi_tclMsgMidRangeStatus(const mascf_mainfi_tclMsgMidRangeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   MidRange = coRef.MidRange;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgMidRangeStatus& mascf_mainfi_tclMsgMidRangeStatus::operator=(const mascf_mainfi_tclMsgMidRangeStatus& coRef)
{
   if (this == &coRef) return *this;
   MidRange = coRef.MidRange;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMidRangeStatus::mascf_mainfi_tclMsgMidRangeStatus()
:MidRange(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgMidRangeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MIDRANGESTATUS;
}


mascf_mainfi_tclMsgMidRangeStatus::~mascf_mainfi_tclMsgMidRangeStatus()
{}

tU32 mascf_mainfi_tclMsgMidRangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgMidRangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MidRange);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMidRangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MidRange);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgMidRangeStatus::operator==(const mascf_mainfi_tclMsgMidRangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MidRange == roRef.MidRange);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgMemSoundUpReg::mascf_mainfi_tclMsgMemSoundUpReg()
 {}

tS32 mascf_mainfi_tclMsgMemSoundUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MEMSOUNDUPREG;
}


mascf_mainfi_tclMsgMemSoundUpReg::~mascf_mainfi_tclMsgMemSoundUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgMemSoundRelUpReg::mascf_mainfi_tclMsgMemSoundRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgMemSoundRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MEMSOUNDRELUPREG;
}


mascf_mainfi_tclMsgMemSoundRelUpReg::~mascf_mainfi_tclMsgMemSoundRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMemSoundSet::mascf_mainfi_tclMsgMemSoundSet(const mascf_mainfi_tclMsgMemSoundSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Sound = coRef.Sound;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgMemSoundSet& mascf_mainfi_tclMsgMemSoundSet::operator=(const mascf_mainfi_tclMsgMemSoundSet& coRef)
{
   if (this == &coRef) return *this;
   Sound = coRef.Sound;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMemSoundSet::mascf_mainfi_tclMsgMemSoundSet()
:Sound()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgMemSoundSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MEMSOUNDSET;
}


mascf_mainfi_tclMsgMemSoundSet::~mascf_mainfi_tclMsgMemSoundSet()
{}

tU32 mascf_mainfi_tclMsgMemSoundSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgMemSoundSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sound);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMemSoundSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sound);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgMemSoundSet::operator==(const mascf_mainfi_tclMsgMemSoundSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sound == roRef.Sound);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMemSoundStatus::mascf_mainfi_tclMsgMemSoundStatus(const mascf_mainfi_tclMsgMemSoundStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Sound = coRef.Sound;
   Resource = coRef.Resource;
   MemStatus = coRef.MemStatus;
}
mascf_mainfi_tclMsgMemSoundStatus& mascf_mainfi_tclMsgMemSoundStatus::operator=(const mascf_mainfi_tclMsgMemSoundStatus& coRef)
{
   if (this == &coRef) return *this;
   Sound = coRef.Sound;
   Resource = coRef.Resource;
   MemStatus = coRef.MemStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMemSoundStatus::mascf_mainfi_tclMsgMemSoundStatus()
:Sound()
,Resource()
,MemStatus()
 {}

tS32 mascf_mainfi_tclMsgMemSoundStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MEMSOUNDSTATUS;
}


mascf_mainfi_tclMsgMemSoundStatus::~mascf_mainfi_tclMsgMemSoundStatus()
{}

tU32 mascf_mainfi_tclMsgMemSoundStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgMemSoundStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sound);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> MemStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMemSoundStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sound);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << MemStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgMemSoundStatus::operator==(const mascf_mainfi_tclMsgMemSoundStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sound == roRef.Sound);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (MemStatus == roRef.MemStatus);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgFaderActivationStatusUpReg::mascf_mainfi_tclMsgFaderActivationStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgFaderActivationStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSUPREG;
}


mascf_mainfi_tclMsgFaderActivationStatusUpReg::~mascf_mainfi_tclMsgFaderActivationStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgFaderActivationStatusRelUpReg::mascf_mainfi_tclMsgFaderActivationStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgFaderActivationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSRELUPREG;
}


mascf_mainfi_tclMsgFaderActivationStatusRelUpReg::~mascf_mainfi_tclMsgFaderActivationStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgFaderActivationStatusGet::mascf_mainfi_tclMsgFaderActivationStatusGet()
 {}

tS32 mascf_mainfi_tclMsgFaderActivationStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSGET;
}


mascf_mainfi_tclMsgFaderActivationStatusGet::~mascf_mainfi_tclMsgFaderActivationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgFaderActivationStatusStatus::mascf_mainfi_tclMsgFaderActivationStatusStatus(const mascf_mainfi_tclMsgFaderActivationStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   FaderStatus = coRef.FaderStatus;
}
mascf_mainfi_tclMsgFaderActivationStatusStatus& mascf_mainfi_tclMsgFaderActivationStatusStatus::operator=(const mascf_mainfi_tclMsgFaderActivationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   FaderStatus = coRef.FaderStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgFaderActivationStatusStatus::mascf_mainfi_tclMsgFaderActivationStatusStatus()
:FaderStatus()
 {}

tS32 mascf_mainfi_tclMsgFaderActivationStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FADERACTIVATIONSTATUSSTATUS;
}


mascf_mainfi_tclMsgFaderActivationStatusStatus::~mascf_mainfi_tclMsgFaderActivationStatusStatus()
{}

tU32 mascf_mainfi_tclMsgFaderActivationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgFaderActivationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FaderStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgFaderActivationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FaderStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgFaderActivationStatusStatus::operator==(const mascf_mainfi_tclMsgFaderActivationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FaderStatus == roRef.FaderStatus);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgDynamicCompressionUpReg::mascf_mainfi_tclMsgDynamicCompressionUpReg()
 {}

tS32 mascf_mainfi_tclMsgDynamicCompressionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONUPREG;
}


mascf_mainfi_tclMsgDynamicCompressionUpReg::~mascf_mainfi_tclMsgDynamicCompressionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDynamicCompressionRelUpReg::mascf_mainfi_tclMsgDynamicCompressionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgDynamicCompressionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONRELUPREG;
}


mascf_mainfi_tclMsgDynamicCompressionRelUpReg::~mascf_mainfi_tclMsgDynamicCompressionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDynamicCompressionGet::mascf_mainfi_tclMsgDynamicCompressionGet()
 {}

tS32 mascf_mainfi_tclMsgDynamicCompressionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONGET;
}


mascf_mainfi_tclMsgDynamicCompressionGet::~mascf_mainfi_tclMsgDynamicCompressionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDynamicCompressionSet::mascf_mainfi_tclMsgDynamicCompressionSet(const mascf_mainfi_tclMsgDynamicCompressionSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DynComp = coRef.DynComp;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgDynamicCompressionSet& mascf_mainfi_tclMsgDynamicCompressionSet::operator=(const mascf_mainfi_tclMsgDynamicCompressionSet& coRef)
{
   if (this == &coRef) return *this;
   DynComp = coRef.DynComp;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDynamicCompressionSet::mascf_mainfi_tclMsgDynamicCompressionSet()
:DynComp()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgDynamicCompressionSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSET;
}


mascf_mainfi_tclMsgDynamicCompressionSet::~mascf_mainfi_tclMsgDynamicCompressionSet()
{}

tU32 mascf_mainfi_tclMsgDynamicCompressionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgDynamicCompressionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynComp);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDynamicCompressionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynComp);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgDynamicCompressionSet::operator==(const mascf_mainfi_tclMsgDynamicCompressionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynComp == roRef.DynComp);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDynamicCompressionStatus::mascf_mainfi_tclMsgDynamicCompressionStatus(const mascf_mainfi_tclMsgDynamicCompressionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DynCompression = coRef.DynCompression;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgDynamicCompressionStatus& mascf_mainfi_tclMsgDynamicCompressionStatus::operator=(const mascf_mainfi_tclMsgDynamicCompressionStatus& coRef)
{
   if (this == &coRef) return *this;
   DynCompression = coRef.DynCompression;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDynamicCompressionStatus::mascf_mainfi_tclMsgDynamicCompressionStatus()
:DynCompression()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgDynamicCompressionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSTATUS;
}


mascf_mainfi_tclMsgDynamicCompressionStatus::~mascf_mainfi_tclMsgDynamicCompressionStatus()
{}

tU32 mascf_mainfi_tclMsgDynamicCompressionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgDynamicCompressionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynCompression);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDynamicCompressionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynCompression);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgDynamicCompressionStatus::operator==(const mascf_mainfi_tclMsgDynamicCompressionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynCompression == roRef.DynCompression);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgOptimizationUpReg::mascf_mainfi_tclMsgOptimizationUpReg()
 {}

tS32 mascf_mainfi_tclMsgOptimizationUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONUPREG;
}


mascf_mainfi_tclMsgOptimizationUpReg::~mascf_mainfi_tclMsgOptimizationUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgOptimizationRelUpReg::mascf_mainfi_tclMsgOptimizationRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgOptimizationRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONRELUPREG;
}


mascf_mainfi_tclMsgOptimizationRelUpReg::~mascf_mainfi_tclMsgOptimizationRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgOptimizationGet::mascf_mainfi_tclMsgOptimizationGet()
 {}

tS32 mascf_mainfi_tclMsgOptimizationGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONGET;
}


mascf_mainfi_tclMsgOptimizationGet::~mascf_mainfi_tclMsgOptimizationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgOptimizationSet::mascf_mainfi_tclMsgOptimizationSet(const mascf_mainfi_tclMsgOptimizationSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgOptimizationSet& mascf_mainfi_tclMsgOptimizationSet::operator=(const mascf_mainfi_tclMsgOptimizationSet& coRef)
{
   if (this == &coRef) return *this;
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgOptimizationSet::mascf_mainfi_tclMsgOptimizationSet()
:Optimization()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgOptimizationSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONSET;
}


mascf_mainfi_tclMsgOptimizationSet::~mascf_mainfi_tclMsgOptimizationSet()
{}

tU32 mascf_mainfi_tclMsgOptimizationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgOptimizationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Optimization);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgOptimizationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Optimization);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgOptimizationSet::operator==(const mascf_mainfi_tclMsgOptimizationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Optimization == roRef.Optimization);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgOptimizationStatus::mascf_mainfi_tclMsgOptimizationStatus(const mascf_mainfi_tclMsgOptimizationStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgOptimizationStatus& mascf_mainfi_tclMsgOptimizationStatus::operator=(const mascf_mainfi_tclMsgOptimizationStatus& coRef)
{
   if (this == &coRef) return *this;
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgOptimizationStatus::mascf_mainfi_tclMsgOptimizationStatus()
:Optimization()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgOptimizationStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OPTIMIZATIONSTATUS;
}


mascf_mainfi_tclMsgOptimizationStatus::~mascf_mainfi_tclMsgOptimizationStatus()
{}

tU32 mascf_mainfi_tclMsgOptimizationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgOptimizationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Optimization);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgOptimizationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Optimization);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgOptimizationStatus::operator==(const mascf_mainfi_tclMsgOptimizationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Optimization == roRef.Optimization);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgEqualiserPresetUpReg::mascf_mainfi_tclMsgEqualiserPresetUpReg()
 {}

tS32 mascf_mainfi_tclMsgEqualiserPresetUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETUPREG;
}


mascf_mainfi_tclMsgEqualiserPresetUpReg::~mascf_mainfi_tclMsgEqualiserPresetUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgEqualiserPresetRelUpReg::mascf_mainfi_tclMsgEqualiserPresetRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgEqualiserPresetRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETRELUPREG;
}


mascf_mainfi_tclMsgEqualiserPresetRelUpReg::~mascf_mainfi_tclMsgEqualiserPresetRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgEqualiserPresetGet::mascf_mainfi_tclMsgEqualiserPresetGet()
 {}

tS32 mascf_mainfi_tclMsgEqualiserPresetGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETGET;
}


mascf_mainfi_tclMsgEqualiserPresetGet::~mascf_mainfi_tclMsgEqualiserPresetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEqualiserPresetSet::mascf_mainfi_tclMsgEqualiserPresetSet(const mascf_mainfi_tclMsgEqualiserPresetSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgEqualiserPresetSet& mascf_mainfi_tclMsgEqualiserPresetSet::operator=(const mascf_mainfi_tclMsgEqualiserPresetSet& coRef)
{
   if (this == &coRef) return *this;
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgEqualiserPresetSet::mascf_mainfi_tclMsgEqualiserPresetSet()
:EquPreset()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgEqualiserPresetSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETSET;
}


mascf_mainfi_tclMsgEqualiserPresetSet::~mascf_mainfi_tclMsgEqualiserPresetSet()
{}

tU32 mascf_mainfi_tclMsgEqualiserPresetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgEqualiserPresetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EquPreset);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEqualiserPresetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EquPreset);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgEqualiserPresetSet::operator==(const mascf_mainfi_tclMsgEqualiserPresetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EquPreset == roRef.EquPreset);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEqualiserPresetStatus::mascf_mainfi_tclMsgEqualiserPresetStatus(const mascf_mainfi_tclMsgEqualiserPresetStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgEqualiserPresetStatus& mascf_mainfi_tclMsgEqualiserPresetStatus::operator=(const mascf_mainfi_tclMsgEqualiserPresetStatus& coRef)
{
   if (this == &coRef) return *this;
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgEqualiserPresetStatus::mascf_mainfi_tclMsgEqualiserPresetStatus()
:EquPreset()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgEqualiserPresetStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EQUALISERPRESETSTATUS;
}


mascf_mainfi_tclMsgEqualiserPresetStatus::~mascf_mainfi_tclMsgEqualiserPresetStatus()
{}

tU32 mascf_mainfi_tclMsgEqualiserPresetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgEqualiserPresetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EquPreset);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEqualiserPresetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EquPreset);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgEqualiserPresetStatus::operator==(const mascf_mainfi_tclMsgEqualiserPresetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EquPreset == roRef.EquPreset);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgDiagAudModeUpReg::mascf_mainfi_tclMsgDiagAudModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgDiagAudModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODEUPREG;
}


mascf_mainfi_tclMsgDiagAudModeUpReg::~mascf_mainfi_tclMsgDiagAudModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDiagAudModeRelUpReg::mascf_mainfi_tclMsgDiagAudModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgDiagAudModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODERELUPREG;
}


mascf_mainfi_tclMsgDiagAudModeRelUpReg::~mascf_mainfi_tclMsgDiagAudModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDiagAudModeGet::mascf_mainfi_tclMsgDiagAudModeGet()
 {}

tS32 mascf_mainfi_tclMsgDiagAudModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODEGET;
}


mascf_mainfi_tclMsgDiagAudModeGet::~mascf_mainfi_tclMsgDiagAudModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDiagAudModeSet::mascf_mainfi_tclMsgDiagAudModeSet(const mascf_mainfi_tclMsgDiagAudModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
}
mascf_mainfi_tclMsgDiagAudModeSet& mascf_mainfi_tclMsgDiagAudModeSet::operator=(const mascf_mainfi_tclMsgDiagAudModeSet& coRef)
{
   if (this == &coRef) return *this;
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDiagAudModeSet::mascf_mainfi_tclMsgDiagAudModeSet()
:DiagAudMode()
,OnVolLimiterMode()
,MuteRampMode()
,VolumeRampMode()
,clippingMode()
,PresetMode()
 {}

tS32 mascf_mainfi_tclMsgDiagAudModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODESET;
}


mascf_mainfi_tclMsgDiagAudModeSet::~mascf_mainfi_tclMsgDiagAudModeSet()
{}

tU32 mascf_mainfi_tclMsgDiagAudModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_mainfi_tclMsgDiagAudModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagAudMode);
   (tVoid) (oIn >> OnVolLimiterMode);
   (tVoid) (oIn >> MuteRampMode);
   (tVoid) (oIn >> VolumeRampMode);
   (tVoid) (oIn >> clippingMode);
   (tVoid) (oIn >> PresetMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDiagAudModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagAudMode);
   (tVoid) (oOut << OnVolLimiterMode);
   (tVoid) (oOut << MuteRampMode);
   (tVoid) (oOut << VolumeRampMode);
   (tVoid) (oOut << clippingMode);
   (tVoid) (oOut << PresetMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgDiagAudModeSet::operator==(const mascf_mainfi_tclMsgDiagAudModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagAudMode == roRef.DiagAudMode);
   bResult = bResult && (OnVolLimiterMode == roRef.OnVolLimiterMode);
   bResult = bResult && (MuteRampMode == roRef.MuteRampMode);
   bResult = bResult && (VolumeRampMode == roRef.VolumeRampMode);
   bResult = bResult && (clippingMode == roRef.clippingMode);
   bResult = bResult && (PresetMode == roRef.PresetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDiagAudModeStatus::mascf_mainfi_tclMsgDiagAudModeStatus(const mascf_mainfi_tclMsgDiagAudModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
}
mascf_mainfi_tclMsgDiagAudModeStatus& mascf_mainfi_tclMsgDiagAudModeStatus::operator=(const mascf_mainfi_tclMsgDiagAudModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDiagAudModeStatus::mascf_mainfi_tclMsgDiagAudModeStatus()
:DiagAudMode()
,OnVolLimiterMode()
,MuteRampMode()
,VolumeRampMode()
,clippingMode()
,PresetMode()
 {}

tS32 mascf_mainfi_tclMsgDiagAudModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGAUDMODESTATUS;
}


mascf_mainfi_tclMsgDiagAudModeStatus::~mascf_mainfi_tclMsgDiagAudModeStatus()
{}

tU32 mascf_mainfi_tclMsgDiagAudModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_mainfi_tclMsgDiagAudModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagAudMode);
   (tVoid) (oIn >> OnVolLimiterMode);
   (tVoid) (oIn >> MuteRampMode);
   (tVoid) (oIn >> VolumeRampMode);
   (tVoid) (oIn >> clippingMode);
   (tVoid) (oIn >> PresetMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDiagAudModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagAudMode);
   (tVoid) (oOut << OnVolLimiterMode);
   (tVoid) (oOut << MuteRampMode);
   (tVoid) (oOut << VolumeRampMode);
   (tVoid) (oOut << clippingMode);
   (tVoid) (oOut << PresetMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgDiagAudModeStatus::operator==(const mascf_mainfi_tclMsgDiagAudModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagAudMode == roRef.DiagAudMode);
   bResult = bResult && (OnVolLimiterMode == roRef.OnVolLimiterMode);
   bResult = bResult && (MuteRampMode == roRef.MuteRampMode);
   bResult = bResult && (VolumeRampMode == roRef.VolumeRampMode);
   bResult = bResult && (clippingMode == roRef.clippingMode);
   bResult = bResult && (PresetMode == roRef.PresetMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAuxInLevelUpReg::mascf_mainfi_tclMsgAuxInLevelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAuxInLevelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUXINLEVELUPREG;
}


mascf_mainfi_tclMsgAuxInLevelUpReg::~mascf_mainfi_tclMsgAuxInLevelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAuxInLevelRelUpReg::mascf_mainfi_tclMsgAuxInLevelRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAuxInLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUXINLEVELRELUPREG;
}


mascf_mainfi_tclMsgAuxInLevelRelUpReg::~mascf_mainfi_tclMsgAuxInLevelRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAuxInLevelGet::mascf_mainfi_tclMsgAuxInLevelGet()
 {}

tS32 mascf_mainfi_tclMsgAuxInLevelGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUXINLEVELGET;
}


mascf_mainfi_tclMsgAuxInLevelGet::~mascf_mainfi_tclMsgAuxInLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAuxInLevelSet::mascf_mainfi_tclMsgAuxInLevelSet(const mascf_mainfi_tclMsgAuxInLevelSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AuxInLevel = coRef.AuxInLevel;
}
mascf_mainfi_tclMsgAuxInLevelSet& mascf_mainfi_tclMsgAuxInLevelSet::operator=(const mascf_mainfi_tclMsgAuxInLevelSet& coRef)
{
   if (this == &coRef) return *this;
   AuxInLevel = coRef.AuxInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAuxInLevelSet::mascf_mainfi_tclMsgAuxInLevelSet()
:AuxInLevel()
 {}

tS32 mascf_mainfi_tclMsgAuxInLevelSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUXINLEVELSET;
}


mascf_mainfi_tclMsgAuxInLevelSet::~mascf_mainfi_tclMsgAuxInLevelSet()
{}

tU32 mascf_mainfi_tclMsgAuxInLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAuxInLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AuxInLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAuxInLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AuxInLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgAuxInLevelSet::operator==(const mascf_mainfi_tclMsgAuxInLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AuxInLevel == roRef.AuxInLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAuxInLevelStatus::mascf_mainfi_tclMsgAuxInLevelStatus(const mascf_mainfi_tclMsgAuxInLevelStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AuxInLevel = coRef.AuxInLevel;
}
mascf_mainfi_tclMsgAuxInLevelStatus& mascf_mainfi_tclMsgAuxInLevelStatus::operator=(const mascf_mainfi_tclMsgAuxInLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   AuxInLevel = coRef.AuxInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAuxInLevelStatus::mascf_mainfi_tclMsgAuxInLevelStatus()
:AuxInLevel()
 {}

tS32 mascf_mainfi_tclMsgAuxInLevelStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUXINLEVELSTATUS;
}


mascf_mainfi_tclMsgAuxInLevelStatus::~mascf_mainfi_tclMsgAuxInLevelStatus()
{}

tU32 mascf_mainfi_tclMsgAuxInLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAuxInLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AuxInLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAuxInLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AuxInLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgAuxInLevelStatus::operator==(const mascf_mainfi_tclMsgAuxInLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AuxInLevel == roRef.AuxInLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgBeepLevelUpReg::mascf_mainfi_tclMsgBeepLevelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBeepLevelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPLEVELUPREG;
}


mascf_mainfi_tclMsgBeepLevelUpReg::~mascf_mainfi_tclMsgBeepLevelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBeepLevelRelUpReg::mascf_mainfi_tclMsgBeepLevelRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBeepLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPLEVELRELUPREG;
}


mascf_mainfi_tclMsgBeepLevelRelUpReg::~mascf_mainfi_tclMsgBeepLevelRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBeepLevelGet::mascf_mainfi_tclMsgBeepLevelGet()
 {}

tS32 mascf_mainfi_tclMsgBeepLevelGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPLEVELGET;
}


mascf_mainfi_tclMsgBeepLevelGet::~mascf_mainfi_tclMsgBeepLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepLevelSet::mascf_mainfi_tclMsgBeepLevelSet(const mascf_mainfi_tclMsgBeepLevelSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   BeepLevel = coRef.BeepLevel;
}
mascf_mainfi_tclMsgBeepLevelSet& mascf_mainfi_tclMsgBeepLevelSet::operator=(const mascf_mainfi_tclMsgBeepLevelSet& coRef)
{
   if (this == &coRef) return *this;
   BeepLevel = coRef.BeepLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBeepLevelSet::mascf_mainfi_tclMsgBeepLevelSet()
:BeepLevel()
 {}

tS32 mascf_mainfi_tclMsgBeepLevelSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPLEVELSET;
}


mascf_mainfi_tclMsgBeepLevelSet::~mascf_mainfi_tclMsgBeepLevelSet()
{}

tU32 mascf_mainfi_tclMsgBeepLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgBeepLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepLevelSet::operator==(const mascf_mainfi_tclMsgBeepLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepLevel == roRef.BeepLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBeepLevelStatus::mascf_mainfi_tclMsgBeepLevelStatus(const mascf_mainfi_tclMsgBeepLevelStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   BeepLevel = coRef.BeepLevel;
}
mascf_mainfi_tclMsgBeepLevelStatus& mascf_mainfi_tclMsgBeepLevelStatus::operator=(const mascf_mainfi_tclMsgBeepLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BeepLevel = coRef.BeepLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBeepLevelStatus::mascf_mainfi_tclMsgBeepLevelStatus()
:BeepLevel()
 {}

tS32 mascf_mainfi_tclMsgBeepLevelStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BEEPLEVELSTATUS;
}


mascf_mainfi_tclMsgBeepLevelStatus::~mascf_mainfi_tclMsgBeepLevelStatus()
{}

tU32 mascf_mainfi_tclMsgBeepLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgBeepLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBeepLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgBeepLevelStatus::operator==(const mascf_mainfi_tclMsgBeepLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepLevel == roRef.BeepLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRear_MuteUpReg::mascf_mainfi_tclMsgRear_MuteUpReg()
 {}

tS32 mascf_mainfi_tclMsgRear_MuteUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REAR_MUTEUPREG;
}


mascf_mainfi_tclMsgRear_MuteUpReg::~mascf_mainfi_tclMsgRear_MuteUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRear_MuteRelUpReg::mascf_mainfi_tclMsgRear_MuteRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRear_MuteRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REAR_MUTERELUPREG;
}


mascf_mainfi_tclMsgRear_MuteRelUpReg::~mascf_mainfi_tclMsgRear_MuteRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRear_MuteGet::mascf_mainfi_tclMsgRear_MuteGet()
 {}

tS32 mascf_mainfi_tclMsgRear_MuteGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REAR_MUTEGET;
}


mascf_mainfi_tclMsgRear_MuteGet::~mascf_mainfi_tclMsgRear_MuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRear_MuteSet::mascf_mainfi_tclMsgRear_MuteSet(const mascf_mainfi_tclMsgRear_MuteSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Rear_Mute = coRef.Rear_Mute;
}
mascf_mainfi_tclMsgRear_MuteSet& mascf_mainfi_tclMsgRear_MuteSet::operator=(const mascf_mainfi_tclMsgRear_MuteSet& coRef)
{
   if (this == &coRef) return *this;
   Rear_Mute = coRef.Rear_Mute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRear_MuteSet::mascf_mainfi_tclMsgRear_MuteSet()
:Rear_Mute()
 {}

tS32 mascf_mainfi_tclMsgRear_MuteSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REAR_MUTESET;
}


mascf_mainfi_tclMsgRear_MuteSet::~mascf_mainfi_tclMsgRear_MuteSet()
{}

tU32 mascf_mainfi_tclMsgRear_MuteSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRear_MuteSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Rear_Mute);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRear_MuteSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Rear_Mute);
   return oOut;
}

tBool mascf_mainfi_tclMsgRear_MuteSet::operator==(const mascf_mainfi_tclMsgRear_MuteSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Rear_Mute == roRef.Rear_Mute);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRear_MuteStatus::mascf_mainfi_tclMsgRear_MuteStatus(const mascf_mainfi_tclMsgRear_MuteStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Rear_Mute = coRef.Rear_Mute;
}
mascf_mainfi_tclMsgRear_MuteStatus& mascf_mainfi_tclMsgRear_MuteStatus::operator=(const mascf_mainfi_tclMsgRear_MuteStatus& coRef)
{
   if (this == &coRef) return *this;
   Rear_Mute = coRef.Rear_Mute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRear_MuteStatus::mascf_mainfi_tclMsgRear_MuteStatus()
:Rear_Mute()
 {}

tS32 mascf_mainfi_tclMsgRear_MuteStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REAR_MUTESTATUS;
}


mascf_mainfi_tclMsgRear_MuteStatus::~mascf_mainfi_tclMsgRear_MuteStatus()
{}

tU32 mascf_mainfi_tclMsgRear_MuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRear_MuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Rear_Mute);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRear_MuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Rear_Mute);
   return oOut;
}

tBool mascf_mainfi_tclMsgRear_MuteStatus::operator==(const mascf_mainfi_tclMsgRear_MuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Rear_Mute == roRef.Rear_Mute);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgGeometry_ModeUpReg::mascf_mainfi_tclMsgGeometry_ModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgGeometry_ModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODEUPREG;
}


mascf_mainfi_tclMsgGeometry_ModeUpReg::~mascf_mainfi_tclMsgGeometry_ModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgGeometry_ModeRelUpReg::mascf_mainfi_tclMsgGeometry_ModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgGeometry_ModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODERELUPREG;
}


mascf_mainfi_tclMsgGeometry_ModeRelUpReg::~mascf_mainfi_tclMsgGeometry_ModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgGeometry_ModeGet::mascf_mainfi_tclMsgGeometry_ModeGet()
 {}

tS32 mascf_mainfi_tclMsgGeometry_ModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODEGET;
}


mascf_mainfi_tclMsgGeometry_ModeGet::~mascf_mainfi_tclMsgGeometry_ModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgGeometry_ModeSet::mascf_mainfi_tclMsgGeometry_ModeSet(const mascf_mainfi_tclMsgGeometry_ModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Geometry_Mode = coRef.Geometry_Mode;
}
mascf_mainfi_tclMsgGeometry_ModeSet& mascf_mainfi_tclMsgGeometry_ModeSet::operator=(const mascf_mainfi_tclMsgGeometry_ModeSet& coRef)
{
   if (this == &coRef) return *this;
   Geometry_Mode = coRef.Geometry_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgGeometry_ModeSet::mascf_mainfi_tclMsgGeometry_ModeSet()
:Geometry_Mode()
 {}

tS32 mascf_mainfi_tclMsgGeometry_ModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODESET;
}


mascf_mainfi_tclMsgGeometry_ModeSet::~mascf_mainfi_tclMsgGeometry_ModeSet()
{}

tU32 mascf_mainfi_tclMsgGeometry_ModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgGeometry_ModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Geometry_Mode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgGeometry_ModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Geometry_Mode);
   return oOut;
}

tBool mascf_mainfi_tclMsgGeometry_ModeSet::operator==(const mascf_mainfi_tclMsgGeometry_ModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Geometry_Mode == roRef.Geometry_Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgGeometry_ModeStatus::mascf_mainfi_tclMsgGeometry_ModeStatus(const mascf_mainfi_tclMsgGeometry_ModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Geometry_Mode = coRef.Geometry_Mode;
}
mascf_mainfi_tclMsgGeometry_ModeStatus& mascf_mainfi_tclMsgGeometry_ModeStatus::operator=(const mascf_mainfi_tclMsgGeometry_ModeStatus& coRef)
{
   if (this == &coRef) return *this;
   Geometry_Mode = coRef.Geometry_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgGeometry_ModeStatus::mascf_mainfi_tclMsgGeometry_ModeStatus()
:Geometry_Mode()
 {}

tS32 mascf_mainfi_tclMsgGeometry_ModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GEOMETRY_MODESTATUS;
}


mascf_mainfi_tclMsgGeometry_ModeStatus::~mascf_mainfi_tclMsgGeometry_ModeStatus()
{}

tU32 mascf_mainfi_tclMsgGeometry_ModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgGeometry_ModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Geometry_Mode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgGeometry_ModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Geometry_Mode);
   return oOut;
}

tBool mascf_mainfi_tclMsgGeometry_ModeStatus::operator==(const mascf_mainfi_tclMsgGeometry_ModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Geometry_Mode == roRef.Geometry_Mode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgLSValueStatusUpReg::mascf_mainfi_tclMsgLSValueStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgLSValueStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSUPREG;
}


mascf_mainfi_tclMsgLSValueStatusUpReg::~mascf_mainfi_tclMsgLSValueStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgLSValueStatusRelUpReg::mascf_mainfi_tclMsgLSValueStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgLSValueStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSRELUPREG;
}


mascf_mainfi_tclMsgLSValueStatusRelUpReg::~mascf_mainfi_tclMsgLSValueStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgLSValueStatusGet::mascf_mainfi_tclMsgLSValueStatusGet()
 {}

tS32 mascf_mainfi_tclMsgLSValueStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSGET;
}


mascf_mainfi_tclMsgLSValueStatusGet::~mascf_mainfi_tclMsgLSValueStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgLSValueStatusStatus::mascf_mainfi_tclMsgLSValueStatusStatus(const mascf_mainfi_tclMsgLSValueStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   u8NaviSetupLs = coRef.u8NaviSetupLs;
}
mascf_mainfi_tclMsgLSValueStatusStatus& mascf_mainfi_tclMsgLSValueStatusStatus::operator=(const mascf_mainfi_tclMsgLSValueStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NaviSetupLs = coRef.u8NaviSetupLs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgLSValueStatusStatus::mascf_mainfi_tclMsgLSValueStatusStatus()
:u8NaviSetupLs(0)
 {}

tS32 mascf_mainfi_tclMsgLSValueStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_LSVALUESTATUSSTATUS;
}


mascf_mainfi_tclMsgLSValueStatusStatus::~mascf_mainfi_tclMsgLSValueStatusStatus()
{}

tU32 mascf_mainfi_tclMsgLSValueStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgLSValueStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NaviSetupLs);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgLSValueStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NaviSetupLs);
   return oOut;
}

tBool mascf_mainfi_tclMsgLSValueStatusStatus::operator==(const mascf_mainfi_tclMsgLSValueStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NaviSetupLs == roRef.u8NaviSetupLs);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgPDCAttenuationLevelUpReg::mascf_mainfi_tclMsgPDCAttenuationLevelUpReg()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationLevelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELUPREG;
}


mascf_mainfi_tclMsgPDCAttenuationLevelUpReg::~mascf_mainfi_tclMsgPDCAttenuationLevelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg::mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELRELUPREG;
}


mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg::~mascf_mainfi_tclMsgPDCAttenuationLevelRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgPDCAttenuationLevelGet::mascf_mainfi_tclMsgPDCAttenuationLevelGet()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationLevelGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELGET;
}


mascf_mainfi_tclMsgPDCAttenuationLevelGet::~mascf_mainfi_tclMsgPDCAttenuationLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgPDCAttenuationLevelSet::mascf_mainfi_tclMsgPDCAttenuationLevelSet(const mascf_mainfi_tclMsgPDCAttenuationLevelSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   PDCAttenutionLevel = coRef.PDCAttenutionLevel;
}
mascf_mainfi_tclMsgPDCAttenuationLevelSet& mascf_mainfi_tclMsgPDCAttenuationLevelSet::operator=(const mascf_mainfi_tclMsgPDCAttenuationLevelSet& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenutionLevel = coRef.PDCAttenutionLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgPDCAttenuationLevelSet::mascf_mainfi_tclMsgPDCAttenuationLevelSet()
:PDCAttenutionLevel(0)
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationLevelSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELSET;
}


mascf_mainfi_tclMsgPDCAttenuationLevelSet::~mascf_mainfi_tclMsgPDCAttenuationLevelSet()
{}

tU32 mascf_mainfi_tclMsgPDCAttenuationLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgPDCAttenuationLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenutionLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgPDCAttenuationLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenutionLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgPDCAttenuationLevelSet::operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenutionLevel == roRef.PDCAttenutionLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgPDCAttenuationLevelStatus::mascf_mainfi_tclMsgPDCAttenuationLevelStatus(const mascf_mainfi_tclMsgPDCAttenuationLevelStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   PDCAttenuationLevel = coRef.PDCAttenuationLevel;
}
mascf_mainfi_tclMsgPDCAttenuationLevelStatus& mascf_mainfi_tclMsgPDCAttenuationLevelStatus::operator=(const mascf_mainfi_tclMsgPDCAttenuationLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenuationLevel = coRef.PDCAttenuationLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgPDCAttenuationLevelStatus::mascf_mainfi_tclMsgPDCAttenuationLevelStatus()
:PDCAttenuationLevel(0)
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationLevelStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONLEVELSTATUS;
}


mascf_mainfi_tclMsgPDCAttenuationLevelStatus::~mascf_mainfi_tclMsgPDCAttenuationLevelStatus()
{}

tU32 mascf_mainfi_tclMsgPDCAttenuationLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgPDCAttenuationLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenuationLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgPDCAttenuationLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenuationLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgPDCAttenuationLevelStatus::operator==(const mascf_mainfi_tclMsgPDCAttenuationLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenuationLevel == roRef.PDCAttenuationLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgPDCAttenuationUpReg::mascf_mainfi_tclMsgPDCAttenuationUpReg()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONUPREG;
}


mascf_mainfi_tclMsgPDCAttenuationUpReg::~mascf_mainfi_tclMsgPDCAttenuationUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgPDCAttenuationRelUpReg::mascf_mainfi_tclMsgPDCAttenuationRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONRELUPREG;
}


mascf_mainfi_tclMsgPDCAttenuationRelUpReg::~mascf_mainfi_tclMsgPDCAttenuationRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgPDCAttenuationGet::mascf_mainfi_tclMsgPDCAttenuationGet()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONGET;
}


mascf_mainfi_tclMsgPDCAttenuationGet::~mascf_mainfi_tclMsgPDCAttenuationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgPDCAttenuationSet::mascf_mainfi_tclMsgPDCAttenuationSet(const mascf_mainfi_tclMsgPDCAttenuationSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   PDCAttenuationCommand = coRef.PDCAttenuationCommand;
}
mascf_mainfi_tclMsgPDCAttenuationSet& mascf_mainfi_tclMsgPDCAttenuationSet::operator=(const mascf_mainfi_tclMsgPDCAttenuationSet& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenuationCommand = coRef.PDCAttenuationCommand;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgPDCAttenuationSet::mascf_mainfi_tclMsgPDCAttenuationSet()
:PDCAttenuationCommand()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONSET;
}


mascf_mainfi_tclMsgPDCAttenuationSet::~mascf_mainfi_tclMsgPDCAttenuationSet()
{}

tU32 mascf_mainfi_tclMsgPDCAttenuationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgPDCAttenuationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenuationCommand);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgPDCAttenuationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenuationCommand);
   return oOut;
}

tBool mascf_mainfi_tclMsgPDCAttenuationSet::operator==(const mascf_mainfi_tclMsgPDCAttenuationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenuationCommand == roRef.PDCAttenuationCommand);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgPDCAttenuationStatus::mascf_mainfi_tclMsgPDCAttenuationStatus(const mascf_mainfi_tclMsgPDCAttenuationStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   PDCAttenuation = coRef.PDCAttenuation;
}
mascf_mainfi_tclMsgPDCAttenuationStatus& mascf_mainfi_tclMsgPDCAttenuationStatus::operator=(const mascf_mainfi_tclMsgPDCAttenuationStatus& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenuation = coRef.PDCAttenuation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgPDCAttenuationStatus::mascf_mainfi_tclMsgPDCAttenuationStatus()
:PDCAttenuation()
 {}

tS32 mascf_mainfi_tclMsgPDCAttenuationStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_PDCATTENUATIONSTATUS;
}


mascf_mainfi_tclMsgPDCAttenuationStatus::~mascf_mainfi_tclMsgPDCAttenuationStatus()
{}

tU32 mascf_mainfi_tclMsgPDCAttenuationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgPDCAttenuationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenuation);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgPDCAttenuationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenuation);
   return oOut;
}

tBool mascf_mainfi_tclMsgPDCAttenuationStatus::operator==(const mascf_mainfi_tclMsgPDCAttenuationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenuation == roRef.PDCAttenuation);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAudioDeviceStatusUpReg::mascf_mainfi_tclMsgAudioDeviceStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSUPREG;
}


mascf_mainfi_tclMsgAudioDeviceStatusUpReg::~mascf_mainfi_tclMsgAudioDeviceStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg::mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSRELUPREG;
}


mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg::~mascf_mainfi_tclMsgAudioDeviceStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioDeviceStatusGet::mascf_mainfi_tclMsgAudioDeviceStatusGet()
 {}

tS32 mascf_mainfi_tclMsgAudioDeviceStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSGET;
}


mascf_mainfi_tclMsgAudioDeviceStatusGet::~mascf_mainfi_tclMsgAudioDeviceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioDeviceStatusStatus::mascf_mainfi_tclMsgAudioDeviceStatusStatus(const mascf_mainfi_tclMsgAudioDeviceStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AudioDeviceAvailability = coRef.AudioDeviceAvailability;
}
mascf_mainfi_tclMsgAudioDeviceStatusStatus& mascf_mainfi_tclMsgAudioDeviceStatusStatus::operator=(const mascf_mainfi_tclMsgAudioDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioDeviceAvailability = coRef.AudioDeviceAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioDeviceStatusStatus::mascf_mainfi_tclMsgAudioDeviceStatusStatus()
:AudioDeviceAvailability()
 {}

tS32 mascf_mainfi_tclMsgAudioDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIODEVICESTATUSSTATUS;
}


mascf_mainfi_tclMsgAudioDeviceStatusStatus::~mascf_mainfi_tclMsgAudioDeviceStatusStatus()
{}

tU32 mascf_mainfi_tclMsgAudioDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioDeviceAvailability);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioDeviceAvailability);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioDeviceStatusStatus::operator==(const mascf_mainfi_tclMsgAudioDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioDeviceAvailability == roRef.AudioDeviceAvailability);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgOverTempReductionUpReg::mascf_mainfi_tclMsgOverTempReductionUpReg()
 {}

tS32 mascf_mainfi_tclMsgOverTempReductionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONUPREG;
}


mascf_mainfi_tclMsgOverTempReductionUpReg::~mascf_mainfi_tclMsgOverTempReductionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgOverTempReductionRelUpReg::mascf_mainfi_tclMsgOverTempReductionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgOverTempReductionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONRELUPREG;
}


mascf_mainfi_tclMsgOverTempReductionRelUpReg::~mascf_mainfi_tclMsgOverTempReductionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgOverTempReductionGet::mascf_mainfi_tclMsgOverTempReductionGet()
 {}

tS32 mascf_mainfi_tclMsgOverTempReductionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONGET;
}


mascf_mainfi_tclMsgOverTempReductionGet::~mascf_mainfi_tclMsgOverTempReductionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgOverTempReductionSet::mascf_mainfi_tclMsgOverTempReductionSet(const mascf_mainfi_tclMsgOverTempReductionSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DownScaling_Active = coRef.DownScaling_Active;
   ReductionInterval = coRef.ReductionInterval;
}
mascf_mainfi_tclMsgOverTempReductionSet& mascf_mainfi_tclMsgOverTempReductionSet::operator=(const mascf_mainfi_tclMsgOverTempReductionSet& coRef)
{
   if (this == &coRef) return *this;
   DownScaling_Active = coRef.DownScaling_Active;
   ReductionInterval = coRef.ReductionInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgOverTempReductionSet::mascf_mainfi_tclMsgOverTempReductionSet()
:DownScaling_Active(0)
,ReductionInterval(0)
 {}

tS32 mascf_mainfi_tclMsgOverTempReductionSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONSET;
}


mascf_mainfi_tclMsgOverTempReductionSet::~mascf_mainfi_tclMsgOverTempReductionSet()
{}

tU32 mascf_mainfi_tclMsgOverTempReductionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgOverTempReductionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DownScaling_Active);
   (tVoid) (oIn >> ReductionInterval);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgOverTempReductionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DownScaling_Active);
   (tVoid) (oOut << ReductionInterval);
   return oOut;
}

tBool mascf_mainfi_tclMsgOverTempReductionSet::operator==(const mascf_mainfi_tclMsgOverTempReductionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DownScaling_Active == roRef.DownScaling_Active);
   bResult = bResult && (ReductionInterval == roRef.ReductionInterval);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgOverTempReductionStatus::mascf_mainfi_tclMsgOverTempReductionStatus(const mascf_mainfi_tclMsgOverTempReductionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ActiveByCommand = coRef.ActiveByCommand;
   ActiveByAmplifier = coRef.ActiveByAmplifier;
   CurrentFactor = coRef.CurrentFactor;
   ReductionInterval = coRef.ReductionInterval;
}
mascf_mainfi_tclMsgOverTempReductionStatus& mascf_mainfi_tclMsgOverTempReductionStatus::operator=(const mascf_mainfi_tclMsgOverTempReductionStatus& coRef)
{
   if (this == &coRef) return *this;
   ActiveByCommand = coRef.ActiveByCommand;
   ActiveByAmplifier = coRef.ActiveByAmplifier;
   CurrentFactor = coRef.CurrentFactor;
   ReductionInterval = coRef.ReductionInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgOverTempReductionStatus::mascf_mainfi_tclMsgOverTempReductionStatus()
:ActiveByCommand(0)
,ActiveByAmplifier(0)
,CurrentFactor(0)
,ReductionInterval(0)
 {}

tS32 mascf_mainfi_tclMsgOverTempReductionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPREDUCTIONSTATUS;
}


mascf_mainfi_tclMsgOverTempReductionStatus::~mascf_mainfi_tclMsgOverTempReductionStatus()
{}

tU32 mascf_mainfi_tclMsgOverTempReductionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_mainfi_tclMsgOverTempReductionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActiveByCommand);
   (tVoid) (oIn >> ActiveByAmplifier);
   (tVoid) (oIn >> CurrentFactor);
   (tVoid) (oIn >> ReductionInterval);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgOverTempReductionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActiveByCommand);
   (tVoid) (oOut << ActiveByAmplifier);
   (tVoid) (oOut << CurrentFactor);
   (tVoid) (oOut << ReductionInterval);
   return oOut;
}

tBool mascf_mainfi_tclMsgOverTempReductionStatus::operator==(const mascf_mainfi_tclMsgOverTempReductionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActiveByCommand == roRef.ActiveByCommand);
   bResult = bResult && (ActiveByAmplifier == roRef.ActiveByAmplifier);
   bResult = bResult && (CurrentFactor == roRef.CurrentFactor);
   bResult = bResult && (ReductionInterval == roRef.ReductionInterval);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg::mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSUPREG;
}


mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg::~mascf_mainfi_tclMsgOverTempAmplifierStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg::mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSRELUPREG;
}


mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg::~mascf_mainfi_tclMsgOverTempAmplifierStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgOverTempAmplifierStatusGet::mascf_mainfi_tclMsgOverTempAmplifierStatusGet()
 {}

tS32 mascf_mainfi_tclMsgOverTempAmplifierStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSGET;
}


mascf_mainfi_tclMsgOverTempAmplifierStatusGet::~mascf_mainfi_tclMsgOverTempAmplifierStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::mascf_mainfi_tclMsgOverTempAmplifierStatusStatus(const mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AmpTemperatureLevel = coRef.AmpTemperatureLevel;
}
mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::operator=(const mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   AmpTemperatureLevel = coRef.AmpTemperatureLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::mascf_mainfi_tclMsgOverTempAmplifierStatusStatus()
:AmpTemperatureLevel()
 {}

tS32 mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSSTATUS;
}


mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::~mascf_mainfi_tclMsgOverTempAmplifierStatusStatus()
{}

tU32 mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmpTemperatureLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmpTemperatureLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgOverTempAmplifierStatusStatus::operator==(const mascf_mainfi_tclMsgOverTempAmplifierStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmpTemperatureLevel == roRef.AmpTemperatureLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgReadMeasurementResultUpReg::mascf_mainfi_tclMsgReadMeasurementResultUpReg()
 {}

tS32 mascf_mainfi_tclMsgReadMeasurementResultUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTUPREG;
}


mascf_mainfi_tclMsgReadMeasurementResultUpReg::~mascf_mainfi_tclMsgReadMeasurementResultUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgReadMeasurementResultRelUpReg::mascf_mainfi_tclMsgReadMeasurementResultRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgReadMeasurementResultRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTRELUPREG;
}


mascf_mainfi_tclMsgReadMeasurementResultRelUpReg::~mascf_mainfi_tclMsgReadMeasurementResultRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgReadMeasurementResultGet::mascf_mainfi_tclMsgReadMeasurementResultGet()
 {}

tS32 mascf_mainfi_tclMsgReadMeasurementResultGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTGET;
}


mascf_mainfi_tclMsgReadMeasurementResultGet::~mascf_mainfi_tclMsgReadMeasurementResultGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgReadMeasurementResultStatus::mascf_mainfi_tclMsgReadMeasurementResultStatus(const mascf_mainfi_tclMsgReadMeasurementResultStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   MeasurementResultList = coRef.MeasurementResultList;
}
mascf_mainfi_tclMsgReadMeasurementResultStatus& mascf_mainfi_tclMsgReadMeasurementResultStatus::operator=(const mascf_mainfi_tclMsgReadMeasurementResultStatus& coRef)
{
   if (this == &coRef) return *this;
   MeasurementResultList = coRef.MeasurementResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgReadMeasurementResultStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MeasurementResultList.size(); ++u32Idx)
         MeasurementResultList[u32Idx].vDestroy();
   MeasurementResultList.clear();
   }
}

mascf_mainfi_tclMsgReadMeasurementResultStatus::mascf_mainfi_tclMsgReadMeasurementResultStatus()

 {}

tS32 mascf_mainfi_tclMsgReadMeasurementResultStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_READMEASUREMENTRESULTSTATUS;
}


mascf_mainfi_tclMsgReadMeasurementResultStatus::~mascf_mainfi_tclMsgReadMeasurementResultStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgReadMeasurementResultStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MeasurementResultList.size()*5);
}

fi_tclInContext& mascf_mainfi_tclMsgReadMeasurementResultStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MeasurementResultList.size(); ++u32Idx)
      {
         MeasurementResultList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MeasurementResultList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MeasurementResultList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgReadMeasurementResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MeasurementResultList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MeasurementResultList.size(); ++u32Idx)
         (tVoid) (oOut << MeasurementResultList[u32Idx]);
   }
   return oOut;
}

tBool mascf_mainfi_tclMsgReadMeasurementResultStatus::operator==(const mascf_mainfi_tclMsgReadMeasurementResultStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MeasurementResultList.size() == roRef.MeasurementResultList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MeasurementResultList.size()); ++u32Idx)
            bResult = bResult && (MeasurementResultList[u32Idx] == roRef.MeasurementResultList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgCenterUpReg::mascf_mainfi_tclMsgCenterUpReg()
 {}

tS32 mascf_mainfi_tclMsgCenterUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CENTERUPREG;
}


mascf_mainfi_tclMsgCenterUpReg::~mascf_mainfi_tclMsgCenterUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgCenterRelUpReg::mascf_mainfi_tclMsgCenterRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgCenterRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CENTERRELUPREG;
}


mascf_mainfi_tclMsgCenterRelUpReg::~mascf_mainfi_tclMsgCenterRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgCenterGet::mascf_mainfi_tclMsgCenterGet()
 {}

tS32 mascf_mainfi_tclMsgCenterGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CENTERGET;
}


mascf_mainfi_tclMsgCenterGet::~mascf_mainfi_tclMsgCenterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgCenterSet::mascf_mainfi_tclMsgCenterSet(const mascf_mainfi_tclMsgCenterSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Center = coRef.Center;
}
mascf_mainfi_tclMsgCenterSet& mascf_mainfi_tclMsgCenterSet::operator=(const mascf_mainfi_tclMsgCenterSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Center = coRef.Center;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgCenterSet::mascf_mainfi_tclMsgCenterSet()
:SoundType()
,Resource()
,Center(0)
 {}

tS32 mascf_mainfi_tclMsgCenterSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CENTERSET;
}


mascf_mainfi_tclMsgCenterSet::~mascf_mainfi_tclMsgCenterSet()
{}

tU32 mascf_mainfi_tclMsgCenterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_mainfi_tclMsgCenterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Center);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgCenterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Center);
   return oOut;
}

tBool mascf_mainfi_tclMsgCenterSet::operator==(const mascf_mainfi_tclMsgCenterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Center == roRef.Center);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgCenterStatus::mascf_mainfi_tclMsgCenterStatus(const mascf_mainfi_tclMsgCenterStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Center = coRef.Center;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgCenterStatus& mascf_mainfi_tclMsgCenterStatus::operator=(const mascf_mainfi_tclMsgCenterStatus& coRef)
{
   if (this == &coRef) return *this;
   Center = coRef.Center;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgCenterStatus::mascf_mainfi_tclMsgCenterStatus()
:Center(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgCenterStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CENTERSTATUS;
}


mascf_mainfi_tclMsgCenterStatus::~mascf_mainfi_tclMsgCenterStatus()
{}

tU32 mascf_mainfi_tclMsgCenterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_mainfi_tclMsgCenterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Center);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgCenterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Center);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgCenterStatus::operator==(const mascf_mainfi_tclMsgCenterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Center == roRef.Center);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgSubWooferUpReg::mascf_mainfi_tclMsgSubWooferUpReg()
 {}

tS32 mascf_mainfi_tclMsgSubWooferUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SUBWOOFERUPREG;
}


mascf_mainfi_tclMsgSubWooferUpReg::~mascf_mainfi_tclMsgSubWooferUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSubWooferRelUpReg::mascf_mainfi_tclMsgSubWooferRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgSubWooferRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SUBWOOFERRELUPREG;
}


mascf_mainfi_tclMsgSubWooferRelUpReg::~mascf_mainfi_tclMsgSubWooferRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSubWooferGet::mascf_mainfi_tclMsgSubWooferGet()
 {}

tS32 mascf_mainfi_tclMsgSubWooferGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SUBWOOFERGET;
}


mascf_mainfi_tclMsgSubWooferGet::~mascf_mainfi_tclMsgSubWooferGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSubWooferSet::mascf_mainfi_tclMsgSubWooferSet(const mascf_mainfi_tclMsgSubWooferSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SubWoofer = coRef.SubWoofer;
}
mascf_mainfi_tclMsgSubWooferSet& mascf_mainfi_tclMsgSubWooferSet::operator=(const mascf_mainfi_tclMsgSubWooferSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SubWoofer = coRef.SubWoofer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSubWooferSet::mascf_mainfi_tclMsgSubWooferSet()
:SoundType()
,Resource()
,SubWoofer(0)
 {}

tS32 mascf_mainfi_tclMsgSubWooferSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SUBWOOFERSET;
}


mascf_mainfi_tclMsgSubWooferSet::~mascf_mainfi_tclMsgSubWooferSet()
{}

tU32 mascf_mainfi_tclMsgSubWooferSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_mainfi_tclMsgSubWooferSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> SubWoofer);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSubWooferSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << SubWoofer);
   return oOut;
}

tBool mascf_mainfi_tclMsgSubWooferSet::operator==(const mascf_mainfi_tclMsgSubWooferSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (SubWoofer == roRef.SubWoofer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSubWooferStatus::mascf_mainfi_tclMsgSubWooferStatus(const mascf_mainfi_tclMsgSubWooferStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SubWoofer = coRef.SubWoofer;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgSubWooferStatus& mascf_mainfi_tclMsgSubWooferStatus::operator=(const mascf_mainfi_tclMsgSubWooferStatus& coRef)
{
   if (this == &coRef) return *this;
   SubWoofer = coRef.SubWoofer;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSubWooferStatus::mascf_mainfi_tclMsgSubWooferStatus()
:SubWoofer(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgSubWooferStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SUBWOOFERSTATUS;
}


mascf_mainfi_tclMsgSubWooferStatus::~mascf_mainfi_tclMsgSubWooferStatus()
{}

tU32 mascf_mainfi_tclMsgSubWooferStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mascf_mainfi_tclMsgSubWooferStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubWoofer);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSubWooferStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubWoofer);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgSubWooferStatus::operator==(const mascf_mainfi_tclMsgSubWooferStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubWoofer == roRef.SubWoofer);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg::mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg()
 {}

tS32 mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEUPREG;
}


mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg::~mascf_mainfi_tclMsgExternalAmplifierConnectionStateUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg::mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATERELUPREG;
}


mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg::~mascf_mainfi_tclMsgExternalAmplifierConnectionStateRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet::mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet()
 {}

tS32 mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEGET;
}


mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet::~mascf_mainfi_tclMsgExternalAmplifierConnectionStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ConnectionState = coRef.ConnectionState;
}
mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::operator=(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectionState = coRef.ConnectionState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus()
:ConnectionState(0)
 {}

tS32 mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATESTATUS;
}


mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::~mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus()
{}

tU32 mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConnectionState);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConnectionState);
   return oOut;
}

tBool mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus::operator==(const mascf_mainfi_tclMsgExternalAmplifierConnectionStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConnectionState == roRef.ConnectionState);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgGeneralSpeakerTestUpReg::mascf_mainfi_tclMsgGeneralSpeakerTestUpReg()
 {}

tS32 mascf_mainfi_tclMsgGeneralSpeakerTestUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTUPREG;
}


mascf_mainfi_tclMsgGeneralSpeakerTestUpReg::~mascf_mainfi_tclMsgGeneralSpeakerTestUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg::mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTRELUPREG;
}


mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg::~mascf_mainfi_tclMsgGeneralSpeakerTestRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgGeneralSpeakerTestGet::mascf_mainfi_tclMsgGeneralSpeakerTestGet()
 {}

tS32 mascf_mainfi_tclMsgGeneralSpeakerTestGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTGET;
}


mascf_mainfi_tclMsgGeneralSpeakerTestGet::~mascf_mainfi_tclMsgGeneralSpeakerTestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgGeneralSpeakerTestSet::mascf_mainfi_tclMsgGeneralSpeakerTestSet(const mascf_mainfi_tclMsgGeneralSpeakerTestSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Request = coRef.Request;
}
mascf_mainfi_tclMsgGeneralSpeakerTestSet& mascf_mainfi_tclMsgGeneralSpeakerTestSet::operator=(const mascf_mainfi_tclMsgGeneralSpeakerTestSet& coRef)
{
   if (this == &coRef) return *this;
   Request = coRef.Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgGeneralSpeakerTestSet::mascf_mainfi_tclMsgGeneralSpeakerTestSet()
:Request(0)
 {}

tS32 mascf_mainfi_tclMsgGeneralSpeakerTestSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTSET;
}


mascf_mainfi_tclMsgGeneralSpeakerTestSet::~mascf_mainfi_tclMsgGeneralSpeakerTestSet()
{}

tU32 mascf_mainfi_tclMsgGeneralSpeakerTestSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgGeneralSpeakerTestSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Request);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgGeneralSpeakerTestSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Request);
   return oOut;
}

tBool mascf_mainfi_tclMsgGeneralSpeakerTestSet::operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Request == roRef.Request);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgGeneralSpeakerTestStatus::mascf_mainfi_tclMsgGeneralSpeakerTestStatus(const mascf_mainfi_tclMsgGeneralSpeakerTestStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SpeakerValue_1 = coRef.SpeakerValue_1;
   SpeakerValue_2 = coRef.SpeakerValue_2;
   SpeakerValue_3 = coRef.SpeakerValue_3;
   SpeakerValue_4 = coRef.SpeakerValue_4;
   SpeakerValue_5 = coRef.SpeakerValue_5;
}
mascf_mainfi_tclMsgGeneralSpeakerTestStatus& mascf_mainfi_tclMsgGeneralSpeakerTestStatus::operator=(const mascf_mainfi_tclMsgGeneralSpeakerTestStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeakerValue_1 = coRef.SpeakerValue_1;
   SpeakerValue_2 = coRef.SpeakerValue_2;
   SpeakerValue_3 = coRef.SpeakerValue_3;
   SpeakerValue_4 = coRef.SpeakerValue_4;
   SpeakerValue_5 = coRef.SpeakerValue_5;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgGeneralSpeakerTestStatus::mascf_mainfi_tclMsgGeneralSpeakerTestStatus()
:SpeakerValue_1(0)
,SpeakerValue_2(0)
,SpeakerValue_3(0)
,SpeakerValue_4(0)
,SpeakerValue_5(0)
 {}

tS32 mascf_mainfi_tclMsgGeneralSpeakerTestStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_GENERALSPEAKERTESTSTATUS;
}


mascf_mainfi_tclMsgGeneralSpeakerTestStatus::~mascf_mainfi_tclMsgGeneralSpeakerTestStatus()
{}

tU32 mascf_mainfi_tclMsgGeneralSpeakerTestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mascf_mainfi_tclMsgGeneralSpeakerTestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeakerValue_1);
   (tVoid) (oIn >> SpeakerValue_2);
   (tVoid) (oIn >> SpeakerValue_3);
   (tVoid) (oIn >> SpeakerValue_4);
   (tVoid) (oIn >> SpeakerValue_5);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgGeneralSpeakerTestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeakerValue_1);
   (tVoid) (oOut << SpeakerValue_2);
   (tVoid) (oOut << SpeakerValue_3);
   (tVoid) (oOut << SpeakerValue_4);
   (tVoid) (oOut << SpeakerValue_5);
   return oOut;
}

tBool mascf_mainfi_tclMsgGeneralSpeakerTestStatus::operator==(const mascf_mainfi_tclMsgGeneralSpeakerTestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeakerValue_1 == roRef.SpeakerValue_1);
   bResult = bResult && (SpeakerValue_2 == roRef.SpeakerValue_2);
   bResult = bResult && (SpeakerValue_3 == roRef.SpeakerValue_3);
   bResult = bResult && (SpeakerValue_4 == roRef.SpeakerValue_4);
   bResult = bResult && (SpeakerValue_5 == roRef.SpeakerValue_5);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgANCSWVersionUpReg::mascf_mainfi_tclMsgANCSWVersionUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCSWVersionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONUPREG;
}


mascf_mainfi_tclMsgANCSWVersionUpReg::~mascf_mainfi_tclMsgANCSWVersionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCSWVersionRelUpReg::mascf_mainfi_tclMsgANCSWVersionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCSWVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONRELUPREG;
}


mascf_mainfi_tclMsgANCSWVersionRelUpReg::~mascf_mainfi_tclMsgANCSWVersionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCSWVersionGet::mascf_mainfi_tclMsgANCSWVersionGet()
 {}

tS32 mascf_mainfi_tclMsgANCSWVersionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONGET;
}


mascf_mainfi_tclMsgANCSWVersionGet::~mascf_mainfi_tclMsgANCSWVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgANCSWVersionStatus::mascf_mainfi_tclMsgANCSWVersionStatus(const mascf_mainfi_tclMsgANCSWVersionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
}
mascf_mainfi_tclMsgANCSWVersionStatus& mascf_mainfi_tclMsgANCSWVersionStatus::operator=(const mascf_mainfi_tclMsgANCSWVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgANCSWVersionStatus::mascf_mainfi_tclMsgANCSWVersionStatus()
:LargeVersion(0)
,MiddleVersion(0)
,SmallVersion(0)
 {}

tS32 mascf_mainfi_tclMsgANCSWVersionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCSWVERSIONSTATUS;
}


mascf_mainfi_tclMsgANCSWVersionStatus::~mascf_mainfi_tclMsgANCSWVersionStatus()
{}

tU32 mascf_mainfi_tclMsgANCSWVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgANCSWVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LargeVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> SmallVersion);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgANCSWVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LargeVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << SmallVersion);
   return oOut;
}

tBool mascf_mainfi_tclMsgANCSWVersionStatus::operator==(const mascf_mainfi_tclMsgANCSWVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LargeVersion == roRef.LargeVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (SmallVersion == roRef.SmallVersion);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgASCSWVersionUpReg::mascf_mainfi_tclMsgASCSWVersionUpReg()
 {}

tS32 mascf_mainfi_tclMsgASCSWVersionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONUPREG;
}


mascf_mainfi_tclMsgASCSWVersionUpReg::~mascf_mainfi_tclMsgASCSWVersionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgASCSWVersionRelUpReg::mascf_mainfi_tclMsgASCSWVersionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgASCSWVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONRELUPREG;
}


mascf_mainfi_tclMsgASCSWVersionRelUpReg::~mascf_mainfi_tclMsgASCSWVersionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgASCSWVersionGet::mascf_mainfi_tclMsgASCSWVersionGet()
 {}

tS32 mascf_mainfi_tclMsgASCSWVersionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONGET;
}


mascf_mainfi_tclMsgASCSWVersionGet::~mascf_mainfi_tclMsgASCSWVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgASCSWVersionStatus::mascf_mainfi_tclMsgASCSWVersionStatus(const mascf_mainfi_tclMsgASCSWVersionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
}
mascf_mainfi_tclMsgASCSWVersionStatus& mascf_mainfi_tclMsgASCSWVersionStatus::operator=(const mascf_mainfi_tclMsgASCSWVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgASCSWVersionStatus::mascf_mainfi_tclMsgASCSWVersionStatus()
:LargeVersion(0)
,MiddleVersion(0)
,SmallVersion(0)
 {}

tS32 mascf_mainfi_tclMsgASCSWVersionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ASCSWVERSIONSTATUS;
}


mascf_mainfi_tclMsgASCSWVersionStatus::~mascf_mainfi_tclMsgASCSWVersionStatus()
{}

tU32 mascf_mainfi_tclMsgASCSWVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgASCSWVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LargeVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> SmallVersion);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgASCSWVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LargeVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << SmallVersion);
   return oOut;
}

tBool mascf_mainfi_tclMsgASCSWVersionStatus::operator==(const mascf_mainfi_tclMsgASCSWVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LargeVersion == roRef.LargeVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (SmallVersion == roRef.SmallVersion);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgANCASCSettingUpReg::mascf_mainfi_tclMsgANCASCSettingUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCASCSettingUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGUPREG;
}


mascf_mainfi_tclMsgANCASCSettingUpReg::~mascf_mainfi_tclMsgANCASCSettingUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCSettingRelUpReg::mascf_mainfi_tclMsgANCASCSettingRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCASCSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGRELUPREG;
}


mascf_mainfi_tclMsgANCASCSettingRelUpReg::~mascf_mainfi_tclMsgANCASCSettingRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCSettingGet::mascf_mainfi_tclMsgANCASCSettingGet()
 {}

tS32 mascf_mainfi_tclMsgANCASCSettingGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGGET;
}


mascf_mainfi_tclMsgANCASCSettingGet::~mascf_mainfi_tclMsgANCASCSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgANCASCSettingSet::mascf_mainfi_tclMsgANCASCSettingSet(const mascf_mainfi_tclMsgANCASCSettingSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
}
mascf_mainfi_tclMsgANCASCSettingSet& mascf_mainfi_tclMsgANCASCSettingSet::operator=(const mascf_mainfi_tclMsgANCASCSettingSet& coRef)
{
   if (this == &coRef) return *this;
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgANCASCSettingSet::mascf_mainfi_tclMsgANCASCSettingSet()
:ANCAvailability(0)
,ASCAvailability(0)
 {}

tS32 mascf_mainfi_tclMsgANCASCSettingSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGSET;
}


mascf_mainfi_tclMsgANCASCSettingSet::~mascf_mainfi_tclMsgANCASCSettingSet()
{}

tU32 mascf_mainfi_tclMsgANCASCSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgANCASCSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ANCAvailability);
   (tVoid) (oIn >> ASCAvailability);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgANCASCSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ANCAvailability);
   (tVoid) (oOut << ASCAvailability);
   return oOut;
}

tBool mascf_mainfi_tclMsgANCASCSettingSet::operator==(const mascf_mainfi_tclMsgANCASCSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ANCAvailability == roRef.ANCAvailability);
   bResult = bResult && (ASCAvailability == roRef.ASCAvailability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgANCASCSettingStatus::mascf_mainfi_tclMsgANCASCSettingStatus(const mascf_mainfi_tclMsgANCASCSettingStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
}
mascf_mainfi_tclMsgANCASCSettingStatus& mascf_mainfi_tclMsgANCASCSettingStatus::operator=(const mascf_mainfi_tclMsgANCASCSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgANCASCSettingStatus::mascf_mainfi_tclMsgANCASCSettingStatus()
:ANCAvailability(0)
,ASCAvailability(0)
 {}

tS32 mascf_mainfi_tclMsgANCASCSettingStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSETTINGSTATUS;
}


mascf_mainfi_tclMsgANCASCSettingStatus::~mascf_mainfi_tclMsgANCASCSettingStatus()
{}

tU32 mascf_mainfi_tclMsgANCASCSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgANCASCSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ANCAvailability);
   (tVoid) (oIn >> ASCAvailability);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgANCASCSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ANCAvailability);
   (tVoid) (oOut << ASCAvailability);
   return oOut;
}

tBool mascf_mainfi_tclMsgANCASCSettingStatus::operator==(const mascf_mainfi_tclMsgANCASCSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ANCAvailability == roRef.ANCAvailability);
   bResult = bResult && (ASCAvailability == roRef.ASCAvailability);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAmpSoftwareVersionUpReg::mascf_mainfi_tclMsgAmpSoftwareVersionUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpSoftwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONUPREG;
}


mascf_mainfi_tclMsgAmpSoftwareVersionUpReg::~mascf_mainfi_tclMsgAmpSoftwareVersionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg::mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONRELUPREG;
}


mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg::~mascf_mainfi_tclMsgAmpSoftwareVersionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpSoftwareVersionGet::mascf_mainfi_tclMsgAmpSoftwareVersionGet()
 {}

tS32 mascf_mainfi_tclMsgAmpSoftwareVersionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONGET;
}


mascf_mainfi_tclMsgAmpSoftwareVersionGet::~mascf_mainfi_tclMsgAmpSoftwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpSoftwareVersionStatus::mascf_mainfi_tclMsgAmpSoftwareVersionStatus(const mascf_mainfi_tclMsgAmpSoftwareVersionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
}
mascf_mainfi_tclMsgAmpSoftwareVersionStatus& mascf_mainfi_tclMsgAmpSoftwareVersionStatus::operator=(const mascf_mainfi_tclMsgAmpSoftwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpSoftwareVersionStatus::mascf_mainfi_tclMsgAmpSoftwareVersionStatus()
:LowerVersion(0)
,MiddleVersion(0)
,HigherVersion(0)
 {}

tS32 mascf_mainfi_tclMsgAmpSoftwareVersionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPSOFTWAREVERSIONSTATUS;
}


mascf_mainfi_tclMsgAmpSoftwareVersionStatus::~mascf_mainfi_tclMsgAmpSoftwareVersionStatus()
{}

tU32 mascf_mainfi_tclMsgAmpSoftwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpSoftwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowerVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> HigherVersion);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpSoftwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowerVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << HigherVersion);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpSoftwareVersionStatus::operator==(const mascf_mainfi_tclMsgAmpSoftwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowerVersion == roRef.LowerVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (HigherVersion == roRef.HigherVersion);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAmpParameterVersionUpReg::mascf_mainfi_tclMsgAmpParameterVersionUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpParameterVersionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONUPREG;
}


mascf_mainfi_tclMsgAmpParameterVersionUpReg::~mascf_mainfi_tclMsgAmpParameterVersionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpParameterVersionRelUpReg::mascf_mainfi_tclMsgAmpParameterVersionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpParameterVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONRELUPREG;
}


mascf_mainfi_tclMsgAmpParameterVersionRelUpReg::~mascf_mainfi_tclMsgAmpParameterVersionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpParameterVersionGet::mascf_mainfi_tclMsgAmpParameterVersionGet()
 {}

tS32 mascf_mainfi_tclMsgAmpParameterVersionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONGET;
}


mascf_mainfi_tclMsgAmpParameterVersionGet::~mascf_mainfi_tclMsgAmpParameterVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpParameterVersionStatus::mascf_mainfi_tclMsgAmpParameterVersionStatus(const mascf_mainfi_tclMsgAmpParameterVersionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
}
mascf_mainfi_tclMsgAmpParameterVersionStatus& mascf_mainfi_tclMsgAmpParameterVersionStatus::operator=(const mascf_mainfi_tclMsgAmpParameterVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpParameterVersionStatus::mascf_mainfi_tclMsgAmpParameterVersionStatus()
:LowerVersion(0)
,MiddleVersion(0)
,HigherVersion(0)
 {}

tS32 mascf_mainfi_tclMsgAmpParameterVersionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPPARAMETERVERSIONSTATUS;
}


mascf_mainfi_tclMsgAmpParameterVersionStatus::~mascf_mainfi_tclMsgAmpParameterVersionStatus()
{}

tU32 mascf_mainfi_tclMsgAmpParameterVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpParameterVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowerVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> HigherVersion);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpParameterVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowerVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << HigherVersion);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpParameterVersionStatus::operator==(const mascf_mainfi_tclMsgAmpParameterVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowerVersion == roRef.LowerVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (HigherVersion == roRef.HigherVersion);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAmpHardwareVersionUpReg::mascf_mainfi_tclMsgAmpHardwareVersionUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpHardwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONUPREG;
}


mascf_mainfi_tclMsgAmpHardwareVersionUpReg::~mascf_mainfi_tclMsgAmpHardwareVersionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg::mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONRELUPREG;
}


mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg::~mascf_mainfi_tclMsgAmpHardwareVersionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpHardwareVersionGet::mascf_mainfi_tclMsgAmpHardwareVersionGet()
 {}

tS32 mascf_mainfi_tclMsgAmpHardwareVersionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONGET;
}


mascf_mainfi_tclMsgAmpHardwareVersionGet::~mascf_mainfi_tclMsgAmpHardwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpHardwareVersionStatus::mascf_mainfi_tclMsgAmpHardwareVersionStatus(const mascf_mainfi_tclMsgAmpHardwareVersionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
}
mascf_mainfi_tclMsgAmpHardwareVersionStatus& mascf_mainfi_tclMsgAmpHardwareVersionStatus::operator=(const mascf_mainfi_tclMsgAmpHardwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpHardwareVersionStatus::mascf_mainfi_tclMsgAmpHardwareVersionStatus()
:LowerVersion(0)
,MiddleVersion(0)
,HigherVersion(0)
 {}

tS32 mascf_mainfi_tclMsgAmpHardwareVersionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPHARDWAREVERSIONSTATUS;
}


mascf_mainfi_tclMsgAmpHardwareVersionStatus::~mascf_mainfi_tclMsgAmpHardwareVersionStatus()
{}

tU32 mascf_mainfi_tclMsgAmpHardwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpHardwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowerVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> HigherVersion);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpHardwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowerVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << HigherVersion);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpHardwareVersionStatus::operator==(const mascf_mainfi_tclMsgAmpHardwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowerVersion == roRef.LowerVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (HigherVersion == roRef.HigherVersion);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgSurroundVolUpReg::mascf_mainfi_tclMsgSurroundVolUpReg()
 {}

tS32 mascf_mainfi_tclMsgSurroundVolUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLUPREG;
}


mascf_mainfi_tclMsgSurroundVolUpReg::~mascf_mainfi_tclMsgSurroundVolUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSurroundVolRelUpReg::mascf_mainfi_tclMsgSurroundVolRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgSurroundVolRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLRELUPREG;
}


mascf_mainfi_tclMsgSurroundVolRelUpReg::~mascf_mainfi_tclMsgSurroundVolRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSurroundVolGet::mascf_mainfi_tclMsgSurroundVolGet()
 {}

tS32 mascf_mainfi_tclMsgSurroundVolGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLGET;
}


mascf_mainfi_tclMsgSurroundVolGet::~mascf_mainfi_tclMsgSurroundVolGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSurroundVolSet::mascf_mainfi_tclMsgSurroundVolSet(const mascf_mainfi_tclMsgSurroundVolSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SurroundVol = coRef.SurroundVol;
}
mascf_mainfi_tclMsgSurroundVolSet& mascf_mainfi_tclMsgSurroundVolSet::operator=(const mascf_mainfi_tclMsgSurroundVolSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SurroundVol = coRef.SurroundVol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSurroundVolSet::mascf_mainfi_tclMsgSurroundVolSet()
:SoundType()
,Resource()
,SurroundVol(0)
 {}

tS32 mascf_mainfi_tclMsgSurroundVolSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLSET;
}


mascf_mainfi_tclMsgSurroundVolSet::~mascf_mainfi_tclMsgSurroundVolSet()
{}

tU32 mascf_mainfi_tclMsgSurroundVolSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgSurroundVolSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> SurroundVol);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSurroundVolSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << SurroundVol);
   return oOut;
}

tBool mascf_mainfi_tclMsgSurroundVolSet::operator==(const mascf_mainfi_tclMsgSurroundVolSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (SurroundVol == roRef.SurroundVol);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSurroundVolStatus::mascf_mainfi_tclMsgSurroundVolStatus(const mascf_mainfi_tclMsgSurroundVolStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SurroundVol = coRef.SurroundVol;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
mascf_mainfi_tclMsgSurroundVolStatus& mascf_mainfi_tclMsgSurroundVolStatus::operator=(const mascf_mainfi_tclMsgSurroundVolStatus& coRef)
{
   if (this == &coRef) return *this;
   SurroundVol = coRef.SurroundVol;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSurroundVolStatus::mascf_mainfi_tclMsgSurroundVolStatus()
:SurroundVol(0)
,Resource()
,Channel()
 {}

tS32 mascf_mainfi_tclMsgSurroundVolStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDVOLSTATUS;
}


mascf_mainfi_tclMsgSurroundVolStatus::~mascf_mainfi_tclMsgSurroundVolStatus()
{}

tU32 mascf_mainfi_tclMsgSurroundVolStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mascf_mainfi_tclMsgSurroundVolStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SurroundVol);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSurroundVolStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SurroundVol);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool mascf_mainfi_tclMsgSurroundVolStatus::operator==(const mascf_mainfi_tclMsgSurroundVolStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SurroundVol == roRef.SurroundVol);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAudioPilotModeUpReg::mascf_mainfi_tclMsgAudioPilotModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODEUPREG;
}


mascf_mainfi_tclMsgAudioPilotModeUpReg::~mascf_mainfi_tclMsgAudioPilotModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioPilotModeRelUpReg::mascf_mainfi_tclMsgAudioPilotModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODERELUPREG;
}


mascf_mainfi_tclMsgAudioPilotModeRelUpReg::~mascf_mainfi_tclMsgAudioPilotModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioPilotModeGet::mascf_mainfi_tclMsgAudioPilotModeGet()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODEGET;
}


mascf_mainfi_tclMsgAudioPilotModeGet::~mascf_mainfi_tclMsgAudioPilotModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioPilotModeSet::mascf_mainfi_tclMsgAudioPilotModeSet(const mascf_mainfi_tclMsgAudioPilotModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AudPilotMode = coRef.AudPilotMode;
}
mascf_mainfi_tclMsgAudioPilotModeSet& mascf_mainfi_tclMsgAudioPilotModeSet::operator=(const mascf_mainfi_tclMsgAudioPilotModeSet& coRef)
{
   if (this == &coRef) return *this;
   AudPilotMode = coRef.AudPilotMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioPilotModeSet::mascf_mainfi_tclMsgAudioPilotModeSet()
:AudPilotMode(0)
 {}

tS32 mascf_mainfi_tclMsgAudioPilotModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODESET;
}


mascf_mainfi_tclMsgAudioPilotModeSet::~mascf_mainfi_tclMsgAudioPilotModeSet()
{}

tU32 mascf_mainfi_tclMsgAudioPilotModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioPilotModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudPilotMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioPilotModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudPilotMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioPilotModeSet::operator==(const mascf_mainfi_tclMsgAudioPilotModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudPilotMode == roRef.AudPilotMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioPilotModeStatus::mascf_mainfi_tclMsgAudioPilotModeStatus(const mascf_mainfi_tclMsgAudioPilotModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AudPilotMode = coRef.AudPilotMode;
}
mascf_mainfi_tclMsgAudioPilotModeStatus& mascf_mainfi_tclMsgAudioPilotModeStatus::operator=(const mascf_mainfi_tclMsgAudioPilotModeStatus& coRef)
{
   if (this == &coRef) return *this;
   AudPilotMode = coRef.AudPilotMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioPilotModeStatus::mascf_mainfi_tclMsgAudioPilotModeStatus()
:AudPilotMode(0)
 {}

tS32 mascf_mainfi_tclMsgAudioPilotModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTMODESTATUS;
}


mascf_mainfi_tclMsgAudioPilotModeStatus::~mascf_mainfi_tclMsgAudioPilotModeStatus()
{}

tU32 mascf_mainfi_tclMsgAudioPilotModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioPilotModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudPilotMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioPilotModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudPilotMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioPilotModeStatus::operator==(const mascf_mainfi_tclMsgAudioPilotModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudPilotMode == roRef.AudPilotMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgSurroundModeUpReg::mascf_mainfi_tclMsgSurroundModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgSurroundModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDMODEUPREG;
}


mascf_mainfi_tclMsgSurroundModeUpReg::~mascf_mainfi_tclMsgSurroundModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSurroundModeRelUpReg::mascf_mainfi_tclMsgSurroundModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgSurroundModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDMODERELUPREG;
}


mascf_mainfi_tclMsgSurroundModeRelUpReg::~mascf_mainfi_tclMsgSurroundModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSurroundModeGet::mascf_mainfi_tclMsgSurroundModeGet()
 {}

tS32 mascf_mainfi_tclMsgSurroundModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDMODEGET;
}


mascf_mainfi_tclMsgSurroundModeGet::~mascf_mainfi_tclMsgSurroundModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSurroundModeSet::mascf_mainfi_tclMsgSurroundModeSet(const mascf_mainfi_tclMsgSurroundModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SurroundMode = coRef.SurroundMode;
}
mascf_mainfi_tclMsgSurroundModeSet& mascf_mainfi_tclMsgSurroundModeSet::operator=(const mascf_mainfi_tclMsgSurroundModeSet& coRef)
{
   if (this == &coRef) return *this;
   SurroundMode = coRef.SurroundMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSurroundModeSet::mascf_mainfi_tclMsgSurroundModeSet()
:SurroundMode(0)
 {}

tS32 mascf_mainfi_tclMsgSurroundModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDMODESET;
}


mascf_mainfi_tclMsgSurroundModeSet::~mascf_mainfi_tclMsgSurroundModeSet()
{}

tU32 mascf_mainfi_tclMsgSurroundModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSurroundModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SurroundMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSurroundModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SurroundMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgSurroundModeSet::operator==(const mascf_mainfi_tclMsgSurroundModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SurroundMode == roRef.SurroundMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSurroundModeStatus::mascf_mainfi_tclMsgSurroundModeStatus(const mascf_mainfi_tclMsgSurroundModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SurroundMode = coRef.SurroundMode;
}
mascf_mainfi_tclMsgSurroundModeStatus& mascf_mainfi_tclMsgSurroundModeStatus::operator=(const mascf_mainfi_tclMsgSurroundModeStatus& coRef)
{
   if (this == &coRef) return *this;
   SurroundMode = coRef.SurroundMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSurroundModeStatus::mascf_mainfi_tclMsgSurroundModeStatus()
:SurroundMode(0)
 {}

tS32 mascf_mainfi_tclMsgSurroundModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDMODESTATUS;
}


mascf_mainfi_tclMsgSurroundModeStatus::~mascf_mainfi_tclMsgSurroundModeStatus()
{}

tU32 mascf_mainfi_tclMsgSurroundModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSurroundModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SurroundMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSurroundModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SurroundMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgSurroundModeStatus::operator==(const mascf_mainfi_tclMsgSurroundModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SurroundMode == roRef.SurroundMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAmpDownMixModeUpReg::mascf_mainfi_tclMsgAmpDownMixModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpDownMixModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODEUPREG;
}


mascf_mainfi_tclMsgAmpDownMixModeUpReg::~mascf_mainfi_tclMsgAmpDownMixModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpDownMixModeRelUpReg::mascf_mainfi_tclMsgAmpDownMixModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpDownMixModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODERELUPREG;
}


mascf_mainfi_tclMsgAmpDownMixModeRelUpReg::~mascf_mainfi_tclMsgAmpDownMixModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpDownMixModeGet::mascf_mainfi_tclMsgAmpDownMixModeGet()
 {}

tS32 mascf_mainfi_tclMsgAmpDownMixModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODEGET;
}


mascf_mainfi_tclMsgAmpDownMixModeGet::~mascf_mainfi_tclMsgAmpDownMixModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpDownMixModeSet::mascf_mainfi_tclMsgAmpDownMixModeSet(const mascf_mainfi_tclMsgAmpDownMixModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AmpDownMixMode = coRef.AmpDownMixMode;
}
mascf_mainfi_tclMsgAmpDownMixModeSet& mascf_mainfi_tclMsgAmpDownMixModeSet::operator=(const mascf_mainfi_tclMsgAmpDownMixModeSet& coRef)
{
   if (this == &coRef) return *this;
   AmpDownMixMode = coRef.AmpDownMixMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpDownMixModeSet::mascf_mainfi_tclMsgAmpDownMixModeSet()
:AmpDownMixMode(0)
 {}

tS32 mascf_mainfi_tclMsgAmpDownMixModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODESET;
}


mascf_mainfi_tclMsgAmpDownMixModeSet::~mascf_mainfi_tclMsgAmpDownMixModeSet()
{}

tU32 mascf_mainfi_tclMsgAmpDownMixModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpDownMixModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmpDownMixMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpDownMixModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmpDownMixMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpDownMixModeSet::operator==(const mascf_mainfi_tclMsgAmpDownMixModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmpDownMixMode == roRef.AmpDownMixMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpDownMixModeStatus::mascf_mainfi_tclMsgAmpDownMixModeStatus(const mascf_mainfi_tclMsgAmpDownMixModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AmpDownMixMode = coRef.AmpDownMixMode;
}
mascf_mainfi_tclMsgAmpDownMixModeStatus& mascf_mainfi_tclMsgAmpDownMixModeStatus::operator=(const mascf_mainfi_tclMsgAmpDownMixModeStatus& coRef)
{
   if (this == &coRef) return *this;
   AmpDownMixMode = coRef.AmpDownMixMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpDownMixModeStatus::mascf_mainfi_tclMsgAmpDownMixModeStatus()
:AmpDownMixMode(0)
 {}

tS32 mascf_mainfi_tclMsgAmpDownMixModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPDOWNMIXMODESTATUS;
}


mascf_mainfi_tclMsgAmpDownMixModeStatus::~mascf_mainfi_tclMsgAmpDownMixModeStatus()
{}

tU32 mascf_mainfi_tclMsgAmpDownMixModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpDownMixModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmpDownMixMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpDownMixModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmpDownMixMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpDownMixModeStatus::operator==(const mascf_mainfi_tclMsgAmpDownMixModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmpDownMixMode == roRef.AmpDownMixMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgDriverSoundModeUpReg::mascf_mainfi_tclMsgDriverSoundModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgDriverSoundModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODEUPREG;
}


mascf_mainfi_tclMsgDriverSoundModeUpReg::~mascf_mainfi_tclMsgDriverSoundModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDriverSoundModeRelUpReg::mascf_mainfi_tclMsgDriverSoundModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgDriverSoundModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODERELUPREG;
}


mascf_mainfi_tclMsgDriverSoundModeRelUpReg::~mascf_mainfi_tclMsgDriverSoundModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDriverSoundModeGet::mascf_mainfi_tclMsgDriverSoundModeGet()
 {}

tS32 mascf_mainfi_tclMsgDriverSoundModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODEGET;
}


mascf_mainfi_tclMsgDriverSoundModeGet::~mascf_mainfi_tclMsgDriverSoundModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDriverSoundModeSet::mascf_mainfi_tclMsgDriverSoundModeSet(const mascf_mainfi_tclMsgDriverSoundModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DriverMode = coRef.DriverMode;
}
mascf_mainfi_tclMsgDriverSoundModeSet& mascf_mainfi_tclMsgDriverSoundModeSet::operator=(const mascf_mainfi_tclMsgDriverSoundModeSet& coRef)
{
   if (this == &coRef) return *this;
   DriverMode = coRef.DriverMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDriverSoundModeSet::mascf_mainfi_tclMsgDriverSoundModeSet()
:DriverMode(0)
 {}

tS32 mascf_mainfi_tclMsgDriverSoundModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODESET;
}


mascf_mainfi_tclMsgDriverSoundModeSet::~mascf_mainfi_tclMsgDriverSoundModeSet()
{}

tU32 mascf_mainfi_tclMsgDriverSoundModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgDriverSoundModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDriverSoundModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgDriverSoundModeSet::operator==(const mascf_mainfi_tclMsgDriverSoundModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverMode == roRef.DriverMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDriverSoundModeStatus::mascf_mainfi_tclMsgDriverSoundModeStatus(const mascf_mainfi_tclMsgDriverSoundModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DriverMode = coRef.DriverMode;
}
mascf_mainfi_tclMsgDriverSoundModeStatus& mascf_mainfi_tclMsgDriverSoundModeStatus::operator=(const mascf_mainfi_tclMsgDriverSoundModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DriverMode = coRef.DriverMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDriverSoundModeStatus::mascf_mainfi_tclMsgDriverSoundModeStatus()
:DriverMode(0)
 {}

tS32 mascf_mainfi_tclMsgDriverSoundModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DRIVERSOUNDMODESTATUS;
}


mascf_mainfi_tclMsgDriverSoundModeStatus::~mascf_mainfi_tclMsgDriverSoundModeStatus()
{}

tU32 mascf_mainfi_tclMsgDriverSoundModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgDriverSoundModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDriverSoundModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgDriverSoundModeStatus::operator==(const mascf_mainfi_tclMsgDriverSoundModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverMode == roRef.DriverMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRearSoundModeUpReg::mascf_mainfi_tclMsgRearSoundModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgRearSoundModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODEUPREG;
}


mascf_mainfi_tclMsgRearSoundModeUpReg::~mascf_mainfi_tclMsgRearSoundModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRearSoundModeRelUpReg::mascf_mainfi_tclMsgRearSoundModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRearSoundModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODERELUPREG;
}


mascf_mainfi_tclMsgRearSoundModeRelUpReg::~mascf_mainfi_tclMsgRearSoundModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRearSoundModeGet::mascf_mainfi_tclMsgRearSoundModeGet()
 {}

tS32 mascf_mainfi_tclMsgRearSoundModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODEGET;
}


mascf_mainfi_tclMsgRearSoundModeGet::~mascf_mainfi_tclMsgRearSoundModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRearSoundModeSet::mascf_mainfi_tclMsgRearSoundModeSet(const mascf_mainfi_tclMsgRearSoundModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RearMode = coRef.RearMode;
}
mascf_mainfi_tclMsgRearSoundModeSet& mascf_mainfi_tclMsgRearSoundModeSet::operator=(const mascf_mainfi_tclMsgRearSoundModeSet& coRef)
{
   if (this == &coRef) return *this;
   RearMode = coRef.RearMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRearSoundModeSet::mascf_mainfi_tclMsgRearSoundModeSet()
:RearMode(0)
 {}

tS32 mascf_mainfi_tclMsgRearSoundModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODESET;
}


mascf_mainfi_tclMsgRearSoundModeSet::~mascf_mainfi_tclMsgRearSoundModeSet()
{}

tU32 mascf_mainfi_tclMsgRearSoundModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRearSoundModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RearMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRearSoundModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RearMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgRearSoundModeSet::operator==(const mascf_mainfi_tclMsgRearSoundModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RearMode == roRef.RearMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRearSoundModeStatus::mascf_mainfi_tclMsgRearSoundModeStatus(const mascf_mainfi_tclMsgRearSoundModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RearMode = coRef.RearMode;
}
mascf_mainfi_tclMsgRearSoundModeStatus& mascf_mainfi_tclMsgRearSoundModeStatus::operator=(const mascf_mainfi_tclMsgRearSoundModeStatus& coRef)
{
   if (this == &coRef) return *this;
   RearMode = coRef.RearMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRearSoundModeStatus::mascf_mainfi_tclMsgRearSoundModeStatus()
:RearMode(0)
 {}

tS32 mascf_mainfi_tclMsgRearSoundModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_REARSOUNDMODESTATUS;
}


mascf_mainfi_tclMsgRearSoundModeStatus::~mascf_mainfi_tclMsgRearSoundModeStatus()
{}

tU32 mascf_mainfi_tclMsgRearSoundModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRearSoundModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RearMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRearSoundModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RearMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgRearSoundModeStatus::operator==(const mascf_mainfi_tclMsgRearSoundModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RearMode == roRef.RearMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAudioOFFMuteStateUpReg::mascf_mainfi_tclMsgAudioOFFMuteStateUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioOFFMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATEUPREG;
}


mascf_mainfi_tclMsgAudioOFFMuteStateUpReg::~mascf_mainfi_tclMsgAudioOFFMuteStateUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg::mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATERELUPREG;
}


mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg::~mascf_mainfi_tclMsgAudioOFFMuteStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioOFFMuteStateSet::mascf_mainfi_tclMsgAudioOFFMuteStateSet(const mascf_mainfi_tclMsgAudioOFFMuteStateSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   MuteState = coRef.MuteState;
}
mascf_mainfi_tclMsgAudioOFFMuteStateSet& mascf_mainfi_tclMsgAudioOFFMuteStateSet::operator=(const mascf_mainfi_tclMsgAudioOFFMuteStateSet& coRef)
{
   if (this == &coRef) return *this;
   MuteState = coRef.MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioOFFMuteStateSet::mascf_mainfi_tclMsgAudioOFFMuteStateSet()
:MuteState(0)
 {}

tS32 mascf_mainfi_tclMsgAudioOFFMuteStateSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATESET;
}


mascf_mainfi_tclMsgAudioOFFMuteStateSet::~mascf_mainfi_tclMsgAudioOFFMuteStateSet()
{}

tU32 mascf_mainfi_tclMsgAudioOFFMuteStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioOFFMuteStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MuteState);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioOFFMuteStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MuteState);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioOFFMuteStateSet::operator==(const mascf_mainfi_tclMsgAudioOFFMuteStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MuteState == roRef.MuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioOFFMuteStateStatus::mascf_mainfi_tclMsgAudioOFFMuteStateStatus(const mascf_mainfi_tclMsgAudioOFFMuteStateStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   MuteState = coRef.MuteState;
}
mascf_mainfi_tclMsgAudioOFFMuteStateStatus& mascf_mainfi_tclMsgAudioOFFMuteStateStatus::operator=(const mascf_mainfi_tclMsgAudioOFFMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MuteState = coRef.MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioOFFMuteStateStatus::mascf_mainfi_tclMsgAudioOFFMuteStateStatus()
:MuteState(0)
 {}

tS32 mascf_mainfi_tclMsgAudioOFFMuteStateStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOOFFMUTESTATESTATUS;
}


mascf_mainfi_tclMsgAudioOFFMuteStateStatus::~mascf_mainfi_tclMsgAudioOFFMuteStateStatus()
{}

tU32 mascf_mainfi_tclMsgAudioOFFMuteStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioOFFMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MuteState);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioOFFMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MuteState);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioOFFMuteStateStatus::operator==(const mascf_mainfi_tclMsgAudioOFFMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MuteState == roRef.MuteState);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg::mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSUPREG;
}


mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg::~mascf_mainfi_tclMsgMicrophoneConnectionStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg::mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSRELUPREG;
}


mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg::~mascf_mainfi_tclMsgMicrophoneConnectionStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgMicrophoneConnectionStatusGet::mascf_mainfi_tclMsgMicrophoneConnectionStatusGet()
 {}

tS32 mascf_mainfi_tclMsgMicrophoneConnectionStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSGET;
}


mascf_mainfi_tclMsgMicrophoneConnectionStatusGet::~mascf_mainfi_tclMsgMicrophoneConnectionStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus(const mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
}
mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::operator=(const mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::vDestroy()
{
   MicrophoneConnectionStatusList.vDestroy(); 
}

mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus()
:MicrophoneConnectionStatusList()
 {}

tS32 mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSSTATUS;
}


mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::~mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MicrophoneConnectionStatusList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MicrophoneConnectionStatusList);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MicrophoneConnectionStatusList);
   return oOut;
}

tBool mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus::operator==(const mascf_mainfi_tclMsgMicrophoneConnectionStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MicrophoneConnectionStatusList == roRef.MicrophoneConnectionStatusList);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgConnectionUpReg::mascf_mainfi_tclMsgConnectionUpReg()
 {}

tS32 mascf_mainfi_tclMsgConnectionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CONNECTIONUPREG;
}


mascf_mainfi_tclMsgConnectionUpReg::~mascf_mainfi_tclMsgConnectionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgConnectionRelUpReg::mascf_mainfi_tclMsgConnectionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CONNECTIONRELUPREG;
}


mascf_mainfi_tclMsgConnectionRelUpReg::~mascf_mainfi_tclMsgConnectionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgConnectionGet::mascf_mainfi_tclMsgConnectionGet()
 {}

tS32 mascf_mainfi_tclMsgConnectionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CONNECTIONGET;
}


mascf_mainfi_tclMsgConnectionGet::~mascf_mainfi_tclMsgConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgConnectionStatus::mascf_mainfi_tclMsgConnectionStatus(const mascf_mainfi_tclMsgConnectionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   arConnectionStatusList = coRef.arConnectionStatusList;
}
mascf_mainfi_tclMsgConnectionStatus& mascf_mainfi_tclMsgConnectionStatus::operator=(const mascf_mainfi_tclMsgConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   arConnectionStatusList = coRef.arConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgConnectionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
         arConnectionStatusList[u32Idx].vDestroy();
   arConnectionStatusList.clear();
   }
}

mascf_mainfi_tclMsgConnectionStatus::mascf_mainfi_tclMsgConnectionStatus()

 {}

tS32 mascf_mainfi_tclMsgConnectionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_CONNECTIONSTATUS;
}


mascf_mainfi_tclMsgConnectionStatus::~mascf_mainfi_tclMsgConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arConnectionStatusList.size()*4);
}

fi_tclInContext& mascf_mainfi_tclMsgConnectionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
      {
         arConnectionStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arConnectionStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arConnectionStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arConnectionStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
         (tVoid) (oOut << arConnectionStatusList[u32Idx]);
   }
   return oOut;
}

tBool mascf_mainfi_tclMsgConnectionStatus::operator==(const mascf_mainfi_tclMsgConnectionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arConnectionStatusList.size() == roRef.arConnectionStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arConnectionStatusList.size()); ++u32Idx)
            bResult = bResult && (arConnectionStatusList[u32Idx] == roRef.arConnectionStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgVolumeListUpReg::mascf_mainfi_tclMsgVolumeListUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeListUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELISTUPREG;
}


mascf_mainfi_tclMsgVolumeListUpReg::~mascf_mainfi_tclMsgVolumeListUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeListRelUpReg::mascf_mainfi_tclMsgVolumeListRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeListRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELISTRELUPREG;
}


mascf_mainfi_tclMsgVolumeListRelUpReg::~mascf_mainfi_tclMsgVolumeListRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeListGet::mascf_mainfi_tclMsgVolumeListGet()
 {}

tS32 mascf_mainfi_tclMsgVolumeListGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELISTGET;
}


mascf_mainfi_tclMsgVolumeListGet::~mascf_mainfi_tclMsgVolumeListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeListSet::mascf_mainfi_tclMsgVolumeListSet(const mascf_mainfi_tclMsgVolumeListSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AudVolumeList = coRef.AudVolumeList;
}
mascf_mainfi_tclMsgVolumeListSet& mascf_mainfi_tclMsgVolumeListSet::operator=(const mascf_mainfi_tclMsgVolumeListSet& coRef)
{
   if (this == &coRef) return *this;
   AudVolumeList = coRef.AudVolumeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgVolumeListSet::vDestroy()
{
   AudVolumeList.vDestroy(); 
}

mascf_mainfi_tclMsgVolumeListSet::mascf_mainfi_tclMsgVolumeListSet()
:AudVolumeList()
 {}

tS32 mascf_mainfi_tclMsgVolumeListSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELISTSET;
}


mascf_mainfi_tclMsgVolumeListSet::~mascf_mainfi_tclMsgVolumeListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgVolumeListSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AudVolumeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudVolumeList);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudVolumeList);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeListSet::operator==(const mascf_mainfi_tclMsgVolumeListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudVolumeList == roRef.AudVolumeList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeListStatus::mascf_mainfi_tclMsgVolumeListStatus(const mascf_mainfi_tclMsgVolumeListStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AudVolumeList = coRef.AudVolumeList;
}
mascf_mainfi_tclMsgVolumeListStatus& mascf_mainfi_tclMsgVolumeListStatus::operator=(const mascf_mainfi_tclMsgVolumeListStatus& coRef)
{
   if (this == &coRef) return *this;
   AudVolumeList = coRef.AudVolumeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgVolumeListStatus::vDestroy()
{
   AudVolumeList.vDestroy(); 
}

mascf_mainfi_tclMsgVolumeListStatus::mascf_mainfi_tclMsgVolumeListStatus()
:AudVolumeList()
 {}

tS32 mascf_mainfi_tclMsgVolumeListStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELISTSTATUS;
}


mascf_mainfi_tclMsgVolumeListStatus::~mascf_mainfi_tclMsgVolumeListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgVolumeListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AudVolumeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudVolumeList);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudVolumeList);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeListStatus::operator==(const mascf_mainfi_tclMsgVolumeListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudVolumeList == roRef.AudVolumeList);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgBTAudioInLevelUpReg::mascf_mainfi_tclMsgBTAudioInLevelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBTAudioInLevelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELUPREG;
}


mascf_mainfi_tclMsgBTAudioInLevelUpReg::~mascf_mainfi_tclMsgBTAudioInLevelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBTAudioInLevelRelUpReg::mascf_mainfi_tclMsgBTAudioInLevelRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgBTAudioInLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELRELUPREG;
}


mascf_mainfi_tclMsgBTAudioInLevelRelUpReg::~mascf_mainfi_tclMsgBTAudioInLevelRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgBTAudioInLevelGet::mascf_mainfi_tclMsgBTAudioInLevelGet()
 {}

tS32 mascf_mainfi_tclMsgBTAudioInLevelGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELGET;
}


mascf_mainfi_tclMsgBTAudioInLevelGet::~mascf_mainfi_tclMsgBTAudioInLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBTAudioInLevelSet::mascf_mainfi_tclMsgBTAudioInLevelSet(const mascf_mainfi_tclMsgBTAudioInLevelSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   BTAudioInLevel = coRef.BTAudioInLevel;
}
mascf_mainfi_tclMsgBTAudioInLevelSet& mascf_mainfi_tclMsgBTAudioInLevelSet::operator=(const mascf_mainfi_tclMsgBTAudioInLevelSet& coRef)
{
   if (this == &coRef) return *this;
   BTAudioInLevel = coRef.BTAudioInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBTAudioInLevelSet::mascf_mainfi_tclMsgBTAudioInLevelSet()
:BTAudioInLevel()
 {}

tS32 mascf_mainfi_tclMsgBTAudioInLevelSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELSET;
}


mascf_mainfi_tclMsgBTAudioInLevelSet::~mascf_mainfi_tclMsgBTAudioInLevelSet()
{}

tU32 mascf_mainfi_tclMsgBTAudioInLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgBTAudioInLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAudioInLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBTAudioInLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAudioInLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgBTAudioInLevelSet::operator==(const mascf_mainfi_tclMsgBTAudioInLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAudioInLevel == roRef.BTAudioInLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgBTAudioInLevelStatus::mascf_mainfi_tclMsgBTAudioInLevelStatus(const mascf_mainfi_tclMsgBTAudioInLevelStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   BTAudioInLevel = coRef.BTAudioInLevel;
}
mascf_mainfi_tclMsgBTAudioInLevelStatus& mascf_mainfi_tclMsgBTAudioInLevelStatus::operator=(const mascf_mainfi_tclMsgBTAudioInLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BTAudioInLevel = coRef.BTAudioInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgBTAudioInLevelStatus::mascf_mainfi_tclMsgBTAudioInLevelStatus()
:BTAudioInLevel()
 {}

tS32 mascf_mainfi_tclMsgBTAudioInLevelStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_BTAUDIOINLEVELSTATUS;
}


mascf_mainfi_tclMsgBTAudioInLevelStatus::~mascf_mainfi_tclMsgBTAudioInLevelStatus()
{}

tU32 mascf_mainfi_tclMsgBTAudioInLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgBTAudioInLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAudioInLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgBTAudioInLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAudioInLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgBTAudioInLevelStatus::operator==(const mascf_mainfi_tclMsgBTAudioInLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAudioInLevel == roRef.BTAudioInLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgEngineeringDataUpReg::mascf_mainfi_tclMsgEngineeringDataUpReg()
 {}

tS32 mascf_mainfi_tclMsgEngineeringDataUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATAUPREG;
}


mascf_mainfi_tclMsgEngineeringDataUpReg::~mascf_mainfi_tclMsgEngineeringDataUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgEngineeringDataRelUpReg::mascf_mainfi_tclMsgEngineeringDataRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgEngineeringDataRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATARELUPREG;
}


mascf_mainfi_tclMsgEngineeringDataRelUpReg::~mascf_mainfi_tclMsgEngineeringDataRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgEngineeringDataGet::mascf_mainfi_tclMsgEngineeringDataGet()
 {}

tS32 mascf_mainfi_tclMsgEngineeringDataGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATAGET;
}


mascf_mainfi_tclMsgEngineeringDataGet::~mascf_mainfi_tclMsgEngineeringDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEngineeringDataSet::mascf_mainfi_tclMsgEngineeringDataSet(const mascf_mainfi_tclMsgEngineeringDataSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   EngineeringDataList = coRef.EngineeringDataList;
}
mascf_mainfi_tclMsgEngineeringDataSet& mascf_mainfi_tclMsgEngineeringDataSet::operator=(const mascf_mainfi_tclMsgEngineeringDataSet& coRef)
{
   if (this == &coRef) return *this;
   EngineeringDataList = coRef.EngineeringDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgEngineeringDataSet::vDestroy()
{
   EngineeringDataList.vDestroy(); 
}

mascf_mainfi_tclMsgEngineeringDataSet::mascf_mainfi_tclMsgEngineeringDataSet()
:EngineeringDataList()
 {}

tS32 mascf_mainfi_tclMsgEngineeringDataSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATASET;
}


mascf_mainfi_tclMsgEngineeringDataSet::~mascf_mainfi_tclMsgEngineeringDataSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgEngineeringDataSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EngineeringDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgEngineeringDataSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EngineeringDataList);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEngineeringDataSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EngineeringDataList);
   return oOut;
}

tBool mascf_mainfi_tclMsgEngineeringDataSet::operator==(const mascf_mainfi_tclMsgEngineeringDataSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EngineeringDataList == roRef.EngineeringDataList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEngineeringDataStatus::mascf_mainfi_tclMsgEngineeringDataStatus(const mascf_mainfi_tclMsgEngineeringDataStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   EngineeringDataList = coRef.EngineeringDataList;
}
mascf_mainfi_tclMsgEngineeringDataStatus& mascf_mainfi_tclMsgEngineeringDataStatus::operator=(const mascf_mainfi_tclMsgEngineeringDataStatus& coRef)
{
   if (this == &coRef) return *this;
   EngineeringDataList = coRef.EngineeringDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgEngineeringDataStatus::vDestroy()
{
   EngineeringDataList.vDestroy(); 
}

mascf_mainfi_tclMsgEngineeringDataStatus::mascf_mainfi_tclMsgEngineeringDataStatus()
:EngineeringDataList()
 {}

tS32 mascf_mainfi_tclMsgEngineeringDataStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENGINEERINGDATASTATUS;
}


mascf_mainfi_tclMsgEngineeringDataStatus::~mascf_mainfi_tclMsgEngineeringDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgEngineeringDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EngineeringDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgEngineeringDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EngineeringDataList);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEngineeringDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EngineeringDataList);
   return oOut;
}

tBool mascf_mainfi_tclMsgEngineeringDataStatus::operator==(const mascf_mainfi_tclMsgEngineeringDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EngineeringDataList == roRef.EngineeringDataList);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgSurroundSettingUpReg::mascf_mainfi_tclMsgSurroundSettingUpReg()
 {}

tS32 mascf_mainfi_tclMsgSurroundSettingUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGUPREG;
}


mascf_mainfi_tclMsgSurroundSettingUpReg::~mascf_mainfi_tclMsgSurroundSettingUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSurroundSettingRelUpReg::mascf_mainfi_tclMsgSurroundSettingRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgSurroundSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGRELUPREG;
}


mascf_mainfi_tclMsgSurroundSettingRelUpReg::~mascf_mainfi_tclMsgSurroundSettingRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSurroundSettingGet::mascf_mainfi_tclMsgSurroundSettingGet()
 {}

tS32 mascf_mainfi_tclMsgSurroundSettingGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGGET;
}


mascf_mainfi_tclMsgSurroundSettingGet::~mascf_mainfi_tclMsgSurroundSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSurroundSettingSet::mascf_mainfi_tclMsgSurroundSettingSet(const mascf_mainfi_tclMsgSurroundSettingSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Surround = coRef.Surround;
}
mascf_mainfi_tclMsgSurroundSettingSet& mascf_mainfi_tclMsgSurroundSettingSet::operator=(const mascf_mainfi_tclMsgSurroundSettingSet& coRef)
{
   if (this == &coRef) return *this;
   Surround = coRef.Surround;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSurroundSettingSet::mascf_mainfi_tclMsgSurroundSettingSet()
:Surround()
 {}

tS32 mascf_mainfi_tclMsgSurroundSettingSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGSET;
}


mascf_mainfi_tclMsgSurroundSettingSet::~mascf_mainfi_tclMsgSurroundSettingSet()
{}

tU32 mascf_mainfi_tclMsgSurroundSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSurroundSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Surround);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSurroundSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Surround);
   return oOut;
}

tBool mascf_mainfi_tclMsgSurroundSettingSet::operator==(const mascf_mainfi_tclMsgSurroundSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Surround == roRef.Surround);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSurroundSettingStatus::mascf_mainfi_tclMsgSurroundSettingStatus(const mascf_mainfi_tclMsgSurroundSettingStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Surround = coRef.Surround;
}
mascf_mainfi_tclMsgSurroundSettingStatus& mascf_mainfi_tclMsgSurroundSettingStatus::operator=(const mascf_mainfi_tclMsgSurroundSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   Surround = coRef.Surround;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSurroundSettingStatus::mascf_mainfi_tclMsgSurroundSettingStatus()
:Surround()
 {}

tS32 mascf_mainfi_tclMsgSurroundSettingStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SURROUNDSETTINGSTATUS;
}


mascf_mainfi_tclMsgSurroundSettingStatus::~mascf_mainfi_tclMsgSurroundSettingStatus()
{}

tU32 mascf_mainfi_tclMsgSurroundSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSurroundSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Surround);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSurroundSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Surround);
   return oOut;
}

tBool mascf_mainfi_tclMsgSurroundSettingStatus::operator==(const mascf_mainfi_tclMsgSurroundSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Surround == roRef.Surround);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgVolumeLockUpReg::mascf_mainfi_tclMsgVolumeLockUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeLockUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKUPREG;
}


mascf_mainfi_tclMsgVolumeLockUpReg::~mascf_mainfi_tclMsgVolumeLockUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeLockRelUpReg::mascf_mainfi_tclMsgVolumeLockRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgVolumeLockRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKRELUPREG;
}


mascf_mainfi_tclMsgVolumeLockRelUpReg::~mascf_mainfi_tclMsgVolumeLockRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgVolumeLockGet::mascf_mainfi_tclMsgVolumeLockGet()
 {}

tS32 mascf_mainfi_tclMsgVolumeLockGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKGET;
}


mascf_mainfi_tclMsgVolumeLockGet::~mascf_mainfi_tclMsgVolumeLockGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeLockSet::mascf_mainfi_tclMsgVolumeLockSet(const mascf_mainfi_tclMsgVolumeLockSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
}
mascf_mainfi_tclMsgVolumeLockSet& mascf_mainfi_tclMsgVolumeLockSet::operator=(const mascf_mainfi_tclMsgVolumeLockSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeLockSet::mascf_mainfi_tclMsgVolumeLockSet()
:VolumeLockType()
,Requester()
 {}

tS32 mascf_mainfi_tclMsgVolumeLockSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKSET;
}


mascf_mainfi_tclMsgVolumeLockSet::~mascf_mainfi_tclMsgVolumeLockSet()
{}

tU32 mascf_mainfi_tclMsgVolumeLockSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeLockSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLockType);
   (tVoid) (oIn >> Requester);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeLockSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLockType);
   (tVoid) (oOut << Requester);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeLockSet::operator==(const mascf_mainfi_tclMsgVolumeLockSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLockType == roRef.VolumeLockType);
   bResult = bResult && (Requester == roRef.Requester);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgVolumeLockStatus::mascf_mainfi_tclMsgVolumeLockStatus(const mascf_mainfi_tclMsgVolumeLockStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
}
mascf_mainfi_tclMsgVolumeLockStatus& mascf_mainfi_tclMsgVolumeLockStatus::operator=(const mascf_mainfi_tclMsgVolumeLockStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgVolumeLockStatus::mascf_mainfi_tclMsgVolumeLockStatus()
:VolumeLockType()
,Requester()
 {}

tS32 mascf_mainfi_tclMsgVolumeLockStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_VOLUMELOCKSTATUS;
}


mascf_mainfi_tclMsgVolumeLockStatus::~mascf_mainfi_tclMsgVolumeLockStatus()
{}

tU32 mascf_mainfi_tclMsgVolumeLockStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgVolumeLockStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLockType);
   (tVoid) (oIn >> Requester);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgVolumeLockStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLockType);
   (tVoid) (oOut << Requester);
   return oOut;
}

tBool mascf_mainfi_tclMsgVolumeLockStatus::operator==(const mascf_mainfi_tclMsgVolumeLockStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLockType == roRef.VolumeLockType);
   bResult = bResult && (Requester == roRef.Requester);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAmpAvailFunctionUpReg::mascf_mainfi_tclMsgAmpAvailFunctionUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpAvailFunctionUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONUPREG;
}


mascf_mainfi_tclMsgAmpAvailFunctionUpReg::~mascf_mainfi_tclMsgAmpAvailFunctionUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg::mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONRELUPREG;
}


mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg::~mascf_mainfi_tclMsgAmpAvailFunctionRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAmpAvailFunctionGet::mascf_mainfi_tclMsgAmpAvailFunctionGet()
 {}

tS32 mascf_mainfi_tclMsgAmpAvailFunctionGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONGET;
}


mascf_mainfi_tclMsgAmpAvailFunctionGet::~mascf_mainfi_tclMsgAmpAvailFunctionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAmpAvailFunctionStatus::mascf_mainfi_tclMsgAmpAvailFunctionStatus(const mascf_mainfi_tclMsgAmpAvailFunctionStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Bass = coRef.Bass;
   Middle = coRef.Middle;
   Treble = coRef.Treble;
   Balance = coRef.Balance;
   Fader = coRef.Fader;
   AudioPilot = coRef.AudioPilot;
   Gala = coRef.Gala;
   SurroundMode = coRef.SurroundMode;
   SubWoofer = coRef.SubWoofer;
   Staging = coRef.Staging;
   RoomEffect = coRef.RoomEffect;
   Loudness = coRef.Loudness;
   AGC = coRef.AGC;
   AmpDownMix = coRef.AmpDownMix;
   SurroundVol = coRef.SurroundVol;
   RearSoundMode = coRef.RearSoundMode;
   DriverSoundMode = coRef.DriverSoundMode;
   ANC = coRef.ANC;
   ASC = coRef.ASC;
   SoundAmbiance = coRef.SoundAmbiance;
   ESE = coRef.ESE;
}
mascf_mainfi_tclMsgAmpAvailFunctionStatus& mascf_mainfi_tclMsgAmpAvailFunctionStatus::operator=(const mascf_mainfi_tclMsgAmpAvailFunctionStatus& coRef)
{
   if (this == &coRef) return *this;
   Bass = coRef.Bass;
   Middle = coRef.Middle;
   Treble = coRef.Treble;
   Balance = coRef.Balance;
   Fader = coRef.Fader;
   AudioPilot = coRef.AudioPilot;
   Gala = coRef.Gala;
   SurroundMode = coRef.SurroundMode;
   SubWoofer = coRef.SubWoofer;
   Staging = coRef.Staging;
   RoomEffect = coRef.RoomEffect;
   Loudness = coRef.Loudness;
   AGC = coRef.AGC;
   AmpDownMix = coRef.AmpDownMix;
   SurroundVol = coRef.SurroundVol;
   RearSoundMode = coRef.RearSoundMode;
   DriverSoundMode = coRef.DriverSoundMode;
   ANC = coRef.ANC;
   ASC = coRef.ASC;
   SoundAmbiance = coRef.SoundAmbiance;
   ESE = coRef.ESE;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAmpAvailFunctionStatus::mascf_mainfi_tclMsgAmpAvailFunctionStatus()
:Bass(0)
,Middle(0)
,Treble(0)
,Balance(0)
,Fader(0)
,AudioPilot(0)
,Gala(0)
,SurroundMode(0)
,SubWoofer(0)
,Staging(0)
,RoomEffect(0)
,Loudness(0)
,AGC(0)
,AmpDownMix(0)
,SurroundVol(0)
,RearSoundMode(0)
,DriverSoundMode(0)
,ANC(0)
,ASC(0)
,SoundAmbiance(0)
,ESE(0)
 {}

tS32 mascf_mainfi_tclMsgAmpAvailFunctionStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AMPAVAILFUNCTIONSTATUS;
}


mascf_mainfi_tclMsgAmpAvailFunctionStatus::~mascf_mainfi_tclMsgAmpAvailFunctionStatus()
{}

tU32 mascf_mainfi_tclMsgAmpAvailFunctionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 21;
}

fi_tclInContext& mascf_mainfi_tclMsgAmpAvailFunctionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Bass);
   (tVoid) (oIn >> Middle);
   (tVoid) (oIn >> Treble);
   (tVoid) (oIn >> Balance);
   (tVoid) (oIn >> Fader);
   (tVoid) (oIn >> AudioPilot);
   (tVoid) (oIn >> Gala);
   (tVoid) (oIn >> SurroundMode);
   (tVoid) (oIn >> SubWoofer);
   (tVoid) (oIn >> Staging);
   (tVoid) (oIn >> RoomEffect);
   (tVoid) (oIn >> Loudness);
   (tVoid) (oIn >> AGC);
   (tVoid) (oIn >> AmpDownMix);
   (tVoid) (oIn >> SurroundVol);
   (tVoid) (oIn >> RearSoundMode);
   (tVoid) (oIn >> DriverSoundMode);
   (tVoid) (oIn >> ANC);
   (tVoid) (oIn >> ASC);
   (tVoid) (oIn >> SoundAmbiance);
   (tVoid) (oIn >> ESE);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAmpAvailFunctionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Bass);
   (tVoid) (oOut << Middle);
   (tVoid) (oOut << Treble);
   (tVoid) (oOut << Balance);
   (tVoid) (oOut << Fader);
   (tVoid) (oOut << AudioPilot);
   (tVoid) (oOut << Gala);
   (tVoid) (oOut << SurroundMode);
   (tVoid) (oOut << SubWoofer);
   (tVoid) (oOut << Staging);
   (tVoid) (oOut << RoomEffect);
   (tVoid) (oOut << Loudness);
   (tVoid) (oOut << AGC);
   (tVoid) (oOut << AmpDownMix);
   (tVoid) (oOut << SurroundVol);
   (tVoid) (oOut << RearSoundMode);
   (tVoid) (oOut << DriverSoundMode);
   (tVoid) (oOut << ANC);
   (tVoid) (oOut << ASC);
   (tVoid) (oOut << SoundAmbiance);
   (tVoid) (oOut << ESE);
   return oOut;
}

tBool mascf_mainfi_tclMsgAmpAvailFunctionStatus::operator==(const mascf_mainfi_tclMsgAmpAvailFunctionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Bass == roRef.Bass);
   bResult = bResult && (Middle == roRef.Middle);
   bResult = bResult && (Treble == roRef.Treble);
   bResult = bResult && (Balance == roRef.Balance);
   bResult = bResult && (Fader == roRef.Fader);
   bResult = bResult && (AudioPilot == roRef.AudioPilot);
   bResult = bResult && (Gala == roRef.Gala);
   bResult = bResult && (SurroundMode == roRef.SurroundMode);
   bResult = bResult && (SubWoofer == roRef.SubWoofer);
   bResult = bResult && (Staging == roRef.Staging);
   bResult = bResult && (RoomEffect == roRef.RoomEffect);
   bResult = bResult && (Loudness == roRef.Loudness);
   bResult = bResult && (AGC == roRef.AGC);
   bResult = bResult && (AmpDownMix == roRef.AmpDownMix);
   bResult = bResult && (SurroundVol == roRef.SurroundVol);
   bResult = bResult && (RearSoundMode == roRef.RearSoundMode);
   bResult = bResult && (DriverSoundMode == roRef.DriverSoundMode);
   bResult = bResult && (ANC == roRef.ANC);
   bResult = bResult && (ASC == roRef.ASC);
   bResult = bResult && (SoundAmbiance == roRef.SoundAmbiance);
   bResult = bResult && (ESE == roRef.ESE);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgSetAudioPropertyUpReg::mascf_mainfi_tclMsgSetAudioPropertyUpReg()
 {}

tS32 mascf_mainfi_tclMsgSetAudioPropertyUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYUPREG;
}


mascf_mainfi_tclMsgSetAudioPropertyUpReg::~mascf_mainfi_tclMsgSetAudioPropertyUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSetAudioPropertyRelUpReg::mascf_mainfi_tclMsgSetAudioPropertyRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgSetAudioPropertyRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYRELUPREG;
}


mascf_mainfi_tclMsgSetAudioPropertyRelUpReg::~mascf_mainfi_tclMsgSetAudioPropertyRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSetAudioPropertyGet::mascf_mainfi_tclMsgSetAudioPropertyGet()
 {}

tS32 mascf_mainfi_tclMsgSetAudioPropertyGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYGET;
}


mascf_mainfi_tclMsgSetAudioPropertyGet::~mascf_mainfi_tclMsgSetAudioPropertyGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSetAudioPropertySet::mascf_mainfi_tclMsgSetAudioPropertySet(const mascf_mainfi_tclMsgSetAudioPropertySet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
}
mascf_mainfi_tclMsgSetAudioPropertySet& mascf_mainfi_tclMsgSetAudioPropertySet::operator=(const mascf_mainfi_tclMsgSetAudioPropertySet& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSetAudioPropertySet::mascf_mainfi_tclMsgSetAudioPropertySet()
:u8Source()
,u8Property()
,s32PropValue(0)
 {}

tS32 mascf_mainfi_tclMsgSetAudioPropertySet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYSET;
}


mascf_mainfi_tclMsgSetAudioPropertySet::~mascf_mainfi_tclMsgSetAudioPropertySet()
{}

tU32 mascf_mainfi_tclMsgSetAudioPropertySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_mainfi_tclMsgSetAudioPropertySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8Property);
   (tVoid) (oIn >> s32PropValue);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSetAudioPropertySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8Property);
   (tVoid) (oOut << s32PropValue);
   return oOut;
}

tBool mascf_mainfi_tclMsgSetAudioPropertySet::operator==(const mascf_mainfi_tclMsgSetAudioPropertySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8Property == roRef.u8Property);
   bResult = bResult && (s32PropValue == roRef.s32PropValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSetAudioPropertyStatus::mascf_mainfi_tclMsgSetAudioPropertyStatus(const mascf_mainfi_tclMsgSetAudioPropertyStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
}
mascf_mainfi_tclMsgSetAudioPropertyStatus& mascf_mainfi_tclMsgSetAudioPropertyStatus::operator=(const mascf_mainfi_tclMsgSetAudioPropertyStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSetAudioPropertyStatus::mascf_mainfi_tclMsgSetAudioPropertyStatus()
:u8Source()
,u8Property()
,s32PropValue(0)
 {}

tS32 mascf_mainfi_tclMsgSetAudioPropertyStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SETAUDIOPROPERTYSTATUS;
}


mascf_mainfi_tclMsgSetAudioPropertyStatus::~mascf_mainfi_tclMsgSetAudioPropertyStatus()
{}

tU32 mascf_mainfi_tclMsgSetAudioPropertyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mascf_mainfi_tclMsgSetAudioPropertyStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8Property);
   (tVoid) (oIn >> s32PropValue);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSetAudioPropertyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8Property);
   (tVoid) (oOut << s32PropValue);
   return oOut;
}

tBool mascf_mainfi_tclMsgSetAudioPropertyStatus::operator==(const mascf_mainfi_tclMsgSetAudioPropertyStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8Property == roRef.u8Property);
   bResult = bResult && (s32PropValue == roRef.s32PropValue);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgEntOnVolumeSetupUpReg::mascf_mainfi_tclMsgEntOnVolumeSetupUpReg()
 {}

tS32 mascf_mainfi_tclMsgEntOnVolumeSetupUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPUPREG;
}


mascf_mainfi_tclMsgEntOnVolumeSetupUpReg::~mascf_mainfi_tclMsgEntOnVolumeSetupUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg::mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPRELUPREG;
}


mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg::~mascf_mainfi_tclMsgEntOnVolumeSetupRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEntOnVolumeSetupSet::mascf_mainfi_tclMsgEntOnVolumeSetupSet(const mascf_mainfi_tclMsgEntOnVolumeSetupSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LimitValue = coRef.LimitValue;
   SoundType = coRef.SoundType;
}
mascf_mainfi_tclMsgEntOnVolumeSetupSet& mascf_mainfi_tclMsgEntOnVolumeSetupSet::operator=(const mascf_mainfi_tclMsgEntOnVolumeSetupSet& coRef)
{
   if (this == &coRef) return *this;
   LimitValue = coRef.LimitValue;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgEntOnVolumeSetupSet::mascf_mainfi_tclMsgEntOnVolumeSetupSet()
:LimitValue(0)
,SoundType()
 {}

tS32 mascf_mainfi_tclMsgEntOnVolumeSetupSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPSET;
}


mascf_mainfi_tclMsgEntOnVolumeSetupSet::~mascf_mainfi_tclMsgEntOnVolumeSetupSet()
{}

tU32 mascf_mainfi_tclMsgEntOnVolumeSetupSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgEntOnVolumeSetupSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LimitValue);
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEntOnVolumeSetupSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LimitValue);
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgEntOnVolumeSetupSet::operator==(const mascf_mainfi_tclMsgEntOnVolumeSetupSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LimitValue == roRef.LimitValue);
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgEntOnVolumeSetupStatus::mascf_mainfi_tclMsgEntOnVolumeSetupStatus(const mascf_mainfi_tclMsgEntOnVolumeSetupStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   LimitValue = coRef.LimitValue;
}
mascf_mainfi_tclMsgEntOnVolumeSetupStatus& mascf_mainfi_tclMsgEntOnVolumeSetupStatus::operator=(const mascf_mainfi_tclMsgEntOnVolumeSetupStatus& coRef)
{
   if (this == &coRef) return *this;
   LimitValue = coRef.LimitValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgEntOnVolumeSetupStatus::mascf_mainfi_tclMsgEntOnVolumeSetupStatus()
:LimitValue(0)
 {}

tS32 mascf_mainfi_tclMsgEntOnVolumeSetupStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ENTONVOLUMESETUPSTATUS;
}


mascf_mainfi_tclMsgEntOnVolumeSetupStatus::~mascf_mainfi_tclMsgEntOnVolumeSetupStatus()
{}

tU32 mascf_mainfi_tclMsgEntOnVolumeSetupStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgEntOnVolumeSetupStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LimitValue);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgEntOnVolumeSetupStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LimitValue);
   return oOut;
}

tBool mascf_mainfi_tclMsgEntOnVolumeSetupStatus::operator==(const mascf_mainfi_tclMsgEntOnVolumeSetupStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LimitValue == roRef.LimitValue);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRoomEffectUpReg::mascf_mainfi_tclMsgRoomEffectUpReg()
 {}

tS32 mascf_mainfi_tclMsgRoomEffectUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTUPREG;
}


mascf_mainfi_tclMsgRoomEffectUpReg::~mascf_mainfi_tclMsgRoomEffectUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRoomEffectRelUpReg::mascf_mainfi_tclMsgRoomEffectRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRoomEffectRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTRELUPREG;
}


mascf_mainfi_tclMsgRoomEffectRelUpReg::~mascf_mainfi_tclMsgRoomEffectRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRoomEffectGet::mascf_mainfi_tclMsgRoomEffectGet()
 {}

tS32 mascf_mainfi_tclMsgRoomEffectGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTGET;
}


mascf_mainfi_tclMsgRoomEffectGet::~mascf_mainfi_tclMsgRoomEffectGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRoomEffectSet::mascf_mainfi_tclMsgRoomEffectSet(const mascf_mainfi_tclMsgRoomEffectSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgRoomEffectSet& mascf_mainfi_tclMsgRoomEffectSet::operator=(const mascf_mainfi_tclMsgRoomEffectSet& coRef)
{
   if (this == &coRef) return *this;
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRoomEffectSet::mascf_mainfi_tclMsgRoomEffectSet()
:RoomEffect()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgRoomEffectSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTSET;
}


mascf_mainfi_tclMsgRoomEffectSet::~mascf_mainfi_tclMsgRoomEffectSet()
{}

tU32 mascf_mainfi_tclMsgRoomEffectSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgRoomEffectSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoomEffect);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRoomEffectSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoomEffect);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgRoomEffectSet::operator==(const mascf_mainfi_tclMsgRoomEffectSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoomEffect == roRef.RoomEffect);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRoomEffectStatus::mascf_mainfi_tclMsgRoomEffectStatus(const mascf_mainfi_tclMsgRoomEffectStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
}
mascf_mainfi_tclMsgRoomEffectStatus& mascf_mainfi_tclMsgRoomEffectStatus::operator=(const mascf_mainfi_tclMsgRoomEffectStatus& coRef)
{
   if (this == &coRef) return *this;
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRoomEffectStatus::mascf_mainfi_tclMsgRoomEffectStatus()
:RoomEffect()
,Resource()
 {}

tS32 mascf_mainfi_tclMsgRoomEffectStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ROOMEFFECTSTATUS;
}


mascf_mainfi_tclMsgRoomEffectStatus::~mascf_mainfi_tclMsgRoomEffectStatus()
{}

tU32 mascf_mainfi_tclMsgRoomEffectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mascf_mainfi_tclMsgRoomEffectStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoomEffect);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRoomEffectStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoomEffect);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool mascf_mainfi_tclMsgRoomEffectStatus::operator==(const mascf_mainfi_tclMsgRoomEffectStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoomEffect == roRef.RoomEffect);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgFMEnhancerModeUpReg::mascf_mainfi_tclMsgFMEnhancerModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgFMEnhancerModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODEUPREG;
}


mascf_mainfi_tclMsgFMEnhancerModeUpReg::~mascf_mainfi_tclMsgFMEnhancerModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgFMEnhancerModeRelUpReg::mascf_mainfi_tclMsgFMEnhancerModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgFMEnhancerModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODERELUPREG;
}


mascf_mainfi_tclMsgFMEnhancerModeRelUpReg::~mascf_mainfi_tclMsgFMEnhancerModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgFMEnhancerModeGet::mascf_mainfi_tclMsgFMEnhancerModeGet()
 {}

tS32 mascf_mainfi_tclMsgFMEnhancerModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODEGET;
}


mascf_mainfi_tclMsgFMEnhancerModeGet::~mascf_mainfi_tclMsgFMEnhancerModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgFMEnhancerModeSet::mascf_mainfi_tclMsgFMEnhancerModeSet(const mascf_mainfi_tclMsgFMEnhancerModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   FMEnhancer = coRef.FMEnhancer;
}
mascf_mainfi_tclMsgFMEnhancerModeSet& mascf_mainfi_tclMsgFMEnhancerModeSet::operator=(const mascf_mainfi_tclMsgFMEnhancerModeSet& coRef)
{
   if (this == &coRef) return *this;
   FMEnhancer = coRef.FMEnhancer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgFMEnhancerModeSet::mascf_mainfi_tclMsgFMEnhancerModeSet()
:FMEnhancer(0)
 {}

tS32 mascf_mainfi_tclMsgFMEnhancerModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODESET;
}


mascf_mainfi_tclMsgFMEnhancerModeSet::~mascf_mainfi_tclMsgFMEnhancerModeSet()
{}

tU32 mascf_mainfi_tclMsgFMEnhancerModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgFMEnhancerModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FMEnhancer);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgFMEnhancerModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FMEnhancer);
   return oOut;
}

tBool mascf_mainfi_tclMsgFMEnhancerModeSet::operator==(const mascf_mainfi_tclMsgFMEnhancerModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FMEnhancer == roRef.FMEnhancer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgFMEnhancerModeStatus::mascf_mainfi_tclMsgFMEnhancerModeStatus(const mascf_mainfi_tclMsgFMEnhancerModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   FMEnhancer = coRef.FMEnhancer;
}
mascf_mainfi_tclMsgFMEnhancerModeStatus& mascf_mainfi_tclMsgFMEnhancerModeStatus::operator=(const mascf_mainfi_tclMsgFMEnhancerModeStatus& coRef)
{
   if (this == &coRef) return *this;
   FMEnhancer = coRef.FMEnhancer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgFMEnhancerModeStatus::mascf_mainfi_tclMsgFMEnhancerModeStatus()
:FMEnhancer(0)
 {}

tS32 mascf_mainfi_tclMsgFMEnhancerModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_FMENHANCERMODESTATUS;
}


mascf_mainfi_tclMsgFMEnhancerModeStatus::~mascf_mainfi_tclMsgFMEnhancerModeStatus()
{}

tU32 mascf_mainfi_tclMsgFMEnhancerModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgFMEnhancerModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FMEnhancer);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgFMEnhancerModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FMEnhancer);
   return oOut;
}

tBool mascf_mainfi_tclMsgFMEnhancerModeStatus::operator==(const mascf_mainfi_tclMsgFMEnhancerModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FMEnhancer == roRef.FMEnhancer);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgDiagDefSetPhaseUpReg::mascf_mainfi_tclMsgDiagDefSetPhaseUpReg()
 {}

tS32 mascf_mainfi_tclMsgDiagDefSetPhaseUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASEUPREG;
}


mascf_mainfi_tclMsgDiagDefSetPhaseUpReg::~mascf_mainfi_tclMsgDiagDefSetPhaseUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg::mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASERELUPREG;
}


mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg::~mascf_mainfi_tclMsgDiagDefSetPhaseRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgDiagDefSetPhaseGet::mascf_mainfi_tclMsgDiagDefSetPhaseGet()
 {}

tS32 mascf_mainfi_tclMsgDiagDefSetPhaseGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASEGET;
}


mascf_mainfi_tclMsgDiagDefSetPhaseGet::~mascf_mainfi_tclMsgDiagDefSetPhaseGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgDiagDefSetPhaseStatus::mascf_mainfi_tclMsgDiagDefSetPhaseStatus(const mascf_mainfi_tclMsgDiagDefSetPhaseStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DefSetPhase = coRef.DefSetPhase;
}
mascf_mainfi_tclMsgDiagDefSetPhaseStatus& mascf_mainfi_tclMsgDiagDefSetPhaseStatus::operator=(const mascf_mainfi_tclMsgDiagDefSetPhaseStatus& coRef)
{
   if (this == &coRef) return *this;
   DefSetPhase = coRef.DefSetPhase;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgDiagDefSetPhaseStatus::mascf_mainfi_tclMsgDiagDefSetPhaseStatus()
:DefSetPhase()
 {}

tS32 mascf_mainfi_tclMsgDiagDefSetPhaseStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_DIAGDEFSETPHASESTATUS;
}


mascf_mainfi_tclMsgDiagDefSetPhaseStatus::~mascf_mainfi_tclMsgDiagDefSetPhaseStatus()
{}

tU32 mascf_mainfi_tclMsgDiagDefSetPhaseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgDiagDefSetPhaseStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetPhase);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgDiagDefSetPhaseStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetPhase);
   return oOut;
}

tBool mascf_mainfi_tclMsgDiagDefSetPhaseStatus::operator==(const mascf_mainfi_tclMsgDiagDefSetPhaseStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetPhase == roRef.DefSetPhase);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgESESoundTypeUpReg::mascf_mainfi_tclMsgESESoundTypeUpReg()
 {}

tS32 mascf_mainfi_tclMsgESESoundTypeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPEUPREG;
}


mascf_mainfi_tclMsgESESoundTypeUpReg::~mascf_mainfi_tclMsgESESoundTypeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgESESoundTypeRelUpReg::mascf_mainfi_tclMsgESESoundTypeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgESESoundTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPERELUPREG;
}


mascf_mainfi_tclMsgESESoundTypeRelUpReg::~mascf_mainfi_tclMsgESESoundTypeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgESESoundTypeGet::mascf_mainfi_tclMsgESESoundTypeGet()
 {}

tS32 mascf_mainfi_tclMsgESESoundTypeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPEGET;
}


mascf_mainfi_tclMsgESESoundTypeGet::~mascf_mainfi_tclMsgESESoundTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgESESoundTypeSet::mascf_mainfi_tclMsgESESoundTypeSet(const mascf_mainfi_tclMsgESESoundTypeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
mascf_mainfi_tclMsgESESoundTypeSet& mascf_mainfi_tclMsgESESoundTypeSet::operator=(const mascf_mainfi_tclMsgESESoundTypeSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgESESoundTypeSet::mascf_mainfi_tclMsgESESoundTypeSet()
:SoundType(0)
 {}

tS32 mascf_mainfi_tclMsgESESoundTypeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPESET;
}


mascf_mainfi_tclMsgESESoundTypeSet::~mascf_mainfi_tclMsgESESoundTypeSet()
{}

tU32 mascf_mainfi_tclMsgESESoundTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgESESoundTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgESESoundTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgESESoundTypeSet::operator==(const mascf_mainfi_tclMsgESESoundTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgESESoundTypeStatus::mascf_mainfi_tclMsgESESoundTypeStatus(const mascf_mainfi_tclMsgESESoundTypeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
mascf_mainfi_tclMsgESESoundTypeStatus& mascf_mainfi_tclMsgESESoundTypeStatus::operator=(const mascf_mainfi_tclMsgESESoundTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgESESoundTypeStatus::mascf_mainfi_tclMsgESESoundTypeStatus()
:SoundType(0)
 {}

tS32 mascf_mainfi_tclMsgESESoundTypeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESESOUNDTYPESTATUS;
}


mascf_mainfi_tclMsgESESoundTypeStatus::~mascf_mainfi_tclMsgESESoundTypeStatus()
{}

tU32 mascf_mainfi_tclMsgESESoundTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgESESoundTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgESESoundTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgESESoundTypeStatus::operator==(const mascf_mainfi_tclMsgESESoundTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgESEVolumeUpReg::mascf_mainfi_tclMsgESEVolumeUpReg()
 {}

tS32 mascf_mainfi_tclMsgESEVolumeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEVOLUMEUPREG;
}


mascf_mainfi_tclMsgESEVolumeUpReg::~mascf_mainfi_tclMsgESEVolumeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgESEVolumeRelUpReg::mascf_mainfi_tclMsgESEVolumeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgESEVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEVOLUMERELUPREG;
}


mascf_mainfi_tclMsgESEVolumeRelUpReg::~mascf_mainfi_tclMsgESEVolumeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgESEVolumeGet::mascf_mainfi_tclMsgESEVolumeGet()
 {}

tS32 mascf_mainfi_tclMsgESEVolumeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEVOLUMEGET;
}


mascf_mainfi_tclMsgESEVolumeGet::~mascf_mainfi_tclMsgESEVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgESEVolumeSet::mascf_mainfi_tclMsgESEVolumeSet(const mascf_mainfi_tclMsgESEVolumeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
mascf_mainfi_tclMsgESEVolumeSet& mascf_mainfi_tclMsgESEVolumeSet::operator=(const mascf_mainfi_tclMsgESEVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgESEVolumeSet::mascf_mainfi_tclMsgESEVolumeSet()
:Volume(0)
 {}

tS32 mascf_mainfi_tclMsgESEVolumeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEVOLUMESET;
}


mascf_mainfi_tclMsgESEVolumeSet::~mascf_mainfi_tclMsgESEVolumeSet()
{}

tU32 mascf_mainfi_tclMsgESEVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgESEVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgESEVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_mainfi_tclMsgESEVolumeSet::operator==(const mascf_mainfi_tclMsgESEVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgESEVolumeStatus::mascf_mainfi_tclMsgESEVolumeStatus(const mascf_mainfi_tclMsgESEVolumeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
mascf_mainfi_tclMsgESEVolumeStatus& mascf_mainfi_tclMsgESEVolumeStatus::operator=(const mascf_mainfi_tclMsgESEVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgESEVolumeStatus::mascf_mainfi_tclMsgESEVolumeStatus()
:Volume(0)
 {}

tS32 mascf_mainfi_tclMsgESEVolumeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEVOLUMESTATUS;
}


mascf_mainfi_tclMsgESEVolumeStatus::~mascf_mainfi_tclMsgESEVolumeStatus()
{}

tU32 mascf_mainfi_tclMsgESEVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgESEVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgESEVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_mainfi_tclMsgESEVolumeStatus::operator==(const mascf_mainfi_tclMsgESEVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRSoundOnOffUpReg::mascf_mainfi_tclMsgRSoundOnOffUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundOnOffUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFUPREG;
}


mascf_mainfi_tclMsgRSoundOnOffUpReg::~mascf_mainfi_tclMsgRSoundOnOffUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundOnOffRelUpReg::mascf_mainfi_tclMsgRSoundOnOffRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundOnOffRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFRELUPREG;
}


mascf_mainfi_tclMsgRSoundOnOffRelUpReg::~mascf_mainfi_tclMsgRSoundOnOffRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundOnOffGet::mascf_mainfi_tclMsgRSoundOnOffGet()
 {}

tS32 mascf_mainfi_tclMsgRSoundOnOffGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFGET;
}


mascf_mainfi_tclMsgRSoundOnOffGet::~mascf_mainfi_tclMsgRSoundOnOffGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundOnOffSet::mascf_mainfi_tclMsgRSoundOnOffSet(const mascf_mainfi_tclMsgRSoundOnOffSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RSound = coRef.RSound;
}
mascf_mainfi_tclMsgRSoundOnOffSet& mascf_mainfi_tclMsgRSoundOnOffSet::operator=(const mascf_mainfi_tclMsgRSoundOnOffSet& coRef)
{
   if (this == &coRef) return *this;
   RSound = coRef.RSound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundOnOffSet::mascf_mainfi_tclMsgRSoundOnOffSet()
:RSound(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundOnOffSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFSET;
}


mascf_mainfi_tclMsgRSoundOnOffSet::~mascf_mainfi_tclMsgRSoundOnOffSet()
{}

tU32 mascf_mainfi_tclMsgRSoundOnOffSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundOnOffSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSound);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundOnOffSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSound);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundOnOffSet::operator==(const mascf_mainfi_tclMsgRSoundOnOffSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSound == roRef.RSound);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundOnOffStatus::mascf_mainfi_tclMsgRSoundOnOffStatus(const mascf_mainfi_tclMsgRSoundOnOffStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RSound = coRef.RSound;
}
mascf_mainfi_tclMsgRSoundOnOffStatus& mascf_mainfi_tclMsgRSoundOnOffStatus::operator=(const mascf_mainfi_tclMsgRSoundOnOffStatus& coRef)
{
   if (this == &coRef) return *this;
   RSound = coRef.RSound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundOnOffStatus::mascf_mainfi_tclMsgRSoundOnOffStatus()
:RSound(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundOnOffStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDONOFFSTATUS;
}


mascf_mainfi_tclMsgRSoundOnOffStatus::~mascf_mainfi_tclMsgRSoundOnOffStatus()
{}

tU32 mascf_mainfi_tclMsgRSoundOnOffStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundOnOffStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSound);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundOnOffStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSound);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundOnOffStatus::operator==(const mascf_mainfi_tclMsgRSoundOnOffStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSound == roRef.RSound);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRSoundSoundTypeUpReg::mascf_mainfi_tclMsgRSoundSoundTypeUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundSoundTypeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPEUPREG;
}


mascf_mainfi_tclMsgRSoundSoundTypeUpReg::~mascf_mainfi_tclMsgRSoundSoundTypeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg::mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPERELUPREG;
}


mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg::~mascf_mainfi_tclMsgRSoundSoundTypeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundSoundTypeGet::mascf_mainfi_tclMsgRSoundSoundTypeGet()
 {}

tS32 mascf_mainfi_tclMsgRSoundSoundTypeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPEGET;
}


mascf_mainfi_tclMsgRSoundSoundTypeGet::~mascf_mainfi_tclMsgRSoundSoundTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundSoundTypeSet::mascf_mainfi_tclMsgRSoundSoundTypeSet(const mascf_mainfi_tclMsgRSoundSoundTypeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RSoundType = coRef.RSoundType;
}
mascf_mainfi_tclMsgRSoundSoundTypeSet& mascf_mainfi_tclMsgRSoundSoundTypeSet::operator=(const mascf_mainfi_tclMsgRSoundSoundTypeSet& coRef)
{
   if (this == &coRef) return *this;
   RSoundType = coRef.RSoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundSoundTypeSet::mascf_mainfi_tclMsgRSoundSoundTypeSet()
:RSoundType(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundSoundTypeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPESET;
}


mascf_mainfi_tclMsgRSoundSoundTypeSet::~mascf_mainfi_tclMsgRSoundSoundTypeSet()
{}

tU32 mascf_mainfi_tclMsgRSoundSoundTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundSoundTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundSoundTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundSoundTypeSet::operator==(const mascf_mainfi_tclMsgRSoundSoundTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundType == roRef.RSoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundSoundTypeStatus::mascf_mainfi_tclMsgRSoundSoundTypeStatus(const mascf_mainfi_tclMsgRSoundSoundTypeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RSoundType = coRef.RSoundType;
}
mascf_mainfi_tclMsgRSoundSoundTypeStatus& mascf_mainfi_tclMsgRSoundSoundTypeStatus::operator=(const mascf_mainfi_tclMsgRSoundSoundTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   RSoundType = coRef.RSoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundSoundTypeStatus::mascf_mainfi_tclMsgRSoundSoundTypeStatus()
:RSoundType(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundSoundTypeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDSOUNDTYPESTATUS;
}


mascf_mainfi_tclMsgRSoundSoundTypeStatus::~mascf_mainfi_tclMsgRSoundSoundTypeStatus()
{}

tU32 mascf_mainfi_tclMsgRSoundSoundTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundSoundTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundSoundTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundSoundTypeStatus::operator==(const mascf_mainfi_tclMsgRSoundSoundTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundType == roRef.RSoundType);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRSoundVolumeUpReg::mascf_mainfi_tclMsgRSoundVolumeUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundVolumeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMEUPREG;
}


mascf_mainfi_tclMsgRSoundVolumeUpReg::~mascf_mainfi_tclMsgRSoundVolumeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundVolumeRelUpReg::mascf_mainfi_tclMsgRSoundVolumeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMERELUPREG;
}


mascf_mainfi_tclMsgRSoundVolumeRelUpReg::~mascf_mainfi_tclMsgRSoundVolumeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundVolumeGet::mascf_mainfi_tclMsgRSoundVolumeGet()
 {}

tS32 mascf_mainfi_tclMsgRSoundVolumeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMEGET;
}


mascf_mainfi_tclMsgRSoundVolumeGet::~mascf_mainfi_tclMsgRSoundVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundVolumeSet::mascf_mainfi_tclMsgRSoundVolumeSet(const mascf_mainfi_tclMsgRSoundVolumeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
mascf_mainfi_tclMsgRSoundVolumeSet& mascf_mainfi_tclMsgRSoundVolumeSet::operator=(const mascf_mainfi_tclMsgRSoundVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundVolumeSet::mascf_mainfi_tclMsgRSoundVolumeSet()
:Volume(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundVolumeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMESET;
}


mascf_mainfi_tclMsgRSoundVolumeSet::~mascf_mainfi_tclMsgRSoundVolumeSet()
{}

tU32 mascf_mainfi_tclMsgRSoundVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundVolumeSet::operator==(const mascf_mainfi_tclMsgRSoundVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundVolumeStatus::mascf_mainfi_tclMsgRSoundVolumeStatus(const mascf_mainfi_tclMsgRSoundVolumeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
mascf_mainfi_tclMsgRSoundVolumeStatus& mascf_mainfi_tclMsgRSoundVolumeStatus::operator=(const mascf_mainfi_tclMsgRSoundVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundVolumeStatus::mascf_mainfi_tclMsgRSoundVolumeStatus()
:Volume(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundVolumeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDVOLUMESTATUS;
}


mascf_mainfi_tclMsgRSoundVolumeStatus::~mascf_mainfi_tclMsgRSoundVolumeStatus()
{}

tU32 mascf_mainfi_tclMsgRSoundVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundVolumeStatus::operator==(const mascf_mainfi_tclMsgRSoundVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgESEDriveModeUpReg::mascf_mainfi_tclMsgESEDriveModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgESEDriveModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODEUPREG;
}


mascf_mainfi_tclMsgESEDriveModeUpReg::~mascf_mainfi_tclMsgESEDriveModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgESEDriveModeRelUpReg::mascf_mainfi_tclMsgESEDriveModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgESEDriveModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODERELUPREG;
}


mascf_mainfi_tclMsgESEDriveModeRelUpReg::~mascf_mainfi_tclMsgESEDriveModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgESEDriveModeGet::mascf_mainfi_tclMsgESEDriveModeGet()
 {}

tS32 mascf_mainfi_tclMsgESEDriveModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODEGET;
}


mascf_mainfi_tclMsgESEDriveModeGet::~mascf_mainfi_tclMsgESEDriveModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgESEDriveModeSet::mascf_mainfi_tclMsgESEDriveModeSet(const mascf_mainfi_tclMsgESEDriveModeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DriveMode = coRef.DriveMode;
}
mascf_mainfi_tclMsgESEDriveModeSet& mascf_mainfi_tclMsgESEDriveModeSet::operator=(const mascf_mainfi_tclMsgESEDriveModeSet& coRef)
{
   if (this == &coRef) return *this;
   DriveMode = coRef.DriveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgESEDriveModeSet::mascf_mainfi_tclMsgESEDriveModeSet()
:DriveMode(0)
 {}

tS32 mascf_mainfi_tclMsgESEDriveModeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODESET;
}


mascf_mainfi_tclMsgESEDriveModeSet::~mascf_mainfi_tclMsgESEDriveModeSet()
{}

tU32 mascf_mainfi_tclMsgESEDriveModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgESEDriveModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgESEDriveModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgESEDriveModeSet::operator==(const mascf_mainfi_tclMsgESEDriveModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveMode == roRef.DriveMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgESEDriveModeStatus::mascf_mainfi_tclMsgESEDriveModeStatus(const mascf_mainfi_tclMsgESEDriveModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DriveMode = coRef.DriveMode;
}
mascf_mainfi_tclMsgESEDriveModeStatus& mascf_mainfi_tclMsgESEDriveModeStatus::operator=(const mascf_mainfi_tclMsgESEDriveModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DriveMode = coRef.DriveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgESEDriveModeStatus::mascf_mainfi_tclMsgESEDriveModeStatus()
:DriveMode(0)
 {}

tS32 mascf_mainfi_tclMsgESEDriveModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ESEDRIVEMODESTATUS;
}


mascf_mainfi_tclMsgESEDriveModeStatus::~mascf_mainfi_tclMsgESEDriveModeStatus()
{}

tU32 mascf_mainfi_tclMsgESEDriveModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgESEDriveModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgESEDriveModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgESEDriveModeStatus::operator==(const mascf_mainfi_tclMsgESEDriveModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveMode == roRef.DriveMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAudioModeUpReg::mascf_mainfi_tclMsgAudioModeUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioModeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOMODEUPREG;
}


mascf_mainfi_tclMsgAudioModeUpReg::~mascf_mainfi_tclMsgAudioModeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioModeRelUpReg::mascf_mainfi_tclMsgAudioModeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioModeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOMODERELUPREG;
}


mascf_mainfi_tclMsgAudioModeRelUpReg::~mascf_mainfi_tclMsgAudioModeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioModeGet::mascf_mainfi_tclMsgAudioModeGet()
 {}

tS32 mascf_mainfi_tclMsgAudioModeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOMODEGET;
}


mascf_mainfi_tclMsgAudioModeGet::~mascf_mainfi_tclMsgAudioModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioModeStatus::mascf_mainfi_tclMsgAudioModeStatus(const mascf_mainfi_tclMsgAudioModeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AudioMode = coRef.AudioMode;
}
mascf_mainfi_tclMsgAudioModeStatus& mascf_mainfi_tclMsgAudioModeStatus::operator=(const mascf_mainfi_tclMsgAudioModeStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioMode = coRef.AudioMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioModeStatus::mascf_mainfi_tclMsgAudioModeStatus()
:AudioMode()
 {}

tS32 mascf_mainfi_tclMsgAudioModeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOMODESTATUS;
}


mascf_mainfi_tclMsgAudioModeStatus::~mascf_mainfi_tclMsgAudioModeStatus()
{}

tU32 mascf_mainfi_tclMsgAudioModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioMode);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioMode);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioModeStatus::operator==(const mascf_mainfi_tclMsgAudioModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioMode == roRef.AudioMode);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg::mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEUPREG;
}


mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg::~mascf_mainfi_tclMsgADAS_UPASoundTypeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg::mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPERELUPREG;
}


mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg::~mascf_mainfi_tclMsgADAS_UPASoundTypeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_UPASoundTypeGet::mascf_mainfi_tclMsgADAS_UPASoundTypeGet()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPASoundTypeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEGET;
}


mascf_mainfi_tclMsgADAS_UPASoundTypeGet::~mascf_mainfi_tclMsgADAS_UPASoundTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_UPASoundTypeSet::mascf_mainfi_tclMsgADAS_UPASoundTypeSet(const mascf_mainfi_tclMsgADAS_UPASoundTypeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
mascf_mainfi_tclMsgADAS_UPASoundTypeSet& mascf_mainfi_tclMsgADAS_UPASoundTypeSet::operator=(const mascf_mainfi_tclMsgADAS_UPASoundTypeSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_UPASoundTypeSet::mascf_mainfi_tclMsgADAS_UPASoundTypeSet()
:SoundType()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPASoundTypeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESET;
}


mascf_mainfi_tclMsgADAS_UPASoundTypeSet::~mascf_mainfi_tclMsgADAS_UPASoundTypeSet()
{}

tU32 mascf_mainfi_tclMsgADAS_UPASoundTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_UPASoundTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_UPASoundTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_UPASoundTypeSet::operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::mascf_mainfi_tclMsgADAS_UPASoundTypeStatus(const mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::operator=(const mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::mascf_mainfi_tclMsgADAS_UPASoundTypeStatus()
:SoundType()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESTATUS;
}


mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::~mascf_mainfi_tclMsgADAS_UPASoundTypeStatus()
{}

tU32 mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_UPASoundTypeStatus::operator==(const mascf_mainfi_tclMsgADAS_UPASoundTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg::mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEUPREG;
}


mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg::~mascf_mainfi_tclMsgADAS_ParkAssistVolumeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg::mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMERELUPREG;
}


mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg::~mascf_mainfi_tclMsgADAS_ParkAssistVolumeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet::mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet()
 {}

tS32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEGET;
}


mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet::~mascf_mainfi_tclMsgADAS_ParkAssistVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::operator=(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet()
:VolumeLevel()
 {}

tS32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESET;
}


mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::~mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet()
{}

tU32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet::operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::operator=(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus()
:VolumeLevel()
 {}

tS32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESTATUS;
}


mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::~mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus()
{}

tU32 mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus::operator==(const mascf_mainfi_tclMsgADAS_ParkAssistVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgADAS_UPAMuteUpReg::mascf_mainfi_tclMsgADAS_UPAMuteUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPAMuteUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTEUPREG;
}


mascf_mainfi_tclMsgADAS_UPAMuteUpReg::~mascf_mainfi_tclMsgADAS_UPAMuteUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg::mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTERELUPREG;
}


mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg::~mascf_mainfi_tclMsgADAS_UPAMuteRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_UPAMuteGet::mascf_mainfi_tclMsgADAS_UPAMuteGet()
 {}

tS32 mascf_mainfi_tclMsgADAS_UPAMuteGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTEGET;
}


mascf_mainfi_tclMsgADAS_UPAMuteGet::~mascf_mainfi_tclMsgADAS_UPAMuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_UPAMuteSet::mascf_mainfi_tclMsgADAS_UPAMuteSet(const mascf_mainfi_tclMsgADAS_UPAMuteSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   bMute = coRef.bMute;
}
mascf_mainfi_tclMsgADAS_UPAMuteSet& mascf_mainfi_tclMsgADAS_UPAMuteSet::operator=(const mascf_mainfi_tclMsgADAS_UPAMuteSet& coRef)
{
   if (this == &coRef) return *this;
   bMute = coRef.bMute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_UPAMuteSet::mascf_mainfi_tclMsgADAS_UPAMuteSet()
:bMute(0)
 {}

tS32 mascf_mainfi_tclMsgADAS_UPAMuteSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTESET;
}


mascf_mainfi_tclMsgADAS_UPAMuteSet::~mascf_mainfi_tclMsgADAS_UPAMuteSet()
{}

tU32 mascf_mainfi_tclMsgADAS_UPAMuteSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_UPAMuteSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMute);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_UPAMuteSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMute);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_UPAMuteSet::operator==(const mascf_mainfi_tclMsgADAS_UPAMuteSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMute == roRef.bMute);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_UPAMuteStatus::mascf_mainfi_tclMsgADAS_UPAMuteStatus(const mascf_mainfi_tclMsgADAS_UPAMuteStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   bMuted = coRef.bMuted;
}
mascf_mainfi_tclMsgADAS_UPAMuteStatus& mascf_mainfi_tclMsgADAS_UPAMuteStatus::operator=(const mascf_mainfi_tclMsgADAS_UPAMuteStatus& coRef)
{
   if (this == &coRef) return *this;
   bMuted = coRef.bMuted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_UPAMuteStatus::mascf_mainfi_tclMsgADAS_UPAMuteStatus()
:bMuted(0)
 {}

tS32 mascf_mainfi_tclMsgADAS_UPAMuteStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_UPAMUTESTATUS;
}


mascf_mainfi_tclMsgADAS_UPAMuteStatus::~mascf_mainfi_tclMsgADAS_UPAMuteStatus()
{}

tU32 mascf_mainfi_tclMsgADAS_UPAMuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_UPAMuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMuted);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_UPAMuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMuted);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_UPAMuteStatus::operator==(const mascf_mainfi_tclMsgADAS_UPAMuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMuted == roRef.bMuted);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAutomaticGainControlUpReg::mascf_mainfi_tclMsgAutomaticGainControlUpReg()
 {}

tS32 mascf_mainfi_tclMsgAutomaticGainControlUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLUPREG;
}


mascf_mainfi_tclMsgAutomaticGainControlUpReg::~mascf_mainfi_tclMsgAutomaticGainControlUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAutomaticGainControlRelUpReg::mascf_mainfi_tclMsgAutomaticGainControlRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAutomaticGainControlRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLRELUPREG;
}


mascf_mainfi_tclMsgAutomaticGainControlRelUpReg::~mascf_mainfi_tclMsgAutomaticGainControlRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAutomaticGainControlGet::mascf_mainfi_tclMsgAutomaticGainControlGet()
 {}

tS32 mascf_mainfi_tclMsgAutomaticGainControlGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLGET;
}


mascf_mainfi_tclMsgAutomaticGainControlGet::~mascf_mainfi_tclMsgAutomaticGainControlGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAutomaticGainControlSet::mascf_mainfi_tclMsgAutomaticGainControlSet(const mascf_mainfi_tclMsgAutomaticGainControlSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AutomaticGainControl = coRef.AutomaticGainControl;
}
mascf_mainfi_tclMsgAutomaticGainControlSet& mascf_mainfi_tclMsgAutomaticGainControlSet::operator=(const mascf_mainfi_tclMsgAutomaticGainControlSet& coRef)
{
   if (this == &coRef) return *this;
   AutomaticGainControl = coRef.AutomaticGainControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAutomaticGainControlSet::mascf_mainfi_tclMsgAutomaticGainControlSet()
:AutomaticGainControl(0)
 {}

tS32 mascf_mainfi_tclMsgAutomaticGainControlSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSET;
}


mascf_mainfi_tclMsgAutomaticGainControlSet::~mascf_mainfi_tclMsgAutomaticGainControlSet()
{}

tU32 mascf_mainfi_tclMsgAutomaticGainControlSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAutomaticGainControlSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutomaticGainControl);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAutomaticGainControlSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutomaticGainControl);
   return oOut;
}

tBool mascf_mainfi_tclMsgAutomaticGainControlSet::operator==(const mascf_mainfi_tclMsgAutomaticGainControlSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutomaticGainControl == roRef.AutomaticGainControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAutomaticGainControlStatus::mascf_mainfi_tclMsgAutomaticGainControlStatus(const mascf_mainfi_tclMsgAutomaticGainControlStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   AutomaticGainControl = coRef.AutomaticGainControl;
}
mascf_mainfi_tclMsgAutomaticGainControlStatus& mascf_mainfi_tclMsgAutomaticGainControlStatus::operator=(const mascf_mainfi_tclMsgAutomaticGainControlStatus& coRef)
{
   if (this == &coRef) return *this;
   AutomaticGainControl = coRef.AutomaticGainControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAutomaticGainControlStatus::mascf_mainfi_tclMsgAutomaticGainControlStatus()
:AutomaticGainControl(0)
 {}

tS32 mascf_mainfi_tclMsgAutomaticGainControlStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSTATUS;
}


mascf_mainfi_tclMsgAutomaticGainControlStatus::~mascf_mainfi_tclMsgAutomaticGainControlStatus()
{}

tU32 mascf_mainfi_tclMsgAutomaticGainControlStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAutomaticGainControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutomaticGainControl);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAutomaticGainControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutomaticGainControl);
   return oOut;
}

tBool mascf_mainfi_tclMsgAutomaticGainControlStatus::operator==(const mascf_mainfi_tclMsgAutomaticGainControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutomaticGainControl == roRef.AutomaticGainControl);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg::mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEUPREG;
}


mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg::~mascf_mainfi_tclMsgADAS_LDW_UserVolumeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg::mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMERELUPREG;
}


mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg::~mascf_mainfi_tclMsgADAS_LDW_UserVolumeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet::mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet()
 {}

tS32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEGET;
}


mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet::~mascf_mainfi_tclMsgADAS_LDW_UserVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::operator=(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet()
:VolumeLevel()
 {}

tS32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESET;
}


mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::~mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet()
{}

tU32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet::operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::operator=(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus()
:VolumeLevel()
 {}

tS32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESTATUS;
}


mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::~mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus()
{}

tU32 mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus::operator==(const mascf_mainfi_tclMsgADAS_LDW_UserVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgRSoundActivationUpReg::mascf_mainfi_tclMsgRSoundActivationUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundActivationUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONUPREG;
}


mascf_mainfi_tclMsgRSoundActivationUpReg::~mascf_mainfi_tclMsgRSoundActivationUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundActivationRelUpReg::mascf_mainfi_tclMsgRSoundActivationRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgRSoundActivationRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONRELUPREG;
}


mascf_mainfi_tclMsgRSoundActivationRelUpReg::~mascf_mainfi_tclMsgRSoundActivationRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgRSoundActivationGet::mascf_mainfi_tclMsgRSoundActivationGet()
 {}

tS32 mascf_mainfi_tclMsgRSoundActivationGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONGET;
}


mascf_mainfi_tclMsgRSoundActivationGet::~mascf_mainfi_tclMsgRSoundActivationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundActivationSet::mascf_mainfi_tclMsgRSoundActivationSet(const mascf_mainfi_tclMsgRSoundActivationSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RSoundActive = coRef.RSoundActive;
}
mascf_mainfi_tclMsgRSoundActivationSet& mascf_mainfi_tclMsgRSoundActivationSet::operator=(const mascf_mainfi_tclMsgRSoundActivationSet& coRef)
{
   if (this == &coRef) return *this;
   RSoundActive = coRef.RSoundActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundActivationSet::mascf_mainfi_tclMsgRSoundActivationSet()
:RSoundActive(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundActivationSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONSET;
}


mascf_mainfi_tclMsgRSoundActivationSet::~mascf_mainfi_tclMsgRSoundActivationSet()
{}

tU32 mascf_mainfi_tclMsgRSoundActivationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundActivationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundActive);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundActivationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundActive);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundActivationSet::operator==(const mascf_mainfi_tclMsgRSoundActivationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundActive == roRef.RSoundActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgRSoundActivationStatus::mascf_mainfi_tclMsgRSoundActivationStatus(const mascf_mainfi_tclMsgRSoundActivationStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   RSoundActive = coRef.RSoundActive;
}
mascf_mainfi_tclMsgRSoundActivationStatus& mascf_mainfi_tclMsgRSoundActivationStatus::operator=(const mascf_mainfi_tclMsgRSoundActivationStatus& coRef)
{
   if (this == &coRef) return *this;
   RSoundActive = coRef.RSoundActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgRSoundActivationStatus::mascf_mainfi_tclMsgRSoundActivationStatus()
:RSoundActive(0)
 {}

tS32 mascf_mainfi_tclMsgRSoundActivationStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_RSOUNDACTIVATIONSTATUS;
}


mascf_mainfi_tclMsgRSoundActivationStatus::~mascf_mainfi_tclMsgRSoundActivationStatus()
{}

tU32 mascf_mainfi_tclMsgRSoundActivationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgRSoundActivationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundActive);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgRSoundActivationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundActive);
   return oOut;
}

tBool mascf_mainfi_tclMsgRSoundActivationStatus::operator==(const mascf_mainfi_tclMsgRSoundActivationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundActive == roRef.RSoundActive);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgANCASCActiveTestUpReg::mascf_mainfi_tclMsgANCASCActiveTestUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCASCActiveTestUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTUPREG;
}


mascf_mainfi_tclMsgANCASCActiveTestUpReg::~mascf_mainfi_tclMsgANCASCActiveTestUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCActiveTestRelUpReg::mascf_mainfi_tclMsgANCASCActiveTestRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCASCActiveTestRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTRELUPREG;
}


mascf_mainfi_tclMsgANCASCActiveTestRelUpReg::~mascf_mainfi_tclMsgANCASCActiveTestRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCActiveTestGet::mascf_mainfi_tclMsgANCASCActiveTestGet()
 {}

tS32 mascf_mainfi_tclMsgANCASCActiveTestGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTGET;
}


mascf_mainfi_tclMsgANCASCActiveTestGet::~mascf_mainfi_tclMsgANCASCActiveTestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgANCASCActiveTestSet::mascf_mainfi_tclMsgANCASCActiveTestSet(const mascf_mainfi_tclMsgANCASCActiveTestSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Request = coRef.Request;
}
mascf_mainfi_tclMsgANCASCActiveTestSet& mascf_mainfi_tclMsgANCASCActiveTestSet::operator=(const mascf_mainfi_tclMsgANCASCActiveTestSet& coRef)
{
   if (this == &coRef) return *this;
   Request = coRef.Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgANCASCActiveTestSet::mascf_mainfi_tclMsgANCASCActiveTestSet()
:Request(0)
 {}

tS32 mascf_mainfi_tclMsgANCASCActiveTestSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTSET;
}


mascf_mainfi_tclMsgANCASCActiveTestSet::~mascf_mainfi_tclMsgANCASCActiveTestSet()
{}

tU32 mascf_mainfi_tclMsgANCASCActiveTestSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgANCASCActiveTestSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Request);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgANCASCActiveTestSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Request);
   return oOut;
}

tBool mascf_mainfi_tclMsgANCASCActiveTestSet::operator==(const mascf_mainfi_tclMsgANCASCActiveTestSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Request == roRef.Request);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgANCASCActiveTestStatus::mascf_mainfi_tclMsgANCASCActiveTestStatus(const mascf_mainfi_tclMsgANCASCActiveTestStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   TestStatus = coRef.TestStatus;
}
mascf_mainfi_tclMsgANCASCActiveTestStatus& mascf_mainfi_tclMsgANCASCActiveTestStatus::operator=(const mascf_mainfi_tclMsgANCASCActiveTestStatus& coRef)
{
   if (this == &coRef) return *this;
   TestStatus = coRef.TestStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgANCASCActiveTestStatus::mascf_mainfi_tclMsgANCASCActiveTestStatus()
:TestStatus(0)
 {}

tS32 mascf_mainfi_tclMsgANCASCActiveTestStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCACTIVETESTSTATUS;
}


mascf_mainfi_tclMsgANCASCActiveTestStatus::~mascf_mainfi_tclMsgANCASCActiveTestStatus()
{}

tU32 mascf_mainfi_tclMsgANCASCActiveTestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgANCASCActiveTestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestStatus);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgANCASCActiveTestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestStatus);
   return oOut;
}

tBool mascf_mainfi_tclMsgANCASCActiveTestStatus::operator==(const mascf_mainfi_tclMsgANCASCActiveTestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestStatus == roRef.TestStatus);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg::mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSUPREG;
}


mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg::~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg::mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSRELUPREG;
}


mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg::~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet::mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet()
 {}

tS32 mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSGET;
}


mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet::~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusGet()
{}

//=============================================================================

mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet::mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet()
 {}

tS32 mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSET;
}


mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet::~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   DiagResultSummary = coRef.DiagResultSummary;
   MicrophoneResult = coRef.MicrophoneResult;
   EnginePulse = coRef.EnginePulse;
   DoorOpenClose = coRef.DoorOpenClose;
   ConfigInformation = coRef.ConfigInformation;
}
mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::operator=(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DiagResultSummary = coRef.DiagResultSummary;
   MicrophoneResult = coRef.MicrophoneResult;
   EnginePulse = coRef.EnginePulse;
   DoorOpenClose = coRef.DoorOpenClose;
   ConfigInformation = coRef.ConfigInformation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::vDestroy()
{
   MicrophoneResult.vDestroy(); 
   ConfigInformation.vDestroy();
}

mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus()
:DiagResultSummary(0)
,MicrophoneResult()
,EnginePulse(0)
,DoorOpenClose(0)
,ConfigInformation()
 {}

tS32 mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSTATUS;
}


mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::~mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+ConfigInformation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagResultSummary);
   (tVoid) (oIn >> MicrophoneResult);
   (tVoid) (oIn >> EnginePulse);
   (tVoid) (oIn >> DoorOpenClose);
   (tVoid) (oIn >> ConfigInformation);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagResultSummary);
   (tVoid) (oOut << MicrophoneResult);
   (tVoid) (oOut << EnginePulse);
   (tVoid) (oOut << DoorOpenClose);
   (tVoid) (oOut << ConfigInformation);
   return oOut;
}

tBool mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus::operator==(const mascf_mainfi_tclMsgANCASCSelfDiagnosticStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagResultSummary == roRef.DiagResultSummary);
   bResult = bResult && (MicrophoneResult == roRef.MicrophoneResult);
   bResult = bResult && (EnginePulse == roRef.EnginePulse);
   bResult = bResult && (DoorOpenClose == roRef.DoorOpenClose);
   bResult = bResult && (ConfigInformation == roRef.ConfigInformation);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgUserProfileChangeUpReg::mascf_mainfi_tclMsgUserProfileChangeUpReg()
 {}

tS32 mascf_mainfi_tclMsgUserProfileChangeUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGEUPREG;
}


mascf_mainfi_tclMsgUserProfileChangeUpReg::~mascf_mainfi_tclMsgUserProfileChangeUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgUserProfileChangeRelUpReg::mascf_mainfi_tclMsgUserProfileChangeRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgUserProfileChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGERELUPREG;
}


mascf_mainfi_tclMsgUserProfileChangeRelUpReg::~mascf_mainfi_tclMsgUserProfileChangeRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgUserProfileChangeGet::mascf_mainfi_tclMsgUserProfileChangeGet()
 {}

tS32 mascf_mainfi_tclMsgUserProfileChangeGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGEGET;
}


mascf_mainfi_tclMsgUserProfileChangeGet::~mascf_mainfi_tclMsgUserProfileChangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgUserProfileChangeSet::mascf_mainfi_tclMsgUserProfileChangeSet(const mascf_mainfi_tclMsgUserProfileChangeSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   UserProfileChange = coRef.UserProfileChange;
}
mascf_mainfi_tclMsgUserProfileChangeSet& mascf_mainfi_tclMsgUserProfileChangeSet::operator=(const mascf_mainfi_tclMsgUserProfileChangeSet& coRef)
{
   if (this == &coRef) return *this;
   UserProfileChange = coRef.UserProfileChange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgUserProfileChangeSet::mascf_mainfi_tclMsgUserProfileChangeSet()
:UserProfileChange(0)
 {}

tS32 mascf_mainfi_tclMsgUserProfileChangeSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGESET;
}


mascf_mainfi_tclMsgUserProfileChangeSet::~mascf_mainfi_tclMsgUserProfileChangeSet()
{}

tU32 mascf_mainfi_tclMsgUserProfileChangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgUserProfileChangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserProfileChange);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgUserProfileChangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserProfileChange);
   return oOut;
}

tBool mascf_mainfi_tclMsgUserProfileChangeSet::operator==(const mascf_mainfi_tclMsgUserProfileChangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserProfileChange == roRef.UserProfileChange);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgUserProfileChangeStatus::mascf_mainfi_tclMsgUserProfileChangeStatus(const mascf_mainfi_tclMsgUserProfileChangeStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   UserProfileChange = coRef.UserProfileChange;
}
mascf_mainfi_tclMsgUserProfileChangeStatus& mascf_mainfi_tclMsgUserProfileChangeStatus::operator=(const mascf_mainfi_tclMsgUserProfileChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   UserProfileChange = coRef.UserProfileChange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgUserProfileChangeStatus::mascf_mainfi_tclMsgUserProfileChangeStatus()
:UserProfileChange(0)
 {}

tS32 mascf_mainfi_tclMsgUserProfileChangeStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_USERPROFILECHANGESTATUS;
}


mascf_mainfi_tclMsgUserProfileChangeStatus::~mascf_mainfi_tclMsgUserProfileChangeStatus()
{}

tU32 mascf_mainfi_tclMsgUserProfileChangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgUserProfileChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserProfileChange);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgUserProfileChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserProfileChange);
   return oOut;
}

tBool mascf_mainfi_tclMsgUserProfileChangeStatus::operator==(const mascf_mainfi_tclMsgUserProfileChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserProfileChange == roRef.UserProfileChange);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgSRSoundNotificationStateUpReg::mascf_mainfi_tclMsgSRSoundNotificationStateUpReg()
 {}

tS32 mascf_mainfi_tclMsgSRSoundNotificationStateUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEUPREG;
}


mascf_mainfi_tclMsgSRSoundNotificationStateUpReg::~mascf_mainfi_tclMsgSRSoundNotificationStateUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg::mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATERELUPREG;
}


mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg::~mascf_mainfi_tclMsgSRSoundNotificationStateRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgSRSoundNotificationStateGet::mascf_mainfi_tclMsgSRSoundNotificationStateGet()
 {}

tS32 mascf_mainfi_tclMsgSRSoundNotificationStateGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEGET;
}


mascf_mainfi_tclMsgSRSoundNotificationStateGet::~mascf_mainfi_tclMsgSRSoundNotificationStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSRSoundNotificationStateSet::mascf_mainfi_tclMsgSRSoundNotificationStateSet(const mascf_mainfi_tclMsgSRSoundNotificationStateSet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
}
mascf_mainfi_tclMsgSRSoundNotificationStateSet& mascf_mainfi_tclMsgSRSoundNotificationStateSet::operator=(const mascf_mainfi_tclMsgSRSoundNotificationStateSet& coRef)
{
   if (this == &coRef) return *this;
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSRSoundNotificationStateSet::mascf_mainfi_tclMsgSRSoundNotificationStateSet()
:SR_SoundNotification_State(0)
 {}

tS32 mascf_mainfi_tclMsgSRSoundNotificationStateSet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESET;
}


mascf_mainfi_tclMsgSRSoundNotificationStateSet::~mascf_mainfi_tclMsgSRSoundNotificationStateSet()
{}

tU32 mascf_mainfi_tclMsgSRSoundNotificationStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSRSoundNotificationStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SR_SoundNotification_State);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSRSoundNotificationStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SR_SoundNotification_State);
   return oOut;
}

tBool mascf_mainfi_tclMsgSRSoundNotificationStateSet::operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SR_SoundNotification_State == roRef.SR_SoundNotification_State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgSRSoundNotificationStateStatus::mascf_mainfi_tclMsgSRSoundNotificationStateStatus(const mascf_mainfi_tclMsgSRSoundNotificationStateStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
}
mascf_mainfi_tclMsgSRSoundNotificationStateStatus& mascf_mainfi_tclMsgSRSoundNotificationStateStatus::operator=(const mascf_mainfi_tclMsgSRSoundNotificationStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgSRSoundNotificationStateStatus::mascf_mainfi_tclMsgSRSoundNotificationStateStatus()
:SR_SoundNotification_State(0)
 {}

tS32 mascf_mainfi_tclMsgSRSoundNotificationStateStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESTATUS;
}


mascf_mainfi_tclMsgSRSoundNotificationStateStatus::~mascf_mainfi_tclMsgSRSoundNotificationStateStatus()
{}

tU32 mascf_mainfi_tclMsgSRSoundNotificationStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgSRSoundNotificationStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SR_SoundNotification_State);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgSRSoundNotificationStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SR_SoundNotification_State);
   return oOut;
}

tBool mascf_mainfi_tclMsgSRSoundNotificationStateStatus::operator==(const mascf_mainfi_tclMsgSRSoundNotificationStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SR_SoundNotification_State == roRef.SR_SoundNotification_State);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgAudioPilotIntensityUpReg::mascf_mainfi_tclMsgAudioPilotIntensityUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotIntensityUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYUPREG;
}


mascf_mainfi_tclMsgAudioPilotIntensityUpReg::~mascf_mainfi_tclMsgAudioPilotIntensityUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg::mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYRELUPREG;
}


mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg::~mascf_mainfi_tclMsgAudioPilotIntensityRelUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgAudioPilotIntensityGet::mascf_mainfi_tclMsgAudioPilotIntensityGet()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotIntensityGet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYGET;
}


mascf_mainfi_tclMsgAudioPilotIntensityGet::~mascf_mainfi_tclMsgAudioPilotIntensityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioPilotIntensitySet::mascf_mainfi_tclMsgAudioPilotIntensitySet(const mascf_mainfi_tclMsgAudioPilotIntensitySet& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
}
mascf_mainfi_tclMsgAudioPilotIntensitySet& mascf_mainfi_tclMsgAudioPilotIntensitySet::operator=(const mascf_mainfi_tclMsgAudioPilotIntensitySet& coRef)
{
   if (this == &coRef) return *this;
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioPilotIntensitySet::mascf_mainfi_tclMsgAudioPilotIntensitySet()
:Audio_Pilot_Intensity()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotIntensitySet::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSET;
}


mascf_mainfi_tclMsgAudioPilotIntensitySet::~mascf_mainfi_tclMsgAudioPilotIntensitySet()
{}

tU32 mascf_mainfi_tclMsgAudioPilotIntensitySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioPilotIntensitySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Audio_Pilot_Intensity);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioPilotIntensitySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Audio_Pilot_Intensity);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioPilotIntensitySet::operator==(const mascf_mainfi_tclMsgAudioPilotIntensitySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Audio_Pilot_Intensity == roRef.Audio_Pilot_Intensity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgAudioPilotIntensityStatus::mascf_mainfi_tclMsgAudioPilotIntensityStatus(const mascf_mainfi_tclMsgAudioPilotIntensityStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
}
mascf_mainfi_tclMsgAudioPilotIntensityStatus& mascf_mainfi_tclMsgAudioPilotIntensityStatus::operator=(const mascf_mainfi_tclMsgAudioPilotIntensityStatus& coRef)
{
   if (this == &coRef) return *this;
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgAudioPilotIntensityStatus::mascf_mainfi_tclMsgAudioPilotIntensityStatus()
:Audio_Pilot_Intensity()
 {}

tS32 mascf_mainfi_tclMsgAudioPilotIntensityStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSTATUS;
}


mascf_mainfi_tclMsgAudioPilotIntensityStatus::~mascf_mainfi_tclMsgAudioPilotIntensityStatus()
{}

tU32 mascf_mainfi_tclMsgAudioPilotIntensityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgAudioPilotIntensityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Audio_Pilot_Intensity);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgAudioPilotIntensityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Audio_Pilot_Intensity);
   return oOut;
}

tBool mascf_mainfi_tclMsgAudioPilotIntensityStatus::operator==(const mascf_mainfi_tclMsgAudioPilotIntensityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Audio_Pilot_Intensity == roRef.Audio_Pilot_Intensity);
   return bResult;
}

//=============================================================================

mascf_mainfi_tclMsgMainAudioAttenuationUpReg::mascf_mainfi_tclMsgMainAudioAttenuationUpReg()
 {}

tS32 mascf_mainfi_tclMsgMainAudioAttenuationUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MAINAUDIOATTENUATIONUPREG;
}


mascf_mainfi_tclMsgMainAudioAttenuationUpReg::~mascf_mainfi_tclMsgMainAudioAttenuationUpReg()
{}

//=============================================================================

mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg::mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg()
 {}

tS32 mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MAINAUDIOATTENUATIONRELUPREG;
}


mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg::~mascf_mainfi_tclMsgMainAudioAttenuationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mascf_mainfi_tclMsgMainAudioAttenuationStatus::mascf_mainfi_tclMsgMainAudioAttenuationStatus(const mascf_mainfi_tclMsgMainAudioAttenuationStatus& coRef)
   : mascf_mainfi_tclMsgBaseMessage(coRef)
{
   Attenuation_Value = coRef.Attenuation_Value;
}
mascf_mainfi_tclMsgMainAudioAttenuationStatus& mascf_mainfi_tclMsgMainAudioAttenuationStatus::operator=(const mascf_mainfi_tclMsgMainAudioAttenuationStatus& coRef)
{
   if (this == &coRef) return *this;
   Attenuation_Value = coRef.Attenuation_Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mascf_mainfi_tclMsgMainAudioAttenuationStatus::mascf_mainfi_tclMsgMainAudioAttenuationStatus()
:Attenuation_Value(0)
 {}

tS32 mascf_mainfi_tclMsgMainAudioAttenuationStatus::s32GetTypeId() const
{
   return (tS32) mascf_mainfi_tclToken::EN_MSG_MAINAUDIOATTENUATIONSTATUS;
}


mascf_mainfi_tclMsgMainAudioAttenuationStatus::~mascf_mainfi_tclMsgMainAudioAttenuationStatus()
{}

tU32 mascf_mainfi_tclMsgMainAudioAttenuationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mascf_mainfi_tclMsgMainAudioAttenuationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Attenuation_Value);
   return oIn;
}

fi_tclOutContext& mascf_mainfi_tclMsgMainAudioAttenuationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Attenuation_Value);
   return oOut;
}

tBool mascf_mainfi_tclMsgMainAudioAttenuationStatus::operator==(const mascf_mainfi_tclMsgMainAudioAttenuationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Attenuation_Value == roRef.Attenuation_Value);
   return bResult;
}

