#ifndef LCMDBUSCLIENT_FIVISITOR_HEADER
#define LCMDBUSCLIENT_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class lcmdbusclient_fi_tclOutput {
public:
   lcmdbusclient_fi_tclOutput();
   virtual ~lcmdbusclient_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class lcmdbusclient_fi_tclFileOutput : public lcmdbusclient_fi_tclOutput 
{
public:
   lcmdbusclient_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   lcmdbusclient_fi_tclFileOutput(); //lint !e1704
   lcmdbusclient_fi_tclFileOutput& operator=(const lcmdbusclient_fi_tclFileOutput& coRef);
   lcmdbusclient_fi_tclFileOutput(const lcmdbusclient_fi_tclFileOutput& coRef); //lint !e1704
};

class lcmdbusclient_fi_tclMemOutput : public lcmdbusclient_fi_tclOutput
{
public:
   lcmdbusclient_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~lcmdbusclient_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   lcmdbusclient_fi_tclMemOutput(); //lint !e1704
   lcmdbusclient_fi_tclMemOutput(const lcmdbusclient_fi_tclMemOutput& coRef); //lint !e1704
   lcmdbusclient_fi_tclMemOutput& operator=(const lcmdbusclient_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL lcmdbusclient_fi_tclVisitorBase {
public:

   // --Konstruktor
   lcmdbusclient_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~lcmdbusclient_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(lcmdbusclient_fi_tclU8& oU8);
   virtual tVoid vVisitS8(lcmdbusclient_fi_tclS8& oS8);
   virtual tVoid vVisitU16(lcmdbusclient_fi_tclU16& oU16);
   virtual tVoid vVisitS16(lcmdbusclient_fi_tclS16& oS16);
   virtual tVoid vVisitU24(lcmdbusclient_fi_tclU24& oU24);
   virtual tVoid vVisitS24(lcmdbusclient_fi_tclS24& oS24);
   virtual tVoid vVisitU32(lcmdbusclient_fi_tclU32& oU32);
   virtual tVoid vVisitS32(lcmdbusclient_fi_tclS32& oS32);
   virtual tVoid vVisitU64(lcmdbusclient_fi_tclU64& oU64);
   virtual tVoid vVisitS64(lcmdbusclient_fi_tclS64& oS64);
   virtual tVoid vVisitF32(lcmdbusclient_fi_tclF32& oF32);
   virtual tVoid vVisitF64(lcmdbusclient_fi_tclF64& oF64);
   virtual tVoid vVisitBool(lcmdbusclient_fi_tclBool& oBool);
   virtual tVoid vVisitString(lcmdbusclient_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(lcmdbusclient_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(lcmdbusclient_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(lcmdbusclient_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(lcmdbusclient_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(lcmdbusclient_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(lcmdbusclient_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(lcmdbusclient_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(lcmdbusclient_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(lcmdbusclient_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(lcmdbusclient_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(lcmdbusclient_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(lcmdbusclient_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(lcmdbusclient_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(lcmdbusclient_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(lcmdbusclient_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(lcmdbusclient_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(lcmdbusclient_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(lcmdbusclient_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(lcmdbusclient_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(lcmdbusclient_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(lcmdbusclient_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(lcmdbusclient_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(lcmdbusclient_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(lcmdbusclient_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(lcmdbusclient_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(lcmdbusclient_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(lcmdbusclient_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(lcmdbusclient_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(lcmdbusclient_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(lcmdbusclient_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(lcmdbusclient_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(lcmdbusclient_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(lcmdbusclient_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(lcmdbusclient_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(lcmdbusclient_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(lcmdbusclient_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(lcmdbusclient_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(lcmdbusclient_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(lcmdbusclient_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(lcmdbusclient_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(lcmdbusclient_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(lcmdbusclient_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(lcmdbusclient_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(lcmdbusclient_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(lcmdbusclient_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(lcmdbusclient_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(lcmdbusclient_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(lcmdbusclient_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(lcmdbusclient_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisitheDevInfo(lcmdbusclient_fi_tclheDevInfo& oeDevInfo);

   virtual tVoid vVisitheSubsystemList(lcmdbusclient_fi_tclheSubsystemList& oeSubsystemList);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
