/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define LCMDBUSCLIENT_FI_S_IMPORT_INTERFACE_LCMDBUSCLIENT_MAINFI_TYPES
#define LCMDBUSCLIENT_FI_S_IMPORT_INTERFACE_LCMDBUSCLIENT_MAINFI_FUNCTIONIDS
#define LCMDBUSCLIENT_FI_S_IMPORT_INTERFACE_LCMDBUSCLIENT_MAINFI_SERVICEINFO
#include "lcmdbusclient_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for lcmdbusclient_main_fi message types

fi_tclMessageBase* lcmdbusclient_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCEGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgCurrentSourceGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCESTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgCurrentSourceStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgNanomsgStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgNanomsgStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgThermallevelStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgThermallevelStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSGET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSET:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet;

      case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSTATUS:
         return OSAL_NEW lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all lcmdbusclient_mainfifi messages

// common functions

tU16 lcmdbusclient_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return LCMDBUSCLIENT_MAINFI_C_U16_SERVICE_ID;
}

tU16 lcmdbusclient_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 lcmdbusclient_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& lcmdbusclient_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& lcmdbusclient_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 lcmdbusclient_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgCurrentSourceGet::lcmdbusclient_mainfi_tclMsgCurrentSourceGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgCurrentSourceGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCEGET;
}


lcmdbusclient_mainfi_tclMsgCurrentSourceGet::~lcmdbusclient_mainfi_tclMsgCurrentSourceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::lcmdbusclient_mainfi_tclMsgCurrentSourceStatus(const lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   strSourceName = coRef.strSourceName;
}
lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::operator=(const lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& coRef)
{
   if (this == &coRef) return *this;
   strSourceName = coRef.strSourceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::vDestroy()
{
   strSourceName.vDestroy();
}

lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::lcmdbusclient_mainfi_tclMsgCurrentSourceStatus()
:strSourceName()
 {}

tS32 lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCESTATUS;
}


lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::~lcmdbusclient_mainfi_tclMsgCurrentSourceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strSourceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strSourceName);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strSourceName);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgCurrentSourceStatus::operator==(const lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strSourceName == roRef.strSourceName);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgNanomsgStatusGet::lcmdbusclient_mainfi_tclMsgNanomsgStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgNanomsgStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSGET;
}


lcmdbusclient_mainfi_tclMsgNanomsgStatusGet::~lcmdbusclient_mainfi_tclMsgNanomsgStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::lcmdbusclient_mainfi_tclMsgNanomsgStatusSet(const lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Nanomsgconstate = coRef.Nanomsgconstate;
}
lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& coRef)
{
   if (this == &coRef) return *this;
   Nanomsgconstate = coRef.Nanomsgconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::lcmdbusclient_mainfi_tclMsgNanomsgStatusSet()
:Nanomsgconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSET;
}


lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::~lcmdbusclient_mainfi_tclMsgNanomsgStatusSet()
{}

tU32 lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Nanomsgconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Nanomsgconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgNanomsgStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgNanomsgStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Nanomsgconstate == roRef.Nanomsgconstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus(const lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Nanomsgconstate = coRef.Nanomsgconstate;
}
lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Nanomsgconstate = coRef.Nanomsgconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus()
:Nanomsgconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::~lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus()
{}

tU32 lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Nanomsgconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Nanomsgconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Nanomsgconstate == roRef.Nanomsgconstate);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet::lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSGET;
}


lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet::~lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Subsystemerrorconstate = coRef.Subsystemerrorconstate;
}
lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& coRef)
{
   if (this == &coRef) return *this;
   Subsystemerrorconstate = coRef.Subsystemerrorconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::vDestroy()
{
   Subsystemerrorconstate.vDestroy(); 
}

lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet()
:Subsystemerrorconstate()
 {}

tS32 lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSET;
}


lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::~lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Subsystemerrorconstate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Subsystemerrorconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Subsystemerrorconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Subsystemerrorconstate == roRef.Subsystemerrorconstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Subsystemerrorconstate = coRef.Subsystemerrorconstate;
}
lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Subsystemerrorconstate = coRef.Subsystemerrorconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::vDestroy()
{
   Subsystemerrorconstate.vDestroy(); 
}

lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus()
:Subsystemerrorconstate()
 {}

tS32 lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::~lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Subsystemerrorconstate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Subsystemerrorconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Subsystemerrorconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Subsystemerrorconstate == roRef.Subsystemerrorconstate);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet::lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSGET;
}


lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet::~lcmdbusclient_mainfi_tclMsgVoltagelevelStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Voltagelevelconstate = coRef.Voltagelevelconstate;
}
lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& coRef)
{
   if (this == &coRef) return *this;
   Voltagelevelconstate = coRef.Voltagelevelconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet()
:Voltagelevelconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSET;
}


lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::~lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet()
{}

tU32 lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Voltagelevelconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Voltagelevelconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Voltagelevelconstate == roRef.Voltagelevelconstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Voltagelevelconstate = coRef.Voltagelevelconstate;
}
lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Voltagelevelconstate = coRef.Voltagelevelconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus()
:Voltagelevelconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::~lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus()
{}

tU32 lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Voltagelevelconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Voltagelevelconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Voltagelevelconstate == roRef.Voltagelevelconstate);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet::lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSGET;
}


lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet::~lcmdbusclient_mainfi_tclMsgCockpitmodeStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Cockpitmodeconstate = coRef.Cockpitmodeconstate;
}
lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& coRef)
{
   if (this == &coRef) return *this;
   Cockpitmodeconstate = coRef.Cockpitmodeconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet()
:Cockpitmodeconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSET;
}


lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::~lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet()
{}

tU32 lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cockpitmodeconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cockpitmodeconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cockpitmodeconstate == roRef.Cockpitmodeconstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Cockpitmodeconstate = coRef.Cockpitmodeconstate;
}
lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Cockpitmodeconstate = coRef.Cockpitmodeconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus()
:Cockpitmodeconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::~lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus()
{}

tU32 lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cockpitmodeconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cockpitmodeconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cockpitmodeconstate == roRef.Cockpitmodeconstate);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgThermallevelStatusGet::lcmdbusclient_mainfi_tclMsgThermallevelStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgThermallevelStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSGET;
}


lcmdbusclient_mainfi_tclMsgThermallevelStatusGet::~lcmdbusclient_mainfi_tclMsgThermallevelStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::lcmdbusclient_mainfi_tclMsgThermallevelStatusSet(const lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Thermallevelconstate = coRef.Thermallevelconstate;
}
lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& coRef)
{
   if (this == &coRef) return *this;
   Thermallevelconstate = coRef.Thermallevelconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::lcmdbusclient_mainfi_tclMsgThermallevelStatusSet()
:Thermallevelconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSET;
}


lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::~lcmdbusclient_mainfi_tclMsgThermallevelStatusSet()
{}

tU32 lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Thermallevelconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Thermallevelconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgThermallevelStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgThermallevelStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Thermallevelconstate == roRef.Thermallevelconstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus(const lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   Thermallevelconstate = coRef.Thermallevelconstate;
}
lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Thermallevelconstate = coRef.Thermallevelconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus()
:Thermallevelconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::~lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus()
{}

tU32 lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Thermallevelconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Thermallevelconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Thermallevelconstate == roRef.Thermallevelconstate);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet::lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSGET;
}


lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet::~lcmdbusclient_mainfi_tclMsgDoorUnlockStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   DoorUnlockconstate = coRef.DoorUnlockconstate;
}
lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& coRef)
{
   if (this == &coRef) return *this;
   DoorUnlockconstate = coRef.DoorUnlockconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet()
:DoorUnlockconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSET;
}


lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::~lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet()
{}

tU32 lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DoorUnlockconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DoorUnlockconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DoorUnlockconstate == roRef.DoorUnlockconstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   DoorUnlockconstate = coRef.DoorUnlockconstate;
}
lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DoorUnlockconstate = coRef.DoorUnlockconstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus()
:DoorUnlockconstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::~lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus()
{}

tU32 lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DoorUnlockconstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DoorUnlockconstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DoorUnlockconstate == roRef.DoorUnlockconstate);
   return bResult;
}

//=============================================================================

lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet::lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet()
 {}

tS32 lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSGET;
}


lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet::~lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   PNMGRP10Signalstate = coRef.PNMGRP10Signalstate;
}
lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::operator=(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& coRef)
{
   if (this == &coRef) return *this;
   PNMGRP10Signalstate = coRef.PNMGRP10Signalstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet()
:PNMGRP10Signalstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSET;
}


lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::~lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet()
{}

tU32 lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PNMGRP10Signalstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PNMGRP10Signalstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet::operator==(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PNMGRP10Signalstate == roRef.PNMGRP10Signalstate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& coRef)
   : lcmdbusclient_mainfi_tclMsgBaseMessage(coRef)
{
   PNMGRP10Signalstate = coRef.PNMGRP10Signalstate;
}
lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::operator=(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   PNMGRP10Signalstate = coRef.PNMGRP10Signalstate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus()
:PNMGRP10Signalstate(0)
 {}

tS32 lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::s32GetTypeId() const
{
   return (tS32) lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSTATUS;
}


lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::~lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus()
{}

tU32 lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PNMGRP10Signalstate);
   return oIn;
}

fi_tclOutContext& lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PNMGRP10Signalstate);
   return oOut;
}

tBool lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus::operator==(const lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PNMGRP10Signalstate == roRef.PNMGRP10Signalstate);
   return bResult;
}

