#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define LCMDBUSCLIENT_FI_S_IMPORT_INTERFACE_LCMDBUSCLIENT_MAINFI_STDVISITORS
#include "lcmdbusclient_fi_gen_if.h"

tBool lcmdbusclient_mainfi_tclDescription::bInitMessage(lcmdbusclient_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case lcmdbusclient_mainfi_tclToken::EN_LAST_TOKEN:
   case lcmdbusclient_mainfi_tclToken::EN_LIST:
   case lcmdbusclient_mainfi_tclToken::EN_END_OF_STRUCT:
   case lcmdbusclient_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;
   // include the expansions for the messages
   case lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCESTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_STRING,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_STRSOURCENAME)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_BOOL,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_NANOMSGCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_BOOL,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_NANOMSGCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_ESUBSYSTEMLIST,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_SUBSYSTEMERRORCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_ESUBSYSTEMLIST,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_SUBSYSTEMERRORCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_VOLTAGELEVELCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_VOLTAGELEVELCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_COCKPITMODECONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_COCKPITMODECONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U16,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_THERMALLEVELCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U16,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_THERMALLEVELCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_BOOL,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_DOORUNLOCKCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_BOOL,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_DOORUNLOCKCONSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSET:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_PNMGRP10SIGNALSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_MSG_PNMGRP10SIGNALSTATE)) && bResult;
   } break;
   case lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCEGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSGET:
   case lcmdbusclient_mainfi_tclToken::EN_BINCONTAINER:
   case lcmdbusclient_mainfi_tclToken::EN_EDEVINFO:
   case lcmdbusclient_mainfi_tclToken::EN_ESUBSYSTEMLIST:
   case lcmdbusclient_mainfi_tclToken::EN_U8:   
   case lcmdbusclient_mainfi_tclToken::EN_S8:   
   case lcmdbusclient_mainfi_tclToken::EN_U16:   
   case lcmdbusclient_mainfi_tclToken::EN_S16:   
   case lcmdbusclient_mainfi_tclToken::EN_U24:   
   case lcmdbusclient_mainfi_tclToken::EN_S24:   
   case lcmdbusclient_mainfi_tclToken::EN_U32:   
   case lcmdbusclient_mainfi_tclToken::EN_S32:   
   case lcmdbusclient_mainfi_tclToken::EN_U64:   
   case lcmdbusclient_mainfi_tclToken::EN_S64:   
   case lcmdbusclient_mainfi_tclToken::EN_F32:   
   case lcmdbusclient_mainfi_tclToken::EN_F64:   
   case lcmdbusclient_mainfi_tclToken::EN_BOOL:   
   case lcmdbusclient_mainfi_tclToken::EN_STRING:   
   case lcmdbusclient_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(enMsgToken,lcmdbusclient_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool lcmdbusclient_mainfi_tclDescription::bDoIt(lcmdbusclient_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool lcmdbusclient_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      lcmdbusclient_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      lcmdbusclient_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      lcmdbusclient_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == lcmdbusclient_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(lcmdbusclient_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case lcmdbusclient_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == lcmdbusclient_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_LIST: 
      {
         lcmdbusclient_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            lcmdbusclient_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            lcmdbusclient_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_U8: 
      {
         lcmdbusclient_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_U16: 
      {
         lcmdbusclient_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_U24: 
      {
         lcmdbusclient_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_U32: 
      {
         lcmdbusclient_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_U64: 
      {
         lcmdbusclient_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_S8: 
      {
         lcmdbusclient_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_S16: 
      {
         lcmdbusclient_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_S24: 
      {
         lcmdbusclient_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_S32: 
      {
         lcmdbusclient_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_S64: 
      {
         lcmdbusclient_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_F32: 
      {
         lcmdbusclient_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_F64: 
      {
         lcmdbusclient_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_BOOL: 
      {
         lcmdbusclient_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_STRING: 
      {
         lcmdbusclient_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         lcmdbusclient_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCEGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_CURRENTSOURCESTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_NANOMSGSTATUSSTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_SUBSYSTEMERRORSTATUSSTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_VOLTAGELEVELSTATUSSTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_COCKPITMODESTATUSSTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_THERMALLEVELSTATUSSTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_DOORUNLOCKSTATUSSTATUS:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSGET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSET:
      case lcmdbusclient_mainfi_tclToken::EN_MSG_PNMGRP10SIGNALSTATUSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case lcmdbusclient_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_END_OF_STRUCT,lcmdbusclient_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_LIST,lcmdbusclient_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         lcmdbusclient_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_EDEVINFO:
      {
      if (poVisitor->bDoExpandheDevInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_END_OF_STRUCT,lcmdbusclient_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U16,lcmdbusclient_mainfi_tclSemanticDomain::EN_DEVERROR));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_DEVIP));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_U8,lcmdbusclient_mainfi_tclSemanticDomain::EN_DEVID));
      }
      else
      {
         lcmdbusclient_fi_tclheDevInfo oheDevInfo;
         if (!bDoIt(oheDevInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oheDevInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oheDevInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_ESUBSYSTEMLIST:
      {
      if (poVisitor->bDoExpandheSubsystemList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_END_OF_STRUCT,lcmdbusclient_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_EDEVINFO,lcmdbusclient_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(lcmdbusclient_mainfi_tclKnot(lcmdbusclient_mainfi_tclToken::EN_LIST,lcmdbusclient_mainfi_tclSemanticDomain::EN_SUBSYSTEMLIST));
      }
      else
      {
         lcmdbusclient_fi_tclheSubsystemList oheSubsystemList;
         if (!bDoIt(oheSubsystemList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oheSubsystemList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oheSubsystemList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcmdbusclient_mainfi_tclToken::EN_UNKNOWN:
      case lcmdbusclient_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

