/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef LCM_DBUSCTRLFITYPES_HEADER
#define LCM_DBUSCTRLFITYPES_HEADER


class lcm_dbusctrlfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for lcm_dbusctrl_fi message types

fi_tclMessageBase* lcm_dbusctrlfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class lcm_dbusctrlfi_tclMsgBaseMessage : public lcm_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   lcm_dbusctrlfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class lcm_dbusctrlfi_tclMsgStartProcessMethodStart : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStartProcessMethodStart& operator=(const lcm_dbusctrlfi_tclMsgStartProcessMethodStart& coRef);
   lcm_dbusctrlfi_tclMsgStartProcessMethodStart(const lcm_dbusctrlfi_tclMsgStartProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strLocation;
   tU32 u32Prio;
   tU32 u32Affinity;
   tU32 u32AffinityEnd;
   tU32 u32NiceLevel;
   tU32 u32NiceLevelEnd;
   lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type;
   tU32 u32Info;
   virtual ~lcm_dbusctrlfi_tclMsgStartProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStartProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartProcessMethodResult : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStartProcessMethodResult& operator=(const lcm_dbusctrlfi_tclMsgStartProcessMethodResult& coRef);
   lcm_dbusctrlfi_tclMsgStartProcessMethodResult(const lcm_dbusctrlfi_tclMsgStartProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   lcm_fi_tclString strLocation;
   tU32 u32ProcId;
   tU32 u32SpawnDuration;
   virtual ~lcm_dbusctrlfi_tclMsgStartProcessMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStartProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStopProcessMethodStart : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStopProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStopProcessMethodStart& operator=(const lcm_dbusctrlfi_tclMsgStopProcessMethodStart& coRef);
   lcm_dbusctrlfi_tclMsgStopProcessMethodStart(const lcm_dbusctrlfi_tclMsgStopProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strLocation;
   tU32 u32ProcId;
   virtual ~lcm_dbusctrlfi_tclMsgStopProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStopProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStopProcessMethodResult : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStopProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStopProcessMethodResult& operator=(const lcm_dbusctrlfi_tclMsgStopProcessMethodResult& coRef);
   lcm_dbusctrlfi_tclMsgStopProcessMethodResult(const lcm_dbusctrlfi_tclMsgStopProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~lcm_dbusctrlfi_tclMsgStopProcessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStopProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& operator=(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& coRef);
   lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam;
   virtual ~lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& operator=(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& coRef);
   lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& operator=(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& coRef);
   lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strServiceName;
   virtual ~lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult();

   virtual ~lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart();

   virtual ~lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult();

   virtual ~lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgRestartProcessMethodStart : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgRestartProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& operator=(const lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& coRef);
   lcm_dbusctrlfi_tclMsgRestartProcessMethodStart(const lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strLocation;
   tU32 u32ProcId;
   virtual ~lcm_dbusctrlfi_tclMsgRestartProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgRestartProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgRestartProcessMethodResult : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgRestartProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& operator=(const lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& coRef);
   lcm_dbusctrlfi_tclMsgRestartProcessMethodResult(const lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~lcm_dbusctrlfi_tclMsgRestartProcessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgRestartProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStartRequestUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStartRequestUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppStartRequestUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppStartRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppStartRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStartRequestGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStartRequestGet();

   virtual ~lcm_dbusctrlfi_tclMsgAppStartRequestGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppStartRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStartRequestStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStartRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgAppStartRequestStatus& operator=(const lcm_dbusctrlfi_tclMsgAppStartRequestStatus& coRef);
   lcm_dbusctrlfi_tclMsgAppStartRequestStatus(const lcm_dbusctrlfi_tclMsgAppStartRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strSwBlockName;
   lcm_fi_tclString strServiceName;
   tU32 u32AppId;
   virtual ~lcm_dbusctrlfi_tclMsgAppStartRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgAppStartRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppInitializedUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppInitializedUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppInitializedUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppInitializedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppInitializedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppInitializedGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppInitializedGet();

   virtual ~lcm_dbusctrlfi_tclMsgAppInitializedGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppInitializedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppInitializedStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppInitializedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgAppInitializedStatus& operator=(const lcm_dbusctrlfi_tclMsgAppInitializedStatus& coRef);
   lcm_dbusctrlfi_tclMsgAppInitializedStatus(const lcm_dbusctrlfi_tclMsgAppInitializedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppId;
   virtual ~lcm_dbusctrlfi_tclMsgAppInitializedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgAppInitializedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStateChangeUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStateChangeUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppStateChangeUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStateChangeGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStateChangeGet();

   virtual ~lcm_dbusctrlfi_tclMsgAppStateChangeGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStateChangeSet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStateChangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgAppStateChangeSet& operator=(const lcm_dbusctrlfi_tclMsgAppStateChangeSet& coRef);
   lcm_dbusctrlfi_tclMsgAppStateChangeSet(const lcm_dbusctrlfi_tclMsgAppStateChangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppId;
   tU32 u32State;
   virtual ~lcm_dbusctrlfi_tclMsgAppStateChangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppStateChangeStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppStateChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgAppStateChangeStatus& operator=(const lcm_dbusctrlfi_tclMsgAppStateChangeStatus& coRef);
   lcm_dbusctrlfi_tclMsgAppStateChangeStatus(const lcm_dbusctrlfi_tclMsgAppStateChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppId;
   tU32 u32State;
   virtual ~lcm_dbusctrlfi_tclMsgAppStateChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgAppStateChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppEndUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppEndUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppEndUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppEndUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppEndRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppEndRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgAppEndRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppEndRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppEndGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppEndGet();

   virtual ~lcm_dbusctrlfi_tclMsgAppEndGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgAppEndGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppEndSet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppEndSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgAppEndSet& operator=(const lcm_dbusctrlfi_tclMsgAppEndSet& coRef);
   lcm_dbusctrlfi_tclMsgAppEndSet(const lcm_dbusctrlfi_tclMsgAppEndSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppId;
   virtual ~lcm_dbusctrlfi_tclMsgAppEndSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgAppEndSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgAppEndStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgAppEndStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgAppEndStatus& operator=(const lcm_dbusctrlfi_tclMsgAppEndStatus& coRef);
   lcm_dbusctrlfi_tclMsgAppEndStatus(const lcm_dbusctrlfi_tclMsgAppEndStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AppId;
   virtual ~lcm_dbusctrlfi_tclMsgAppEndStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgAppEndStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgNewServiceLoadedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgNewServiceLoadedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewServiceLoadedGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewServiceLoadedGet();

   virtual ~lcm_dbusctrlfi_tclMsgNewServiceLoadedGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgNewServiceLoadedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& operator=(const lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& coRef);
   lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus(const lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strServiceName;
   lcm_fi_tclString strBlockName;
   tU32 u32AppId;
   virtual ~lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgFailedServicesListUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgFailedServicesListUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgFailedServicesListUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgFailedServicesListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgFailedServicesListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgFailedServicesListGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgFailedServicesListGet();

   virtual ~lcm_dbusctrlfi_tclMsgFailedServicesListGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgFailedServicesListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgFailedServicesListStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgFailedServicesListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgFailedServicesListStatus& operator=(const lcm_dbusctrlfi_tclMsgFailedServicesListStatus& coRef);
   lcm_dbusctrlfi_tclMsgFailedServicesListStatus(const lcm_dbusctrlfi_tclMsgFailedServicesListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tcl_SPM_ServiceList tServices;
   virtual ~lcm_dbusctrlfi_tclMsgFailedServicesListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgFailedServicesListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewProcessIdUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewProcessIdUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgNewProcessIdUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgNewProcessIdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgNewProcessIdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewProcessIdGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewProcessIdGet();

   virtual ~lcm_dbusctrlfi_tclMsgNewProcessIdGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgNewProcessIdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgNewProcessIdStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgNewProcessIdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgNewProcessIdStatus& operator=(const lcm_dbusctrlfi_tclMsgNewProcessIdStatus& coRef);
   lcm_dbusctrlfi_tclMsgNewProcessIdStatus(const lcm_dbusctrlfi_tclMsgNewProcessIdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tclString strBlockName;
   lcm_fi_tclString strServiceName;
   tU32 u32ProcessId;
   virtual ~lcm_dbusctrlfi_tclMsgNewProcessIdStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgNewProcessIdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet();

   virtual ~lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& operator=(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& coRef);
   lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   lcm_fi_tcl_StartupFailureInfo tStartupFailureInd;
   virtual ~lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg();

   virtual ~lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg();

   inline tBool operator==(const lcm_dbusctrlfi_tclMsgStartupFailureIndicationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& operator=(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& coRef);
   lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSupervisionActive;
   virtual ~lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus : public lcm_dbusctrlfi_tclMsgBaseMessage
{
public:

   lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& operator=(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& coRef);
   lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSupervisionActive;
   virtual ~lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
