#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_STDVISITORS
#include "lcm_fi_gen_if.h"

tBool lcm_dbusctrlfi_tclDescription::bInitMessage(lcm_dbusctrlfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case lcm_dbusctrlfi_tclToken::EN_LAST_TOKEN:
   case lcm_dbusctrlfi_tclToken::EN_LIST:
   case lcm_dbusctrlfi_tclToken::EN_END_OF_STRUCT:
   case lcm_dbusctrlfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;
   // include the expansions for the messages
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32INFO)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_E32_LCM_START_PROC_TYPE,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32TYPE)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32NICELEVELEND)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32NICELEVEL)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32AFFINITYEND)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32AFFINITY)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32PRIO)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32SPAWNDURATION)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32PROCID)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_S32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODSTART:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32PROCID)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_S32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODSTART:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_TYPE,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_ESTARTUPPARAM)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODRESULT:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_S32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODSTART:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRSERVICENAME)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32PROCID)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_S32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRSERVICENAME)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRSWBLOCKNAME)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESET:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32STATE)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32STATE)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSET:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32APPID)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRBLOCKNAME)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRSERVICENAME)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_SPM_SERVICELIST,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_TSERVICES)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_U32PROCESSID)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRSERVICENAME)) && bResult;
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_STRBLOCKNAME)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONSTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STARTUPFAILUREINFO,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_TSTARTUPFAILUREIND)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESET:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_BOOL,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_BSUPERVISIONACTIVE)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESTATUS:
   {
      bResult = oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_BOOL,lcm_dbusctrlfi_tclSemanticDomain::EN_MSG_BSUPERVISIONACTIVE)) && bResult;
   } break;
   case lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODRESULT:
   case lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODSTART:
   case lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODRESULT:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGERELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONGET:
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONRELUPREG:
   case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONUPREG:
   case lcm_dbusctrlfi_tclToken::EN_BINCONTAINER:
   case lcm_dbusctrlfi_tclToken::EN_E32_LCM_START_PROC_TYPE:
   case lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_FAILURE_TYPE:
   case lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_TYPE:
   case lcm_dbusctrlfi_tclToken::EN_SERVICEELEMENT:
   case lcm_dbusctrlfi_tclToken::EN_SPM_SERVICELIST:
   case lcm_dbusctrlfi_tclToken::EN_STARTUPFAILUREINFO:
   case lcm_dbusctrlfi_tclToken::EN_U8:   
   case lcm_dbusctrlfi_tclToken::EN_S8:   
   case lcm_dbusctrlfi_tclToken::EN_U16:   
   case lcm_dbusctrlfi_tclToken::EN_S16:   
   case lcm_dbusctrlfi_tclToken::EN_U24:   
   case lcm_dbusctrlfi_tclToken::EN_S24:   
   case lcm_dbusctrlfi_tclToken::EN_U32:   
   case lcm_dbusctrlfi_tclToken::EN_S32:   
   case lcm_dbusctrlfi_tclToken::EN_U64:   
   case lcm_dbusctrlfi_tclToken::EN_S64:   
   case lcm_dbusctrlfi_tclToken::EN_F32:   
   case lcm_dbusctrlfi_tclToken::EN_F64:   
   case lcm_dbusctrlfi_tclToken::EN_BOOL:   
   case lcm_dbusctrlfi_tclToken::EN_STRING:   
   case lcm_dbusctrlfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(enMsgToken,lcm_dbusctrlfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool lcm_dbusctrlfi_tclDescription::bDoIt(lcm_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool lcm_dbusctrlfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      lcm_dbusctrlfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      lcm_dbusctrlfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      lcm_dbusctrlfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == lcm_dbusctrlfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(lcm_dbusctrlfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case lcm_dbusctrlfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == lcm_dbusctrlfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_LIST: 
      {
         lcm_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            lcm_dbusctrlfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            lcm_dbusctrlfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case lcm_dbusctrlfi_tclToken::EN_U8: 
      {
         lcm_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case lcm_dbusctrlfi_tclToken::EN_U16: 
      {
         lcm_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_U24: 
      {
         lcm_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_U32: 
      {
         lcm_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_U64: 
      {
         lcm_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_S8: 
      {
         lcm_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_S16: 
      {
         lcm_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_S24: 
      {
         lcm_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_S32: 
      {
         lcm_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_S64: 
      {
         lcm_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_F32: 
      {
         lcm_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_F64: 
      {
         lcm_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_BOOL: 
      {
         lcm_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_STRING: 
      {
         lcm_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         lcm_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODSTART:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODSTART:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFINISHEDMETHODRESULT:
      case lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODSTART:
      case lcm_dbusctrlfi_tclToken::EN_MSG_GETPROCESSIDMETHODRESULT:
      case lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODSTART:
      case lcm_dbusctrlfi_tclToken::EN_MSG_TRIGGERGETUNITLISTMETHODRESULT:
      case lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART:
      case lcm_dbusctrlfi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTARTREQUESTSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPINITIALIZEDSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGERELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGEGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPSTATECHANGESTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_APPENDSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWSERVICELOADEDSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_FAILEDSERVICESLISTSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_NEWPROCESSIDSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONGET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONRELUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONSTATUS:
      case lcm_dbusctrlfi_tclToken::EN_MSG_STARTUPFAILUREINDICATIONUPREG:
      case lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESET:
      case lcm_dbusctrlfi_tclToken::EN_MSG_SUPERVISIONSTATECHANGESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case lcm_dbusctrlfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_END_OF_STRUCT,lcm_dbusctrlfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U8,lcm_dbusctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_LIST,lcm_dbusctrlfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         lcm_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcm_dbusctrlfi_tclToken::EN_E32_LCM_START_PROC_TYPE:
      {
         lcm_fi_tcl_e32_LCM_START_PROC_TYPE o_e32_LCM_START_PROC_TYPE;
         if (!bDoIt(o_e32_LCM_START_PROC_TYPE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_FAILURE_TYPE:
      {
         lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE o_e32_LCM_STARTUP_FAILURE_TYPE;
         if (!bDoIt(o_e32_LCM_STARTUP_FAILURE_TYPE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_TYPE:
      {
         lcm_fi_tcl_e32_LCM_STARTUP_TYPE o_e32_LCM_STARTUP_TYPE;
         if (!bDoIt(o_e32_LCM_STARTUP_TYPE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case lcm_dbusctrlfi_tclToken::EN_SERVICEELEMENT:
      {
      if (poVisitor->bDoExpand_ServiceElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_END_OF_STRUCT,lcm_dbusctrlfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_TFOLLOWER));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_TSUBSTATE));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_TACTIVESTATE));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_TLOADSTATE));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_TDESCRIPTION));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_STRING,lcm_dbusctrlfi_tclSemanticDomain::EN_TUNITNAME));
      }
      else
      {
         lcm_fi_tcl_ServiceElement o_ServiceElement;
         if (!bDoIt(o_ServiceElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ServiceElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcm_dbusctrlfi_tclToken::EN_SPM_SERVICELIST:
      {
      if (poVisitor->bDoExpand_SPM_ServiceList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_END_OF_STRUCT,lcm_dbusctrlfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_SERVICEELEMENT,lcm_dbusctrlfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_LIST,lcm_dbusctrlfi_tclSemanticDomain::EN_TSERVICES));
      }
      else
      {
         lcm_fi_tcl_SPM_ServiceList o_SPM_ServiceList;
         if (!bDoIt(o_SPM_ServiceList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_ServiceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_ServiceList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcm_dbusctrlfi_tclToken::EN_STARTUPFAILUREINFO:
      {
      if (poVisitor->bDoExpand_StartupFailureInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_END_OF_STRUCT,lcm_dbusctrlfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_U32,lcm_dbusctrlfi_tclSemanticDomain::EN_U32DATA));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_TYPE,lcm_dbusctrlfi_tclSemanticDomain::EN_TSTATE));
         (tVoid) oPath.bGoDown(lcm_dbusctrlfi_tclKnot(lcm_dbusctrlfi_tclToken::EN_E32_LCM_STARTUP_FAILURE_TYPE,lcm_dbusctrlfi_tclSemanticDomain::EN_TFAILURE));
      }
      else
      {
         lcm_fi_tcl_StartupFailureInfo o_StartupFailureInfo;
         if (!bDoIt(o_StartupFailureInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StartupFailureInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StartupFailureInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case lcm_dbusctrlfi_tclToken::EN_UNKNOWN:
      case lcm_dbusctrlfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

