#ifndef INPUT_FIVISITOR_HEADER
#define INPUT_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class input_fi_tclOutput {
public:
   input_fi_tclOutput();
   virtual ~input_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class input_fi_tclFileOutput : public input_fi_tclOutput 
{
public:
   input_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   input_fi_tclFileOutput(); //lint !e1704
   input_fi_tclFileOutput& operator=(const input_fi_tclFileOutput& coRef);
   input_fi_tclFileOutput(const input_fi_tclFileOutput& coRef); //lint !e1704
};

class input_fi_tclMemOutput : public input_fi_tclOutput
{
public:
   input_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~input_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   input_fi_tclMemOutput(); //lint !e1704
   input_fi_tclMemOutput(const input_fi_tclMemOutput& coRef); //lint !e1704
   input_fi_tclMemOutput& operator=(const input_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL input_fi_tclVisitorBase {
public:

   // --Konstruktor
   input_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~input_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(input_fi_tclU8& oU8);
   virtual tVoid vVisitS8(input_fi_tclS8& oS8);
   virtual tVoid vVisitU16(input_fi_tclU16& oU16);
   virtual tVoid vVisitS16(input_fi_tclS16& oS16);
   virtual tVoid vVisitU24(input_fi_tclU24& oU24);
   virtual tVoid vVisitS24(input_fi_tclS24& oS24);
   virtual tVoid vVisitU32(input_fi_tclU32& oU32);
   virtual tVoid vVisitS32(input_fi_tclS32& oS32);
   virtual tVoid vVisitU64(input_fi_tclU64& oU64);
   virtual tVoid vVisitS64(input_fi_tclS64& oS64);
   virtual tVoid vVisitF32(input_fi_tclF32& oF32);
   virtual tVoid vVisitF64(input_fi_tclF64& oF64);
   virtual tVoid vVisitBool(input_fi_tclBool& oBool);
   virtual tVoid vVisitString(input_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(input_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(input_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(input_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(input_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(input_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(input_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(input_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(input_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(input_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(input_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(input_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(input_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(input_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(input_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(input_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(input_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(input_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(input_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(input_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(input_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(input_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(input_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(input_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(input_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(input_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(input_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(input_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(input_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(input_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(input_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(input_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(input_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(input_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(input_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(input_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(input_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(input_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(input_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(input_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(input_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(input_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(input_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(input_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(input_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(input_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(input_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(input_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(input_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(input_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e16_KeyCode(input_fi_tcl_e16_KeyCode& oe16_KeyCode);

   virtual tVoid vVisit_KeyInfo(input_fi_tcl_KeyInfo& oKeyInfo);

   virtual tVoid vVisit_e8_EncoderType(input_fi_tcl_e8_EncoderType& oe8_EncoderType);

   virtual tVoid vVisit_e8_TouchStatus(input_fi_tcl_e8_TouchStatus& oe8_TouchStatus);

   virtual tVoid vVisit_EncInfo(input_fi_tcl_EncInfo& oEncInfo);

   virtual tVoid vVisit_EncoderDirectionList(input_fi_tcl_EncoderDirectionList& oEncoderDirectionList);

   virtual tVoid vVisit_EncoderStatus(input_fi_tcl_EncoderStatus& oEncoderStatus);

   virtual tVoid vVisit_DiagKeyList(input_fi_tcl_DiagKeyList& oDiagKeyList);

   virtual tVoid vVisit_TouchInfo(input_fi_tcl_TouchInfo& oTouchInfo);

   virtual tVoid vVisit_TouchDataList(input_fi_tcl_TouchDataList& oTouchDataList);

   virtual tVoid vVisit_e8_DeviceConnectStatus(input_fi_tcl_e8_DeviceConnectStatus& oe8_DeviceConnectStatus);

   virtual tVoid vVisit_e8_Device(input_fi_tcl_e8_Device& oe8_Device);

   virtual tVoid vVisit_DevManager_DeviceProperty(input_fi_tcl_DevManager_DeviceProperty& oDevManager_DeviceProperty);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
