/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef INPUT_ALLFITYPES_HEADER
#define INPUT_ALLFITYPES_HEADER

#include <vector>

class input_fi_tclVisitorBase;

const tU16 INPUT_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 INPUT_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 INPUT_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class input_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  input_fi_tclTypeBase() {}
  virtual ~input_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& /*oVisitor*/) {}
};

class input_fi_tclVisitableTypeBase :public input_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(input_fi_tclVisitorBase& /*oVisitor*/) {}
};

class input_fi_tclU8 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_U8;}
};

class input_fi_tclS8 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_S8;}
};

class input_fi_tclU16 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_U16;}
};

class input_fi_tclS16 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_S16;}
};

class input_fi_tclU24 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_U24;}
};

class input_fi_tclS24 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_S24;}
};

class input_fi_tclU32 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_U32;}
};

class input_fi_tclS32 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_S32;}
};

class input_fi_tclU64 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_U64;}
};

class input_fi_tclS64 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_S64;}
};

class input_fi_tclF32 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_F32;}
};

class input_fi_tclF64 : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_F64;}
};

class input_fi_tclBool : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const input_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_BOOL;}
};

class input_fi_tclString : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tclString(const input_fi_tclString& coRef);
   input_fi_tclString& operator=(const input_fi_tclString& coRef);
   virtual ~input_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const input_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   input_fi_tclString& operator=(tCString coszString); // ADDED
   input_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const input_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class input_fi_tclList : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const input_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_LIST;}
};

class input_fi_tclMultiLanguageString : public input_fi_tclVisitableTypeBase
{
public:
   input_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tclMultiLanguageString(const input_fi_tclMultiLanguageString& coRef);
   input_fi_tclMultiLanguageString& operator=(const input_fi_tclMultiLanguageString& coRef);
   virtual ~input_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const input_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(input_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   input_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   input_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return input_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const input_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class input_fi_tcl_BinContainer;
class input_fi_tcl_Reserved;
class input_fi_tcl_u8_Percent;
class input_fi_tcl_s16_PerThousand;
class input_fi_tcl_u16_IndexInReferenceList;
class input_fi_tcl_u16_ErrorCode;
class input_fi_tcl_u16_RPM;
class input_fi_tcl_s32_Kilogram;
class input_fi_tcl_s32_Pound;
class input_fi_tcl_s16_Meter;
class input_fi_tcl_s32_Meter;
class input_fi_tcl_s32_Yards;
class input_fi_tcl_s32_Foot;
class input_fi_tcl_s32_Centimeter;
class input_fi_tcl_s32_Inch;
class input_fi_tcl_s32_Millimeter;
class input_fi_tcl_s32_Microliter;
class input_fi_tcl_s32_Second;
class input_fi_tcl_u16_MilliSecond;
class input_fi_tcl_s32_MilliSecond;
class input_fi_tcl_POSIXTime;
class input_fi_tcl_e8_DST_State;
class input_fi_tcl_TimeZoneElement;
class input_fi_tcl_s16_KmPerHour;
class input_fi_tcl_s16_MilesPerHour;
class input_fi_tcl_s16_Knot;
class input_fi_tcl_s16_CentimeterSecond;
class input_fi_tcl_s16_Kelvin;
class input_fi_tcl_s16_Fahrenheit;
class input_fi_tcl_s32_Pascal;
class input_fi_tcl_s32_Watt;
class input_fi_tcl_FIVersion;
class input_fi_tcl_s32_Longitude;
class input_fi_tcl_s32_Latitude;
class input_fi_tcl_PositionWGS84;
class input_fi_tcl_RectangleWGS84;
class input_fi_tcl_e16_ISOCountryCode;
class input_fi_tcl_e16_ISOLanguageCode;
class input_fi_tcl_LanguageID;
class input_fi_tcl_u8_DirectionAbsolute;
class input_fi_tcl_u8_DirectionRelative;
class input_fi_tcl_s16_CentiDegree;
class input_fi_tcl_s16_Degree;
class input_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class input_fi_tcl_s16_DirectionRelative_CentiDegree;
class input_fi_tcl_e8_FuelType;
class input_fi_tcl_DistTimeFuel;
class input_fi_tcl_e16_KeyCode;
class input_fi_tcl_KeyInfo;
class input_fi_tcl_e8_EncoderType;
class input_fi_tcl_e8_TouchStatus;
class input_fi_tcl_EncInfo;
class input_fi_tcl_EncoderDirectionList;
class input_fi_tcl_EncoderStatus;
class input_fi_tcl_DiagKeyList;
class input_fi_tcl_TouchInfo;
class input_fi_tcl_TouchDataList;
class input_fi_tcl_e8_DeviceConnectStatus;
class input_fi_tcl_e8_Device;
class input_fi_tcl_DevManager_DeviceProperty;
class input_fi_tcl_BinContainer : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_BinContainer& operator=(const input_fi_tcl_BinContainer& coRef);
   input_fi_tcl_BinContainer(const input_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~input_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_Reserved : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_Reserved();

   virtual ~input_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u8_Percent : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~input_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_PerThousand : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u16_IndexInReferenceList : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~input_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u16_ErrorCode : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~input_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u16_RPM : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~input_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Kilogram : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Pound : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_Meter : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Meter : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Yards : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Foot : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Centimeter : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Inch : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Millimeter : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Microliter : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Second : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u16_MilliSecond : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~input_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_MilliSecond : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_POSIXTime : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_POSIXTime& operator=(const input_fi_tcl_POSIXTime& coRef);
   input_fi_tcl_POSIXTime(const input_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~input_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e8_DST_State : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   input_fi_tcl_e8_DST_State(input_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_TimeZoneElement : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_TimeZoneElement& operator=(const input_fi_tcl_TimeZoneElement& coRef);
   input_fi_tcl_TimeZoneElement(const input_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tclMultiLanguageString Abbreviation_StandardTime;
   input_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   input_fi_tcl_s32_Second TimeZoneDifference;
   input_fi_tcl_e8_DST_State DST_State;
   input_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~input_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_KmPerHour : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_MilesPerHour : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_Knot : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_CentimeterSecond : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_Kelvin : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_Fahrenheit : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Pascal : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Watt : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_FIVersion : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_FIVersion& operator=(const input_fi_tcl_FIVersion& coRef);
   input_fi_tcl_FIVersion(const input_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~input_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Longitude : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s32_Latitude : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~input_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_PositionWGS84 : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_PositionWGS84& operator=(const input_fi_tcl_PositionWGS84& coRef);
   input_fi_tcl_PositionWGS84(const input_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_s32_Longitude Longitude;
   input_fi_tcl_s32_Latitude Latitude;
   virtual ~input_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_RectangleWGS84 : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_RectangleWGS84& operator=(const input_fi_tcl_RectangleWGS84& coRef);
   input_fi_tcl_RectangleWGS84(const input_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_s32_Longitude LongitudeMin;
   input_fi_tcl_s32_Latitude LatitudeMin;
   input_fi_tcl_s32_Longitude LongitudeMax;
   input_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~input_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e16_ISOCountryCode : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   input_fi_tcl_e16_ISOCountryCode(input_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e16_ISOLanguageCode : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   input_fi_tcl_e16_ISOLanguageCode(input_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_LanguageID : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_LanguageID& operator=(const input_fi_tcl_LanguageID& coRef);
   input_fi_tcl_LanguageID(const input_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   input_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~input_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u8_DirectionAbsolute : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~input_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u8_DirectionRelative : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~input_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_CentiDegree : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_Degree : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_u16_DirectionAbsolute_CentiDegree : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~input_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_s16_DirectionRelative_CentiDegree : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~input_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e8_FuelType : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   input_fi_tcl_e8_FuelType(input_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_DistTimeFuel : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_DistTimeFuel& operator=(const input_fi_tcl_DistTimeFuel& coRef);
   input_fi_tcl_DistTimeFuel(const input_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_s32_Meter Distance;
   input_fi_tcl_s32_Second Time;
   input_fi_tcl_s32_Microliter Fuel;
   virtual ~input_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e16_KeyCode : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e16_KeyCode();
   enum tenType {
      FI_EN_INPUT_HK_APP = 787UL,
      FI_EN_INPUT_HK_AUDIO = 788UL,
      FI_EN_INPUT_HK_AUX = 771UL,
      FI_EN_INPUT_HK_BACK = 778UL,
      FI_EN_INPUT_HK_CAMERA = 770UL,
      FI_EN_INPUT_HK_CD = 769UL,
      FI_EN_INPUT_HK_DAY_NIGHT_LONG = 724UL,
      FI_EN_INPUT_HK_DAY_NIGHT = 779UL,
      FI_EN_INPUT_HK_DISP = 789UL,
      FI_EN_INPUT_HK_ELECTRO_VEHICLE = 795UL,
      FI_EN_INPUT_HK_ENTER = 781UL,
      FI_EN_INPUT_HK_FM_AM = 785UL,
      FI_EN_INPUT_HK_FOLDER_NEXT = 796UL,
      FI_EN_INPUT_HK_FOLDER_PREV = 797UL,
      FI_EN_INPUT_HK_MUTE = 798UL,
      FI_EN_INPUT_HK_PIVI_CLIMATE = 799UL,
      FI_EN_INPUT_HK_MEX = 800UL,
      FI_EN_INPUT_HK_HOME_LONG = 723UL,
      FI_EN_INPUT_HK_HOME = 793UL,
      FI_EN_INPUT_HK_INFO = 775UL,
      FI_EN_INPUT_HK_MAP = 777UL,
      FI_EN_INPUT_HK_MENU_LONG = 720UL,
      FI_EN_INPUT_HK_MENU = 786UL,
      FI_EN_INPUT_HK_NAV = 780UL,
      FI_EN_INPUT_HK_NEXT = 773UL,
      FI_EN_INPUT_HK_PHONE = 768UL,
      FI_EN_INPUT_HK_PREV = 772UL,
      FI_EN_INPUT_HK_RADIO = 774UL,
      FI_EN_INPUT_HK_SETUP_LONG = 721UL,
      FI_EN_INPUT_HK_SETUP = 776UL,
      FI_EN_INPUT_HK_VIRT_SRV_TEST = 928UL,
      FI_EN_INPUT_HK_VIRT_VOL_COMBI = 929UL,
      FI_EN_INPUT_HK_VOLUME_DOWN = 791UL,
      FI_EN_INPUT_HK_VOLUME_UP = 790UL,
      FI_EN_INPUT_HK_VOLUME = 792UL,
      FI_EN_INPUT_HK_XM = 782UL,
      FI_EN_INPUT_HVAC_MEX = 930UL,
      FI_EN_INPUT_HVAC_SEAT = 931UL,
      FI_EN_INPUT_JOYSTICK_BACK_LONGPRESS = 946UL,
      FI_EN_INPUT_JOYSTICK_BACK = 972UL,
      FI_EN_INPUT_JOYSTICK_DAY_NIGHT = 973UL,
      FI_EN_INPUT_JOYSTICK_DISP = 974UL,
      FI_EN_INPUT_JOYSTICK_DOWN = 961UL,
      FI_EN_INPUT_JOYSTICK_ENTER_LONGPRESS = 947UL,
      FI_EN_INPUT_JOYSTICK_ENTER = 968UL,
      FI_EN_INPUT_JOYSTICK_HOME_LONGPRESS = 945UL,
      FI_EN_INPUT_JOYSTICK_HOME = 971UL,
      FI_EN_INPUT_JOYSTICK_LEFT = 962UL,
      FI_EN_INPUT_JOYSTICK_LOWER_LEFT = 966UL,
      FI_EN_INPUT_JOYSTICK_LOWER_RIGHT = 967UL,
      FI_EN_INPUT_JOYSTICK_MAP = 969UL,
      FI_EN_INPUT_JOYSTICK_OPTION_LONGPRESS = 944UL,
      FI_EN_INPUT_JOYSTICK_OPTION = 970UL,
      FI_EN_INPUT_JOYSTICK_RIGHT = 963UL,
      FI_EN_INPUT_JOYSTICK_UPPER_LEFT = 964UL,
      FI_EN_INPUT_JOYSTICK_UPPER_RIGHT = 965UL,
      FI_EN_INPUT_JOYSTICK_UP = 960UL,
      FI_EN_INPUT_SWC_AUDIO_SRC_DOWN = 115UL,
      FI_EN_INPUT_SWC_AUDIO_SRC_UP = 114UL,
      FI_EN_INPUT_SWC_BACK = 109UL,
      FI_EN_INPUT_SWC_DOWN = 112UL,
      FI_EN_INPUT_SWC_ENTER = 117UL,
      FI_EN_INPUT_SWC_LEFT = 118UL,
      FI_EN_INPUT_SWC_MODE = 100UL,
      FI_EN_INPUT_SWC_MUTE = 113UL,
      FI_EN_INPUT_SWC_OK = 101UL,
      FI_EN_INPUT_SWC_RADIO = 116UL,
      FI_EN_INPUT_SWC_RIGHT = 119UL,
      FI_EN_INPUT_SWC_PHONE_MUTE_DUO = 120UL,
      FI_EN_INPUT_SWC_SEEK_DOWN = 103UL,
      FI_EN_INPUT_SWC_SEEK_UP = 102UL,
      FI_EN_INPUT_SWC_TEL_HANG_UP = 108UL,
      FI_EN_INPUT_SWC_TEL_VR = 104UL,
      FI_EN_INPUT_SWC_UP = 111UL,
      FI_EN_INPUT_SWC_VOL_DOWN = 106UL,
      FI_EN_INPUT_SWC_VOL_UP = 107UL,
      FI_EN_INPUT_SYS_KEY_EJECT = 784UL,
      FI_EN_INPUT_SYS_KEY_POWER_LONG = 722UL,
      FI_EN_INPUT_SYS_KEY_POWER = 783UL,
      FI_EN_INPUT_SYS_KEY_RSC_ON_OFF = 794UL,
      FI_EN_INPUT_INF4CV_MCP_HOME_COCKPIT = 975UL,
      FI_EN_INPUT_INF4CV_MCP_SRC_COCKPIT = 976UL,
      FI_EN_INPUT_INF4CV_MCP_NAV = 977UL,
      FI_EN_INPUT_INF4CV_MCP_MAP = 978UL,
      FI_EN_INPUT_INF4CV_MCP_SRC_CABIN = 979UL,
      FI_EN_INPUT_INF4CV_MCP_HOME_CABIN = 980UL,
      FI_EN_INPUT_INF4CV_MCP_SET_COCKPIT = 981UL,
      FI_EN_INPUT_INF4CV_MCP_CAM = 982UL,
      FI_EN_INPUT_INF4CV_MCP_PHONE_ACCEPT = 983UL,
      FI_EN_INPUT_INF4CV_MCP_PHONE_REJECT = 984UL,
      FI_EN_INPUT_INF4CV_MCP_MON = 985UL,
      FI_EN_INPUT_INF4CV_MCP_SET_CABIN = 986UL,
      FI_EN_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_COCKPIT = 987UL,
      FI_EN_INPUT_ENCODER_KEY_INF4CV_VOLUMEBUTTON_CABIN = 988UL
   };
   tenType enType;

   input_fi_tcl_e16_KeyCode(input_fi_tcl_e16_KeyCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e16_KeyCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e16_KeyCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_KeyInfo : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_KeyInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_KeyInfo& operator=(const input_fi_tcl_KeyInfo& coRef);
   input_fi_tcl_KeyInfo(const input_fi_tcl_KeyInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e16_KeyCode e16KeyCode;
   tU8 u8KeyStatus;
   virtual ~input_fi_tcl_KeyInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_KeyInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e8_EncoderType : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e8_EncoderType();
   enum tenType {
      FI_EN_LEFT_ENCODER = 6UL,
      FI_EN_RIGHT_ENCODER = 8UL,
      FI_EN_MSMENCODER = 7UL,
      FI_EN_JOYSTICK_ENCODER = 3UL,
      FI_EN_SWRCENCODER = 9UL
   };
   tenType enType;

   input_fi_tcl_e8_EncoderType(input_fi_tcl_e8_EncoderType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e8_EncoderType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e8_EncoderType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e8_TouchStatus : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e8_TouchStatus();
   enum tenType {
      FI_EN_TOUCH_INVALID = 2UL,
      FI_EN_TOUCH_PRESSED = 1UL,
      FI_EN_TOUCH_RELEASED = 0UL
   };
   tenType enType;

   input_fi_tcl_e8_TouchStatus(input_fi_tcl_e8_TouchStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e8_TouchStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e8_TouchStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_EncInfo : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_EncInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_EncInfo& operator=(const input_fi_tcl_EncInfo& coRef);
   input_fi_tcl_EncInfo(const input_fi_tcl_EncInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e8_EncoderType e8EncoderType;
   tS8 s8EncSteps;
   virtual ~input_fi_tcl_EncInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_EncInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_EncoderDirectionList : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_EncoderDirectionList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_EncoderDirectionList& operator=(const input_fi_tcl_EncoderDirectionList& coRef);
   input_fi_tcl_EncoderDirectionList(const input_fi_tcl_EncoderDirectionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<input_fi_tcl_EncInfo, std::allocator<input_fi_tcl_EncInfo> > tEncInfoList;
   virtual ~input_fi_tcl_EncoderDirectionList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_EncoderDirectionList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_EncoderStatus : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_EncoderStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_EncoderStatus& operator=(const input_fi_tcl_EncoderStatus& coRef);
   input_fi_tcl_EncoderStatus(const input_fi_tcl_EncoderStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 s8EncVal_1;
   tS8 s8EncVal_2;
   tS8 s8EncVal_3;
   tS8 s8EncVal_4;
   tS8 s8EncVal_5;
   virtual ~input_fi_tcl_EncoderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_EncoderStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_DiagKeyList : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_DiagKeyList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_DiagKeyList& operator=(const input_fi_tcl_DiagKeyList& coRef);
   input_fi_tcl_DiagKeyList(const input_fi_tcl_DiagKeyList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<input_fi_tcl_KeyInfo, std::allocator<input_fi_tcl_KeyInfo> > tKeyInfoList;
   virtual ~input_fi_tcl_DiagKeyList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_DiagKeyList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_TouchInfo : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_TouchInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_TouchInfo& operator=(const input_fi_tcl_TouchInfo& coRef);
   input_fi_tcl_TouchInfo(const input_fi_tcl_TouchInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e8_TouchStatus e8TouchStatus;
   tS32 s32XCoord;
   tS32 s32YCoord;
   virtual ~input_fi_tcl_TouchInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_TouchInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_TouchDataList : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_TouchDataList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_TouchDataList& operator=(const input_fi_tcl_TouchDataList& coRef);
   input_fi_tcl_TouchDataList(const input_fi_tcl_TouchDataList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<input_fi_tcl_TouchInfo, std::allocator<input_fi_tcl_TouchInfo> > sTouchInfo;
   virtual ~input_fi_tcl_TouchDataList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_TouchDataList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e8_DeviceConnectStatus : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e8_DeviceConnectStatus();
   enum tenType {
      FI_EN_USB_DEV_CONNECTED = 2UL,
      FI_EN_USB_DEV_REMOVED_BY_USR = 3UL,
      FI_EN_USB_DEV_UNAVAIL_BAT_LOWVOLT = 4UL,
      FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT = 6UL,
      FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC = 5UL,
      FI_EN_USB_DEV_UNAVAIL_OVERTEMP = 7UL,
      FI_EN_USB_DEV_UNDEFINED = 0UL,
      FI_EN_USB_DEV_WARNING = 1UL
   };
   tenType enType;

   input_fi_tcl_e8_DeviceConnectStatus(input_fi_tcl_e8_DeviceConnectStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e8_DeviceConnectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e8_DeviceConnectStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_e8_Device : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_e8_Device();
   enum tenType {
      FI_EN_DTY_BTA = 13UL,
      FI_EN_DTY_CDDA = 14UL,
      FI_EN_DTY_CDROM = 7UL,
      FI_EN_DTY_DIGITALAUX = 12UL,
      FI_EN_DTY_DVD_DRIVE = 15UL,
      FI_EN_DTY_HUB = 11UL,
      FI_EN_DTY_IPAD = 8UL,
      FI_EN_DTY_IPHONE = 4UL,
      FI_EN_DTY_IPOD = 3UL,
      FI_EN_DTY_MSZUNE = 6UL,
      FI_EN_DTY_MTP = 5UL,
      FI_EN_DTY_NOT_SUPPORTED = 10UL,
      FI_EN_DTY_SDCARD_INTERNAL = 9UL,
      FI_EN_DTY_SDCARD = 2UL,
      FI_EN_DTY_UNKNOWN = 0UL,
      FI_EN_DTY_USB = 1UL
   };
   tenType enType;

   input_fi_tcl_e8_Device(input_fi_tcl_e8_Device::tenType newValue)
      :enType(newValue)
   {}

   virtual ~input_fi_tcl_e8_Device();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const input_fi_tcl_e8_Device& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

class input_fi_tcl_DevManager_DeviceProperty : public input_fi_tclVisitableTypeBase
{
public:

   input_fi_tcl_DevManager_DeviceProperty();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   input_fi_tcl_DevManager_DeviceProperty& operator=(const input_fi_tcl_DevManager_DeviceProperty& coRef);
   input_fi_tcl_DevManager_DeviceProperty(const input_fi_tcl_DevManager_DeviceProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   input_fi_tcl_e8_DeviceConnectStatus DeviceConnectStatus;
   input_fi_tcl_e8_Device DeviceType;
   input_fi_tclString DeviceName;
   virtual ~input_fi_tcl_DevManager_DeviceProperty();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const input_fi_tcl_DevManager_DeviceProperty& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(input_fi_tclVisitorBase& rfoVisitor);
};

#endif
