/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_TYPES
#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_FUNCTIONIDS
#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_SERVICEINFO
#include "input_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for input_main_fi message types

fi_tclMessageBase* input_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgEnableInputEventsMethodStart;

      case input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgEnableInputEventsMethodResult;

      case input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgDisableInputEventsMethodStart;

      case input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgDisableInputEventsMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulateKeyInjectionMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulateKeyInjectionMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulateEncRotationMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulateEncRotationMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulateSingleTouchMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulateSingleTouchMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulateTouchSlideMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulateTouchSlideMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulateMultiTouchMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulateMultiTouchMethodResult;

      case input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgGestureRecordMethodStart;

      case input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgGestureRecordMethodResult;

      case input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgGestureReplayMethodStart;

      case input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgGestureReplayMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulatePIVITouchMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulatePIVITouchMethodResult;

      case input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgDevInputNotifyConnectionMethodStart;

      case input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgDevInputNotifyConnectionMethodResult;

      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODSTART:
         return OSAL_NEW input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart;

      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODRESULT:
         return OSAL_NEW input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult;

      case input_mainfi_tclToken::EN_MSG_PRESSEDKEYSGET:
         return OSAL_NEW input_mainfi_tclMsgPressedKeysGet;

      case input_mainfi_tclToken::EN_MSG_PRESSEDKEYSSTATUS:
         return OSAL_NEW input_mainfi_tclMsgPressedKeysStatus;

      case input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSGET:
         return OSAL_NEW input_mainfi_tclMsgEncoderDirStatusGet;

      case input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSSTATUS:
         return OSAL_NEW input_mainfi_tclMsgEncoderDirStatusStatus;

      case input_mainfi_tclToken::EN_MSG_ENCODERSTATUSGET:
         return OSAL_NEW input_mainfi_tclMsgEncoderStatusGet;

      case input_mainfi_tclToken::EN_MSG_ENCODERSTATUSSTATUS:
         return OSAL_NEW input_mainfi_tclMsgEncoderStatusStatus;

      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSGET:
         return OSAL_NEW input_mainfi_tclMsgTouchStatusGet;

      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSSTATUS:
         return OSAL_NEW input_mainfi_tclMsgTouchStatusStatus;

      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYGET:
         return OSAL_NEW input_mainfi_tclMsgTouchStatusPIVISecondaryGet;

      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYSTATUS:
         return OSAL_NEW input_mainfi_tclMsgTouchStatusPIVISecondaryStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all input_mainfifi messages

// common functions

tU16 input_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return INPUT_MAINFI_C_U16_SERVICE_ID;
}

tU16 input_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 input_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& input_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& input_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 input_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& input_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& input_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

input_mainfi_tclMsgEnableInputEventsMethodStart::input_mainfi_tclMsgEnableInputEventsMethodStart()
 {}

tS32 input_mainfi_tclMsgEnableInputEventsMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODSTART;
}


input_mainfi_tclMsgEnableInputEventsMethodStart::~input_mainfi_tclMsgEnableInputEventsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgEnableInputEventsMethodResult::input_mainfi_tclMsgEnableInputEventsMethodResult(const input_mainfi_tclMsgEnableInputEventsMethodResult& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   SimulationStatus = coRef.SimulationStatus;
}
input_mainfi_tclMsgEnableInputEventsMethodResult& input_mainfi_tclMsgEnableInputEventsMethodResult::operator=(const input_mainfi_tclMsgEnableInputEventsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SimulationStatus = coRef.SimulationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgEnableInputEventsMethodResult::input_mainfi_tclMsgEnableInputEventsMethodResult()
:SimulationStatus(0)
 {}

tS32 input_mainfi_tclMsgEnableInputEventsMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODRESULT;
}


input_mainfi_tclMsgEnableInputEventsMethodResult::~input_mainfi_tclMsgEnableInputEventsMethodResult()
{}

tU32 input_mainfi_tclMsgEnableInputEventsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& input_mainfi_tclMsgEnableInputEventsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SimulationStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgEnableInputEventsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SimulationStatus);
   return oOut;
}

tBool input_mainfi_tclMsgEnableInputEventsMethodResult::operator==(const input_mainfi_tclMsgEnableInputEventsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SimulationStatus == roRef.SimulationStatus);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgDisableInputEventsMethodStart::input_mainfi_tclMsgDisableInputEventsMethodStart()
 {}

tS32 input_mainfi_tclMsgDisableInputEventsMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODSTART;
}


input_mainfi_tclMsgDisableInputEventsMethodStart::~input_mainfi_tclMsgDisableInputEventsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgDisableInputEventsMethodResult::input_mainfi_tclMsgDisableInputEventsMethodResult(const input_mainfi_tclMsgDisableInputEventsMethodResult& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   SimulationStatus = coRef.SimulationStatus;
}
input_mainfi_tclMsgDisableInputEventsMethodResult& input_mainfi_tclMsgDisableInputEventsMethodResult::operator=(const input_mainfi_tclMsgDisableInputEventsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SimulationStatus = coRef.SimulationStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgDisableInputEventsMethodResult::input_mainfi_tclMsgDisableInputEventsMethodResult()
:SimulationStatus(0)
 {}

tS32 input_mainfi_tclMsgDisableInputEventsMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODRESULT;
}


input_mainfi_tclMsgDisableInputEventsMethodResult::~input_mainfi_tclMsgDisableInputEventsMethodResult()
{}

tU32 input_mainfi_tclMsgDisableInputEventsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& input_mainfi_tclMsgDisableInputEventsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SimulationStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgDisableInputEventsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SimulationStatus);
   return oOut;
}

tBool input_mainfi_tclMsgDisableInputEventsMethodResult::operator==(const input_mainfi_tclMsgDisableInputEventsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SimulationStatus == roRef.SimulationStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulateKeyInjectionMethodStart::input_mainfi_tclMsgsimulateKeyInjectionMethodStart(const input_mainfi_tclMsgsimulateKeyInjectionMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   e16Keycode = coRef.e16Keycode;
   u8KeyStatus = coRef.u8KeyStatus;
}
input_mainfi_tclMsgsimulateKeyInjectionMethodStart& input_mainfi_tclMsgsimulateKeyInjectionMethodStart::operator=(const input_mainfi_tclMsgsimulateKeyInjectionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e16Keycode = coRef.e16Keycode;
   u8KeyStatus = coRef.u8KeyStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulateKeyInjectionMethodStart::input_mainfi_tclMsgsimulateKeyInjectionMethodStart()
:e16Keycode()
,u8KeyStatus(0)
 {}

tS32 input_mainfi_tclMsgsimulateKeyInjectionMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODSTART;
}


input_mainfi_tclMsgsimulateKeyInjectionMethodStart::~input_mainfi_tclMsgsimulateKeyInjectionMethodStart()
{}

tU32 input_mainfi_tclMsgsimulateKeyInjectionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& input_mainfi_tclMsgsimulateKeyInjectionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Keycode);
   (tVoid) (oIn >> u8KeyStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulateKeyInjectionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Keycode);
   (tVoid) (oOut << u8KeyStatus);
   return oOut;
}

tBool input_mainfi_tclMsgsimulateKeyInjectionMethodStart::operator==(const input_mainfi_tclMsgsimulateKeyInjectionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Keycode == roRef.e16Keycode);
   bResult = bResult && (u8KeyStatus == roRef.u8KeyStatus);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulateKeyInjectionMethodResult::input_mainfi_tclMsgsimulateKeyInjectionMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulateKeyInjectionMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODRESULT;
}


input_mainfi_tclMsgsimulateKeyInjectionMethodResult::~input_mainfi_tclMsgsimulateKeyInjectionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulateEncRotationMethodStart::input_mainfi_tclMsgsimulateEncRotationMethodStart(const input_mainfi_tclMsgsimulateEncRotationMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   e8EncoderType = coRef.e8EncoderType;
   s8EncSteps = coRef.s8EncSteps;
}
input_mainfi_tclMsgsimulateEncRotationMethodStart& input_mainfi_tclMsgsimulateEncRotationMethodStart::operator=(const input_mainfi_tclMsgsimulateEncRotationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8EncoderType = coRef.e8EncoderType;
   s8EncSteps = coRef.s8EncSteps;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulateEncRotationMethodStart::input_mainfi_tclMsgsimulateEncRotationMethodStart()
:e8EncoderType()
,s8EncSteps(0)
 {}

tS32 input_mainfi_tclMsgsimulateEncRotationMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODSTART;
}


input_mainfi_tclMsgsimulateEncRotationMethodStart::~input_mainfi_tclMsgsimulateEncRotationMethodStart()
{}

tU32 input_mainfi_tclMsgsimulateEncRotationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& input_mainfi_tclMsgsimulateEncRotationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8EncoderType);
   (tVoid) (oIn >> s8EncSteps);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulateEncRotationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8EncoderType);
   (tVoid) (oOut << s8EncSteps);
   return oOut;
}

tBool input_mainfi_tclMsgsimulateEncRotationMethodStart::operator==(const input_mainfi_tclMsgsimulateEncRotationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8EncoderType == roRef.e8EncoderType);
   bResult = bResult && (s8EncSteps == roRef.s8EncSteps);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulateEncRotationMethodResult::input_mainfi_tclMsgsimulateEncRotationMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulateEncRotationMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODRESULT;
}


input_mainfi_tclMsgsimulateEncRotationMethodResult::~input_mainfi_tclMsgsimulateEncRotationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulateSingleTouchMethodStart::input_mainfi_tclMsgsimulateSingleTouchMethodStart(const input_mainfi_tclMsgsimulateSingleTouchMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   s32XCoord = coRef.s32XCoord;
   s32YCoord = coRef.s32YCoord;
   e8TouchStatus = coRef.e8TouchStatus;
}
input_mainfi_tclMsgsimulateSingleTouchMethodStart& input_mainfi_tclMsgsimulateSingleTouchMethodStart::operator=(const input_mainfi_tclMsgsimulateSingleTouchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32XCoord = coRef.s32XCoord;
   s32YCoord = coRef.s32YCoord;
   e8TouchStatus = coRef.e8TouchStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulateSingleTouchMethodStart::input_mainfi_tclMsgsimulateSingleTouchMethodStart()
:s32XCoord(0)
,s32YCoord(0)
,e8TouchStatus()
 {}

tS32 input_mainfi_tclMsgsimulateSingleTouchMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODSTART;
}


input_mainfi_tclMsgsimulateSingleTouchMethodStart::~input_mainfi_tclMsgsimulateSingleTouchMethodStart()
{}

tU32 input_mainfi_tclMsgsimulateSingleTouchMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& input_mainfi_tclMsgsimulateSingleTouchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32XCoord);
   (tVoid) (oIn >> s32YCoord);
   (tVoid) (oIn >> e8TouchStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulateSingleTouchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32XCoord);
   (tVoid) (oOut << s32YCoord);
   (tVoid) (oOut << e8TouchStatus);
   return oOut;
}

tBool input_mainfi_tclMsgsimulateSingleTouchMethodStart::operator==(const input_mainfi_tclMsgsimulateSingleTouchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32XCoord == roRef.s32XCoord);
   bResult = bResult && (s32YCoord == roRef.s32YCoord);
   bResult = bResult && (e8TouchStatus == roRef.e8TouchStatus);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulateSingleTouchMethodResult::input_mainfi_tclMsgsimulateSingleTouchMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulateSingleTouchMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODRESULT;
}


input_mainfi_tclMsgsimulateSingleTouchMethodResult::~input_mainfi_tclMsgsimulateSingleTouchMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulateTouchSlideMethodStart::input_mainfi_tclMsgsimulateTouchSlideMethodStart(const input_mainfi_tclMsgsimulateTouchSlideMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   s32XStart = coRef.s32XStart;
   s32YStart = coRef.s32YStart;
   s32XEnd = coRef.s32XEnd;
   s32YEnd = coRef.s32YEnd;
   u16Duration = coRef.u16Duration;
}
input_mainfi_tclMsgsimulateTouchSlideMethodStart& input_mainfi_tclMsgsimulateTouchSlideMethodStart::operator=(const input_mainfi_tclMsgsimulateTouchSlideMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32XStart = coRef.s32XStart;
   s32YStart = coRef.s32YStart;
   s32XEnd = coRef.s32XEnd;
   s32YEnd = coRef.s32YEnd;
   u16Duration = coRef.u16Duration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulateTouchSlideMethodStart::input_mainfi_tclMsgsimulateTouchSlideMethodStart()
:s32XStart(0)
,s32YStart(0)
,s32XEnd(0)
,s32YEnd(0)
,u16Duration(0)
 {}

tS32 input_mainfi_tclMsgsimulateTouchSlideMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODSTART;
}


input_mainfi_tclMsgsimulateTouchSlideMethodStart::~input_mainfi_tclMsgsimulateTouchSlideMethodStart()
{}

tU32 input_mainfi_tclMsgsimulateTouchSlideMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& input_mainfi_tclMsgsimulateTouchSlideMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32XStart);
   (tVoid) (oIn >> s32YStart);
   (tVoid) (oIn >> s32XEnd);
   (tVoid) (oIn >> s32YEnd);
   (tVoid) (oIn >> u16Duration);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulateTouchSlideMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32XStart);
   (tVoid) (oOut << s32YStart);
   (tVoid) (oOut << s32XEnd);
   (tVoid) (oOut << s32YEnd);
   (tVoid) (oOut << u16Duration);
   return oOut;
}

tBool input_mainfi_tclMsgsimulateTouchSlideMethodStart::operator==(const input_mainfi_tclMsgsimulateTouchSlideMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32XStart == roRef.s32XStart);
   bResult = bResult && (s32YStart == roRef.s32YStart);
   bResult = bResult && (s32XEnd == roRef.s32XEnd);
   bResult = bResult && (s32YEnd == roRef.s32YEnd);
   bResult = bResult && (u16Duration == roRef.u16Duration);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulateTouchSlideMethodResult::input_mainfi_tclMsgsimulateTouchSlideMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulateTouchSlideMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODRESULT;
}


input_mainfi_tclMsgsimulateTouchSlideMethodResult::~input_mainfi_tclMsgsimulateTouchSlideMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulateMultiTouchMethodStart::input_mainfi_tclMsgsimulateMultiTouchMethodStart(const input_mainfi_tclMsgsimulateMultiTouchMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   s32SlotId = coRef.s32SlotId;
   s32XCoord = coRef.s32XCoord;
   s32YCoord = coRef.s32YCoord;
   e8TouchStatus = coRef.e8TouchStatus;
}
input_mainfi_tclMsgsimulateMultiTouchMethodStart& input_mainfi_tclMsgsimulateMultiTouchMethodStart::operator=(const input_mainfi_tclMsgsimulateMultiTouchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32SlotId = coRef.s32SlotId;
   s32XCoord = coRef.s32XCoord;
   s32YCoord = coRef.s32YCoord;
   e8TouchStatus = coRef.e8TouchStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulateMultiTouchMethodStart::input_mainfi_tclMsgsimulateMultiTouchMethodStart()
:s32SlotId(0)
,s32XCoord(0)
,s32YCoord(0)
,e8TouchStatus()
 {}

tS32 input_mainfi_tclMsgsimulateMultiTouchMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODSTART;
}


input_mainfi_tclMsgsimulateMultiTouchMethodStart::~input_mainfi_tclMsgsimulateMultiTouchMethodStart()
{}

tU32 input_mainfi_tclMsgsimulateMultiTouchMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& input_mainfi_tclMsgsimulateMultiTouchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32SlotId);
   (tVoid) (oIn >> s32XCoord);
   (tVoid) (oIn >> s32YCoord);
   (tVoid) (oIn >> e8TouchStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulateMultiTouchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32SlotId);
   (tVoid) (oOut << s32XCoord);
   (tVoid) (oOut << s32YCoord);
   (tVoid) (oOut << e8TouchStatus);
   return oOut;
}

tBool input_mainfi_tclMsgsimulateMultiTouchMethodStart::operator==(const input_mainfi_tclMsgsimulateMultiTouchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32SlotId == roRef.s32SlotId);
   bResult = bResult && (s32XCoord == roRef.s32XCoord);
   bResult = bResult && (s32YCoord == roRef.s32YCoord);
   bResult = bResult && (e8TouchStatus == roRef.e8TouchStatus);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulateMultiTouchMethodResult::input_mainfi_tclMsgsimulateMultiTouchMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulateMultiTouchMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODRESULT;
}


input_mainfi_tclMsgsimulateMultiTouchMethodResult::~input_mainfi_tclMsgsimulateMultiTouchMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgGestureRecordMethodStart::input_mainfi_tclMsgGestureRecordMethodStart(const input_mainfi_tclMsgGestureRecordMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   u8StartStop = coRef.u8StartStop;
   FilePath = coRef.FilePath;
}
input_mainfi_tclMsgGestureRecordMethodStart& input_mainfi_tclMsgGestureRecordMethodStart::operator=(const input_mainfi_tclMsgGestureRecordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8StartStop = coRef.u8StartStop;
   FilePath = coRef.FilePath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgGestureRecordMethodStart::vDestroy()
{
   FilePath.vDestroy();
}

input_mainfi_tclMsgGestureRecordMethodStart::input_mainfi_tclMsgGestureRecordMethodStart()
:u8StartStop(0)
,FilePath()
 {}

tS32 input_mainfi_tclMsgGestureRecordMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODSTART;
}


input_mainfi_tclMsgGestureRecordMethodStart::~input_mainfi_tclMsgGestureRecordMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgGestureRecordMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+FilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgGestureRecordMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8StartStop);
   (tVoid) (oIn >> FilePath);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgGestureRecordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8StartStop);
   (tVoid) (oOut << FilePath);
   return oOut;
}

tBool input_mainfi_tclMsgGestureRecordMethodStart::operator==(const input_mainfi_tclMsgGestureRecordMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8StartStop == roRef.u8StartStop);
   bResult = bResult && (FilePath == roRef.FilePath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgGestureRecordMethodResult::input_mainfi_tclMsgGestureRecordMethodResult(const input_mainfi_tclMsgGestureRecordMethodResult& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
input_mainfi_tclMsgGestureRecordMethodResult& input_mainfi_tclMsgGestureRecordMethodResult::operator=(const input_mainfi_tclMsgGestureRecordMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgGestureRecordMethodResult::input_mainfi_tclMsgGestureRecordMethodResult()
:bSuccess(0)
 {}

tS32 input_mainfi_tclMsgGestureRecordMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODRESULT;
}


input_mainfi_tclMsgGestureRecordMethodResult::~input_mainfi_tclMsgGestureRecordMethodResult()
{}

tU32 input_mainfi_tclMsgGestureRecordMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& input_mainfi_tclMsgGestureRecordMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgGestureRecordMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool input_mainfi_tclMsgGestureRecordMethodResult::operator==(const input_mainfi_tclMsgGestureRecordMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgGestureReplayMethodStart::input_mainfi_tclMsgGestureReplayMethodStart(const input_mainfi_tclMsgGestureReplayMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   u8StartStop = coRef.u8StartStop;
   FilePath = coRef.FilePath;
}
input_mainfi_tclMsgGestureReplayMethodStart& input_mainfi_tclMsgGestureReplayMethodStart::operator=(const input_mainfi_tclMsgGestureReplayMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8StartStop = coRef.u8StartStop;
   FilePath = coRef.FilePath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgGestureReplayMethodStart::vDestroy()
{
   FilePath.vDestroy();
}

input_mainfi_tclMsgGestureReplayMethodStart::input_mainfi_tclMsgGestureReplayMethodStart()
:u8StartStop(0)
,FilePath()
 {}

tS32 input_mainfi_tclMsgGestureReplayMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODSTART;
}


input_mainfi_tclMsgGestureReplayMethodStart::~input_mainfi_tclMsgGestureReplayMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgGestureReplayMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+FilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgGestureReplayMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8StartStop);
   (tVoid) (oIn >> FilePath);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgGestureReplayMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8StartStop);
   (tVoid) (oOut << FilePath);
   return oOut;
}

tBool input_mainfi_tclMsgGestureReplayMethodStart::operator==(const input_mainfi_tclMsgGestureReplayMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8StartStop == roRef.u8StartStop);
   bResult = bResult && (FilePath == roRef.FilePath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgGestureReplayMethodResult::input_mainfi_tclMsgGestureReplayMethodResult(const input_mainfi_tclMsgGestureReplayMethodResult& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   bSuccess = coRef.bSuccess;
}
input_mainfi_tclMsgGestureReplayMethodResult& input_mainfi_tclMsgGestureReplayMethodResult::operator=(const input_mainfi_tclMsgGestureReplayMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSuccess = coRef.bSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgGestureReplayMethodResult::input_mainfi_tclMsgGestureReplayMethodResult()
:bSuccess(0)
 {}

tS32 input_mainfi_tclMsgGestureReplayMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODRESULT;
}


input_mainfi_tclMsgGestureReplayMethodResult::~input_mainfi_tclMsgGestureReplayMethodResult()
{}

tU32 input_mainfi_tclMsgGestureReplayMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& input_mainfi_tclMsgGestureReplayMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSuccess);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgGestureReplayMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSuccess);
   return oOut;
}

tBool input_mainfi_tclMsgGestureReplayMethodResult::operator==(const input_mainfi_tclMsgGestureReplayMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSuccess == roRef.bSuccess);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulatePIVITouchMethodStart::input_mainfi_tclMsgsimulatePIVITouchMethodStart(const input_mainfi_tclMsgsimulatePIVITouchMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   s32XCoord = coRef.s32XCoord;
   s32YCoord = coRef.s32YCoord;
   s32ScreenNumber = coRef.s32ScreenNumber;
   e8TouchStatus = coRef.e8TouchStatus;
}
input_mainfi_tclMsgsimulatePIVITouchMethodStart& input_mainfi_tclMsgsimulatePIVITouchMethodStart::operator=(const input_mainfi_tclMsgsimulatePIVITouchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32XCoord = coRef.s32XCoord;
   s32YCoord = coRef.s32YCoord;
   s32ScreenNumber = coRef.s32ScreenNumber;
   e8TouchStatus = coRef.e8TouchStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulatePIVITouchMethodStart::input_mainfi_tclMsgsimulatePIVITouchMethodStart()
:s32XCoord(0)
,s32YCoord(0)
,s32ScreenNumber(0)
,e8TouchStatus()
 {}

tS32 input_mainfi_tclMsgsimulatePIVITouchMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODSTART;
}


input_mainfi_tclMsgsimulatePIVITouchMethodStart::~input_mainfi_tclMsgsimulatePIVITouchMethodStart()
{}

tU32 input_mainfi_tclMsgsimulatePIVITouchMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& input_mainfi_tclMsgsimulatePIVITouchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32XCoord);
   (tVoid) (oIn >> s32YCoord);
   (tVoid) (oIn >> s32ScreenNumber);
   (tVoid) (oIn >> e8TouchStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulatePIVITouchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32XCoord);
   (tVoid) (oOut << s32YCoord);
   (tVoid) (oOut << s32ScreenNumber);
   (tVoid) (oOut << e8TouchStatus);
   return oOut;
}

tBool input_mainfi_tclMsgsimulatePIVITouchMethodStart::operator==(const input_mainfi_tclMsgsimulatePIVITouchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32XCoord == roRef.s32XCoord);
   bResult = bResult && (s32YCoord == roRef.s32YCoord);
   bResult = bResult && (s32ScreenNumber == roRef.s32ScreenNumber);
   bResult = bResult && (e8TouchStatus == roRef.e8TouchStatus);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulatePIVITouchMethodResult::input_mainfi_tclMsgsimulatePIVITouchMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulatePIVITouchMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODRESULT;
}


input_mainfi_tclMsgsimulatePIVITouchMethodResult::~input_mainfi_tclMsgsimulatePIVITouchMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::input_mainfi_tclMsgDevInputNotifyConnectionMethodStart(const input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceType = coRef.DeviceType;
   DeviceConnectStatus = coRef.DeviceConnectStatus;
   DeviceName = coRef.DeviceName;
}
input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::operator=(const input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceType = coRef.DeviceType;
   DeviceConnectStatus = coRef.DeviceConnectStatus;
   DeviceName = coRef.DeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::vDestroy()
{
   DeviceName.vDestroy();
}

input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::input_mainfi_tclMsgDevInputNotifyConnectionMethodStart()
:DeviceType()
,DeviceConnectStatus()
,DeviceName()
 {}

tS32 input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODSTART;
}


input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::~input_mainfi_tclMsgDevInputNotifyConnectionMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+DeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceType);
   (tVoid) (oIn >> DeviceConnectStatus);
   (tVoid) (oIn >> DeviceName);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceType);
   (tVoid) (oOut << DeviceConnectStatus);
   (tVoid) (oOut << DeviceName);
   return oOut;
}

tBool input_mainfi_tclMsgDevInputNotifyConnectionMethodStart::operator==(const input_mainfi_tclMsgDevInputNotifyConnectionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceType == roRef.DeviceType);
   bResult = bResult && (DeviceConnectStatus == roRef.DeviceConnectStatus);
   bResult = bResult && (DeviceName == roRef.DeviceName);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgDevInputNotifyConnectionMethodResult::input_mainfi_tclMsgDevInputNotifyConnectionMethodResult()
 {}

tS32 input_mainfi_tclMsgDevInputNotifyConnectionMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODRESULT;
}


input_mainfi_tclMsgDevInputNotifyConnectionMethodResult::~input_mainfi_tclMsgDevInputNotifyConnectionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   s32XStart = coRef.s32XStart;
   s32YStart = coRef.s32YStart;
   s32XEnd = coRef.s32XEnd;
   s32YEnd = coRef.s32YEnd;
   u16Duration = coRef.u16Duration;
}
input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::operator=(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s32XStart = coRef.s32XStart;
   s32YStart = coRef.s32YStart;
   s32XEnd = coRef.s32XEnd;
   s32YEnd = coRef.s32YEnd;
   u16Duration = coRef.u16Duration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart()
:s32XStart(0)
,s32YStart(0)
,s32XEnd(0)
,s32YEnd(0)
,u16Duration(0)
 {}

tS32 input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODSTART;
}


input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::~input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart()
{}

tU32 input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32XStart);
   (tVoid) (oIn >> s32YStart);
   (tVoid) (oIn >> s32XEnd);
   (tVoid) (oIn >> s32YEnd);
   (tVoid) (oIn >> u16Duration);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32XStart);
   (tVoid) (oOut << s32YStart);
   (tVoid) (oOut << s32XEnd);
   (tVoid) (oOut << s32YEnd);
   (tVoid) (oOut << u16Duration);
   return oOut;
}

tBool input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart::operator==(const input_mainfi_tclMsgsimulatePIVITouchSlideMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32XStart == roRef.s32XStart);
   bResult = bResult && (s32YStart == roRef.s32YStart);
   bResult = bResult && (s32XEnd == roRef.s32XEnd);
   bResult = bResult && (s32YEnd == roRef.s32YEnd);
   bResult = bResult && (u16Duration == roRef.u16Duration);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult::input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult()
 {}

tS32 input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODRESULT;
}


input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult::~input_mainfi_tclMsgsimulatePIVITouchSlideMethodResult()
{}

//=============================================================================

input_mainfi_tclMsgPressedKeysGet::input_mainfi_tclMsgPressedKeysGet()
 {}

tS32 input_mainfi_tclMsgPressedKeysGet::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_PRESSEDKEYSGET;
}


input_mainfi_tclMsgPressedKeysGet::~input_mainfi_tclMsgPressedKeysGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgPressedKeysStatus::input_mainfi_tclMsgPressedKeysStatus(const input_mainfi_tclMsgPressedKeysStatus& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   KeyInfoList = coRef.KeyInfoList;
}
input_mainfi_tclMsgPressedKeysStatus& input_mainfi_tclMsgPressedKeysStatus::operator=(const input_mainfi_tclMsgPressedKeysStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyInfoList = coRef.KeyInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgPressedKeysStatus::vDestroy()
{
   KeyInfoList.vDestroy(); 
}

input_mainfi_tclMsgPressedKeysStatus::input_mainfi_tclMsgPressedKeysStatus()
:KeyInfoList()
 {}

tS32 input_mainfi_tclMsgPressedKeysStatus::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_PRESSEDKEYSSTATUS;
}


input_mainfi_tclMsgPressedKeysStatus::~input_mainfi_tclMsgPressedKeysStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgPressedKeysStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+KeyInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgPressedKeysStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyInfoList);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgPressedKeysStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyInfoList);
   return oOut;
}

tBool input_mainfi_tclMsgPressedKeysStatus::operator==(const input_mainfi_tclMsgPressedKeysStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyInfoList == roRef.KeyInfoList);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgEncoderDirStatusGet::input_mainfi_tclMsgEncoderDirStatusGet()
 {}

tS32 input_mainfi_tclMsgEncoderDirStatusGet::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSGET;
}


input_mainfi_tclMsgEncoderDirStatusGet::~input_mainfi_tclMsgEncoderDirStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgEncoderDirStatusStatus::input_mainfi_tclMsgEncoderDirStatusStatus(const input_mainfi_tclMsgEncoderDirStatusStatus& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   tEncoderDirectionList = coRef.tEncoderDirectionList;
}
input_mainfi_tclMsgEncoderDirStatusStatus& input_mainfi_tclMsgEncoderDirStatusStatus::operator=(const input_mainfi_tclMsgEncoderDirStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   tEncoderDirectionList = coRef.tEncoderDirectionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgEncoderDirStatusStatus::vDestroy()
{
   tEncoderDirectionList.vDestroy(); 
}

input_mainfi_tclMsgEncoderDirStatusStatus::input_mainfi_tclMsgEncoderDirStatusStatus()
:tEncoderDirectionList()
 {}

tS32 input_mainfi_tclMsgEncoderDirStatusStatus::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSSTATUS;
}


input_mainfi_tclMsgEncoderDirStatusStatus::~input_mainfi_tclMsgEncoderDirStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgEncoderDirStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tEncoderDirectionList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgEncoderDirStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tEncoderDirectionList);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgEncoderDirStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tEncoderDirectionList);
   return oOut;
}

tBool input_mainfi_tclMsgEncoderDirStatusStatus::operator==(const input_mainfi_tclMsgEncoderDirStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tEncoderDirectionList == roRef.tEncoderDirectionList);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgEncoderStatusGet::input_mainfi_tclMsgEncoderStatusGet()
 {}

tS32 input_mainfi_tclMsgEncoderStatusGet::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_ENCODERSTATUSGET;
}


input_mainfi_tclMsgEncoderStatusGet::~input_mainfi_tclMsgEncoderStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgEncoderStatusStatus::input_mainfi_tclMsgEncoderStatusStatus(const input_mainfi_tclMsgEncoderStatusStatus& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   tEncoderStatus = coRef.tEncoderStatus;
}
input_mainfi_tclMsgEncoderStatusStatus& input_mainfi_tclMsgEncoderStatusStatus::operator=(const input_mainfi_tclMsgEncoderStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   tEncoderStatus = coRef.tEncoderStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

input_mainfi_tclMsgEncoderStatusStatus::input_mainfi_tclMsgEncoderStatusStatus()
:tEncoderStatus()
 {}

tS32 input_mainfi_tclMsgEncoderStatusStatus::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_ENCODERSTATUSSTATUS;
}


input_mainfi_tclMsgEncoderStatusStatus::~input_mainfi_tclMsgEncoderStatusStatus()
{}

tU32 input_mainfi_tclMsgEncoderStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& input_mainfi_tclMsgEncoderStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tEncoderStatus);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgEncoderStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tEncoderStatus);
   return oOut;
}

tBool input_mainfi_tclMsgEncoderStatusStatus::operator==(const input_mainfi_tclMsgEncoderStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tEncoderStatus == roRef.tEncoderStatus);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgTouchStatusGet::input_mainfi_tclMsgTouchStatusGet()
 {}

tS32 input_mainfi_tclMsgTouchStatusGet::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_TOUCHSTATUSGET;
}


input_mainfi_tclMsgTouchStatusGet::~input_mainfi_tclMsgTouchStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgTouchStatusStatus::input_mainfi_tclMsgTouchStatusStatus(const input_mainfi_tclMsgTouchStatusStatus& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   tTouchDataList = coRef.tTouchDataList;
}
input_mainfi_tclMsgTouchStatusStatus& input_mainfi_tclMsgTouchStatusStatus::operator=(const input_mainfi_tclMsgTouchStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   tTouchDataList = coRef.tTouchDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgTouchStatusStatus::vDestroy()
{
   tTouchDataList.vDestroy(); 
}

input_mainfi_tclMsgTouchStatusStatus::input_mainfi_tclMsgTouchStatusStatus()
:tTouchDataList()
 {}

tS32 input_mainfi_tclMsgTouchStatusStatus::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_TOUCHSTATUSSTATUS;
}


input_mainfi_tclMsgTouchStatusStatus::~input_mainfi_tclMsgTouchStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgTouchStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tTouchDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgTouchStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tTouchDataList);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgTouchStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tTouchDataList);
   return oOut;
}

tBool input_mainfi_tclMsgTouchStatusStatus::operator==(const input_mainfi_tclMsgTouchStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tTouchDataList == roRef.tTouchDataList);
   return bResult;
}

//=============================================================================

input_mainfi_tclMsgTouchStatusPIVISecondaryGet::input_mainfi_tclMsgTouchStatusPIVISecondaryGet()
 {}

tS32 input_mainfi_tclMsgTouchStatusPIVISecondaryGet::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYGET;
}


input_mainfi_tclMsgTouchStatusPIVISecondaryGet::~input_mainfi_tclMsgTouchStatusPIVISecondaryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::input_mainfi_tclMsgTouchStatusPIVISecondaryStatus(const input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& coRef)
   : input_mainfi_tclMsgBaseMessage(coRef)
{
   tSecondaryTouchDataList = coRef.tSecondaryTouchDataList;
}
input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::operator=(const input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& coRef)
{
   if (this == &coRef) return *this;
   tSecondaryTouchDataList = coRef.tSecondaryTouchDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::vDestroy()
{
   tSecondaryTouchDataList.vDestroy(); 
}

input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::input_mainfi_tclMsgTouchStatusPIVISecondaryStatus()
:tSecondaryTouchDataList()
 {}

tS32 input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::s32GetTypeId() const
{
   return (tS32) input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYSTATUS;
}


input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::~input_mainfi_tclMsgTouchStatusPIVISecondaryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tSecondaryTouchDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSecondaryTouchDataList);
   return oIn;
}

fi_tclOutContext& input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSecondaryTouchDataList);
   return oOut;
}

tBool input_mainfi_tclMsgTouchStatusPIVISecondaryStatus::operator==(const input_mainfi_tclMsgTouchStatusPIVISecondaryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSecondaryTouchDataList == roRef.tSecondaryTouchDataList);
   return bResult;
}

