#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_STDVISITORS
#include "input_fi_if.h"

tBool input_mainfi_tclDescription::bInitMessage(input_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case input_mainfi_tclToken::EN_LAST_TOKEN:
   case input_mainfi_tclToken::EN_LIST:
   case input_mainfi_tclToken::EN_END_OF_STRUCT:
   case input_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_BOOL,input_mainfi_tclSemanticDomain::EN_MSG_SIMULATIONSTATUS)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODRESULT:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_BOOL,input_mainfi_tclSemanticDomain::EN_MSG_SIMULATIONSTATUS)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U8,input_mainfi_tclSemanticDomain::EN_MSG_U8KEYSTATUS)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E16_KEYCODE,input_mainfi_tclSemanticDomain::EN_MSG_E16KEYCODE)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_MSG_S8ENCSTEPS)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_ENCODERTYPE,input_mainfi_tclSemanticDomain::EN_MSG_E8ENCODERTYPE)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_TOUCHSTATUS,input_mainfi_tclSemanticDomain::EN_MSG_E8TOUCHSTATUS)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YCOORD)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XCOORD)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U16,input_mainfi_tclSemanticDomain::EN_MSG_U16DURATION)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YEND)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XEND)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YSTART)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XSTART)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_TOUCHSTATUS,input_mainfi_tclSemanticDomain::EN_MSG_E8TOUCHSTATUS)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YCOORD)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XCOORD)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32SLOTID)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_STRING,input_mainfi_tclSemanticDomain::EN_MSG_FILEPATH)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U8,input_mainfi_tclSemanticDomain::EN_MSG_U8STARTSTOP)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODRESULT:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_BOOL,input_mainfi_tclSemanticDomain::EN_MSG_BSUCCESS)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_STRING,input_mainfi_tclSemanticDomain::EN_MSG_FILEPATH)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U8,input_mainfi_tclSemanticDomain::EN_MSG_U8STARTSTOP)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODRESULT:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_BOOL,input_mainfi_tclSemanticDomain::EN_MSG_BSUCCESS)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_TOUCHSTATUS,input_mainfi_tclSemanticDomain::EN_MSG_E8TOUCHSTATUS)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32SCREENNUMBER)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YCOORD)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XCOORD)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_STRING,input_mainfi_tclSemanticDomain::EN_MSG_DEVICENAME)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_DEVICECONNECTSTATUS,input_mainfi_tclSemanticDomain::EN_MSG_DEVICECONNECTSTATUS)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_DEVICE,input_mainfi_tclSemanticDomain::EN_MSG_DEVICETYPE)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODSTART:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U16,input_mainfi_tclSemanticDomain::EN_MSG_U16DURATION)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YEND)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XEND)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32YSTART)) && bResult;
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_MSG_S32XSTART)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_PRESSEDKEYSSTATUS:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_DIAGKEYLIST,input_mainfi_tclSemanticDomain::EN_MSG_KEYINFOLIST)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_ENCODERDIRECTIONLIST,input_mainfi_tclSemanticDomain::EN_MSG_TENCODERDIRECTIONLIST)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_ENCODERSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_ENCODERSTATUS,input_mainfi_tclSemanticDomain::EN_MSG_TENCODERSTATUS)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_TOUCHDATALIST,input_mainfi_tclSemanticDomain::EN_MSG_TTOUCHDATALIST)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYSTATUS:
   {
      bResult = oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_TOUCHDATALIST,input_mainfi_tclSemanticDomain::EN_MSG_TSECONDARYTOUCHDATALIST)) && bResult;
   } break;
   case input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODSTART:
   case input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODSTART:
   case input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODRESULT:
   case input_mainfi_tclToken::EN_MSG_PRESSEDKEYSGET:
   case input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSGET:
   case input_mainfi_tclToken::EN_MSG_ENCODERSTATUSGET:
   case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSGET:
   case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYGET:
   case input_mainfi_tclToken::EN_BINCONTAINER:
   case input_mainfi_tclToken::EN_E16_KEYCODE:
   case input_mainfi_tclToken::EN_KEYINFO:
   case input_mainfi_tclToken::EN_E8_ENCODERTYPE:
   case input_mainfi_tclToken::EN_E8_TOUCHSTATUS:
   case input_mainfi_tclToken::EN_ENCINFO:
   case input_mainfi_tclToken::EN_ENCODERDIRECTIONLIST:
   case input_mainfi_tclToken::EN_ENCODERSTATUS:
   case input_mainfi_tclToken::EN_DIAGKEYLIST:
   case input_mainfi_tclToken::EN_TOUCHINFO:
   case input_mainfi_tclToken::EN_TOUCHDATALIST:
   case input_mainfi_tclToken::EN_E8_DEVICECONNECTSTATUS:
   case input_mainfi_tclToken::EN_E8_DEVICE:
   case input_mainfi_tclToken::EN_U8:   
   case input_mainfi_tclToken::EN_S8:   
   case input_mainfi_tclToken::EN_U16:   
   case input_mainfi_tclToken::EN_S16:   
   case input_mainfi_tclToken::EN_U24:   
   case input_mainfi_tclToken::EN_S24:   
   case input_mainfi_tclToken::EN_U32:   
   case input_mainfi_tclToken::EN_S32:   
   case input_mainfi_tclToken::EN_U64:   
   case input_mainfi_tclToken::EN_S64:   
   case input_mainfi_tclToken::EN_F32:   
   case input_mainfi_tclToken::EN_F64:   
   case input_mainfi_tclToken::EN_BOOL:   
   case input_mainfi_tclToken::EN_STRING:   
   case input_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(input_mainfi_tclKnot(enMsgToken,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool input_mainfi_tclDescription::bDoIt(input_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool input_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      input_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      input_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      input_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == input_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(input_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(input_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(input_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case input_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == input_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_LIST: 
      {
         input_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            input_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(input_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            input_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(input_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case input_mainfi_tclToken::EN_U8: 
      {
         input_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case input_mainfi_tclToken::EN_U16: 
      {
         input_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_U24: 
      {
         input_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_U32: 
      {
         input_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_U64: 
      {
         input_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_S8: 
      {
         input_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_S16: 
      {
         input_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_S24: 
      {
         input_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_S32: 
      {
         input_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_S64: 
      {
         input_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_F32: 
      {
         input_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_F64: 
      {
         input_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_BOOL: 
      {
         input_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_STRING: 
      {
         input_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         input_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_ENABLEINPUTEVENTSMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_DISABLEINPUTEVENTSMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATEKEYINJECTIONMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATEENCROTATIONMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATESINGLETOUCHMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATETOUCHSLIDEMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATEMULTITOUCHMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_GESTURERECORDMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_GESTUREREPLAYMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_DEVINPUTNOTIFYCONNECTIONMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODSTART:
      case input_mainfi_tclToken::EN_MSG_SIMULATEPIVITOUCHSLIDEMETHODRESULT:
      case input_mainfi_tclToken::EN_MSG_PRESSEDKEYSGET:
      case input_mainfi_tclToken::EN_MSG_PRESSEDKEYSSTATUS:
      case input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSGET:
      case input_mainfi_tclToken::EN_MSG_ENCODERDIRSTATUSSTATUS:
      case input_mainfi_tclToken::EN_MSG_ENCODERSTATUSGET:
      case input_mainfi_tclToken::EN_MSG_ENCODERSTATUSSTATUS:
      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSGET:
      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSSTATUS:
      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYGET:
      case input_mainfi_tclToken::EN_MSG_TOUCHSTATUSPIVISECONDARYSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case input_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U8,input_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_LIST,input_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         input_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_E16_KEYCODE:
      {
         input_fi_tcl_e16_KeyCode o_e16_KeyCode;
         if (!bDoIt(o_e16_KeyCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_KEYINFO:
      {
      if (poVisitor->bDoExpand_KeyInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_U8,input_mainfi_tclSemanticDomain::EN_U8KEYSTATUS));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E16_KEYCODE,input_mainfi_tclSemanticDomain::EN_E16KEYCODE));
      }
      else
      {
         input_fi_tcl_KeyInfo o_KeyInfo;
         if (!bDoIt(o_KeyInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_KeyInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_E8_ENCODERTYPE:
      {
         input_fi_tcl_e8_EncoderType o_e8_EncoderType;
         if (!bDoIt(o_e8_EncoderType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_E8_TOUCHSTATUS:
      {
         input_fi_tcl_e8_TouchStatus o_e8_TouchStatus;
         if (!bDoIt(o_e8_TouchStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_ENCINFO:
      {
      if (poVisitor->bDoExpand_EncInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_S8ENCSTEPS));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_ENCODERTYPE,input_mainfi_tclSemanticDomain::EN_E8ENCODERTYPE));
      }
      else
      {
         input_fi_tcl_EncInfo o_EncInfo;
         if (!bDoIt(o_EncInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_ENCODERDIRECTIONLIST:
      {
      if (poVisitor->bDoExpand_EncoderDirectionList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_ENCINFO,input_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_LIST,input_mainfi_tclSemanticDomain::EN_TENCINFOLIST));
      }
      else
      {
         input_fi_tcl_EncoderDirectionList o_EncoderDirectionList;
         if (!bDoIt(o_EncoderDirectionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncoderDirectionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncoderDirectionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_ENCODERSTATUS:
      {
      if (poVisitor->bDoExpand_EncoderStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_S8ENCVAL_5));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_S8ENCVAL_4));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_S8ENCVAL_3));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_S8ENCVAL_2));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S8,input_mainfi_tclSemanticDomain::EN_S8ENCVAL_1));
      }
      else
      {
         input_fi_tcl_EncoderStatus o_EncoderStatus;
         if (!bDoIt(o_EncoderStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncoderStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EncoderStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_DIAGKEYLIST:
      {
      if (poVisitor->bDoExpand_DiagKeyList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_KEYINFO,input_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_LIST,input_mainfi_tclSemanticDomain::EN_TKEYINFOLIST));
      }
      else
      {
         input_fi_tcl_DiagKeyList o_DiagKeyList;
         if (!bDoIt(o_DiagKeyList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagKeyList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagKeyList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_TOUCHINFO:
      {
      if (poVisitor->bDoExpand_TouchInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_S32YCOORD));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_S32,input_mainfi_tclSemanticDomain::EN_S32XCOORD));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_E8_TOUCHSTATUS,input_mainfi_tclSemanticDomain::EN_E8TOUCHSTATUS));
      }
      else
      {
         input_fi_tcl_TouchInfo o_TouchInfo;
         if (!bDoIt(o_TouchInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TouchInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TouchInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_TOUCHDATALIST:
      {
      if (poVisitor->bDoExpand_TouchDataList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_END_OF_STRUCT,input_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_TOUCHINFO,input_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(input_mainfi_tclKnot(input_mainfi_tclToken::EN_LIST,input_mainfi_tclSemanticDomain::EN_STOUCHINFO));
      }
      else
      {
         input_fi_tcl_TouchDataList o_TouchDataList;
         if (!bDoIt(o_TouchDataList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TouchDataList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TouchDataList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case input_mainfi_tclToken::EN_E8_DEVICECONNECTSTATUS:
      {
         input_fi_tcl_e8_DeviceConnectStatus o_e8_DeviceConnectStatus;
         if (!bDoIt(o_e8_DeviceConnectStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_E8_DEVICE:
      {
         input_fi_tcl_e8_Device o_e8_Device;
         if (!bDoIt(o_e8_Device))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case input_mainfi_tclToken::EN_UNKNOWN:
      case input_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

