/************************************************************************
*FILE: TextureImageWidget3DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TextureImageWidget3DBase_h)
#define TextureImageWidget3DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/3D/BaseWidget3D.h>
// ------------------------------------------------------------------------
//! [TextureImageWidget3DBase_Declaration]
class TextureImageWidget3DBase : public BaseWidget3D
{
    public:
        typedef Candera::MemoryManagement::SharedPointer<Candera::Bitmap> BitmapType;

        //! [Property_IDs]
        static const FeatStd::UInt32 BitmapPropertyId = 0xD304CEEA;
        //! [Property_IDs]

        TextureImageWidget3DBase();
        virtual ~TextureImageWidget3DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextureImageWidget3DBase, BaseWidget3D);

        //! [DataBinding_BitmapPropertyGetterSetter]
        void SetBitmap(const BitmapType& bitmap);
        const BitmapType& GetBitmap() const { return m_Bitmap; }
        //! [DataBinding_BitmapPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidgetDef(TextureImageWidget3DBase, BaseWidget3D)
            CdaDescription("Controls the Texture property of the existing bitmap brush of a render node.")
            CdaReadableName("TextureImageWidget3DBase")
            CdaCategory("Image")

            CdaProperties()
                CdaBindableProperty(Bitmap, BitmapType, GetBitmap, SetBitmap)
                    CdaDescription("Bitmap to be set on the BitmapBrushEffect inside the RenderNode.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        BitmapType m_Bitmap;
};

#endif // TextureImageWidget3DBase_h
