/************************************************************************
*FILE: SimpleButtonWidget3DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SimpleButtonWidget3DBase_h)
#define SimpleButtonWidget3DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/3D/BaseWidget3D.h>
#include <Widgets/3D/Touchable3D.h>
#include <Candera/Engine3D/Core/Appearance.h>
// ------------------------------------------------------------------------
//! [SimpleButtonWidget3DBase_Declaration]
class SimpleButtonWidget3DBase : public Touchable3D
{
    public:
        typedef Candera::MemoryManagement::SharedPointer<Candera::Bitmap> NormalBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Bitmap> PressedBitmapType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Bitmap> DisabledBitmapType;

        //! [Property_IDs]
        static const FeatStd::UInt32 NormalBitmapPropertyId = 0x0465C2D8;
        static const FeatStd::UInt32 PressedBitmapPropertyId = 0x4E266A55;
        static const FeatStd::UInt32 DisabledBitmapPropertyId = 0xE382473B;
        //! [Property_IDs]

        SimpleButtonWidget3DBase();
        virtual ~SimpleButtonWidget3DBase();

        CGI_WIDGET_RTTI_DECLARATION(SimpleButtonWidget3DBase, Touchable3D);

        //! [DataBinding_NormalBitmapPropertyGetterSetter]
        void SetNormalBitmap(const NormalBitmapType& normalbitmap);
        const NormalBitmapType& GetNormalBitmap() const { return m_NormalBitmap; }
        //! [DataBinding_NormalBitmapPropertyGetterSetter]

        //! [DataBinding_PressedBitmapPropertyGetterSetter]
        void SetPressedBitmap(const PressedBitmapType& pressedbitmap);
        const PressedBitmapType& GetPressedBitmap() const { return m_PressedBitmap; }
        //! [DataBinding_PressedBitmapPropertyGetterSetter]

        //! [DataBinding_DisabledBitmapPropertyGetterSetter]
        void SetDisabledBitmap(const DisabledBitmapType& disabledbitmap);
        const DisabledBitmapType& GetDisabledBitmap() const { return m_DisabledBitmap; }
        //! [DataBinding_DisabledBitmapPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidgetDef(SimpleButtonWidget3DBase, Touchable3D)
            CdaDescription("Provide a simple 3D button, this button should link a kind of 3D note (billboard, mesh...), it also contains several states (enabled/disabled, pressed), all these states can be configured with a bitmap")
            CdaReadableName("SimpleButtonWidget3DBase")
            CdaCategory("Button3D")

            CdaProperties()
                CdaBindableProperty(NormalBitmap, NormalBitmapType, GetNormalBitmap, SetNormalBitmap)
                    CdaDescription("Bitmap used inside the texture of Apperance when Button is enabled, not pressed")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PressedBitmap, PressedBitmapType, GetPressedBitmap, SetPressedBitmap)
                    CdaDescription("Bitmap used inside the texture of Apperance when Button is pressed, enabled")
                CdaBindablePropertyEnd()
                CdaBindableProperty(DisabledBitmap, DisabledBitmapType, GetDisabledBitmap, SetDisabledBitmap)
                    CdaDescription("Bitmap used inside the texture of Apperance when Button is disabled")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        NormalBitmapType m_NormalBitmap;
        PressedBitmapType m_PressedBitmap;
        DisabledBitmapType m_DisabledBitmap;
};

#endif // SimpleButtonWidget3DBase_h
