/************************************************************************
*FILE: ViewSwitchWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ViewSwitchWidget2DBase_h)
#define ViewSwitchWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [ViewSwitchWidget2DBase_Declaration]
class ViewSwitchWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef FeatStd::UInt32 IndexType;

        typedef bool AddInvalidationDependencyType;

        typedef FeatStd::String ViewPrefixType;

        typedef Candera::ArrayProperty<FeatStd::String> ViewIdsType;

        typedef Candera::ArrayProperty<bool> CacheViewsType;

        //! [Property_IDs]
        static const FeatStd::UInt32 IndexPropertyId = 0x3DBCF2F4;
        static const FeatStd::UInt32 ViewPrefixPropertyId = 0x62E645A4;
        static const FeatStd::UInt32 ViewIdsPropertyId = 0xDFCE346B;
        static const FeatStd::UInt32 CacheViewsPropertyId = 0x4FD1E9AC;
        //! [Property_IDs]

        ViewSwitchWidget2DBase();
        virtual ~ViewSwitchWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ViewSwitchWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_IndexPropertyGetterSetter]
        void SetIndex(const IndexType& index);
        const IndexType& GetIndex() const { return m_Index; }
        //! [DataBinding_IndexPropertyGetterSetter]

        void SetAddInvalidationDependency(const AddInvalidationDependencyType& addinvalidationdependency);
        const AddInvalidationDependencyType& GetAddInvalidationDependency() const { return m_AddInvalidationDependency; }

        //! [DataBinding_ViewPrefixPropertyGetterSetter]
        void SetViewPrefix(const ViewPrefixType& viewprefix);
        const ViewPrefixType& GetViewPrefix() const { return m_ViewPrefix; }
        //! [DataBinding_ViewPrefixPropertyGetterSetter]

        //! [DataBinding_ViewIdsPropertyGetterSetter]
        void SetViewIds(const ViewIdsType& viewids);
        const ViewIdsType& GetViewIds() const { return m_ViewIds; }
        ViewIdsType& GetViewIds() { return m_ViewIds; }
        //! [DataBinding_ViewIdsPropertyGetterSetter]

        //! [DataBinding_CacheViewsPropertyGetterSetter]
        void SetCacheViews(const CacheViewsType& cacheviews);
        const CacheViewsType& GetCacheViews() const { return m_CacheViews; }
        CacheViewsType& GetCacheViews() { return m_CacheViews; }
        //! [DataBinding_CacheViewsPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ViewSwitchWidget2DBase, ::BaseWidget2D)
            CdaDescription("Manages the load/unload and activate/deactivate of some views which are considered as children of the widget's parent view (this scene).")
            CdaReadableName("ViewSwitchWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaBindableProperty(Index, IndexType, GetIndex, SetIndex)
                    CdaDescription("Index of the view which should be visible.")
                CdaBindablePropertyEnd()
                CdaProperty(AddInvalidationDependency, AddInvalidationDependencyType, GetAddInvalidationDependency, SetAddInvalidationDependency)
                    CdaDescription("If set to true then two-way invalidation dependency will be set between the widget's parent view (this scene) and the selected view.")
                CdaPropertyEnd()
                CdaBindableProperty(ViewPrefix, ViewPrefixType, GetViewPrefix, SetViewPrefix)
                    CdaDescription("Prefix to be inserted before view id.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ViewIds, ViewIdsType, GetViewIds, SetViewIds)
                    CdaDescription("Name of the views managed by this widget. The view full name will be obtained by concatenating ViewPrefix and ViewId[Index].")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CacheViews, CacheViewsType, GetCacheViews, SetCacheViews)
                    CdaDescription("If set to true then the unselected views will be deactivated else they will be unloaded (destroyed).")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        IndexType m_Index;
        AddInvalidationDependencyType m_AddInvalidationDependency;
        ViewPrefixType m_ViewPrefix;
        ViewIdsType m_ViewIds;
        CacheViewsType m_CacheViews;
};

#endif // ViewSwitchWidget2DBase_h
