/************************************************************************
*FILE: TwoDimensionSliderWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TwoDimensionSliderWidget2DBase_h)
#define TwoDimensionSliderWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/TwoDimensionSlider/generated/TwoDimensionSliderWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>
// ------------------------------------------------------------------------
//! [TwoDimensionSliderWidget2DBase_Declaration]
class TwoDimensionSliderWidget2DBase : public ::Touchable2D
{
    public:
virtual bool composerPropVisibleFilterPermittedArea() const { return false; }
        typedef Candera::Node2D* SkinNodeType;

        typedef bool ValueUpdateOnDragType;

        typedef Candera::Rectangle SliderAreaType;

        typedef Candera::Int32 HorizontalCurValueType;

        typedef Candera::Int32 HorizontalRangeMinType;

        typedef Candera::Int32 HorizontalRangeMaxType;

        typedef Candera::UInt32 HorizontalStepValueType;

        typedef bool HorizontalMovementLockedType;

        typedef Candera::Int32 VerticalCurValueType;

        typedef Candera::Int32 VerticalRangeMinType;

        typedef Candera::Int32 VerticalRangeMaxType;

        typedef Candera::UInt32 VerticalStepValueType;

        typedef bool VerticalMovementLockedType;

        typedef bool UsePermittedValuesType;

        typedef Candera::Int32 HorizontalPermittedValueMinType;

        typedef Candera::Int32 HorizontalPermittedValueMaxType;

        typedef Candera::Int32 VerticalPermittedValueMinType;

        typedef Candera::Int32 VerticalPermittedValueMaxType;

        //! [Property_IDs]
        static const FeatStd::UInt32 SkinNodePropertyId = 0xAC529069;
        static const FeatStd::UInt32 ValueUpdateOnDragPropertyId = 0x350CD6A5;
        static const FeatStd::UInt32 HorizontalCurValuePropertyId = 0xA67F7E62;
        static const FeatStd::UInt32 HorizontalRangeMinPropertyId = 0xB05E3DB5;
        static const FeatStd::UInt32 HorizontalRangeMaxPropertyId = 0x30FB6C01;
        static const FeatStd::UInt32 HorizontalStepValuePropertyId = 0x5557B32D;
        static const FeatStd::UInt32 HorizontalMovementLockedPropertyId = 0x35B7F8A4;
        static const FeatStd::UInt32 VerticalCurValuePropertyId = 0x2B05AE3F;
        static const FeatStd::UInt32 VerticalRangeMinPropertyId = 0x424993ED;
        static const FeatStd::UInt32 VerticalRangeMaxPropertyId = 0x60BAD9BF;
        static const FeatStd::UInt32 VerticalStepValuePropertyId = 0x554702CF;
        static const FeatStd::UInt32 VerticalMovementLockedPropertyId = 0x3F2870E4;
        static const FeatStd::UInt32 UsePermittedValuesPropertyId = 0x361F8373;
        static const FeatStd::UInt32 HorizontalPermittedValueMinPropertyId = 0x5D63EBCB;
        static const FeatStd::UInt32 HorizontalPermittedValueMaxPropertyId = 0xC0B16B65;
        static const FeatStd::UInt32 VerticalPermittedValueMinPropertyId = 0x2B52EDA8;
        static const FeatStd::UInt32 VerticalPermittedValueMaxPropertyId = 0x1C7A46FB;
        //! [Property_IDs]

        TwoDimensionSliderWidget2DBase();
        virtual ~TwoDimensionSliderWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TwoDimensionSliderWidget2DBase, ::Touchable2D);

        void SetSkinNode(const SkinNodeType& skinnode);
        const SkinNodeType& GetSkinNode() const { return m_SkinNode; }

        void SetValueUpdateOnDrag(const ValueUpdateOnDragType& valueupdateondrag);
        const ValueUpdateOnDragType& GetValueUpdateOnDrag() const { return m_ValueUpdateOnDrag; }

        void SetSliderArea(const SliderAreaType& sliderarea);
        const SliderAreaType& GetSliderArea() const { return m_SliderArea; }

        //! [DataBinding_HorizontalCurValuePropertyGetterSetter]
        void SetHorizontalCurValue(const HorizontalCurValueType& horizontalcurvalue);
        const HorizontalCurValueType& GetHorizontalCurValue() const { return m_HorizontalCurValue; }
        //! [DataBinding_HorizontalCurValuePropertyGetterSetter]

        //! [DataBinding_HorizontalRangeMinPropertyGetterSetter]
        void SetHorizontalRangeMin(const HorizontalRangeMinType& horizontalrangemin);
        const HorizontalRangeMinType& GetHorizontalRangeMin() const { return m_HorizontalRangeMin; }
        //! [DataBinding_HorizontalRangeMinPropertyGetterSetter]

        void SetHorizontalRangeMax(const HorizontalRangeMaxType& horizontalrangemax);
        const HorizontalRangeMaxType& GetHorizontalRangeMax() const { return m_HorizontalRangeMax; }

        void SetHorizontalStepValue(const HorizontalStepValueType& horizontalstepvalue);
        const HorizontalStepValueType& GetHorizontalStepValue() const { return m_HorizontalStepValue; }

        //! [DataBinding_HorizontalMovementLockedPropertyGetterSetter]
        void SetHorizontalMovementLocked(const HorizontalMovementLockedType& horizontalmovementlocked);
        const HorizontalMovementLockedType& GetHorizontalMovementLocked() const { return m_HorizontalMovementLocked; }
        //! [DataBinding_HorizontalMovementLockedPropertyGetterSetter]

        //! [DataBinding_VerticalCurValuePropertyGetterSetter]
        void SetVerticalCurValue(const VerticalCurValueType& verticalcurvalue);
        const VerticalCurValueType& GetVerticalCurValue() const { return m_VerticalCurValue; }
        //! [DataBinding_VerticalCurValuePropertyGetterSetter]

        //! [DataBinding_VerticalRangeMinPropertyGetterSetter]
        void SetVerticalRangeMin(const VerticalRangeMinType& verticalrangemin);
        const VerticalRangeMinType& GetVerticalRangeMin() const { return m_VerticalRangeMin; }
        //! [DataBinding_VerticalRangeMinPropertyGetterSetter]

        void SetVerticalRangeMax(const VerticalRangeMaxType& verticalrangemax);
        const VerticalRangeMaxType& GetVerticalRangeMax() const { return m_VerticalRangeMax; }

        void SetVerticalStepValue(const VerticalStepValueType& verticalstepvalue);
        const VerticalStepValueType& GetVerticalStepValue() const { return m_VerticalStepValue; }

        //! [DataBinding_VerticalMovementLockedPropertyGetterSetter]
        void SetVerticalMovementLocked(const VerticalMovementLockedType& verticalmovementlocked);
        const VerticalMovementLockedType& GetVerticalMovementLocked() const { return m_VerticalMovementLocked; }
        //! [DataBinding_VerticalMovementLockedPropertyGetterSetter]

        //! [DataBinding_UsePermittedValuesPropertyGetterSetter]
        void SetUsePermittedValues(const UsePermittedValuesType& usepermittedvalues);
        const UsePermittedValuesType& GetUsePermittedValues() const { return m_UsePermittedValues; }
        //! [DataBinding_UsePermittedValuesPropertyGetterSetter]

        //! [DataBinding_HorizontalPermittedValueMinPropertyGetterSetter]
        void SetHorizontalPermittedValueMin(const HorizontalPermittedValueMinType& horizontalpermittedvaluemin);
        const HorizontalPermittedValueMinType& GetHorizontalPermittedValueMin() const { return m_HorizontalPermittedValueMin; }
        //! [DataBinding_HorizontalPermittedValueMinPropertyGetterSetter]

        //! [DataBinding_HorizontalPermittedValueMaxPropertyGetterSetter]
        void SetHorizontalPermittedValueMax(const HorizontalPermittedValueMaxType& horizontalpermittedvaluemax);
        const HorizontalPermittedValueMaxType& GetHorizontalPermittedValueMax() const { return m_HorizontalPermittedValueMax; }
        //! [DataBinding_HorizontalPermittedValueMaxPropertyGetterSetter]

        //! [DataBinding_VerticalPermittedValueMinPropertyGetterSetter]
        void SetVerticalPermittedValueMin(const VerticalPermittedValueMinType& verticalpermittedvaluemin);
        const VerticalPermittedValueMinType& GetVerticalPermittedValueMin() const { return m_VerticalPermittedValueMin; }
        //! [DataBinding_VerticalPermittedValueMinPropertyGetterSetter]

        //! [DataBinding_VerticalPermittedValueMaxPropertyGetterSetter]
        void SetVerticalPermittedValueMax(const VerticalPermittedValueMaxType& verticalpermittedvaluemax);
        const VerticalPermittedValueMaxType& GetVerticalPermittedValueMax() const { return m_VerticalPermittedValueMax; }
        //! [DataBinding_VerticalPermittedValueMaxPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(TwoDimensionSliderWidget2DBase, ::Touchable2D)
            CdaDescription("TwoDimensionSliderWidget2D is used to get the touched position values based on the horizontal and vertical values set by the user. Add a group node, add three bitmap node for the crosshair, first for the knob, 2nd for horizontal line and 3rd for vertical line.")
            CdaReadableName("TwoDimensionSliderWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(SkinNode, SkinNodeType, GetSkinNode, SetSkinNode)
                    CdaDescription("The node of the background skin.")
                CdaPropertyEnd()
                CdaProperty(ValueUpdateOnDrag, ValueUpdateOnDragType, GetValueUpdateOnDrag, SetValueUpdateOnDrag)
                    CdaDescription("Set to true if value updates are required while dragging, set to false if update is required only at the end of the drag operation,  .")
                CdaPropertyEnd()
                CdaProperty(SliderArea, SliderAreaType, GetSliderArea, SetSliderArea)
                    CdaDescription("Configures the touchable area of the slider. X and Y are coordinates relative to the upper left corner of the node effective bounding rectangle. If width or height are zero or negative the effective bounding rectangle of the node will be used as touchable area (X and Y will also be ignored).")
                CdaPropertyEnd()
                CdaBindableProperty(HorizontalCurValue, HorizontalCurValueType, GetHorizontalCurValue, SetHorizontalCurValue)
                    CdaDescription("Current horizontal value of marker based on the range (int).")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HorizontalRangeMin, HorizontalRangeMinType, GetHorizontalRangeMin, SetHorizontalRangeMin)
                    CdaDescription("Min scale value for horizontal marker (int).")
                CdaBindablePropertyEnd()
                CdaProperty(HorizontalRangeMax, HorizontalRangeMaxType, GetHorizontalRangeMax, SetHorizontalRangeMax)
                    CdaDescription("Max scale value for horizontal marker  (int).")
                CdaPropertyEnd()
                CdaProperty(HorizontalStepValue, HorizontalStepValueType, GetHorizontalStepValue, SetHorizontalStepValue)
                    CdaDescription("Horizontal marker movement step value given in unsigned integer for move messages, default=1")
                CdaPropertyEnd()
                CdaBindableProperty(HorizontalMovementLocked, HorizontalMovementLockedType, GetHorizontalMovementLocked, SetHorizontalMovementLocked)
                    CdaDescription("Only vertical movement allowed, e.g for Audio Fader")
                CdaBindablePropertyEnd()
                CdaBindableProperty(VerticalCurValue, VerticalCurValueType, GetVerticalCurValue, SetVerticalCurValue)
                    CdaDescription("Current vertical value of marker based on the range (int).")
                CdaBindablePropertyEnd()
                CdaBindableProperty(VerticalRangeMin, VerticalRangeMinType, GetVerticalRangeMin, SetVerticalRangeMin)
                    CdaDescription("Min scale value for vertical marker (int).")
                CdaBindablePropertyEnd()
                CdaProperty(VerticalRangeMax, VerticalRangeMaxType, GetVerticalRangeMax, SetVerticalRangeMax)
                    CdaDescription("Max scale value for vertical marker (int).")
                CdaPropertyEnd()
                CdaProperty(VerticalStepValue, VerticalStepValueType, GetVerticalStepValue, SetVerticalStepValue)
                    CdaDescription("Vertical marker movement step value given in unsigned integer for move messages, default=1")
                CdaPropertyEnd()
                CdaBindableProperty(VerticalMovementLocked, VerticalMovementLockedType, GetVerticalMovementLocked, SetVerticalMovementLocked)
                    CdaDescription("Only vhorizontal movement allowed, e.g for Audio Fader")
                CdaBindablePropertyEnd()
                CdaBindableProperty(UsePermittedValues, UsePermittedValuesType, GetUsePermittedValues, SetUsePermittedValues)
                    CdaDescription("Make use of permitted values inside of given range values")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HorizontalPermittedValueMin, HorizontalPermittedValueMinType, GetHorizontalPermittedValueMin, SetHorizontalPermittedValueMin)
                    CdaDescription("Permitted range value, allowed valid area inside given range (int).")
                    CdaVisibilityTest(composerPropVisibleFilterPermittedArea)
                CdaBindablePropertyEnd()
                CdaBindableProperty(HorizontalPermittedValueMax, HorizontalPermittedValueMaxType, GetHorizontalPermittedValueMax, SetHorizontalPermittedValueMax)
                    CdaDescription("Permitted range value, allowed valid area inside given range (int).")
                    CdaVisibilityTest(composerPropVisibleFilterPermittedArea)
                CdaBindablePropertyEnd()
                CdaBindableProperty(VerticalPermittedValueMin, VerticalPermittedValueMinType, GetVerticalPermittedValueMin, SetVerticalPermittedValueMin)
                    CdaDescription("Permitted range value, allowed valid area inside given range (int).")
                    CdaVisibilityTest(composerPropVisibleFilterPermittedArea)
                CdaBindablePropertyEnd()
                CdaBindableProperty(VerticalPermittedValueMax, VerticalPermittedValueMaxType, GetVerticalPermittedValueMax, SetVerticalPermittedValueMax)
                    CdaDescription("Permitted range value, allowed valid area inside given range (int).")
                    CdaVisibilityTest(composerPropVisibleFilterPermittedArea)
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        SkinNodeType m_SkinNode;
        ValueUpdateOnDragType m_ValueUpdateOnDrag;
        SliderAreaType m_SliderArea;
        HorizontalCurValueType m_HorizontalCurValue;
        HorizontalRangeMinType m_HorizontalRangeMin;
        HorizontalRangeMaxType m_HorizontalRangeMax;
        HorizontalStepValueType m_HorizontalStepValue;
        HorizontalMovementLockedType m_HorizontalMovementLocked;
        VerticalCurValueType m_VerticalCurValue;
        VerticalRangeMinType m_VerticalRangeMin;
        VerticalRangeMaxType m_VerticalRangeMax;
        VerticalStepValueType m_VerticalStepValue;
        VerticalMovementLockedType m_VerticalMovementLocked;
        UsePermittedValuesType m_UsePermittedValues;
        HorizontalPermittedValueMinType m_HorizontalPermittedValueMin;
        HorizontalPermittedValueMaxType m_HorizontalPermittedValueMax;
        VerticalPermittedValueMinType m_VerticalPermittedValueMin;
        VerticalPermittedValueMaxType m_VerticalPermittedValueMax;
};

#endif // TwoDimensionSliderWidget2DBase_h
