/************************************************************************
*FILE: TimerWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TimerWidget2DBase_h)
#define TimerWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/TimerWidget/generated/TimerWidget2DMessages.h>
// ------------------------------------------------------------------------
//! [TimerWidget2DBase_Declaration]
class TimerWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef bool AutoStartEnabledType;

        typedef Candera::UInt32 TimerDurationType;

        typedef bool AutoRestartEnabledType;

        typedef bool StartStopTriggerType;

        typedef bool PauseTriggerType;

        //! [Property_IDs]
        static const FeatStd::UInt32 AutoStartEnabledPropertyId = 0x0B4F2B74;
        static const FeatStd::UInt32 TimerDurationPropertyId = 0x7DA996DA;
        static const FeatStd::UInt32 AutoRestartEnabledPropertyId = 0x1330FB98;
        static const FeatStd::UInt32 StartStopTriggerPropertyId = 0x784AD863;
        static const FeatStd::UInt32 PauseTriggerPropertyId = 0xADF16A25;
        //! [Property_IDs]

        TimerWidget2DBase();
        virtual ~TimerWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TimerWidget2DBase, ::BaseWidget2D);

        void SetAutoStartEnabled(const AutoStartEnabledType& autostartenabled);
        const AutoStartEnabledType& GetAutoStartEnabled() const { return m_AutoStartEnabled; }

        void SetTimerDuration(const TimerDurationType& timerduration);
        const TimerDurationType& GetTimerDuration() const { return m_TimerDuration; }

        void SetAutoRestartEnabled(const AutoRestartEnabledType& autorestartenabled);
        const AutoRestartEnabledType& GetAutoRestartEnabled() const { return m_AutoRestartEnabled; }

        //! [DataBinding_StartStopTriggerPropertyGetterSetter]
        void SetStartStopTrigger(const StartStopTriggerType& startstoptrigger);
        const StartStopTriggerType& GetStartStopTrigger() const { return m_StartStopTrigger; }
        //! [DataBinding_StartStopTriggerPropertyGetterSetter]

        //! [DataBinding_PauseTriggerPropertyGetterSetter]
        void SetPauseTrigger(const PauseTriggerType& pausetrigger);
        const PauseTriggerType& GetPauseTrigger() const { return m_PauseTrigger; }
        //! [DataBinding_PauseTriggerPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(TimerWidget2DBase, ::BaseWidget2D)
            CdaDescription("TimerWidget2D widget")
            CdaReadableName("TimerWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaProperty(AutoStartEnabled, AutoStartEnabledType, GetAutoStartEnabled, SetAutoStartEnabled)
                    CdaDescription("When this is Enabled, the timer will be started automatically on the render activation of the scene.")
                CdaPropertyEnd()
                CdaProperty(TimerDuration, TimerDurationType, GetTimerDuration, SetTimerDuration)
                    CdaDescription("This property holds the timeout value in milli seconds.")
                CdaPropertyEnd()
                CdaProperty(AutoRestartEnabled, AutoRestartEnabledType, GetAutoRestartEnabled, SetAutoRestartEnabled)
                    CdaDescription("When this property is Enabled, the timer will run recursively until deactivation of the scene.")
                CdaPropertyEnd()
                CdaBindableProperty(StartStopTrigger, StartStopTriggerType, GetStartStopTrigger, SetStartStopTrigger)
                    CdaDescription("This is an explicit trigger to start or stop the timer. When set to false the timer is stopped, always. On setting the StartStopTrigger property to true it causes a restart of the timer.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PauseTrigger, PauseTriggerType, GetPauseTrigger, SetPauseTrigger)
                    CdaDescription("This is an explicit trigger to pause the timer. When set to true a running timer(if any) is paused. When set to false a paused timer(if any) continues to run.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        AutoStartEnabledType m_AutoStartEnabled;
        TimerDurationType m_TimerDuration;
        AutoRestartEnabledType m_AutoRestartEnabled;
        StartStopTriggerType m_StartStopTrigger;
        PauseTriggerType m_PauseTrigger;
};

#endif // TimerWidget2DBase_h
