/************************************************************************
*FILE: TextExtensionWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TextExtensionWidget2DBase_h)
#define TextExtensionWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <CanderaWidget/String/String.h>
#include <Candera/TextEngine/Types.h>
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ExtensionMethod)  \
        ENUM_DATA_TYPE_ITEM(TEXTCONCAT)           \
        ENUM_DATA_TYPE_ITEM(TEXTSWITCH)           \
        ENUM_DATA_TYPE_ITEM(TEXTWITHARGS)         \
    ENUM_DATA_TYPE_END(ExtensionMethod)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [TextExtensionWidget2DBase_Declaration]
class TextExtensionWidget2DBase : public ::BaseWidget2D
{
    public:
virtual bool ComposerPropFilterTimer() const { return false; }
virtual bool ComposerPropFilterArgs() const { return false; }
        typedef Candera::String FormatTextType;

        typedef Candera::String Text1Type;

        typedef Candera::String Text2Type;

        typedef Candera::String Text3Type;

        typedef Candera::String Text4Type;

        typedef Candera::String Text5Type;

        typedef Candera::ExtensionMethod ExtensionMethodType;

        typedef Candera::UInt16 AnimationTimeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 FormatTextPropertyId = 0xE2A90ACB;
        static const FeatStd::UInt32 Text1PropertyId = 0x0EFF254A;
        static const FeatStd::UInt32 Text2PropertyId = 0x6246CBD8;
        static const FeatStd::UInt32 Text3PropertyId = 0x737D6E45;
        static const FeatStd::UInt32 Text4PropertyId = 0x4D7C2247;
        static const FeatStd::UInt32 Text5PropertyId = 0x5FD1C6F2;
        static const FeatStd::UInt32 ExtensionMethodPropertyId = 0xD07A46C4;
        static const FeatStd::UInt32 AnimationTimePropertyId = 0x4E42C1A7;
        //! [Property_IDs]

        TextExtensionWidget2DBase();
        virtual ~TextExtensionWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextExtensionWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_FormatTextPropertyGetterSetter]
        void SetFormatText(const FormatTextType& formattext);
        const FormatTextType& GetFormatText() const { return m_FormatText; }
        //! [DataBinding_FormatTextPropertyGetterSetter]

        //! [DataBinding_Text1PropertyGetterSetter]
        void SetText1(const Text1Type& text1);
        const Text1Type& GetText1() const { return m_Text1; }
        //! [DataBinding_Text1PropertyGetterSetter]

        //! [DataBinding_Text2PropertyGetterSetter]
        void SetText2(const Text2Type& text2);
        const Text2Type& GetText2() const { return m_Text2; }
        //! [DataBinding_Text2PropertyGetterSetter]

        //! [DataBinding_Text3PropertyGetterSetter]
        void SetText3(const Text3Type& text3);
        const Text3Type& GetText3() const { return m_Text3; }
        //! [DataBinding_Text3PropertyGetterSetter]

        //! [DataBinding_Text4PropertyGetterSetter]
        void SetText4(const Text4Type& text4);
        const Text4Type& GetText4() const { return m_Text4; }
        //! [DataBinding_Text4PropertyGetterSetter]

        //! [DataBinding_Text5PropertyGetterSetter]
        void SetText5(const Text5Type& text5);
        const Text5Type& GetText5() const { return m_Text5; }
        //! [DataBinding_Text5PropertyGetterSetter]

        void SetExtensionMethod(const ExtensionMethodType& extensionmethod);
        const ExtensionMethodType& GetExtensionMethod() const { return m_ExtensionMethod; }

        void SetAnimationTime(const AnimationTimeType& animationtime);
        const AnimationTimeType& GetAnimationTime() const { return m_AnimationTime; }

        // @WidgetBaseClass
        CdaWidget2DDef(TextExtensionWidget2DBase, ::BaseWidget2D)
            CdaDescription("TextExtensionWidget2D is a widget extension, that is capable to set special text configurations(like 'printf' style or animated strings) to a standard text widget. This extension widget uses the TextWidget on same node on which it will set the text depending on the Method property(TEXTCONCAT, TEXTSWITCH, TEXTWITHARGS). The TextWidget should be linked to a node which is ancestor of the this node widget, in most cases the TextWidget and the TextExtensionWidget are linked to the same node. A simple sample for the ARGS feature could be: 'Hello $(2:) and $(1:)?'")
            CdaReadableName("TextExtensionWidget2DBase")
            CdaCategory("Text")

            CdaProperties()
                CdaBindableProperty(FormatText, FormatTextType, GetFormatText, SetFormatText)
                    CdaDescription("Text string with containing format identifier for insertion. e.g. ")
                    CdaVisibilityTest(ComposerPropFilterArgs)
                CdaBindablePropertyEnd()
                CdaBindableProperty(Text1, Text1Type, GetText1, SetText1)
                    CdaDescription("The text1 to be displayed on the label")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Text2, Text2Type, GetText2, SetText2)
                    CdaDescription("The text2 to be displayed on the label")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Text3, Text3Type, GetText3, SetText3)
                    CdaDescription("The text3 to be displayed on the label")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Text4, Text4Type, GetText4, SetText4)
                    CdaDescription("The text4 to be displayed on the label")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Text5, Text5Type, GetText5, SetText5)
                    CdaDescription("The text5 to be displayed on the label")
                CdaBindablePropertyEnd()
                CdaProperty(ExtensionMethod, ExtensionMethodType, GetExtensionMethod, SetExtensionMethod)
                    CdaDescription("ExtensionMethod")
                CdaPropertyEnd()
                CdaProperty(AnimationTime, AnimationTimeType, GetAnimationTime, SetAnimationTime)
                    CdaDescription("Speed for switching between the text parts")
                    CdaVisibilityTest(ComposerPropFilterTimer)
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        FormatTextType m_FormatText;
        Text1Type m_Text1;
        Text2Type m_Text2;
        Text3Type m_Text3;
        Text4Type m_Text4;
        Text5Type m_Text5;
        ExtensionMethodType m_ExtensionMethod;
        AnimationTimeType m_AnimationTime;
};

#endif // TextExtensionWidget2DBase_h
