/************************************************************************
*FILE: TextExtensionWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "TextExtensionWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(TextExtensionWidget2DBase)

TextExtensionWidget2DBase::TextExtensionWidget2DBase() :
    m_FormatText(FormatTextType()),
    m_Text1(Text1Type()),
    m_Text2(Text2Type()),
    m_Text3(Text3Type()),
    m_Text4(Text4Type()),
    m_Text5(Text5Type()),
    m_ExtensionMethod(Candera::TEXTCONCAT),
    m_AnimationTime(2000)
{
}

TextExtensionWidget2DBase::~TextExtensionWidget2DBase()
{
}

void TextExtensionWidget2DBase::SetFormatText(const FormatTextType& formattext)
{
    if (m_FormatText != formattext) {
        m_FormatText = formattext;
        OnChanged(static_cast< ::FeatStd::UInt32>(FormatTextPropertyId));
    }
}

void TextExtensionWidget2DBase::SetText1(const Text1Type& text1)
{
    if (m_Text1 != text1) {
        m_Text1 = text1;
        OnChanged(static_cast< ::FeatStd::UInt32>(Text1PropertyId));
    }
}

void TextExtensionWidget2DBase::SetText2(const Text2Type& text2)
{
    if (m_Text2 != text2) {
        m_Text2 = text2;
        OnChanged(static_cast< ::FeatStd::UInt32>(Text2PropertyId));
    }
}

void TextExtensionWidget2DBase::SetText3(const Text3Type& text3)
{
    if (m_Text3 != text3) {
        m_Text3 = text3;
        OnChanged(static_cast< ::FeatStd::UInt32>(Text3PropertyId));
    }
}

void TextExtensionWidget2DBase::SetText4(const Text4Type& text4)
{
    if (m_Text4 != text4) {
        m_Text4 = text4;
        OnChanged(static_cast< ::FeatStd::UInt32>(Text4PropertyId));
    }
}

void TextExtensionWidget2DBase::SetText5(const Text5Type& text5)
{
    if (m_Text5 != text5) {
        m_Text5 = text5;
        OnChanged(static_cast< ::FeatStd::UInt32>(Text5PropertyId));
    }
}

void TextExtensionWidget2DBase::SetExtensionMethod(const ExtensionMethodType& extensionmethod)
{
    if (m_ExtensionMethod != extensionmethod) {
        m_ExtensionMethod = extensionmethod;
        OnChanged(static_cast< ::FeatStd::UInt32>(ExtensionMethodPropertyId));
    }
}

void TextExtensionWidget2DBase::SetAnimationTime(const AnimationTimeType& animationtime)
{
    if (m_AnimationTime != animationtime) {
        m_AnimationTime = animationtime;
        OnChanged(static_cast< ::FeatStd::UInt32>(AnimationTimePropertyId));
    }
}
