/************************************************************************
*FILE: TextColorWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TextColorWidget2DBase_h)
#define TextColorWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [TextColorWidget2DBase_Declaration]
class TextColorWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::Color NormalTextColorType;

        typedef Candera::Color DisabledTextColorType;

        typedef Candera::Color ActiveTextColorType;

        //! [Property_IDs]
        static const FeatStd::UInt32 NormalTextColorPropertyId = 0x80687832;
        static const FeatStd::UInt32 DisabledTextColorPropertyId = 0xA2474CE1;
        static const FeatStd::UInt32 ActiveTextColorPropertyId = 0xCD2D090E;
        //! [Property_IDs]

        TextColorWidget2DBase();
        virtual ~TextColorWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextColorWidget2DBase, ::BaseWidget2D);

        void SetNormalTextColor(const NormalTextColorType& normaltextcolor);
        const NormalTextColorType& GetNormalTextColor() const { return m_NormalTextColor; }

        void SetDisabledTextColor(const DisabledTextColorType& disabledtextcolor);
        const DisabledTextColorType& GetDisabledTextColor() const { return m_DisabledTextColor; }

        void SetActiveTextColor(const ActiveTextColorType& activetextcolor);
        const ActiveTextColorType& GetActiveTextColor() const { return m_ActiveTextColor; }

        // @WidgetBaseClass
        CdaWidget2DDef(TextColorWidget2DBase, ::BaseWidget2D)
            CdaDescription("Changes the color of a text depending on the enabled and active properties. This extension widget uses a text widget in the same scene on which it will set the text color depending on the Enabled property of the text widget and Active property of this widget. The text widget should be linked to a node which is ancestor of the this node widget. A particular situation would be when the text widget and the text color widget are linked to the same node.")
            CdaReadableName("TextColorWidget2DBase")
            CdaCategory("Text")

            CdaProperties()
                CdaProperty(NormalTextColor, NormalTextColorType, GetNormalTextColor, SetNormalTextColor)
                    CdaDescription("Text color used when the state is enabled and not active.")
                    CdaCategory("Color")
                CdaPropertyEnd()
                CdaProperty(DisabledTextColor, DisabledTextColorType, GetDisabledTextColor, SetDisabledTextColor)
                    CdaDescription("Text color used when the state is disabled (active info will be ignored).")
                    CdaCategory("Color")
                CdaPropertyEnd()
                CdaProperty(ActiveTextColor, ActiveTextColorType, GetActiveTextColor, SetActiveTextColor)
                    CdaDescription("Text color used when the enabled and active.")
                    CdaCategory("Color")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        NormalTextColorType m_NormalTextColor;
        DisabledTextColorType m_DisabledTextColor;
        ActiveTextColorType m_ActiveTextColor;
};

#endif // TextColorWidget2DBase_h
