/************************************************************************
*FILE: TextBaseLineOffsetWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TextBaseLineOffsetWidget2DBase_h)
#define TextBaseLineOffsetWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [TextBaseLineOffsetWidget2DBase_Declaration]
class TextBaseLineOffsetWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::Int16 FontLineHeightType;

        typedef Candera::Float SingleLineOffsetType;

        typedef Candera::Float MultipleLinesOffsetType;

        //! [Property_IDs]
        static const FeatStd::UInt32 FontLineHeightPropertyId = 0xEB6B341C;
        static const FeatStd::UInt32 SingleLineOffsetPropertyId = 0x0ACA8CC7;
        static const FeatStd::UInt32 MultipleLinesOffsetPropertyId = 0x076451C5;
        //! [Property_IDs]

        TextBaseLineOffsetWidget2DBase();
        virtual ~TextBaseLineOffsetWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextBaseLineOffsetWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_FontLineHeightPropertyGetterSetter]
        void SetFontLineHeight(const FontLineHeightType& fontlineheight);
        const FontLineHeightType& GetFontLineHeight() const { return m_FontLineHeight; }
        //! [DataBinding_FontLineHeightPropertyGetterSetter]

        //! [DataBinding_SingleLineOffsetPropertyGetterSetter]
        void SetSingleLineOffset(const SingleLineOffsetType& singlelineoffset);
        const SingleLineOffsetType& GetSingleLineOffset() const { return m_SingleLineOffset; }
        //! [DataBinding_SingleLineOffsetPropertyGetterSetter]

        //! [DataBinding_MultipleLinesOffsetPropertyGetterSetter]
        void SetMultipleLinesOffset(const MultipleLinesOffsetType& multiplelinesoffset);
        const MultipleLinesOffsetType& GetMultipleLinesOffset() const { return m_MultipleLinesOffset; }
        //! [DataBinding_MultipleLinesOffsetPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(TextBaseLineOffsetWidget2DBase, ::BaseWidget2D)
            CdaDescription("Attach this widget to a text RenderNode in order to control the BaseLineOffset property of the parent Group depending on the number of text lines which are rendered. The height of the text box is compared to the font line height to determine if the text is single line or multiple lines.")
            CdaReadableName("TextBaseLineOffsetWidget2DBase")
            CdaCategory("Text")

            CdaProperties()
                CdaBindableProperty(FontLineHeight, FontLineHeightType, GetFontLineHeight, SetFontLineHeight)
                    CdaDescription("Font line height is compared to the height of the text box to determine if the text is single or multiple lines. If the property value is not greater than 0 then it will be obtained from the font metrics.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SingleLineOffset, SingleLineOffsetType, GetSingleLineOffset, SetSingleLineOffset)
                    CdaDescription("Offset to be used when the text is rendered on a single line.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(MultipleLinesOffset, MultipleLinesOffsetType, GetMultipleLinesOffset, SetMultipleLinesOffset)
                    CdaDescription("Offset to be used when the text is rendered on multiple lines.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        FontLineHeightType m_FontLineHeight;
        SingleLineOffsetType m_SingleLineOffset;
        MultipleLinesOffsetType m_MultipleLinesOffset;
};

#endif // TextBaseLineOffsetWidget2DBase_h
