/************************************************************************
*FILE: TextAreaWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "TextAreaWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(TextAreaWidget2DBase)

TextAreaWidget2DBase::TextAreaWidget2DBase() :
    m_TruncationMode(TruncationModeType()),
    m_TruncationText(TruncationTextType()),
    m_TextWidgetMode(TextWidgetModeType()),
    m_ItemOrder(ItemOrderType()),
    m_DisabledTextColor(DisabledTextColorType()),
    m_HighlightTextColor(HighlightTextColorType()),
    m_ActiveTextColor(ActiveTextColorType()),
    m_ScrollSpeed(ScrollSpeedType()),
    m_ScrollStartDelay(ScrollStartDelayType()),
    m_ScrollEndDelay(ScrollEndDelayType()),
    m_HighlightMode(HighlightModeType()),
    m_HighlightStartIndex(HighlightStartIndexType()),
    m_HighlightCount(HighlightCountType()),
    m_HighlightText(HighlightTextType()),
    m_EnableDynamicText(EnableDynamicTextType()),
    m_TextParameter1(TextParameter1Type()),
    m_TextParameter2(TextParameter2Type()),
    m_TextParameter3(TextParameter3Type()),
    m_TextParameter4(TextParameter4Type()),
    m_TextParameter5(TextParameter5Type()),
    m_TextParameter6(TextParameter6Type()),
    m_MultiLineLayouting(false),
    m_LinespacingFactor(LinespacingFactorType()),
    m_TextWrapMode(TextWrapModeType()),
    m_MaximumNumberOfLines(1)
{
}

TextAreaWidget2DBase::~TextAreaWidget2DBase()
{
}

void TextAreaWidget2DBase::SetTruncationMode(const TruncationModeType& truncationmode)
{
    if (m_TruncationMode != truncationmode) {
        m_TruncationMode = truncationmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(TruncationModePropertyId));
    }
}

void TextAreaWidget2DBase::SetTruncationText(const TruncationTextType& truncationtext)
{
    if (m_TruncationText != truncationtext) {
        m_TruncationText = truncationtext;
        OnChanged(static_cast< ::FeatStd::UInt32>(TruncationTextPropertyId));
    }
}

void TextAreaWidget2DBase::SetTextWidgetMode(const TextWidgetModeType& textwidgetmode)
{
    if (m_TextWidgetMode != textwidgetmode) {
        m_TextWidgetMode = textwidgetmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextWidgetModePropertyId));
    }
}

void TextAreaWidget2DBase::SetItemOrder(const ItemOrderType& itemorder)
{
    if (m_ItemOrder != itemorder) {
        m_ItemOrder = itemorder;
        OnChanged(static_cast< ::FeatStd::UInt32>(ItemOrderPropertyId));
    }
}

void TextAreaWidget2DBase::SetDisabledTextColor(const DisabledTextColorType& disabledtextcolor)
{
    if (m_DisabledTextColor != disabledtextcolor) {
        m_DisabledTextColor = disabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(DisabledTextColorPropertyId));
    }
}

void TextAreaWidget2DBase::SetHighlightTextColor(const HighlightTextColorType& highlighttextcolor)
{
    if (m_HighlightTextColor != highlighttextcolor) {
        m_HighlightTextColor = highlighttextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightTextColorPropertyId));
    }
}

void TextAreaWidget2DBase::SetActiveTextColor(const ActiveTextColorType& activetextcolor)
{
    if (m_ActiveTextColor != activetextcolor) {
        m_ActiveTextColor = activetextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActiveTextColorPropertyId));
    }
}

void TextAreaWidget2DBase::SetScrollSpeed(const ScrollSpeedType& scrollspeed)
{
    if (m_ScrollSpeed != scrollspeed) {
        m_ScrollSpeed = scrollspeed;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollSpeedPropertyId));
    }
}

void TextAreaWidget2DBase::SetScrollStartDelay(const ScrollStartDelayType& scrollstartdelay)
{
    if (m_ScrollStartDelay != scrollstartdelay) {
        m_ScrollStartDelay = scrollstartdelay;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollStartDelayPropertyId));
    }
}

void TextAreaWidget2DBase::SetScrollEndDelay(const ScrollEndDelayType& scrollenddelay)
{
    if (m_ScrollEndDelay != scrollenddelay) {
        m_ScrollEndDelay = scrollenddelay;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollEndDelayPropertyId));
    }
}

void TextAreaWidget2DBase::SetHighlightMode(const HighlightModeType& highlightmode)
{
    if (m_HighlightMode != highlightmode) {
        m_HighlightMode = highlightmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightModePropertyId));
    }
}

void TextAreaWidget2DBase::SetHighlightStartIndex(const HighlightStartIndexType& highlightstartindex)
{
    if (m_HighlightStartIndex != highlightstartindex) {
        m_HighlightStartIndex = highlightstartindex;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightStartIndexPropertyId));
    }
}

void TextAreaWidget2DBase::SetHighlightCount(const HighlightCountType& highlightcount)
{
    if (m_HighlightCount != highlightcount) {
        m_HighlightCount = highlightcount;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightCountPropertyId));
    }
}

void TextAreaWidget2DBase::SetHighlightText(const HighlightTextType& highlighttext)
{
    if (m_HighlightText != highlighttext) {
        m_HighlightText = highlighttext;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightTextPropertyId));
    }
}

void TextAreaWidget2DBase::SetEnableDynamicText(const EnableDynamicTextType& enabledynamictext)
{
    if (m_EnableDynamicText != enabledynamictext) {
        m_EnableDynamicText = enabledynamictext;
        OnChanged(static_cast< ::FeatStd::UInt32>(EnableDynamicTextPropertyId));
    }
}

void TextAreaWidget2DBase::SetTextParameter1(const TextParameter1Type& textparameter1)
{
    if (m_TextParameter1 != textparameter1) {
        m_TextParameter1 = textparameter1;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextParameter1PropertyId));
    }
}

void TextAreaWidget2DBase::SetTextParameter2(const TextParameter2Type& textparameter2)
{
    if (m_TextParameter2 != textparameter2) {
        m_TextParameter2 = textparameter2;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextParameter2PropertyId));
    }
}

void TextAreaWidget2DBase::SetTextParameter3(const TextParameter3Type& textparameter3)
{
    if (m_TextParameter3 != textparameter3) {
        m_TextParameter3 = textparameter3;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextParameter3PropertyId));
    }
}

void TextAreaWidget2DBase::SetTextParameter4(const TextParameter4Type& textparameter4)
{
    if (m_TextParameter4 != textparameter4) {
        m_TextParameter4 = textparameter4;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextParameter4PropertyId));
    }
}

void TextAreaWidget2DBase::SetTextParameter5(const TextParameter5Type& textparameter5)
{
    if (m_TextParameter5 != textparameter5) {
        m_TextParameter5 = textparameter5;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextParameter5PropertyId));
    }
}

void TextAreaWidget2DBase::SetTextParameter6(const TextParameter6Type& textparameter6)
{
    if (m_TextParameter6 != textparameter6) {
        m_TextParameter6 = textparameter6;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextParameter6PropertyId));
    }
}

void TextAreaWidget2DBase::SetMultiLineLayouting(const MultiLineLayoutingType& multilinelayouting)
{
    if (m_MultiLineLayouting != multilinelayouting) {
        m_MultiLineLayouting = multilinelayouting;
        OnChanged(static_cast< ::FeatStd::UInt32>(MultiLineLayoutingPropertyId));
    }
}

void TextAreaWidget2DBase::SetLinespacingFactor(const LinespacingFactorType& linespacingfactor)
{
    if (m_LinespacingFactor != linespacingfactor) {
        m_LinespacingFactor = linespacingfactor;
        OnChanged(static_cast< ::FeatStd::UInt32>(LinespacingFactorPropertyId));
    }
}

void TextAreaWidget2DBase::SetTextWrapMode(const TextWrapModeType& textwrapmode)
{
    if (m_TextWrapMode != textwrapmode) {
        m_TextWrapMode = textwrapmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextWrapModePropertyId));
    }
}

void TextAreaWidget2DBase::SetMaximumNumberOfLines(const MaximumNumberOfLinesType& maximumnumberoflines)
{
    if (m_MaximumNumberOfLines != maximumnumberoflines) {
        m_MaximumNumberOfLines = maximumnumberoflines;
        OnChanged(static_cast< ::FeatStd::UInt32>(MaximumNumberOfLinesPropertyId));
    }
}
