/************************************************************************
*FILE: TextWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TextWidget2DBase_h)
#define TextWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/Text/generated/TextWidget2DTypes.h>
#include <CanderaWidget/String/String.h>
#include <Candera/TextEngine/Types.h>
#include <Widgets/2D/BaseWidget2D.h>
#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/Effects/GlOutlineTextBrushBlend.h>
#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/Effects/GlOutlineBitmapBrushColorBlend.h>
#include <Candera/Engine2D/Core/RenderNode.h>
/* Description about enTruncationDirection Enum
 * Left - Truncation direction is left
 * Right - Truncation direction is right
 */
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(enTruncationDirection)        \
        ENUM_DATA_TYPE_ITEM_VALUE(Left, 0)    \
        ENUM_DATA_TYPE_ITEM_VALUE(Right, 1) \
    ENUM_DATA_TYPE_END(enTruncationDirection)
#include <Candera/System/MetaInfo/EnumDataType.h>

/* Description about ScrollBehavior Enum
 * Off - Scroll mode off
 */
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ScrollBehavior)        \
        ENUM_DATA_TYPE_ITEM_VALUE(Off, 0) \
        ENUM_DATA_TYPE_ITEM_VALUE(Circular, 1) \
        ENUM_DATA_TYPE_ITEM_VALUE(EndOfLineOnce, 2) \
        ENUM_DATA_TYPE_ITEM_VALUE(EndOfLineRepeat, 3) \
        ENUM_DATA_TYPE_ITEM_VALUE(EndOfLineRemain, 4) \
    ENUM_DATA_TYPE_END(ScrollBehavior)
#include <Candera/System/MetaInfo/EnumDataType.h>

/* Description about ScrollStart Enum
 * Off - Scroll mode off
 * On - Scroll mode on
 */
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ScrollStartMode)        \
        ENUM_DATA_TYPE_ITEM_VALUE(External, 0) \
        ENUM_DATA_TYPE_ITEM_VALUE(Auto, 1) \
        ENUM_DATA_TYPE_ITEM_VALUE(OnTouch, 2) \
    ENUM_DATA_TYPE_END(ScrollStartMode)
#include <Candera/System/MetaInfo/EnumDataType.h>

#ifdef VARIANT_S_FTR_ENABLE_TEXTWIDGET2DV2
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TruncationMethod)  \
        ENUM_DATA_TYPE_ITEM(Hard)           \
        ENUM_DATA_TYPE_ITEM(Soft)           \
        ENUM_DATA_TYPE_ITEM(Text)           \
        ENUM_DATA_TYPE_ITEM(NoneTruncation)         \
    ENUM_DATA_TYPE_END(TruncationMethod)
#include <Candera/System/MetaInfo/EnumDataType.h>
#else
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TruncationMethod)  \
        ENUM_DATA_TYPE_ITEM(Hard)           \
        ENUM_DATA_TYPE_ITEM(Soft)           \
        ENUM_DATA_TYPE_ITEM(Text)           \
        ENUM_DATA_TYPE_ITEM(Shrink)         \
        ENUM_DATA_TYPE_ITEM(NoneTruncation)         \
    ENUM_DATA_TYPE_END(TruncationMethod)
#include <Candera/System/MetaInfo/EnumDataType.h>
#endif
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ShrinkMethod)  \
        ENUM_DATA_TYPE_ITEM(NoShrink)           \
        ENUM_DATA_TYPE_ITEM(CondenseAndShrink)           \
    ENUM_DATA_TYPE_END(ShrinkMethod)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [TextWidget2DBase_Declaration]
class TextWidget2DBase : public ::BaseWidget2D
{
    public:
virtual bool ComposerPropVisibleFilterTruncation() const { return true; }
virtual bool ComposerPropVisibleFilterMultiline() const { return true; }
virtual bool ComposerPropVisibleFilterScrolling() const { return true; }
virtual bool ComposerPropVisibleFilterNotTextNode2D() const { return true; }
virtual bool IsPixelWiseLineSpacingEnabled() const { return ComposerPropVisibleFilterMultiline() && !(GetLineSpacingInPixels() > 0.0f ); }
virtual bool IsGlOutlineTextBrushBlend() const { \
				Candera::RenderNode* renderNode = Candera::Dynamic_Cast<Candera::RenderNode*>(GetNode());
				if(0 != renderNode) {\
				Candera::GlOutlineTextBrushBlend* outlineBrush = Candera::Dynamic_Cast<Candera::GlOutlineTextBrushBlend*>(renderNode->GetEffect(0));
				if(0 != outlineBrush)\
				{ return true ;} }\
				return false ; }

virtual bool IsGlOutlineBitmapBrushColorBlend() const { \
				Candera::RenderNode* renderNode = Candera::Dynamic_Cast<Candera::RenderNode*>(GetNode());
				if(0 != renderNode) {\
				Candera::GlOutlineBitmapBrushColorBlend* outlineBitmapBrush = Candera::Dynamic_Cast<Candera::GlOutlineBitmapBrushColorBlend*>(renderNode->GetEffect(0));
				if(0 != outlineBitmapBrush)\
				{ return true ;} }\
				return false ; }

virtual bool IsOutlineEffectEnabled() const { return IsGlOutlineTextBrushBlend() || IsGlOutlineBitmapBrushColorBlend () ;} 

#if (COURIER_VERSION_MAJOR==2)
typedef  Candera::TextAlignment Candera__HorizontalAlignment;
typedef  Candera::TextAlignment Candera__VerticalAlignment;
#define  Candera__HLeft Candera::Leading
#define  Candera__VTop Candera::Leading
#else
typedef  Candera::HorizontalAlignment Candera__HorizontalAlignment;
typedef  Candera::VerticalAlignment Candera__VerticalAlignment;
#define  Candera__HLeft Candera::HLeft
#define  Candera__VTop Candera::VTop
#endif
        typedef Candera::String TextType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> StyleType;

        typedef Candera::ShrinkMethod ShrinkMethodType;

        typedef bool BoldType;

        typedef bool ItalicType;

        typedef Candera::Vector2 MaximumSizeType;

        typedef bool FixedTextBoxSizeType;

        typedef Candera::String TransRefsType;

        typedef Candera::Color TextColorType;

        typedef Candera::Float AlphaType;

        typedef bool CultureDependentAlignmentType;

        typedef Candera__HorizontalAlignment HorizontalAlignmentType;

        typedef Candera__VerticalAlignment VerticalAlignmentType;

        typedef hmibase::widget::text::enDirection::Enum DirectionType;

        typedef Candera::TruncationMethod TruncationMethodType;

        typedef FeatStd::String TruncationTextType;

        typedef Candera::enTruncationDirection TruncationDirectionType;

        typedef Candera::ScrollBehavior ScrollBehaviorType;

        typedef Candera::UInt16 ScrollSpeedType;

        typedef Candera::UInt32 ScrollCharCountType;

        typedef Candera::UInt16 ScrollStartDelayType;

        typedef Candera::ScrollStartMode ScrollStartModeType;

        typedef bool MultiLineLayoutingType;

        typedef hmibase::widget::text::enMultiLineHorizontalAlignment::Enum MultiLineHorizontalAlignmentType;

        typedef bool WordWrapType;

        typedef Candera::Float LineSpacingInPixelsType;

        typedef Candera::Float LineSpacingFactorType;

        typedef Candera::UInt16 MaximumNumberOfLinesType;

        typedef Candera::UInt8 OutlineWidthType;

        typedef Candera::Color OutlineColorType;

        //! [Property_IDs]
        static const FeatStd::UInt32 TextPropertyId = 0xB5A7CD47;
        static const FeatStd::UInt32 StylePropertyId = 0xB90F95B4;
        static const FeatStd::UInt32 ShrinkMethodPropertyId = 0x5F1B20CB;
        static const FeatStd::UInt32 BoldPropertyId = 0x58737183;
        static const FeatStd::UInt32 ItalicPropertyId = 0xDFEC1555;
        static const FeatStd::UInt32 MaximumSizePropertyId = 0x0D3901B8;
        static const FeatStd::UInt32 FixedTextBoxSizePropertyId = 0xF06A312F;
        static const FeatStd::UInt32 TransRefsPropertyId = 0x295C076C;
        static const FeatStd::UInt32 TextColorPropertyId = 0x04840BDC;
        static const FeatStd::UInt32 AlphaPropertyId = 0xBE14289F;
        static const FeatStd::UInt32 CultureDependentAlignmentPropertyId = 0xB2CB46F1;
        static const FeatStd::UInt32 HorizontalAlignmentPropertyId = 0x32F00453;
        static const FeatStd::UInt32 VerticalAlignmentPropertyId = 0x599B04F6;
        static const FeatStd::UInt32 DirectionPropertyId = 0xA0567985;
        static const FeatStd::UInt32 TruncationMethodPropertyId = 0x95A4DC23;
        static const FeatStd::UInt32 TruncationTextPropertyId = 0x979670E0;
        static const FeatStd::UInt32 TruncationDirectionPropertyId = 0x5AE12643;
        static const FeatStd::UInt32 ScrollBehaviorPropertyId = 0xEC4C5118;
        static const FeatStd::UInt32 ScrollSpeedPropertyId = 0x757705E7;
        static const FeatStd::UInt32 ScrollCharCountPropertyId = 0xAEDA9E6C;
        static const FeatStd::UInt32 ScrollStartDelayPropertyId = 0x39B676BB;
        static const FeatStd::UInt32 ScrollStartModePropertyId = 0x4DA6A8A7;
        static const FeatStd::UInt32 MultiLineLayoutingPropertyId = 0x76E966BA;
        static const FeatStd::UInt32 MultiLineHorizontalAlignmentPropertyId = 0xB59DF9AA;
        static const FeatStd::UInt32 WordWrapPropertyId = 0xA4199BAD;
        static const FeatStd::UInt32 LineSpacingInPixelsPropertyId = 0x2A77A207;
        static const FeatStd::UInt32 LineSpacingFactorPropertyId = 0x733D3E56;
        static const FeatStd::UInt32 MaximumNumberOfLinesPropertyId = 0x776015EF;
        static const FeatStd::UInt32 OutlineWidthPropertyId = 0xDA679C26;
        static const FeatStd::UInt32 OutlineColorPropertyId = 0xA3CF6922;
        //! [Property_IDs]

        TextWidget2DBase();
        virtual ~TextWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_TextPropertyGetterSetter]
        void SetText(const TextType& text);
        const TextType& GetText() const { return m_Text; }
        //! [DataBinding_TextPropertyGetterSetter]

        //! [DataBinding_StylePropertyGetterSetter]
        void SetStyle(const StyleType& style);
        const StyleType& GetStyle() const { return m_Style; }
        //! [DataBinding_StylePropertyGetterSetter]

        void SetShrinkMethod(const ShrinkMethodType& shrinkmethod);
        const ShrinkMethodType& GetShrinkMethod() const { return m_ShrinkMethod; }

        //! [DataBinding_BoldPropertyGetterSetter]
        void SetBold(const BoldType& bold);
        const BoldType& GetBold() const { return m_Bold; }
        //! [DataBinding_BoldPropertyGetterSetter]

        //! [DataBinding_ItalicPropertyGetterSetter]
        void SetItalic(const ItalicType& italic);
        const ItalicType& GetItalic() const { return m_Italic; }
        //! [DataBinding_ItalicPropertyGetterSetter]

        //! [DataBinding_MaximumSizePropertyGetterSetter]
        void SetMaximumSize(const MaximumSizeType& maximumsize);
        const MaximumSizeType& GetMaximumSize() const { return m_MaximumSize; }
        //! [DataBinding_MaximumSizePropertyGetterSetter]

        //! [DataBinding_FixedTextBoxSizePropertyGetterSetter]
        void SetFixedTextBoxSize(const FixedTextBoxSizeType& fixedtextboxsize);
        const FixedTextBoxSizeType& GetFixedTextBoxSize() const { return m_FixedTextBoxSize; }
        //! [DataBinding_FixedTextBoxSizePropertyGetterSetter]

        void SetTransRefs(const TransRefsType& transrefs);
        const TransRefsType& GetTransRefs() const { return m_TransRefs; }

        //! [DataBinding_TextColorPropertyGetterSetter]
        void SetTextColor(const TextColorType& textcolor);
        const TextColorType& GetTextColor() const { return m_TextColor; }
        //! [DataBinding_TextColorPropertyGetterSetter]

        //! [DataBinding_AlphaPropertyGetterSetter]
        void SetAlpha(const AlphaType& alpha);
        const AlphaType& GetAlpha() const { return m_Alpha; }
        //! [DataBinding_AlphaPropertyGetterSetter]

        void SetCultureDependentAlignment(const CultureDependentAlignmentType& culturedependentalignment);
        const CultureDependentAlignmentType& GetCultureDependentAlignment() const { return m_CultureDependentAlignment; }

        //! [DataBinding_HorizontalAlignmentPropertyGetterSetter]
        void SetHorizontalAlignment(const HorizontalAlignmentType& horizontalalignment);
        const HorizontalAlignmentType& GetHorizontalAlignment() const { return m_HorizontalAlignment; }
        //! [DataBinding_HorizontalAlignmentPropertyGetterSetter]

        //! [DataBinding_VerticalAlignmentPropertyGetterSetter]
        void SetVerticalAlignment(const VerticalAlignmentType& verticalalignment);
        const VerticalAlignmentType& GetVerticalAlignment() const { return m_VerticalAlignment; }
        //! [DataBinding_VerticalAlignmentPropertyGetterSetter]

        //! [DataBinding_DirectionPropertyGetterSetter]
        void SetDirection(const DirectionType& direction);
        const DirectionType& GetDirection() const { return m_Direction; }
        //! [DataBinding_DirectionPropertyGetterSetter]

        void SetTruncationMethod(const TruncationMethodType& truncationmethod);
        const TruncationMethodType& GetTruncationMethod() const { return m_TruncationMethod; }

        void SetTruncationText(const TruncationTextType& truncationtext);
        const TruncationTextType& GetTruncationText() const { return m_TruncationText; }

        //! [DataBinding_TruncationDirectionPropertyGetterSetter]
        void SetTruncationDirection(const TruncationDirectionType& truncationdirection);
        const TruncationDirectionType& GetTruncationDirection() const { return m_TruncationDirection; }
        //! [DataBinding_TruncationDirectionPropertyGetterSetter]

        void SetScrollBehavior(const ScrollBehaviorType& scrollbehavior);
        const ScrollBehaviorType& GetScrollBehavior() const { return m_ScrollBehavior; }

        void SetScrollSpeed(const ScrollSpeedType& scrollspeed);
        const ScrollSpeedType& GetScrollSpeed() const { return m_ScrollSpeed; }

        void SetScrollCharCount(const ScrollCharCountType& scrollcharcount);
        const ScrollCharCountType& GetScrollCharCount() const { return m_ScrollCharCount; }

        void SetScrollStartDelay(const ScrollStartDelayType& scrollstartdelay);
        const ScrollStartDelayType& GetScrollStartDelay() const { return m_ScrollStartDelay; }

        void SetScrollStartMode(const ScrollStartModeType& scrollstartmode);
        const ScrollStartModeType& GetScrollStartMode() const { return m_ScrollStartMode; }

        //! [DataBinding_MultiLineLayoutingPropertyGetterSetter]
        void SetMultiLineLayouting(const MultiLineLayoutingType& multilinelayouting);
        const MultiLineLayoutingType& GetMultiLineLayouting() const { return m_MultiLineLayouting; }
        //! [DataBinding_MultiLineLayoutingPropertyGetterSetter]

        void SetMultiLineHorizontalAlignment(const MultiLineHorizontalAlignmentType& multilinehorizontalalignment);
        const MultiLineHorizontalAlignmentType& GetMultiLineHorizontalAlignment() const { return m_MultiLineHorizontalAlignment; }

        //! [DataBinding_WordWrapPropertyGetterSetter]
        void SetWordWrap(const WordWrapType& wordwrap);
        const WordWrapType& GetWordWrap() const { return m_WordWrap; }
        //! [DataBinding_WordWrapPropertyGetterSetter]

        //! [DataBinding_LineSpacingInPixelsPropertyGetterSetter]
        void SetLineSpacingInPixels(const LineSpacingInPixelsType& linespacinginpixels);
        const LineSpacingInPixelsType& GetLineSpacingInPixels() const { return m_LineSpacingInPixels; }
        //! [DataBinding_LineSpacingInPixelsPropertyGetterSetter]

        //! [DataBinding_LineSpacingFactorPropertyGetterSetter]
        void SetLineSpacingFactor(const LineSpacingFactorType& linespacingfactor);
        const LineSpacingFactorType& GetLineSpacingFactor() const { return m_LineSpacingFactor; }
        //! [DataBinding_LineSpacingFactorPropertyGetterSetter]

        //! [DataBinding_MaximumNumberOfLinesPropertyGetterSetter]
        void SetMaximumNumberOfLines(const MaximumNumberOfLinesType& maximumnumberoflines);
        const MaximumNumberOfLinesType& GetMaximumNumberOfLines() const { return m_MaximumNumberOfLines; }
        //! [DataBinding_MaximumNumberOfLinesPropertyGetterSetter]

        //! [DataBinding_OutlineWidthPropertyGetterSetter]
        void SetOutlineWidth(const OutlineWidthType& outlinewidth);
        const OutlineWidthType& GetOutlineWidth() const { return m_OutlineWidth; }
        //! [DataBinding_OutlineWidthPropertyGetterSetter]

        //! [DataBinding_OutlineColorPropertyGetterSetter]
        void SetOutlineColor(const OutlineColorType& outlinecolor);
        const OutlineColorType& GetOutlineColor() const { return m_OutlineColor; }
        //! [DataBinding_OutlineColorPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(TextWidget2DBase, ::BaseWidget2D)
            CdaDescription("Label widget capable for rendering text in 2D scenes on a RenderNode or TextNode2D")
            CdaReadableName("TextWidget2DBase")
            CdaCategory("Text")

            CdaProperties()
                CdaBindableProperty(Text, TextType, GetText, SetText)
                    CdaDescription("The text, that has to be displayed. Language dependent string has to be taken from the translation table, use the choice button on the right side to select a string")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Style, StyleType, GetStyle, SetStyle)
                    CdaDescription("The text style for the label with size and font information")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaProperty(ShrinkMethod, ShrinkMethodType, GetShrinkMethod, SetShrinkMethod)
                    CdaDescription("This will enable to choose the extended textstyle condensed and shrinked for shrink feature")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaPropertyEnd()
                CdaBindableProperty(Bold, BoldType, GetBold, SetBold)
                    CdaDescription("This will enable Bold Text ")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaBindableProperty(Italic, ItalicType, GetItalic, SetItalic)
                    CdaDescription("This will enable Italic Text ")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaBindableProperty(MaximumSize, MaximumSizeType, GetMaximumSize, SetMaximumSize)
                    CdaDescription("Window size for truncation and multiline mode.")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaBindableProperty(FixedTextBoxSize, FixedTextBoxSizeType, GetFixedTextBoxSize, SetFixedTextBoxSize)
                    CdaDescription("If set to True, Text Box Size will be equal to maximum size else Text Box size should be based on given text")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaProperty(TransRefs, TransRefsType, GetTransRefs, SetTransRefs)
                    CdaDescription("CSV separted TEXTID reference list, only used for translation topics. As of now you have to add manually the ID's devided with a comma.")
                CdaPropertyEnd()
                CdaBindableProperty(TextColor, TextColorType, GetTextColor, SetTextColor)
                    CdaDescription("Color to be used to display the text; For state handling see als TextColorWidget2D.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Alpha, AlphaType, GetAlpha, SetAlpha)
                    CdaDescription("Represents the Alpha value to be set to the associated node, default: 1.0")
                CdaBindablePropertyEnd()
                CdaProperty(CultureDependentAlignment, CultureDependentAlignmentType, GetCultureDependentAlignment, SetCultureDependentAlignment)
                    CdaDescription("If enabled then HLeft and HRight will be inverted for cultures with right to left text direction")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaPropertyEnd()
                CdaBindableProperty(HorizontalAlignment, HorizontalAlignmentType, GetHorizontalAlignment, SetHorizontalAlignment)
                    CdaDescription("Text horizontal alignment")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaBindableProperty(VerticalAlignment, VerticalAlignmentType, GetVerticalAlignment, SetVerticalAlignment)
                    CdaDescription("Text vertical alignment")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaBindableProperty(Direction, DirectionType, GetDirection, SetDirection)
                    CdaDescription("Utilized for text flow direction.Legacy : old behavior, Implicit: depends on character, LeftToRight: As LTR, RightToLeft: As RTL, Culture: As culture direction, Node: As Layout Direction ")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaProperty(TruncationMethod, TruncationMethodType, GetTruncationMethod, SetTruncationMethod)
                    CdaDescription("Text truncation method; Hard cuts pixelwise, Soft cuts charwise, Text adds the 'TruncationText' ... and Shrink fits the string to the avaliable space.")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaPropertyEnd()
                CdaProperty(TruncationText, TruncationTextType, GetTruncationText, SetTruncationText)
                    CdaDescription("Truncation text to be rendered in UTF-8 encoding, in most cases '...'")
                    CdaVisibilityTest(ComposerPropVisibleFilterTruncation)
                CdaPropertyEnd()
                CdaBindableProperty(TruncationDirection, TruncationDirectionType, GetTruncationDirection, SetTruncationDirection)
                    CdaDescription("Truncation Direction add right side or left side of the text")
                    CdaVisibilityTest(ComposerPropVisibleFilterTruncation)
                CdaBindablePropertyEnd()
                CdaProperty(ScrollBehavior, ScrollBehaviorType, GetScrollBehavior, SetScrollBehavior)
                    CdaDescription("Behavior of scrolling, circular endless or scrolling to the end of line and return after a short remaining time.")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaPropertyEnd()
                CdaProperty(ScrollSpeed, ScrollSpeedType, GetScrollSpeed, SetScrollSpeed)
                    CdaDescription("Speed for scrolling in msec. 300 is a good value and default.")
                    CdaVisibilityTest(ComposerPropVisibleFilterScrolling)
                CdaPropertyEnd()
                CdaProperty(ScrollCharCount, ScrollCharCountType, GetScrollCharCount, SetScrollCharCount)
                    CdaDescription("Pixels scrolled is equal to (Number of characters * default font width), 0 indicates legacy behavior ")
                    CdaVisibilityTest(ComposerPropVisibleFilterScrolling)
                CdaPropertyEnd()
                CdaProperty(ScrollStartDelay, ScrollStartDelayType, GetScrollStartDelay, SetScrollStartDelay)
                    CdaDescription("Delay Required before starting scrolling in msec")
                    CdaVisibilityTest(ComposerPropVisibleFilterScrolling)
                CdaPropertyEnd()
                CdaProperty(ScrollStartMode, ScrollStartModeType, GetScrollStartMode, SetScrollStartMode)
                    CdaDescription("How scrolling feature was enabled : 'OnTouch' will start the scrolling whenever someone touches the widget, 'Auto' starts the scrolling feature after init of the scene. 'Extern' starts scrolling after it was called from an anchestor widget.")
                    CdaVisibilityTest(ComposerPropVisibleFilterScrolling)
                CdaPropertyEnd()
                CdaBindableProperty(MultiLineLayouting, MultiLineLayoutingType, GetMultiLineLayouting, SetMultiLineLayouting)
                    CdaDescription("Sets the property of MultiLineLayouting for the TextBrush")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaBindablePropertyEnd()
                CdaProperty(MultiLineHorizontalAlignment, MultiLineHorizontalAlignmentType, GetMultiLineHorizontalAlignment, SetMultiLineHorizontalAlignment)
                    CdaDescription("Text horizontal alignment in case text is rendered for multiple lines")
                    CdaVisibilityTest(ComposerPropVisibleFilterNotTextNode2D)
                CdaPropertyEnd()
                CdaBindableProperty(WordWrap, WordWrapType, GetWordWrap, SetWordWrap)
                    CdaDescription("Sets the property of WordWrap for the TextBrush")
                    CdaVisibilityTest(ComposerPropVisibleFilterMultiline)
                CdaBindablePropertyEnd()
                CdaBindableProperty(LineSpacingInPixels, LineSpacingInPixelsType, GetLineSpacingInPixels, SetLineSpacingInPixels)
                    CdaDescription("LineSpacing between the lines to be used in pixels")
                    CdaVisibilityTest(ComposerPropVisibleFilterMultiline)
                CdaBindablePropertyEnd()
                CdaBindableProperty(LineSpacingFactor, LineSpacingFactorType, GetLineSpacingFactor, SetLineSpacingFactor)
                    CdaDescription("LineSpacing used e.g. buttons with two lines, a value of one is the font height")
                    CdaVisibilityTest(IsPixelWiseLineSpacingEnabled)
                CdaBindablePropertyEnd()
                CdaBindableProperty(MaximumNumberOfLines, MaximumNumberOfLinesType, GetMaximumNumberOfLines, SetMaximumNumberOfLines)
                    CdaDescription("Maximum Number Of Lines, default is one.")
                    CdaVisibilityTest(ComposerPropVisibleFilterMultiline)
                CdaBindablePropertyEnd()
                CdaBindableProperty(OutlineWidth, OutlineWidthType, GetOutlineWidth, SetOutlineWidth)
                    CdaDescription("Sets the outline width")
                    CdaVisibilityTest(IsOutlineEffectEnabled)
                CdaBindablePropertyEnd()
                CdaBindableProperty(OutlineColor, OutlineColorType, GetOutlineColor, SetOutlineColor)
                    CdaDescription("Sets the outline color")
                    CdaVisibilityTest(IsOutlineEffectEnabled)
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        TextType m_Text;
        StyleType m_Style;
        ShrinkMethodType m_ShrinkMethod;
        BoldType m_Bold;
        ItalicType m_Italic;
        MaximumSizeType m_MaximumSize;
        FixedTextBoxSizeType m_FixedTextBoxSize;
        TransRefsType m_TransRefs;
        TextColorType m_TextColor;
        AlphaType m_Alpha;
        CultureDependentAlignmentType m_CultureDependentAlignment;
        HorizontalAlignmentType m_HorizontalAlignment;
        VerticalAlignmentType m_VerticalAlignment;
        DirectionType m_Direction;
        TruncationMethodType m_TruncationMethod;
        TruncationTextType m_TruncationText;
        TruncationDirectionType m_TruncationDirection;
        ScrollBehaviorType m_ScrollBehavior;
        ScrollSpeedType m_ScrollSpeed;
        ScrollCharCountType m_ScrollCharCount;
        ScrollStartDelayType m_ScrollStartDelay;
        ScrollStartModeType m_ScrollStartMode;
        MultiLineLayoutingType m_MultiLineLayouting;
        MultiLineHorizontalAlignmentType m_MultiLineHorizontalAlignment;
        WordWrapType m_WordWrap;
        LineSpacingInPixelsType m_LineSpacingInPixels;
        LineSpacingFactorType m_LineSpacingFactor;
        MaximumNumberOfLinesType m_MaximumNumberOfLines;
        OutlineWidthType m_OutlineWidth;
        OutlineColorType m_OutlineColor;
};

#endif // TextWidget2DBase_h
