/************************************************************************
*FILE: TextWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "TextWidget2DBase.h"
#include <Widgets/utils/WidgetDefaults.h>

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(TextWidget2DBase)

TextWidget2DBase::TextWidget2DBase() :
    m_Text(TextType()),
    m_Style(StyleType()),
    m_ShrinkMethod(Candera::NoShrink),
    m_Bold(false),
    m_Italic(false),
    m_MaximumSize(Candera::Vector2(-1.0F, -1.0F)),
    m_FixedTextBoxSize(true),
    m_TransRefs(TransRefsType()),
    m_TextColor(Candera::Color(1.0F, 1.0F, 1.0F, 1.0F)),
    m_Alpha(1.0F),
    m_CultureDependentAlignment(hmibase::widget::WidgetDefaults::GetTextCultureDependentAlignment()),
    m_HorizontalAlignment(Candera__HLeft),
    m_VerticalAlignment(Candera__VTop),
    m_Direction(hmibase::widget::WidgetDefaults::GetTextDirection()),
    m_TruncationMethod(Candera::NoneTruncation),
    m_TruncationText("..."),
    m_TruncationDirection(Candera::Right),
    m_ScrollBehavior(Candera::Off),
    m_ScrollSpeed(300),
    m_ScrollCharCount(0),
    m_ScrollStartDelay(0),
    m_ScrollStartMode(Candera::External),
    m_MultiLineLayouting(false),
    m_MultiLineHorizontalAlignment(hmibase::widget::text::enMultiLineHorizontalAlignment::Default),
    m_WordWrap(false),
    m_LineSpacingInPixels(false),
    m_LineSpacingFactor(1.0F),
    m_MaximumNumberOfLines(1),
    m_OutlineWidth(1),
    m_OutlineColor(Candera::Color(1.0F, 1.0F, 1.0F, 1.0F))
{
}

TextWidget2DBase::~TextWidget2DBase()
{
}

void TextWidget2DBase::SetText(const TextType& text)
{
    if (m_Text != text) {
        m_Text = text;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextPropertyId));
    }
}

void TextWidget2DBase::SetStyle(const StyleType& style)
{
    if (m_Style != style) {
        m_Style = style;
        OnChanged(static_cast< ::FeatStd::UInt32>(StylePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Style");
        }
    }
}

void TextWidget2DBase::SetShrinkMethod(const ShrinkMethodType& shrinkmethod)
{
    if (m_ShrinkMethod != shrinkmethod) {
        m_ShrinkMethod = shrinkmethod;
        OnChanged(static_cast< ::FeatStd::UInt32>(ShrinkMethodPropertyId));
    }
}

void TextWidget2DBase::SetBold(const BoldType& bold)
{
    if (m_Bold != bold) {
        m_Bold = bold;
        OnChanged(static_cast< ::FeatStd::UInt32>(BoldPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Bold");
        }
    }
}

void TextWidget2DBase::SetItalic(const ItalicType& italic)
{
    if (m_Italic != italic) {
        m_Italic = italic;
        OnChanged(static_cast< ::FeatStd::UInt32>(ItalicPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Italic");
        }
    }
}

void TextWidget2DBase::SetMaximumSize(const MaximumSizeType& maximumsize)
{
    if (m_MaximumSize != maximumsize) {
        m_MaximumSize = maximumsize;
        OnChanged(static_cast< ::FeatStd::UInt32>(MaximumSizePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("MaximumSize");
        }
    }
}

void TextWidget2DBase::SetFixedTextBoxSize(const FixedTextBoxSizeType& fixedtextboxsize)
{
    if (m_FixedTextBoxSize != fixedtextboxsize) {
        m_FixedTextBoxSize = fixedtextboxsize;
        OnChanged(static_cast< ::FeatStd::UInt32>(FixedTextBoxSizePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("FixedTextBoxSize");
        }
    }
}

void TextWidget2DBase::SetTransRefs(const TransRefsType& transrefs)
{
    if (m_TransRefs != transrefs) {
        m_TransRefs = transrefs;
        OnChanged(static_cast< ::FeatStd::UInt32>(TransRefsPropertyId));
    }
}

void TextWidget2DBase::SetTextColor(const TextColorType& textcolor)
{
    if (m_TextColor != textcolor) {
        m_TextColor = textcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextColorPropertyId));
    }
}

void TextWidget2DBase::SetAlpha(const AlphaType& alpha)
{
    if (m_Alpha != alpha) {
        m_Alpha = alpha;
        OnChanged(static_cast< ::FeatStd::UInt32>(AlphaPropertyId));
    }
}

void TextWidget2DBase::SetCultureDependentAlignment(const CultureDependentAlignmentType& culturedependentalignment)
{
    if (m_CultureDependentAlignment != culturedependentalignment) {
        m_CultureDependentAlignment = culturedependentalignment;
        OnChanged(static_cast< ::FeatStd::UInt32>(CultureDependentAlignmentPropertyId));
    }
}

void TextWidget2DBase::SetHorizontalAlignment(const HorizontalAlignmentType& horizontalalignment)
{
    if (m_HorizontalAlignment != horizontalalignment) {
        m_HorizontalAlignment = horizontalalignment;
        OnChanged(static_cast< ::FeatStd::UInt32>(HorizontalAlignmentPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("HorizontalAlignment");
        }
    }
}

void TextWidget2DBase::SetVerticalAlignment(const VerticalAlignmentType& verticalalignment)
{
    if (m_VerticalAlignment != verticalalignment) {
        m_VerticalAlignment = verticalalignment;
        OnChanged(static_cast< ::FeatStd::UInt32>(VerticalAlignmentPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("VerticalAlignment");
        }
    }
}

void TextWidget2DBase::SetDirection(const DirectionType& direction)
{
    if (m_Direction != direction) {
        m_Direction = direction;
        OnChanged(static_cast< ::FeatStd::UInt32>(DirectionPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Direction");
        }
    }
}

void TextWidget2DBase::SetTruncationMethod(const TruncationMethodType& truncationmethod)
{
    if (m_TruncationMethod != truncationmethod) {
        m_TruncationMethod = truncationmethod;
        OnChanged(static_cast< ::FeatStd::UInt32>(TruncationMethodPropertyId));
    }
}

void TextWidget2DBase::SetTruncationText(const TruncationTextType& truncationtext)
{
    if (m_TruncationText != truncationtext) {
        m_TruncationText = truncationtext;
        OnChanged(static_cast< ::FeatStd::UInt32>(TruncationTextPropertyId));
    }
}

void TextWidget2DBase::SetTruncationDirection(const TruncationDirectionType& truncationdirection)
{
    if (m_TruncationDirection != truncationdirection) {
        m_TruncationDirection = truncationdirection;
        OnChanged(static_cast< ::FeatStd::UInt32>(TruncationDirectionPropertyId));
    }
}

void TextWidget2DBase::SetScrollBehavior(const ScrollBehaviorType& scrollbehavior)
{
    if (m_ScrollBehavior != scrollbehavior) {
        m_ScrollBehavior = scrollbehavior;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollBehaviorPropertyId));
    }
}

void TextWidget2DBase::SetScrollSpeed(const ScrollSpeedType& scrollspeed)
{
    if (m_ScrollSpeed != scrollspeed) {
        m_ScrollSpeed = scrollspeed;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollSpeedPropertyId));
    }
}

void TextWidget2DBase::SetScrollCharCount(const ScrollCharCountType& scrollcharcount)
{
    if (m_ScrollCharCount != scrollcharcount) {
        m_ScrollCharCount = scrollcharcount;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollCharCountPropertyId));
    }
}

void TextWidget2DBase::SetScrollStartDelay(const ScrollStartDelayType& scrollstartdelay)
{
    if (m_ScrollStartDelay != scrollstartdelay) {
        m_ScrollStartDelay = scrollstartdelay;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollStartDelayPropertyId));
    }
}

void TextWidget2DBase::SetScrollStartMode(const ScrollStartModeType& scrollstartmode)
{
    if (m_ScrollStartMode != scrollstartmode) {
        m_ScrollStartMode = scrollstartmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollStartModePropertyId));
    }
}

void TextWidget2DBase::SetMultiLineLayouting(const MultiLineLayoutingType& multilinelayouting)
{
    if (m_MultiLineLayouting != multilinelayouting) {
        m_MultiLineLayouting = multilinelayouting;
        OnChanged(static_cast< ::FeatStd::UInt32>(MultiLineLayoutingPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("MultiLineLayouting");
        }
    }
}

void TextWidget2DBase::SetMultiLineHorizontalAlignment(const MultiLineHorizontalAlignmentType& multilinehorizontalalignment)
{
    if (m_MultiLineHorizontalAlignment != multilinehorizontalalignment) {
        m_MultiLineHorizontalAlignment = multilinehorizontalalignment;
        OnChanged(static_cast< ::FeatStd::UInt32>(MultiLineHorizontalAlignmentPropertyId));
    }
}

void TextWidget2DBase::SetWordWrap(const WordWrapType& wordwrap)
{
    if (m_WordWrap != wordwrap) {
        m_WordWrap = wordwrap;
        OnChanged(static_cast< ::FeatStd::UInt32>(WordWrapPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("WordWrap");
        }
    }
}

void TextWidget2DBase::SetLineSpacingInPixels(const LineSpacingInPixelsType& linespacinginpixels)
{
    if (m_LineSpacingInPixels != linespacinginpixels) {
        m_LineSpacingInPixels = linespacinginpixels;
        OnChanged(static_cast< ::FeatStd::UInt32>(LineSpacingInPixelsPropertyId));
    }
}

void TextWidget2DBase::SetLineSpacingFactor(const LineSpacingFactorType& linespacingfactor)
{
    if (m_LineSpacingFactor != linespacingfactor) {
        m_LineSpacingFactor = linespacingfactor;
        OnChanged(static_cast< ::FeatStd::UInt32>(LineSpacingFactorPropertyId));
    }
}

void TextWidget2DBase::SetMaximumNumberOfLines(const MaximumNumberOfLinesType& maximumnumberoflines)
{
    if (m_MaximumNumberOfLines != maximumnumberoflines) {
        m_MaximumNumberOfLines = maximumnumberoflines;
        OnChanged(static_cast< ::FeatStd::UInt32>(MaximumNumberOfLinesPropertyId));
    }
}

void TextWidget2DBase::SetOutlineWidth(const OutlineWidthType& outlinewidth)
{
    if (m_OutlineWidth != outlinewidth) {
        m_OutlineWidth = outlinewidth;
        OnChanged(static_cast< ::FeatStd::UInt32>(OutlineWidthPropertyId));
    }
}

void TextWidget2DBase::SetOutlineColor(const OutlineColorType& outlinecolor)
{
    if (m_OutlineColor != outlinecolor) {
        m_OutlineColor = outlinecolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(OutlineColorPropertyId));
    }
}
