/************************************************************************
*FILE: SwitchWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SwitchWidget2DBase_h)
#define SwitchWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [SwitchWidget2DBase_Declaration]
class SwitchWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef bool BitmaskEnabledType;

        typedef ::Candera::UInt32 IndexType;

        //! [Property_IDs]
        static const FeatStd::UInt32 BitmaskEnabledPropertyId = 0x22D43E20;
        static const FeatStd::UInt32 IndexPropertyId = 0x3DBCF2F4;
        //! [Property_IDs]

        SwitchWidget2DBase();
        virtual ~SwitchWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(SwitchWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_BitmaskEnabledPropertyGetterSetter]
        void SetBitmaskEnabled(const BitmaskEnabledType& bitmaskenabled);
        const BitmaskEnabledType& GetBitmaskEnabled() const { return m_BitmaskEnabled; }
        //! [DataBinding_BitmaskEnabledPropertyGetterSetter]

        //! [DataBinding_IndexPropertyGetterSetter]
        void SetIndex(const IndexType& index);
        const IndexType& GetIndex() const { return m_Index; }
        //! [DataBinding_IndexPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(SwitchWidget2DBase, ::BaseWidget2D)
            CdaDescription("Sets the RenderingEnabled property of is children nodes based on the index property (allowing to switch between nodes by a bindable widget property).")
            CdaReadableName("SwitchWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaBindableProperty(BitmaskEnabled, BitmaskEnabledType, GetBitmaskEnabled, SetBitmaskEnabled)
                    CdaDescription("If set to true, the Index will be considered as bitmask and each bit will toggle the visibility of a node. Bit 0 from Index will control the first child node, bit 1 the second child node, etc. Up to 32 nodes can be controlled this way.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Index, IndexType, GetIndex, SetIndex)
                    CdaDescription("Index of the associated node's child that will be visible.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        BitmaskEnabledType m_BitmaskEnabled;
        IndexType m_Index;
};

#endif // SwitchWidget2DBase_h
