/************************************************************************
*FILE: SpellerWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "SpellerWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(SpellerWidget2DBase)

SpellerWidget2DBase::SpellerWidget2DBase() :
    m_Mode(ModeType()),
    m_Type(TypeType()),
    m_UserDefinedSequence(UserDefinedSequenceType()),
    m_ZeroKeyLongPressed(ZeroKeyLongPressedType()),
    m_SpellerScenesPath(SpellerScenesPathType()),
    m_ConfigureSpellerScenes(ConfigureSpellerScenesType()),
    m_UseOnlyButtonsWithText(true),
    m_ActiveLanguage(ActiveLanguageType()),
    m_ActiveCountry(ActiveCountryType()),
    m_ValidCharSet(ValidCharSetType()),
    m_KeypadFormat(KeypadFormatType()),
    m_AllCharLayoutDisable(AllCharLayoutDisableType()),
    m_SpellerKeyPressed(SpellerKeyPressedType()),
    m_AutoLayoutToggle(false),
    m_ActivateLayoutIndex(false)
{
}

SpellerWidget2DBase::~SpellerWidget2DBase()
{
}

void SpellerWidget2DBase::SetMode(const ModeType& mode)
{
    if (m_Mode != mode) {
        m_Mode = mode;
        OnChanged(static_cast< ::FeatStd::UInt32>(ModePropertyId));
    }
}

void SpellerWidget2DBase::SetType(const TypeType& type)
{
    if (m_Type != type) {
        m_Type = type;
        OnChanged(static_cast< ::FeatStd::UInt32>(TypePropertyId));
    }
}

void SpellerWidget2DBase::SetUserDefinedSequence(const UserDefinedSequenceType& userdefinedsequence)
{
    if (m_UserDefinedSequence != userdefinedsequence) {
        m_UserDefinedSequence = userdefinedsequence;
        OnChanged(static_cast< ::FeatStd::UInt32>(UserDefinedSequencePropertyId));
    }
}

void SpellerWidget2DBase::SetZeroKeyLongPressed(const ZeroKeyLongPressedType& zerokeylongpressed)
{
    if (m_ZeroKeyLongPressed != zerokeylongpressed) {
        m_ZeroKeyLongPressed = zerokeylongpressed;
        OnChanged(static_cast< ::FeatStd::UInt32>(ZeroKeyLongPressedPropertyId));
    }
}

void SpellerWidget2DBase::SetSpellerScenesPath(const SpellerScenesPathType& spellerscenespath)
{
    if (m_SpellerScenesPath != spellerscenespath) {
        m_SpellerScenesPath = spellerscenespath;
        OnChanged(static_cast< ::FeatStd::UInt32>(SpellerScenesPathPropertyId));
    }
}

void SpellerWidget2DBase::SetConfigureSpellerScenes(const ConfigureSpellerScenesType& configurespellerscenes)
{
    if (m_ConfigureSpellerScenes != configurespellerscenes) {
        m_ConfigureSpellerScenes = configurespellerscenes;
        OnChanged(static_cast< ::FeatStd::UInt32>(ConfigureSpellerScenesPropertyId));
    }
}

void SpellerWidget2DBase::SetUseOnlyButtonsWithText(const UseOnlyButtonsWithTextType& useonlybuttonswithtext)
{
    if (m_UseOnlyButtonsWithText != useonlybuttonswithtext) {
        m_UseOnlyButtonsWithText = useonlybuttonswithtext;
    }
}

void SpellerWidget2DBase::SetActiveLanguage(const ActiveLanguageType& activelanguage)
{
    if (m_ActiveLanguage != activelanguage) {
        m_ActiveLanguage = activelanguage;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActiveLanguagePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("ActiveLanguage");
        }
    }
}

void SpellerWidget2DBase::SetActiveCountry(const ActiveCountryType& activecountry)
{
    if (m_ActiveCountry != activecountry) {
        m_ActiveCountry = activecountry;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActiveCountryPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("ActiveCountry");
        }
    }
}

void SpellerWidget2DBase::SetValidCharSet(const ValidCharSetType& validcharset)
{
    m_ValidCharSet = validcharset;
    OnChanged(static_cast< ::FeatStd::UInt32>(ValidCharSetPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("ValidCharSet");
    }
}

void SpellerWidget2DBase::SetKeypadFormat(const KeypadFormatType& keypadformat)
{
    m_KeypadFormat = keypadformat;
    OnChanged(static_cast< ::FeatStd::UInt32>(KeypadFormatPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("KeypadFormat");
    }
}

void SpellerWidget2DBase::SetAllCharLayoutDisable(const AllCharLayoutDisableType& allcharlayoutdisable)
{
    if (m_AllCharLayoutDisable != allcharlayoutdisable) {
        m_AllCharLayoutDisable = allcharlayoutdisable;
        OnChanged(static_cast< ::FeatStd::UInt32>(AllCharLayoutDisablePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("AllCharLayoutDisable");
        }
    }
}

void SpellerWidget2DBase::SetSpellerKeyPressed(const SpellerKeyPressedType& spellerkeypressed)
{
    m_SpellerKeyPressed = spellerkeypressed;
    OnChanged(static_cast< ::FeatStd::UInt32>(SpellerKeyPressedPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SpellerKeyPressed");
    }
}

void SpellerWidget2DBase::SetAutoLayoutToggle(const AutoLayoutToggleType& autolayouttoggle)
{
    if (m_AutoLayoutToggle != autolayouttoggle) {
        m_AutoLayoutToggle = autolayouttoggle;
        OnChanged(static_cast< ::FeatStd::UInt32>(AutoLayoutTogglePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("AutoLayoutToggle");
        }
    }
}

void SpellerWidget2DBase::SetActivateLayoutIndex(const ActivateLayoutIndexType& activatelayoutindex)
{
    if (m_ActivateLayoutIndex != activatelayoutindex) {
        m_ActivateLayoutIndex = activatelayoutindex;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActivateLayoutIndexPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("ActivateLayoutIndex");
        }
    }
}
