/************************************************************************
*FILE: SliderWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "SliderWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(SliderWidget2DBase)

SliderWidget2DBase::SliderWidget2DBase() :
    m_SliderBackGround(SliderBackGroundType()),
    m_MarkerNode(MarkerNodeType()),
    m_BitmapFillNode(BitmapFillNodeType()),
    m_MinVal(0.0f),
    m_MaxVal(100.0f),
    m_CurrentValue(CurrentValueType()),
    m_SliderOrientation(SliderOrientationType()),
    m_PaddingMinVal(PaddingMinValType()),
    m_PaddingMaxVal(PaddingMaxValType()),
    m_MarkerMovement(MarkerMovementType()),
    m_UseNumofSteps(true),
    m_NumOfSteps(10),
    m_StepSize(0.0F),
    m_MarkerNormalBitmap(MarkerNormalBitmapType()),
    m_MarkerSelectedBitmap(MarkerSelectedBitmapType()),
    m_ContinuousUpdateOnDrag(ContinuousUpdateOnDragType()),
    m_FillerPositionIsKnobCenter(true)
{
}

SliderWidget2DBase::~SliderWidget2DBase()
{
}

void SliderWidget2DBase::SetSliderBackGround(const SliderBackGroundType& sliderbackground)
{
    if (m_SliderBackGround != sliderbackground) {
        m_SliderBackGround = sliderbackground;
        OnChanged(static_cast< ::FeatStd::UInt32>(SliderBackGroundPropertyId));
    }
}

void SliderWidget2DBase::SetMarkerNode(const MarkerNodeType& markernode)
{
    if (m_MarkerNode != markernode) {
        m_MarkerNode = markernode;
        OnChanged(static_cast< ::FeatStd::UInt32>(MarkerNodePropertyId));
    }
}

void SliderWidget2DBase::SetBitmapFillNode(const BitmapFillNodeType& bitmapfillnode)
{
    if (m_BitmapFillNode != bitmapfillnode) {
        m_BitmapFillNode = bitmapfillnode;
        OnChanged(static_cast< ::FeatStd::UInt32>(BitmapFillNodePropertyId));
    }
}

void SliderWidget2DBase::SetMinVal(const MinValType& minval)
{
    if (m_MinVal != minval) {
        m_MinVal = minval;
        OnChanged(static_cast< ::FeatStd::UInt32>(MinValPropertyId));
    }
}

void SliderWidget2DBase::SetMaxVal(const MaxValType& maxval)
{
    if (m_MaxVal != maxval) {
        m_MaxVal = maxval;
        OnChanged(static_cast< ::FeatStd::UInt32>(MaxValPropertyId));
    }
}

void SliderWidget2DBase::SetCurrentValue(const CurrentValueType& currentvalue)
{
    if (m_CurrentValue != currentvalue) {
        m_CurrentValue = currentvalue;
        OnChanged(static_cast< ::FeatStd::UInt32>(CurrentValuePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("CurrentValue");
        }
    }
}

void SliderWidget2DBase::SetSliderOrientation(const SliderOrientationType& sliderorientation)
{
    if (m_SliderOrientation != sliderorientation) {
        m_SliderOrientation = sliderorientation;
        OnChanged(static_cast< ::FeatStd::UInt32>(SliderOrientationPropertyId));
    }
}

void SliderWidget2DBase::SetPaddingMinVal(const PaddingMinValType& paddingminval)
{
    if (m_PaddingMinVal != paddingminval) {
        m_PaddingMinVal = paddingminval;
        OnChanged(static_cast< ::FeatStd::UInt32>(PaddingMinValPropertyId));
    }
}

void SliderWidget2DBase::SetPaddingMaxVal(const PaddingMaxValType& paddingmaxval)
{
    if (m_PaddingMaxVal != paddingmaxval) {
        m_PaddingMaxVal = paddingmaxval;
        OnChanged(static_cast< ::FeatStd::UInt32>(PaddingMaxValPropertyId));
    }
}

void SliderWidget2DBase::SetMarkerMovement(const MarkerMovementType& markermovement)
{
    if (m_MarkerMovement != markermovement) {
        m_MarkerMovement = markermovement;
        OnChanged(static_cast< ::FeatStd::UInt32>(MarkerMovementPropertyId));
    }
}

void SliderWidget2DBase::SetUseNumofSteps(const UseNumofStepsType& usenumofsteps)
{
    if (m_UseNumofSteps != usenumofsteps) {
        m_UseNumofSteps = usenumofsteps;
        OnChanged(static_cast< ::FeatStd::UInt32>(UseNumofStepsPropertyId));
    }
}

void SliderWidget2DBase::SetNumOfSteps(const NumOfStepsType& numofsteps)
{
    if (m_NumOfSteps != numofsteps) {
        m_NumOfSteps = numofsteps;
        OnChanged(static_cast< ::FeatStd::UInt32>(NumOfStepsPropertyId));
    }
}

void SliderWidget2DBase::SetStepSize(const StepSizeType& stepsize)
{
    if (m_StepSize != stepsize) {
        m_StepSize = stepsize;
        OnChanged(static_cast< ::FeatStd::UInt32>(StepSizePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("StepSize");
        }
    }
}

void SliderWidget2DBase::SetMarkerNormalBitmap(const MarkerNormalBitmapType& markernormalbitmap)
{
    if (m_MarkerNormalBitmap != markernormalbitmap) {
        m_MarkerNormalBitmap = markernormalbitmap;
        OnChanged(static_cast< ::FeatStd::UInt32>(MarkerNormalBitmapPropertyId));
    }
}

void SliderWidget2DBase::SetMarkerSelectedBitmap(const MarkerSelectedBitmapType& markerselectedbitmap)
{
    if (m_MarkerSelectedBitmap != markerselectedbitmap) {
        m_MarkerSelectedBitmap = markerselectedbitmap;
        OnChanged(static_cast< ::FeatStd::UInt32>(MarkerSelectedBitmapPropertyId));
    }
}

void SliderWidget2DBase::SetContinuousUpdateOnDrag(const ContinuousUpdateOnDragType& continuousupdateondrag)
{
    if (m_ContinuousUpdateOnDrag != continuousupdateondrag) {
        m_ContinuousUpdateOnDrag = continuousupdateondrag;
        OnChanged(static_cast< ::FeatStd::UInt32>(ContinuousUpdateOnDragPropertyId));
    }
}

void SliderWidget2DBase::SetFillerPositionIsKnobCenter(const FillerPositionIsKnobCenterType& fillerpositionisknobcenter)
{
    if (m_FillerPositionIsKnobCenter != fillerpositionisknobcenter) {
        m_FillerPositionIsKnobCenter = fillerpositionisknobcenter;
        OnChanged(static_cast< ::FeatStd::UInt32>(FillerPositionIsKnobCenterPropertyId));
    }
}
