/************************************************************************
*FILE: SizeWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SizeWidget2DBase_h)
#define SizeWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [SizeWidget2DBase_Declaration]
class SizeWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef ::Candera::UInt32 NestedLevelType;

        typedef ::Candera::Vector2 SizeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 NestedLevelPropertyId = 0x731DBB6E;
        static const FeatStd::UInt32 SizePropertyId = 0xD1E4788A;
        //! [Property_IDs]

        SizeWidget2DBase();
        virtual ~SizeWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(SizeWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_NestedLevelPropertyGetterSetter]
        void SetNestedLevel(const NestedLevelType& nestedlevel);
        const NestedLevelType& GetNestedLevel() const { return m_NestedLevel; }
        //! [DataBinding_NestedLevelPropertyGetterSetter]

        //! [DataBinding_SizePropertyGetterSetter]
        void SetSize(const SizeType& size);
        const SizeType& GetSize() const { return m_Size; }
        //! [DataBinding_SizePropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(SizeWidget2DBase, ::BaseWidget2D)
            CdaDescription("Controls the size property of a node.")
            CdaReadableName("SizeWidget2DBase")
            CdaCategory("Layout")

            CdaProperties()
                CdaBindableProperty(NestedLevel, NestedLevelType, GetNestedLevel, SetNestedLevel)
                    CdaDescription("The ancestor's level, relative to the associated node, that will have the Size property modified.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Size, SizeType, GetSize, SetSize)
                    CdaDescription("The value to set for the Size property of the ancestor node.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        NestedLevelType m_NestedLevel;
        SizeType m_Size;
};

#endif // SizeWidget2DBase_h
