/************************************************************************
*FILE: ScrollableTextWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ScrollableTextWidget2DBase_h)
#define ScrollableTextWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/RichTextBase/RichTextBaseWidget2D.h>
// Enum data types
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TextSource)    \
    ENUM_DATA_TYPE_ITEM(SourceText)     \
    ENUM_DATA_TYPE_ITEM(SourceTextId)   \
    ENUM_DATA_TYPE_ITEM(SourceFile)     \
    ENUM_DATA_TYPE_END(TextSource)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [ScrollableTextWidget2DBase_Declaration]
class ScrollableTextWidget2DBase : public ::RichTextBaseWidget2D
{
    public:
        typedef Candera::UInt32 TextIdType;

        typedef FeatStd::String FileNameType;

        typedef Candera::TextSource TextSourceType;

        typedef Courier::ListPropertyType<Candera::Color> ColorTableType;

        typedef Courier::ListPropertyType<Candera::Int16> TabStopTableType;

        typedef Candera::Float LinespacingFactorType;

        typedef Candera::RT_TextWrapMode TextWrapModeType;

        typedef Candera::Int32 SwipeFrictionType;

        typedef bool PostUpdateMessageType;

        typedef ::Courier::UInt32 ScrollableTextIdType;

        //! [Property_IDs]
        static const FeatStd::UInt32 TextIdPropertyId = 0x87271271;
        static const FeatStd::UInt32 FileNamePropertyId = 0xFF466DDA;
        static const FeatStd::UInt32 TextSourcePropertyId = 0x785501D4;
        static const FeatStd::UInt32 ColorTablePropertyId = 0xA089277F;
        static const FeatStd::UInt32 TabStopTablePropertyId = 0x3D13723D;
        static const FeatStd::UInt32 LinespacingFactorPropertyId = 0x1719BC93;
        static const FeatStd::UInt32 TextWrapModePropertyId = 0x220B156F;
        static const FeatStd::UInt32 SwipeFrictionPropertyId = 0xDB0CB5DC;
        static const FeatStd::UInt32 PostUpdateMessagePropertyId = 0x7FBC1357;
        static const FeatStd::UInt32 ScrollableTextIdPropertyId = 0xB32EC8C5;
        //! [Property_IDs]

        ScrollableTextWidget2DBase();
        virtual ~ScrollableTextWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ScrollableTextWidget2DBase, ::RichTextBaseWidget2D);

        //! [DataBinding_TextIdPropertyGetterSetter]
        void SetTextId(const TextIdType& textid);
        const TextIdType& GetTextId() const { return m_TextId; }
        //! [DataBinding_TextIdPropertyGetterSetter]

        //! [DataBinding_FileNamePropertyGetterSetter]
        void SetFileName(const FileNameType& filename);
        const FileNameType& GetFileName() const { return m_FileName; }
        //! [DataBinding_FileNamePropertyGetterSetter]

        //! [DataBinding_TextSourcePropertyGetterSetter]
        void SetTextSource(const TextSourceType& textsource);
        const TextSourceType& GetTextSource() const { return m_TextSource; }
        //! [DataBinding_TextSourcePropertyGetterSetter]

        void SetColorTable(const ColorTableType& colortable);
        const ColorTableType& GetColorTable() const { return m_ColorTable; }
        ColorTableType& GetColorTable() { return m_ColorTable; }

        void SetTabStopTable(const TabStopTableType& tabstoptable);
        const TabStopTableType& GetTabStopTable() const { return m_TabStopTable; }
        TabStopTableType& GetTabStopTable() { return m_TabStopTable; }

        void SetLinespacingFactor(const LinespacingFactorType& linespacingfactor);
        const LinespacingFactorType& GetLinespacingFactor() const { return m_LinespacingFactor; }

        void SetTextWrapMode(const TextWrapModeType& textwrapmode);
        const TextWrapModeType& GetTextWrapMode() const { return m_TextWrapMode; }

        void SetSwipeFriction(const SwipeFrictionType& swipefriction);
        const SwipeFrictionType& GetSwipeFriction() const { return m_SwipeFriction; }

        void SetPostUpdateMessage(const PostUpdateMessageType& postupdatemessage);
        const PostUpdateMessageType& GetPostUpdateMessage() const { return m_PostUpdateMessage; }

        void SetScrollableTextId(const ScrollableTextIdType& scrollabletextid);
        const ScrollableTextIdType& GetScrollableTextId() const { return m_ScrollableTextId; }

        // @WidgetBaseClass
        CdaWidget2DDef(ScrollableTextWidget2DBase, ::RichTextBaseWidget2D)
            CdaDescription("Allows the display of formated, multiline texts.")
            CdaReadableName("ScrollableTextWidget2DBase")
            CdaCategory("Text")

            CdaProperties()
                CdaBindableProperty(TextId, TextIdType, GetTextId, SetTextId)
                    CdaDescription("Id of the text that will be diplayed if the TextMode is set to SourceTextId.")
                    CdaCategory("Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FileName, FileNameType, GetFileName, SetFileName)
                    CdaDescription("File name of the text that will be diplayed if the TextMode is set to SourceFile.")
                    CdaCategory("Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextSource, TextSourceType, GetTextSource, SetTextSource)
                    CdaDescription("Controlls which source should be used as input.")
                    CdaCategory("Text")
                CdaBindablePropertyEnd()
                CdaProperty(ColorTable, ColorTableType, GetColorTable, SetColorTable)
                    CdaDescription("Contains all colors which will be used whenever a '\\cxx' is found in the text.")
                    CdaCategory("Color")
                CdaPropertyEnd()
                CdaProperty(TabStopTable, TabStopTableType, GetTabStopTable, SetTabStopTable)
                    CdaDescription("Contains all tab stop positions which will be used whenever a '\\txx' is found in the text.")
                    CdaCategory("TabStop")
                CdaPropertyEnd()
                CdaProperty(LinespacingFactor, LinespacingFactorType, GetLinespacingFactor, SetLinespacingFactor)
                    CdaDescription("Color to be used to display the text in disabled state.")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
                CdaProperty(TextWrapMode, TextWrapModeType, GetTextWrapMode, SetTextWrapMode)
                    CdaDescription("Controlls how to long lines should be wrapped. RT_WrapNone: No wrapping happens. RT_WrapWords: Whole words will be wrapped. If the word doesn't fit inside an empty line RT_WrapCharacters will be used. RT_WrapCharacters: Individual characters will be wrapped. If no character fits an empty line at least one will be drawn.")
                    CdaCategory("TextWrap")
                CdaPropertyEnd()
                CdaProperty(SwipeFriction, SwipeFrictionType, GetSwipeFriction, SetSwipeFriction)
                    CdaDescription("Controlls the intensity of swipe. Increasing  the friction decreases the swipe intensity")
                    CdaCategory("Swipe")
                CdaPropertyEnd()
                CdaProperty(PostUpdateMessage, PostUpdateMessageType, GetPostUpdateMessage, SetPostUpdateMessage)
                    CdaDescription("Decision on posting ScrollableTextUpdMsg when there is a change in current and maximum scroll position value is decided based on this property")
                    CdaCategory("ScrollableTextUpdMsg")
                CdaPropertyEnd()
                CdaProperty(ScrollableTextId, ScrollableTextIdType, GetScrollableTextId, SetScrollableTextId)
                    CdaDescription("Unique identifier of the scrollable text")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        TextIdType m_TextId;
        FileNameType m_FileName;
        TextSourceType m_TextSource;
        ColorTableType m_ColorTable;
        TabStopTableType m_TabStopTable;
        LinespacingFactorType m_LinespacingFactor;
        TextWrapModeType m_TextWrapMode;
        SwipeFrictionType m_SwipeFriction;
        PostUpdateMessageType m_PostUpdateMessage;
        ScrollableTextIdType m_ScrollableTextId;
};

#endif // ScrollableTextWidget2DBase_h
