/************************************************************************
*FILE: ScrollBarButtonWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ScrollBarButtonWidget2DBase_h)
#define ScrollBarButtonWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/Button/ButtonWidget2D.h>
#include <Widgets/2D/List/generated/ListEnums.h>
#define ENUM_DATA_TYPE \
ENUM_DATA_TYPE_BEGIN(ScrollBarButtonType)     \
    ENUM_DATA_TYPE_ITEM_VALUE(ScrollBarButtonPrevious, ListChangeUp)        \
    ENUM_DATA_TYPE_ITEM_VALUE(ScrollBarButtonNext, ListChangeDown)        \
    ENUM_DATA_TYPE_ITEM_VALUE(ScrollBarButtonPreviousPage, ListChangePageUp)        \
    ENUM_DATA_TYPE_ITEM_VALUE(ScrollBarButtonNextPage, ListChangePageDown)        \
ENUM_DATA_TYPE_END(ScrollBarButtonType)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [ScrollBarButtonWidget2DBase_Declaration]
class ScrollBarButtonWidget2DBase : public ::ButtonWidget2D
{
    public:
        typedef Candera::ScrollBarButtonType ChangeTypeType;

        typedef FeatStd::Int32 AmountType;

        typedef bool OnPressType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ChangeTypePropertyId = 0xFD9B7B70;
        static const FeatStd::UInt32 AmountPropertyId = 0x028675D8;
        static const FeatStd::UInt32 OnPressPropertyId = 0xBD454AC9;
        //! [Property_IDs]

        ScrollBarButtonWidget2DBase();
        virtual ~ScrollBarButtonWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ScrollBarButtonWidget2DBase, ::ButtonWidget2D);

        void SetChangeType(const ChangeTypeType& changetype);
        const ChangeTypeType& GetChangeType() const { return m_ChangeType; }

        void SetAmount(const AmountType& amount);
        const AmountType& GetAmount() const { return m_Amount; }

        void SetOnPress(const OnPressType& onpress);
        const OnPressType& GetOnPress() const { return m_OnPress; }

        // @WidgetBaseClass
        CdaWidget2DDef(ScrollBarButtonWidget2DBase, ::ButtonWidget2D)
            CdaDescription("It triggers scrolling actions for a ScrollBarWidget2D. Its node must be a child of the node of the ScrollBarWidget2D it should controll")
            CdaReadableName("ScrollBarButtonWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(ChangeType, ChangeTypeType, GetChangeType, SetChangeType)
                    CdaDescription("The type of action that will be issued to the scrollbar.")
                CdaPropertyEnd()
                CdaProperty(Amount, AmountType, GetAmount, SetAmount)
                    CdaDescription("The amount for the change type. For example, if set to 2 and ChangeType is set to Previous, it will request an action to go 2 items back.")
                CdaPropertyEnd()
                CdaProperty(OnPress, OnPressType, GetOnPress, SetOnPress)
                    CdaDescription("If set to true, then the action is done when pressing the button, otherwise it's done when releaseing the button.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ChangeTypeType m_ChangeType;
        AmountType m_Amount;
        OnPressType m_OnPress;
};

#endif // ScrollBarButtonWidget2DBase_h
