/************************************************************************
*FILE: ScrollBarWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ScrollBarWidget2DBase_h)
#define ScrollBarWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Touchable2D.h>
#include <Widgets/2D/ScrollBar/ScrollbarEnums.h>
// ------------------------------------------------------------------------
//! [ScrollBarWidget2DBase_Declaration]
class ScrollBarWidget2DBase : public ::Touchable2D
{
    public:
        typedef ::Candera::Node2D* ScrollableNodeType;

        typedef ::Candera::Node2D* BackwardNodeType;

        typedef ::Candera::Node2D* PageBackwardNodeType;

        typedef ::Candera::Node2D* SliderNodeType;

        typedef ::Candera::Node2D* PageForwardNodeType;

        typedef ::Candera::Node2D* ForwardNodeType;

        typedef ::Courier::UInt32 RepeatMessageType;

        typedef bool DynamicSliderSizeType;

        typedef ::Candera::Float SliderSizeType;

        typedef ::Candera::Float OverscrollSizeType;

        typedef ::Candera::KnobDragMode KnobDragModeType;

        typedef bool AdditionalPageButtonsType;

        typedef ::Candera::Node2D* AdditionalPageBackwardNodeType;

        typedef ::Candera::Node2D* AdditionalPageForwardNodeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ScrollableNodePropertyId = 0x0F67B3B9;
        static const FeatStd::UInt32 BackwardNodePropertyId = 0xAE2D9667;
        static const FeatStd::UInt32 PageBackwardNodePropertyId = 0x3BBA0E52;
        static const FeatStd::UInt32 SliderNodePropertyId = 0xCD0928B7;
        static const FeatStd::UInt32 PageForwardNodePropertyId = 0x618AFE00;
        static const FeatStd::UInt32 ForwardNodePropertyId = 0x58664B3A;
        static const FeatStd::UInt32 RepeatMessagePropertyId = 0x180E988D;
        static const FeatStd::UInt32 DynamicSliderSizePropertyId = 0xFEE4FA33;
        static const FeatStd::UInt32 SliderSizePropertyId = 0xE88DF9AA;
        static const FeatStd::UInt32 OverscrollSizePropertyId = 0x32592D80;
        static const FeatStd::UInt32 KnobDragModePropertyId = 0xDEBFD0F2;
        static const FeatStd::UInt32 AdditionalPageButtonsPropertyId = 0xCD190318;
        static const FeatStd::UInt32 AdditionalPageBackwardNodePropertyId = 0x2E420739;
        static const FeatStd::UInt32 AdditionalPageForwardNodePropertyId = 0xD2CAD124;
        //! [Property_IDs]

        ScrollBarWidget2DBase();
        virtual ~ScrollBarWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ScrollBarWidget2DBase, ::Touchable2D);

        void SetScrollableNode(const ScrollableNodeType& scrollablenode);
        const ScrollableNodeType& GetScrollableNode() const { return m_ScrollableNode; }

        void SetBackwardNode(const BackwardNodeType& backwardnode);
        const BackwardNodeType& GetBackwardNode() const { return m_BackwardNode; }

        void SetPageBackwardNode(const PageBackwardNodeType& pagebackwardnode);
        const PageBackwardNodeType& GetPageBackwardNode() const { return m_PageBackwardNode; }

        void SetSliderNode(const SliderNodeType& slidernode);
        const SliderNodeType& GetSliderNode() const { return m_SliderNode; }

        void SetPageForwardNode(const PageForwardNodeType& pageforwardnode);
        const PageForwardNodeType& GetPageForwardNode() const { return m_PageForwardNode; }

        void SetForwardNode(const ForwardNodeType& forwardnode);
        const ForwardNodeType& GetForwardNode() const { return m_ForwardNode; }

        void SetRepeatMessage(const RepeatMessageType& repeatmessage);
        const RepeatMessageType& GetRepeatMessage() const { return m_RepeatMessage; }

        void SetDynamicSliderSize(const DynamicSliderSizeType& dynamicslidersize);
        const DynamicSliderSizeType& GetDynamicSliderSize() const { return m_DynamicSliderSize; }

        //! [DataBinding_SliderSizePropertyGetterSetter]
        void SetSliderSize(const SliderSizeType& slidersize);
        const SliderSizeType& GetSliderSize() const { return m_SliderSize; }
        //! [DataBinding_SliderSizePropertyGetterSetter]

        //! [DataBinding_OverscrollSizePropertyGetterSetter]
        void SetOverscrollSize(const OverscrollSizeType& overscrollsize);
        const OverscrollSizeType& GetOverscrollSize() const { return m_OverscrollSize; }
        //! [DataBinding_OverscrollSizePropertyGetterSetter]

        void SetKnobDragMode(const KnobDragModeType& knobdragmode);
        const KnobDragModeType& GetKnobDragMode() const { return m_KnobDragMode; }

        void SetAdditionalPageButtons(const AdditionalPageButtonsType& additionalpagebuttons);
        const AdditionalPageButtonsType& GetAdditionalPageButtons() const { return m_AdditionalPageButtons; }

        void SetAdditionalPageBackwardNode(const AdditionalPageBackwardNodeType& additionalpagebackwardnode);
        const AdditionalPageBackwardNodeType& GetAdditionalPageBackwardNode() const { return m_AdditionalPageBackwardNode; }

        void SetAdditionalPageForwardNode(const AdditionalPageForwardNodeType& additionalpageforwardnode);
        const AdditionalPageForwardNodeType& GetAdditionalPageForwardNode() const { return m_AdditionalPageForwardNode; }

        // @WidgetBaseClass
        CdaWidget2DDef(ScrollBarWidget2DBase, ::Touchable2D)
            CdaDescription("Provides support to scroll through scrollable elements (e.g. a list).")
            CdaReadableName("ScrollBarWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(ScrollableNode, ScrollableNodeType, GetScrollableNode, SetScrollableNode)
                    CdaDescription("The node containing a FlexScrollable widget.")
                CdaPropertyEnd()
                CdaProperty(BackwardNode, BackwardNodeType, GetBackwardNode, SetBackwardNode)
                    CdaDescription("The node acting as back button.")
                CdaPropertyEnd()
                CdaProperty(PageBackwardNode, PageBackwardNodeType, GetPageBackwardNode, SetPageBackwardNode)
                    CdaDescription("The node acting as a page back button; the part between the knob and BackwardNode.")
                CdaPropertyEnd()
                CdaProperty(SliderNode, SliderNodeType, GetSliderNode, SetSliderNode)
                    CdaDescription("The node that will act as a slider and can be dragged. Its parent must be the ancestor of the PageBackwardNode and PageForwardNode.")
                CdaPropertyEnd()
                CdaProperty(PageForwardNode, PageForwardNodeType, GetPageForwardNode, SetPageForwardNode)
                    CdaDescription("The node acting as a page forward button; the part between the knob and ForwardNode.")
                CdaPropertyEnd()
                CdaProperty(ForwardNode, ForwardNodeType, GetForwardNode, SetForwardNode)
                    CdaDescription("The node acting as forward button.")
                CdaPropertyEnd()
                CdaProperty(RepeatMessage, RepeatMessageType, GetRepeatMessage, SetRepeatMessage)
                    CdaDescription("The time between triggering two consecutive events(back, forward, pageBack or pageForward) when the corresponding button is kept pressed.")
                CdaPropertyEnd()
                CdaProperty(DynamicSliderSize, DynamicSliderSizeType, GetDynamicSliderSize, SetDynamicSliderSize)
                    CdaDescription("Whether or not the slider size shall reflect the number of items in the list, if set to true the specified slider size will represent the minimum size.")
                CdaPropertyEnd()
                CdaBindableProperty(SliderSize, SliderSizeType, GetSliderSize, SetSliderSize)
                    CdaDescription("The percentage of the slider size relative to the size of the slider back.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OverscrollSize, OverscrollSizeType, GetOverscrollSize, SetOverscrollSize)
                    CdaDescription("The percentage of one of the overscroll areas relative to the size of the slider back. There are two regions of overscroll: one at the begining of the scrollbar and one at the end.")
                CdaBindablePropertyEnd()
                CdaProperty(KnobDragMode, KnobDragModeType, GetKnobDragMode, SetKnobDragMode)
                    CdaDescription("The mode the knob(slider) moves when dragged: ListPosition follows the list current position relative to its whole content; PointerPosition follows the pointer.")
                CdaPropertyEnd()
                CdaProperty(AdditionalPageButtons, AdditionalPageButtonsType, GetAdditionalPageButtons, SetAdditionalPageButtons)
                    CdaDescription("Use additional page buttons that are not resized and are not part of the knob movement area.")
                CdaPropertyEnd()
                CdaProperty(AdditionalPageBackwardNode, AdditionalPageBackwardNodeType, GetAdditionalPageBackwardNode, SetAdditionalPageBackwardNode)
                    CdaDescription("An auxiliary node acting as a page backward button. This node is not part of the knob movement area.")
                    CdaVisibilityTest(GetAdditionalPageButtons)
                CdaPropertyEnd()
                CdaProperty(AdditionalPageForwardNode, AdditionalPageForwardNodeType, GetAdditionalPageForwardNode, SetAdditionalPageForwardNode)
                    CdaDescription("An auxiliary node acting as a page forward button. This node is not part of the knob movement area.")
                    CdaVisibilityTest(GetAdditionalPageButtons)
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ScrollableNodeType m_ScrollableNode;
        BackwardNodeType m_BackwardNode;
        PageBackwardNodeType m_PageBackwardNode;
        SliderNodeType m_SliderNode;
        PageForwardNodeType m_PageForwardNode;
        ForwardNodeType m_ForwardNode;
        RepeatMessageType m_RepeatMessage;
        DynamicSliderSizeType m_DynamicSliderSize;
        SliderSizeType m_SliderSize;
        OverscrollSizeType m_OverscrollSize;
        KnobDragModeType m_KnobDragMode;
        AdditionalPageButtonsType m_AdditionalPageButtons;
        AdditionalPageBackwardNodeType m_AdditionalPageBackwardNode;
        AdditionalPageForwardNodeType m_AdditionalPageForwardNode;
};

#endif // ScrollBarWidget2DBase_h
