/************************************************************************
*FILE: ScrollBarWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ScrollBarWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ScrollBarWidget2DBase)

ScrollBarWidget2DBase::ScrollBarWidget2DBase() :
    m_ScrollableNode(ScrollableNodeType()),
    m_BackwardNode(BackwardNodeType()),
    m_PageBackwardNode(PageBackwardNodeType()),
    m_SliderNode(SliderNodeType()),
    m_PageForwardNode(PageForwardNodeType()),
    m_ForwardNode(ForwardNodeType()),
    m_RepeatMessage(RepeatMessageType()),
    m_DynamicSliderSize(false),
    m_SliderSize(SliderSizeType()),
    m_OverscrollSize(OverscrollSizeType()),
    m_KnobDragMode(::Candera::ListPosition),
    m_AdditionalPageButtons(false),
    m_AdditionalPageBackwardNode(AdditionalPageBackwardNodeType()),
    m_AdditionalPageForwardNode(AdditionalPageForwardNodeType())
{
}

ScrollBarWidget2DBase::~ScrollBarWidget2DBase()
{
}

void ScrollBarWidget2DBase::SetScrollableNode(const ScrollableNodeType& scrollablenode)
{
    m_ScrollableNode = scrollablenode;
    OnChanged(static_cast< ::FeatStd::UInt32>(ScrollableNodePropertyId));
}

void ScrollBarWidget2DBase::SetBackwardNode(const BackwardNodeType& backwardnode)
{
    m_BackwardNode = backwardnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(BackwardNodePropertyId));
}

void ScrollBarWidget2DBase::SetPageBackwardNode(const PageBackwardNodeType& pagebackwardnode)
{
    m_PageBackwardNode = pagebackwardnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(PageBackwardNodePropertyId));
}

void ScrollBarWidget2DBase::SetSliderNode(const SliderNodeType& slidernode)
{
    m_SliderNode = slidernode;
    OnChanged(static_cast< ::FeatStd::UInt32>(SliderNodePropertyId));
}

void ScrollBarWidget2DBase::SetPageForwardNode(const PageForwardNodeType& pageforwardnode)
{
    m_PageForwardNode = pageforwardnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(PageForwardNodePropertyId));
}

void ScrollBarWidget2DBase::SetForwardNode(const ForwardNodeType& forwardnode)
{
    m_ForwardNode = forwardnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(ForwardNodePropertyId));
}

void ScrollBarWidget2DBase::SetRepeatMessage(const RepeatMessageType& repeatmessage)
{
    m_RepeatMessage = repeatmessage;
    OnChanged(static_cast< ::FeatStd::UInt32>(RepeatMessagePropertyId));
}

void ScrollBarWidget2DBase::SetDynamicSliderSize(const DynamicSliderSizeType& dynamicslidersize)
{
    m_DynamicSliderSize = dynamicslidersize;
    OnChanged(static_cast< ::FeatStd::UInt32>(DynamicSliderSizePropertyId));
}

void ScrollBarWidget2DBase::SetSliderSize(const SliderSizeType& slidersize)
{
    m_SliderSize = slidersize;
    OnChanged(static_cast< ::FeatStd::UInt32>(SliderSizePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SliderSize");
    }
}

void ScrollBarWidget2DBase::SetOverscrollSize(const OverscrollSizeType& overscrollsize)
{
    m_OverscrollSize = overscrollsize;
    OnChanged(static_cast< ::FeatStd::UInt32>(OverscrollSizePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("OverscrollSize");
    }
}

void ScrollBarWidget2DBase::SetKnobDragMode(const KnobDragModeType& knobdragmode)
{
    m_KnobDragMode = knobdragmode;
    OnChanged(static_cast< ::FeatStd::UInt32>(KnobDragModePropertyId));
}

void ScrollBarWidget2DBase::SetAdditionalPageButtons(const AdditionalPageButtonsType& additionalpagebuttons)
{
    m_AdditionalPageButtons = additionalpagebuttons;
    OnChanged(static_cast< ::FeatStd::UInt32>(AdditionalPageButtonsPropertyId));
}

void ScrollBarWidget2DBase::SetAdditionalPageBackwardNode(const AdditionalPageBackwardNodeType& additionalpagebackwardnode)
{
    m_AdditionalPageBackwardNode = additionalpagebackwardnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(AdditionalPageBackwardNodePropertyId));
}

void ScrollBarWidget2DBase::SetAdditionalPageForwardNode(const AdditionalPageForwardNodeType& additionalpageforwardnode)
{
    m_AdditionalPageForwardNode = additionalpageforwardnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(AdditionalPageForwardNodePropertyId));
}
