/************************************************************************
*FILE: RichTextBaseWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(RichTextBaseWidget2DBase_h)
#define RichTextBaseWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/RichTextBase/RichText.h>
#include <Widgets/2D/Touchable2D.h>
// ------------------------------------------------------------------------
//! [RichTextBaseWidget2DBase_Declaration]
class RichTextBaseWidget2DBase : public ::Touchable2D
{
    public:
        typedef FeatStd::String TextType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> StyleType;

        typedef Candera::Vector2 TextAreaSizeType;

        typedef Candera::RT_TextAlignment HorizontalAlignmentType;

        typedef Candera::RT_TextAlignment VerticalAlignmentType;

        typedef Candera::Color NormalTextColorType;

        typedef Candera::Float AlphaValueType;

        //! [Property_IDs]
        static const FeatStd::UInt32 TextPropertyId = 0xB5A7CD47;
        static const FeatStd::UInt32 StylePropertyId = 0xB90F95B4;
        static const FeatStd::UInt32 TextAreaSizePropertyId = 0x7946C578;
        static const FeatStd::UInt32 HorizontalAlignmentPropertyId = 0x32F00453;
        static const FeatStd::UInt32 VerticalAlignmentPropertyId = 0x599B04F6;
        static const FeatStd::UInt32 NormalTextColorPropertyId = 0x80687832;
        static const FeatStd::UInt32 AlphaValuePropertyId = 0x2D98CE2E;
        //! [Property_IDs]

        RichTextBaseWidget2DBase();
        virtual ~RichTextBaseWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(RichTextBaseWidget2DBase, ::Touchable2D);

        virtual void Update();

        //! [DataBinding_TextPropertyGetterSetter]
        void SetText(const TextType& text);
        const TextType& GetText() const { return m_Text; }
        //! [DataBinding_TextPropertyGetterSetter]

        void SetStyle(const StyleType& style);
        const StyleType& GetStyle() const { return m_Style; }

        //! [DataBinding_TextAreaSizePropertyGetterSetter]
        void SetTextAreaSize(const TextAreaSizeType& textareasize);
        const TextAreaSizeType& GetTextAreaSize() const { return m_TextAreaSize; }
        //! [DataBinding_TextAreaSizePropertyGetterSetter]

        void SetHorizontalAlignment(const HorizontalAlignmentType& horizontalalignment);
        const HorizontalAlignmentType& GetHorizontalAlignment() const { return m_HorizontalAlignment; }

        void SetVerticalAlignment(const VerticalAlignmentType& verticalalignment);
        const VerticalAlignmentType& GetVerticalAlignment() const { return m_VerticalAlignment; }

        void SetNormalTextColor(const NormalTextColorType& normaltextcolor);
        const NormalTextColorType& GetNormalTextColor() const { return m_NormalTextColor; }

        //! [DataBinding_AlphaValuePropertyGetterSetter]
        void SetAlphaValue(const AlphaValueType& alphavalue);
        const AlphaValueType& GetAlphaValue() const { return m_AlphaValue; }
        //! [DataBinding_AlphaValuePropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(RichTextBaseWidget2DBase, ::Touchable2D)
            CdaDescription("Base class for all rich text capable widget. Don't use this widget directly.")
            CdaReadableName("RichText widget")
            CdaCategory("Text")

            CdaProperties()
                CdaBindableProperty(Text, TextType, GetText, SetText)
                    CdaDescription("Text to be displayed.")
                    CdaCategory("Text")
                CdaBindablePropertyEnd()
                CdaProperty(Style, StyleType, GetStyle, SetStyle)
                    CdaDescription("Default style to be used for text rendering.")
                    CdaCategory("Style")
                CdaPropertyEnd()
                CdaBindableProperty(TextAreaSize, TextAreaSizeType, GetTextAreaSize, SetTextAreaSize)
                    CdaDescription("The text area size to be used for truncation and alignment calculations.")
                    CdaCategory("Alignment")
                CdaBindablePropertyEnd()
                CdaProperty(HorizontalAlignment, HorizontalAlignmentType, GetHorizontalAlignment, SetHorizontalAlignment)
                    CdaDescription("Horizontal alignment of the text. RT_Leading: Aligns text to the left side for LTR and right side for RTL texts. RT_Middle: Aligned to the center. RT_Trailing: Aligns text to the right side for LTR and left side for RTL texts.")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
                CdaProperty(VerticalAlignment, VerticalAlignmentType, GetVerticalAlignment, SetVerticalAlignment)
                    CdaDescription("Vertical alignment of the text. RT_Leading: Aligns text to the top side for TTB and bottom side for BTT texts. RT_Middle: Aligned to the center. RT_Trailing: Aligns text to the bottom side for TTB and top side for BTT texts.")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
                CdaProperty(NormalTextColor, NormalTextColorType, GetNormalTextColor, SetNormalTextColor)
                    CdaDescription("Default color to be used to display the text.")
                    CdaCategory("Color")
                CdaPropertyEnd()
                CdaBindableProperty(AlphaValue, AlphaValueType, GetAlphaValue, SetAlphaValue)
                    CdaDescription("Sets the alpha value to of the associated node.")
                    CdaCategory("Color")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        TextType m_Text;
        StyleType m_Style;
        TextAreaSizeType m_TextAreaSize;
        HorizontalAlignmentType m_HorizontalAlignment;
        VerticalAlignmentType m_VerticalAlignment;
        NormalTextColorType m_NormalTextColor;
        AlphaValueType m_AlphaValue;

        ::FeatStd::Internal::Vector< ::FeatStd::UInt32 > m_ChangeSetRichTextBaseWidget2DBase;
};

#endif // RichTextBaseWidget2DBase_h
