/************************************************************************
*FILE: ScrollableRichTextWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_richtext_ScrollableRichTextWidget2DBase_h)
#define hmibase_widget_richtext_ScrollableRichTextWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/Touchable2D.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
//! [ScrollableRichTextWidget2DBase_Declaration]
class ScrollableRichTextWidget2DBase : public ::Touchable2D
{
    public:
        typedef ::FeatStd::UInt32 ScrollIdType;

        typedef ::FeatStd::UInt32 SwipeDecelerationType;

        typedef ::FeatStd::UInt32 SwipeMaxDistanceType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ScrollIdPropertyId = 0x4D064944;
        //! [Property_IDs]

        ScrollableRichTextWidget2DBase();
        virtual ~ScrollableRichTextWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ScrollableRichTextWidget2DBase, ::Touchable2D);

        //! [DataBinding_ScrollIdPropertyGetterSetter]
        void SetScrollId(const ScrollIdType& scrollid);
        const ScrollIdType& GetScrollId() const { return m_ScrollId; }
        //! [DataBinding_ScrollIdPropertyGetterSetter]

        void SetSwipeDeceleration(const SwipeDecelerationType& swipedeceleration);
        const SwipeDecelerationType& GetSwipeDeceleration() const { return m_SwipeDeceleration; }

        void SetSwipeMaxDistance(const SwipeMaxDistanceType& swipemaxdistance);
        const SwipeMaxDistanceType& GetSwipeMaxDistance() const { return m_SwipeMaxDistance; }

        // @WidgetBaseClass
        CdaWidget2DDef(ScrollableRichTextWidget2DBase, ::Touchable2D)
            CdaDescription("Provides vertical scrolling support for rich text. See Widget User Guide for details on how to use this widget.")
            CdaReadableName("ScrollableRichTextWidget2DBase")
            CdaCategory("RichText")

            CdaProperties()
                CdaBindableProperty(ScrollId, ScrollIdType, GetScrollId, SetScrollId)
                    CdaDescription("A unique identifier be used to communicate with e.g. the data model.")
                CdaBindablePropertyEnd()
                CdaProperty(SwipeDeceleration, SwipeDecelerationType, GetSwipeDeceleration, SetSwipeDeceleration)
                    CdaDescription("Scroll deceleration for swipe gesture in [pixel / s²")
                CdaPropertyEnd()
                CdaProperty(SwipeMaxDistance, SwipeMaxDistanceType, GetSwipeMaxDistance, SetSwipeMaxDistance)
                    CdaDescription("If swipe velocity and configured deceleration would result in a scroll distance that is greater than this value, the deceleration is increased to limit the scroll distance.\n\nA value of 0 means no limit.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ScrollIdType m_ScrollId;
        SwipeDecelerationType m_SwipeDeceleration;
        SwipeMaxDistanceType m_SwipeMaxDistance;
};
} // namespace richtext
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_richtext_ScrollableRichTextWidget2DBase_h
