/************************************************************************
*FILE: RichTextWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_richtext_RichTextWidget2DBase_h)
#define hmibase_widget_richtext_RichTextWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/MetaInfo/BaseInternalMacros.h>
#include <Candera/System/MetaInfo/EnumDataTypeInternal.h>
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>

namespace hmibase {
namespace widget {
namespace richtext {
namespace SrcType {
// =========================================================================
enum Enum {
    String,
    URL
};
} // namespace SrcType
} // namespace richtext
} // namespace widget
} // namespace hmibase

CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(::hmibase::widget::richtext::SrcType::Enum, _hmibase_widget_richtext_SrcType_Enum)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(String)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(URL)
CANDERA_INTERNAL_ENUM_METAINFO_END()

namespace hmibase {
} // namespace hmibase
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::hmibase::widget::richtext::SrcType::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::hmibase::widget::richtext::SrcType::Enum const & object);
} // namespace FeatStd
#endif
namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
//! [RichTextWidget2DBase_Declaration]
class RichTextWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef SrcType::Enum SourceTypeType;

        typedef ::FeatStd::String SourceType;

        typedef Candera::TextRendering::SharedStyle::SharedPointer TextStyleType;

        typedef ::FeatStd::String StyleSheetUrlType;

        typedef ::FeatStd::String StyleType;

        typedef bool ColorEnabledType;

        typedef Candera::Color ColorType;

        typedef Candera::Vector2 OffsetType;

        typedef FeatStd::UInt16 MaxNumberOfLinesType;

        typedef bool HorizontalAlignmentEnabledType;

        typedef Candera::HorizontalAlignment HorizontalAlignmentType;

        typedef bool CultureDependentAlignmentType;

        typedef FeatStd::Int32 BaselineOffsetType;

        typedef bool AsynchronousRenderingType;

        typedef bool SlicedRenderingType;

        typedef FeatStd::UInt16 SliceHeightType;

        //! [Property_IDs]
        static const FeatStd::UInt32 SourceTypePropertyId = 0x9E3DB09B;
        static const FeatStd::UInt32 SourcePropertyId = 0x9FB1BC0D;
        static const FeatStd::UInt32 TextStylePropertyId = 0x7DDF3132;
        static const FeatStd::UInt32 StyleSheetUrlPropertyId = 0x94198594;
        static const FeatStd::UInt32 StylePropertyId = 0xB90F95B4;
        static const FeatStd::UInt32 ColorEnabledPropertyId = 0xC0EDF5CB;
        static const FeatStd::UInt32 ColorPropertyId = 0x4E036667;
        static const FeatStd::UInt32 OffsetPropertyId = 0x91322C71;
        static const FeatStd::UInt32 MaxNumberOfLinesPropertyId = 0x98DC6D91;
        static const FeatStd::UInt32 HorizontalAlignmentEnabledPropertyId = 0x767B1411;
        static const FeatStd::UInt32 HorizontalAlignmentPropertyId = 0x32F00453;
        static const FeatStd::UInt32 CultureDependentAlignmentPropertyId = 0xB2CB46F1;
        static const FeatStd::UInt32 BaselineOffsetPropertyId = 0x50274E73;
        //! [Property_IDs]

        RichTextWidget2DBase();
        virtual ~RichTextWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(RichTextWidget2DBase, ::BaseWidget2D);

        void SetSourceType(const SourceTypeType& sourcetype);
        const SourceTypeType& GetSourceType() const { return m_SourceType; }
        SourceTypeType& GetSourceType() { return m_SourceType; }

        //! [DataBinding_SourcePropertyGetterSetter]
        void SetSource(const SourceType& source);
        const SourceType& GetSource() const { return m_Source; }
        //! [DataBinding_SourcePropertyGetterSetter]

        //! [DataBinding_TextStylePropertyGetterSetter]
        void SetTextStyle(const TextStyleType& textstyle);
        const TextStyleType& GetTextStyle() const { return m_TextStyle; }
        TextStyleType& GetTextStyle() { return m_TextStyle; }
        //! [DataBinding_TextStylePropertyGetterSetter]

        void SetStyleSheetUrl(const StyleSheetUrlType& stylesheeturl);
        const StyleSheetUrlType& GetStyleSheetUrl() const { return m_StyleSheetUrl; }
        StyleSheetUrlType& GetStyleSheetUrl() { return m_StyleSheetUrl; }

        //! [DataBinding_StylePropertyGetterSetter]
        void SetStyle(const StyleType& style);
        const StyleType& GetStyle() const { return m_Style; }
        StyleType& GetStyle() { return m_Style; }
        //! [DataBinding_StylePropertyGetterSetter]

        void SetColorEnabled(const ColorEnabledType& colorenabled);
        const ColorEnabledType& GetColorEnabled() const { return m_ColorEnabled; }
        ColorEnabledType& GetColorEnabled() { return m_ColorEnabled; }

        //! [DataBinding_ColorPropertyGetterSetter]
        void SetColor(const ColorType& color);
        const ColorType& GetColor() const { return m_Color; }
        //! [DataBinding_ColorPropertyGetterSetter]

        void SetOffset(const OffsetType& offset);
        const OffsetType& GetOffset() const { return m_Offset; }
        OffsetType& GetOffset() { return m_Offset; }

        void SetMaxNumberOfLines(const MaxNumberOfLinesType& maxnumberoflines);
        const MaxNumberOfLinesType& GetMaxNumberOfLines() const { return m_MaxNumberOfLines; }
        MaxNumberOfLinesType& GetMaxNumberOfLines() { return m_MaxNumberOfLines; }

        void SetHorizontalAlignmentEnabled(const HorizontalAlignmentEnabledType& horizontalalignmentenabled);
        const HorizontalAlignmentEnabledType& GetHorizontalAlignmentEnabled() const { return m_HorizontalAlignmentEnabled; }
        HorizontalAlignmentEnabledType& GetHorizontalAlignmentEnabled() { return m_HorizontalAlignmentEnabled; }

        void SetHorizontalAlignment(const HorizontalAlignmentType& horizontalalignment);
        const HorizontalAlignmentType& GetHorizontalAlignment() const { return m_HorizontalAlignment; }
        HorizontalAlignmentType& GetHorizontalAlignment() { return m_HorizontalAlignment; }

        void SetCultureDependentAlignment(const CultureDependentAlignmentType& culturedependentalignment);
        const CultureDependentAlignmentType& GetCultureDependentAlignment() const { return m_CultureDependentAlignment; }
        CultureDependentAlignmentType& GetCultureDependentAlignment() { return m_CultureDependentAlignment; }

        void SetBaselineOffset(const BaselineOffsetType& baselineoffset);
        const BaselineOffsetType& GetBaselineOffset() const { return m_BaselineOffset; }
        BaselineOffsetType& GetBaselineOffset() { return m_BaselineOffset; }

        void SetAsynchronousRendering(const AsynchronousRenderingType& asynchronousrendering);
        const AsynchronousRenderingType& GetAsynchronousRendering() const { return m_AsynchronousRendering; }
        AsynchronousRenderingType& GetAsynchronousRendering() { return m_AsynchronousRendering; }

        void SetSlicedRendering(const SlicedRenderingType& slicedrendering);
        const SlicedRenderingType& GetSlicedRendering() const { return m_SlicedRendering; }
        SlicedRenderingType& GetSlicedRendering() { return m_SlicedRendering; }

        void SetSliceHeight(const SliceHeightType& sliceheight);
        const SliceHeightType& GetSliceHeight() const { return m_SliceHeight; }
        SliceHeightType& GetSliceHeight() { return m_SliceHeight; }

        // @WidgetBaseClass
        CdaWidget2DDef(RichTextWidget2DBase, ::BaseWidget2D)
            CdaDescription("Renders formatted and styled text elements. See Widget User Guide for details on how to use this widget.")
            CdaReadableName("RichTextWidget2DBase")
            CdaCategory("RichText")

            CdaProperties()
                CdaProperty(SourceType, SourceTypeType, GetSourceType, SetSourceType)
                    CdaDescription("Defines how to interpret string property 'Source'.\n\n- String\nSource defines the HTML formatted string.\n\n- URL\nSource is an URL to a resource that holds the HTML formatted string. Format for URL is [scheme]:[authority]/[path].\n\nCurrently supported URLs are\n\n- asset:path/[path]\nthe path to the source in format shown as Candera Name in property grid.\nExample: 'asset:path/Resources#sample.html'\n\n- asset:id/[id]\nthe asset id as decimal value as defined with property 'Id'.\nExample: 'asset:id/1000'")
                CdaPropertyEnd()
                CdaBindableProperty(Source, SourceType, GetSource, SetSource)
                    CdaDescription("Depending on property 'Source Type' the\n\n- String\nThis can either be plain text or a string including HTML tags like\n<p style='font-size:2em;color:blue'>This is large blue text.</p>\n\n- URL\nURL to a resource that holds the HTML formatted text. See property 'Source Type' for supported URL formats.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextStyle, TextStyleType, GetTextStyle, SetTextStyle)
                    CdaDescription("This text style is taken if not defined in HTML style.\nTo define a text style the following CSS properties has to be used (example):\n- text-family:font-family:Resources#Fonts#Arial\n- text-size:20px")
                CdaBindablePropertyEnd()
                CdaProperty(StyleSheetUrl, StyleSheetUrlType, GetStyleSheetUrl, SetStyleSheetUrl)
                    CdaDescription("The URL in format [scheme]:[authority]/[path] to the HTML style sheet document. See property 'Source Type' for URL examples.\n\nThe following CSS properties are supported:\n- background-color\n- color\n- display\n- font-family\n- font-size\n- height\n- line-height\n- margin-bottom\n- margin-left\n- margin-right\n- margin-top\n- margin\n- overflow\n- padding-bottom\n- padding-left\n- padding-right\n- padding-top\n- padding\n- position\n- text-align\n- text-overflow\n- vertical-align\n- white-space\n- width")
                CdaPropertyEnd()
                CdaBindableProperty(Style, StyleType, GetStyle, SetStyle)
                    CdaDescription("Local user style that overrides the style properties defined by property 'Style Sheet Url'.\nExample:\nhtml{color:red;font-size:26px}")
                CdaBindablePropertyEnd()
                CdaProperty(ColorEnabled, ColorEnabledType, GetColorEnabled, SetColorEnabled)
                    CdaDescription("If this property is set to true, the text color can be defined with property 'Color'.")
                CdaPropertyEnd()
                CdaBindableProperty(Color, ColorType, GetColor, SetColor)
                    CdaDescription("The color to be set on the text, overrules HTML style 'body{color:}'")
                    CdaVisibilityTest(GetColorEnabled)
                CdaBindablePropertyEnd()
                CdaProperty(Offset, OffsetType, GetOffset, SetOffset)
                    CdaDescription("Offset : Candera::Vector2")
                CdaPropertyEnd()
                CdaProperty(MaxNumberOfLines, MaxNumberOfLinesType, GetMaxNumberOfLines, SetMaxNumberOfLines)
                    CdaDescription("If set to a value greater than zero, text truncation happens at last specified line.\nIf truncation should show an ellipsis ('...') at the end, 'text-overflow:ellipsis' has to be defined as style.")
                CdaPropertyEnd()
                CdaProperty(HorizontalAlignmentEnabled, HorizontalAlignmentEnabledType, GetHorizontalAlignmentEnabled, SetHorizontalAlignmentEnabled)
                    CdaDescription("If this property is set to true, the horizontal alignment can be defined with property 'Horizontal Alignment'.")
                CdaPropertyEnd()
                CdaProperty(HorizontalAlignment, HorizontalAlignmentType, GetHorizontalAlignment, SetHorizontalAlignment)
                    CdaDescription("The horizontal alignment for the text, overrules HTML style body{text-align:}")
                    CdaVisibilityTest(GetHorizontalAlignmentEnabled)
                CdaPropertyEnd()
                CdaProperty(CultureDependentAlignment, CultureDependentAlignmentType, GetCultureDependentAlignment, SetCultureDependentAlignment)
                    CdaDescription("Defines whether the horizontal alignment depends on the culture or not.")
                CdaPropertyEnd()
                CdaProperty(BaselineOffset, BaselineOffsetType, GetBaselineOffset, SetBaselineOffset)
                    CdaDescription("If set to a value >= 0 this value defines the vertical distance in pixel between node position and the baseline position of the first rendered text line.")
                CdaPropertyEnd()
                CdaProperty(AsynchronousRendering, AsynchronousRenderingType, GetAsynchronousRendering, SetAsynchronousRendering)
                    CdaDescription("Enables asynchronous parsing and rendering.")
                CdaPropertyEnd()
                CdaProperty(SlicedRendering, SlicedRenderingType, GetSlicedRendering, SetSlicedRendering)
                    CdaDescription("Enables rendering into separate bitmap slices.")
                CdaPropertyEnd()
                CdaProperty(SliceHeight, SliceHeightType, GetSliceHeight, SetSliceHeight)
                    CdaDescription("The pixel height for all slices. Value 0 defines a slice height that is automatically set to the viewport height.")
                    CdaVisibilityTest(GetSlicedRendering)
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        SourceTypeType m_SourceType;
        SourceType m_Source;
        TextStyleType m_TextStyle;
        StyleSheetUrlType m_StyleSheetUrl;
        StyleType m_Style;
        ColorEnabledType m_ColorEnabled;
        ColorType m_Color;
        OffsetType m_Offset;
        MaxNumberOfLinesType m_MaxNumberOfLines;
        HorizontalAlignmentEnabledType m_HorizontalAlignmentEnabled;
        HorizontalAlignmentType m_HorizontalAlignment;
        CultureDependentAlignmentType m_CultureDependentAlignment;
        BaselineOffsetType m_BaselineOffset;
        AsynchronousRenderingType m_AsynchronousRendering;
        SlicedRenderingType m_SlicedRendering;
        SliceHeightType m_SliceHeight;
};
} // namespace richtext
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_richtext_RichTextWidget2DBase_h
