/************************************************************************
*FILE: RichTextMarqueeWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_richtext_RichTextMarqueeWidget2DBase_h)
#define hmibase_widget_richtext_RichTextMarqueeWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/BaseWidget2D.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
//! [RichTextMarqueeWidget2DBase_Declaration]
class RichTextMarqueeWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef FeatStd::UInt32 SpeedType;

        typedef FeatStd::UInt32 DelayStartType;

        typedef FeatStd::UInt32 DelayEndType;

        typedef bool StartEmptyType;

        typedef bool EndEmptyType;

        typedef FeatStd::UInt32 RepeatCountType;

        typedef bool BounceType;

        RichTextMarqueeWidget2DBase();
        virtual ~RichTextMarqueeWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(RichTextMarqueeWidget2DBase, ::BaseWidget2D);

        void SetSpeed(const SpeedType& speed);
        const SpeedType& GetSpeed() const { return m_Speed; }
        SpeedType& GetSpeed() { return m_Speed; }

        void SetDelayStart(const DelayStartType& delaystart);
        const DelayStartType& GetDelayStart() const { return m_DelayStart; }
        DelayStartType& GetDelayStart() { return m_DelayStart; }

        void SetDelayEnd(const DelayEndType& delayend);
        const DelayEndType& GetDelayEnd() const { return m_DelayEnd; }
        DelayEndType& GetDelayEnd() { return m_DelayEnd; }

        void SetStartEmpty(const StartEmptyType& startempty);
        const StartEmptyType& GetStartEmpty() const { return m_StartEmpty; }
        StartEmptyType& GetStartEmpty() { return m_StartEmpty; }

        void SetEndEmpty(const EndEmptyType& endempty);
        const EndEmptyType& GetEndEmpty() const { return m_EndEmpty; }
        EndEmptyType& GetEndEmpty() { return m_EndEmpty; }

        void SetRepeatCount(const RepeatCountType& repeatcount);
        const RepeatCountType& GetRepeatCount() const { return m_RepeatCount; }
        RepeatCountType& GetRepeatCount() { return m_RepeatCount; }

        void SetBounce(const BounceType& bounce);
        const BounceType& GetBounce() const { return m_Bounce; }
        BounceType& GetBounce() { return m_Bounce; }

        // @WidgetBaseClass
        CdaWidget2DDef(RichTextMarqueeWidget2DBase, ::BaseWidget2D)
            CdaDescription("Provides horizontal scrolling animation support for rich text. See Widget User Guide for details on how to use this widget.")
            CdaReadableName("RichTextMarqueeWidget2DBase")
            CdaCategory("RichText")

            CdaProperties()
                CdaProperty(Speed, SpeedType, GetSpeed, SetSpeed)
                    CdaDescription("Animation speed in pixel per second.")
                CdaPropertyEnd()
                CdaProperty(DelayStart, DelayStartType, GetDelayStart, SetDelayStart)
                    CdaDescription("Defines a delay in milliseconds at the start of the marquee animation.")
                CdaPropertyEnd()
                CdaProperty(DelayEnd, DelayEndType, GetDelayEnd, SetDelayEnd)
                    CdaDescription("Defines a delay in milliseconds at the end of the marquee animation.")
                CdaPropertyEnd()
                CdaProperty(StartEmpty, StartEmptyType, GetStartEmpty, SetStartEmpty)
                    CdaDescription("If set, the animation starts with an empty field and all text is moved in from the right.\n\nIf not set, the visible part of the text is displayed from the beginning and the hidden part is moved in from the right.")
                CdaPropertyEnd()
                CdaProperty(EndEmpty, EndEmptyType, GetEndEmpty, SetEndEmpty)
                    CdaDescription("If set, the animation ends with an empty field, which means that all text is moved to the left.\n\nIf not set, the animation ends as soon as the last character on the right side is completely visible.")
                CdaPropertyEnd()
                CdaProperty(RepeatCount, RepeatCountType, GetRepeatCount, SetRepeatCount)
                    CdaDescription("Number of animation sequences to run, zero means infinite.")
                CdaPropertyEnd()
                CdaProperty(Bounce, BounceType, GetBounce, SetBounce)
                    CdaDescription("If set, the animation reverts the direction at the end (text runs out to the right again).")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        SpeedType m_Speed;
        DelayStartType m_DelayStart;
        DelayEndType m_DelayEnd;
        StartEmptyType m_StartEmpty;
        EndEmptyType m_EndEmpty;
        RepeatCountType m_RepeatCount;
        BounceType m_Bounce;
};
} // namespace richtext
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_richtext_RichTextMarqueeWidget2DBase_h
