/************************************************************************
*FILE: RichTextHighlightWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_richtext_RichTextHighlightWidget2DBase_h)
#define hmibase_widget_richtext_RichTextHighlightWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/RichText/Engine/RtHighlighter.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
//! [RichTextHighlightWidget2DBase_Declaration]
class RichTextHighlightWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Highlighter::HighlightMode HighlightModeType;

        typedef ::FeatStd::String HighlightTextType;

        typedef bool AllOccurrencesType;

        typedef bool CaseSensitiveType;

        typedef bool TextColorEnabledType;

        typedef Candera::Color TextColorType;

        typedef bool BackgroundColorEnabledType;

        typedef Candera::Color BackgroundColorType;

        //! [Property_IDs]
        static const FeatStd::UInt32 HighlightModePropertyId = 0xA69B5DD6;
        static const FeatStd::UInt32 HighlightTextPropertyId = 0xB1384D7C;
        static const FeatStd::UInt32 AllOccurrencesPropertyId = 0x25FD44A6;
        static const FeatStd::UInt32 CaseSensitivePropertyId = 0xF8A726AC;
        static const FeatStd::UInt32 TextColorEnabledPropertyId = 0xDE72640B;
        static const FeatStd::UInt32 TextColorPropertyId = 0x04840BDC;
        static const FeatStd::UInt32 BackgroundColorEnabledPropertyId = 0xE8868C4C;
        static const FeatStd::UInt32 BackgroundColorPropertyId = 0xDCA450C2;
        //! [Property_IDs]

        RichTextHighlightWidget2DBase();
        virtual ~RichTextHighlightWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(RichTextHighlightWidget2DBase, ::BaseWidget2D);

        void SetHighlightMode(const HighlightModeType& highlightmode);
        const HighlightModeType& GetHighlightMode() const { return m_HighlightMode; }
        HighlightModeType& GetHighlightMode() { return m_HighlightMode; }

        //! [DataBinding_HighlightTextPropertyGetterSetter]
        void SetHighlightText(const HighlightTextType& highlighttext);
        const HighlightTextType& GetHighlightText() const { return m_HighlightText; }
        //! [DataBinding_HighlightTextPropertyGetterSetter]

        void SetAllOccurrences(const AllOccurrencesType& alloccurrences);
        const AllOccurrencesType& GetAllOccurrences() const { return m_AllOccurrences; }
        AllOccurrencesType& GetAllOccurrences() { return m_AllOccurrences; }

        void SetCaseSensitive(const CaseSensitiveType& casesensitive);
        const CaseSensitiveType& GetCaseSensitive() const { return m_CaseSensitive; }
        CaseSensitiveType& GetCaseSensitive() { return m_CaseSensitive; }

        void SetTextColorEnabled(const TextColorEnabledType& textcolorenabled);
        const TextColorEnabledType& GetTextColorEnabled() const { return m_TextColorEnabled; }
        TextColorEnabledType& GetTextColorEnabled() { return m_TextColorEnabled; }

        //! [DataBinding_TextColorPropertyGetterSetter]
        void SetTextColor(const TextColorType& textcolor);
        const TextColorType& GetTextColor() const { return m_TextColor; }
        //! [DataBinding_TextColorPropertyGetterSetter]

        void SetBackgroundColorEnabled(const BackgroundColorEnabledType& backgroundcolorenabled);
        const BackgroundColorEnabledType& GetBackgroundColorEnabled() const { return m_BackgroundColorEnabled; }
        BackgroundColorEnabledType& GetBackgroundColorEnabled() { return m_BackgroundColorEnabled; }

        //! [DataBinding_BackgroundColorPropertyGetterSetter]
        void SetBackgroundColor(const BackgroundColorType& backgroundcolor);
        const BackgroundColorType& GetBackgroundColor() const { return m_BackgroundColor; }
        //! [DataBinding_BackgroundColorPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(RichTextHighlightWidget2DBase, ::BaseWidget2D)
            CdaDescription("Provides highlight support for rich text. See Widget User Guide for details on how to use this widget.")
            CdaReadableName("RichTextHighlightWidget2DBase")
            CdaCategory("RichText")

            CdaProperties()
                CdaProperty(HighlightMode, HighlightModeType, GetHighlightMode, SetHighlightMode)
                    CdaDescription("Defines how to interpret string property HighlightText.\n\n- Mask\nAll occurrences of the string defined in property 'Highlight Text' are highlighted.\n\n- Range\nDefines character index ranges to be highlighted.\n\nExample to highlight characters at index 3, 7, 8, 9 and 15: '3,7-9,15'")
                CdaPropertyEnd()
                CdaBindableProperty(HighlightText, HighlightTextType, GetHighlightText, SetHighlightText)
                    CdaDescription("The criteria to highlight Text. See property 'Highlight Mode'.")
                CdaBindablePropertyEnd()
                CdaProperty(AllOccurrences, AllOccurrencesType, GetAllOccurrences, SetAllOccurrences)
                    CdaDescription("If set to true, all occurrences of the string defined in property 'Highlight Text' are highlighted. False highlights only the first occurrence.")
                    CdaVisibilityTest(IsMaskMode)
                CdaPropertyEnd()
                CdaProperty(CaseSensitive, CaseSensitiveType, GetCaseSensitive, SetCaseSensitive)
                    CdaDescription("If set to true, property 'Highlight Text' is case sensitive. False searches case insensitive.")
                    CdaVisibilityTest(IsMaskMode)
                CdaPropertyEnd()
                CdaProperty(TextColorEnabled, TextColorEnabledType, GetTextColorEnabled, SetTextColorEnabled)
                    CdaDescription("If this property is set to true, the color for the highlighted text can be defined with property 'Text Color'.")
                CdaPropertyEnd()
                CdaBindableProperty(TextColor, TextColorType, GetTextColor, SetTextColor)
                    CdaDescription("The color to be set on the highlighted text.")
                    CdaVisibilityTest(GetTextColorEnabled)
                CdaBindablePropertyEnd()
                CdaProperty(BackgroundColorEnabled, BackgroundColorEnabledType, GetBackgroundColorEnabled, SetBackgroundColorEnabled)
                    CdaDescription("If this property is set to true, the color for the highlighted background can be defined property 'Background Color'.")
                CdaPropertyEnd()
                CdaBindableProperty(BackgroundColor, BackgroundColorType, GetBackgroundColor, SetBackgroundColor)
                    CdaDescription("The background color to be set on the highlighted text.")
                    CdaVisibilityTest(GetBackgroundColorEnabled)
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        bool IsMaskMode() const { return GetHighlightMode() == Highlighter::Mask; }
        HighlightModeType m_HighlightMode;
        HighlightTextType m_HighlightText;
        AllOccurrencesType m_AllOccurrences;
        CaseSensitiveType m_CaseSensitive;
        TextColorEnabledType m_TextColorEnabled;
        TextColorType m_TextColor;
        BackgroundColorEnabledType m_BackgroundColorEnabled;
        BackgroundColorType m_BackgroundColor;
};
} // namespace richtext
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_richtext_RichTextHighlightWidget2DBase_h
