/************************************************************************
*FILE: ProgressBarWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ProgressBarWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ProgressBarWidget2DBase)

ProgressBarWidget2DBase::ProgressBarWidget2DBase() :
    m_ProgressFillType(ProgressFillTypeType()),
    m_ProgressFillNode(ProgressFillNodeType()),
    m_ProgressBufferNode(ProgressBufferNodeType()),
    m_MaskNode(MaskNodeType()),
    m_BufferMaskNode(BufferMaskNodeType()),
    m_ProgressBarOrientationType(ProgressBarOrientationTypeType()),
    m_TotalValue(100.0f),
    m_CurrentValue(CurrentValueType()),
    m_BufferValue(BufferValueType()),
    m_TimerValue(TimerValueType()),
    m_TimerStepCount(1),
    m_StartTimer(StartTimerType()),
    m_RestartTimer(false)
{
}

ProgressBarWidget2DBase::~ProgressBarWidget2DBase()
{
}

void ProgressBarWidget2DBase::SetProgressFillType(const ProgressFillTypeType& progressfilltype)
{
    m_ProgressFillType = progressfilltype;
    OnChanged(static_cast< ::FeatStd::UInt32>(ProgressFillTypePropertyId));
}

void ProgressBarWidget2DBase::SetProgressFillNode(const ProgressFillNodeType& progressfillnode)
{
    m_ProgressFillNode = progressfillnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(ProgressFillNodePropertyId));
}

void ProgressBarWidget2DBase::SetProgressBufferNode(const ProgressBufferNodeType& progressbuffernode)
{
    m_ProgressBufferNode = progressbuffernode;
    OnChanged(static_cast< ::FeatStd::UInt32>(ProgressBufferNodePropertyId));
}

void ProgressBarWidget2DBase::SetMaskNode(const MaskNodeType& masknode)
{
    m_MaskNode = masknode;
    OnChanged(static_cast< ::FeatStd::UInt32>(MaskNodePropertyId));
}

void ProgressBarWidget2DBase::SetBufferMaskNode(const BufferMaskNodeType& buffermasknode)
{
    m_BufferMaskNode = buffermasknode;
    OnChanged(static_cast< ::FeatStd::UInt32>(BufferMaskNodePropertyId));
}

void ProgressBarWidget2DBase::SetProgressBarOrientationType(const ProgressBarOrientationTypeType& progressbarorientationtype)
{
    m_ProgressBarOrientationType = progressbarorientationtype;
    OnChanged(static_cast< ::FeatStd::UInt32>(ProgressBarOrientationTypePropertyId));
}

void ProgressBarWidget2DBase::SetTotalValue(const TotalValueType& totalvalue)
{
    m_TotalValue = totalvalue;
    OnChanged(static_cast< ::FeatStd::UInt32>(TotalValuePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("TotalValue");
    }
}

void ProgressBarWidget2DBase::SetCurrentValue(const CurrentValueType& currentvalue)
{
    if (m_CurrentValue != currentvalue) {
        m_CurrentValue = currentvalue;
        OnChanged(static_cast< ::FeatStd::UInt32>(CurrentValuePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("CurrentValue");
        }
    }
}

void ProgressBarWidget2DBase::SetBufferValue(const BufferValueType& buffervalue)
{
    if (m_BufferValue != buffervalue) {
        m_BufferValue = buffervalue;
        OnChanged(static_cast< ::FeatStd::UInt32>(BufferValuePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BufferValue");
        }
    }
}

void ProgressBarWidget2DBase::SetTimerValue(const TimerValueType& timervalue)
{
    m_TimerValue = timervalue;
}

void ProgressBarWidget2DBase::SetTimerStepCount(const TimerStepCountType& timerstepcount)
{
    m_TimerStepCount = timerstepcount;
}

void ProgressBarWidget2DBase::SetStartTimer(const StartTimerType& starttimer)
{
    m_StartTimer = starttimer;
    OnChanged(static_cast< ::FeatStd::UInt32>(StartTimerPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("StartTimer");
    }
}

void ProgressBarWidget2DBase::SetRestartTimer(const RestartTimerType& restarttimer)
{
    m_RestartTimer = restarttimer;
    OnChanged(static_cast< ::FeatStd::UInt32>(RestartTimerPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("RestartTimer");
    }
}
