/************************************************************************
*FILE: PageEditWidget2DMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_pageedit_PageEditWidget2DMessages_h)
#define hmibase_widget_pageedit_PageEditWidget2DMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Widgets/generated/BaseWidgetMessages.h>
#include <Widgets/2D/PageEdit/generated/PageEditWidget2DTypes.h>
#include <Courier/Util/Vector.h>

namespace hmibase {
namespace widget {
namespace pageedit {
typedef ::Candera::UInt32 AlbumIdType;
typedef ::std::string PageIdType;
typedef ::std::string ItemIdType;

struct PageEditItem
{
    // item (gizmo) name
    ItemIdType Id;

    // name of an external item which must replace this item (can happen if an item is dragged from one page to another)
    ItemIdType ExternalId;

    // specifies the top left cell and the cell span. Hidden items have cell span [0,0].
    ::Candera::Rectangle Cells;
};

struct PageEditPage
{
    // page name
    PageIdType Id;

    // items (gizmos) contained into this page (some may be hidden and have cell span [0,0])
    ::Courier::Vector<PageEditItem> Items;
};

struct PageEditData
{
    CANDERA_SHARED_POINTER_DECLARATION();
    FEATSTD_TYPEDEF_SHARED_POINTER(PageEditData);

    // identifies the album
    AlbumIdType AlbumId;

    // data for all the pages
    ::Courier::Vector<PageEditPage> Pages;

    // item from which drag started
    ItemIdType SourceItemId;
    PageIdType SourcePageId;

    // item where drag was ended
    ItemIdType DestinationItemId;
    PageIdType DestinationPageId;
};
// ------------------------------------------------------------------------
class PageEditUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PageEditUpdMsg, ::Courier::Message, 0xCE84AD0C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        PageEditUpdMsg(AlbumIdType const & aAlbumId, PageEditData::SharedPointer const & aData, enEditStatus::Enum const & aStatus);
        virtual ~PageEditUpdMsg();

        AlbumIdType const & GetAlbumId() const { return mAlbumId; }
        void SetAlbumId(AlbumIdType const & value) { mAlbumId = value; }
        PageEditData::SharedPointer const & GetData() const { return mData; }
        void SetData(PageEditData::SharedPointer const & value) { mData = value; }
        enEditStatus::Enum const & GetStatus() const { return mStatus; }
        void SetStatus(enEditStatus::Enum const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(PageEditUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPageEditUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPageEditUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mPageEditUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        AlbumIdType mAlbumId;
        PageEditData::SharedPointer mData;
        enEditStatus::Enum mStatus;
};
} // namespace pageedit
} // namespace widget
} // namespace hmibase
namespace hmibase {
} // namespace hmibase

#endif // hmibase_widget_pageedit_PageEditWidget2DMessages_h
