/************************************************************************
*FILE: OPSWidgetBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "OPSWidgetBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(OPSWidgetBase)

OPSWidgetBase::OPSWidgetBase() :
    m_OPSMini(OPSMiniType()),
    m_OPSWidgetType(OPSWidgetTypeType()),
    m_OPSDisplayMode(OPSDisplayModeType()),
    m_TrailerConnected(TrailerConnectedType()),
    m_VehicleType(VehicleTypeType()),
    m_SensorsAvailable(SensorsAvailableType()),
    m_SensorsSegmentValues(SensorsSegmentValuesType()),
    m_SegmentPreDefinedDistanceValues(SegmentPreDefinedDistanceValuesType()),
    m_StatusValues(StatusValuesType()),
    m_SensorFieldBlinking(SensorFieldBlinkingType()),
    m_BlinkInterval(BlinkIntervalType()),
    m_SensorFieldHatched(SensorFieldHatchedType()),
    m_SensorFieldScanned(SensorFieldScannedType()),
    m_LeftRTAStatuslevel(LeftRTAStatuslevelType()),
    m_RightRTAStatuslevel(RightRTAStatuslevelType()),
    m_LeftRTADistanceValue(LeftRTADistanceValueType()),
    m_RightRTADistanceValue(RightRTADistanceValueType())
{
}

OPSWidgetBase::~OPSWidgetBase()
{
}

void OPSWidgetBase::SetOPSMini(const OPSMiniType& opsmini)
{
    if (m_OPSMini != opsmini) {
        m_OPSMini = opsmini;
    }
}

void OPSWidgetBase::SetOPSWidgetType(const OPSWidgetTypeType& opswidgettype)
{
    if (m_OPSWidgetType != opswidgettype) {
        m_OPSWidgetType = opswidgettype;
        OnChanged(static_cast< ::FeatStd::UInt32>(OPSWidgetTypePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("OPSWidgetType");
        }
    }
}

void OPSWidgetBase::SetOPSDisplayMode(const OPSDisplayModeType& opsdisplaymode)
{
    if (m_OPSDisplayMode != opsdisplaymode) {
        m_OPSDisplayMode = opsdisplaymode;
        OnChanged(static_cast< ::FeatStd::UInt32>(OPSDisplayModePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("OPSDisplayMode");
        }
    }
}

void OPSWidgetBase::SetTrailerConnected(const TrailerConnectedType& trailerconnected)
{
    if (m_TrailerConnected != trailerconnected) {
        m_TrailerConnected = trailerconnected;
        OnChanged(static_cast< ::FeatStd::UInt32>(TrailerConnectedPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("TrailerConnected");
        }
    }
}

void OPSWidgetBase::SetVehicleType(const VehicleTypeType& vehicletype)
{
    if (m_VehicleType != vehicletype) {
        m_VehicleType = vehicletype;
        OnChanged(static_cast< ::FeatStd::UInt32>(VehicleTypePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("VehicleType");
        }
    }
}

void OPSWidgetBase::SetSensorsAvailable(const SensorsAvailableType& sensorsavailable)
{
    m_SensorsAvailable = sensorsavailable;
    OnChanged(static_cast< ::FeatStd::UInt32>(SensorsAvailablePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SensorsAvailable");
    }
}

void OPSWidgetBase::SetSensorsSegmentValues(const SensorsSegmentValuesType& sensorssegmentvalues)
{
    m_SensorsSegmentValues = sensorssegmentvalues;
    OnChanged(static_cast< ::FeatStd::UInt32>(SensorsSegmentValuesPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SensorsSegmentValues");
    }
}

void OPSWidgetBase::SetSegmentPreDefinedDistanceValues(const SegmentPreDefinedDistanceValuesType& segmentpredefineddistancevalues)
{
    m_SegmentPreDefinedDistanceValues = segmentpredefineddistancevalues;
    OnChanged(static_cast< ::FeatStd::UInt32>(SegmentPreDefinedDistanceValuesPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SegmentPreDefinedDistanceValues");
    }
}

void OPSWidgetBase::SetStatusValues(const StatusValuesType& statusvalues)
{
    m_StatusValues = statusvalues;
    OnChanged(static_cast< ::FeatStd::UInt32>(StatusValuesPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("StatusValues");
    }
}

void OPSWidgetBase::SetSensorFieldBlinking(const SensorFieldBlinkingType& sensorfieldblinking)
{
    m_SensorFieldBlinking = sensorfieldblinking;
    OnChanged(static_cast< ::FeatStd::UInt32>(SensorFieldBlinkingPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SensorFieldBlinking");
    }
}

void OPSWidgetBase::SetBlinkInterval(const BlinkIntervalType& blinkinterval)
{
    m_BlinkInterval = blinkinterval;
    OnChanged(static_cast< ::FeatStd::UInt32>(BlinkIntervalPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("BlinkInterval");
    }
}

void OPSWidgetBase::SetSensorFieldHatched(const SensorFieldHatchedType& sensorfieldhatched)
{
    m_SensorFieldHatched = sensorfieldhatched;
    OnChanged(static_cast< ::FeatStd::UInt32>(SensorFieldHatchedPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SensorFieldHatched");
    }
}

void OPSWidgetBase::SetSensorFieldScanned(const SensorFieldScannedType& sensorfieldscanned)
{
    m_SensorFieldScanned = sensorfieldscanned;
    OnChanged(static_cast< ::FeatStd::UInt32>(SensorFieldScannedPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SensorFieldScanned");
    }
}

void OPSWidgetBase::SetLeftRTAStatuslevel(const LeftRTAStatuslevelType& leftrtastatuslevel)
{
    m_LeftRTAStatuslevel = leftrtastatuslevel;
    OnChanged(static_cast< ::FeatStd::UInt32>(LeftRTAStatuslevelPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LeftRTAStatuslevel");
    }
}

void OPSWidgetBase::SetRightRTAStatuslevel(const RightRTAStatuslevelType& rightrtastatuslevel)
{
    m_RightRTAStatuslevel = rightrtastatuslevel;
    OnChanged(static_cast< ::FeatStd::UInt32>(RightRTAStatuslevelPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("RightRTAStatuslevel");
    }
}

void OPSWidgetBase::SetLeftRTADistanceValue(const LeftRTADistanceValueType& leftrtadistancevalue)
{
    m_LeftRTADistanceValue = leftrtadistancevalue;
    OnChanged(static_cast< ::FeatStd::UInt32>(LeftRTADistanceValuePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LeftRTADistanceValue");
    }
}

void OPSWidgetBase::SetRightRTADistanceValue(const RightRTADistanceValueType& rightrtadistancevalue)
{
    m_RightRTADistanceValue = rightrtadistancevalue;
    OnChanged(static_cast< ::FeatStd::UInt32>(RightRTADistanceValuePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("RightRTADistanceValue");
    }
}
