/************************************************************************
*FILE: MultiSliderWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(MultiSliderWidget2DBase_h)
#define MultiSliderWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Touchable2D.h>
// ------------------------------------------------------------------------
//! [MultiSliderWidget2DBase_Declaration]
class MultiSliderWidget2DBase : public ::Touchable2D
{
    public:
        typedef FeatStd::Float RadiusMinType;

        typedef FeatStd::Float RadiusMaxType;

        typedef FeatStd::Float RadiusCenterType;

        typedef FeatStd::Float StartAngleType;

        typedef Candera::Node2D* HandleNodeType;

        typedef Candera::WidgetBase* MultiSliderViewType;

        typedef Candera::ArrayProperty<Candera::Float> ValuesType;

        //! [Property_IDs]
        static const FeatStd::UInt32 HandleNodePropertyId = 0xAD6B7B63;
        static const FeatStd::UInt32 MultiSliderViewPropertyId = 0x8F1300C9;
        static const FeatStd::UInt32 ValuesPropertyId = 0x24B9AD8A;
        //! [Property_IDs]

        MultiSliderWidget2DBase();
        virtual ~MultiSliderWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(MultiSliderWidget2DBase, ::Touchable2D);

        void SetRadiusMin(const RadiusMinType& radiusmin);
        const RadiusMinType& GetRadiusMin() const { return m_RadiusMin; }
        RadiusMinType& GetRadiusMin() { return m_RadiusMin; }

        void SetRadiusMax(const RadiusMaxType& radiusmax);
        const RadiusMaxType& GetRadiusMax() const { return m_RadiusMax; }
        RadiusMaxType& GetRadiusMax() { return m_RadiusMax; }

        void SetRadiusCenter(const RadiusCenterType& radiuscenter);
        const RadiusCenterType& GetRadiusCenter() const { return m_RadiusCenter; }
        RadiusCenterType& GetRadiusCenter() { return m_RadiusCenter; }

        void SetStartAngle(const StartAngleType& startangle);
        const StartAngleType& GetStartAngle() const { return m_StartAngle; }
        StartAngleType& GetStartAngle() { return m_StartAngle; }

        void SetHandleNode(const HandleNodeType& handlenode);
        const HandleNodeType& GetHandleNode() const { return m_HandleNode; }
        HandleNodeType& GetHandleNode() { return m_HandleNode; }

        void SetMultiSliderView(const MultiSliderViewType& multisliderview);
        const MultiSliderViewType& GetMultiSliderView() const { return m_MultiSliderView; }
        MultiSliderViewType& GetMultiSliderView() { return m_MultiSliderView; }

        //! [DataBinding_ValuesPropertyGetterSetter]
        void SetValues(const ValuesType& values);
        const ValuesType& GetValues() const { return m_Values; }
        ValuesType& GetValues() { return m_Values; }
        //! [DataBinding_ValuesPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(MultiSliderWidget2DBase, ::Touchable2D)
            CdaDescription("Widget to change the importance of a property and visualize the same in the meanding of a unique profile representation.")
            CdaReadableName("MultiSliderWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(RadiusMin, RadiusMinType, GetRadiusMin, SetRadiusMin)
                    CdaDescription("Radius for minimum values in pixel")
                CdaPropertyEnd()
                CdaProperty(RadiusMax, RadiusMaxType, GetRadiusMax, SetRadiusMax)
                    CdaDescription("Radius for maximum values in pixel")
                CdaPropertyEnd()
                CdaProperty(RadiusCenter, RadiusCenterType, GetRadiusCenter, SetRadiusCenter)
                    CdaDescription("Radius for center button (sets all values to minimum)")
                CdaPropertyEnd()
                CdaProperty(StartAngle, StartAngleType, GetStartAngle, SetStartAngle)
                    CdaDescription("Defines the angle in degrees of the first value. 0° is 12 o'clock position.")
                CdaPropertyEnd()
                CdaProperty(HandleNode, HandleNodeType, GetHandleNode, SetHandleNode)
                    CdaDescription("Pointer to the node that represents a slider handle. This node must not be a child node of the widget associated node and rendering of that should be disabled.")
                CdaPropertyEnd()
                CdaProperty(MultiSliderView, MultiSliderViewType, GetMultiSliderView, SetMultiSliderView)
                    CdaDescription("The multi slider view widget for graphical representation.")
                CdaPropertyEnd()
                CdaBindableProperty(Values, ValuesType, GetValues, SetValues)
                    CdaDescription("Array of float values to be controlled by the widget. The number of values also defines the number of billboard to be shown by MultiSliderHelperWidget3D.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        RadiusMinType m_RadiusMin;
        RadiusMaxType m_RadiusMax;
        RadiusCenterType m_RadiusCenter;
        StartAngleType m_StartAngle;
        HandleNodeType m_HandleNode;
        MultiSliderViewType m_MultiSliderView;
        ValuesType m_Values;
};

#endif // MultiSliderWidget2DBase_h
