/************************************************************************
*FILE: MeshWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_mesh_MeshWidget2DBase_h)
#define hmibase_widget_mesh_MeshWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/Mesh/generated/MeshWidget2DTypes.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace mesh {
// ------------------------------------------------------------------------
//! [MeshWidget2DBase_Declaration]
class MeshWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef FeatStd::Float RotationType;

        typedef FeatStd::Float CameraDistanceType;

        typedef FeatStd::Float FitToMaximumSizeRotationType;

        typedef Candera::Vector3 RotationAxisType;

        typedef FeatStd::Float FieldOfViewType;

        typedef Mesh2DFitStrategy::Enum FitStrategyType;

        typedef HorizontalOrigin::Enum HorizontalOriginType;

        typedef VerticalOrigin::Enum VerticalOriginType;

        typedef FeatStd::Float CustomHorizontalOriginType;

        typedef FeatStd::Float CustomVerticalOriginType;

        typedef Candera::Vector2 OriginOffsetType;

        //! [Property_IDs]
        static const FeatStd::UInt32 RotationPropertyId = 0x8D559FAF;
        static const FeatStd::UInt32 CameraDistancePropertyId = 0x4B47C2B5;
        static const FeatStd::UInt32 FitToMaximumSizeRotationPropertyId = 0xA10B5D5E;
        static const FeatStd::UInt32 RotationAxisPropertyId = 0xCE6BFE86;
        static const FeatStd::UInt32 FieldOfViewPropertyId = 0x388CBD70;
        static const FeatStd::UInt32 FitStrategyPropertyId = 0x13CC253E;
        static const FeatStd::UInt32 HorizontalOriginPropertyId = 0x7D0CC8CC;
        static const FeatStd::UInt32 VerticalOriginPropertyId = 0x5262E6B0;
        static const FeatStd::UInt32 CustomHorizontalOriginPropertyId = 0xB9E0A483;
        static const FeatStd::UInt32 CustomVerticalOriginPropertyId = 0x34B4B496;
        static const FeatStd::UInt32 OriginOffsetPropertyId = 0x8206D0B6;
        //! [Property_IDs]

        MeshWidget2DBase();
        virtual ~MeshWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(MeshWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_RotationPropertyGetterSetter]
        void SetRotation(const RotationType& rotation);
        const RotationType& GetRotation() const { return m_Rotation; }
        RotationType& GetRotation() { return m_Rotation; }
        //! [DataBinding_RotationPropertyGetterSetter]

        //! [DataBinding_CameraDistancePropertyGetterSetter]
        void SetCameraDistance(const CameraDistanceType& cameradistance);
        const CameraDistanceType& GetCameraDistance() const { return m_CameraDistance; }
        CameraDistanceType& GetCameraDistance() { return m_CameraDistance; }
        //! [DataBinding_CameraDistancePropertyGetterSetter]

        void SetFitToMaximumSizeRotation(const FitToMaximumSizeRotationType& fittomaximumsizerotation);
        const FitToMaximumSizeRotationType& GetFitToMaximumSizeRotation() const { return m_FitToMaximumSizeRotation; }
        FitToMaximumSizeRotationType& GetFitToMaximumSizeRotation() { return m_FitToMaximumSizeRotation; }

        void SetRotationAxis(const RotationAxisType& rotationaxis);
        const RotationAxisType& GetRotationAxis() const { return m_RotationAxis; }
        RotationAxisType& GetRotationAxis() { return m_RotationAxis; }

        void SetFieldOfView(const FieldOfViewType& fieldofview);
        const FieldOfViewType& GetFieldOfView() const { return m_FieldOfView; }
        FieldOfViewType& GetFieldOfView() { return m_FieldOfView; }

        void SetFitStrategy(const FitStrategyType& fitstrategy);
        const FitStrategyType& GetFitStrategy() const { return m_FitStrategy; }
        FitStrategyType& GetFitStrategy() { return m_FitStrategy; }

        void SetHorizontalOrigin(const HorizontalOriginType& horizontalorigin);
        const HorizontalOriginType& GetHorizontalOrigin() const { return m_HorizontalOrigin; }
        HorizontalOriginType& GetHorizontalOrigin() { return m_HorizontalOrigin; }

        void SetVerticalOrigin(const VerticalOriginType& verticalorigin);
        const VerticalOriginType& GetVerticalOrigin() const { return m_VerticalOrigin; }
        VerticalOriginType& GetVerticalOrigin() { return m_VerticalOrigin; }

        void SetCustomHorizontalOrigin(const CustomHorizontalOriginType& customhorizontalorigin);
        const CustomHorizontalOriginType& GetCustomHorizontalOrigin() const { return m_CustomHorizontalOrigin; }
        CustomHorizontalOriginType& GetCustomHorizontalOrigin() { return m_CustomHorizontalOrigin; }

        void SetCustomVerticalOrigin(const CustomVerticalOriginType& customverticalorigin);
        const CustomVerticalOriginType& GetCustomVerticalOrigin() const { return m_CustomVerticalOrigin; }
        CustomVerticalOriginType& GetCustomVerticalOrigin() { return m_CustomVerticalOrigin; }

        void SetOriginOffset(const OriginOffsetType& originoffset);
        const OriginOffsetType& GetOriginOffset() const { return m_OriginOffset; }
        OriginOffsetType& GetOriginOffset() { return m_OriginOffset; }

        // @WidgetBaseClass
        CdaWidget2DDef(MeshWidget2DBase, ::BaseWidget2D)
            CdaDescription("Performs a perspective projection of a 3D rotated effect (e.g. Bitmap or SolidColor effects) based on the configured origin, rotation and field of view.")
            CdaReadableName("2D Mesh")
            CdaCategory("Common")

            CdaProperties()
                CdaBindableProperty(Rotation, RotationType, GetRotation, SetRotation)
                    CdaDescription("Defines the rotation angle in degree around configured rotation axis at the configured origin.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CameraDistance, CameraDistanceType, GetCameraDistance, SetCameraDistance)
                    CdaDescription("Defines a normalized camera distance (the projection is based on a normalized geometry of widht and height 1) with a default value of 1. ")
                CdaBindablePropertyEnd()
                CdaProperty(FitToMaximumSizeRotation, FitToMaximumSizeRotationType, GetFitToMaximumSizeRotation, SetFitToMaximumSizeRotation)
                    CdaDescription("Defines the rotation angle in degree that will be uses as maximum for the FitToMaximumSize fit strategy. Default is an angle of 90 degree.")
                    CdaVisibilityTest(IsFitToMaximumSizeStrategy)
                CdaPropertyEnd()
                CdaProperty(RotationAxis, RotationAxisType, GetRotationAxis, SetRotationAxis)
                    CdaDescription("Defines the axis (default is the y axis) for the rotation as a 3D direction vector (the vector will be internally normalized).")
                CdaPropertyEnd()
                CdaProperty(FieldOfView, FieldOfViewType, GetFieldOfView, SetFieldOfView)
                    CdaDescription("The area on the Y axis view field in degrees. It influences the perspective distortion of the projection. Higher angles will result in more distorted projection. Lower angles will result in less perspective distorted projections. The angle has to be higher than 0 and less than 180.")
                CdaPropertyEnd()
                CdaProperty(FitStrategy, FitStrategyType, GetFitStrategy, SetFitStrategy)
                    CdaDescription("Defines how the perspective projected mesh should fit into the original boundaries.")
                CdaPropertyEnd()
                CdaProperty(HorizontalOrigin, HorizontalOriginType, GetHorizontalOrigin, SetHorizontalOrigin)
                    CdaDescription("The origin influences where the rotation is performed and how the perspective projection looks. It is defined as a normalized (bitmap resolution independent) origin on the y axis as Left (0), Center (0.5), Right (1.0) or Custom (see CustomHorizontalOrigin).")
                CdaPropertyEnd()
                CdaProperty(VerticalOrigin, VerticalOriginType, GetVerticalOrigin, SetVerticalOrigin)
                    CdaDescription("The origin influences where the rotation is performed and how the perspective projection looks. It is defined as a  normalized (bitmap resolution independent) origin on the y axis as Top (0), Center (0.5), Bottom (1.0) or Custom (see CustomVerticalOrigin).")
                CdaPropertyEnd()
                CdaProperty(CustomHorizontalOrigin, CustomHorizontalOriginType, GetCustomHorizontalOrigin, SetCustomHorizontalOrigin)
                    CdaDescription("Defines a normalized (bitmap resolution independent) custom origin that can not be defined with Left, Center or Right.")
                    CdaVisibilityTest(IsCustomHorizontalOrigin)
                CdaPropertyEnd()
                CdaProperty(CustomVerticalOrigin, CustomVerticalOriginType, GetCustomVerticalOrigin, SetCustomVerticalOrigin)
                    CdaDescription("Defines a normalized (bitmap resolution independent) custom origin that can not be defined with Top, Center or Bottom.")
                    CdaVisibilityTest(IsCustomVerticalOrigin)
                CdaPropertyEnd()
                CdaProperty(OriginOffset, OriginOffsetType, GetOriginOffset, SetOriginOffset)
                    CdaDescription("In addition to the configured normalized origin this pixel based origin offset is added.")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
#ifdef CANDERA_META_DESCRIPTION
        bool IsCustomHorizontalOrigin() const
        {
            return GetHorizontalOrigin() == HorizontalOrigin::Custom;
        }
        bool IsCustomVerticalOrigin() const
        {
            return GetVerticalOrigin() == VerticalOrigin::Custom;
        }
        bool IsFitToMaximumSizeStrategy() const
        {
            return GetFitStrategy() == Mesh2DFitStrategy::FitToMaximumSize;
        }
#endif
        RotationType m_Rotation;
        CameraDistanceType m_CameraDistance;
        FitToMaximumSizeRotationType m_FitToMaximumSizeRotation;
        RotationAxisType m_RotationAxis;
        FieldOfViewType m_FieldOfView;
        FitStrategyType m_FitStrategy;
        HorizontalOriginType m_HorizontalOrigin;
        VerticalOriginType m_VerticalOrigin;
        CustomHorizontalOriginType m_CustomHorizontalOrigin;
        CustomVerticalOriginType m_CustomVerticalOrigin;
        OriginOffsetType m_OriginOffset;
};
} // namespace mesh
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_mesh_MeshWidget2DBase_h
