/************************************************************************
*FILE: MeshWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "MeshWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace mesh {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(MeshWidget2DBase)

MeshWidget2DBase::MeshWidget2DBase() :
    m_Rotation(0.0F),
    m_CameraDistance(1.0F),
    m_FitToMaximumSizeRotation(90.0F),
    m_RotationAxis(Candera::Vector3(0.0F, 1.0F, 0.0F)),
    m_FieldOfView(65.0F),
    m_FitStrategy(Mesh2DFitStrategy::FitToActualSize),
    m_HorizontalOrigin(HorizontalOrigin::Center),
    m_VerticalOrigin(VerticalOrigin::Center),
    m_CustomHorizontalOrigin(0.5F),
    m_CustomVerticalOrigin(0.5F),
    m_OriginOffset(Candera::Vector2(0.0F, 0.0F))
{
}

MeshWidget2DBase::~MeshWidget2DBase()
{
}

void MeshWidget2DBase::SetRotation(const RotationType& rotation)
{
    if (m_Rotation != rotation) {
        m_Rotation = rotation;
        OnChanged(static_cast< ::FeatStd::UInt32>(RotationPropertyId));
    }
}

void MeshWidget2DBase::SetCameraDistance(const CameraDistanceType& cameradistance)
{
    if (m_CameraDistance != cameradistance) {
        m_CameraDistance = cameradistance;
        OnChanged(static_cast< ::FeatStd::UInt32>(CameraDistancePropertyId));
    }
}

void MeshWidget2DBase::SetFitToMaximumSizeRotation(const FitToMaximumSizeRotationType& fittomaximumsizerotation)
{
    if (m_FitToMaximumSizeRotation != fittomaximumsizerotation) {
        m_FitToMaximumSizeRotation = fittomaximumsizerotation;
        OnChanged(static_cast< ::FeatStd::UInt32>(FitToMaximumSizeRotationPropertyId));
    }
}

void MeshWidget2DBase::SetRotationAxis(const RotationAxisType& rotationaxis)
{
    if (m_RotationAxis != rotationaxis) {
        m_RotationAxis = rotationaxis;
        OnChanged(static_cast< ::FeatStd::UInt32>(RotationAxisPropertyId));
    }
}

void MeshWidget2DBase::SetFieldOfView(const FieldOfViewType& fieldofview)
{
    if (m_FieldOfView != fieldofview) {
        m_FieldOfView = fieldofview;
        OnChanged(static_cast< ::FeatStd::UInt32>(FieldOfViewPropertyId));
    }
}

void MeshWidget2DBase::SetFitStrategy(const FitStrategyType& fitstrategy)
{
    if (m_FitStrategy != fitstrategy) {
        m_FitStrategy = fitstrategy;
        OnChanged(static_cast< ::FeatStd::UInt32>(FitStrategyPropertyId));
    }
}

void MeshWidget2DBase::SetHorizontalOrigin(const HorizontalOriginType& horizontalorigin)
{
    if (m_HorizontalOrigin != horizontalorigin) {
        m_HorizontalOrigin = horizontalorigin;
        OnChanged(static_cast< ::FeatStd::UInt32>(HorizontalOriginPropertyId));
    }
}

void MeshWidget2DBase::SetVerticalOrigin(const VerticalOriginType& verticalorigin)
{
    if (m_VerticalOrigin != verticalorigin) {
        m_VerticalOrigin = verticalorigin;
        OnChanged(static_cast< ::FeatStd::UInt32>(VerticalOriginPropertyId));
    }
}

void MeshWidget2DBase::SetCustomHorizontalOrigin(const CustomHorizontalOriginType& customhorizontalorigin)
{
    if (m_CustomHorizontalOrigin != customhorizontalorigin) {
        m_CustomHorizontalOrigin = customhorizontalorigin;
        OnChanged(static_cast< ::FeatStd::UInt32>(CustomHorizontalOriginPropertyId));
    }
}

void MeshWidget2DBase::SetCustomVerticalOrigin(const CustomVerticalOriginType& customverticalorigin)
{
    if (m_CustomVerticalOrigin != customverticalorigin) {
        m_CustomVerticalOrigin = customverticalorigin;
        OnChanged(static_cast< ::FeatStd::UInt32>(CustomVerticalOriginPropertyId));
    }
}

void MeshWidget2DBase::SetOriginOffset(const OriginOffsetType& originoffset)
{
    if (m_OriginOffset != originoffset) {
        m_OriginOffset = originoffset;
        OnChanged(static_cast< ::FeatStd::UInt32>(OriginOffsetPropertyId));
    }
}
} // namespace mesh
} // namespace widget
} // namespace hmibase
