/************************************************************************
*FILE: ListOverscrollWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ListOverscrollWidget2DBase_h)
#define ListOverscrollWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/List/generated/ListEnums.h>
// ------------------------------------------------------------------------
//! [ListOverscrollWidget2DBase_Declaration]
class ListOverscrollWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef bool OnDragType;

        typedef bool OnSwipeType;

        typedef FeatStd::Float AttenuationFactorType;

        typedef FeatStd::Float MaxRelaxingSpeedType;

        //! [Property_IDs]
        static const FeatStd::UInt32 OnDragPropertyId = 0x88B0F04A;
        static const FeatStd::UInt32 OnSwipePropertyId = 0xACE3B73A;
        static const FeatStd::UInt32 AttenuationFactorPropertyId = 0x9E527E78;
        static const FeatStd::UInt32 MaxRelaxingSpeedPropertyId = 0xBCD94B75;
        //! [Property_IDs]

        ListOverscrollWidget2DBase();
        virtual ~ListOverscrollWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ListOverscrollWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_OnDragPropertyGetterSetter]
        void SetOnDrag(const OnDragType& ondrag);
        const OnDragType& GetOnDrag() const { return m_OnDrag; }
        //! [DataBinding_OnDragPropertyGetterSetter]

        //! [DataBinding_OnSwipePropertyGetterSetter]
        void SetOnSwipe(const OnSwipeType& onswipe);
        const OnSwipeType& GetOnSwipe() const { return m_OnSwipe; }
        //! [DataBinding_OnSwipePropertyGetterSetter]

        //! [DataBinding_AttenuationFactorPropertyGetterSetter]
        void SetAttenuationFactor(const AttenuationFactorType& attenuationfactor);
        const AttenuationFactorType& GetAttenuationFactor() const { return m_AttenuationFactor; }
        //! [DataBinding_AttenuationFactorPropertyGetterSetter]

        //! [DataBinding_MaxRelaxingSpeedPropertyGetterSetter]
        void SetMaxRelaxingSpeed(const MaxRelaxingSpeedType& maxrelaxingspeed);
        const MaxRelaxingSpeedType& GetMaxRelaxingSpeed() const { return m_MaxRelaxingSpeed; }
        //! [DataBinding_MaxRelaxingSpeedPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ListOverscrollWidget2DBase, ::BaseWidget2D)
            CdaDescription("ListOverscrollWidget2D widget")
            CdaReadableName("ListOverscrollWidget2DBase")
            CdaCategory("List")

            CdaProperties()
                CdaBindableProperty(OnDrag, OnDragType, GetOnDrag, SetOnDrag)
                    CdaDescription("Enables or disables overscroll for drag")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OnSwipe, OnSwipeType, GetOnSwipe, SetOnSwipe)
                    CdaDescription("Enables or disables overscroll for swipe")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AttenuationFactor, AttenuationFactorType, GetAttenuationFactor, SetAttenuationFactor)
                    CdaDescription("Valid values are between 0.0 and 1.0. If the value is 0.0f then there is no resistance, the list will follow the finger pixel by pixel. If the value is 1.0f then the drag will be fully attenuated, the list will not move at all.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(MaxRelaxingSpeed, MaxRelaxingSpeedType, GetMaxRelaxingSpeed, SetMaxRelaxingSpeed)
                    CdaDescription("Represents the initial speed for the relaxing movement if the overscroll distance would be equal to the viewport size. The speed is expressed in viewport ratio / seconds; for example, a speed equal to 0.5 means half of the viewport would be relaxed in one second.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        OnDragType m_OnDrag;
        OnSwipeType m_OnSwipe;
        AttenuationFactorType m_AttenuationFactor;
        MaxRelaxingSpeedType m_MaxRelaxingSpeed;
};

#endif // ListOverscrollWidget2DBase_h
