/************************************************************************
*FILE: ListMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ListMessages_h)
#define ListMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Widgets/2D/List/generated/ListEnums.h>
#include <Widgets/2D/Slider/generated/SliderWidget2DTypes.h>
#include <Courier/Version.h>
#include <Courier/Visualization/ViewId.h>
#include <Courier/Visualization/ItemId.h>
#include <Widgets/2D/List/Data/ListDataProvider.h>
#include <Widgets/2D/List/Data/ListProviderEventInfo.h>
#include <Courier/Visualization/VisualizationTypes.h>
#include <Courier/Visualization/AnimationProperties.h>
#include <Courier/Visualization/CompositePath.h>
   struct ListMovementDetails
   {
      bool _pixelwise; //if the list movement animation should be performed pixelwise or not
      FeatStd::Int32 _delay; //the delay to start the list movement animation
      FeatStd::Int32 _duration; //the duration of the list movement animation
   };
// ------------------------------------------------------------------------
        /* Request is sent by the ListWidget to request data from the model. The model should react to this message and, 
        *  depending on the listId, it should prepare the data to send to the list. The model can request data to other 
        *  components when this message is received or it can do it at a different time and cache the received values so 
        *  that it will be able to fulfill the request.
        * Properties:
        *   listId:             the id of the list that sends the message. It will be used by the response message to identify the target list.
        *   startIndex:         the index of the first item that is requested.
        *   windowElementSize:  the number of requested elements.
        *   circular:           whether the requesting list is circular or not
        */
class ListDateProviderReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListDateProviderReqMsg, ::Courier::Message, 0xAD4004BE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ListDateProviderReqMsg(::Courier::UInt32 const & aListId, ::Courier::Int32 const & aStartIndex, ::Courier::UInt32 const & aWindowElementSize, bool const & aCircular, bool const & aCachedData);
        virtual ~ListDateProviderReqMsg();

        ::Courier::UInt32 const & GetListId() const { return mlistId; }
        void SetListId(::Courier::UInt32 const & value) { mlistId = value; }
              /**
               * The index of the first requested element. Even in case of circular scrolling, this is positive, as
               * the startIndex + windowElementSize can yield values greater than the list size, in which case the
               * indices should be treated as % virtualListSize
               */
        ::Courier::Int32 const & GetStartIndex() const { return mstartIndex; }
        void SetStartIndex(::Courier::Int32 const & value) { mstartIndex = value; }
              /**
               * The number of requested element. In case of circular scrolling, the startIndex + windowElementSize can
               * yield values greater than the list size, in which case the indices should be treated as
               * % virtualListSize
               */
        ::Courier::UInt32 const & GetWindowElementSize() const { return mwindowElementSize; }
        void SetWindowElementSize(::Courier::UInt32 const & value) { mwindowElementSize = value; }
        bool const & GetCircular() const { return mcircular; }
        void SetCircular(bool const & value) { mcircular = value; }
        bool const & GetCachedData() const { return mcachedData; }
        void SetCachedData(bool const & value) { mcachedData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListDateProviderReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListDateProviderReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListDateProviderReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListDateProviderReqMsgSubscriberList[];

        ::Courier::UInt32 mlistId;
        ::Courier::Int32 mstartIndex;
        ::Courier::UInt32 mwindowElementSize;
        bool mcircular;
        bool mcachedData;
};

// ------------------------------------------------------------------------
        /* This message is sent as a response to a ListDateProviderReqMsg. It should provide the list with a valid set
        * of data that it previously requested via a ListDateProviderReqMsg. The model posts this kind of message
        * after it builds a DataProvider containing the relevant data the list requested. See onListDateProviderReq
        * for a concrete example
        * Properties:
        *   ListDateProvider: a pointer to an instance of DataProvider that will be used by the list to display the 
        *     requested set of data.
        */
class ListDateProviderResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListDateProviderResMsg, ::Courier::Message, 0x4849194D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        ListDateProviderResMsg(tSharedPtrDataProvider const & aListDateProvider);
        virtual ~ListDateProviderResMsg();

        tSharedPtrDataProvider const & GetListDateProvider() const { return mListDateProvider; }
        void SetListDateProvider(tSharedPtrDataProvider const & value) { mListDateProvider = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListDateProviderResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListDateProviderResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListDateProviderResMsgModifiableMetadata;
        static const ::Courier::ComponentId mListDateProviderResMsgSubscriberList[];

        tSharedPtrDataProvider mListDateProvider;
};

// ------------------------------------------------------------------------
        /* Updates the entries of the previously sent ListDataProvider by replacing them.
        * It does not insert or remove entries.
        * Properties:
        *   UpdateInfo: contains the entries to be updated.
        */
class ListDataProviderUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListDataProviderUpdMsg, ::Courier::Message, 0xBD2DCA4B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        ListDataProviderUpdMsg(tSharedPtrDataProviderUpdater const & aUpdater);
        virtual ~ListDataProviderUpdMsg();

        tSharedPtrDataProviderUpdater const & GetUpdater() const { return mUpdater; }
        void SetUpdater(tSharedPtrDataProviderUpdater const & value) { mUpdater = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListDataProviderUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListDataProviderUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListDataProviderUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mListDataProviderUpdMsgSubscriberList[];

        tSharedPtrDataProviderUpdater mUpdater;
};

// ------------------------------------------------------------------------
        /* ListChangeMsg message is sent from the DM to the ListWidget to request movement for the list. This message
        *   can be sent from an external component as a reaction to up/down hardware button presses or to software
        *   buttons from a scrollbar for example.
        *  Properties:
        *   ListId: the id of the targeted list.
        *   Value: the amount of the move.
        *     ListChangeType: the type of the requested movement:
        *     ListChangeUp – moves the list backwards by Value items
        *     ListChangeDown – moves the list forward by Value items
        *     ListChangePageUp – moves the list backward by Value pages
        *     ListChangePageDown – moves the list forward by Value pages
        *     ListChangeSet – sets the position of the list to Value
        */
class ListChangeMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListChangeMsg, ::Courier::Message, 0x10B262BB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListChangeMsg();
        ListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource = ListChangeMsgSourceUnknown, bool const & aImmediatePositioning = false);
        virtual ~ListChangeMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ListChangeType const & GetListChangeType() const { return mListChangeType; }
        void SetListChangeType(ListChangeType const & value) { mListChangeType = value; }
        ::Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(::Courier::Int32 const & value) { mValue = value; }
        ListChangeMsgSourceType const & GetListChangeMsgSource() const { return mListChangeMsgSource; }
        void SetListChangeMsgSource(ListChangeMsgSourceType const & value) { mListChangeMsgSource = value; }
        bool const & GetImmediatePositioning() const { return mImmediatePositioning; }
        void SetImmediatePositioning(bool const & value) { mImmediatePositioning = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListChangeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListChangeMsgModifiableMetadata;
        static const ::Courier::ComponentId mListChangeMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ListChangeType mListChangeType;
        ::Courier::Int32 mValue;
        ListChangeMsgSourceType mListChangeMsgSource;
        bool mImmediatePositioning;
};

// ------------------------------------------------------------------------
        /* ListAnimatedChangeReqMsg message is sent from the DM to the ListWidget to request animated movement for the list as well as triggering an external
        *   synchronized animation. This message can be sent from an external component as a reaction to up/down hardware button presses or to software
        *   buttons from a scrollbar for example.
        *  Properties:
        *   ListId: the id of the targeted list.
        *   ListChangeType: the type of the requested movement:
        *     ListChangeUp – moves the list backwards by Value items
        *     ListChangeDown – moves the list forward by Value items
        *     ListChangePageUp – moves the list backward by Value pages
        *     ListChangePageDown – moves the list forward by Value pages
        *     ListChangeSet – sets the position of the list to Value
        *   Value: the amount of the move.
        *   MovementDetails
        *   ExternalAnimationAction: see AnimationReqMsg
        *   ViewId: see AnimationReqMsg
        *   CompositePath: see AnimationReqMsg
        *   AnimationId: see AnimationReqMsg
        *   AnimationProperties: see AnimationReqMsg
        *   ListChangeMsgSource: the source of the message
        *   ImmediatePositioning: use no list animation for going to the required position
        */
class ListAnimatedChangeReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListAnimatedChangeReqMsg, ::Courier::Message, 0x6B33F360);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListAnimatedChangeReqMsg();
        ListAnimatedChangeReqMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListMovementDetails const & aMovementDetails, Courier::AnimationAction::Enum const & aExternalAnimationAction = Courier::AnimationAction::Start, Courier::ViewId const & aViewId = Courier::ViewId(), Courier::CompositePath const & aCompositePath = Courier::CompositePath(), Courier::ItemId const & aAnimationId = Courier::ItemId(), Courier::AnimationProperties const & aAnimationProperties = Courier::AnimationProperties(), ListChangeMsgSourceType const & aListChangeMsgSource = ListChangeMsgSourceUnknown, bool const & aImmediatePositioning = false);
        virtual ~ListAnimatedChangeReqMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ListChangeType const & GetListChangeType() const { return mListChangeType; }
        void SetListChangeType(ListChangeType const & value) { mListChangeType = value; }
        ::Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(::Courier::Int32 const & value) { mValue = value; }
        ListMovementDetails const & GetMovementDetails() const { return mMovementDetails; }
        void SetMovementDetails(ListMovementDetails const & value) { mMovementDetails = value; }
        Courier::AnimationAction::Enum const & GetExternalAnimationAction() const { return mExternalAnimationAction; }
        void SetExternalAnimationAction(Courier::AnimationAction::Enum const & value) { mExternalAnimationAction = value; }
        Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(Courier::ItemId const & value) { mAnimationId = value; }
        Courier::AnimationProperties const & GetAnimationProperties() const { return mAnimationProperties; }
        void SetAnimationProperties(Courier::AnimationProperties const & value) { mAnimationProperties = value; }
        ListChangeMsgSourceType const & GetListChangeMsgSource() const { return mListChangeMsgSource; }
        void SetListChangeMsgSource(ListChangeMsgSourceType const & value) { mListChangeMsgSource = value; }
        bool const & GetImmediatePositioning() const { return mImmediatePositioning; }
        void SetImmediatePositioning(bool const & value) { mImmediatePositioning = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListAnimatedChangeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListAnimatedChangeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListAnimatedChangeReqMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ListChangeType mListChangeType;
        ::Courier::Int32 mValue;
        ListMovementDetails mMovementDetails;
        Courier::AnimationAction::Enum mExternalAnimationAction;
        Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        Courier::ItemId mAnimationId;
        Courier::AnimationProperties mAnimationProperties;
        ListChangeMsgSourceType mListChangeMsgSource;
        bool mImmediatePositioning;
};

// ------------------------------------------------------------------------
        /* Posted by the ListWidget if its PostListChanged property is true and the first visible index has
         *   changed. This message is posted to the model to inform other components that the displayed content
         *   of the list has changed., e.g FirstVisibleIndex
         *  Properties:
         *   listId:  the id of the list that sends the message.
         *   MovementStatus: how is the list moving (finished moving, item, page, set, scrolling, swiping)
         *   Circular: true if the list is circular scrollable; false otherwise
         *   StartIndex:[deprecated] the new value of the first visible index
         *   FirstVisibleIndex: the new value of the first visible index
         *   FirstItemFullyVisible: true if the first item is fully visible; false otherwise. If this is true, 
               it means that the FirstVisibleIndex represents also the start index of the list; if it's false,
               the start index should be FirstVisibleIndex+1
         *   MinIndex: the value of the minimum possible value for the first visible index
         *   MaxIndex: the value of the maximum possible value for the first visible index
        *   DataSequenceNumber: sequence number of the data used to prepare the visible items (see ListDataProvider.getSequenceNumber)
         */
class ListChangedUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListChangedUpdMsg, ::Courier::Message, 0xD08D3FF6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListChangedUpdMsg(::Courier::UInt32 const & aListId, ListMovementStatusType const & aMovementStatus, bool const & aCircular, ::Courier::UInt32 const & aStartIndex, ::Courier::UInt32 const & aFirstVisibleIndex, bool const & aFirstItemFullyVisible, ::Courier::UInt32 const & aMinIndex, ::Courier::UInt32 const & aMaxIndex, ::FeatStd::SizeType const & aDataSequenceNumber);
        virtual ~ListChangedUpdMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ListMovementStatusType const & GetMovementStatus() const { return mMovementStatus; }
        void SetMovementStatus(ListMovementStatusType const & value) { mMovementStatus = value; }
        bool const & GetCircular() const { return mCircular; }
        void SetCircular(bool const & value) { mCircular = value; }
        ::Courier::UInt32 const & GetStartIndex() const { return mStartIndex; }
        void SetStartIndex(::Courier::UInt32 const & value) { mStartIndex = value; }
        ::Courier::UInt32 const & GetFirstVisibleIndex() const { return mFirstVisibleIndex; }
        void SetFirstVisibleIndex(::Courier::UInt32 const & value) { mFirstVisibleIndex = value; }
        bool const & GetFirstItemFullyVisible() const { return mFirstItemFullyVisible; }
        void SetFirstItemFullyVisible(bool const & value) { mFirstItemFullyVisible = value; }
        ::Courier::UInt32 const & GetMinIndex() const { return mMinIndex; }
        void SetMinIndex(::Courier::UInt32 const & value) { mMinIndex = value; }
        ::Courier::UInt32 const & GetMaxIndex() const { return mMaxIndex; }
        void SetMaxIndex(::Courier::UInt32 const & value) { mMaxIndex = value; }
        ::FeatStd::SizeType const & GetDataSequenceNumber() const { return mDataSequenceNumber; }
        void SetDataSequenceNumber(::FeatStd::SizeType const & value) { mDataSequenceNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListChangedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListChangedUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mListChangedUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::UInt32 mListId;
        ListMovementStatusType mMovementStatus;
        bool mCircular;
        ::Courier::UInt32 mStartIndex;
        ::Courier::UInt32 mFirstVisibleIndex;
        bool mFirstItemFullyVisible;
        ::Courier::UInt32 mMinIndex;
        ::Courier::UInt32 mMaxIndex;
        ::FeatStd::SizeType mDataSequenceNumber;
};

// ------------------------------------------------------------------------
        /* Posted by the ListWidget when the movement triggered by touch gestures or a ListChangeMsg has finished
        *  Properties:
        *   listId:  the id of the list that sends the message.
        *   FirstVisibleIndex: the value of the first visible index
        */
class ListMovementFinishedUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListMovementFinishedUpdMsg, ::Courier::Message, 0xE3CC0835);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListMovementFinishedUpdMsg(::Courier::UInt32 const & aListId, ::Courier::UInt32 const & aFirstVisibleIndex);
        virtual ~ListMovementFinishedUpdMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::UInt32 const & GetFirstVisibleIndex() const { return mFirstVisibleIndex; }
        void SetFirstVisibleIndex(::Courier::UInt32 const & value) { mFirstVisibleIndex = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListMovementFinishedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListMovementFinishedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListMovementFinishedUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mListMovementFinishedUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::UInt32 mListId;
        ::Courier::UInt32 mFirstVisibleIndex;
};

// ------------------------------------------------------------------------
        /* Posted by the ListWidget normaly to the model each time for example its swiping state has changed.
        *   This message should be treated by other components that need to react to changes in the swiping
        *   state of the list. These components can be either items contained inside the list or other various
        *   external components.
        *  Properties:
        *   Status: the new swiping sate; possible states: ListIdle, ListTouched, ListFocused, ListScrolling, ListSwiping
        *   ListId: the id of the list that has changed its state
        *   View: the ViewId of the View containing the ListWidget instance
        *   List: the name of the ListWidget instance
        *   Direction: Prev, Next, Unavailable
        *   LockoutActive: on/off
        */
class ListStatusUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListStatusUpdMsg, ::Courier::Message, 0xE08C7B91);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListStatusUpdMsg(ListStatusType const & aStatus, ::Courier::UInt32 const & aListId, ::Courier::ViewId const & aView, ::Courier::Identifier const & aList, ListStatusDirectionType const & aDirection, bool const & aLockoutActive);
        virtual ~ListStatusUpdMsg();

        ListStatusType const & GetStatus() const { return mStatus; }
        void SetStatus(ListStatusType const & value) { mStatus = value; }
        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::ViewId const & GetView() const { return mView; }
        void SetView(::Courier::ViewId const & value) { mView = value; }
        ::Courier::Identifier const & GetList() const { return mList; }
        void SetList(::Courier::Identifier const & value) { mList = value; }
        ListStatusDirectionType const & GetDirection() const { return mDirection; }
        void SetDirection(ListStatusDirectionType const & value) { mDirection = value; }
        bool const & GetLockoutActive() const { return mLockoutActive; }
        void SetLockoutActive(bool const & value) { mLockoutActive = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListStatusUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListStatusUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mListStatusUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ListStatusType mStatus;
        ::Courier::UInt32 mListId;
        ::Courier::ViewId mView;
        ::Courier::Identifier mList;
        ListStatusDirectionType mDirection;
        bool mLockoutActive;
};

// ------------------------------------------------------------------------
        /* ListVisibiltyUpdMsg posted by the ListWidget to the model each time when the List comes in foreground
        *   This message should be treated by other components that need to react to changes, for example
        *   in the lockout component of the DM to lock the screen imediatly after the list becomes visible.
        *  Properties:
        *   VisibilityStatus: the new visibility sate; possible states: ListVisible, ListInVisible
        *   ListId: the id of the list that has changed its visibility
        *   View: the ViewId of the View containing the ListWidget instance
        *   List: the name of the ListWidget instance
        */
class ListVisibiltyUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListVisibiltyUpdMsg, ::Courier::Message, 0x9F4B01C4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListVisibiltyUpdMsg(ListStatusVisibilityType const & aVisibilityStatus, ::Courier::UInt32 const & aListId, ::Courier::ViewId const & aView, ::Courier::Identifier const & aList);
        virtual ~ListVisibiltyUpdMsg();

        ListStatusVisibilityType const & GetVisibilityStatus() const { return mVisibilityStatus; }
        void SetVisibilityStatus(ListStatusVisibilityType const & value) { mVisibilityStatus = value; }
        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::ViewId const & GetView() const { return mView; }
        void SetView(::Courier::ViewId const & value) { mView = value; }
        ::Courier::Identifier const & GetList() const { return mList; }
        void SetList(::Courier::Identifier const & value) { mList = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListVisibiltyUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListVisibiltyUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListVisibiltyUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mListVisibiltyUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ListStatusVisibilityType mVisibilityStatus;
        ::Courier::UInt32 mListId;
        ::Courier::ViewId mView;
        ::Courier::Identifier mList;
};

// ------------------------------------------------------------------------
        /* This message is currently not used. */
class ListFocusChangeReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListFocusChangeReqMsg, ::Courier::Message, 0x8E6464A8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListFocusChangeReqMsg(::Courier::UInt32 const & aListId, ::Courier::Int32 const & aSteps);
        virtual ~ListFocusChangeReqMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::Int32 const & GetSteps() const { return mSteps; }
        void SetSteps(::Courier::Int32 const & value) { mSteps = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListFocusChangeReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListFocusChangeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListFocusChangeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListFocusChangeReqMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ::Courier::Int32 mSteps;
};

// ------------------------------------------------------------------------
        /* SliderCurrentValueChangedMsg message is posted from ListWidget when the CurrentValue from SliderWidgetproperty 
        *   changes. External components should react to this message to possibly change their states based on the current
        *   value.
        * Properties:
        *   View: the ViewId of the View containing the DropDownListWidget instance
        *   Sender: the name of the DropDownListWidget instance
        *   CurrentValue: the current value of the slider
        *   TouchState: the touch state of the slider
        */
class SliderCurrentValueChangedMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SliderCurrentValueChangedMsg, ::Courier::Message, 0x99C3E559);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SliderCurrentValueChangedMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::Courier::Float const & aCurrentValue, SliderTouchState const & aTouchState);
        virtual ~SliderCurrentValueChangedMsg();

        ::Courier::ViewId const & GetView() const { return mView; }
        void SetView(::Courier::ViewId const & value) { mView = value; }
        ::Courier::Identifier const & GetSender() const { return mSender; }
        void SetSender(::Courier::Identifier const & value) { mSender = value; }
        ::Courier::Float const & GetCurrentValue() const { return mCurrentValue; }
        void SetCurrentValue(::Courier::Float const & value) { mCurrentValue = value; }
        SliderTouchState const & GetTouchState() const { return mTouchState; }
        void SetTouchState(SliderTouchState const & value) { mTouchState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SliderCurrentValueChangedMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSliderCurrentValueChangedMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSliderCurrentValueChangedMsgModifiableMetadata;
        static const ::Courier::ComponentId mSliderCurrentValueChangedMsgSubscriberList[];

        ::Courier::ViewId mView;
        ::Courier::Identifier mSender;
        ::Courier::Float mCurrentValue;
        SliderTouchState mTouchState;
};

// ------------------------------------------------------------------------
        /* LockoutMsg message has to be sent from the DM to the ListWidget to request for
        *   lockout (speed lockout feature)
        * Properties:
        *   ReceiverId: the id of the list that should be locked; Zero (0) means broadcast to all lists
        *   LockOut: The LockOutType decides how the list reacts on user input
        *     - LockOutNone: decatives any LockOut, normal operation of the list and scrollbar
        *     - LockOutPageWise: instead of pixelwise swipe on any user input pagewise scrolling is enabled
        *     - LockOutPageWisePrev: pagewise scrolling, but in prev direction locked (up/left)
        *     - LockOutPageWiseNext: pagewise scrolling, but in next direction locked (dn/right)
        *     - LockOutDirPrev: up/left operations are locked, down or right operations allowed
        *     - LockOutDirNext: up/left operations allowed, down or right operations are locked
        *     - LockOutComplete: everything is locked, list and scrollbar
        *     - LockOutFixMovement: pagewise scrolling is enabled but only after a specified percent of the viewport was scrolled, see also ListWidget property LockOutFixMovmentOffset
        *                           in case of coverflow the entries will be scrolled itemwise.
        */
class LockOutMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LockOutMsg, ::Courier::Message, 0xDF268781);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LockOutMsg(::Courier::UInt32 const & aReceiverId, LockOutType const & aLockOut);
        virtual ~LockOutMsg();

        ::Courier::UInt32 const & GetReceiverId() const { return mReceiverId; }
        void SetReceiverId(::Courier::UInt32 const & value) { mReceiverId = value; }
        LockOutType const & GetLockOut() const { return mLockOut; }
        void SetLockOut(LockOutType const & value) { mLockOut = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(LockOutMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLockOutMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLockOutMsgModifiableMetadata;
        static const ::Courier::ComponentId mLockOutMsgSubscriberList[];

        ::Courier::UInt32 mReceiverId;
        LockOutType mLockOut;
};

// ------------------------------------------------------------------------
        /* ListItemExpandReqMsg message is treated by the list widget in order to play an expand animation 
         * for the given item, in the requested direction.
         */
class ListItemExpandReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListItemExpandReqMsg, ::Courier::Message, 0x47E4222F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListItemExpandReqMsg(::Courier::UInt32 const & aListId, ::Courier::UInt32 const & aItemIndex, bool const & aForward);
        virtual ~ListItemExpandReqMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::UInt32 const & GetItemIndex() const { return mItemIndex; }
        void SetItemIndex(::Courier::UInt32 const & value) { mItemIndex = value; }
        bool const & GetForward() const { return mForward; }
        void SetForward(bool const & value) { mForward = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListItemExpandReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListItemExpandReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListItemExpandReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListItemExpandReqMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ::Courier::UInt32 mItemIndex;
        bool mForward;
};

// ------------------------------------------------------------------------
        /* ListItemExpandEndUpdMsg message is issued by the list widget to signal the end of a certain expand animation
         */
class ListItemExpandEndUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListItemExpandEndUpdMsg, ::Courier::Message, 0x7CA9CE2C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ListItemExpandEndUpdMsg(::Courier::UInt32 const & aListId, ::Courier::UInt32 const & aItemIntex, bool const & aForward);
        virtual ~ListItemExpandEndUpdMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::UInt32 const & GetItemIntex() const { return mItemIntex; }
        void SetItemIntex(::Courier::UInt32 const & value) { mItemIntex = value; }
        bool const & GetForward() const { return mForward; }
        void SetForward(bool const & value) { mForward = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListItemExpandEndUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListItemExpandEndUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListItemExpandEndUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mListItemExpandEndUpdMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ::Courier::UInt32 mItemIntex;
        bool mForward;
};

// ------------------------------------------------------------------------
        /* ListCustomAnimationReqMsg message is treated by the list widget in order to play a custom animation given by it's name.
         */
class ListCustomAnimationReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListCustomAnimationReqMsg, ::Courier::Message, 0x99229069);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListCustomAnimationReqMsg(::Courier::UInt32 const & aListId, ::Courier::ItemId const & aAnimationId, CustomListAnimationAction const & aAction);
        virtual ~ListCustomAnimationReqMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }
        CustomListAnimationAction const & GetAction() const { return mAction; }
        void SetAction(CustomListAnimationAction const & value) { mAction = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListCustomAnimationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListCustomAnimationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListCustomAnimationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListCustomAnimationReqMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ::Courier::ItemId mAnimationId;
        CustomListAnimationAction mAction;
};

// ------------------------------------------------------------------------
        /* ListCustomAnimationResqMsg message is posted in response to ListCustomAnimationReqMsg.
         * Success indicates if the processing was done or not
         */
class ListCustomAnimationResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListCustomAnimationResMsg, ::Courier::Message, 0xF4EEBBAE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListCustomAnimationResMsg(::Courier::UInt32 const & aListId, ::Courier::ItemId const & aAnimationId, CustomListAnimationAction const & aAction, bool const & aSuccess);
        virtual ~ListCustomAnimationResMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }
        CustomListAnimationAction const & GetAction() const { return mAction; }
        void SetAction(CustomListAnimationAction const & value) { mAction = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListCustomAnimationResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListCustomAnimationResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListCustomAnimationResMsgModifiableMetadata;
        static ::Courier::ComponentId mListCustomAnimationResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::UInt32 mListId;
        ::Courier::ItemId mAnimationId;
        CustomListAnimationAction mAction;
        bool mSuccess;
};

// ------------------------------------------------------------------------
        /* ListCustomAnimationIndMsg message is posted when the animation is finished.
         */
class ListCustomAnimationIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListCustomAnimationIndMsg, ::Courier::Message, 0x3F06F7DC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListCustomAnimationIndMsg(::Courier::UInt32 const & aListId, ::Courier::ItemId const & aAnimationId);
        virtual ~ListCustomAnimationIndMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListCustomAnimationIndMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListCustomAnimationIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListCustomAnimationIndMsgModifiableMetadata;
        static ::Courier::ComponentId mListCustomAnimationIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::UInt32 mListId;
        ::Courier::ItemId mAnimationId;
};

// ------------------------------------------------------------------------
        /* ListMorphReqMsg request sent to control and data model to trigger the morphing of the specified list into a state identified by Hint.
        */
class ListMorphReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListMorphReqMsg, ::Courier::Message, 0xCF53F4DD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ListMorphReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHint);
        virtual ~ListMorphReqMsg();

        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::UInt32 const & GetHint() const { return mHint; }
        void SetHint(Courier::UInt32 const & value) { mHint = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListMorphReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListMorphReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListMorphReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListMorphReqMsgSubscriberList[];

        Courier::UInt32 mListId;
        Courier::UInt32 mHint;
};

// ------------------------------------------------------------------------
        /* ListContentUpdMsg is send by the ListWidget each time new data is received by either
        * ListDataProviderResMsg or ListDataProviderUpdMsg
        * DataSequenceNumber: sequence number of the data used to prepare the visible items (see ListDataProvider.getSequenceNumber)
        */
class ListContentUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListContentUpdMsg, ::Courier::Message, 0xF250D17D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListContentUpdMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aFirstVisibleIndex, Courier::UInt32 const & aMaxFirstVisbleIndex, ::FeatStd::SizeType const & aDataSequenceNumber);
        virtual ~ListContentUpdMsg();

        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::UInt32 const & GetFirstVisibleIndex() const { return mFirstVisibleIndex; }
        void SetFirstVisibleIndex(Courier::UInt32 const & value) { mFirstVisibleIndex = value; }
        Courier::UInt32 const & GetMaxFirstVisbleIndex() const { return mMaxFirstVisbleIndex; }
        void SetMaxFirstVisbleIndex(Courier::UInt32 const & value) { mMaxFirstVisbleIndex = value; }
        ::FeatStd::SizeType const & GetDataSequenceNumber() const { return mDataSequenceNumber; }
        void SetDataSequenceNumber(::FeatStd::SizeType const & value) { mDataSequenceNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListContentUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListContentUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListContentUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mListContentUpdMsgSubscriberList[];

        Courier::UInt32 mListId;
        Courier::UInt32 mFirstVisibleIndex;
        Courier::UInt32 mMaxFirstVisbleIndex;
        ::FeatStd::SizeType mDataSequenceNumber;
};

// ------------------------------------------------------------------------
        /* ListVisualContentUpdateMsg is send by the ListWidget each frame
        */
class ListVisualContentUpdateMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListVisualContentUpdateMsg, ::Courier::Message, 0xBB0C6B0A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListVisualContentUpdateMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aFirstVisibleIndex, Courier::UInt32 const & aFirstCompleteVisibleIndex, Courier::UInt32 const & aNumberOfVisibleItems, Courier::UInt32 const & aNumberOfCompleteVisibleItems, Courier::UInt32 const & aConfiguredNumberOfItems);
        virtual ~ListVisualContentUpdateMsg();

        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::UInt32 const & GetFirstVisibleIndex() const { return mFirstVisibleIndex; }
        void SetFirstVisibleIndex(Courier::UInt32 const & value) { mFirstVisibleIndex = value; }
        Courier::UInt32 const & GetFirstCompleteVisibleIndex() const { return mFirstCompleteVisibleIndex; }
        void SetFirstCompleteVisibleIndex(Courier::UInt32 const & value) { mFirstCompleteVisibleIndex = value; }
        Courier::UInt32 const & GetNumberOfVisibleItems() const { return mNumberOfVisibleItems; }
        void SetNumberOfVisibleItems(Courier::UInt32 const & value) { mNumberOfVisibleItems = value; }
        Courier::UInt32 const & GetNumberOfCompleteVisibleItems() const { return mNumberOfCompleteVisibleItems; }
        void SetNumberOfCompleteVisibleItems(Courier::UInt32 const & value) { mNumberOfCompleteVisibleItems = value; }
        Courier::UInt32 const & GetConfiguredNumberOfItems() const { return mConfiguredNumberOfItems; }
        void SetConfiguredNumberOfItems(Courier::UInt32 const & value) { mConfiguredNumberOfItems = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListVisualContentUpdateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListVisualContentUpdateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListVisualContentUpdateMsgModifiableMetadata;
        static const ::Courier::ComponentId mListVisualContentUpdateMsgSubscriberList[];

        Courier::UInt32 mListId;
        Courier::UInt32 mFirstVisibleIndex;
        Courier::UInt32 mFirstCompleteVisibleIndex;
        Courier::UInt32 mNumberOfVisibleItems;
        Courier::UInt32 mNumberOfCompleteVisibleItems;
        Courier::UInt32 mConfiguredNumberOfItems;
};

// ------------------------------------------------------------------------
        /* ListCacheReqMsg request is treated by the list widget to explicitly cache the visual
        * item at the given index, after cloning, until explicitly requested to delete from cache
        */
class ListCacheReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListCacheReqMsg, ::Courier::Message, 0xC2E17898);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListCacheReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aIndex, bool const & aCache);
        virtual ~ListCacheReqMsg();

        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::UInt32 const & GetIndex() const { return mIndex; }
        void SetIndex(Courier::UInt32 const & value) { mIndex = value; }
        bool const & GetCache() const { return mCache; }
        void SetCache(bool const & value) { mCache = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListCacheReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListCacheReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListCacheReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListCacheReqMsgSubscriberList[];

        Courier::UInt32 mListId;
        Courier::UInt32 mIndex;
        bool mCache;
};

#endif // ListMessages_h
